<?xml version="1.0" encoding="ISO-8859-2"?>
<!-- edited with XMLSpy v2009 sp1 (http://www.altova.com) by andrejaoman (EMBRACE) -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output encoding="ISO-8859-2" method="html" omit-xml-declaration="yes"/>
	<xsl:template match="/">
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="ResultStatus"/>
	<xsl:template match="LabResult">
		<html>
			<head>
				<META http-equiv="Content-Type" content="text/html; charset=ISO-8859-2"/>
				<BASEFONT FACE="Arial Narrow" SIZE="2"/>
				<style>
					body{
						background-color: transparent;
					}
					.content{
						/*width: 1000px; Nap_21723 */
						margin-left: auto;
						margin-right: auto;
						padding: 10px;
					}
					.reports-table{
						border-collapse:collapse;
						font-size: 15px;	
						 border: 1px solid black;
						 width: 100%;
					}
					.reports-table td{
						padding: 5px;
						text-align: center;
					}

					.reports-table td.column-header{
						text-align: right;
						width: 120px;
					}

					.examination-title{
						padding-left: 90px;
					}
					.reports-table.table-more-4{
						width: 100%;
					}
					.reports-table.table-1{
						width: 15%;
					}
					.reports-table.table-2{
						width: 30%;
					}

					.reports-table.table-3{
						width: 45%;
					}

					.reports-table.table-4{
						width: 65%;
					}
					.reports-table .table-no-row{
						border:0;
						border-bottom: 1px solid black;
					}
					.r-highlight{
						background-color: #FFD1D1;
					}
					.s-highlight{
						background-color: #D9FFD1;
					}
					.i-highlight{
						background-color: #F9FF99;
					}
					.no-highlight{
						background-color: #ffffff;
					}



				</style>
			</head>
			<body>
				<div class="content">
					<xsl:call-template name="DisplayHeader"/>
					<hr COLOR="black" SIZE="1"/>
					<xsl:call-template name="DisplaySamples"/>
					<xsl:call-template name="DisplayTables"/>
					<xsl:call-template name="DisplayComment"/>
					<xsl:call-template name="DisplayCommentsForExamOrSet"/>
					<xsl:call-template name="DisplayFooter"/>
					<xsl:call-template name="DisplayCommentOnLabResult"/>
					<xsl:call-template name="DisplayPartialStatusComment"/>
					<xsl:call-template name="DisplayAcreditationStatus"/>
				</div>
			</body>
		</html>
	</xsl:template>
	<xsl:template name="DisplayHeader">
		<font SIZE="2" COLOR="Blue">
			<b>WEB IZVID</b>
		</font>
		<xsl:value-of select="Header/ZZVTitle" disable-output-escaping="yes"/>
		<hr COLOR="black" SIZE="1"/>
		<table BORDER="0" CELLSPACING="0" CELLPADDING="0" WIDTH="100%">
			<colgroup ALIGN="left" VALIGN="baseline" WIDTH="8%"/>
			<colgroup ALIGN="left" VALIGN="baseline" WIDTH="78%"/>
			<colgroup ALIGN="right" VALIGN="baseline" WIDTH="6%"/>
			<colgroup WIDTH="1%"/>
			<colgroup ALIGN="left" VALIGN="baseline" WIDTH="7%"/>
			<tr>
				<td>
					<font SIZE="2">Poiljatelj:</font>
				</td>
				<td>
					<font SIZE="2">
						<b>
							<xsl:value-of select="Header/SendOrg/Name"/>
						</b>
					</font>
				</td>
			</tr>
			<tr>
				<td/>
				<td>
					<font SIZE="2">
						<b>
							<xsl:value-of select="Header/SendDoc/DispName"/>
						</b>
					</font>
				</td>
				<xsl:if test="Header/SendOrg/Code = Header/RequestOrg/Code">
					<td>
						<font SIZE="2">Protokol:</font>
					</td>
					<td/>
					<td>
						<font SIZE="2">
							<b>
								<xsl:value-of select="Header/LabResultID/LabID"/>/<xsl:value-of select="Header/LabResultID/Protocol"/>
							</b>
						</font>
					</td>
				</xsl:if>
			</tr>
			<xsl:if test="Header/SendOrg/Code != Header/RequestOrg/Code">
				<tr>
					<td>
						<font SIZE="2">Naronik:</font>
					</td>
					<td>
						<font SIZE="2">
							<b>
								<xsl:value-of select="Header/RequestOrg/Name"/>
							</b>
						</font>
					</td>
				</tr>
				<tr>
					<td/>
					<td>
						<font SIZE="2">
							<b>
								<xsl:value-of select="Header/RequestDoc/DispName"/>
							</b>
						</font>
					</td>
					<td>
						<font SIZE="2">Protokol:</font>
					</td>
					<td/>
					<td>
						<font SIZE="2">
							<b>
								<xsl:value-of select="Header/LabResultID/LabID"/>/<xsl:value-of select="Header/LabResultID/Protocol"/>
							</b>
						</font>
					</td>
				</tr>
			</xsl:if>
		</table>
		<table BORDER="0" CELLSPACING="0" CELLPADDING="0" WIDTH="100%">
			<colgroup ALIGN="left" VALIGN="baseline" WIDTH="80%"/>
			<colgroup ALIGN="right" VALIGN="baseline" WIDTH="12%"/>
			<colgroup WIDTH="1%"/>
			<colgroup ALIGN="left" VALIGN="baseline" WIDTH="7%"/>
			<tr>
				<td>
					<font SIZE="2">Datum sprejema: <b>
							<xsl:call-template name="FormatDate">
								<xsl:with-param name="Date" select="Header/InputDate"/>
							</xsl:call-template>
							<xsl:choose>
								<xsl:when test="count(Header/InputHour) &gt; 0">&#160;<xsl:value-of select="Header/InputHour"/>
								</xsl:when>
								<xsl:otherwise> - Ura sprejema ni navedena</xsl:otherwise>
							</xsl:choose>
						</b>, datum izvida: <b>
							<xsl:call-template name="FormatDate">
								<xsl:with-param name="Date" select="Header/ResultDate"/>
							</xsl:call-template>
						</b>
					</font>
				</td>
				<td>
					<font SIZE="2">Status:</font>
				</td>
				<td/>
				<td>
					<font SIZE="2">
						<b>
							<xsl:choose>
								<xsl:when test="Header/MBLStatus = 'N'">Vneen</xsl:when>
								<xsl:when test="Header/MBLStatus = 'V'">V delu</xsl:when>
								<xsl:when test="Header/MBLStatus = 'D'">Delni</xsl:when>
								<xsl:when test="Header/MBLStatus = 'K'">Konni</xsl:when>
								<xsl:when test="Header/MBLStatus = 'O'">Dodatni</xsl:when>
							</xsl:choose>
						</b>
					</font>
				</td>
			</tr>
			<tr>
				<td/>
				<td>
					<font SIZE="2">Verzija:</font>
				</td>
				<td/>
				<td>
					<font SIZE="2">
						<b>
							<xsl:value-of select="Header/Version"/>.00</b>
					</font>
				</td>
			</tr>
			<!-- RV, 03.01.2018, Akt_106567 - PTest_2414 "Popravek za verzijo" se pokae samo takrat, ko je ta podatek. -->
			<xsl:if test="count(Header/CorrectedVersion) = 1">
			<tr>
				<td/>
				<td>
					<font SIZE="2">Popravek za verzijo:</font>
				</td>
				<td/>
				<td>
					<font SIZE="2">
						<b>
							<xsl:value-of select="Header/CorrectedVersion"/></b>
					</font>
				</td>
			</tr>
			</xsl:if>
			<tr>
				<td>
					<xsl:choose>
						<xsl:when test="count(Header/Pacient) &gt; 0">
							<xsl:call-template name="DisplayPacient">
								<xsl:with-param name="Pacient" select="Header/Pacient"/>
							</xsl:call-template>
						</xsl:when>
						<xsl:when test="count(Header/Animal) &gt; 0">
							<xsl:call-template name="DisplayAnimal">
								<xsl:with-param name="Animal" select="Header/Animal"/>
							</xsl:call-template>
						</xsl:when>
					</xsl:choose>
				</td>
				<xsl:if test="count(Header/LabResultPoints) &gt; 0">
					<td>
						<font SIZE="2">Toke za izvid:</font>
					</td>
					<td/>
					<td>
						<font SIZE="2">
							<b>
								<xsl:value-of select="Header/LabResultPoints"/>
							</b>
						</font>
					</td>
				</xsl:if>
			</tr>
			<xsl:call-template name="DisplayPregnancyWeeks"/>
		</table>
		<br/>
		<xsl:call-template name="DisplayTitle"/>
	</xsl:template>
	<xsl:template name="DisplayPacient">
		<xsl:param name="Pacient"/>
		<font SIZE="2">
			<b>
				<xsl:value-of select="$Pacient/DispName"/>
			</b>
			<xsl:if test="$Pacient/Addict = 'false'">, <xsl:call-template name="FormatDate">
					<xsl:with-param name="Date" select="$Pacient/BirthDate"/>
				</xsl:call-template>, <xsl:value-of select="$Pacient/Address"/> (<xsl:value-of select="normalize-space($Pacient/Code)"/>)</xsl:if>
		</font>
	</xsl:template>
	<xsl:template name="DisplayAnimal">
		<xsl:param name="Animal"/>
		<font SIZE="2">
			<b>
				<xsl:value-of select="$Animal/Name"/>
			</b>
			<xsl:if test="count($Animal/Breed) &gt; 0">, <xsl:value-of select="$Animal/Breed"/>
			</xsl:if>
			<xsl:if test="count($Animal/BirthDate) &gt; 0">, <xsl:call-template name="FormatDate">
					<xsl:with-param name="Date" select="$Animal/BirthDate"/>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="count($Animal/ChipNumber) &gt; 0">, (<xsl:value-of select="normalize-space($Animal/ChipNumber)"/>)</xsl:if>
		</font>
	</xsl:template>
	<xsl:template name="DisplayTitle">
		<div ALIGN="center">
			<font SIZE="5">
				<xsl:choose>
					<xsl:when test="count(Header/Title) &gt; 0">
						<xsl:value-of select="Header/Title"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="Header/MBLStatus = 'D'">Delni izvid</xsl:when>
							<xsl:when test="Header/MBLStatus = 'O'">Dodatni izvid</xsl:when>
							<xsl:otherwise>Izvid</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</font>
		</div>
	</xsl:template>
	<xsl:template name="DisplayPregnancyWeeks">
		<xsl:if test="count(Header/PregnancyWeeks) &gt; 0">
			<tr>
				<td>
					<font SIZE="2">Tedni nosenosti: <b>
							<xsl:value-of select="Header/PregnancyWeeks"/>
						</b>
					</font>
				</td>
			</tr>
		</xsl:if>
	</xsl:template>
	<xsl:template name="DisplaySamples">
		<xsl:for-each select="LabResultSamples/LabResultSample">
			<xsl:if test="Order &gt; 1">
				<br/>
			</xsl:if>
			<xsl:call-template name="DisplaySample"/>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="DisplaySample">
		<table BORDER="0" CELLSPACING="0" CELLPADDING="0" WIDTH="100%">
			<colgroup ALIGN="left" VALIGN="baseline" WIDTH="8%"/>
			<colgroup ALIGN="left" VALIGN="baseline" WIDTH="92%"/>
			<tr>
				<td>
					<font SIZE="2">
						<xsl:choose>
							<xsl:when test="count(../LabResultSample) = 1">Vzorec:</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="Order"/>. vzorec:</xsl:otherwise>
						</xsl:choose>
					</font>
				</td>
				<td>
					<font SIZE="2">
						<b>
							<xsl:value-of select="Sample/DispName"/>
						</b> (<xsl:choose>
							<xsl:when test="count(DateOfSeizure) &gt; 0">
								odvzeto <xsl:call-template name="FormatDate">
									<xsl:with-param name="Date" select="DateOfSeizure"/>
								</xsl:call-template>
								<xsl:choose>
									<xsl:when test="count(TimeOfSeizure) &gt; 0"> ob <xsl:value-of select="TimeOfSeizure"/>
									</xsl:when>
									<xsl:otherwise> - ura odvzema ni navedena</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>datum in ura odvzema nista navedena</xsl:otherwise>
						</xsl:choose>
						)</font>
				</td>
			</tr>
			<xsl:if test="count(SeizurePurpose) &gt; 0">
				<tr>
					<td/>
					<td>
						<font SIZE="2">Namen odvzema: <xsl:value-of select="SeizurePurpose"/>
						</font>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="count(Anomaly) &gt; 0">
				<tr>
					<td/>
					<td>
						<xsl:value-of select="Anomaly/DispText" disable-output-escaping="yes"/>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="count(Comment) &gt; 0">
				<tr>
					<td/>
					<td>
						<xsl:value-of select="Comment" disable-output-escaping="yes"/>
					</td>
				</tr>
			</xsl:if>
		</table>
		<xsl:for-each select="LabResultExaminationSets/LabResultExaminationSet">
			<xsl:call-template name="DisplayLabResultExaminationSet"/>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="DisplayLabResultExaminationSet">
		<xsl:if test="count(DispText) &gt; 0">
			<br/>
			<table BORDER="0" CELLSPACING="0" CELLPADDING="0" WIDTH="100%">
				<colgroup ALIGN="left" VALIGN="baseline" WIDTH="4%"/>
				<colgroup ALIGN="left" VALIGN="baseline" WIDTH="96%"/>
				<tr>
					<td/>
					<td>
						<xsl:value-of select="DispText" disable-output-escaping="yes"/>
					</td>
				</tr>
			</table>
		</xsl:if>
		<xsl:for-each select="descendant::LabResultExamination">
			<xsl:call-template name="DisplayLabResultExamination"/>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="DisplayLabResultExamination">
			<xsl:if test="count(AddDispText) &gt; 0">
			<br/>
			<table BORDER="0" CELLSPACING="0" CELLPADDING="0" WIDTH="100%">
				<colgroup ALIGN="left" VALIGN="baseline" WIDTH="8%"/>
				<colgroup ALIGN="left" VALIGN="baseline" WIDTH="92%"/>
				<tr>
				  <td/>
					<td>
					  <font SIZE="2"><b>
						<xsl:value-of select="AddDispText" disable-output-escaping="yes"/>
					  </b></font>
					</td>
				</tr>
			</table>
		</xsl:if>
		<xsl:variable name="FirstCol">
			<xsl:choose>
				<xsl:when test="(Examination/Code = 10101) or (Examination/Code = 10102) or (Examination/Code = 10103)">
					<colgroup ALIGN="right" VALIGN="baseline" WIDTH="{Level*4+17}%"/>
				</xsl:when>
				<xsl:otherwise>
					<colgroup ALIGN="right" VALIGN="baseline" WIDTH="{Level*4+8}%"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="SecondCol">
			<xsl:if test="(Examination/Code = 10101) or (Examination/Code = 10102) or (Examination/Code = 10103)">
				<colgroup WIDTH="1%"/>
			</xsl:if>
		</xsl:variable>
		<xsl:variable name="ThirdCol">
			<xsl:choose>
				<xsl:when test="(Examination/Code = 10101) or (Examination/Code = 10102) or (Examination/Code = 10103)">
					<colgroup ALIGN="left" VALIGN="baseline" WIDTH="{99-Level*4+17}%"/>
				</xsl:when>
				<xsl:otherwise>
					<colgroup ALIGN="left" VALIGN="baseline" WIDTH="{99-Level*4+8}%"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="SecondCell">
			<xsl:if test="(Examination/Code = 10101) or (Examination/Code = 10102) or (Examination/Code = 10103)">
				<td/>
			</xsl:if>
		</xsl:variable>
		<xsl:if test="(count(../DispText) = 0) and (count(AddDispText)=0) and (Level = 0)">
			<br/>
		</xsl:if>

		<table BORDER="0" CELLSPACING="0" CELLPADDING="0" WIDTH="100%">
			<xsl:copy-of select="$FirstCol"/>
			<xsl:copy-of select="$SecondCol"/>
			<xsl:copy-of select="$ThirdCol"/>
			<tr>
				<xsl:choose>
					<xsl:when test="count(Result/AddDispText) &gt; 0">
						<td>
							<font SIZE="2" class="examination-title">
								<xsl:value-of select="Result/AddDispText"/>
							</font>
						</td>
					</xsl:when>
					<xsl:otherwise>
						<td/>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:copy-of select="$SecondCell"/>
				<td>
					<table>
						<tbody>
							<tr>
								<td><xsl:value-of select="Result/DispText" disable-output-escaping="yes"/></td><td><xsl:value-of select="Result/MeaningCodes"/></td>
							</tr>
						</tbody>
					</table>
				</td>
			</tr>
			<xsl:call-template name="DisplayTables"/>		
			<xsl:if test="count(Result/Meaning) &gt; 0">
				<tr>
					<td/>
					<xsl:copy-of select="$SecondCell"/>
					<td>
						<xsl:value-of select="Result/Meaning" disable-output-escaping="yes"/>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="count(Result/AdditionalMeaning1) &gt; 0">
				<tr>
					<td/>
					<xsl:copy-of select="$SecondCell"/>
					<td>
						<xsl:value-of select="Result/AdditionalMeaning1" disable-output-escaping="yes"/>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="count(Result/AdditionalMeaning2) &gt; 0">
				<tr>
					<td/>
					<xsl:copy-of select="$SecondCell"/>
					<td>
						<xsl:value-of select="Result/AdditionalMeaning2" disable-output-escaping="yes"/>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="count(Result/IsolateText) &gt; 0">
				<tr>
					<td/>
					<xsl:copy-of select="$SecondCell"/>
					<td>
						<xsl:value-of select="Result/IsolateText" disable-output-escaping="yes"/>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="count(Result/Comment) &gt; 0">
				<tr>
					<td/>
					<xsl:copy-of select="$SecondCell"/>
					<td>
						<xsl:value-of select="Result/Comment" disable-output-escaping="yes"/>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="count(Result/Legend) &gt; 0">
				<tr>
					<td/>
					<xsl:copy-of select="$SecondCell"/>
					<td>
						<font SIZE="0">
							<br/>
							<xsl:value-of select="Result/Legend" disable-output-escaping="yes"/>
							<br/>
						</font>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>
	<xsl:template name="DisplayTables">
		<xsl:for-each select="Tables/Table">
			<xsl:for-each select="Data/TableSegment">
				<br/>
				<xsl:variable name="css-class">
				    <xsl:choose>
				      <xsl:when test="count(Row[1]/Cell) = 1">table-1</xsl:when>
				      <xsl:when test="count(Row[1]/Cell) = 2">table-2</xsl:when>
				      <xsl:when test="count(Row[1]/Cell) = 3">table-3</xsl:when>
				      <xsl:when test="count(Row[1]/Cell) = 4">table-4</xsl:when>

				      <xsl:otherwise>table-more-4</xsl:otherwise>
				    </xsl:choose>
				  </xsl:variable>
		

				<table class="reports-table {$css-class}" FRAME="void" RULES="all" BORDERCOLOR="black">
					<xsl:for-each select="Row[position() = 1]">
						<tr>
							<xsl:for-each select="Cell">
								<td BGCOLOR="LightYellow">
									<xsl:value-of select="."/>
								</td>
							</xsl:for-each>
						</tr>
					</xsl:for-each>
					<xsl:for-each select="Row[position() != 1]">
						<tr>
							<xsl:for-each select="Cell">
								<xsl:choose>
									<xsl:when test="position() = 1">
										<td BGCOLOR="LightYellow" class="column-header">
											<xsl:value-of select="."/>
										</td>
									</xsl:when>
									<!-- RV, Akt_106567: Dodan fontcolor -->
									<xsl:when test="@fontcolor">
										<!--xls:if test="@fontstyle"> FONTSTYLE </xls:if-->
										<td><span style="{./@fontstyle}">
											<font color="{@fontcolor}">
												<xsl:value-of select="."/>
											</font> </span>
										<!-- xls:if test=contains(./@fontstyle,"B")>A</xls:if-->
	   								
										</td>
									</xsl:when>
									<!--- xsl:when test="@contains(@fontstyle,'B')"></B></xls:when-->
									<xsl:otherwise>
										<xsl:choose>
											<xsl:when test=". != ''">
											<xsl:variable name="css-class-color">
											    <xsl:choose>
											      <xsl:when test=". = 'R'">r-highlight</xsl:when>
											      <xsl:when test=". = 'S'">s-highlight</xsl:when>
											      <xsl:when test=". = 'I'">i-highlight</xsl:when>
											      <xsl:when test="substring-before(., '*') = 'R'">r-highlight</xsl:when>
											      <xsl:when test="substring-before(., '*') = 'S'">s-highlight</xsl:when>
											      <xsl:when test="substring-before(., '*') = 'I'">i-highlight</xsl:when>

											      <xsl:otherwise>no-highlight</xsl:otherwise>
											    </xsl:choose>
											  </xsl:variable>
												<xsl:choose>
													<xsl:when test="contains(. , '*')">
														<td class="{$css-class-color}" style="font-weight:bold;">
															<xsl:value-of select="."/>
														</td>
													 </xsl:when>
													 <xsl:otherwise>
														<td class="{$css-class-color}">
															<xsl:value-of select="."/>
														</td>
													 </xsl:otherwise>
											   </xsl:choose>												


												
											</xsl:when>
											<xsl:otherwise>
												<td/> 
											</xsl:otherwise>
										</xsl:choose>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:for-each>
						</tr>
					</xsl:for-each>
				</table>
			</xsl:for-each>
			<xsl:call-template name="DisplayTableLegend"/>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="DisplayTableLegend">

		<xsl:if test="count(Legend) &gt; 0">
			<xsl:variable name="ColGroup">
				<colgroup ALIGN="left" VALIGN="baseline" WIDTH="25%" SPAN="4"/>
			</xsl:variable>
			<br/>
			<font SIZE="1">
				<i>Legenda za tabelo:</i>
			</font>
			<hr COLOR="black" SIZE="1"/>
			<table BORDER="0" CELLSPACING="0" CELLPADDING="0" WIDTH="100%">
				<xsl:copy-of select="$ColGroup"/>
				<xsl:for-each select="Legend/FirstSegment/Row">
					<tr>
						<xsl:for-each select="Cell">
							<td>
								<font SIZE="1">
									<xsl:value-of select="."/>
								</font>
							</td>
						</xsl:for-each>
					</tr>
				</xsl:for-each>
				<tr>
					<td>
						<font SIZE="0">
							<br/>
						</font>
					</td>
				</tr>
				<xsl:for-each select="Legend/SecondSegment/Row">
					<tr>
						<xsl:for-each select="Cell">
							<td>
								<font SIZE="1">
									<xsl:value-of select="."/>
								</font>
							</td>
						</xsl:for-each>
					</tr>
				</xsl:for-each>
				<tr>
					<td>
						<font SIZE="0">
							<br/>
						</font>
					</td>
				</tr>
				<xsl:for-each select="Legend/ThirdSegment/Row">
					<tr>
						<xsl:for-each select="Cell">
							<xsl:choose>
								<xsl:when test="contains(. , '*')">
									<td style="font-weight:bold;">
										<font SIZE="1">									
											<xsl:value-of select="."/>
										</font>												
									</td>
								 </xsl:when>
								 <xsl:otherwise>
									<td>
										<font SIZE="1">										
											<xsl:value-of select="."/>
										</font>													
									</td>
								 </xsl:otherwise>
							 </xsl:choose>								
						</xsl:for-each>
					</tr>
				</xsl:for-each>
			</table>
			<hr COLOR="black" SIZE="1"/>
		</xsl:if>
		<xsl:call-template name="DisplayTableComment"/>
	</xsl:template>
	<xsl:template name="DisplayTableComment">
		<xsl:for-each select="Comments/Set">
			<font SIZE="1">
				<b>
					<i>
						<xsl:value-of select="Title"/>
					</i>
				</b>
			</font>
			<xsl:for-each select="Comment">
				<xsl:value-of select="." disable-output-escaping="yes"/>
			</xsl:for-each>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="DisplayComment">
		<xsl:for-each select="Comment">
			<br/>
			<hr COLOR="black" SIZE="1"/>
			<xsl:value-of select="." disable-output-escaping="yes"/>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="DisplayCommentsForExamOrSet">
		<xsl:for-each select="CommentsForExamOrSet">
			<xsl:for-each select="CommentForExamOrSet">
				<xsl:value-of select="." disable-output-escaping="yes"/>
			</xsl:for-each>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="DisplayCommentOnLabResult">
		<xsl:for-each select="CommentOnLabResult">
			<br/>
			<hr COLOR="black" SIZE="1"/>
			<xsl:value-of select="." disable-output-escaping="yes"/>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="DisplayPartialStatusComment">
		<xsl:for-each select="PartialStatusComment">
			<br/>
			<hr COLOR="black" SIZE="1"/>
			<xsl:value-of select="." disable-output-escaping="yes"/>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="DisplayFooter">
		<br/>
		<br/>
		<hr COLOR="black" SIZE="1"/>
		<table BORDER="0" CELLSPACING="0" CELLPADDING="0" WIDTH="100%">
			<colgroup ALIGN="left" VALIGN="baseline" WIDTH="70%" SPAN="1"/>
			<colgroup ALIGN="left" VALIGN="baseline" WIDTH="30%" SPAN="1"/>
			<tr>
				<td>
					<xsl:if test="count(Footer/Performer) &gt; 0">
						<xsl:choose>
							<xsl:when test="count(Footer/Performer/Label) &gt; 0">
								<xsl:call-template name="DisplaySignature">
									<xsl:with-param name="Label" select="Footer/Performer/Label"/>
									<xsl:with-param name="Text" select="Footer/Performer/Text"/>
								</xsl:call-template>
							</xsl:when>
							<xsl:otherwise>
								<xsl:call-template name="DisplaySignature">
									<xsl:with-param name="Label" select="'Pregled opravil:'"/>
									<xsl:with-param name="Text" select="Footer/Performer"/>
								</xsl:call-template>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:if>
				</td>
				<td>
					<xsl:if test="count(Footer/PersonInCharge) &gt; 0">
						<xsl:choose>
							<xsl:when test="count(Footer/PersonInCharge/Label) &gt; 0">
								<xsl:call-template name="DisplaySignature">
									<xsl:with-param name="Label" select="Footer/PersonInCharge/Label"/>
									<xsl:with-param name="Text" select="Footer/PersonInCharge/Text"/>
								</xsl:call-template>
							</xsl:when>
							<xsl:otherwise>
								<xsl:call-template name="DisplaySignature">
									<xsl:with-param name="Label" select="''"/>
									<xsl:with-param name="Text" select="Footer/PersonInCharge"/>
								</xsl:call-template>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:if>
				</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="DisplaySignature">
		<xsl:param name="Label"/>
		<xsl:param name="Text"/>
		<xsl:if test="$Label != ''">
			<font SIZE="2">
				<xsl:value-of select="$Label"/>
			</font>
		</xsl:if>
		<xsl:value-of select="$Text" disable-output-escaping="yes"/>
	</xsl:template>
	<xsl:template name="FormatDate">
		<xsl:param name="Date"/>
		<xsl:value-of select="substring($Date,9,2)"/>.<xsl:value-of select="substring($Date,6,2)"/>.<xsl:value-of select="substring($Date,1,4)"/>
	</xsl:template>
	<xsl:template name="DisplayAcreditationStatus">
            <hr COLOR="black" SIZE="1"/>
	       <font SIZE="2">
		     <b>
	                <xsl:choose>
                           <xsl:when test="Header/AcreditationStatus = 'M'">Rezultati oznaeni z # se nanaajo na neakreditirano dejavnost.</xsl:when>
                        </xsl:choose>
		      </b>
	       </font>
	</xsl:template>
</xsl:stylesheet>





