<?xml version="1.0" encoding="Windows-1250"?>
<!DOCTYPE xsl:stylesheet [
	<!ENTITY nbsp "&#160;">
]>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:template name="SpecCommon">
		<xsl:param name="Type"/>
		<xsl:param name="TxtFile"/>
		<xsl:for-each select="InvSpecs/InvSpec">
			<xsl:apply-templates select="InvHeader" mode="SpecCommonHeader">
				<xsl:with-param name="Type" select="InvProperty/TypeName"/>
				<xsl:with-param name="TxtFile" select="$TxtFile"/>
			</xsl:apply-templates>
			<xsl:apply-templates select="InvBody" mode="SpecBody">
				<xsl:with-param name="Type" select="InvProperty/TypeName"/>
				<xsl:with-param name="TxtFile" select="$TxtFile"/>
			</xsl:apply-templates>
			<xsl:if test="position()!=last()">
				<br class="pBreak"/>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	<xsl:template match="InvHeader" mode="SpecCommonHeader">
		<xsl:param name="Type"/>
		<xsl:param name="TxtFile"/>
		<table width="650" border="0" cellspacing="0" cellpadding="0" style="font-size: 11px;">
			<td width="350">
				<table width="350" border="0" cellspacing="0" cellpadding="0" style="font-size: 11px;">
					<tr>
						<td width="350">
							<xsl:value-of select="Performer/Organization/ID"/>&nbsp;
							<xsl:value-of select="Performer/Organization/Name"/>
						</td>
					</tr>
					<xsl:if test="Performer/Organization/AdditionName != ''">
						<tr>
							<td>
								<xsl:value-of select="Performer/Organization/AdditionName"/>
							</td>
						</tr>
					</xsl:if>
					<tr>
						<td>&nbsp;</td>
					</tr>
					<tr>
						<td>
							<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BH1_2_1"/>&nbsp;
							<xsl:if test="($Type='01') or ($Type='02') or ($Type='03') or ($Type='05') or ($Type='06')">
								<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BH1_3_1"/>
							</xsl:if>
							<xsl:if test="($Type='04') or ($Type='11') or ($Type='15') or ($Type='16') or ($Type='17')">
								<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BH1_3_2"/>
							</xsl:if>
							<xsl:if test="($Type='09') or ($Type='10') or ($Type='12') or ($Type='19') or ($Type='23') or ($Type='25') or ($Type='P01') or ($Type='08') or ($Type='26') or ($Type='S01') or ($Type='VOZ') or ($Type='DDDDD') or ($Type='BBBBB') or ($Type='41') or ($Type='45') or ($Type='47') or ($Type='ER')"><!--Akt_101021-->
								<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BH1_3_3"/>
							</xsl:if>
							&nbsp;<xsl:value-of select="Document/ID"/>
						</td>
					</tr>
					<tr>
						<td>Vrsta zavarovanja:
							<xsl:if test="Document/InsuranceType = '1'">Obvezno zavarovanje</xsl:if>
							<xsl:if test="Document/InsuranceType = '2'">Prostovoljno zavarovanje</xsl:if>
						</td>
					</tr>
					<tr>
						<td>&nbsp;</td>
					</tr>
					<tr>
						<td>
							<xsl:value-of select="Payer/Organization/Name"/>
						</td>
					</tr>
					<tr>
						<td>Izpostava <xsl:value-of select="Payer/Destination/Name"/>
						</td>
					</tr>
					<tr>
						<td>&nbsp;</td>
					</tr>
					<tr>
						<td>Obdobje:&nbsp;
							<xsl:call-template name="FormatDate">
								<xsl:with-param name="Date" select="Document/InvDateFrom"/>
							</xsl:call-template>&nbsp;-&nbsp; 
							<xsl:call-template name="FormatDate">
								<xsl:with-param name="Date" select="Document/InvDateTo"/>
							</xsl:call-template>
						</td>
					</tr>
					<tr>
						<td>&nbsp;</td>
					</tr>
					<xsl:if test="../InvBody/BodyProperty/ReasonTrial/ID != ''">
						<tr>
							<td>Razlog obravnave:&nbsp;
								<xsl:value-of select="../InvBody/BodyProperty/ReasonTrial/ID"/>&nbsp;
								<xsl:value-of select="../InvBody/BodyProperty/ReasonTrial/Name"/>
							</td>
						</tr>
					</xsl:if>
					<tr>
						<td>ifra kriterija za priloge: <xsl:value-of select="../InvBody/BodyProperty/IDCriterionKZZ"/>
						</td>
					</tr>
				</table>
			</td>
			<td width="300">
				<table width="300" border="0" cellspacing="0" cellpadding="0" style="font-size: 11px;">
					<tr>
						<td>KRITERIJI:</td>
					</tr>
					<xsl:for-each select="../../../InvProperty/SpecHeader">
						<xsl:if test="ObdobjeOd and ObdobjeDo">
							<tr>
								<td>Obdobje:</td>
								<td>
									<xsl:value-of select="ObdobjeOd"/>&nbsp;-&nbsp;
									<xsl:value-of select="ObdobjeDo"/>
								</td>
							</tr>
						</xsl:if>
						<xsl:if test="DocumentFrom and DocumentTo">
							<tr>
								<td>Dokumenti:</td>
								<td>
									<xsl:value-of select="DocumentFrom"/>&nbsp;-&nbsp;
									<xsl:value-of select="DocumentTo"/>
								</td>
							</tr>
						</xsl:if>
						<xsl:if test="EnotaIzv">
							<tr>
								<td>Enota izvajanja:</td>
								<td>
									<xsl:value-of select="EnotaIzv"/>
								</td>
							</tr>
						</xsl:if>
						<xsl:if test="ZdravnikIzv">
							<tr>
								<td>Zdravnik izvajalec:</td>
								<td>
									<xsl:value-of select="ZdravnikIzv"/>
								</td>
							</tr>
						</xsl:if>
						<xsl:if test="EnotaNar">
							<tr>
								<td>Enota naroanja:</td>
								<td>
									<xsl:value-of select="EnotaNar"/>
								</td>
							</tr>
						</xsl:if>
						<xsl:if test="ZdravnikNar">
							<tr>
								<td>Zdravnik naronik:</td>
								<td>
									<xsl:value-of select="ZdravnikNar"/>
								</td>
							</tr>
						</xsl:if>
						<xsl:if test="Grupa">
							<tr>
								<td>Grupa planika:</td>
								<td>
									<xsl:value-of select="Grupa"/>
								</td>
							</tr>
						</xsl:if>
						<xsl:if test="Payer">
							<tr>
								<td>Planik:</td>
								<td>
									<xsl:value-of select="Payer"/>
								</td>
							</tr>
						</xsl:if>
						<xsl:if test="CategorysCode">
							<tr>
								<td>Kategorija:</td>
								<td>
									<xsl:value-of select="CategorysCode"/>
								</td>
							</tr>
						</xsl:if>
						<xsl:if test="ReasonTrial">
							<tr>
								<td>Razlog obravnave:</td>
								<td>
									<xsl:value-of select="ReasonTrial"/>
								</td>
							</tr>
						</xsl:if>
						<xsl:if test="PaymentMethod">
							<tr>
								<td>Nain plaila:</td>
								<td>
									<xsl:value-of select="PaymentMethod"/>
								</td>
							</tr>
						</xsl:if>
						<xsl:if test="GrupaStoritev">
							<tr>
								<td>Grupa storitev:</td>
								<td>
									<xsl:value-of select="GrupaStoritev"/>
								</td>
							</tr>
						</xsl:if>
						<xsl:if test="NHCCode">
							<tr>
								<td>Storitev - koda:</td>
								<td>
									<xsl:value-of select="NHCCode"/>
								</td>
							</tr>
						</xsl:if>
						<xsl:if test="Patient">
							<tr>
								<td>Pacient:</td>
								<td>
									<xsl:value-of select="Patient"/>
								</td>
							</tr>
						</xsl:if>
						<xsl:if test="KZZId">
							<tr>
								<td>KZZ tevilka:</td>
								<td>
									<xsl:value-of select="KZZId"/>
								</td>
							</tr>
						</xsl:if>
						<xsl:if test="KontoSpec">
							<tr>
								<td>VZD:</td>
								<td>
									<xsl:value-of select="KontoSpec"/>
								</td>
							</tr>
						</xsl:if>
						<xsl:if test="EMSO">
							<tr>
								<td>EMO:</td>
								<td>
									<xsl:value-of select="EMSO"/>
								</td>
							</tr>
						</xsl:if>
						<xsl:if test="Sex">
							<tr>
								<td>Spol:</td>
								<td>
									<xsl:value-of select="Sex"/>
								</td>
							</tr>
						</xsl:if>
						<xsl:if test="AdditionalInsurancePolicy">
							<tr>
								<td>Polica prost. zavar.:</td>
								<td>
									<xsl:value-of select="AdditionalInsurancePolicy"/>
								</td>
							</tr>
						</xsl:if>
						<xsl:if test="IDCriterionKZZ">
							<tr>
								<td>ifra kriterija za priloge:</td>
								<td>
									<xsl:value-of select="IDCriterionKZZ"/>
								</td>
							</tr>
						</xsl:if>
						<xsl:if test="InvPart">
							<tr>
								<td>Plailni del:</td>
								<td>
									<xsl:value-of select="InvPart"/>
								</td>
							</tr>
						</xsl:if>
						<xsl:if test="SamoplacniskiDelez='true'">
							<tr>
								<td colspan="2">Pacienti s samoplanikim osnovnim deleem</td>
							</tr>
						</xsl:if>
					</xsl:for-each>
				</table>
			</td>
		</table>
	</xsl:template>
</xsl:stylesheet>
