<?xml version="1.0" encoding="Windows-1250"?>
<!DOCTYPE xsl:stylesheet [
	<!ENTITY nbsp "&#160;">
]>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:template match="InvFooter">
		<xsl:param name="Type"/>
		<xsl:param name="TxtFile"/>
		<table width="650" border="0" cellspacing="0" cellpadding="0" style="font-size: 10px;">
			<tr>
				<td colspan="2">&nbsp;</td>
			</tr>
			<xsl:for-each select="AdditionalDescriptionList/Value">
				<tr>
					<td colspan="2">
						<xsl:value-of select="."/>
					</td>
				</tr>
			</xsl:for-each>
			<tr>
				<td colspan="2">&nbsp;</td>
			</tr>
			<xsl:if test="TextProvsion != ''">
				<tr>
					<td colspan="2">
						<xsl:value-of select="TextProvsion"/>
					</td>
				</tr>
			</xsl:if>
			<!--<xsl:if test="../InvProperty/Language = 'SLO'">-->
			<xsl:if test="not($Type='04')">
				<tr>
					<td colspan="2">
						<xsl:value-of select="Description"/>
					</td>
				</tr>
			</xsl:if>
			<!--</xsl:if>-->
			<tr>
				<td colspan="2">&nbsp;</td>
			</tr>
			<tr>
				<td colspan="2">
					<xsl:if test="not(Text= '')">
						<xsl:value-of select="Text"/>
					</xsl:if>
				</td>
			</tr>
			<tr>
				<td colspan="2">&nbsp;</td>
			</tr>
			<tr>
				<td width="350" align="left">
					<xsl:value-of select="SignHeader"/>
				</td>
				<td width="300" align="left">
					<xsl:value-of select="SignManHeader"/>
				</td>
			</tr>
			<tr>
				<td width="350" align="left">
					<xsl:value-of select="Sign"/>
				</td>
				<td width="300" align="left">
					<xsl:value-of select="SignMan"/>
				</td>
			</tr>
			<tr>
				<td colspan="2">&nbsp;</td>
			</tr>
		</table>
		<!--//ML, 28.10.2016, Akt_106471: Dopolnitev 'noge' rauna z zakonsko obveznimi podatki-->
		<xsl:if test="FooterText">
			<table width="650" border="0" cellspacing="0" cellpadding="0" style="font-size: 8px;">
				<tr>
					<td colspan="4">&nbsp;</td>
				</tr>
				<tr>
					<td colspan="4">&nbsp;</td>
				</tr>
				<xsl:if test="FooterText/QRCodeUPN">				
					<tr>
						<td colspan="4">
							<img src="data:image/jpg;base64,{FooterText/QRCodeUPN}"/>
						</td>
					</tr>						
				</xsl:if>
				<xsl:choose>
					<xsl:when test="FooterText/Image">				
						<tr>
							<td colspan="4">
								<img src="{FooterText/Image}"/>
							</td>
						</tr>						
					</xsl:when>
					<xsl:otherwise>
						<tr>
							<xsl:choose>
								<xsl:when test="FooterText/Align = 'Left'">
									<td width="650" align="left">
										<xsl:for-each select="FooterText/Line">
											<xsl:value-of select="."/>
											<br/>
										</xsl:for-each>
									</td>
								</xsl:when>
								<xsl:when test="FooterText/Align = 'Right'">
									<td width="650" align="right">
										<xsl:for-each select="FooterText/Line">
											<xsl:value-of select="."/>
											<br/>
										</xsl:for-each>
									</td>
								</xsl:when>
								<xsl:otherwise>
									<td width="650" align="center">
										<xsl:for-each select="FooterText/Line">
											<xsl:value-of select="."/>
											<br/>
										</xsl:for-each>
									</td>
								</xsl:otherwise>
							</xsl:choose>
						</tr>
					</xsl:otherwise>
				</xsl:choose>
			</table>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>
