<?xml version="1.0" encoding="Windows-1250"?>
<!DOCTYPE xsl:stylesheet [
	<!ENTITY nbsp "&#160;">
]>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:template match="InvHeader" mode="DocCountryHeader">
		<xsl:param name="Type"/>
		<xsl:param name="TxtFile"/>
		<table width="650" border="0" cellspacing="0" cellpadding="0" style="font-size: 11px;">
			<tr>
				<td>
					<tr>
						<td width="130">
							<img src="logo.jpg"/>
						</td>
						<td>
							<table border="0" cellspacing="0" cellpadding="0" style="font-size: 11px;">
								<tr>
									<td>
										<b>
											<xsl:value-of select="Performer/Organization/Name"/>
										</b>
									</td>
								</tr>
								<tr>
									<td>
										<xsl:value-of select="Performer/Organization/Address/PostalOffice/Code"/>&nbsp;
										<xsl:value-of select="Performer/Organization/Address/PostalOffice/Name"/>&nbsp;,
										<xsl:value-of select="Performer/Organization/Address/Street"/>
									</td>
								</tr>
								<xsl:if test="not(Performer/Organization/AdditionName = '')">
									<tr>
										<td>
											<b>
												<xsl:value-of select="Performer/Organization/AdditionName"/>
											</b>
										</td>
									</tr>
								</xsl:if>
								<tr>
									<td>
										<xsl:value-of select="Performer/Organization/PhoneNumber"/>
									</td>
								</tr>
								<tr>
									<td>
										<xsl:value-of select="document($TxtFile)/InvoiceTXT/HeadTXT/H1_1"/>:&nbsp;
										<xsl:value-of select="Performer/Organization/AccountID"/>
									</td>
								</tr>
								<xsl:if test="(Performer/Organization/TaxID != '')">
									<tr>
										<td>
											<xsl:value-of select="document($TxtFile)/InvoiceTXT/HeadTXT/H2_1"/>:&nbsp;
										<xsl:value-of select="Performer/Organization/TaxID"/>
										</td>
									</tr>
								</xsl:if>
								<!--
								<tr>
									<td>
										<xsl:value-of select="document($TxtFile)/InvoiceTXT/HeadTXT/H3_1"/>:&nbsp;
										<xsl:value-of select="Performer/Organization/ID"/>
									</td>
								</tr>
								-->
							</table>
						</td>
					</tr>
				</td>
			</tr>
			<tr>
				<td colspan="2">&nbsp;</td>
			</tr>
			<tr>
				<td colspan="2">&nbsp;</td>
			</tr>
		</table>
		<table width="650" border="0" cellspacing="0" cellpadding="0" style="font-size: 11px;">
			<tr>
				<td width="300">
					<table border="0" cellspacing="0" cellpadding="0" style="font-size: 11px;">
						<tr>
							<td>
								<xsl:value-of select="document($TxtFile)/InvoiceTXT/HeadTXT/H4_1"/>:&nbsp;
								<xsl:call-template name="FormatDate">
									<xsl:with-param name="Date" select="Document/InvDate"/>
								</xsl:call-template>
							</td>
						</tr>
						<tr>
							<td>
								<xsl:value-of select="document($TxtFile)/InvoiceTXT/HeadTXT/H5_1"/>:&nbsp;
								<xsl:call-template name="FormatDate">
									<xsl:with-param name="Date" select="Document/DateExpiration"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>
				<td>
					<table border="0" cellspacing="0" cellpadding="0" style="font-size: 11px;">
						<tr>
							<td>
								<b>
									<xsl:value-of select="Payer/Destination/Name"/>
								</b>
							</td>
						</tr>
						<xsl:choose>
							<xsl:when test="(Payer/Destination/AdditionalName != '')">
								<tr>
									<td>
										<b>
											<xsl:value-of select="Payer/Destination/AdditionalName"/>
										</b>
									</td>
								</tr>
								<xsl:if test="(Payer/Destination/AdditionalName1 != '')">
									<tr>
										<td>
											<b>
												<xsl:value-of select="Payer/Destination/AdditionalName1"/>
											</b>
										</td>
									</tr>
								</xsl:if>
								<xsl:if test="(Payer/Destination/AdditionalName2 != '')">
									<tr>
										<td>
											<b>
												<xsl:value-of select="Payer/Destination/AdditionalName2"/>
											</b>
										</td>
									</tr>
								</xsl:if>
							</xsl:when>
							<xsl:otherwise>
		
								</xsl:otherwise>
						</xsl:choose>
						<tr>
							<td>
								<xsl:value-of select="Payer/Destination/Address/PostalOffice/Code"/>&nbsp;
								<xsl:value-of select="Payer/Destination/Address/PostalOffice/Name"/>
							</td>
						</tr>
						<tr>
							<td>
								<xsl:value-of select="Payer/Destination/Address/Street"/>
							</td>
						</tr>
						<xsl:if test="(Payer/Destination/TaxID != '')">
							<tr>
								<td>
									<xsl:value-of select="document($TxtFile)/InvoiceTXT/HeadTXT/H2_1"/>:&nbsp;
								<xsl:value-of select="Payer/Destination/TaxID"/>
								</td>
							</tr>
						</xsl:if>
					</table>
				</td>
			</tr>
			<tr>
				<td colspan="2">&nbsp;</td>
			</tr>
			<tr>
				<td colspan="2">&nbsp;</td>
			</tr>
			<tr>
				<td colspan="2" align="center">
					<b>
						<xsl:value-of select="document($TxtFile)/InvoiceTXT/HeadTXT/H6_1"/>&nbsp;
						<xsl:value-of select="Document/ID"/>
					</b>
				</td>
			</tr>
			<xsl:choose>
				<xsl:when test="../InvProperty/StornoDocument='D'">
					<tr>
						<td colspan="2" align="center">
							<xsl:value-of select="document($TxtFile)/InvoiceTXT/HeadTXT/H6_2"/>&nbsp;
							<xsl:value-of select="../InvProperty/VezniDocument"/>,&nbsp;
							<xsl:value-of select="document($TxtFile)/InvoiceTXT/HeadTXT/H6_3"/>&nbsp;
							<xsl:call-template name="FormatDate">
								<xsl:with-param name="Date" select="../InvProperty/VezniDocument_Date"/>
							</xsl:call-template>
						</td>
					</tr>
				</xsl:when>
			</xsl:choose>
			<tr>
				<td colspan="2">&nbsp;</td>
			</tr>
			<tr>
				<td colspan="2">&nbsp;</td>
			</tr>
			<!-- //ML, 21.02.2023, Akt_109479: Dodatni opis na dokumentu-->
			<xsl:if test="(Document/DocumentTitle != '')">
				<tr>
					<td colspan="4">
						<b>
							<xsl:value-of select="Document/DocumentTitle"/>
						</b>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="(Document/DocumentText != '')">
				<tr>
					<td colspan="4">
						<xsl:value-of select="Document/DocumentText"/>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="(Document/DocumentText != '') or (Document/DocumentTitle != '')">
				<tr>
					<td colspan="4">&nbsp;</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>
	<xsl:template match="InvBody" mode="DocCountryHeaderBody">
		<xsl:param name="Type"/>
		<xsl:param name="TxtFile"/>
		<table width="650" border="0" cellspacing="0" cellpadding="0" style="font-size: 11px;">
			<tr>
				<td>
					<xsl:value-of select="document($TxtFile)/InvoiceTXT/BodyTXT/BH1_1"/>:&nbsp;
					<xsl:value-of select="BodyProperty/Patient/Patient"/>
				</td>
			</tr>
			<xsl:choose>
				<xsl:when test="not(../InvHeader/Document/DocType='I') and not(../InvHeader/Document/DocType='S')">
					<tr>
						<td>
							<xsl:value-of select="document($TxtFile)/InvoiceTXT/BodyTXT/BH2_5"/>:&nbsp;								
							<xsl:call-template name="FormatDate">
								<xsl:with-param name="Date" select="../InvHeader/Document/InvDateFrom"/>
							</xsl:call-template>&nbsp;-					
							<xsl:call-template name="FormatDate">
								<xsl:with-param name="Date" select="../InvHeader/Document/InvDateTo"/>
							</xsl:call-template>
						</td>
					</tr>
				</xsl:when>
			</xsl:choose>
			<xsl:choose>
				<xsl:when test="not(../InvHeader/Document/DocType='S')">
					<tr>
						<td>
							<xsl:value-of select="document($TxtFile)/InvoiceTXT/BodyTXT/BH2_1"/>:&nbsp;
							<xsl:value-of select="BodyProperty/Patient/DateRealization"/>
							<!--		<xsl:choose>
								<xsl:when test="(BodyProperty/Patient/DateRealizationTo = 'A')"/>
								<xsl:when test="(BodyProperty/Patient/DateRealizationTo = '')">&nbsp;-&nbsp;
									<xsl:value-of select="document($TxtFile)/InvoiceTXT/BodyTXT/BH2_4"/>
								</xsl:when>
								<xsl:otherwise>&nbsp;-
									<xsl:value-of select="BodyProperty/Patient/DateRealizationTo"/>&nbsp;	
									<xsl:value-of select="document($TxtFile)/InvoiceTXT/BodyTXT/BH2_3"/>
								</xsl:otherwise>
							</xsl:choose> -->
						</td>
					</tr>
				</xsl:when>
			</xsl:choose>
			<xsl:choose>
				<xsl:when test="not(../InvHeader/Document/DocType='S')">
					<tr>
						<td>
							<xsl:value-of select="document($TxtFile)/InvoiceTXT/BodyTXT/BH3_1"/>:&nbsp;
							<xsl:value-of select="BodyProperty/Patient/PatientID"/>
						</td>
					</tr>
				</xsl:when>
			</xsl:choose>
			<tr>
				<td>
					<xsl:value-of select="document($TxtFile)/InvoiceTXT/BodyTXT/BH4_1"/>:&nbsp;
					<xsl:value-of select="BodyProperty/Patient/MedicalServiceID"/>
				</td>
			</tr>
			<tr>
				<td>
					<xsl:value-of select="document($TxtFile)/InvoiceTXT/BodyTXT/BH5_1"/>:&nbsp;
					<xsl:value-of select="BodyProperty/Patient/RegistrationID"/>
				</td>
			</tr>
			<!--
			<tr>
				<td>
					<xsl:value-of select="document($TxtFile)/InvoiceTXT/BodyTXT/BH6_1"/>:&nbsp;
					<xsl:value-of select="BodyProperty/Patient/UnitID"/>
				</td>
			</tr>
			-->
			<tr>
				<td>&nbsp;</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template match="InvBody" mode="DocCountryBody">
		<xsl:param name="Type"/>
		<xsl:param name="TxtFile"/>
		<table width="650" border="0" cellspacing="0" cellpadding="0" style="font-size: 11px;">
			<tr>
				<td colspan="5">
					<hr size="0"/>
				</td>
			</tr>
			<tr>
				<td width="80" align="left">
					<b>
						<xsl:value-of select="document($TxtFile)/InvoiceTXT/BodyTXT/BTH1_1"/>
					</b>
				</td>
				<td width="370" align="left">
					<b>
						<xsl:value-of select="document($TxtFile)/InvoiceTXT/BodyTXT/BTH1_2"/>
					</b>
				</td>
				<td width="200" align="right">
					<b>
						<xsl:value-of select="document($TxtFile)/InvoiceTXT/BodyTXT/BTH1_5"/>
					</b>
				</td>
			</tr>
			<tr>
				<td colspan="5">
					<hr size="0"/>
				</td>
			</tr>
			<xsl:for-each select="Activitys/Activity">
				<xsl:sort/>
				<xsl:for-each select="Categorys/Category">
					<xsl:sort/>
					<xsl:for-each select="UnderGroups/UnderGroup">
						<xsl:sort/>
						<xsl:for-each select="Groups/Group">
							<xsl:sort/>
							<tr>
								<td>
									<xsl:value-of select="ID"/>
								</td>
								<td>
									<xsl:value-of select="Name"/>
								</td>
								<td align="right">
									<xsl:choose>
										<xsl:when test="(../../../../../../../../../InvFooter/ServicePriceProperty/Currency='EUR')">
											<xsl:call-template name="FormatNumberWithNull">
												<xsl:with-param name="Number" select="ServicePriceProperty/BasicPriceInCurrency"/>
											</xsl:call-template>
										</xsl:when>
										<xsl:otherwise>
											<xsl:call-template name="FormatNumberWithNull">
												<xsl:with-param name="Number" select="ServicePriceProperty/BasicPrice"/>
											</xsl:call-template>
										</xsl:otherwise>
									</xsl:choose>
								</td>
							</tr>
						</xsl:for-each>
					</xsl:for-each>
				</xsl:for-each>
			</xsl:for-each>
			<tr>
				<td colspan="5">
					<hr size="0"/>
				</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template match="InvFooter" mode="DocCountryFooter">
		<xsl:param name="Type"/>
		<xsl:param name="TxtFile"/>
		<table width="650" border="0" cellspacing="0" cellpadding="0" style="font-size: 11px;">
			<xsl:choose>
				<xsl:when test="(ServicePriceProperty/Currency='EUR')">
					<!--<tr>
						<td>&nbsp;</td>
						<td>
							<hr size="0"/>
						</td>
					</tr>-->
					<tr>
						<td width="510" align="right">
							<xsl:value-of select="document($TxtFile)/InvoiceTXT/BodyTXT/BF1_2"/>:
					</td>
						<td align="right">
							<xsl:call-template name="FormatNumberWithNull">
								<xsl:with-param name="Number" select="ServicePriceProperty/ServicePriceInCurrency"/>
							</xsl:call-template>
						</td>
					</tr>
					<tr>
						<td width="510" align="right">
							<xsl:choose>
								<xsl:when test="../InvProperty/PayerType = '1'">
									<xsl:value-of select="document($TxtFile)/InvoiceTXT/BodyTXT/BF2_3"/>:
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="document($TxtFile)/InvoiceTXT/BodyTXT/BF2_4"/>:						
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td align="right">
							<xsl:call-template name="FormatNumberWithNull">
								<xsl:with-param name="Number" select="(ServicePriceProperty/AdvancePriceInCurrency*-1)"/>
							</xsl:call-template>
						</td>
					</tr>
					<tr>
						<td width="510" align="right">
							<xsl:value-of select="document($TxtFile)/InvoiceTXT/BodyTXT/BF3_2"/>:
					</td>
						<td align="right">
							<xsl:call-template name="FormatNumberWithNull">
								<xsl:with-param name="Number" select="ServicePriceProperty/ServicePriceInCurrency"/>
							</xsl:call-template>
						</td>
					</tr>
					<tr>
						<td>&nbsp;</td>
						<td>
							<hr size="0"/>
						</td>
					</tr>
					<tr>
						<xsl:choose>
							<xsl:when test="contains(((ServicePriceProperty/ServicePriceInCurrency)+(ServicePriceProperty/AdvancePriceInCurrency)), '-')">
								<td width="510" align="right">
									<xsl:value-of select="document($TxtFile)/InvoiceTXT/BodyTXT/BF4_4"/>:
								</td>
								<td align="right">
									<xsl:call-template name="FormatNumberWithNull">
										<xsl:with-param name="Number" select="-((ServicePriceProperty/ServicePriceInCurrency)+(ServicePriceProperty/AdvancePriceInCurrency))"/>
									</xsl:call-template>
								</td>
							</xsl:when>
							<xsl:otherwise>
								<td width="510" align="right">
									<xsl:value-of select="document($TxtFile)/InvoiceTXT/BodyTXT/BF4_2"/>:
								</td>
								<td align="right">
									<xsl:call-template name="FormatNumberWithNull">
										<xsl:with-param name="Number" select="(ServicePriceProperty/ServicePriceInCurrency)+(ServicePriceProperty/AdvancePriceInCurrency)"/>
									</xsl:call-template>
								</td>
							</xsl:otherwise>
						</xsl:choose>
					</tr>
				</xsl:when>
				<xsl:otherwise>
					<tr>
						<td width="510" align="right">
							<xsl:value-of select="document($TxtFile)/InvoiceTXT/BodyTXT/BF1_1"/>:
					</td>
						<td align="right">
							<xsl:call-template name="FormatNumberWithNull">
								<xsl:with-param name="Number" select="ServicePriceProperty/ServicePrice"/>
							</xsl:call-template>
						</td>
					</tr>
					<tr>
						<td width="510" align="right">
							<xsl:choose>
								<xsl:when test="../InvProperty/PayerType = '1'">
									<xsl:value-of select="document($TxtFile)/InvoiceTXT/BodyTXT/BF2_1"/>:
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="document($TxtFile)/InvoiceTXT/BodyTXT/BF2_2"/>:						
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td align="right">
							<xsl:call-template name="FormatNumberWithNull">
								<xsl:with-param name="Number" select="(ServicePriceProperty/AdvancePrice*-1)"/>
							</xsl:call-template>
						</td>
					</tr>
					<tr>
						<td width="510" align="right">
							<xsl:value-of select="document($TxtFile)/InvoiceTXT/BodyTXT/BF3_1"/>:
					</td>
						<td align="right">
							<xsl:call-template name="FormatNumberWithNull">
								<xsl:with-param name="Number" select="ServicePriceProperty/BasicPrice"/>
							</xsl:call-template>
						</td>
					</tr>
					<tr>
						<td>&nbsp;</td>
						<td>
							<hr size="0"/>
						</td>
					</tr>
					<tr>
						<xsl:choose>
							<xsl:when test="contains(((ServicePriceProperty/BasicPrice) + (ServicePriceProperty/AdvancePrice)), '-')">
								<td width="510" align="right">
									<xsl:value-of select="document($TxtFile)/InvoiceTXT/BodyTXT/BF4_3"/>:
								</td>
								<td align="right">
									<xsl:call-template name="FormatNumberWithNull">
										<xsl:with-param name="Number" select="-((ServicePriceProperty/BasicPrice) + (ServicePriceProperty/AdvancePrice))"/>
									</xsl:call-template>
								</td>
							</xsl:when>
							<xsl:otherwise>
								<td width="510" align="right">
									<xsl:value-of select="document($TxtFile)/InvoiceTXT/BodyTXT/BF4_1"/>:
								</td>
								<td align="right">
									<xsl:call-template name="FormatNumberWithNull">
										<xsl:with-param name="Number" select="((ServicePriceProperty/BasicPrice) + (ServicePriceProperty/AdvancePrice))"/>
									</xsl:call-template>
								</td>
							</xsl:otherwise>
						</xsl:choose>
					</tr>
				</xsl:otherwise>
			</xsl:choose>
			<tr>
				<td colspan="2">&nbsp;</td>
			</tr>
			<tr>
				<td colspan="2">&nbsp;</td>
			</tr>
			<tr>
				<td colspan="2">
					<xsl:value-of select="document($TxtFile)/InvoiceTXT/BodyTXT/BF5_1"/>:
					<xsl:value-of select="Text"/>
				</td>
			</tr>
			<tr>
				<td colspan="2">&nbsp;</td>
			</tr>
			<xsl:for-each select="AdditionalDescriptionList/Value">
				<tr>
					<td colspan="2">
						<xsl:value-of select="document($TxtFile)/InvoiceTXT/BodyTXT/BF5_2"/>:
						<xsl:value-of select="."/>
					</td>
				</tr>
			</xsl:for-each>
			<tr>
				<td colspan="2">&nbsp;</td>
			</tr>
			<tr>
				<td colspan="2">&nbsp;</td>
			</tr>
			<tr>
				<td colspan="2">
					<xsl:value-of select="Description"/>
				</td>
			</tr>
		</table>
		<!--//ML, 28.10.2016, Akt_106471: Dopolnitev 'noge' rauna z zakonsko obveznimi podatki-->
		<xsl:if test="FooterText">
			<table width="650" border="0" cellspacing="0" cellpadding="0" style="font-size: 8px;">
				<tr>
					<td colspan="4">&nbsp;</td>
				</tr>
				<tr>
					<td colspan="4">&nbsp;</td>
				</tr>
				<xsl:choose>
					<xsl:when test="FooterText/Image">
						<tr>
							<td colspan="4">
								<img src="{FooterText/Image}"/>
							</td>
						</tr>
					</xsl:when>
					<xsl:otherwise>
						<tr>
							<xsl:choose>
								<xsl:when test="FooterText/Align = 'Left'">
									<td width="650" align="left">
										<xsl:for-each select="FooterText/Line">
											<xsl:value-of select="."/>
											<br/>
										</xsl:for-each>
									</td>
								</xsl:when>
								<xsl:when test="FooterText/Align = 'Right'">
									<td width="650" align="right">
										<xsl:for-each select="FooterText/Line">
											<xsl:value-of select="."/>
											<br/>
										</xsl:for-each>
									</td>
								</xsl:when>
								<xsl:otherwise>
									<td width="650" align="center">
										<xsl:for-each select="FooterText/Line">
											<xsl:value-of select="."/>
											<br/>
										</xsl:for-each>
									</td>
								</xsl:otherwise>
							</xsl:choose>
						</tr>
					</xsl:otherwise>
				</xsl:choose>
			</table>
		</xsl:if>
	</xsl:template>
	<xsl:template match="InvBody" mode="DocCountrySpecBody">
		<xsl:param name="Type"/>
		<xsl:param name="TxtFile"/>
		<table width="650" border="0" cellspacing="0" cellpadding="0" style="font-size: 11px;">
			<tr>
				<td colspan="6" align="center">
					<b>
						<xsl:value-of select="document($TxtFile)/InvoiceTXT/BodyTXT/BTH0_0"/>
					</b>
				</td>
			</tr>
			<tr>
				<td colspan="6">&nbsp;</td>
			</tr>
			<tr>
				<td colspan="6">
					<hr size="0"/>
				</td>
			</tr>
			<tr>
				<td width="50" align="left">&nbsp;</td>
				<td width="50" align="left">
					<b>
						<xsl:value-of select="document($TxtFile)/InvoiceTXT/BodyTXT/BTH1_1"/>
					</b>
				</td>
				<td width="200" align="left">
					<b>
						<xsl:value-of select="document($TxtFile)/InvoiceTXT/BodyTXT/BTH1_2"/>
					</b>
				</td>
				<td width="100" align="right">
					<b>
						<xsl:value-of select="document($TxtFile)/InvoiceTXT/BodyTXT/BTH1_3"/>
					</b>
				</td>
				<td width="125" align="right">
					<b>
						<xsl:value-of select="document($TxtFile)/InvoiceTXT/BodyTXT/BTH1_4"/>
					</b>
				</td>
				<td width="125" align="right">
					<b>
						<xsl:value-of select="document($TxtFile)/InvoiceTXT/BodyTXT/BTH1_5"/>
					</b>
				</td>
			</tr>
			<tr>
				<td colspan="6">
					<hr size="0"/>
				</td>
			</tr>
			<xsl:for-each select="Activitys/Activity">
				<xsl:sort/>
				<xsl:for-each select="Categorys/Category">
					<xsl:sort/>
					<xsl:for-each select="UnderGroups/UnderGroup">
						<xsl:sort/>
						<xsl:for-each select="Groups/Group">
							<xsl:sort/>
							<tr>
								<td colspan="6" align="left">
									<xsl:value-of select="ID"/>&nbsp;&nbsp;
									<xsl:value-of select="Name"/>
								</td>
							</tr>
							<tr>
								<td colspan="6">&nbsp;</td>
							</tr>
							<xsl:for-each select="Services/Service">
								<xsl:sort/>
								<tr>
									<td>&nbsp;</td>
									<td>
										<xsl:value-of select="Service/ID"/>
									</td>
									<td>
										<xsl:value-of select="Service/Name"/>
									</td>
									<td align="right">
										<xsl:choose>
											<xsl:when test="UnitValue/Value='0.00000'">
												<xsl:call-template name="FormatNumberWithNull">
													<xsl:with-param name="Number" select="NumberOfCase/Number"/>
												</xsl:call-template>
											</xsl:when>
											<xsl:otherwise>
												<xsl:call-template name="FormatNumberWithNull">
													<xsl:with-param name="Number" select="UnitValue/Value"/>
												</xsl:call-template>
											</xsl:otherwise>
										</xsl:choose>
									</td>
									<td align="right">
										<xsl:call-template name="FormatNumberWithNull">
											<xsl:with-param name="Number" select="CoeficientValue"/>
										</xsl:call-template>
									</td>
									<td align="right">
										<xsl:call-template name="FormatNumberWithNull">
											<xsl:with-param name="Number" select="ServicePriceProperty/AdditionalPrice"/>
										</xsl:call-template>
									</td>
								</tr>
							</xsl:for-each>
							<tr>
								<td colspan="5">&nbsp;</td>
								<td>
									<hr size="0"/>
								</td>
							</tr>
							<tr>
								<td colspan="5" align="right">
									<xsl:value-of select="document($TxtFile)/InvoiceTXT/BodyTXT/BS1_1"/>:
								</td>
								<td align="right">
									<xsl:call-template name="FormatNumberWithNull">
										<xsl:with-param name="Number" select="ServicePriceProperty/AdditionalPrice"/>
									</xsl:call-template>
								</td>
							</tr>
						</xsl:for-each>
					</xsl:for-each>
				</xsl:for-each>
			</xsl:for-each>
			<tr>
				<td colspan="6">&nbsp;</td>
			</tr>
			<tr>
				<td colspan="6">
					<hr size="0"/>
				</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template match="InvFooter" mode="DocCountrySpecFooter">
		<xsl:param name="Type"/>
		<xsl:param name="TxtFile"/>
		<table width="650" border="0" cellspacing="0" cellpadding="0" style="font-size: 11px;">
			<tr>
				<td width="525" align="right">
					<xsl:value-of select="document($TxtFile)/InvoiceTXT/BodyTXT/BS1_1"/>:
				</td>
				<td width="125" align="right">
					<xsl:call-template name="FormatNumberWithNull">
						<xsl:with-param name="Number" select="ServicePriceProperty/AdditionalPrice"/>
					</xsl:call-template>
				</td>
			</tr>
			<tr>
				<td colspan="2">&nbsp;</td>
			</tr>
			<tr>
				<td colspan="2">&nbsp;</td>
			</tr>
			<tr>
				<td colspan="2">
					<xsl:value-of select="Description"/>
				</td>
			</tr>
		</table>
	</xsl:template>
	<!-- 27.10.2006 MKI -->
	<xsl:template match="InvHeader" mode="DocMKIHeader">
		<xsl:param name="Type"/>
		<xsl:param name="TxtFile"/>
		<table width="650" border="0" cellspacing="0" cellpadding="0" style="font-size: 11px;">
			<tr>
				<td colspan="4">
					<xsl:value-of select="Performer/Organization/Name"/>
				</td>
			</tr>
			<xsl:choose>
				<xsl:when test="Performer/Organization/AdditionName != ''">
					<tr>
						<td colspan="4">
							<xsl:value-of select="Performer/Organization/AdditionName"/>
						</td>
					</tr>
				</xsl:when>
			</xsl:choose>
			<tr>
				<td colspan="4">
					<xsl:value-of select="Performer/Organization/Address/Street"/>
				</td>
			</tr>
			<tr>
				<td colspan="4">
					<xsl:value-of select="Performer/Organization/Address/PostalOffice/Code"/>&nbsp;&nbsp;
					<xsl:value-of select="Performer/Organization/Address/PostalOffice/Name"/>
				</td>
			</tr>
			<tr>
				<td colspan="4">
					<xsl:call-template name="HeadRules">
						<xsl:with-param name="T" select="$Type"/>
						<xsl:with-param name="H5_1" select="$TxtFile"/>
					</xsl:call-template>&nbsp;
					<xsl:value-of select="Performer/Organization/TaxID"/>
				</td>
			</tr>
			<tr>
				<td colspan="4">
					<xsl:call-template name="HeadRules">
						<xsl:with-param name="T" select="$Type"/>
						<xsl:with-param name="H4_1" select="$TxtFile"/>
					</xsl:call-template>&nbsp;
					<xsl:value-of select="Performer/Organization/AccountID"/>
				</td>
			</tr>
			<tr>
				<td colspan="2">
					<xsl:value-of select="Performer/Organization/PhoneNumber"/>
				</td>
				<td>
					<b>
						<xsl:call-template name="HeadRules">
							<xsl:with-param name="T" select="$Type"/>
							<xsl:with-param name="H7_2" select="$TxtFile"/>
						</xsl:call-template>
					</b>
				</td>
				<td>
					<xsl:value-of select="Document/ID"/>
				</td>
			</tr>
			<xsl:if test="(../InvProperty/StornoDocument = 'D') and (../InvProperty/VezniDocument != '')">
				<tr>
					<td colspan="2"/>
					<td>Vezni dokument:</td>
					<td>
						<xsl:value-of select="../InvProperty/VezniDocument"/>
					</td>
				</tr>
			</xsl:if>
			<tr>
				<td colspan="2"/>
				<td>
					<xsl:call-template name="HeadRules">
						<xsl:with-param name="T" select="$Type"/>
						<xsl:with-param name="H8_2" select="$TxtFile"/>
					</xsl:call-template>
				</td>
				<td>
					<xsl:value-of select="Document/PlaceEdition"/>
				</td>
			</tr>
			<tr>
				<td colspan="2">
					<xsl:value-of select="Payer/Organization/Name"/>
				</td>
				<td>
					<xsl:call-template name="HeadRules">
						<xsl:with-param name="T" select="$Type"/>
						<xsl:with-param name="H9_2" select="$TxtFile"/>
					</xsl:call-template>
				</td>
				<td>
					<xsl:call-template name="FormatDate">
						<xsl:with-param name="Date" select="Document/InvDate"/>
					</xsl:call-template>
				</td>
			</tr>
			<tr>
				<td colspan="2">
					<xsl:value-of select="Payer/Organization/Address/Street"/>
				</td>
				<xsl:call-template name="HeadRules">
					<xsl:with-param name="T" select="$Type"/>
					<xsl:with-param name="H10_2" select="$TxtFile"/>
				</xsl:call-template>
			</tr>
			<tr>
				<td colspan="2">
					<xsl:value-of select="Payer/Organization/Address/PostalOffice/Code"/>&nbsp;&nbsp;
					<xsl:value-of select="Payer/Organization/Address/PostalOffice/Name"/>
				</td>
				<td>
					<xsl:call-template name="HeadRules">
						<xsl:with-param name="T" select="$Type"/>
						<xsl:with-param name="H12_2" select="$TxtFile"/>
					</xsl:call-template>
				</td>
				<td>
					<xsl:call-template name="FormatDate">
						<xsl:with-param name="Date" select="Document/InvDateFrom"/>
					</xsl:call-template> -
								<xsl:call-template name="FormatDate">
						<xsl:with-param name="Date" select="Document/InvDateTo"/>
					</xsl:call-template>
				</td>
			</tr>
			<tr>
				<td colspan="2"/>
				<td>
					<xsl:call-template name="HeadRules">
						<xsl:with-param name="T" select="$Type"/>
						<xsl:with-param name="H16_2" select="$TxtFile"/>
					</xsl:call-template>
				</td>
				<td>
					<xsl:value-of select="Payer/Destination/ConvocationID"/>
				</td>
			</tr>
			<tr>
				<td width="5%"/>
				<td width="50%" style="font-size: 13px;">
					<xsl:choose>
						<xsl:when test="../InvProperty/BoldAddress='true'">
							<b>
								<xsl:value-of select="Payer/Destination/Name"/>
							</b>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="Payer/Destination/Name"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td>
					<xsl:call-template name="HeadRules">
						<xsl:with-param name="T" select="$Type"/>
						<xsl:with-param name="H11_2" select="$TxtFile"/>
					</xsl:call-template>
				</td>
				<td>
					<xsl:call-template name="FormatDate">
						<xsl:with-param name="Date" select="Document/DateExpiration"/>
					</xsl:call-template>
				</td>
			</tr>
			<xsl:choose>
				<xsl:when test="(Payer/Destination/AdditionalName != '')">
					<tr>
						<td/>
						<td style="font-size: 13px;">
							<xsl:choose>
								<xsl:when test="../InvProperty/BoldAddress='true'">
									<b>
										<xsl:value-of select="Payer/Destination/AdditionalName"/>
									</b>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="Payer/Destination/AdditionalName"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<xsl:if test="(Payer/Destination/AdditionalName1 != '')">
							<tr>
								<td/>
								<td style="font-size: 13px;">
									<xsl:choose>
										<xsl:when test="../InvProperty/BoldAddress='true'">
											<b>
												<xsl:value-of select="Payer/Destination/AdditionalName1"/>
											</b>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="Payer/Destination/AdditionalName1"/>
										</xsl:otherwise>
									</xsl:choose>
								</td>
							</tr>
						</xsl:if>
						<xsl:if test="(Payer/Destination/AdditionalName2 != '')">
							<tr>
								<td/>
								<td style="font-size: 13px;">
									<xsl:choose>
										<xsl:when test="../InvProperty/BoldAddress='true'">
											<b>
												<xsl:value-of select="Payer/Destination/AdditionalName2"/>
											</b>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="Payer/Destination/AdditionalName2"/>
										</xsl:otherwise>
									</xsl:choose>
								</td>
							</tr>
						</xsl:if>
					</tr>
					<tr>
						<td/>
						<td style="font-size: 13px;">
							<xsl:choose>
								<xsl:when test="../InvProperty/BoldAddress='true'">
									<b>
										<xsl:value-of select="Payer/Destination/Address/Street"/>
									</b>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="Payer/Destination/Address/Street"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
					</tr>
					<tr>
						<td colspan="4">&nbsp;</td>
					</tr>
				</xsl:when>
				<xsl:otherwise>
					<tr>
						<td/>
						<td style="font-size: 13px;">
							<xsl:choose>
								<xsl:when test="../InvProperty/BoldAddress='true'">
									<b>
										<xsl:value-of select="Payer/Destination/Address/Street"/>
									</b>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="Payer/Destination/Address/Street"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
					</tr>
					<tr>
						<td colspan="4">&nbsp;</td>
					</tr>
					<tr>
						<td colspan="2"/>
					</tr>
				</xsl:otherwise>
			</xsl:choose>
			<tr>
				<td/>
				<td style="font-size: 13px;">
					<xsl:choose>
						<xsl:when test="../InvProperty/BoldAddress='true'">
							<b>
								<xsl:value-of select="Payer/Destination/Address/PostalOffice/Code"/>&nbsp;&nbsp;&nbsp;
								<xsl:value-of select="Payer/Destination/Address/PostalOffice/Name"/>
							</b>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="Payer/Destination/Address/PostalOffice/Code"/>&nbsp;&nbsp;&nbsp;
							<xsl:value-of select="Payer/Destination/Address/PostalOffice/Name"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td colspan="2"/>
			</tr>
			<tr>
				<td colspan="4">&nbsp;</td>
			</tr>
			<tr>
				<td colspan="4">&nbsp;</td>
			</tr>
			<tr>
				<td colspan="4">&nbsp;</td>
			</tr>
			<tr>
				<td colspan="4">&nbsp;</td>
			</tr>
			<tr>
				<td colspan="4">&nbsp;</td>
			</tr>
			<tr>
				<td colspan="4">&nbsp;</td>
			</tr>
			<tr>
				<td colspan="4">&nbsp;</td>
			</tr>
			<tr>
				<td colspan="4">&nbsp;</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template match="InvBody" mode="DocMKIBody">
		<xsl:param name="Type"/>
		<xsl:param name="TxtFile"/>
		<table width="650" border="0" cellspacing="0" cellpadding="0" style="font-size: 10px;">
			<tr>
				<td colspan="10">&nbsp;</td>
			</tr>
			<tr>
				<xsl:if test="not(../InvFooter/SubjectOfContract = '')">
					<td colspan="10">
						<!-- Predmet pogodbe: -->
						<b>
							<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BH1_1_1"/>&nbsp;
						</b>
						<xsl:value-of select="../InvFooter/SubjectOfContract"/>
					</td>
				</xsl:if>
			</tr>
			<tr>
				<td colspan="10">
					<hr size="0"/>
				</td>
			</tr>
			<tr>
				<td colspan="10">&nbsp;</td>
			</tr>
			<tr>
				<td colspan="2"/>
				<td>
					<!-- ifra in naziv storitve  -->
					<b>
						<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BH2_1_1"/>
					</b>
				</td>
				<td align="right">
					<!-- koli -->
					<b>
						<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BH2_2_1"/>
					</b>
				</td>
				<td align="right">
					<xsl:if test="not(../InvFooter/UnitValue = '0.00000')">
						<!-- tok -->
						<b>
							<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BH2_3_1"/>
						</b>
					</xsl:if>
				</td>
				<td align="right">
					<!-- cena -->
					<b>
						<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BH2_5_1"/>
					</b>
				</td>
				<td align="right">
					<!-- vrednost storitve -->
					<b>
						<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BH2_7_1"/>
					</b>
				</td>
				<td align="right">
					<!-- znesek za plailo -->
					<b>
						<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BH2_8_1"/>
					</b>
				</td>
				<td align="right">
					<xsl:if test="not(../InvFooter/Discount = '0.00000')">
						<!-- pop -->
						<b>
							<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BH2_4_1"/>
						</b>
					</xsl:if>
				</td>
				<td/>
			</tr>
			<tr>
				<td colspan="10">&nbsp;</td>
			</tr>
			<tr>
				<td colspan="10">
					<hr size="0"/>
				</td>
			</tr>
			<tr>
				<td colspan="10">&nbsp;</td>
			</tr>
			<xsl:for-each select="Activitys/Activity">
				<xsl:variable name="ActivityID" select="ID"/>
				<xsl:for-each select="Categorys/Category">
					<xsl:for-each select="UnderGroups/UnderGroup">
						<xsl:sort/>
						<xsl:for-each select="Services/Service">
							<xsl:sort/>
							<tr>
								<td colspan="2"/>
								<td>
									<xsl:value-of select="Service/ID"/>&nbsp;&nbsp;
									<xsl:value-of select="Service/Name"/>
								</td>
								<td align="right">
									<xsl:call-template name="FormatNumber">
										<xsl:with-param name="Number" select="NumberOfCase/Number"/>
									</xsl:call-template>
								</td>
								<td align="right">
									<xsl:call-template name="FormatNumber">
										<xsl:with-param name="Number" select="UnitValue/Value"/>
									</xsl:call-template>
								</td>
								<td align="right">
									<xsl:call-template name="FormatNumberWithNull">
										<xsl:with-param name="Number" select="CoeficientValue"/>
									</xsl:call-template>
								</td>
								<td align="right">
									<xsl:call-template name="FormatNumberWithNull">
										<xsl:with-param name="Number" select="ServicePriceProperty/ServicePrice"/>
									</xsl:call-template>
								</td>
								<td align="right">
									<xsl:call-template name="FormatNumberWithNull">
										<xsl:with-param name="Number" select="ServicePriceProperty/AdditionalPrice"/>
									</xsl:call-template>
								</td>
								<td align="right">
									<xsl:if test="not(../../../../../../../../../InvFooter/Discount = '0.00000')">
										<xsl:value-of select="format-number(Discount, '##', 'european')"/>
										<xsl:if test="not(Discount='0.00000')">%</xsl:if>
									</xsl:if>
								</td>
								<td align="right">
									<xsl:if test="not(ServicePriceProperty/DDVLevel= '99.00000')">&nbsp;&nbsp;
										<xsl:value-of select="format-number(ServicePriceProperty/DDVLevel, '##', 'european')"/>
									</xsl:if>
								</td>
							</tr>
						</xsl:for-each>
					</xsl:for-each>
				</xsl:for-each>
			</xsl:for-each>
			<tr>
				<td colspan="10">&nbsp;</td>
			</tr>
			<tr>
				<td colspan="10">
					<hr size="0"/>
				</td>
			</tr>
			<tr>
				<td colspan="4">
					<b>
						<!-- SKUPAJ: -->
						<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BF1_1_1"/>
					</b>
				</td>
				<td align="right">
					<xsl:call-template name="FormatNumber">
						<xsl:with-param name="Number" select="../InvFooter/UnitValue"/>
					</xsl:call-template>
				</td>
				<td colspan="2"/>
				<td align="right">
					<xsl:call-template name="FormatNumberWithNull">
						<xsl:with-param name="Number" select="(../InvFooter/ServicePriceProperty/ServicePrice)"/>
					</xsl:call-template>
				</td>
				<td align="left">&nbsp;
					<xsl:value-of select="../InvFooter/ServicePriceProperty/Currency"/>
				</td>
				<td/>
			</tr>
			<tr>
				<td colspan="10">&nbsp;</td>
			</tr>
			<xsl:if test="not(../InvFooter/Discount = '0.00000')">
				<tr>
					<td colspan="7">
						<b>
							<!-- Popust v znesku: -->
							<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BF2_1_1"/>
						</b>
					</td>
					<td align="right">
						<xsl:call-template name="FormatNumberWithNull">
							<xsl:with-param name="Number" select="../InvFooter/Discount"/>
						</xsl:call-template>
					</td>
					<td align="left">&nbsp;-</td>
					<td/>
				</tr>
			</xsl:if>
			<xsl:if test="not(../InvFooter/DiscountWithContract = '0.00000')">
				<tr>
					<td colspan="5">
						<b>
							<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BF2_2_1"/>
						</b>
					</td>
					<td colspan="2">
						<xsl:call-template name="FormatNumber">
							<xsl:with-param name="Number" select="../InvFooter/DiscountWithContractInPercent"/>
						</xsl:call-template>&nbsp;%			
					</td>
					<td align="right">
						<xsl:call-template name="FormatNumberWithNull">
							<xsl:with-param name="Number" select="../InvFooter/DiscountWithContract"/>
						</xsl:call-template>
					</td>
					<td align="left">&nbsp;-</td>
					<td/>
				</tr>
			</xsl:if>
			<tr>
				<td colspan="10">&nbsp;</td>
			</tr>
			<tr>
				<td colspan="7">
					<b>
						<xsl:choose>
							<xsl:when test="contains(../InvFooter/PayPrice,'-')">
								<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BF6_1_2"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BF6_1_1"/>
							</xsl:otherwise>
						</xsl:choose>
					</b>
				</td>
				<td align="right">
					<xsl:call-template name="FormatNumberWithNull">
						<xsl:with-param name="Number" select="(../InvFooter/PayPrice)"/>
					</xsl:call-template>
				</td>
				<td colspan="2"/>
			</tr>
		</table>
	</xsl:template>
</xsl:stylesheet>
