"""
This is a simple program that sends audio stream captured over a microfon, to the TB ASR service.
When finals appear, they are pasted in window that currently has focus (at the position of the cursor).

GUI for mainwindow (toolbar) and command helper is designed with QT Designer and generated using "pyuic5"
Generated gui classes are inherited so that whatever change is made, it is not on the generated code.
Due to the problem of DPI unawareness, GUI automatic sizing is achieved with the scale function that
requires each absolute size or position to be first scaled. To this end, do the following:
1. In all modules with generated GUI classes import scaling function: 
    from gui.gui_scaling import scale
2. With regex based find and replace make changes on the generated classes:
    - regex 1: (move|resize|QRect|setContentsMargins)(?!scale)([(\s])(\d+) --> $1$2scale($3)
    - regex 2: (scale\(\d+\),)(\s)(\d+) --> $1$2scale($3) 
3. All icons and images must have relative paths. Use this - with the IgnoreCase switch:
    - regex 1: (QtGui.QPixmap\()("[\da-z_-]+\.)(png|jpg|jpeg|ico)(")(\)) --> QtGui.QPixmap(os.path.join(basedir, $2$3"))

Resources:
- discussion on how to get active window: https://stackoverflow.com/questions/10266281/obtain-active-window-using-python

Create installation files:
- create version info file with: create-version-file metadata.yml --outfile file_version_info_23.11.txt
- copy version file to location where you have tb-listener.spec file
- rename file_version_info_23.11.txt to file_version_info.txt
- create installation files with: pyinstaller .\tb-listener.spec

Author: Vitasis, Inc
Date: October 2022 -

TODO:
[ ] Some of initializations that are currently under Ui_MainWindow, do no belong there. Consider
    to move under __main__
[ ] Instead of using find and replace to include scaling function, create a python script that will do the same and
    will be then used immediately after gui code is generated.
"""

#from asyncio.log import logger
#from curses.ascii import isdigit
from email.mime import base
from math import hypot
from msilib.schema import Dialog
from xmlrpc.client import Boolean
from PyQt5 import QtCore, QtGui, QtWidgets, Qt
from PyQt5.QtGui import *
from PyQt5.QtWidgets import *
from PyQt5.QtCore import *
from PyQt5.uic import loadUi
from PyQt5.QtMultimedia import QMediaContent, QMediaPlayer

import traceback
import sys
import re
from sys import platform
import pyperclip
import keyboard
import json
import time
from datetime import datetime, timedelta
import os
import yaml
import logging
import win32gui
import win32con
import win32com.client

import webbrowser
from ctypes import windll
import shutil
import threading
import copy
import uuid
from bs4 import BeautifulSoup
import pickle

from utils import truebar

# win32com.client is required for MSMQ
import win32com.client
import winsound
import pythoncom
from gui.gui_dialogs import Ui_Dialog_commands, Ui_Dialog_sendLog, Ui_Dialog_detailed_settings, Ui_Dialog_add_word, Ui_Dialog_Error, Ui_TranscriptWindow, show_message_box, TemplateViewer, DictionaryManager, MappingManager
from gui.gui_toolbar import Ui_Toolbar
from gui.gui_scaling import scale, scalingFactor
from gui.notification import create_pixmap, NotificationButton
from gui.corrector import TextCorrector, word_numbers
from gui.service_logger import setup_logging
from word_helpper import copy_word_template

from screeninfo import get_monitors
import pyautogui

from window_selector_qt import WindowSelector, WindowManipulator

# email service
from sendgrid import SendGridAPIClient
from sendgrid.helpers.mail import (Mail, Attachment, FileContent, FileName, FileType, Disposition, To, From, PlainTextContent, HtmlContent)
import base64

# player editor
from gui.editor import TranscriptEditor

# This is needed to properly handle the mediaplayer functions (e.g. PlaybackRate)
os.environ['QT_MULTIMEDIA_PREFERRED_PLUGINS'] = "windowsmediafoundation"

basedir = os.path.dirname(__file__)
user_appdata = os.path.join(os.getenv('APPDATA'), 'vitasis', 'tb-listener')
resources_folder = os.path.join(basedir, './resources')

# Set to true if you want external commands to be desplayed on the Toolbar
_integration_debug_mode = False

app_version = '25.06'
"""
Version info
publish date: 4. 7. 2025, 
OTHER:
- lock on window
- new commands: withDigits
- Mic check - if the one in teh Registy not available
- Set focus to window reimplemneted
- Time sleep between processing the segments of the final to avaid duplication of the pasted text
"""

_main_window_height_L = 770
_main_window_height_S = 68
_main_window_width_L = 426
_main_window_width_S = 284
_interim_display_len = 37
_dictionary_frame_height_L = 512
_dictionary_frame_height_S = 439

# colors
cl_light_orange_string = 'rgb(254, 241, 230)'
cl_light_green_string = 'rgb(234, 241, 221)'
cl_light_yellow_string = 'rgb(255, 242, 204)'
cl_light_red_string = 'rgb(255, 204, 204)'
cl_light_orange_string = 'rgb(255, 219, 187)'
cl_light_grey_string = 'rgb(211, 211, 211)'
cl_light_blue_string = 'rgb(173, 216, 230)'
cl_beige_string = 'rgb(237, 232, 208)'
cl_message_failed = 'rgb(254, 0, 0)'
cl_message_success = 'rgb(112, 173, 72)'

# Setup logger 
# create user App data folder if not exists
os.makedirs(user_appdata, exist_ok=True)
os.makedirs(os.path.join(user_appdata, 'templates'), exist_ok=True)
os.makedirs(os.path.join(user_appdata, 'dict'), exist_ok=True)
logger = setup_logging("toolbar", user_appdata)

logger.debug(f"BASEDIR: {os.path.dirname(__file__)}")

# settings
def read_config(config_file=os.path.join(user_appdata, "settings.yaml")):
    # if settings file is not found on the user AppData location, read from original version from install folder
    if not os.path.isfile(os.path.join(user_appdata, "settings.yaml")):
        if os.path.isfile(os.path.join(basedir, "settings.yaml")):
            config_file=os.path.join(basedir, "settings.yaml")
        else:
            logger.warning(f"Cannot read settings.yaml file! File {config_file} does not exist!")
            return None

    logger.debug(f"Reading settings from {config_file}")
    with open(config_file, "r", encoding="utf-8") as stream:
        try:
            return yaml.safe_load(stream) 
        except yaml.YAMLError as exc:
            logger.warning(f"Cannot read settings.yaml file, {exc}")
            return None

def move_templates(templates_folder):
    # if templates exist in user-defined templates folder and AppData.../templates folder is empty, the templates are copied to AppData...
    _existing_templates = [f for f in os.listdir(templates_folder) if f.split(".")[-1].lower()=="txt"]
    _existing_templates_APP = [f for f in os.listdir(os.path.join(user_appdata, 'templates')) if f.split(".")[-1].lower()=="txt"]
    if len(_existing_templates) > 0 and len(_existing_templates_APP)==0:
        logger.info(f"Copying {len(_existing_templates)} templates to {os.path.join(user_appdata, 'templates')}")
        for file in _existing_templates:
            shutil.copy(os.path.join(templates_folder, file), os.path.join(user_appdata, 'templates', file))

def save_config(cdict):
    with open(os.path.join(user_appdata, "settings.yaml"), "w", encoding="utf-8") as stream:
        try:
            yaml.safe_dump(cdict, stream, default_flow_style=False, sort_keys=False)
            logger.debug(f"Settings successfully saved to {user_appdata}.")
            return True 
        except yaml.YAMLError as exc:
            logger.warning(f"Cannot update settings.yaml file, {exc}")
            return None

def get_settings_value(dict, key_composition=[]):
    """
    key_composition is a key sequence that coresponds to the key hierarch in the yaml file
    Example: ['general', 'do-postprocessing', 'spp-codes'] refers to the key 'spp-codes' under 'do-postprocessing'...

    """
    if len(key_composition)==0 or key_composition[0] not in dict:
        return False
    elif len(key_composition)==1:
        return dict[key_composition[0]]
    else:
        value = dict[key_composition[0]]
        key_composition.pop(0)
        return get_settings_value(value, key_composition)


# TODO - the same function is already available in the TextCorrectr
def _nvl(t, rv):
    if t:
        return t
    else:
        return rv

def get_monitor_resolutions():
    """
    Uses screeninfo module and returns width and height of the primary screen
    """
    monitors = get_monitors()
    for m in monitors:
        if m.is_primary:
            return {"width": m.width, "height": m.height, "monitors": len(monitors)}
    
    logger.warning(f"None of the monitors seems to be primary - moving toolbar to 0,0 position")
    return {"width": 0, "height": 0, "monitors": len(monitors)}
    
def get_model_update_status(language, domain, model, tb_object):
    model_updater_status = tb_object.check_model_update_status(language=language, domain=domain, model=model)
    if not model_updater_status:
        return 'UNKNOWN'
    else:
        return model_updater_status.get('statusCode', 'UNKNOWN')

def format_datetime(ts):
    """
    Converts timestamp from time.time() into string format "DD.MM.YYYY HH:MM:SS,mmm"
    """
    if not ts:
        return ""
    else:
        return datetime.fromtimestamp(ts).strftime("%d.%m.%Y %H:%M:%S,%f")

    print("Formatted String:", formatted_string)

def create_translations_dict(settings, templates=None):
    """
    Extracts translations from settings and creates a dictionary. If templates are provided, template names mapping is added (e.g. vstavi 5 --> <ins> 5)
    This ensures that token 'vstavi' which is a regular medical term, will not be mapped to command <ins> unless followed by a template name
    Translations refering to disabled commands are ignored!
    """
    translations = dict()
    
    # check if any of the commands is disabled
    enabled_commands_setting = get_settings_value(settings, ['user-defined-commands', 'enabled-commands']) 
    disabled_commands = []
    if enabled_commands_setting:
        disabled_commands = [key for item in enabled_commands_setting for key, value in item.items() if not value]
    
    res = get_settings_value(settings, ['user-defined-commands', 'translations'])
    if res:
        for el in res:
            if el['target'] not in disabled_commands:
                translations[el['source']]=el['target']

    if templates:
        for t in templates.keys():
            translations[f"vstavi {t}"]=f"<ins> {t} "
            translations[f"ustavi {t}"]=f"<ins> {t} "
    
    return translations

def queue_exists(qinfo_object):
    """
    Check if QUEUE initialized with qinfo_object exists
    """
    try:
        qinfo_object.Refresh()  # Will throw an exception if queue doesn't exist
        return True
    except Exception as e:
        return False

# classes

class MedConstants():
    med_units = set(['km',  'm',  'dm',  'cm',  'mm', 'µm',  'm2',  'dm2',  'cm2',  'mm2', 'µm2',  'ha',  'm3',  'dm3',  'cm3',  'mm3', 'µm3',  'dcl',  'cl',  'ml', 'µl',  'hl',  'Hz',  'kg',  'dag',  'g',  'mg', 'µg',  'min',  's',  'h',  'ms', 'µs',  'ted.', '°C', '° C',  'V',  'mV', 'µV',  'A',  'mA', 'µA',  'mol',  'mmol',  'pmol', 'µmol',  'kcal',  'tbl.',  'vp.',  'TT',  'TV',  'OH',  'TM',  'cfu',  'cfu',  'cfu',  'IU',  'IE',  'E',  'gtt',  'gtts',  'mmHg',  'Hg',  'mIU'])
    med_acronyms = set(['UZ', 'TT', 'EEG', 'EKG', 'TV', 'MR', 'PT', 'RTG', 'ORL', 'ZD', 'AV', 'SB', 'SpO', 'RR', 'CRP', 'MRI', 'DKS', 'HV', 'PEF', 'IgE', 'IFS', 'ECHO', 'CMCRF', 'PDA', 'CT', 'ITP', 'TSH', 'VF', 'II', 'VC', 'PeK', 'OŠ', 'COR', 'OG', 'AP', 'oGF', 'SR', 'DRL', 'pH', 'ONS', 'VUR', 'VSD', 'AST', 'NaCl', 'UKC', 'OH', 'IgG', 'KS', 'UMCG', 'DNA', 'KOEDBP', 'EGDS', 'ADC', 'PD', 'KOOKIT', 'RhD', 'ASD', 'KML', 'GER', 'OA', 'EA', 'MCH', 'KP', 'KME', 'HLA', 'IgA', 'PKU', 'CaCO', 'OGTT', 'EMA', 'AD', 'EMG', 'OMR', 'RSV', 'VAS', 'CVK', 'PCR', 'GERB', 'LDL', 'FA', 'PČ', 'IV', 'SCM', 'EIT', 'MŽ', 'NS', 'ICT', 'APMD', 'CD', 'FR', 'AR', 'IVIG', 'EBV', 'JIA', 'KOGHN', 'NGS', 'KOOHO', 'SARKI', 'eRp', 'SVESov', 'IgM', 'FEV', 'RI', 'ZZZS', 'VVZ', 'NF', 'PEK', 'IE', 'HP', 'CK', 'GS', 'MCUG', 'ALL', 'OSAS', 'ITM', 'HDL', 'BPM', 'IVF', 'KVČB', 'KOOMRN', 'COVID', 'INR', 'III', 'DG', 'ICD', 'eNO', 'LDH', 'ACE', 'MRA', 'NIV', 'TEOAE', 'LRL', 'MCT', 'MMR', 'ARI', 'ST', 'SD', 'SDS', 'BAL', 'LA', 'PET', 'EF', 'IUGR', 'HbA', 'VP', 'CH', 'DiTePer', 'IMŽ', 'PFO', 'FVIII', 'IVS', 'PEP', 'GEA', 'FD', 'MCV', 'SCCL', 'AquADEKs', 'CTG', 'HPV', 'CFU', 'QT', 'FS', 'DXA', 'SA', 'CO', 'PIP', 'BAT', 'TR', 'EINT', 'VE', 'GnRH', 'ICP', 'MCP', 'RAPD', 'ACTH', 'PEG', 'TTG', 'RoActemre', 'iPTH', 'ECP', 'ALT', 'MAT', 'CPAP', 'RNO', 'KLB', 'ESBL', 'HiB', 'AH', 'ANCA', 'ISPEK', 'KT', 'PK', 'HSV', 'KR', 'FISH', 'FLAIR', 'KOEDPB', 'TBC', 'PKu', 'FTH', 'DLO', 'SaO', 'TH', 'ESES', 'ADHD', 'HCO', 'IPV', 'CBD', 'BMI', 'BCG', 'HD', 'RCA', 'sIgE', 'PR', 'DEKAs', 'AF', 'NO', 'LV', 'PNO', 'KON', 'SUV', 'MRSA', 'MTX', 'QRS', 'CR', 'PICC', 'APTČ', 'AVF', 'PC', 'DDD', 'PPO', 'MET', 'OR', 'BioGaia', 'APD', 'VCI', 'ADG', 'HR', 'VEP', 'BM', 'PPL', 'IT', 'VTM', 'SLIT', 'SUO', 'LGG', 'RVOT', 'FVC', 'MTHFR', 'WC', 'LF', 'CF', 'AAL', 'NaHCO', 'AK', 'RQ', 'LKH', 'RoActemra', 'LVMI', 'AB', 'CTA', 'IGF', 'EDH', 'VZV', 'LH', 'NK', 'PM', 'RP', 'PB', 'TAPSE', 'tTG', 'DDAVP', 'VT', 'QTc', 'PPI', 'SNMP', 'PAKK', 'NBT', 'IFT', 'CellCept', 'RA', 'kgTT', 'RE', 'HC', 'BNK', 'GCS', 'ICDja', 'WPW', 'PCO', 'IVSd', 'AHI', 'GT', 'DSA', 'AC', 'KIR', 'MZ', 'SARS', 'RVOTO', 'EKK', 'SGB', 'IEGM', 'LCT', 'LPA', 'PORTa', 'PFAPA', 'AŠN', 'OP', 'LVOT', 'SatO', 'TTGM', 'GE', 'CIRIUS', 'XX', 'VD', 'ZPČ', 'PTH', 'PG', 'CSD', 'MM', 'SLE', 'PSVT', 'PMR', 'MTP', 'DNK', 'ARA', 'CAPD', 'dU', 'MF', 'EHO', 'SL', 'dBnHL', 'RPA', 'NŽOD', 'NFS', 'RS', 'CMV', 'SSEP', 'ZRI', 'SCIT', 'CFM', 'KZZ', 'FSGS', 'HUT', 'TM', 'SMA', 'AVNRT', 'FMS', 'SWI', 'MDM', 'LD', 'TNF', 'GVHD', 'IB', 'WAR', 'HBV', 'VZS', 'KM', 'EFŠ', 'SVT', 'HK', 'ADP', 'PRA', 'OMA', 'UTD', 'OŽS', 'TMS', 'ZVP', 'OK', 'ASC', 'AO', 'pT', 'RF', 'VO', 'IL', 'NSE', 'AML', 'RH', 'PAVK', 'DKUC', 'LVD', 'IBD', 'KEF', 'RV', 'WATT', 'CUDV', 'EoE', 'kU', 'BE', 'ATP', 'DD', 'SIOP', 'CZBO', 'JJ', 'RNA', 'HAL', 'aCGH', 'VCma', 'XY', 'MMF', 'SVES', 'TIBC', 'PNMP', 'GMFCS', 'LCA', 'IAS', 'HEP', 'IU', 'KMC', 'CVP', 'ABC', 'NFTH', 'BPD', 'DB', 'IKT', 'OVI', 'ACR', 'GERa', 'MRCP', 'LVd', 'BMD', 'KCl', 'SonoVue', 'AVSD', 'HRCT', 'TD', 'HIT', 'OHP', 'SIS', 'NSAID', 'BHI', 'DMS', 'PVL', 'DiGeorge', 'MPF', 'KNM', 'LP', 'TCD', 'TOF', 'IA', 'SDU', 'LJ', 'BB', 'OEPA', 'LVOTO', 'VESov', 'MPV', 'COPDAC', 'PtcCO', 'AA', 'VMA', 'TEE', 'THC', 'FV', 'SCN', 'SPEC', 'OI', 'DGN', 'SUA', 'AraC', 'GIT', 'OCT', 'DeMeestru', 'VDO', 'HIV', 'mL', 'ABR', 'FSH', 'IVZ', 'HIB', 'GTG', 'EDSS', 'BK', 'ERG', 'CP', 'UF', 'REM', 'HMG', 'DV', 'EDD', 'SKM', 'AoZ', 'IKP', 'MDRD', 'ACC', 'DSP', 'BH', 'SOS', 'VIII', 'MS', 'DRP', 'PAH', 'VAP', 'LDLR', 'VWF', 'EDV', 'MVW', 'VA', 'CŽS', 'ZDA', 'COL', 'MV', 'VII', 'PH', 'RoActemro', 'mM', 'DLCO', 'TG', 'DMSA', 'DNV', 'mK', 'PS', 'CBCL', 'DIP', 'VIDE', 'IX', 'CRT', 'PZ', 'ACM', 'stC', 'AKH', 'TP', 'OHIO', 'NSAR', 'SEH', 'OXY', 'TpcCO', 'AI', 'LCX', 'VDLO', 'FIX', 'KC', 'eRecept', 'AVAPS', 'ID', 'PDP', 'DiTePerPolioHib', 'UKCL', 'MT', 'VCS', 'RTE', 'FP', 'NMDAR', 'vWF', 'ND', 'CA', 'IVIg', 'GERBa', 'QTC', 'OTC', 'DH', 'AGA', 'NG', 'pCO', 'SHOX', 'UL', 'TOAE', 'SPO', 'ACI', 'DM', 'PAID', 'CaCarbonat', 'APOB', 'URIRS', 'KOMZ', 'EC', 'CaCo', 'IPAP', 'RLP', 'NT', 'TEAOE', 'PQ', 'LVI', 'INV', 'IPP', 'TIA', 'CFTR', 'ATC', 'TZ', 'EMLA', 'APGAR', 'MODY', 'MLPA', 'SAB', 'ANC', 'CHARGE', 'HIP', 'UIBC', 'IP', 'GnRh', 'KONEO', 'RER', 'HB', 'DOPA', 'CMZ', 'KOPB', 'HVA', 'TMP', 'MPA', 'VAI', 'PUCAI', 'PGE', 'yGT', 'EDGS', 'CZO', 'GNRH', 'DORV', 'MIBG', 'CKD', 'VCR', 'spO', 'LAD', 'ADOS', 'OSA', 'HCM', 'EpiPen', 'XP', 'PCT', 'DCT', 'WISC', 'PKMC', 'DMD', 'SBT', 'IGE', 'MPS', 'ZGN', 'KOITO', 'ŽMB', 'HSP', 'DWI', 'NMP', 'KIMG', 'UPM', 'GVT', 'TC', 'JAK', 'MEFV', 'IR', 'SEP', 'FSME', 'DNT', 'CB', 'HbsAg', 'TSI', 'ANSA', 'VATER', 'CVID', 'ARVD', 'GPI', 'AM', 'HCV', 'ATO', 'HMF', 'PTČ', 'TwoCal', 'GGT', 'SUM', 'PNS', 'TGA', 'AAT', 'NAN', 'KOKIT', 'BSID', 'ATVR', 'IVA', 'PRES', 'MKZ', 'SHBG', 'CVT', 'IvIg', 'DHZ', 'KE', 'AVRT', 'ECMO', 'HOM', 'VCA', 'HRR', 'PEFa', 'SGA', 'YSR', 'ADPKD', 'ASO', 'DI', 'PACV', 'HCG', 'HbF', 'PEEP', 'FVII', 'MB', 'CTX', 'ZO', 'TORCH', 'KCNQ', 'GJB', 'cUMCG', 'antiXa', 'VM', 'PHA', 'eNo', 'LCH', 'FXII', 'SC', 'BA', 'DDDR', 'TCPC', 'KOOKITa', 'KCNH', 'IVRT', 'HBsAg', 'eNapotnico', 'SANO', 'TIPS', 'HIE', 'VVO', 'MAS', 'MC', 'SMN', 'SPECT', 'AVM', 'LAO', 'iPRO', 'GN', 'NIJZ', 'KOMRN', 'HA', 'RDW', 'ZTM', 'ADEM', 'COSS', 'SS', 'TČ', 'PU', 'TNFalfa', 'AAIR', 'ARPKD', 'FDG', 'HH', 'MEA', 'BNP', 'AT', 'HBs', 'CEUS', 'AMI', 'DC', 'UZRI', 'GOSH', 'PediaSure', 'EEGja', 'ONB', 'PI', 'OS', 'NEC', 'FGFR', 'APS', 'LCP', 'AET', 'PAAK', 'VTG', 'TPO', 'LC', 'ERCP', 'DTP', 'BabyLove', 'RB', 'PLE', 'ER', 'KOOKITu', 'LB', 'RMS', 'GI', 'BIC', 'VMS', 'IRS', 'CDG', 'KVK', 'MND', 'KNS', 'VNS', 'ASDja', 'PAS', 'DUN', 'AMS', 'UCD', 'FXIII', 'KIND', 'URH', 'OMS', 'VIT', 'VVŽ', 'CellCepta', 'PCDAI', 'UC', 'PMS', 'HUS', 'nCPAP', 'OspC', 'EK', 'PETCO', 'RAO', 'PNH', 'DiTe', 'LAL', 'HLAB', 'SAM', 'VTI', 'PCOS', 'EDTA', 'IF', 'mU', 'RSR', 'BioGaja', 'CLIA', 'STIR', 'ABPA', 'PPS', 'MRS', 'VR', 'BCPC', 'LO', 'HAV', 'UMCUG', 'HO', 'LQT', 'BioGaio', 'GAG', 'PCD', 'UK', 'MEN', 'HGMD', 'MCHC', 'FRC', 'BSK', 'VPD', 'PlivitD', 'GFR', 'ADH', 'MI', 'ZGNL', 'EMLO', 'SN', 'QuantiFERON', 'HHV', 'EURONET', 'CC', 'CVVHD', 'KAH', 'CNS', 'AU', 'PV', 'NIFTY', 'FODMAP', 'STH', 'TTE', 'HBS', 'UTI', 'NeoRecormon', 'HELLP', 'KidMel', 'WHO', 'ESWL', 'POST', 'XPhe', 'FASI', 'BW', 'MiBG', 'GTKK', 'CSF', 'TB', 'SŠ', 'DeMeester', 'CMAS', 'PEPom', 'TPP', 'MRU', 'IVH', 'LQTS', 'TX', 'VATS', 'FMF', 'BiPAP', 'DNET', 'CYP', 'CoAo', 'DHEAS', 'TCR', 'DHT', 'KOŽB', 'UV', 'ROP', 'DLR', 'LVPWd', 'BSO', 'JCV', 'EILO', 'MG', 'AZ', 'GLS', 'OKM', 'WAS', 'NM', 'TPMT', 'SiS', 'FAM', 'CRMO', 'CEPI', 'AFP', 'ATRA', 'MKL', 'WPPSI', 'CARD', 'SES', 'SUK', 'DiTePerPolioHiB', 'SPM', 'BT', 'PeKl', 'DEKA', 'aHUS', 'MDS', 'SUVma', 'HiPP', 'LQ', 'SAA', 'ALCAPA', 'PreNan', 'NHL', 'IPTH', 'VSL', 'FK', 'iCa', 'BECT', 'OŠPP', 'MECP', 'MMA', 'OGS', 'EpiPena', 'FerrumLek', 'iMLSb', 'FastCli', 'PTPN', 'CoA', 'TIR', 'XI', 'SAO', 'IPRO', 'OPD', 'VDD', 'VURa', 'ESPGHAN', 'IMT', 'PEI', 'PVCSS', 'NIk', 'IgD', 'PCA', 'DEKAS', 'OGT', 'PMP', 'VPA', 'LAVI', 'KOORMN', 'CRG', 'PL', 'MTF', 'MRSO', 'UJDW', 'KOOKIIT', 'KIKKB', 'CM', 'PTP', 'DAP', 'MA', 'PTLD', 'WAYA', 'VACTERL', 'JME', 'EKGja', 'NPHS', 'RIPA', 'HBA', 'BALa', 'DHEA', 'DIF', 'TLR']) 
    med_medicine1 = set(['Lercapress', 'Irinotekanijev klorid Kabi', 'Gardasil', 'Piperacilin/tazobaktam Kabi', 'Posakonazol AHCL', 'BELOSALIC', 'Coryol', 'PORTALAK', 'TRAVATAN', 'Ketoprofen Vitabalans', 
                        'Lotemax', 'Nozinan', 'Faktu', 'Crypineo', 'Diflazon', 'Metronidazol Braun', 'Leflunomid medac', 'Metoject', 'NUBEQA', 'Brimica Genuair', 'DOCETAKSEL KABI', 'Ebixa', 'Cipramil', 
                        'Nasonex', 'Celebrex', 'TAMIFLU', 'CERSON', 'PHEMITON', 'PENTAXIM prašek in suspenzija za suspenzijo za injiciranje v napolnjeni injekcijski brizgi', 'VARITECT CP', 'Prevenar', 'Gopten', 
                        'TOVIAZ', 'ACLASTA', 'Certican', 'Codilek Combo', 'Plaslyte raztopina za infundiranje', 'Piperacilin/tazobaktam Teva', 'Trelegy Ellipta', 'Estrofem', 'Linezolid Sandoz', 'Rytmonorm', 
                        'REKOVELLE', 'Anagrelid Teva', 'Aglurab', 'Tanyz', 'TRISENOX', 'Tavanic', 'Galafold', 'Epirubicin Teva', 'Duokopt', 'Dianeal PD', 'Dacogen', 'PAROGEN', 'Novistig', 'Simponi', 'Pynrip', 
                        'Angeliq', 'Prostin E', 'Otezla', 'Xigduo', 'ZINNAT', 'Bromergon', 'Kliogest', 'Bylvay', 'Kesimpta', 'iroprem', 'TREVICTA', 'Valoran', 'ISENTRESS', 'Pradaxa', 'Omnitrope', 'DELTACEF', 
                        'NEURONTIN', 'TOND SR', 'Amlopin', 'Ilaris', 'Busulfan Fresenius Kabi', 'Carivalan', 'Macropen', 'BERIPLAST P COMBI-SET', 'Xenazine', 'Reseligo', 'Calquence', 'Oncaspar', 
                        'Citalopram Vitabalans', 'Translarna', 'TYVERB', 'Ventavis', 'Sorel combo', 'ZINPLAVA', 'Truvada', 'Broncho-Munal', 'Bortezomib Actavis', 'Nimodipin Bayer', 'Anidulafungin Stada', 
                        'Ondansetron Accord', 'Humalog Mix', 'Bopacatin', 'Levofolic', 'Tivicay', 'Jivi', 'AZOLAR', 'Prenewel', 'Ampril HD', 'INVEGA', 'Triplixam', 'Kimoks', 'CHAMPIX', 'Lanitop', 
                        'Ceftriakson AptaPharma', 'REBETOL', 'INFANRIX HEXA prašek in suspenzija za suspenzijo za injiciranje', 'COAXIL', 'Gyno-Daktarin', 'REYATAZ', 'Rokuronijev bromid Kabi', 'Symtuza', 
                        'Granupas', 'Volulyte', 'BLINCYTO', 'Zolpidem Vitabalans', 'MAXIDEX', 'TEPADINA', 'Xofigo', 'Propoven', 'BETOPTIC S', 'Utrogestan', 'Palonosetron Accord', 'PROSTIDE', 'Gelaspan', 
                        'Tiotepa Riemser', 'Imipenem/cilastatin Kabi', 'Cerdelga', 'ADENURIC', 'HOLOXAN', 'Xtandi', 'LADIOMIL', 'Dotagraf', 'MOVIPREP prašek za peroralno raztopino', 'Aripiprazol Teva', 
                        'Febuksostat Teva', 'Sorafenib Teva', 'Flonidan', 'Skopryl HCT', 'Dimetilfumarat Mylan', 'Kventiax', 'Columvi', 'Yasnal', 'Yarina', 'Colobreathe', 'Olectan', 'Aprokam', 'Praxbind', 
                        'Erlotinib Teva B.V.', 'Sugamadeks Sandoz', 'CYKLOKAPRON', 'Atacand Plus', 'Balcoga', 'Pazenir', 'Harmonet', 'Calciumfolinat Ebewe', 'Prezista', 'Ropuido', 'Zoledronska kislina Mylan', 
                        'Spiriva Respimat', 'UTROGESTAN', 'Tibsovo', 'Metfogamma', 'Tadalafil Belupo', 'Duosol brez kalija raztopina za hemofiltracijo', 'CUROSURF', 'Zonisamid Sandoz', 'Rifater', 'Mozobil', 
                        'ALPROSTIN VR', 'Medaxone', 'Imatinib Teva', 'RAVICTI', 'Byol', 'Ceftriakson Lek', 'TAGRISSO', 'Escitalopram Teva', 'Imnovid', 'Ampril HL', 'Alecensa', 'Moksifloksacin STADA', 'RILUTEK', 
                        'METOTREKSAT MEDAC', 'Litalir', 'Vizarsin', 'Sugamadeks STADA', 'Berinert', 'Hulio', 'ANORO ELLIPTA', 'Mommox', 'Kytril', 'Amlodipin Alkaloid-INT', 'Zykadia', 'Amdut Combo', 'Ciprobay', 
                        'Cefazolin AptaPharma', 'Avodart', 'Vankomicin Mylan', 'MYDRIACYL', 'Fromilid uno', 'Glucovance', 'Azyter', 'Targretin', 'TOPAMAX', 'Jardiance', 'Bortezomib Teva', 
                        'Litijev karbonat Lekarna Ljubljana', 'Zinforo', 'Plivit D', 'Stivarga', 'Paracetamol Kabi', 'Trisequens filmsko obložene tablete', 'Fasenra', 'Arlevert', 'Androtop', 'Paklitaksel Sandoz', 
                        'Sirdalud', 'Cholib', 'Accofil', 'Meropenem AptaPharma', 'Cozaar', 'Janumet', 'PAMECIL', 'Priligy', 'Vaxzevria suspenzija za injiciranje', 'MacroBID', 'Lamictal', 'Linezolid Accord', 
                        'Pregabalin Krka', 'Neupro', 'Azibiot', 'Cefotaksim Apta', 'Selincro', 'XGEVA', 'PUREGON', 'CERVARIX suspenzija za injiciranje v napolnjeni injekcijski brizgi', 'Esketamin Kalceks', 
                        'Moksifloksacin Kabi', 'Ibandronska kislina Mylan', 'Venofer', 'Doksorubicin Teva', 'Ursofalk', 'Doxilek', 'Pregabalin Belupo', 'Cefotaksim AptaPharma', 'Olfen', 'Ciprinol', 'Rolpryna SR', 
                        'Signifor', 'GlucaGen HypoKit', 'Vankomicin Kabi', 'Kaspofungin STADA', 'EMADINE', 'Paracetamol Accord', 'Statriam', 'Mitomicin medac', 'Memantin Mylan', 'Jentadueto', 'Flixotide', 
                        'Lakozamid Accord', 'ReFacto AF', 'Teotard', 'Flukloksacilin Kabi', 'Entekavir Krka', 'Humira', 'Vankomicin AptaPharma', 'TIMOPTIC - XE', 'Voxin Combo', 'Hepatect CP', 'Enplerasa', 
                        'Decelex', 'NuvaRing', 'CYTOTEC', 'Gefitinib Krka', 'Betaferon', 'Taltz', 'Oxis Turbuhaler', 'ELIQUIS', 'Metamizol STADA', 'Fortum', 'Athyrazol', 'LUCENTIS', 'Votrient', 'TANYZ ERAS', 
                        'Humulin N', 'Diflucan', 'Requip-Modutab', 'Kventiax SR', 'AYVAKYT', 'Ocrevus', 'Bretaris Genuair', 'Humalog  Mix', 'Imatinib Accord', 'CANCIDAS', 'Ketokonazol HRA', 'KANJINTI', 
                        'Aldactone', 'Ibubel', 'VidPrevtyn Beta raztopina in emulzija za emulzijo za injiciranje', 'Tetraspan', 'Lamal', 'Kisqali', 'Solu-Medrol', 'Lecigon', 'Salofalk', 'Combivir', 'LESCOL XL', 
                        'Phoxilium', 'Kalcijev karbonat Lekarna Ljubljana', 'Talzenna', 'Elidel', 'Gonapeptyl', 'Lunsumio', 'VIGAMOX', 'NINLARO', 'Versatis', 'Rawel SR', 'Sclefic', 'Hidrasec za otroke', 
                        'TEMESTA', 'Abstral', 'LOTAR', 'Bixebra', 'Erivedge', 'Ecytara', 'Gazyvaro', 'Eylea', 'Faslodex', 'BeneFIX', 'Scandicaine', 'RISPERDAL', 'Imipenem/cilastatin Teva', 'MabThera', 'Zarzio', 
                        'Sevredol', 'TORISEL', 'SERETIDE DISKUS', 'CAREZA', 'Fludara', 'Teikoplanin AptaPharma', 'Epistatus', 'Glucophage', 'Avelox', 'BETADINE', 'Haloperidol Krka depo', 'VERMOX', 
                        'Azacitidin Mylan', 'NITRONAL', 'Rivotril', 'SPIRIVA', 'Donepezil Mylan', 'Erleada', 'Co-Diovan', 'SANDOSTATIN LAR', 'Dexamethason Krka', 'Remurel', 'EDRONAX', 'Ertapenem AptaPharma', 
                        'Myfortic', 'APO-go', 'ELOCTA', 'Humani Albumin CSL Behring', 'Sogroya', 'Dulsevia', 'Amjodaron hameln', 'Xospata', 'Mirena', 'Ofev', 'Tevagrastim', 'Amoksiklav SOLVO', 'ZAVEDOS', 
                        'Farydak', 'BONDRONAT', 'Heparin Braun', 'Activelle', 'AFLODERM', 'TRISPAN', 'Temodal', 'EISENSULFAT LOMAPHARM', 'Pentasa', 'Saflutan', 'BONVIVA', 'Lekoptin', 'Vosevi', 'Vemlidy', 
                        'Piqray', 'Fluoksetin Vitabalans', 'Cordarone', 'XYREM', 'Advagraf', 'BIOPREXANIL', 'PREDUCTAL MR', 'XANAX SR', 'Ospen', 
                        'Influvac Tetra suspenzija za injiciranje v napolnjeni injekcijski brizgi', 'Ecansya', 'EZETROL', 'Fendrix suspenzija za injiciranje', 'BELODERM', 'RELPAX', 'Remsima', 'REGLAN', 'Roxampex', 
                        'Scandonest', 'VFEND', 'ZOLOFT', 'Lamisil', 'Dovato', 'Ospamox', 
                        'Bortezomib Accord', 'Betmiga', 'Lantus SoloStar', 'Prograf', 'LEGOFER', 'Roferon-A', 'Mekinist', 'Omnic Ocas', 'Gadovist', 'Melfalan Teva', 'Ponvory', 'Ampril', 'Tomalon', 
                        'Ceftazidim Kabi', 'Hemosol B', 'VOLUVEN', 'Irinotekanijev klorid Mylan', 'Softacort', 'Ceftazidim Mylan', 'Epufen', 'Cerazette', 'Belakne', 'Evrysdi', 'Rustavo', 'Fulvestrant Teva', 
                        'Pulmicort Turbuhaler', 'Voxin', 'Refixia', 'Stayveer', 'PREVYMIS', 'Kineret', 'Levemir', 'MVASI', 'Jinarc', 'MAVENCLAD', 'Steglatro', 'Vargatef', 'Vectibix', 'Pantoprazol Teva', 
                        'Kvelux', 'NORVIR', 'Omacor', 'Mycamine', 'MINIMS CYCLOPENTOLATE HYDROCHLORIDE', 'Frotan', 'ZAVESCA', 'Entekavir STADA', 'NovoRapid Penfill', 'Bydureon', 'Baklofen Sintetica', 'EPOSIN', 
                        'Tysabri', 'Rixathon', 'Trittico', 'Miktan', 'TachoSil matriks z lepilom za tkiva', 'ABILIFY', 'TARCEVA', 'ORENCIA', 'Bikalutamid Lek', 'Olicef', 'Emtricitabin/dizoproksiltenofovirat Krka', 
                        'Wamlox', 'NovoEight', 'Miktan Combi', 'INSULATARD FlexPen', 'RUDAKOL', 'Fampyra', 'Minirin Melt', 'HYPNOMIDATE', 'Fludarabin Teva', 'Atoris', 'Cimzia', 'Soliris', 'Amoksiklav', 'ZEFFIX', 
                        'Aspirin protect', 'Zanetin', 'Leptoprol', 'Spectrila', 'Metycor', 'Nocdurna', 'Amyzol', 'Kerendia', 'Herceptin', 'Moditen', 'Skyrizi', 'CellCept', 'Propranolol Lek', 'Dexdor', 'REZOLSTA', 
                        'Primotren', 'PROPAFENON ALKALOID-INT', 'Yuflyma', 'Clexane', 'Topotekan Accord', 'Advantan', 'Revolade', 'Zelboraf', 'Micardis', 'Leponex', 'Posakonazol STADA', 'Nolicin', 'VELCADE', 
                        'Olanzapin Teva', 'Forxiga', 'LYRICA', 'RotaTeq peroralna raztopina', 'Kaletra', 'SPRYCEL', 'Tresiba', 'KAPTOPRIL ALKALOID-INT', 'Jakavi', 'Brufen retard', 'CIALIS', 'Haloperidol Krka', 
                        'Entekavir Sandoz', 'Neulasta', 'CYMBALTA', 'Pemetreksed Sandoz', 'IBRANCE', 'Ultibro Breezhaler', 'SULPIRID BELUPO', 'Zaracet', 'Kalijev klorid Lekarna Ljubljana', 'Entresto', 
                        'Deksmedetomidin Teva', 'VEGZELMA', 'Benlysta', 'Paklitaksel Kabi', 'Actonel', 'Cezera', 'Lynparza', 'Privigen', 'Nillar', 'Cayston', 'JCOVDEN suspenzija za injiciranje', 'Azacitidine Accord', 
                        'Brintellix', 'Ferant', 'Akynzeo', 'DUAVIVE', 'Erlotinib Krka', 'IMIGRAN SPRINT', 'ARCOXIA', 'Prenessa', 'Etopozid Accord', 'Pulmozyme', 'Citalon', 'Ilomedin', 
                        'Geloplasma raztopina za infundiranje', 'Arixtra', 'Ymana', 'Odefsey', 'Emozul', 'CRESEMBA', 'Combigan', 'Ferrum Lek', 'Roxiper', 'X-PREP-', 'CEFZIL', 'Ganfort', 'Venclyxto', 'Aromasin', 
                        'Anaton', 'Metotreksat Ebewe', 'Virolex', 'Abirateron Accord', 'Bimzelx', 'XANAX', 'Deksmedetomidin EVER Pharma', 'Liten HCT', 'ALPHA D', 'YAZ', 'IMFINZI', 'Volibris', 'Razagilin Belupo', 
                        'Dobutamin Hameln', 'Humalog', 'Kornam', 'Bupropion Teva', 'Helex', 'DOSTINEX', 'Latanox', 'KARBOX', 'AVONEX', 'ANDROTOP', 'Sorvitimb', 'ENGERIX-B', 'TYGACIL', 'Ricefan', 'Xarelto', 'XELJANZ', 
                        'Menopur', 'VYEPTI', 'Gribero', 'Leqvio', 'Levosimendan Orion', 'XALACOM', 'MOVALIS', 'BUPRENORFIN ALKALOID-INT', 'Dupixent', 'KOGENATE BAYER', 'Spiolto Respimat', 'Galvus', 'Perivol Combo', 
                        'Eporatio', 'Repaglinid STADA', 'Viread', 'ULTRACAIN D-S', 'Kivexa', 'Koselugo', 'CABOMETYX', 'Irinotekan Accord', 'Glypressin', 'HYZAAR', 'Synjardy', 'Temozolomid Accord', 'Dasatinib Krka', 
                        'Flukloksacilin Altamedics', 'IVEMEND', 'Kvelux SR', 'Candecombi', 'Efloran', 'FRAXIPARINE FORTE', 'CRYSVITA', 'Kevzara', 'EXELON', 'NovoSeven', 'Diclo Duo', 'CIRCADIN', 'Opatanol', 'Zyvoxid', 
                        'Flosteron', 'Asolfena', 'Belogent', 'Adimuplan', 'Kamiren XL', 'Tramadol/paracetamol Teva', 'Amaryl', 'Matever', 'Tadilecto', 'Polivy', 'Duosol z', 'Ibuprofen Vitabalans', 'Arimidex', 
                        'Eligard', 'XALKORI', 'Duloksetin Sandoz', 'Bocouture', 'Dormicum', 'Tensiol', 'Sulfesa', 'Adempas', 'CLOPEZ', 'Sevorane', 'Modigraf', 'Vimpat', 'Relvar Ellipta', 'DYSPORT', 'Pelgraz', 
                        'TRITACE', 'AVAMYS', 'IntronA', 'Furosemid hameln', 'Mydrane', 'RAPAMUNE', 'Briviact', 'Betaklav', 'Emtricitabin/dizoproksiltenofovirat Teva', 'Gliclada', 'Enhertu', 'Zyclara', 'Targocid', 
                        'ONIVYDE pegylated liposomal', 'Busilvex', 'NovoRapid PumpCart', 'INFANRIX - IPV + Hib prašek in suspenzija za suspenzijo za injiciranje', 'XEOMIN', 'Movymia', 'Nimvastid', 'Tetanol pur', 
                        'Actrapid Penfill', 'Kyprolis', 'THYROGEN', 'Nplate', 'Abraxane', 'Enap', 'Cosentyx', 'FODISS', 'CUBICIN', 'Brufen', 'Evoltra', 'MIDZA', 'Biphozyl raztopina za hemodializo/hemofiltracijo', 
                        'Sildenafil Stada', 'Ultop', 'CONCERTA', 'MINIRIN', 'Daxas', 'Senlor', 'Moxogamma', 'Ziextenzo', 'Cablivi', 'KEYTRUDA', 'Metformin Vitabalans', 'Aranesp', 'Ketanest', 'DALACIN', 'NovoNorm', 
                        'Lidokain Kabi', 'Moloxin', 'Pegasys', 'PREXANIL', 'Haemate P', 'Tadalafil Lek', 'Oyavas', 'DIFICLIR', 'Kapecitabin Accord', 'Zaditen SDU', 'Aloxi', 'AVASTIN', 'Monofer', 'Erelzi', 'Lonquex', 
                        'Jaydess', 'Ebrantil', 'Irinotekan Teva', 'STELARA', 'SOMATULINE Autogel', 'Regiocit raztopina za hemofiltracijo', 'Noradrenalin Kabi', 'TertensifKomb', 'Kadcyla', 'CRESTOR', 'Lacidipin Teva', 
                        'Taxotere', 'ZYPREXA', 'Aripiprazol Sandoz', 'Myozyme', 'Sorvasta', 'DIACLAZID', 'Cotellic', 'Airflusan Forspiro', 'WELLBUTRIN XR', 'DAUNOBLASTINA', 'EPIRUBICIN EBEWE', 'MST CONTINUS', 
                        'Giotrif', 'Ultomiris', 'Trazimera', 'Combodart', 'Epclusa', 'Fastum', 'BOTOX', 'Ibuprofen Braun', 'Livial', 'Penthrox', 'Benmak', 'Ropivakainijev klorid Kabi', 'Anidulafungin Teva', 
                        'Valdiocef', 'KALCIJEV GLUKONAT BRAUN', 'Bimanox', 'Epipen', 'Suliqua', 'Betaserc', 'Memaxa', 'Vorikonazol Fresenius Kabi', 'Scemblix', 'Sandostatin', 'Verzenios', 'Roteas', 
                        'Posakonazol Accord', 'Ortanol', 'Esperoct', 'Entyvio', 'ESMERON', 'HUMIRA', 'Gemcitabin Kabi', 'Defitelio', 'ZYKALOR', 'Diprogenta', 'RISEDORA', 'CILOXAN', 'Ezoleta', 'ANALGIN', 'Nadexam'])                 
    med_medicine2 = set(['Heptanon', 'Inspra', 'Oktreotid Teva', 'Dortilla', 'Eliskardia', 'Alventa', 'SOMAVERT', 'Neodolpasse', 'BIOPREXANIL COMBI', 'Amlessa', 'Coxeta', 'Carvedigamma', 'MYLOTARG', 'XELODA', 'Ozempic', 
                        'Bendamustin Kabi', 'Bendamustin Accord', 'PALEXIA SR', 'Oksaliplatin Sandoz', 'Esbriet', 'Maviret', 'Nitrolingual', 'Foster', 'Palonosetron Sandoz', 'Parnido', 'MIRCERA', 'Onbrez Breezhaler', 
                        'BERODUAL N', 'Lysodren', 'Bloxan', 'Coupet', 'Apidra', 'Docetaksel Accord', 'AZOPT', 'Lecalpin', 'Strattera', 'Valsacor', 'Lorista', 'Vorikonazol Sandoz', 'Clopixol-Acuphase', 'ARAVA', 
                        'Humulin R', 'REMINYL', 'Zercepac', 'Kalcijev karbonat Krka', 'Symbicort', 'BIXODALAN', 'Sylvant', 'Diuver', 'Hexvix', 'CAELYX pegylated liposomal', 'Finpros', 'PALLADONE', 'Rivastigmin Teva', 
                        'Diovan', 'OPDIVO', 'Vesomni', 'Anexate', 'Bisolvon', 'Adalat OROS', 'Ertapenem Fresenius Kabi', 'Vyxeos liposomal', 'PANSEMYL', 'Trumenba suspenzija za injiciranje v napolnjeni injekcijski brizgi', 
                        'Anidulafungin Fresenius Kabi', 'Extraneal', 'Telmisartan Actavis', 'Ravalsyo', 'Bivalirudin Accord', 'Claritine', 'Valcyte', 'Nolpaza', 'LEXILIUM', 'Posakonazol Teva', 'DuoTrav', 'Elreptic', 
                        'Kaspofungin Teva', 'Paliperidon Teva', 'DicloJet', 'Vesicare', 'ZYKLOLAT EDO', 'Carboplatin Ebewe', 'Fasturtec', 'Androcur', 'Viavardis', 'Nephrotrans', 'PENTAGLOBIN', 'Qutenza', 'Meaxin', 
                        'Darunavir Krka', 'Xadago', 'Glucobay', 'Actelsar HCT', 'Naklofen SR', 'Pentilin', 'Rydapt', 'Aprovel', 'Rebif', 'Zolrix', 'Logest', 'Chirocaine', 'Vyndaqel', 'PALEXIA', 'Orkambi', 'Tonocardin', 
                        'Olumiant', 'Twynsta', 'Candea HCT', 'XYLONOR', 'GLUCOPHAGE', 'Lorista HD', 'Bilador', 'ENGERIX-B za otroke', 'DACARBAZINE LIPOMED', 'Lyxumia', 'Candea', 'Perindopril Teva', 'GENOTROPIN', 'EVUSHELD', 
                        'Akineton', 'Esomeprazol STADA', 'Tolura', 'Paracetamol B. Braun', 'Bridion', 'Asentra', 'NOLIPREL', 'Lanzul', 'NEXAVAR', 'PROSTIN E', 'Tafinlar', 'Nucala', 'FORTZAAR', 'Duosol s', 'Zirabev', 
                        'Roaccutane', 'Brilique', 'Simbrinza', 'Diprosalic', 'Ovixan', 'Kaftrio', 'PROCORALAN', 'Megalotect', 'ATACAND', 'PRAZINE', 'Dopamin Fresenius', 'Jorveza', 'SEROXAT', 'Physioneal', 'Fluzepam', 
                        'ZOSTAVAX prašek', 'Dutamyz', 'Tametil', 'FABRAZYME', 'METADONIJEV KLORID ALKALOID-INT', 'REMODULIN', 'Pregabalin Sandoz GmbH', 
                        'Seldiar', 'Perindopril amlodipin STADA', 'Rocaltrol', 'Anidulafungin Accord', 'LUMYKRAS', 'Intratect', 'EXJADE', 'Darob mite', 'Loquen SR', 'Braunoderm z barvilom', 'STOCRIN', 'Skinoren', 'FSME IMMUN', 
                        'Pregabalin Accord', 'Dutrex Combo', 'AZARGA', 'BOREZ', 'Cisplatin Accord', 'Benfotiamin Wörwag Pharma', 'Vidaza', 'Eptifibatid Accord', 'Hukyndra', 'CIPRALEX', 'ALPROLIX', 'Hidrokortizon Altamedics', 
                        'Bosulif', 'PREPIDIL', 'Efient', 'Caprelsa', 'BERIRAB P', 'Verquvo', 'Ambroksolijev klorid Berlin-Chemie', 'Oksaliplatin Teva', 'RXULTI', 'Oleovit D', 'Cefamezin', 'MSI MUNDIPHARMA', 'Comirnaty', 
                        'Dermazin', 'Marbodin', 'Abevmy', 'Ganaxa', 'Sugamadeks Orion', 'Amcandin', 'Votubia', 'Piramil H', 'Zalna', 'PROSTIN', 'Pergoveris', 'Kengrexal', 'Zaldiar', 'Visudyne', 'Triumeq', 'Hiconcil', 'Kreon', 
                        'Xapimant', 'Fintepla', 'Relenza', 'Temozolomide Teva', 'Amlodipin Vitabalans', 'Dexamono', 'Agnis', 'Tractocile', 'Humatrope', 'Natrijev klorid Baxter', 'Sorel', 'Linezolid Kabi', 'Aripiprazol STADA', 
                        'LITAK', 'Sevofluran Baxter', 'Neupogen', 'SKOPRYL', 'Perluna', 'DuoResp Spiromax', 'Entekavir Teva', 'Aubagio', 'Razagilin STADA', 'Pemetreksed Accord', 'Tetagam P', 'LEKADOL', 'Eprocliv', 'Genvoya', 
                        'ENDOXAN', 'Ibandronska kislina Teva', 'SOLU-CORTEF', 'Byetta', 'Monopost', 'Benepali', 'Amiokordin', 'BUSCOPAN', 'Yasminelle', 'RINVOQ', 'Cordipin retard', 'Pregabalin STADA Arzneimittel', 
                        'Efavirenz Teva', 'Abuxar', 'NovoRapid FlexPen', 'OxyNorm', 'Enalapril Vitabalans', 'Vocabria', 'Incruse Ellipta', 'HAVRIX', 'FLIXOTIDE DISKUS', 'Pregabalin Teva', 'Palonosetron STADA', 
                        'Priorix-Tetra prašek', 'Juluca', 'Tenox', 'Fluanxol', 'VARIVAX prašek', 
                        'Namuscla', 'VALTREX', 'FOLKODIN ALKALOID-INT', 'Lemtrada', 'Cyramza', 'BIONOLIPREL', 'Mysimba', 'ALENAX', 'SINGULAIR', 'Test Helicobacter INFAI', 'Cetrotide', 'Tasigna', 'Budiair', 'Cisof', 'Tramundin', 
                        'SPORANOX', 'Somatostatin Eumedica', 'Rozamet', 'Cosyrel', 'Mestinon', 'Flixabi', 'Dutasterid STADA', 'Norditropin FlexPro', 'Rhophylac', 'Vabysmo', 'octaplasLG', 'FRAXIPARINE', 'Braunol', 'Tacforius', 
                        'Transtec', 'Fetcroja', 'Iclusig', 'Pemetreksed Krka', 'Epipen za otroke', 'Iruzid', 'Stediril-m', 'Glucotrol XL', 'Budelin Novolizer', 'Torecan', 'Mayzent', 'Zessly', 'Copaxone', 'Rybelsus', 'ERBITUX', 
                        'Dectova', 'Brediwal', 'LANITOP', 'AmBisome liposomal', 'SUMAMED za otroke', 'AZILECT', 'Tremfya', 'VITRAKVI', 'ALDIZEM', 'Rifinah', 'Matrifen', 'Tigeciklin Sandoz', 'Spedra', 'Bizmutov oksid Krka', 
                        'Lorista H', 'Myfenax', 'Bleomicin medac', 'Co-Nebilet', 'Etorikoksib STADA', 'Vizimpro', 'Donepezil Pliva', 'PAROXAT', 'Diane', 'Vinorelbin Teva', 'EVRA', 'Nalgesin forte', 'ORMIDOL', 'Zolgensma', 
                        'Gliklazid STADA', 'GLURENORM', 'TRUSOPT', 'Alopurinol Sandoz', 'Harvoni', 'Inflectra', 'ZELDOX', 'Visanne', 'Serevent', 'Nutrineal PD', 'NeoRecormon', 'Crinone', 'DUROGESIC', 'Karmustin Teva', 'Zometa', 
                        'Siofor SR', 'Concor COR', 'Levofloksacin Kabi', 'Klofarabin Makpharm', 'Atimos', 'Baqsimi', 'Rokuronijev bromid hameln', 'LACRYVISC', 'Pamorelin', 'Megace', 'Opsumit', 'TUKYSA', 'NEBIDO', 'ABASAGLAR', 
                        'Deksametazon Kabi', 'Ramelso', 'FIRMAGON', 'Levetiracetam Teva', 'TORNETIS', 'MULTAQ', 'Makrocef', 'GLIVEC', 'Razagilin Sandoz', 'BETOPTIC', 'Fragmin', 'Zoledronska kislina Fresenius Kabi', 'TAXOTERE', 
                        'DEPO PROVERA', 'Insulatard Penfill', 'Granisetron Lek', 'Cefuroksim AptaPharma', 'Rozlytrek', 'Lenalidomid Sandoz', 'ALIMTA', 'Zydelig', 'Vankomicin Mylan Pharma', 'Zolmitriptan Teva', 'Idarubicin Accord', 
                        'DABROSTON', 'Elyrno', 'Sugamadeks Mylan', 'Mixtard', 'Encepur za otroke', 'Mimpara', 'Zaditen', 'Budenofalk', 'Pifeltro', 'Malarone', 'Uptravi', 'EMEND', 'LENVIMA', 'Noradrenalin Sintetica', 'Vagifem', 
                        'Beloderm', 'MINULET', 'Docetaksel Sandoz', 'Kuterid genta', 'Estring', 'Sivextro', 'Elonva', 'Sunitinib Teva', 'Cefuroksim Alkaloid-Int', 'Roticox', 'Savene', 'ZEPATIER', 'Flutiform', 'Madopar', 'Reblozyl', 
                        'Lopacut', 'NULOJIX', 'Migard', 'Codilek', 'RELISTOR', 'Synflorix suspenzija', 'Rokuronijev bromid Braun', 'Amlodipin Lek', 'FOSAVANCE', 'Conjuncain EDO', 
                        'Amikacin Kabi', 'Aprepitant Teva', 'Vankomicin Apta', 'Sobycor', 'Perjeta', 'KODEINIJEV FOSFAT ALKALOID-INT', 'Tonocardin SR', 'Oksaliplatin Kabi', 'TEGRETOL CR', 'OKSAZEPAM BELUPO', 'Torendo', 'Kenalog', 
                        'NEVANAC', 'Lentrica', 'AMGEVITA', 'Prolia', 'Hidrasec za dojenčke', 'CINQAERO', 'JEVTANA', 'Imraldi', 'Casodex', 'Premovir', 'Linezolid Krka', 'Talidomid Accord', 'OZURDEX', 'Septanestepi', 'Fromilid', 
                        'Binocrit', 'ALOPURINOL BELUPO', 'Sutent', 'Medrol', 'IBUPROFEN BELUPO', 'Clopixol Depot', 'Tulip', 'Levobupivakain Kabi', 'Altasomil', 'Fenistil', 'Lestedon', 'Tadalafil AOP Orphan', 'Lenalidomide Accord', 
                        'Bulnexo', 'Tafen nasal', 'Paclitaxin', 'Boostrix suspenzija', 'Rapiscan', 'Zemplar', 'Trodelvy', 'HAEMOCOMPLETTAN  P', 'INEGY', 'Fenilefrin Sintetica',
                        'Nakom mite', 'PRESTANCE', 'Sovaldi', 'Spasmex', 'LOMUSTINE MEDAC', 'Zolsana', 'Tenzopril', 'Cefepim Kabi', 'Metamizol Stada', 'Xyzal', 'Dicuno', 'Pelmeg', 'Terebyo', 'Lexaurin', 'Ongentys', 'Seroquel SR', 
                        'Noxafil', 'Seebri Breezhaler', 'MicardisPlus', 'Sevelamer Lek', 'Byfavo', 'EDURANT', 'Levetiracetam Accord', 'LIDOCAINE BRAUN', 'Hemlibra', 'Mirtazapin Mylan', 'Betrion', 'Peyona', 'Inotop', 'Monopril Plus', 
                        'AERIUS', 'GIAPREZA', 'elmiron', 'Ronapreve', 'Tardyferon', 'Zoladex', 'Envarsus', 'Nootropil', 'Xerava', 'Foster NEXThaler', 'Galsya SR', 'Doreta', 'Zerbaxa', 'Armisarte', 'Eviplera', 'Parsabiv', 'Ivabradin Mylan', 
                        'Victoza', 'Cetixin', 'Steglujan', 'AJOVY', 'Tramal', 'Acipan', 'SINVACOR FORTE', 'DULCOLAX', 'Phesgo', 'Pergoveris', 'Etopozid Kabi', 'PREZISTA', 'Telassmo', 'Baraclude', 'ZALTRAP', 'Lakozamid Teva', 
                        'Sugamadeks Pharmazac', 'Xaluprine', 'Kvetiapin Accord', 'Pravastatin Teva', 'DIPHERELINE', 'Enap-HL', 'Inlyta', 'Flukonazol Braun', 'Tenzopril HCT', 'Alunbrig', 'Oksikodon Vitabalans', 'Memantin Accord', 
                        'PROPECIA', 'Azacitidin Sandoz', 'Tecfidera', 'Vasilip', 'Anagrelid STADA', 'Elderin', 'Atifan', 'Retsevmo', 'OxyContin', 'EUCREAS', 'Lorsilan', 'Targinact', 'SINVACOR', 'Xiapex', 'Biktarvy', 
                        'Pemetreksed Fresenius Kabi', 'Viekirax', 'Detrusitol', 'Raxone', 'COSOPT', 'EGLONYL', 'Concor', 'COSOPT brez konzervansa', 'Fentanil Torrex', 'Piperacilin/tazobaktam Mylan', 'Daonil', 'Trimbow', 'Daleron', 
                        'Qlaira filmsko obložene tablete', 'Naclof', 'Telfast', 'Xalatan', 'Skudexa', 'Evrenzo', 'Actrapid', 'Primovist', 'Dymista', 'Kalinor', 'TOBREX', 'Gemcitabin Teva', 'Talidomid BMS', 'Kalijev jodid Lek', 
                        'ZYTIGA', 'Albunorm', 'M-M-RVAXPRO prašek', 'Irumed', 'Seroquel', 'CoAprovel', 'Quinsair', 'Nimotop', 'Lodoz', 
                        'ROTARIX peroralna suspenzija', 'Nebilet', 'Ampicilin/sulbaktam AptaPharma', 'Spinraza', 'Letizen', 'EXFORGE HCT', 'Primolut Nor', 'Sildenafil Teva', 'Naprosyn'])                     
    med_medicine3 = set(['BELFIL', 'Entecavir Accord', 'Fulvestrant AptaPharma', 'RoActemra', 'Kovaltry', 'Rispolux', 'DEPO-MEDROL', 'Nyxoid', 'Xolair', 'INTEGRILIN', 'Synagis', 'INVANZ', 'Mikafungin Teva', 'Fulvestrant Lek', 
                        'Symbicort Turbuhaler', 'Atgam', 'ABILIFY MAINTENA', 'VIAGRA', 'Exviera', 'Plenvu prašek za peroralno raztopino', 'GONAL-f', 'TOBI Podhaler', 'Taptiqom', 'Levetiracetam SUN', 'KANUMA', 'Nexium', 'Monopril', 
                        'Lenalidomid Teva', 'Lorviqua', 'Doloproct', 'Bavencio', 'Tapidola', 'Sandimmun', 'Rybrevant', 'STAVRA', 'Kuterid', 'Imipenem/Cilastatin AptaPharma', 'Valganciklovir Stada', 'Agnis Combi', 'Gavreto', 
                        'CARDURA XL', 'Deksametazon Krka', 'Amdut', 'MIRAPEXIN', 'Sulfasalazin Krka', 'Zoledronska kislina Accord', 'Ranital', 'Karboplatin medac', 'Naklofen', 'Meropenem Teva', 'Palonosetron Fresenius Kabi', 
                        'Revlimid', 'Naramig', 'Tecentriq', 'Emgality', 'Tadol', 'Tramadol Vitabalans', 'ZYPREXA VELOTAB', 'OVITRELLE', 'Zyllt', 'Toctino', 'Ultravist', 'Syntocinon', 'CYTOTECT CP BIOTEST', 'IMIGRAN', 'Cardiopirin', 
                        'Ogivri', 'Haldol', 'Descovy', 'ORGALUTRAN', 'Zofran', 'Prismasol', 'Fingolimod Teva', 'Perodilam', 'Meropenem Kabi', 'Januvia', 'Tasmar', 'Actilyse', 'Thymoglobuline', 'Kapecitabin Teva', 'Controloc', 
                        'Kyleena', 'FLAREX', 'Idacio', 'SUBSTITOL', 'Valdoxan', 'Talcid', 'MAXITROL', 'XIFAXAN', 'Ibuprofen Belupo', 'Revatio', 'Tolucombi', 'Doreta SR', 'Bionoliprel', 'Moditen depo', 'ROZOR', 'Delstrigo', 
                        'Trecondi', 'Kamiren', 'Epivir', 'Hyrimoz', 'Toujeo', 'Enbrel', 'REMICADE', 'Renvela', 'Solian', 'Clopixol', 'Pantoprazol AptaPharma', 'EXFORGE', 'Siofor', 'Olectan HCT', 'Abirateron Mylan', 'Euthyrox', 
                        'Trulicity', 'Forsteo', 'Bivacyn', 'GILENYA', 'Mifegyne', 'Duloksetin Mylan', 'Ceftazidim AptaPharma', 'Alvesco', 'Berodual', 'NOLIPREL FORTE', 'Doksivibra', 'Bortezomib Mylan', 'Telmisartan Lek', 'Dasselta', 
                        'ZYPADHERA', 'ALCAINE', 'Yellox', 'Co-Tensiol', 'Fixalpost', 'Aurorix', 'Azitromicin Lek', 'Lotriderm', 'NEOTIGASON', 'ENAP-H', 'Setlona', 'Plavix', 'Kalcijev folinat Sandoz', 'Repatha', 
                        'Insuman Basal SoloStar', 'TERTENSIF SR', 'Plegridy', 'REQUIP', 'Aldara', 'Sortis', 'SUMAMED', 'EPREX', 'TEGRETOL', 'Encepur za odrasle', 'IKERVIS', 'Edemid', 'Doksorubicin Accord', 'Propofol-Lipuro', 
                        'Naklofen duo', 'Agomelatin Teva', 'Zinacef', 'Pixuvri', 'Aripiprazol Accord', 'LUMIGAN', 'Midazolam Braun', 'Mirzaten', 'Sanval', 'EFECTIN ER', 'Ursosan', 'RUBISEPT', 'Aimovig', 'Apaurin', 'Lokelma', 
                        'Metadon Krka', 'KEPPRA', 'KALIJEV KLORID JADRAN', 'Edicin', 'Ducressa', 'Vorikonazol Accordpharma', 'Hexacima suspenzija za injiciranje v napolnjeni injekcijski brizgi', 'POTELIGEO', 'Elocom', 
                        'ETOMIDAT-LIPURO', 'BCG-medac prašek in vehikel za suspenzijo za intravezikalno uporabo', 'Katalip', 'Padcev', 'Dilatrend', 'Klimicin', 'Lasix', 'BRAMITOB', 'IRESSA', 'Xultophy', 'DIAPREL MR', 'Tarka', 
                        'Norditropin SimpleXx', 'Segluromet', 'Humulin N KwikPen', 'Celsentri', 'RISPERDAL CONSTA', 'Piramil', 'Rokuronijev bromid Kalceks', 'Aryzalera', 'Duodopa', 'Afinitor', 'Loquen', 
                        'VaxigripTetra suspenzija za injiciranje v napolnjeni injekcijski brizgi', 'Slenyto', 'Citafort', 'Myocet liposomal', 'ADCETRIS', 'Beriplex P/N', 'Nimenrix prašek', 
                        'LEVITRA', 'Torendo Q-Tab', 'HALAVEN', 'Valsaden', 'Ontruzant', 'Humulin M', 'Doloris', 'Garamycin', 'Td-pur suspenzija za injiciranje', 'Simvastatin Lek', 'Cutticom', 'Atriance', 'MORFIN Alkaloid-INT', 
                        'Besponsa', 'BEKEMV', 'Alymsys', 'TRAJENTA', 'Nolvadex', 'TWINRIX za odrasle suspenzija za injiciranje', 'Monkasta', 'ZEPILEN', 'FLIXONASE', 'Midazolam Accord', 'Vepesid', 'ARICEPT', 'CIAMBRA', 'Angusta', 
                        'DARZALEX', 'Asmanex Twisthaler', 'Recarbrio', 'Distraneurin', 'Valtricom', 'TRITAZIDE', 'Novofem filmsko obložene tablete', 'SABRIL', 'Cyclo-Progynova obložene tablete', 'Kalydeco', 'Praluent', 'Voltaren', 
                        'Pneumovax', 'REKAMBYS', 'Inovelon', 'MONOSAN', 'XEPLION', 'Grafalon', 'Stalevo', 'Okskarbazepin STADA', 'Ivabradin STADA', 'Zavicefta', 'Depakine chrono', 'Yervoy', 'Adolax', 'Cerezyme', 'Beovu', 
                        'Midazolam Lek', 'TAMLOS', 'Ceclor', 'Lonsurf', 'SERETIDE', 'Suprarenin', 'Bikalutamid Teva', 'Rozor', 'Eplerenon STADA', 'Kybernin P', 'Alezaxin', 'Sandimmun Neoral', 'NovoMix', 'PRIORIX prašek', 
                        'Braunoderm', 'ACTILYSE CATHFLO', 'Atorvastatin Stada Arzneimittel', 'Bexsero suspenzija za injiciranje v napolnjeni injekcijski brizgi', 'Latuda', 'SIMULECT', 'Ecalta', 'Fiasp', 'Amlessini', 'ZIAGEN', 
                        'Lartruvo', 'Vinorelbin Accord', 'Folacin', 'Imbruvica', 'Eliquis', 'KETESSE', 'Budezonid Ferring', 'Bortezomib Sandoz', 'Vorikonazol Accord', 'Femara', 'Nakom', 'Fluorouracil Accord', 'VISTABEL', 'VENTOLIN', 
                        'Anagrelid Sandoz', 'Gliolan', 'OLICARD', 'TOBRADEX', 'Gentamicin Braun', 'Truxima', 'Amoksicilin/klavulanska kislina AptaPharma', 'Glukoza Baxter', 'PANCEF', 'Ranexa', 'Pantoprazol Apta', 'VIRGAN', 
                        'Risset', 'Amlewel', 'URUTAL', 'Indometacin Belupo', 'LACIPIL', 'CYTOSAR', 'Olivin', 'Stugeron', 'Cordipin XL', 'Orfadin', 'Ketonal', 'Caverject', 'Azafalk', 'Ropivakain Readyfusor'])

class SessionMetadata:
    def __init__(self, initiator=None, type=None, session_name=None, session_notes=None):
        self.initiator = initiator # external, user
        self.type = type # normal, note-taking, dictaphone
        self.session_name = session_name # name of the session - only given via external commands
        self.session_notes = session_notes # notes for the session - only given via external commands

class MedSyntaxHighlighter(QSyntaxHighlighter):
    def __init__(self, parent=None):
        super().__init__(parent)
        self.is_highlighting_enabled = False
        self.highlighting_rules = [
            (rf'\b({"|".join(MedConstants.med_units)})\b', self.create_format(Qt.blue), False),
            (rf'\b({"|".join(MedConstants.med_acronyms)})\b', self.create_format(Qt.darkRed), False),
            #(rf'\b({"|".join(MedConstants.med_medicine1)})\b', self.create_format(Qt.white, Qt.darkGreen), True),
            #(rf'\b({"|".join(MedConstants.med_medicine2)})\b', self.create_format(Qt.white, Qt.darkGreen), True),
            #(rf'\b({"|".join(MedConstants.med_medicine3)})\b', self.create_format(Qt.white, Qt.darkGreen), True),
            #('\s[A-ZŠČĆŽĐ]+\b', self.create_format(Qt.white, Qt.darkGreen), True),
            #(r'\b[A-ZŠČĆŽĐ][a-zščćžđ\d–]+\b', self.create_format(Qt.darkGreen), False),
            (r'\b\d+\b', self.create_format(Qt.blue), False),
            (r'\{.*\}', self.create_format(Qt.black, Qt.lightGray), False),
            (r'\*\*\*\sOPOMBE\s\*\*\*', self.create_format(Qt.white, Qt.black), False),
        ]

    def create_format(self, foreground_color, background_color=None):
        char_format = QTextCharFormat()
        char_format.setForeground(foreground_color)
        if background_color:
            char_format.setBackground(background_color)
        return char_format

    def highlightBlock(self, text):
        if self.is_highlighting_enabled:
            for pattern, char_format, ignore_case in self.highlighting_rules:
                if ignore_case:
                    expression = QRegExp(pattern, Qt.CaseInsensitive)
                else:
                    expression = QRegExp(pattern)
                index = expression.indexIn(text)
                while index >= 0:
                    length = expression.matchedLength()
                    self.setFormat(index, length, char_format)
                    index = expression.indexIn(text, index + length)

class NoSpaceValidator(QValidator):
    """
    Implements Validator for input fields that require no space inputs 
    """
    def validate(self, input_str, pos):
        if ' ' in input_str:
            return (QValidator.Invalid, input_str, pos)
        return (QValidator.Acceptable, input_str, pos)

class WorkerSignals(QObject):
    """
    Defines the signals available from a running worker thread.
    Supported signals are:
    - finished: No data
    - error: tuple (exctype, value, traceback.format_exc() )
    - result: object data returned from processing, anything
    - status: a dict telling the status of the worker progress
    - hypothesis: a dict with formated hypothesis - can be final or interim. In old versions hypothesis was propagated to the main window
      over status signal. With the 23.14 version, hypothesis is transmited via separated signal.

    Check here to see how to send signals in both directions, i.e. 
    from the main GUI to worker and back, from the worker to GUI
    https://www.pythonguis.com/faq/pause-a-running-worker-thread/
    """
    finished = pyqtSignal(dict)
    error = pyqtSignal(tuple)
    result = pyqtSignal(object)
    status = pyqtSignal(dict)
    hypothesis = pyqtSignal(dict)

class Streamer(QRunnable):
    # TODO: the init must be cleaned - several attributes are no longer needed dou to the TextCorrector and the new approach for handling ASR responses
    def __init__(
        self, 
        stt, 
        settings=None,
        dictation_type="rtf",
        capslock='off', 
        shift='on',
        continue_session=False,
        buffering=None,
        buffer="",
        dictaphone_mode=False,
        templates=None,
        ignore_ssl=False,
        ):
        super(Streamer, self).__init__()
        self.signals = WorkerSignals()
        self.stt = stt
        self.templates = templates
        self.commands_helper_active = False
        self.dictaphone_mode = dictaphone_mode
        # set platform and copy/paste key combination
        # TODO: should go to config
        if platform == "linux" or platform == "linux2":
            self.platform = 'Linux'
            self.copypaste = 'cmd+v'
            self.undo = 'cmd+z'
        elif platform == "darwin":
            self.platform = 'Mac OS'
            self.copypaste = 'cmd+v'
            self.undo = 'cmd+z'
        elif platform == "win32":
            self.platform = "Windows"
            self.copypaste = 'ctrl+v'
            self.undo = 'ctrl+z'
        # other settings
        self.settings = settings
        self.translations = create_translations_dict(self.settings, templates)
        self.dictation_type = dictation_type
        self.caps_lock_state = capslock
        self.shift_state = shift
        self.ins_state = 'off'
        self.is_first_final = True 
        self.spelling = False
        self.command_stack = []
        self.tb_platform = "sandbox"
        self.last_final = None
        self.last_interim = None
        self.command_composite = None
        self.continue_session = continue_session
        self.current_session = None
        self.buffer = buffer
        self.buffering = buffering
        self.ignore_ssl = ignore_ssl
        self._ptr_command = re.compile(r'(\s)*(<[^>\s]+>)(\s)*')
        self._ptr_command_composition = re.compile(r'^(<[^>\s]+>)(\s)*([\d]+[\.\,\?\!]*|[a-zščž]+[\.\,\?\!]*)$', flags=re.IGNORECASE)
        self._ptr_nl = re.compile(r'(\s|^)*(<nl>|nova vrsta|nova vrstica|nov vrstica|no vrstica|nov vrsta|no vrsta)(\s)*', flags=re.IGNORECASE)
        self._ptr_np = re.compile(r'(\s|^)*(<np>|nav odstavek|nov odstavek|novi odstavek|no odstavek|na odstavek)(\s)*', flags=re.IGNORECASE)
        self._ptr_numbers_to_join = re.compile(r'(^|\s)(\d+)(\s)(\d+)')
        self._ptr_numbers_to_translate1 = re.compile(r'(\d+)(\s)(tisoč|sto|deset)(\s|\,\.\!\?)', flags=re.IGNORECASE)
        self._ptr_numbers_to_translate2 = re.compile(r'(tisoč|sto|deset|nič|nula|dva|tri|štiri|pet|šest|sedem|osem|devet)(\s)(\d+)', flags=re.IGNORECASE)
        self._ptr_leading_zero = re.compile(r'(^|\s)(nič)(\s)(\d+)', flags=re.IGNORECASE)
        self._ptr_spp_code = re.compile(r'^(\s)*([a-z])(\s)*(\d{1,2})(\.\s\d{1,2})*(\s|$)', flags=re.IGNORECASE)
        self._ptr_float_number = re.compile(r'(\d+)(\,)(\d+)')
        self._ptr_pause_cmd = re.compile(r'(<pause>|pazva|pauza)[\.\,\!\?]*$', flags=re.IGNORECASE)
        self._ptr_end_cmd = re.compile(r'(<end>|konec diktata|konec nareka)[\.\,\!\?]*$', flags=re.IGNORECASE)
        self._ptr_floating_win_cmd = re.compile(r'(<copy>|zapomni)', flags=re.IGNORECASE)
        # If reserved token for activating B21 templates not set in the settings, use token 'predloga'
        self.b21_template_token = get_settings_value(self.settings, ['general', 'b21-template-reserved-word'])
        if not self.b21_template_token:
            self.b21_template_token = 'predloga'

    def extract_transcript(self, response):
        """
        Transcript is extracted from the response received from ASR
        """
        formated_final = ""
        if response and "transcript" in response: 
            for el in json.loads(response.get("transcript").get("content")):
                if el.get("spaceBefore"):
                    formated_final = formated_final + " " + el.get("text")
                else:
                    formated_final = formated_final + el.get("text")

            return dict(
                isFinal=response["isFinal"],
                transcript=formated_final
            )
   
    def handle_streamer_commands(self, t):
        """
        Some of the commands need to be handled in the Streamer. These are:
        - <pause>: pause mode
        - <end>: end of dictation
        - <copy>: start buffering
        - <paste>: paste buffer
        These commands can be issued alone or at transcript end. Both cases must be handled.
        If the command is issued at the end of transcript, the transcript must first be sent to the
        display_transcript handler and only after that the command can be applied. 
        TODO:
        [x] we have user defined tokens for pause and end of dictation in the settings. They could be removed from the settings 
            since we have reserved words for both.
        """
        res = t.strip().lower()
        res_tokens = res.split()

        # PAUSE
        #if res in ('pavza', 'pauza', '<pause>') or (res_tokens and res_tokens[-1].strip() in ('pavza', 'pauza', '<pause>')):
        if re.search(self._ptr_pause_cmd, res):
            logger.debug("::pause phrase detected")
            self.stt.end_session()
            self.signals.status.emit(dict(stype='progress', value='pause', buffer=self.buffer))
        
        # END DICTATION
        #elif res in ('konec diktata', 'konec nareka', '<end>'):
        elif re.search(self._ptr_end_cmd, res):
            logger.debug("::end of dictation phrase detected")
            self.stt.end_session()
            self.signals.status.emit(dict(stype='progress', value='finished'))

        # START BUFFERING
        #elif res in ('zapomni', '<copy>'):
        elif re.search(self._ptr_floating_win_cmd, res):
            logger.debug("::start buffering phrase detected")
            self.signals.status.emit(dict(stype='final-command', value='<copy>', buffer=""))

        # TODO:
        # SHOW COMMANDS
        # CLOSE COMMANDS WINDOW
        
    @pyqtSlot()
    def run(self):

        try:
            # before starting dictation, move to previous window - expectation here is that
            # the toolbar got focus and that going back to previous window is the right thing to do.
            # If in dictaphone mode, this is not relevant
            if not self.dictaphone_mode and self.settings.get('general', False) and \
                self.settings['general'].get('autofocus', False) and \
                self.settings['general']['autofocus'].get('autofocus-with-key', False) and \
                self.settings['general']['autofocus'].get('autofocus-key', False):
                keyboard.press_and_release(self.settings['general']['autofocus']['autofocus-key'])

            # signal to the main GUI that the process has started
            self.signals.status.emit(dict(stype='progress', value='started'))
            # start the process
            res = self.stt.transcribe_from_microphone(continue_session=self.continue_session, keyListener=False, ignore_ssl=self.ignore_ssl)

            # in case streaming rised an error when establishing connection, res will be false and stt.connection_errors will hold the error log
            if not res:
                logger.error(f"Error in establishing connection. {self.stt.connection_errors[-1]}")
                if len(self.stt.connection_errors)>0:
                    self.signals.result.emit(self.stt.connection_errors[-1])
                else:
                    self.signals.result.emit(dict(
                        messageType='ERROR',
                        message="Unknown error!"
                    ))
            else:
                
                # send ping time
                self.signals.status.emit(dict(stype='ping', value=f"{self.stt.elapsed_time_to_connect}"))

                # send sessionId to main GUI if needed for external commands
                # value in the next command is set to pass it to the GUI explicitly - using last session from the stt object is not safe since stt may get reinitialised
                self.signals.status.emit(dict(stype='sessionid', value=f"{self.stt.last_sessionId}"))
                # remember current sessionId - the session in the stt object will change once new session is started. So safer to keep it as a local variable
                self.current_session = self.stt.last_sessionId
                
                while self.stt.session:
                    for value in self.stt.get_status(True):
                        res = self.extract_transcript(value)
                        if res: 
                            # TODO: the self.stt.get_status() will return -1 if Queue is empty and listener is dead or if an excaption happened when reading the Queue. This is not handled in the get_text()!!!
                            if not res.get('isFinal'):
                                # if interim: show last n characters of the last interim
                                self.last_interim = res.get('transcript')
                                #self.signals.status.emit(dict(stype='final-command', value=res.get('transcript')))
                                self.signals.status.emit(dict(stype='interim', value=f"{res.get('transcript')}..."[-_interim_display_len-3:]))
                            else:
                                # if final, send it to display_transcript handler
                                logger.debug(f"--------------------------- new final ---------------------------")
                                self.last_final = res.get('transcript')
                                self.signals.status.emit(dict(stype='final', value=res.get('transcript')))
                                self.signals.hypothesis.emit(dict(final=True, htype='text', text=res.get('transcript')))
                                self.handle_streamer_commands(res.get('transcript'))

                # When you get here, session has been closed. Check what happened. It could be that websocket was closed by the server
                # Process the error stack and report to the user if anything abnormal happened.
                if len(self.stt.connection_errors)>0:
                    logger.error(f"Error in streaming audio. {self.stt.connection_errors[-1]}")
                    self.signals.result.emit(self.stt.connection_errors[-1])
                else:
                    logger.info(f"Session ended with last interim: {self.last_interim} and last final: {self.last_final}")    
                    result = self.stt.session_info
                    self.signals.result.emit(result)  # Return the result of the processing
        except:
            # if an exception happens at this level, it is very unlikly that the cause would in in the truebar library. All exceptions that happen there are
            # propagated via self.stt.connection_error stack and are caught after the WHILE LOOP above. If web socket is closed unexcpectedlly, due to the server
            # or client, while loop will finish and error will be caught in the self.stt.connection_error stack. So if exception happens here, it is probably due 
            # to some strange error in this part of code.
            #logger.error(f"Exception in the Streamer object")
            #logger.debug(f"Error stack: {self.stt.connection_errors[-1] if len(self.stt.connection_errors)>0 else []}")
            traceback.print_exc()
            exctype, value = sys.exc_info()[:2]
            self.signals.error.emit((exctype, value, traceback.format_exc()))
        #else:
        #    self.signals.result.emit(result)  # Return the result of the processing
        finally:
            self.signals.finished.emit(dict(sessionid=self.current_session))  # Done

    def helper_window_closed(self):
        self.commands_helper_active = False

class OfflineASRSignals(QObject):
    """
    Defines the signals available from a running offline worker thread.
    Supported signals are:
    - status: a dict telling the status of the worker progress
    - sessionid: session identifier assigned to the job
    - error: if an exception is triggered, the reason will be emited to the main thread
    """
    status = pyqtSignal(dict)
    sessionid = pyqtSignal(int)
    error = pyqtSignal(tuple)

class OfflineASR(QRunnable):
    """
    This class implements offline transcription via TB-BE upload functionalitz, using asznc method. It uses truebar wrapper to communicate with the backend.
    """
    def __init__(
            self,
            stt,
            filename,
            status_check_frequency=2, # set to define how often (in sec) to check session status
        ):
        super(OfflineASR, self).__init__()
        self.signals = OfflineASRSignals()
        self.stt = stt
        self.filename = filename
        self.status_check_frequency = status_check_frequency

    @pyqtSlot()
    def run(self):
        
        try:
            if os.path.isfile(self.filename):
                res = self.stt.upload_audio(self.filename, is_async=True)
                sessionid = res['sessionId']
                self.signals.sessionid.emit(sessionid) # Send sessionid to the main thread

                status = None
                step = 0
                while status != 'FINISHED':
                    step += 1
                    status = self.stt.get_session_status(sessionid)
                    self.signals.status.emit(dict(status=status))
                    time.sleep(self.status_check_frequency)
            else:
                self.signals.status.emit(dict(status=None, error=f"File {self.filename} can't be found!"))
        
        except:
            traceback.print_exc()
            exctype, value = sys.exc_info()[:2]
            self.signals.error.emit((exctype, value, traceback.format_exc()))
        
class MSMQSignals(QObject):
    """
    Defines the signals available from a running MSMQ thread.
    Supported signals are:
    - result: data received over MSMQ, format: dict(label, message)
    - error: tuple (exctype, value, traceback.format_exc() )
    - finished: No data
    """
    result = pyqtSignal(dict)
    error = pyqtSignal(tuple)
    finished = pyqtSignal() 

class MSMQ(QRunnable):
    """
    This class encapsulates all required functionality to send and receive mesages from other applications over MS message queue.
    An instance of the MSMQ class should be created when app starts...
    """
    def __init__(self, purge_before_start=False):
        super(MSMQ, self).__init__()
        self.signals = MSMQSignals()
    
        # Initializes an instance of MSMQ.MSMQQueueInfo, which can then be used to reference and manipulate an MSMQ queue.
        self.qinfo=win32com.client.Dispatch("MSMQ.MSMQQueueInfo")

        # get computer name and name of the user that is logged into the windows session
        computer_name = os.getenv('COMPUTERNAME')
        username_win = os.getenv('USERNAME')

        # check if private QUEUEs exist for the logged user. If exists, use it, otherwise use shared QUEUE
        self.qinfo.FormatName="direct=os:"+computer_name+"\\PRIVATE$\\tb_inQueue"+"_"+username_win
        if not queue_exists(self.qinfo):
            logger.info(f"No PRIVATE in-queue found for the WIN user {username_win}, using SHARED in-queue!")
            self.qinfo.FormatName="direct=os:"+computer_name+"\\PRIVATE$\\tb_inQueue"

        self.legal_external_commands = []
        try:
            # Open a ref to queue to read(1)
            self.queue=self.qinfo.Open(1,0)
            # set legal external commands
            self.legal_external_commands = [
                'login',
                'logout',
                'status',
                'start_dict',
                'stop_dict',
                'win_change',
                'hide_toolbar',
                'show_toolbar',
                'pause',
                'continue',
                'start_buffering',
                'paste',
                'command_mode',
                'stop_command_mode',
                'upload_audio',
                'check_status',
                'get_transcript',
            ]
            # purge queue if required so
            if purge_before_start:
                self.purge_queue()
                logger.debug(f"Receiving queue has been purged!")
        except Exception as e:
            logger.warning(f"Can't open in-queue to listen for external commands.\nIntegration over MSQM will not work.")

    def send_message(self, message):
        pass

    def read_queue(self):
        msg=self.queue.Receive()
        return dict(
            label=msg.Label,
            body=msg.Body,
        )
    
    def view_queue(self, timeout):
        """
        Makes a peek into the Queue and if something is in it, it returns True
        The call is blocking but for max timeout*1000 miliseconds
        """
        return self.queue.Peek(pythoncom.Empty, pythoncom.Empty, timeout * 1000)

    def close_queue(self):
        self.queue.close()

    def purge_queue(self):
        """
        Deletes all messages from the queue
        """
        self.queue.Purge()

    @pyqtSlot()
    def run(self):
        
        self.listening = True
        try:
            while self.listening:
                if self.view_queue(timeout=1):
                    msg = self.read_queue()
                    logger.debug(f'Got external message: {msg["label"]} - {msg["body"]}')
                    self.signals.result.emit(msg) # Send received message to the main thread
        except:
            traceback.print_exc()
            exctype, value = sys.exc_info()[:2]
            self.signals.error.emit((exctype, value, traceback.format_exc()))
        finally:
            self.queue.close()
            logger.debug(f'Listener to external commands is down!')
            self.signals.finished.emit()

class VitasisLabel(QLabel):
    def __init__(self, parent):
        QLabel.__init__(self, parent)
        self.link = "https://vitasis.si/home"

    def mousePressEvent(self, event):
        webbrowser.open(self.link)

class CheckableComboBox(QComboBox):

    # Subclass Delegate to increase item height
    class Delegate(QStyledItemDelegate):
        def sizeHint(self, option, index):
            size = super().sizeHint(option, index)
            size.setHeight(20)
            return size

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)

        # Make the combo editable to set a custom text, but readonly
        self.setEditable(True)
        self.lineEdit().setReadOnly(True)
        # Make the lineedit the same color as QPushButton
        palette = qApp.palette()
        palette.setBrush(QPalette.Base, palette.button())
        self.lineEdit().setPalette(palette)

        # Use custom delegate
        self.setItemDelegate(CheckableComboBox.Delegate())

        # Update the text when an item is toggled
        self.model().dataChanged.connect(self.updateText)

        # Hide and show popup when clicking the line edit
        self.lineEdit().installEventFilter(self)
        self.closeOnLineEditClick = False

        # Prevent popup from closing when clicking on an item
        self.view().viewport().installEventFilter(self)

    def resizeEvent(self, event):
        # Recompute text to elide as needed
        self.updateText()
        super().resizeEvent(event)

    def eventFilter(self, object, event):

        if object == self.lineEdit():
            if event.type() == QEvent.MouseButtonRelease:
                if self.closeOnLineEditClick:
                    self.hidePopup()
                else:
                    self.showPopup()
                return True
            return False

        if object == self.view().viewport():
            if event.type() == QEvent.MouseButtonRelease:
                index = self.view().indexAt(event.pos())
                item = self.model().item(index.row())

                if item.checkState() == Qt.Checked:
                    item.setCheckState(Qt.Unchecked)
                else:
                    item.setCheckState(Qt.Checked)
                return True
        return False

    def showPopup(self):
        super().showPopup()
        # When the popup is displayed, a click on the lineedit should close it
        self.closeOnLineEditClick = True

    def hidePopup(self):
        super().hidePopup()
        # Used to prevent immediate reopening when clicking on the lineEdit
        self.startTimer(100)
        # Refresh the display text when closing
        self.updateText()

    def updateText(self):
        texts = []
        for i in range(self.model().rowCount()):
            if self.model().item(i).checkState() == Qt.Checked:
                texts.append(self.model().item(i).text())
        text = ", ".join(texts)

        # Compute elided text (with "...")
        metrics = QFontMetrics(self.lineEdit().font())
        elidedText = metrics.elidedText(text, Qt.ElideRight, self.lineEdit().width())
        self.lineEdit().setText(elidedText)

    def addItem(self, text, data=None, checked=False):
        item = QStandardItem()
        item.setText(text)
        if data is None:
            item.setData(text)
        else:
            item.setData(data)
        item.setFlags(Qt.ItemIsEnabled | Qt.ItemIsUserCheckable)
        if checked:
            item.setData(Qt.Checked, Qt.CheckStateRole)
        else:
            item.setData(Qt.Unchecked, Qt.CheckStateRole)
        self.model().appendRow(item)

    def addItems(self, texts, datalist=None):
        for i, text in enumerate(texts):
            try:
                data = datalist[i]
            except (TypeError, IndexError):
                data = None
            self.addItem(text, data)

    def currentData(self):
        # Return the list of selected items data
        res = []
        for i in range(self.model().rowCount()):
            if self.model().item(i).checkState() == Qt.Checked:
                res.append(self.model().item(i).data())
        return res

class Ui_MainWindow(QWidget, Ui_Toolbar):
    
    def __init__(
        self, 
        gui_object, 
        logger_folder=os.path.dirname(__file__), 
        app=None # the application object
        ):
        super().__init__()

        # The app object is passed from the main module. I need it here for the PlayerWindow
        self.app = app
        
        # in rare cases, there are issues with the SSL due to the certificate. If TB-listener is started from
        # command line with switch --ignore-ssl, SSL will not be used. Notice that this is unsafe and not
        # recommended! By default, ignoreSSL is set to False. 
        self.ignoreSSL=False
        
        # init of Qsettings to store selected variables to registry
        self.qt_settings = QSettings('Vitasis', 'TB-listener')
        
        # init of the logger
        self.logger_folder=logger_folder
        
        # threading
        self.threadpool = QThreadPool()
        logger.info("Multithreading with maximum %d threads" % self.threadpool.maxThreadCount())
        gui_object.setObjectName("MainWindow")
        
        # Initialize GUI
        self.init_gui(gui_object)

        # Init of not GUI atrtributes
        ### offlineASR_status
        self.offlineASR_status = None
        ### user authentication status: {True, False}
        self.user_authenticated = False
        ### window handle to give focus to
        self.wtof = None
        ### variable to hold window handle - the variable is set via win_change external command
        self.b21_win_hndl = None
        ### session log - a dictionary of session metadata objects
        self.user_session_log = dict()
        ### init of the truebar BE object
        self.tb_current_config = None
        self.stt = None
        self.tb_params={
            "timeout": 2,
            "audio_format": truebar.pyaudio.paInt16,
            "audio_channels": 1,
            "audio_rate": 16000,
            "audio_chunk": int(16000 / 10)
        }
        self.stt=truebar.TruebarSTT(self.tb_params, self.logger_folder)
        self.stt_platform = None
        ### initial dictation type. Selected from {txt, rtf, docx, b21} 
        self.dictation_type = "rtf"
        ### PID dialog status
        self.PID_dialog_opened = None
        ### commands helper dialog status
        self.COMMANDS_dialog_opened = None
        ### config initialization. TODO: settings are read again befor every new recording. Maybe redundant! 
        # At the same time, use-proxy settings will not be changed as it is set upon authentication and binded to the stt class
        self.settings = read_config()
        # Disable selected Toolbar buttons if in B21 mode - i.e. listening for external commands, and commands are not forced to remain available
        if get_settings_value(self.settings, ['integration', 'listen-for-external-commands']) and not get_settings_value(self.settings, ['integration', 'allow-toolbar-control']):
            self.actionRecord.setDisabled(True)
            self.actionDictaphone.setDisabled(True)
        # check if any of the commands is disabled
        enabled_commands_setting = get_settings_value(self.settings, ['user-defined-commands', 'enabled-commands']) 
        if enabled_commands_setting:
             self.enabled_commands = [key for item in enabled_commands_setting for key, value in item.items() if value]
        else:
            self.enabled_commands = ['nl', 'np', 'b', 'i', 'u', 'alignc', 'alignl', 'alignr', 'uc', 'UC', 'LC', 'lc', 'cc', 'delall', 'delw', 'dels', 'selectall', 'copy', 'paste', 'end', 'pause', 'spc', 'nospace', 'comment', 'textback', 'next', 'prev', 'ins', 'showcmd', 'deln']
        # suppress notifications if required so
        if not self.settings.get('general', True).get('suppress-notifications', True):
            self.qt_settings.setValue('suppress-notifications', False)
        ### a variable to hold streamer object when activated
        self.streamer = None
        ### initial buffer state - buffer is empty and buffering state is off
        self.buffer = ""
        self.buffering = False
        ### variable that holds current state of the note taking option - it becomes True if user starts dictaphone mode during recording (only allowed if listening for external commands)
        self.note_taking_mode = None
        ### init of the listener for extenal commands - the listener will run in separate thread
        ### also, start queue for dispatching responses on external commands - no need for separate thread
        self.inQueue = None
        self.outQueue = None
        if get_settings_value(self.settings, ['integration', 'listen-for-external-commands']):
            self.start_command_listener()
            self.outQueue = self.start_outQueue()
        ### this attribute will hold identifier of the last processed external message and will reset to None after a response is send back over the outQueue
        self.active_external_msg_id = None
        
        # Read saved values from the registry
        self.model_updates = self.qt_settings.value('model-updates') or dict()
        self.init_fields()
        ### sync template folders if local templates are used - the sync will be made between the map set in the settings and AppData local map
        if get_settings_value(self.settings, ['general', 'use-local-templates']):
            templates_folder = get_settings_value(self.settings, ['general', 'templates-folder'])
            appdata_folder = os.path.join(user_appdata, 'templates')
            if get_settings_value(self.settings, ['general', 'synchronize-templates']) and templates_folder and appdata_folder and os.path.isdir(templates_folder) and os.path.isdir(appdata_folder):
                self.sync_folders(templates_folder, appdata_folder) 
        ### init of templates if any in the template folder (check settings for where the template folder is)
        self.templates = self.read_templates()
        self.b21_template_token = get_settings_value(self.settings, ['general', 'b21-template-reserved-word'])
        self.template_viewer = None # will hold reference to template viewer dialog
        ### When initialiyed, the app is in regular mode
        self.template_mode = False

        ### check settings if new version
        if self.new_version():
            try:
                self.merge_settings()
            except Exception as e:
                logger.error(f"Error when merging settings! Exception: {e}")
        
        ### if host read from Regex, check if ws connection is OK
        self.on_host_changed()
        ### translations - mappings read from settings -make sure to not include those refering to disabled commands
        self.translations = create_translations_dict(self.settings, self.templates)
        ### text corector object
        self.text_corrector = TextCorrector(translations=self.translations)

        # Read named entities
        self.named_entities = self.load_named_entities(os.path.join(resources_folder, 'MED_named_entities.pckl'))

        # Instantiate supporting object for locking cursor to a window
        self.window_locker = WindowSelector()
        self.window_locker.window_selected.connect(self.handle_selection)
        self.locked_window = None
        
        # Instantiate supporting object for window management
        self.win_mnpl = WindowManipulator(logger=logger)

        # Prepare variable for session name and notes - these will be None at init but will leter be set, either via an extarnal command or through the PID window. 
        # Otherwise stay None. Once a session is started and gets an ID number, the dictionary self.user_session_log will be used and an object of SessionMetadata
        # type will be created for the key {session}
        self.session_name = None
        self.session_notes = None 
        
        QtCore.QMetaObject.connectSlotsByName(gui_object)

    def init_gui(self, gui_object):
        """
        Initializes GUI objects and GUI related attributes
        """
        # Apply rounded corners using stylesheets
        self.setObjectName("RoundedMainWindow")
        self.setStyleSheet(
            "#RoundedMainWindow { background-color: white; border-radius: 30px; }"
        )
        
        # windows sizing
        self.main_window_height_S = scale(_main_window_height_S)
        self.main_window_height_L = scale(_main_window_height_L)
        self.main_window_width_S = scale(_main_window_width_S)
        self.main_window_width_L = scale(_main_window_width_L)
        
        # init of common variables
        ### common fonts
        self.bold_font = QtGui.QFont()
        self.bold_font.setBold(True)
        self.bold_font.setWeight(75)
        self.small_font = QtGui.QFont()
        self.small_font.setPointSize(7)
        self.large_font = QtGui.QFont()
        self.large_font.setPointSize(12)
        ### common icons
        self.icon_rec_idle = QtGui.QIcon()
        self.icon_rec_idle.addPixmap(QtGui.QPixmap(os.path.join(basedir, "record.png")), QtGui.QIcon.Normal, QtGui.QIcon.Off)
        self.icon_rec_started = QtGui.QIcon()
        self.icon_rec_started.addPixmap(QtGui.QPixmap(os.path.join(basedir, "recording.png")), QtGui.QIcon.Normal, QtGui.QIcon.Off)
        self.icon_rec_pause = QtGui.QIcon()
        self.icon_rec_pause.addPixmap(QtGui.QPixmap(os.path.join(basedir, "pause.png")), QtGui.QIcon.Normal, QtGui.QIcon.Off)
        self.icon_dict_idle = QtGui.QIcon()
        self.icon_dict_idle.addPixmap(QtGui.QPixmap(os.path.join(basedir, "dict.png")), QtGui.QIcon.Normal, QtGui.QIcon.Off)
        self.icon_dict_running = QtGui.QIcon()
        self.icon_dict_running.addPixmap(QtGui.QPixmap(os.path.join(basedir, "dict-red.png")), QtGui.QIcon.Normal, QtGui.QIcon.Off)
        
        # Render of the designed GUI plus additional settings
        self.setupUi(gui_object)
        # add missing components, styling, actions and signals
        ### extendable spacer to make QLabel for status info in the toolbar right-aligned
        spacer = QtWidgets.QWidget()
        spacer.setSizePolicy(QSizePolicy.Expanding, QSizePolicy.Expanding)
        self.toolBar.addWidget(spacer)
        ### Toolbar label "recording status" indicates buffering state
        self.label_rec_status = QtWidgets.QLabel()
        self.label_rec_status.setGeometry(QtCore.QRect(scale(0), scale(0), scale(40), scale(16)))
        self.label_rec_status.setAlignment(QtCore.Qt.AlignRight|QtCore.Qt.AlignTrailing|QtCore.Qt.AlignVCenter)
        self.label_rec_status.setObjectName("label_rec_status")
        self.toolBar.addWidget(self.label_rec_status)
        ### Toolbar label "logged user" tells the current user name and number of initialized custom templates
        self.label_logged_user = QtWidgets.QLabel()
        self.label_logged_user.setGeometry(QtCore.QRect(scale(0), scale(0), scale(40), scale(16)))
        self.label_logged_user.setAlignment(QtCore.Qt.AlignRight|QtCore.Qt.AlignTrailing|QtCore.Qt.AlignVCenter)
        self.label_logged_user.setObjectName("label_logged_user")
        self.centralwidget.setStyleSheet(f"background-color: {cl_light_green_string}")
        # Make the label showing TB info clickable to open templates folder
        self.label_logged_user.setTextInteractionFlags(Qt.TextBrowserInteraction)
        self.label_logged_user.setOpenExternalLinks(False)
        self.label_logged_user.linkActivated.connect(self.handle_link_click)

        self.toolBar.addWidget(self.label_logged_user)
        ### Toolbar icons - TODO: not sure if all icons here need setting since they are set already in the gui class
        icon_info = QtGui.QIcon()
        icon_info.addPixmap(QtGui.QPixmap(os.path.join(basedir, "info.png")), QtGui.QIcon.Normal, QtGui.QIcon.Off)
        self.actionInfo.setIcon(icon_info)
        icon_settings = QtGui.QIcon()
        icon_settings.addPixmap(QtGui.QPixmap(os.path.join(basedir, "settings.png")), QtGui.QIcon.Normal, QtGui.QIcon.Off)
        self.actionSettings.setIcon(icon_settings)
        icon_exit = QtGui.QIcon()
        icon_exit.addPixmap(QtGui.QPixmap(os.path.join(basedir, "exit_app3.png")), QtGui.QIcon.Normal, QtGui.QIcon.Off)
        self.actionExit.setIcon(icon_exit)
        self.actionAddWord.setIcon(self.icon_dict_idle)
        self.icon_lock_window = QtGui.QIcon()
        self.icon_lock_window.addPixmap(QtGui.QPixmap(os.path.join(basedir, "maps-and-flags-outline.png")), QtGui.QIcon.Normal, QtGui.QIcon.Off)
        self.icon_window_locked = QtGui.QIcon()
        self.icon_window_locked.addPixmap(QtGui.QPixmap(os.path.join(basedir, "maps-and-flags-red.png")), QtGui.QIcon.Normal, QtGui.QIcon.Off)
        icon_dictaphone = QtGui.QIcon()
        icon_dictaphone.addPixmap(QtGui.QPixmap(os.path.join(basedir, "dictaphone.png")), QtGui.QIcon.Normal, QtGui.QIcon.Off)
        self.actionDictaphone.setIcon(icon_dictaphone)
        icon_debug = QtGui.QIcon()
        icon_debug.addPixmap(QtGui.QPixmap(os.path.join(basedir, "debug.png")), QtGui.QIcon.Normal, QtGui.QIcon.Off)
        self.pushButton_sendLogs.setIcon(icon_debug)
        icon_detailed_settings = QtGui.QIcon()
        icon_detailed_settings.addPixmap(QtGui.QPixmap(os.path.join(basedir, "settings.png")), QtGui.QIcon.Normal, QtGui.QIcon.Off)
        self.pushButton_detailed_settings.setIcon(icon_detailed_settings)
        self.icon_upload_audio = QtGui.QIcon()
        self.icon_upload_audio.addPixmap(QtGui.QPixmap(os.path.join(basedir, ".\\upload_audio.png")), QtGui.QIcon.Normal, QtGui.QIcon.Off)
        self.icon_download_transcript = QtGui.QIcon()
        self.icon_download_transcript.addPixmap(QtGui.QPixmap(os.path.join(basedir, ".\\download_transcript.png")), QtGui.QIcon.Normal, QtGui.QIcon.Off)
        self.icon_offlineASR_in_progress = QtGui.QIcon()
        self.icon_offlineASR_in_progress.addPixmap(QtGui.QPixmap(os.path.join(basedir, ".\\busy.png")), QtGui.QIcon.Normal, QtGui.QIcon.Off)    
        ### label for interims - initialy empty string
        self.label_interim.setText("")
        ### model selection
        self.comboBox_model.activated.connect(self.model_config)
        self.comboBox_model.setEnabled(False)
        self.comboBox_model.setStyleSheet(f"background-color: {cl_light_green_string}")
        ### postprocessing options
        self.checkBox_punctuation.stateChanged.connect(lambda: self.change_postprocessing_feature('punct'))
        self.checkBox_capitalization.stateChanged.connect(lambda: self.change_postprocessing_feature('cap'))
        self.checkBox_denormalization.stateChanged.connect(lambda: self.change_postprocessing_feature('denorm'))
        self.checkBox_punctuation.setEnabled(False)
        self.checkBox_capitalization.setEnabled(False)
        self.checkBox_denormalization.setEnabled(False)
        ### radio buttons for destination format
        self.radioButton_plain.toggled.connect(self.select_output)
        self.radioButton_plain.setEnabled(False)
        self.radioButton_rtf.setChecked(True)
        self.radioButton_rtf.toggled.connect(self.select_output)
        self.radioButton_rtf.setEnabled(False)
        self.radioButton_docx.toggled.connect(self.select_output)
        self.radioButton_docx.setEnabled(False)
        self.radioButton_b21.toggled.connect(self.select_output)
        self.radioButton_b21.setEnabled(False)
        ### host
        self.label_host.setAlignment(QtCore.Qt.AlignRight|QtCore.Qt.AlignTrailing|QtCore.Qt.AlignVCenter)
        self.lineEdit_host.setStyleSheet("background-color: white")
        self.original_style = self.lineEdit_host.styleSheet()
        self.lineEdit_host.editingFinished.connect(self.on_host_changed)
        ### username
        self.label_username.setAlignment(QtCore.Qt.AlignRight|QtCore.Qt.AlignTrailing|QtCore.Qt.AlignVCenter)
        self.lineEdit_username.setStyleSheet("background-color: white")
        ## password
        self.label_password.setAlignment(QtCore.Qt.AlignRight|QtCore.Qt.AlignTrailing|QtCore.Qt.AlignVCenter)
        self.lineEdit_password.setEchoMode(QtWidgets.QLineEdit.Password)
        self.lineEdit_password.returnPressed.connect(self.authenticate)
        self.lineEdit_password.setStyleSheet("background-color: white")
        ### destination window
        self.lineEdit_destination.setEnabled(False)
        ### multiselect comboBox for shares - can't be added via the designer
        self.comboBox_allowedUsers = CheckableComboBox(self.centralwidget)
        self.comboBox_allowedUsers.setGeometry(QtCore.QRect(scale(20), scale(580), scale(251), scale(20)))
        self.comboBox_allowedUsers.setObjectName("comboBox_allowedUsers")
        self.comboBox_allowedUsers.setEnabled(False)
        self.comboBox_allowedUsers.setStyleSheet(f"background-color: {cl_light_green_string}")
        ### input device selection
        self.comboBox_inputDevice.setEnabled(False)
        self.comboBox_inputDevice.currentTextChanged.connect(self.set_input_device)
        ### pushButton Login
        self.pushButton_authenticate.setDefault(True)
        self.pushButton_authenticate.setStyleSheet("background-color: lightgrey")
        self.pushButton_authenticate.clicked.connect(lambda: self.authenticate())
        ### pushButton Logout
        self.pushButton_logout.setEnabled(False)
        self.pushButton_logout.setStyleSheet("background-color: lightgrey")
        self.pushButton_logout.clicked.connect(lambda: self.logout())
        ### company Vitasis line at the bottom
        self.label_company = VitasisLabel(self.centralwidget)
        self.label_company.setGeometry(QtCore.QRect(scale(20), scale(680), scale(160), scale(16)))
        self.label_company.setFont(self.small_font)
        self.label_company.setObjectName("label_company")
        self.label_company.setText("@Vitasis 2025, info@vitasis.si")
        self.label_company.setCursor(QCursor(QtCore.Qt.PointingHandCursor))
        ### formatting
        self.pushButton_bold.setStyleSheet("background-color : lightgrey; border-style: solid; border: 1px solid grey")
        self.pushButton_italic.setStyleSheet("background-color : lightgrey; border-style: solid; border: 1px solid grey")
        self.pushButton_underline.setStyleSheet("background-color : lightgrey; border-style: solid; border: 1px solid grey")
        self.pushButton_upper.setStyleSheet("background-color : lightgrey; border-style: solid; border: 1px solid grey")
        self.pushButton_lower.setStyleSheet("background-color : lightgrey; border-style: solid; border: 1px solid grey")
        self.pushButton_spell.setStyleSheet("background-color : lightgrey; border-style: solid; border: 1px solid grey")
        ### toolBar
        self.toolBar.setStyleSheet("background-color: lightblue")
        self.toolBar.setLayoutDirection(QtCore.Qt.LeftToRight)
        self.toolBar.setFloatable(True)
        self.actionRecord.setIcon(self.icon_rec_idle)
        self.actionRecord.setVisible(False)
        self.actionRecord.triggered.connect(self.open_dialog)
        self.actionAlarm.setVisible(False)
        self.actionAlarm.triggered.connect(self.show_last_err)
        self.recording_state = 'idle'
        self.actionSettings.triggered.connect(lambda: self.resize_settings_widget())
        self.actionExit.triggered.connect(lambda: self.exitApp())
        self.actionInfo.triggered.connect(lambda: self.open_commands_helper())
        self.actionAddWord.triggered.connect(lambda: self.open_add_word_dialog())
        self.actionReplacements.triggered.connect(lambda: self.open_repl_dialog())
        self.actionPin.setVisible(False)
        self.actionPin.triggered.connect(lambda: self.select_window())
        #self.actionPin.setDisabled(True)
        self.actionUpload.setVisible(False)
        self.actionReplacements.setVisible(False)
        self.actionUpload.triggered.connect(lambda: self.upload_file())
        # connect dictaphone button - initially hidden
        self.actionDictaphone.triggered.connect(lambda: self.dictaphone_mode())
        self.actionDictaphone.setVisible(False)
        # action to add words to dictionary is initially hidden. Not all models support dictionary management
        # when user authenticates or changes model, the action is rechecked and set to visible or hidden
        self.actionAddWord.setVisible(False)
        ### send button for logs
        self.pushButton_sendLogs.clicked.connect(lambda: self.open_send_logs())
        ### open detailed settings
        self.pushButton_detailed_settings.clicked.connect(lambda: self.open_detailed_settings())
        ### app version
        self.label_about.setText(f"TB-listener, verzija {app_version}")
        ### a variable for transcript window, initially None, set after authentication
        self.transcript_win = None
        ### a variable for player window, initially None, set once offline ASR is invoked
        self.player_win = None

        # Connect the double-click event handler
        self.toolBar.mouseDoubleClickEvent = self.toolbar_double_click_event

    def select_window(self):
        if not self.locked_window or not self.locked_window['hwnd']:
            self.window_locker.start()
        else:
            self.locked_window = None
            self.toggle_lock_icon(False)

    def handle_selection(self, info):
        if info["editable"]:
            logger.info(f"✅ Window Locked | Handle: {info['hwnd']} | Title: {info['title']} | Editable: {info['editable']} | PID: {info['pid']}")
            self.locked_window = info
            self.toggle_lock_icon(True)
        else:
            logger.info(("❌ Window not editable"))
            self.toggle_lock_icon(False)
    
    def toggle_lock_icon(self, checked):
        if checked:
            self.actionPin.setIcon(self.icon_window_locked)
            tooltip_label = "Odkleni okno" if not self.locked_window['title'] else f"Odkleni okno '{self.locked_window['title']}'"
            self.actionPin.setToolTip(tooltip_label)
        else:
            self.actionPin.setIcon(self.icon_lock_window)
            self.actionPin.setToolTip("Zakleni okno")
    
    def handle_link_click(self, link):
        if link == "open_templates":
            templates_folder = get_settings_value(self.settings, ['general', 'templates-folder'])
            if not templates_folder or templates_folder.strip() == "" or not os.path.isdir(templates_folder):
                user_appdata_templates = os.path.join(user_appdata, 'templates')
                if os.path.isdir(user_appdata_templates) and len(os.listdir(user_appdata_templates))>0:
                    templates_folder = user_appdata_templates                    

            if templates_folder and os.path.isdir(templates_folder):
                os.startfile(templates_folder)  # Opens the folder in the default file explorer
            else:
                logger.warning(f"Templates folder does not exist: {templates_folder}")

    def toolbar_double_click_event(self, event: QMouseEvent):
        """
        Reacts on a doubleclick on the Toolbar - current setting is to hide the toolbar into systray
        """
        if event.button() == Qt.LeftButton:
            if self.transcript_win:
                self.transcript_win.hide()
            self.hide()
    
    def load_named_entities(self, ne_file):
        """
        Load NE from a file
        """
        if os.path.isfile(ne_file):
            infile = open(ne_file,'rb')
            ne = pickle.load(infile)
            infile.close()
            logger.info(f"Named entities successfully loaded from: {ne_file}.")
            return ne
        else:
            logger.warning(f"Named entities file can be found at: {ne_file}.")
            return None

    def show_offlineASR_status(self, res):
        status = res.get('status', None)
        error = res.get('error', None) 
        
        if status:
            #self.label_interim.setText(status)
            if status == 'IN_PROGRESS':
                self.offline_progress_counter += 1
                self.label_interim.setText("Transkribiram " + "." * (self.offline_progress_counter % 30))
                if status != self.offlineASR_status:
                    self.actionUpload.setIcon(self.icon_offlineASR_in_progress)
            elif status == 'FINISHED':
                self.actionUpload.setIcon(self.icon_upload_audio) 
                # if initiated by user via Toolbar, open player window with the transcript
                # TODO: change color of the interim message back to blqack if it is red
                self.label_interim.setText("")
                self.open_player_window()
        elif error:
            self.label_interim.setText(error)
        self.offlineASR_status = status

    def get_offlineASR_sessionid(self, res):
        self.offlineASR_sessionid = res
        # if external command, return session id
        if self.offlineASR_invoker == 'EXTERNAL':
            self.send_reponse(self.active_external_msg_id, f'cmd_status=True | sessionid={res}')

    def handle_offlineASR_exception(self, res):
        logger.error(res)

    def upload_file(self, external_command=False, external_params=None):

        # check if another ASRoffline job is in progress - in this case do nothing
        # NOTE that we could handle many parallel offline sessions (both, TB BE and TB listener can handle that)
        # but we deliberatly limit to a single one if the request is via GUI Toolbar. If the request is received as
        # an external command, this limitation is ignored
        logger.debug(f"<<<< UPLOAD BUTTON PRESSED >>>>")
        if not external_command and self.offlineASR_status and self.offlineASR_status in ('IN_PROGRESS', 'INITIATING'):
            logger.warning("Another OfflineASR job is in progress!")
            return

        # If user requested offline ASR via GUI, show FileOpen dialog, otherwise the filename should be privided via parameter external_params
        if not external_command:
            options = QFileDialog.Options()
            options |= QFileDialog.ReadOnly
            file_name, _ = QFileDialog.getOpenFileName(
                self,
                "Naloži zvočni posnetek",
                "",
                "Audio Files (*.wav *.mp3 *.dss *.ds2);;All Files (*)",
                options=options
            )
        else:
            file_name = rf"{external_params}"
            if not os.path.isfile(file_name):
                self.send_reponse(self.active_external_msg_id, f'cmd_status=False | err_msg=FAILED: File not found: {file_name}')
                logger.error(f"Cannot start offline transcription - file not found: {file_name}")
                return

        if file_name:

            self.label_interim.setText("Nalagam ...")
            self.offlineASR_invoker = 'EXTERNAL' if external_command else 'INTERNAL'
            self.offlineASR_status = 'INITIATING'
            self.offlineASR_filename = file_name
            self.actionUpload.setIcon(self.icon_offlineASR_in_progress)

            offlineASR = OfflineASR(
                stt=self.stt,
                filename=file_name,
                status_check_frequency=2
            )
            offlineASR.signals.status.connect(self.show_offlineASR_status)
            offlineASR.signals.sessionid.connect(self.get_offlineASR_sessionid)
            offlineASR.signals.error.connect(self.handle_offlineASR_exception)

            # execute
            self.offline_progress_counter = 0
            self.threadpool.start(offlineASR)

        else:
            print("no file name specified")

    def open_player_window(self):
        if not self.player_win:
            # we need to pass two mainwindow objects to the editor since they will be handled from 
            # there. The first one is the pushbutton for showing/hiding the editor and the second is 
            # the mediaplayer object. We need to know the mediaplayer object state from the editor so
            # that if in play mode when mouse changes the cursor position, audio position is changed 
            # as well. 
            self.player_win = PlayerWindow(app_object=self.app)
            self.player_win.setWindowFlags(Qt.WindowStaysOnTopHint)
            # read last setting for the window sizing and position
            #pos = qt_settings.value('editor-position')
            #size = qt_settings.value('editor-size')
            
            #if pos:
            #    self.transcript_editor.move(pos)
            #if size:
            #    self.transcript_editor.resize(size)
            # show the editor
            self.player_win.show()
        else:
            if not self.player_win.isVisible():
                self.player_win.show()

        self.load_transcript(sessionid=self.offlineASR_sessionid)

    def load_transcript(self, sessionid):

        #TODO: must be loaded approapiratelly so that we can handle changes.

        def truecase_transcript(jsontrans):
            # get clean tokens   
            tokens = []
            for ide in jsontrans:
                content = json.loads(ide['content'])
                for el in content:
                    tokens.append(el["text"])

            # truecase clean tokens
            tc_tokens = self.stt.truecase_tokens(
                tokens=tokens, 
                sessionid="",
                ).get('output_tokens', tokens)
            # check if the number of returned tokens is ok
            if len(tc_tokens) != len(tokens):
                logger.warning(f"The number of tokens {len(tokens)} and truecased tokens {len(tc_tokens)} are different!")
                return tokens
            else:
                return tc_tokens

        # Temporarily disable tracking changes
        self.player_win.enable_tracking_changes = False

        self.player_win.status.showMessage("Transkript se nalaga. Prosimo počakajte.")
        self.player_win.editor.clear()
        
        jsontrans = self.stt.get_session_transcript(sessionid, 'transcript')
        
        if jsontrans:
            tr = truebar.TranscriptReader()
            html_text = tr.transcript_to_html(jsontrans)

            # read content tokens before applying truecasing
            #content = html_text.replace("<br>", "")
            # change line breaks to paragraphs to allow styling
            html_text = "<p>" + html_text.replace("<br>", "</p><p>") + "</p>"

            self.player_win.editor.setHtml(html_text)
            
            # reset text color
            self.player_win.reset_text_color()

            # read content tokens
            content = self.player_win.editor.toPlainText()

            # reset change tracker
            self.player_win.initial_transcript = content
            self.player_win.prev_txt = content
            #self.player_win.tracked_changes.clear()

            # show metadata
            #self.player_win.status.showMessage(f"Število znakov: {len(content)}, število besed: {len(content.split(' '))}")
            #self.player_win.status.setVisible(True)

            # update transcript with absolute position of tokens in text editor
            self.player_win.transcript_aligner = truebar.TranscriptAligner(
                content=content,
                transcript=tr.transcript_tokens,
                logger_folder=user_appdata
            )

            # remember what was the text extracted from the original transcript
            self.player_win.source_text = self.player_win.document.toPlainText()

            # connect play button on the mediaplayer window with the audio
            # TODO: madia player will not play dss or ds2 files. Make sure to convert them first (see ffmpeg)
            self.player_win.open_file(self.offlineASR_filename)
            # if mediaplayer window is hidden, show it
            if not self.player_win.isVisible():
                self.player_win.show()
        else:
            self.player_win.status.showMessage("V posnetku ni bil prepoznan govor!")

        # Enable tracking changes
        self.player_win.enable_tracking_changes = True
        # Set variable to hold offset - will change on evry added/removed character
        self.player_win.offset = 0

    def on_host_changed(self):
         ### perform test websocket connection. If connection to the host not OK, signal that with light red color of the host edit box
        asr_server_address = "truebar-api:1337" if self.lineEdit_host.text()=='local' else self.lineEdit_host.text()+"-api.true-bar.si"
        if not self.stt.check_connection(asr_server=asr_server_address):
            self.lineEdit_host.setStyleSheet(f"border: 2px solid red; background: {cl_light_orange_string};")
        else:
            self.lineEdit_host.setStyleSheet(self.original_style)

    def new_version(self):
        last_version = self.qt_settings.value('version-on-last-exit')
        if last_version and last_version != app_version:
            logger.warning(f"New version detected! Last version was {last_version}, new version is {app_version}!")
            return True
        else:
            return False

    def merge_settings(self):
        """
        Compares last settings with settings of the new version. The procedure is as follows:
        - if key is in both, new and old settings, and if it is specified as 'key to keep', replace new value with the old value
        - if key is in old settings only and at the same time it is annotated as 'key to keep', merge it into the new settings
        Keys to keep are specified as a list of values under 'keys-to-keep' key in the settings. Every key that is included in
        this list must be taken or merged from the old settings - i.e. must override new values.
        NOTE: if 'keys-to-keep' key is not specified in new settings, it will be initialized as an empty list - meaning that
        all old keys will be ignored.
        """
        def recursive_merge(new_d, old_d, keys_to_keep):
            for k in old_d.keys():
                if k in keys_to_keep:
                    if new_d[k]!=old_d[k]: 
                        new_d[k]=old_d[k]
                        logger.debug(f"Merging old key {k}.")
                elif isinstance(old_d[k], dict) and k in new_d: 
                    new_d[k]=recursive_merge(new_d[k], old_d[k], keys_to_keep)
            return new_d

        if os.path.isfile(os.path.join(os.getenv('APPDATA'), 'vitasis', 'tb-listener', f'settings.yaml')):
            old_settings=read_config(os.path.join(os.getenv('APPDATA'), 'vitasis', 'tb-listener', 'settings.yaml'))
            new_settings=read_config(os.path.join(basedir, "settings.yaml"))     
            new_keys=[k for k in new_settings.keys() if k not in old_settings]
            missing_keys=[k for k in old_settings.keys() if k not in new_settings]
            common_keys_different_values=[k for k in new_settings.keys() if k in old_settings and new_settings[k]!=old_settings[k]]
            keys_to_keep=new_settings.get('keys-to-keep', False)
            logger.debug(f"Settings comparison results: new keys: {len(new_keys)}, missing keys: {len(missing_keys)}, common keys with different values: {len(common_keys_different_values)}")
            logger.debug(f"Keys to keep: {keys_to_keep}")

            loaded_settings = copy.deepcopy(self.settings)
            recursive_merge(new_settings, old_settings, keys_to_keep)
            
            # if settings changed due to the merge, save old settings into settings_{version}.yaml and 
            # merged settings into settings.yaml 
            if loaded_settings != new_settings:
                last_version = self.qt_settings.value('version-on-last-exit') or time.strftime("%Y%m%d_%H%M%S", time.localtime())
                shutil.copyfile(
                    os.path.join(user_appdata, "settings.yaml"),
                    os.path.join(user_appdata, f'settings_{last_version}.yaml')
                    )
                save_config(new_settings)
                self.settings=new_settings
                logger.debug(f"New settings have been merged and saved to disk.")
        else:
            logger.debug(f"Old settings can't be found. New settings will be used without changes.")

        # Check if local folder is set for templates and templates not yet at AppData
        templates_folder = get_settings_value(old_settings, ['general', 'templates-folder'])
        if templates_folder and os.path.isdir(os.path.join(user_appdata, 'templates')):
            # if templates not yet in AppData
            if len([f for f in os.listdir(os.path.join(user_appdata, 'templates')) if f.split('.')[-1].lower()=='txt']) == 0:
                logger.debug(f"Templates found in user defined folder: {templates_folder} will be copied to AppData ...")
                move_templates(templates_folder)

    def init_fields(self):

        # read default settings from settings.yaml
        _default_settings = get_settings_value(self.settings, ['default-settings'])

        if get_settings_value(self.settings, ['general', 'autofocus', 'autofocus-window-title']):
            wtof = get_settings_value(self.settings, ['general', 'autofocus', 'autofocus-window-title'])
            if wtof:
                self.lineEdit_destination.setText(wtof)

        if 'host' in self.qt_settings.allKeys():
            self.lineEdit_host.setText(self.qt_settings.value('host'))
        elif _default_settings and _default_settings.get('host', None):
            self.lineEdit_host.setText(_default_settings['host'])

        if 'username' in self.qt_settings.allKeys():
            self.lineEdit_username.setText(self.qt_settings.value('username'))
        elif _default_settings and _default_settings.get('username', None):
            self.lineEdit_username.setText(_default_settings['username'])
        
        _output_format = self.qt_settings.value('output_format') if 'output_format' in self.qt_settings.allKeys() else _default_settings.get('output-format', None)
        if _output_format:
            if _output_format=='plain':
                self.radioButton_plain.setChecked(True)
            elif _output_format=='rtf':
                self.radioButton_rtf.setChecked(True)
            elif _output_format=='docx':
                self.radioButton_docx.setChecked(True)
            elif _output_format=='b21':
                self.radioButton_b21.setChecked(True)
        # if it is the first time (no value in registry), use B21
        else:
            self.radioButton_b21.setChecked(True)

    # Probably not needed
    def hotkey(self, action):
        # if commands are currently opened, do nothig
        if self.COMMANDS_dialog_opened:
            return

        if action=='commands-help':
            self.open_commands_helper()

        if action=='toggle':
            #print(self.recording_state, "*******************************")
            # if currently PID dialog opened, do nothing
            if not self.PID_dialog_opened:
                # if in idle and user authenticated -> open dialog to enter PID
                if self.recording_state=='idle' and self.user_authenticated:
                    self.actionRecord.trigger()
                # if in pause -> continue recording
                elif self.recording_state=='pause':
                    # set self.wtof to None to indicate that the command is not comming from an external command
                    self.wtof = None
                    self.continue_sessionId = None
                    self.record()
                # if in recording -> go to pause mode
                elif self.recording_state=='recording':
                    self.pause_recording()

    def read_templates(self):
        """
        Reads templates from template folder (the template folder is defined in settings)
        TODO: Only plain text is currently supported. Add support for rtf, html and md
        """
        templates = dict()
        templates_folder = get_settings_value(self.settings, ['general', 'templates-folder'])
        templates_folder_shared = get_settings_value(self.settings, ['general', 'templates-folder-shared'])
        templates_count = 0
        
        # if templates folder is not set or accessable, check if user has templates in the AppData folder
        if not templates_folder or templates_folder.strip() == "" or not os.path.isdir(templates_folder):
            user_appdata_templates = os.path.join(user_appdata, 'templates')
            if os.path.isdir(user_appdata_templates) and len(os.listdir(user_appdata_templates))>0:
                templates_folder = user_appdata_templates                    

        if templates_folder and os.path.isdir(templates_folder):
            for file in os.listdir(templates_folder):
                # NOTE: currently, only plain txt is supported
                if file[0] not in ('.', '~') and file.split(".")[-1] in ('txt', 'rtf', 'html', 'md'):
                    with open(os.path.join(templates_folder, file), "r", encoding="utf-8") as ftemplate:
                        template_name = file.split(".")[0].lower()
                        if template_name != 'index':
                            templates[template_name] = "".join(ftemplate.readlines())
            templates_count = len(templates)
            logger.debug(f"{templates_count} templates imported from {templates_folder}")
            # check if template index file exists and load it for the template viewer dialog
            self.templates_index = None
            index_filename = os.path.join(templates_folder, "index.txt")
            if os.path.isfile(index_filename):
                self.templates_index = index_filename
                logger.info(f"Templates index found and will be used for the templates viewer popup")
            else:
                logger.warning(f"Templates index file is missing at {index_filename} - templatas viewer will not be used!")
            # set toolbar labels
            self.label_logged_user.setText(
                f'<a href="open_templates">T: {len(templates)}</a> | '
                f'U: {self.lineEdit_username.text()}  '
            )
        else:
            if not templates_folder:
                logger.warning(f"Templates folder is not set, templates will not be available.")
            else:
                logger.warning(f"Templates folder {templates_folder} does not exist.")

        # check if folder is set for shared templates and load it if so
        self.templates_index_shared = None
        logger.debug(f"Checking for shared templates ...")
        if templates_folder_shared and os.path.isdir(templates_folder_shared):
            logger.debug(f"Shared templates folder found: {templates_folder_shared}")
            for file in os.listdir(templates_folder_shared):
                # NOTE: currently, only plain txt is supported
                if file[0] not in ('.', '~') and file.split(".")[-1] in ('txt', 'rtf', 'html', 'md'):
                    with open(os.path.join(templates_folder_shared, file), "r", encoding="utf-8") as ftemplate:
                        # ignore shared templates that are overriden with local templates
                        if file.split(".")[0].lower() not in templates:
                            templates[file.split(".")[0].lower()] = "".join(ftemplate.readlines())
                        else:
                            logger.debug(f"Shared template {file.split('.')[0].lower()} already exists as a private template - the shared version will be ignored!")
            logger.debug(f"{len(templates)-templates_count} shared templates imported from {templates_folder_shared}")
            # check if template index file exists in the shared folder and load it for the template viewer dialog
            index_filename = os.path.join(templates_folder_shared, "index.txt")
            if os.path.isfile(index_filename):
                self.templates_index_shared = index_filename
                logger.info(f"Index for shared templates found and will be used for the templates viewer popup")
            else:
                logger.warning(f"Index for shared templates is missing at {index_filename}!")
            # set toolbar labels
            self.label_logged_user.setText(
                f'<a href="open_templates">T: {len(templates)}</a> | '
                f'U: {self.lineEdit_username.text()}  '
            )
        else:
            if not templates_folder_shared:
                logger.warning(f"No shared templates found!")
            else:
                logger.warning(f"Templates folder {templates_folder_shared} does not exist.")
          
        return templates

    def sync_folders(self, folder1, folder2):
        """
        Utility function that synchronizes content in two folders. It works on level 1, i.e. flat folders are expected
        We use it for the synchronization of the local and shared templates folder.
        """        
        def get_file_modification_time(file_path):
            """Returns the modification time of a file."""
            return os.path.getmtime(file_path)

        def sync_folders(folder1, folder2):
            """
            Synchronizes two folders by copying files that are missing or newer from one to the other.
            Reports what has been synchronized.
            """
            # Lists to track synchronized files
            copied_to_folder1 = []
            copied_to_folder2 = []
            updated_in_folder1 = []
            updated_in_folder2 = []

            # Get the list of files in both folders
            files1 = set(os.listdir(folder1))
            files2 = set(os.listdir(folder2))

            # Files that are in folder1 but not in folder2
            only_in_folder1 = files1 - files2
            # Files that are in folder2 but not in folder1
            only_in_folder2 = files2 - files1
            # Files that are in both folders
            in_both_folders = files1 & files2

            # Copy files from folder1 to folder2 if they are missing in folder2
            for file in only_in_folder1:
                src = os.path.join(folder1, file)
                dest = os.path.join(folder2, file)
                shutil.copy2(src, dest)
                copied_to_folder2.append(file)
            
            # Copy files from folder2 to folder1 if they are missing in folder1
            for file in only_in_folder2:
                src = os.path.join(folder2, file)
                dest = os.path.join(folder1, file)
                shutil.copy2(src, dest)
                copied_to_folder1.append(file)

            # For files that exist in both folders, check the modification times
            for file in in_both_folders:
                file1 = os.path.join(folder1, file)
                file2 = os.path.join(folder2, file)

                # Compare modification times and copy the newer file to the other folder
                mod_time1 = get_file_modification_time(file1)
                mod_time2 = get_file_modification_time(file2)

                if mod_time1 > mod_time2:
                    shutil.copy2(file1, file2)
                    updated_in_folder2.append(file)
                elif mod_time2 > mod_time1:
                    shutil.copy2(file2, file1)
                    updated_in_folder1.append(file)

            # Reporting what has been synchronized            
            if copied_to_folder2:
                for file in copied_to_folder2:
                    logger.debug(f"Template {file} copied {folder2}")
            else:
                logger.debug(f"No templates copied to {folder2}.")
            
            if copied_to_folder1:
                for file in copied_to_folder1:
                    logger.debug(f"Template {file} copied {folder1}")
            else:
                logger.debug(f"No templates copied to {folder1}.")

            if updated_in_folder2:
                for file in updated_in_folder2:
                    logger.debug(f"Template {file} updated in {folder2}")
            else:
                logger.debug(f"No templates updated in {folder2}.")
            
            if updated_in_folder1:
                for file in updated_in_folder1:
                    logger.debug(f"Template {file} updated in {folder1}")
            else:
                logger.debug(f"No templates updated in {folder1}.")

        sync_folders(folder1, folder2)

    def sync_dictionary(self):
        """
        Takes care for the synchronization between central and local dictionary
        What we expect from the BE is a list in the follwing format: [{'status': 'NEW', 'text': 'pacient', 'pronunciations': [{'saved': False, 'text': 'pacient'}, {'saved': False, 'text': 'pacijent'}]}]
        """
        def read_dict(token):
            res = self.stt.read_dictionary(
                language = self.tb_current_config["stt"]["language"]["value"], 
                domain = self.tb_current_config["stt"]["domain"]["value"],
                model = self.tb_current_config["stt"]["model"]["value"],
                token=token
            )
            if res:
                status=res[0].get("status")
                text=res[0].get("text")
                fClass=res[0].get("frequencyClassId")
                prons=res[0].get("pronunciations")
                return status, text, fClass, [p['text'] for p in prons]
            else:
                return None, None, None, None 

        def save_dict(data):
            word_entry = dict(
                text=data["text"],
                frequencyClassId=data["frequencyClassId"],
                pronunciations=[dict(text=el["text"]) for el in data["pronunciations"]]
            )
            if not self.stt.save_dictionary(
                language = self.tb_current_config["stt"]["language"]["value"], 
                domain = self.tb_current_config["stt"]["domain"]["value"],
                model = self.tb_current_config["stt"]["model"]["value"],
                word_entry=word_entry,
                ):
                logger.error(f"Error synchronizing dictionary: token {data['text']} will not be synchronized!")

        with open(os.path.join(user_appdata, 'dict', 'dictionary.jsonl'), "r", encoding="utf-8") as fdict:
            for i, line in enumerate(fdict.readlines()):
                try:
                    data = json.loads(line)
                    status, token, freq_class, prons = read_dict(data["text"])
                    if status=='NEW':
                        logger.info(f"New token found in local storage: {data['text']} - saving to DB ... ")
                        save_dict(data)
                    else:
                        missing_prons = []
                        for pron in [el["text"] for el in data["pronunciations"]]:
                            if pron not in prons:
                                 missing_prons.append(pron)
                        if len(missing_prons) > 0:
                            logger.info(f"New pronunciation {pron} for token {data['text']} found in local storage - saving to DB ... ")
                            save_dict(data)

                except Exception as e:
                    logger.warning(f"Wrong format in the input dictionary, line {i}, text: {line}, exception: {e}")

    def start_command_listener(self):
        logger.info("Starting listener for external commands!")
        self.inQueue = MSMQ(
            purge_before_start=get_settings_value(self.settings, ['integration', 'purge-queue-on-start'])
            )
        self.inQueue.signals.result.connect(self.external_command_received)
        self.inQueue.signals.finished.connect(self.queue_listener_stopped)
        # execute
        self.threadpool.start(self.inQueue)
        return
    
    def start_outQueue(self):
        # open tb_outQueue for writing
        queue=win32com.client.Dispatch("MSMQ.MSMQQueueInfo")
        computer_name = os.getenv('COMPUTERNAME')
        username_win = os.getenv('USERNAME')

        # check if there is a PRIVATE queue for the WIN user
        queue.FormatName="direct=os:"+computer_name+"\\PRIVATE$\\tb_outQueue"+"_"+username_win

        if not queue_exists(queue):
            logger.info(f"No PRIVATE out-queue found for the WIN user {username_win}, using SHARED out-queue!")
            queue.FormatName="direct=os:"+computer_name+"\\PRIVATE$\\tb_outQueue"
            
        try:
            # Open a ref to queue to write(2)
            q = queue.Open(2,0)
            return q
        except Exception as e:
            logger.warning(f"Can't open out queue for sending responses to exteral systems.\nIntegration over MSQM will not work.")
            return None
           
    def model_config(self):
        """
        If selected model is different than the current one,
        change the configuration. Otherwise do nothing.
        """
        # selected model
        selected_model = self.comboBox_model.currentText().split(",")

        # check if selected model is different than current and in case
        # it is, change the servis configuration
        current_framework = self.tb_current_config["stt"]["framework"].get("value", "") 
        current_language = self.tb_current_config["stt"]["language"].get("value", "") 
        current_domain = self.tb_current_config["stt"]["domain"].get("value", "")
        current_version = self.tb_current_config["stt"]["model"].get("value", "")
        
        if not (
            selected_model[0].strip()==current_framework and
            selected_model[1].strip()==current_language and
            selected_model[2].strip()==current_domain and
            selected_model[3].strip()==current_version
            ):
            self.stt.set_model(
                selected_model[0].strip(),
                selected_model[1].strip(),
                selected_model[2].strip(),
                selected_model[3].strip(),
            )
            self.tb_current_config = self.stt.get_configuration()
            # Enable dictionary if available
            self.dict_phoneset = self.is_dict_available(
                language=selected_model[1].strip(),
                domain=selected_model[2].strip(),
                model=selected_model[3].strip(),
                )
            # show icon for the dictionary if RIVA framework is selected OR if the model comes with a dictionary
            self.actionAddWord.setVisible(self.dict_phoneset is not False or (selected_model[0].upper()=='RIVA' and self.stt.get_user_boosting_words()!=False))
            # set postprocessing features
            self.set_postprocessing_features()
            # switch on truecaser if needed
            # DEPRECATED since ver25.02: self.check_trucasing_option(selected_model=selected_model[0].strip())

    def dictaphone_mode(self):
        """
        NOTE: this function is currently only triggered over the Toolbar. Pressing dictaphon button must be supported as well.
        """
        logger.debug(f"<<<< DICTAPHONE BUTTON PRESSED >>>>")

        # DICTAPHONE HAS BEEN SWITCHED ON
        if self.actionDictaphone.isChecked():
            # When DICTAPHONE button is pressed on the Toolbar, the dictaphone mode is enabled. This has two different behaviours:
            # a) if pressed while recording, it means user wants to take notes on the current session. In this case, the session must be closed and a new one opened for note taking. Note that this is only available for integrations, i.e. when listening to external commands
            # b) if pressed while in idle mode, it means user wants to record audio without any online transcription.
            if self.recording_state=='recording':
                # if not listening to external commands, do nothing, just return 
                if not get_settings_value(self.settings, ['integration', 'listen-for-external-commands']):
                    self.actionDictaphone.setChecked(False)
                    self.label_interim.setText("Med snemanjem diktafonski način ni omogočen!")
                    return
                
                if self.buffering==False:
                    # remember that a new session for note taking is requested
                    self.note_taking_mode = "requested"
                    # new session must be started - reset the self.continue_sessionId
                    self.continue_sessionId = None
                    # stop recording and close existing session
                    self.actionRecord.setIcon(self.icon_rec_idle)
                    logger.info("Recording stopped for note taking - new session will be triggered")
                    self.stt.end_session()
                    # Restore session name and notes
                    self.session_name = self.user_session_log[self.current_sessionid].session_name
                    self.session_notes = self.user_session_log[self.current_sessionid].session_notes
                    # When the current session is finished, automatically start new one for note taking. Check function thread_complete()
                    self.recording_state = 'idle'
                    self.label_interim.setText(f"Zajem pripomb za sejo {self.current_sessionid} ...")
                    self.widget_status.setStyleSheet(f"background-color: {cl_light_grey_string}")
                    return
                else:
                    logger.warning("Recording is in buffering mode. Dictaphone mode will not be enabled!")
                    self.label_interim.setText("V načinu ZAPOMNI diktafonski način ni omogočen!")
                    self.actionDictaphone.setChecked(False)
                    return
            elif self.recording_state=='pause':
                logger.warning("During PAUSE, dictaphone mode can not be enabled!")
                self.label_interim.setText("Med pavzo diktafonski način ni omogočen!")
                self.actionDictaphone.setChecked(False)
                return
            else:
                # if in idle mode, set label and color of the status widget
                #self.user_session_log[self.current_sessionid].type = 'dictaphone'
                self.label_interim.setText("Vklopljen je diktafonski način!")
                self.widget_status.setStyleSheet(f"background-color: {cl_light_yellow_string}")

        # DICTAPHONE HAS BEEN SWITCHED OFF
        # - dictaphone mode can only be switched OFF while recording if in note-taking mode, otherwise user must first stop recording
        else:
            # if switching OFF the dictaphone mode while recording, the dictaphone mode must become disabled and session finished
            if self.recording_state=='recording':
                if self.user_session_log[self.current_sessionid].type == 'note-taking':
                    self.stop_recording()
                else:
                    logger.warning("Dictaphone mode can not be switched off during recording!!")
                    self.actionDictaphone.setChecked(True)
                    return
            else:
                #self.user_session_log[self.current_sessionid].type = 'normal'
                self.label_interim.setText("")
                self.widget_status.setStyleSheet(f"background-color: {cl_light_green_string}")

    def is_dict_available(self, language, domain, model):
        if self.stt.get_model_phoneset(
            language=language,
            domain=domain,
            model=model,
            ):
            return True
        else:
            return False
            
    def set_input_device(self):
        self.stt.selected_input_device_index = self.comboBox_inputDevice.currentIndex()
        logger.debug(f"Device input set to {self.comboBox_inputDevice.currentIndex()} - {self.comboBox_inputDevice.currentText()}")
        self.label_interim.setText("")
        self.widget_status.setStyleSheet(f"background-color: {cl_light_green_string}")

    def patch_session(self, sname, snotes):
        if sname or snotes:
            logger.debug(f"Patching session name {sname} and notes {snotes} for session {self.current_sessionid}")
            self.stt.patch_session_name(sessionid=self.current_sessionid, name=sname, notes=snotes)          
        else:
            logger.debug(f"Session name and notes for session {self.current_sessionid} are empty. Nothing to patch.")  

    def patch_shares(self):
        users2share = self.comboBox_allowedUsers.currentText()
        if users2share != "":
            for u in users2share.split(','):
                userid = self.get_userid(u)
                if not userid or not str(userid).isnumeric():
                    logger.warning(f"Cannot add user {u} to session {self.current_sessionid}. User with this username does not exist in your group.")
                    continue
                self.stt.add_session_shares(sessionid=self.current_sessionid, userid=int(userid))

    def exitApp(self):
        logger.debug(f"<<<< EXIT APP BUTTON PRESSED >>>>")
        # check if user really wants to exit
        if self.user_authenticated and self.recording_state=='idle' and show_message_box(
            message='Ali res želite zapustiti aplikacijo?',
            box_title='Vprašanje',
            button_yes_text='Zapri',
            button_no_text='Prekliči',
            box_type='Warning',
            num_of_buttons=2
            ) != 1:
            return

        # display info on open threads
        logger.debug(f"Number of running threads: {threading.active_count()}")
        current_thread = threading.current_thread()
        #print(self.threadpool.activeThreadCount())
        logger.debug(f"Currently active thread: OS-ID={current_thread.native_id}, IDENT={current_thread.ident}, NAME={current_thread.getName()}")
        logger.debug(f"Current state: {self.recording_state}")
        logger.debug(f"Buffering state: {self.buffering}")

        # if currently in recording mode, do nothing
        if self.recording_state=='recording':
            logger.debug(f"Exit command will be ignored - the system is in recording state!")
            return

        # if in PAUSE mode, go to IDLE, not exit
        if self.recording_state=='pause':
            # if in Dictaphone mode, set label
            if self.actionDictaphone.isChecked():
                logger.info("Setting label for DICTAPHONE mode!")
                self.enable_dictaphone_label()
            
            self.actionRecord.setIcon(self.icon_rec_idle)
            self.recording_state='idle'

            # remove session id from the toolbar
            self.label_logged_user.setText(
                f'P: {self.last_stt_ping} | '
                f'<a href="open_templates">T: {len(self.templates)}</a> | '
                f'U: {self.lineEdit_username.text()}  '
            )
            
            # return in idle mode
            return

        # save settings
        self.qt_settings.setValue('auto-punctuation', self.checkBox_punctuation.isChecked())
        self.qt_settings.setValue('auto-capitalization', self.checkBox_capitalization.isChecked())
        self.qt_settings.setValue('denormalization', self.checkBox_denormalization.isChecked())
        #self.qt_settings.setValue('autofocus-window-title', self.lineEdit_destination.text())
        self.qt_settings.setValue('username', self.lineEdit_username.text())
        self.qt_settings.setValue('host', self.lineEdit_host.text())
        self.qt_settings.setValue('allowedUsers', self.comboBox_allowedUsers.currentText())
        self.qt_settings.setValue('input-device', self.comboBox_inputDevice.currentText())
        if self.radioButton_plain.isChecked():
            self.qt_settings.setValue('output_format', 'plain')
        elif self.radioButton_rtf.isChecked():
            self.qt_settings.setValue('output_format', 'rtf')
        elif self.radioButton_docx.isChecked():
            self.qt_settings.setValue('output_format', 'docx')
        elif self.radioButton_b21.isChecked():
            self.qt_settings.setValue('output_format', 'b21')    
        self.qt_settings.setValue('window size', self.size())
        self.qt_settings.setValue('window position', self.pos())

        # signal listener of external commands to stop listening on the MSMQ
        # closing queue while MSMQ runner is still listening will raise exception. Couldn't find any other solution. 
        if self.inQueue:
            self.inQueue.listening = False
            #logger.info(f"Closing listener for external commands!")
            #self.inQueue.queue.close()    
            # close outQueue as well
            logger.info(f"Closing outQueue!")
            self.outQueue.close()

        # save settings.yaml to AppData location as a backup
        # NOTE: this is now redundant, since settings are saved to this location every time they change
        #appdata_folder = os.path.join(os.getenv('APPDATA'), 'vitasis', 'tb-listener')
        #shutil.copy(os.path.join(basedir, "settings.yaml"), os.path.join(appdata_folder, f"settings.yaml"))
        # save date-time and app version on exit
        self.qt_settings.setValue('last-exit', time.strftime("%d.%m. %Y %H:%M:%S", time.localtime()))
        self.qt_settings.setValue('version-on-last-exit', app_version)

        sys.exit()

    def resize_settings_widget(self):
        logger.debug(f"<<<< SETTINGS BUTTON PRESSED >>>>")
        if self.frameGeometry().height() < self.main_window_height_L:
            # first switch off dictaphone mode if ON 
            #self.actionDictaphone.setChecked(False)
            #self.dictaphone_mode()
            # now resize
            self.setFixedSize(self.main_window_width_S, self.main_window_height_L)
        else:
            self.setFixedSize(self.main_window_width_L, self.main_window_height_S)
            # read settings
       
    def logout(self):
        self.lineEdit_username.setText("")
        self.lineEdit_password.setText("")
        self.comboBox_model.clear()
        self.pushButton_authenticate.setEnabled(True)
        self.pushButton_logout.setEnabled(False)
        self.lineEdit_destination.setEnabled(False)
        self.comboBox_allowedUsers.setEnabled(False)
        self.comboBox_inputDevice.setEnabled(False)
        self.radioButton_plain.setEnabled(False)
        self.radioButton_rtf.setEnabled(False)
        self.radioButton_docx.setEnabled(False)
        self.radioButton_b21.setEnabled(False)
        self.checkBox_punctuation.setEnabled(False)
        self.checkBox_capitalization.setEnabled(False)
        self.checkBox_denormalization.setEnabled(False)
        self.pushButton_sendLogs.setEnabled(False)
        self.pushButton_detailed_settings.setEnabled(False)
        self.lineEdit_host.setStyleSheet("background-color: white")
        self.lineEdit_username.setStyleSheet("background-color: white")
        self.lineEdit_password.setStyleSheet("background-color: white")
        self.comboBox_model.setStyleSheet(f"background-color: {cl_light_green_string}")
        self.comboBox_allowedUsers.setStyleSheet(f"background-color: {cl_light_green_string}")
        self.comboBox_inputDevice.setStyleSheet(f"background-color: {cl_light_green_string}")
        self.lineEdit_destination.setStyleSheet(f"background-color: {cl_light_green_string}")
        self.user_authenticated=False
        self.actionRecord.setVisible(False)
        self.actionDictaphone.setVisible(False)
        self.actionPin.setVisible(False)
        self.actionAddWord.setVisible(False)
        self.actionUpload.setVisible(False)
        self.actionReplacements.setVisible(False)
        self.counter = 0
        self.label_interim.setText("")
        self.label_logged_user.setText(" ")
        self.lineEdit_username.setFocus()
        # if in pause mode, make it idle, reset buffer and close transcript win if in open state
        self.actionRecord.setIcon(self.icon_rec_idle)
        self.recording_state = 'idle'
        self.label_rec_status.setText("")
        self.buffering = False
        self.buffer = ""
        if self.transcript_win:
            self.transcript_win.hide()
            self.actionPin.setChecked(False)
            # clear content from floating window but remember it
            self.last_transcript_win_content = self.transcript_win.ui.textEdit.toHtml()
            self.transcript_win.ui.textEdit.clear()

    def get_userid(self, username):
        if self.stt:
            for u in self.stt.group_users:
                if username.strip() == u['username'].strip():
                    return u['id']
        return None

    def set_postprocessing_features(self):
        if get_settings_value(self.tb_current_config, ['nlp', 'punctuation', 'enabled', 'isAllowed']):
            self.checkBox_punctuation.setEnabled(True)
            self.checkBox_punctuation.setChecked(get_settings_value(self.tb_current_config, ['nlp', 'punctuation', 'enabled', 'value']))
        else: 
            self.checkBox_punctuation.setEnabled(False)
        
        if get_settings_value(self.tb_current_config, ['nlp', 'enableTruecasing', 'isAllowed']):
            self.checkBox_capitalization.setEnabled(True)
            self.checkBox_capitalization.setChecked(get_settings_value(self.tb_current_config, ['nlp', 'enableTruecasing', 'value']))
        else: 
            self.checkBox_capitalization.setEnabled(False)
        
        if get_settings_value(self.tb_current_config, ['nlp', 'enableDenormalization', 'isAllowed']):
            self.checkBox_denormalization.setEnabled(True)
            self.checkBox_denormalization.setChecked(get_settings_value(self.tb_current_config, ['nlp', 'enableDenormalization', 'value']))
        else: 
            self.checkBox_denormalization.setEnabled(False)

    def change_postprocessing_feature(self, feature):
        if self.user_authenticated:
            if feature=='punct':
                new_config = dict(nlp=dict(punctuation=dict(enabled=dict(value=self.checkBox_punctuation.isChecked()))))
                self.stt.update_configuration(json.dumps(new_config))
            elif feature=='cap':
                new_config = dict(nlp=dict(enableTruecasing=dict(value=self.checkBox_capitalization.isChecked())))
                self.stt.update_configuration(json.dumps(new_config))
            elif feature=='denorm':
                new_config = dict(nlp=dict(enableDenormalization=dict(value=self.checkBox_denormalization.isChecked())))
                self.stt.update_configuration(json.dumps(new_config))

    def authenticate(self):
        def get_last_input_device_index():
            """
            Reads all inputs and returns index of the input that was selected last time
            If such input is not found, it returns zero, which refers to the System Default Input
            """
            last_input_device = self.qt_settings.value('input-device')
            if last_input_device:
                last_input_device = last_input_device.strip().lower()
                for k in self.stt.input_devices.keys():
                    if last_input_device == self.stt.input_devices[k].lower()[:len(last_input_device)]:
                        self.stt.selected_input_device_index = k
                        return k
            # if last_input_device not found among available input devices or last_input_device is None, 
            # set device_index to zero indicating that system input should be used 
            logger.warning(f"Stored input device '{last_input_device}' can not be found, system default will be used!")
            self.label_interim.setText("Izbran je privzeti mikrofon - preverite nastavitve!")
            self.widget_status.setStyleSheet(f"background-color: {cl_light_red_string}")
            
            self.stt.selected_input_device_index = 0
            return 0 
            
        # create config object
        _PLATFORM = self.lineEdit_host.text()
        use_proxy = get_settings_value(self.settings, ['proxy-server', 'use-proxy-server']) 
        proxy_ip = get_settings_value(self.settings, ['proxy-server', 'proxy-host-ip'])
        proxy_port = get_settings_value(self.settings, ['proxy-server', 'proxy-host-port'])
        
        _PROXY = None
        if use_proxy and proxy_ip and proxy_port:
            _PROXY = f"{proxy_ip}:{proxy_port}"

        if _PLATFORM.lower() == 'local':
            asr_server_address = "truebar-api:1337"
            self.tb_params["auth-url"]="http://keycloak:8080/auth/realms/truebar/protocol/openid-connect/token"
            use_local_server = True
            self.stt.http_protocol = 'http'
            logger.warning(f"Openning communication with local server!")
        else:
            asr_server_address = _PLATFORM+"-api.true-bar.si"
            self.tb_params["auth-url"]="https://"+_PLATFORM+"-auth.true-bar.si/auth/realms/truebar/protocol/openid-connect/token"
            use_local_server = False
            self.stt.http_protocol = 'https'

        self.tb_params.update(
            ASR_server=asr_server_address,
            username=self.lineEdit_username.text(),
            password=self.lineEdit_password.text(),
            proxy=_PROXY,
            use_local_server=use_local_server,
        )

        # dummy check: is local allowed
        if use_local_server:
            vld = False
            if os.path.isfile(os.path.join(basedir, "./.local")):
                with open(os.path.join(basedir, "./.local"), 'r', encoding="utf-8") as fin:
                    vthr = fin.readlines()[0].strip()
                    res = re.match(r'^\d+\.0$', vthr)
                    if res and float(vthr) > datetime.timestamp(datetime.now()):
                        vld = True
            if not vld:
                show_message_box(
                    message='Lokalna različica prepoznave govora ni nameščena oziroma nimate veljavne licence za njeno uporabo!',
                    box_title='Opozorilo',
                    button_yes_text='Zapri',
                    box_type='Warning',
                    num_of_buttons=1
                )
                return False

        # get authentication token
        if not self.stt.get_auth_token():
            if 'error_code' in self.stt.connection_errors[-1] and self.stt.connection_errors[-1]['error_code']==401:
                self.lineEdit_username.setStyleSheet("border: 1px solid red;")
                self.lineEdit_password.setStyleSheet("border: 1px solid red;")
            else:
                self.lineEdit_host.setStyleSheet("border: 1px solid red;")
            self.pushButton_authenticate.setEnabled(True)
            self.pushButton_logout.setEnabled(False)
            self.user_authenticated = False
            self.label_logged_user.setText(" ")

            return False

        else:
            # when user successfully authenticated, reset current session and user_session_log.
            self.current_sessionid = None
            self.user_session_log = dict() # we keep all user sessions here with their metadata (currently we hold: initiator=(external, user), type=(normal, dictaphone), session-name, session-notes)
            self.check_dictaphone_label()
            logger.info(f"User '{self.lineEdit_username.text()}' authenticated on host '{self.lineEdit_host.text()}'")
            logger.info(f"Client IP: {self.stt.get_ip()}")
            logger.info(f"Cleint MAC: {hex(uuid.getnode())}")
            # populate combo for the selection of an input device and preselect microphone 
            # that was used last time - if still available, otherwise select system input
            # NOTE: index of the first input device, detected by the system, starts with 1 and not 0!!! 
            # Zero index is used in this code for System Default Input
            self.comboBox_inputDevice.addItem("Privzet vhod sistema") # this goes to index 0
            for el in self.stt.input_devices.keys():
                self.comboBox_inputDevice.addItem(self.stt.input_devices[el])
            self.comboBox_inputDevice.setCurrentIndex(get_last_input_device_index())

            self.pushButton_authenticate.setEnabled(False)
            self.pushButton_logout.setEnabled(True)
            self.lineEdit_username.setStyleSheet("")
            self.lineEdit_password.setStyleSheet("")
            self.lineEdit_host.setStyleSheet("")
            self.lineEdit_destination.setStyleSheet("background-color: white")
            self.comboBox_model.setStyleSheet("background-color: white")
            self.comboBox_allowedUsers.setStyleSheet("background-color: white")
            self.comboBox_inputDevice.setStyleSheet("background-color: white")
            # show icons
            self.actionRecord.setVisible(True)
            self.actionDictaphone.setVisible(True)
            self.actionPin.setVisible(True)
            self.actionUpload.setVisible(True)
            self.actionReplacements.setVisible(True)
            self.user_authenticated = True
            # enable settings
            self.lineEdit_destination.setEnabled(True)
            self.comboBox_allowedUsers.setEnabled(True)
            self.radioButton_plain.setEnabled(True)
            self.radioButton_rtf.setEnabled(True)
            self.radioButton_docx.setEnabled(True)
            self.radioButton_b21.setEnabled(True)
            self.comboBox_model.setEnabled(True)
            self.comboBox_inputDevice.setEnabled(True)
            self.checkBox_punctuation.setEnabled(True)
            self.checkBox_capitalization.setEnabled(True)
            self.checkBox_denormalization.setEnabled(True)
            self.pushButton_sendLogs.setEnabled(True)
            self.pushButton_detailed_settings.setEnabled(True)
            # get available models
            available_models=self.stt.get_available_models()
            if len(available_models)==0:
                self.pushButton_authenticate.setEnabled(True)
                self.pushButton_logout.setEnabled(False)
                self.user_authenticated = False
                self.label_logged_user.setText(" ")
                self.lineEdit_username.setStyleSheet("border: 1px solid red;")
                self.lineEdit_password.setStyleSheet("border: 1px solid red;")
                return False

            for model in available_models:
                self.comboBox_model.addItem(f"{model['framework']}, {model['language']}, {model['domain']}, {model['model']}")
            # read current configuration
            self.tb_current_config = self.stt.get_configuration()
            # set combobox selection to the current model
            for i in range(self.comboBox_model.count()):
                if self.comboBox_model.itemText(i)==f"{self.tb_current_config['stt']['framework'].get('value', '')}, {self.tb_current_config['stt']['language'].get('value', '')}, {self.tb_current_config['stt']['domain'].get('value', '')}, {self.tb_current_config['stt']['model'].get('value','')}":
                    self.comboBox_model.setCurrentIndex(i)
                    break

            logger.info(f"Selected model: {self.comboBox_model.currentText()}")
            logger.info(f"Selected input device: {self.comboBox_inputDevice.currentText()}")

            # Enable dictionary if supported by the model
            self.dict_phoneset = self.is_dict_available(
                    language=self.tb_current_config['stt']['language']['value'],
                    domain=self.tb_current_config['stt']['domain']['value'],
                    model=self.tb_current_config['stt']['model']['value'],
                    )
            # show icon for the dictionary if RIVA framework is selected OR if the model comes with a dictionary
            self.actionAddWord.setVisible(self.dict_phoneset is not False or (self.comboBox_model.currentText().strip().split(',')[0].upper()=='RIVA' and self.stt.get_user_boosting_words()!=False))
            # check status of the model - if running, color the icon in red and
            # start timer to periodically check the status! Once finished, stop
            # the timer
            if get_model_update_status(
                language=self.tb_current_config['stt']['language']['value'],
                domain=self.tb_current_config['stt']['domain']['value'],
                model=self.tb_current_config['stt']['model']['value'],
                tb_object=self.stt,
                )=='RUNNING':
                self.actionAddWord.setIcon(self.icon_dict_running)
                self.model_update_timer=QTimer()
                self.model_update_timer.setInterval(3000)
                self.model_update_timer.timeout.connect(self.check_model_status)
                self.model_update_timer.start()
            else:
                self.actionAddWord.setIcon(self.icon_dict_idle)
            # Set postprocessing as it was the last time
            self.set_postprocessing_features()
            # check model and switch on truecasing if RIVA or NEMO is selected
            # DEPRECATED since ver25.02: self.check_trucasing_option(selected_model=self.comboBox_model.currentText().split(',')[0].strip())
            # Get group users
            self.stt.group_users = self.stt.get_users_in_my_group()
            users2share = []
            if 'allowedUsers' in self.qt_settings.allKeys():
                users2share = self.qt_settings.value('allowedUsers')
                if users2share:
                    users2share = [usr.strip() for usr in users2share.split(',')]
                else:
                    users2share = []
            for el in self.stt.group_users:
                self.comboBox_allowedUsers.addItem(el['username'], None, el['username'] in users2share)
            self.comboBox_allowedUsers.updateText()
            # Resize and move window to last position - if not out of current screen
            self.show_interims()
            if 'window position' in self.qt_settings.allKeys():
                last_position = self.qt_settings.value('window position')
                monitor_info = get_monitor_resolutions()
                if (monitor_info['width'] >= last_position.x() + _main_window_width_L and monitor_info['height'] >= last_position.y()) and (last_position.x()>=0 and last_position.y()>=0):
                    logger.debug(f"Moving toolbar to last known position")
                    self.move(self.qt_settings.value('window position'))
            # if minimize-after-login is True, minimize the toolbar into the tray
            if get_settings_value(self.settings, ['general', 'system-tray', 'minimize-after-login']):
                self.hide()
            # create but not show transcript window and position it below toolbar
            self.create_transcript_window()
            self.template_placeholder_endsymbol = "}"
            self.template_placeholder_startsymbol = "{"
            ### sync dictionary
            # TODO: dictionary sync may take some time which will block GUI to render. The synchronization should be implemented as a background task (QRunnable)
            if get_settings_value(self.settings, ['general', 'synchronize-dictionary']) and os.path.isfile(os.path.join(user_appdata, 'dict', 'dictionary.jsonl')):
                self.sync_dictionary()

            return True

    def check_model_status(self):
        language = self.tb_current_config["stt"]["language"]["value"]
        domain = self.tb_current_config["stt"]["domain"]["value"]
        model = self.tb_current_config["stt"]["model"]["value"]
        
        model_updater_status = get_model_update_status(language=language, domain=domain, model=model, tb_object=self.stt)

        # refresh registry entry 
        self.model_updates[f"{language}{domain}{model}"].update(
            status=model_updater_status,
            last_check=time.strftime('%H:%M:%S', time.gmtime(time.time()))
            )
        self.qt_settings.setValue('model-updates', self.model_updates)
        
        if model_updater_status:
            # if updater is running, keep icon in red
            if model_updater_status == "RUNNING":
                self.actionAddWord.setIcon(self.icon_dict_running)
            # if update is IDLE or in FAILED state, put icon back in black and stop timer if running
            else:
                self.actionAddWord.setIcon(self.icon_dict_idle)
                if self.model_update_timer.isActive():
                    self.model_update_timer.stop()

    def record(self):
        if self.recording_state == 'recording':
            self.stop_recording()
        else:
            self.start_recording()

    def stop_recording(self):
        self.actionRecord.setIcon(self.icon_rec_idle)
        logger.debug(f"Recording status: {self.recording_state}")
        logger.info("Recording stopped")
        self.stt.end_session()
        self.recording_state = 'idle'
        # reset buffer
        self.buffering = False
        self.buffer = ""
        # hide if user settings requires that
        if get_settings_value(self.settings, ['general', 'system-tray', 'minimize-after-login']):
            self.hide()

    def pause_recording(self):
        self.actionRecord.setIcon(self.icon_rec_pause)
        logger.debug(f"Recording status: {self.recording_state}")
        logger.info("Recording paused")
        self.stt.end_session()
        self.recording_state = "pause"

    def show_interims(self):
        self.setFixedSize(self.main_window_width_L, self.main_window_height_S)

    def display_status(self, status):
        # status type 'progress' brings message on the streamer status, which can be one of 
        # the following: 'started' - means that recording has started, 'pause' or 'finished'

        if status["stype"]=="progress":
            if status["value"]=="started":
                self.actionRecord.setIcon(self.icon_rec_started)
                self.recording_state = 'recording'
            elif status["value"]=="finished":
                self.actionRecord.setIcon(self.icon_rec_idle)
                self.recording_state = 'idle'
                self.label_rec_status.setText("")
                # remove session id from the toolbar
                self.label_logged_user.setText(
                    f'P: {self.last_stt_ping} | '
                    f'<a href="open_templates">T: {len(self.templates)}</a> | '
                    f'U: {self.lineEdit_username.text()}  '
                )
            elif status["value"]=="pause":
                self.actionRecord.setIcon(self.icon_rec_pause)
                self.recording_state = 'pause'
                self.buffer = status["buffer"]
            # if IDLE or PAUSE, hide the toolbar (including floating window) if user settings requires so
            if status["value"] in ('finished') and get_settings_value(self.settings, ['general', 'system-tray', 'minimize-after-login']):
                self.transcript_win.hide()
                self.hide()
        
        # label_logged_user is abused to additionaly display ping time (P) and number of templates (T)
        elif status["stype"]=="ping":
            self.last_stt_ping = int(float(status["value"])*1000)
            self.label_logged_user.setText(
                f'P: {self.last_stt_ping} | '
                f'<a href="open_templates">T: {len(self.templates)}</a> | '
                f'U: {self.lineEdit_username.text()}  '
            )
        
        # status type 'sessionid' will come when session identifier has been assigned to the session.
        # display sessionid in the toolbar
        # If an external listener is activated, this message is forwarded to the out queue 
        elif status["stype"]=="sessionid":
            self.current_sessionid = status["value"]
            # if note taking has been initated, lable the session type as "note-taking" 
            if self.note_taking_mode == 'initiated':
                self.user_session_log[self.current_sessionid] = SessionMetadata(type='note-taking')
                self.enable_dictaphone_label()
                self.note_taking_mode = None
            else:
                self.user_session_log[self.current_sessionid] = SessionMetadata(type='normal')
            # patch session name and notes if set by the caller
            #if get_settings_value(self.settings, ['integration', 'listen-for-external-commands']):
            if self.session_name or self.session_notes:
                logger.debug(f"Assigning session name {self.session_name} and notes {self.session_notes} to current session {self.current_sessionid}")
                self.patch_session(self.session_name, self.session_notes)
                self.user_session_log[self.current_sessionid].session_name = self.session_name
                self.user_session_log[self.current_sessionid].session_notes = self.session_notes
                self.session_name = None
                self.session_notes = None
                
            self.label_logged_user.setText(
                f'P: {self.last_stt_ping if self.last_stt_ping else "-"} | '
                f'<a href="open_templates">T: {len(self.templates)}</a> | '
                f'S: {self.current_sessionid} | '
                f'U: {self.lineEdit_username.text()}  '
            )
            if self.active_external_msg_id:
                self.user_session_log[self.current_sessionid].initiator = "external"
                self.send_reponse(self.active_external_msg_id, f'cmd_status=True | response={self.current_sessionid}')
            else:
                self.user_session_log[self.current_sessionid].initiator = "user"
        
        # with status type 'interim' we intercept ASR interims and display them in the toolbar
        # In dictaphone mode this message is ignored
        elif status["stype"]=="interim" and not self.actionDictaphone.isChecked():
            self.label_interim.setStyleSheet("color: gray")
            self.label_interim.setText(status["value"])
        
        elif status["stype"]=="final-command":
            # if formatting command, make neccessary changes on GUI
            if status["value"] in ('<showcmd>', '<close>', '<b>', '</b>', '<i>', '</i>', '<u>', '</u>', '<uc>', '</uc>', '<lc>', '</lc>', '<spell>', '</spell>'):
                self.toggle_button(status["value"], status["value"][1]!="/")
                # if open/close commands dialog ...
                if status["value"]=='<showcmd>':
                    self.open_commands_helper()
                if status["value"]=='<close>':
                    self.commands_helper.ui.pushButton_close.click()
                    self.COMMANDS_dialog_opened=False
                    wtof = self.lineEdit_destination.text().strip()
                    if wtof:
                        #set_focus_to_window(wtof)
                        self.win_mnpl.set_focus_to_window(wtof)
                # if UC, switch off LC and vice versa
                if status["value"]=='<uc>':
                    self.toggle_button('<lc>', False)
                if status["value"]=='<lc>':
                    self.toggle_button('<uc>', False)
            
            # if command to start buffering, indicate that on the GUI and open floating window if closed
            if status["value"]==get_settings_value(self.settings, ["user-defined-commands", "start-buffering"]):
                self.label_rec_status.setText("\u25BA pomnjenje | ")
                self.buffering = True
                # open floating window if hiden
                if not self.actionPin.isChecked() and not get_settings_value(self.settings, ["general", "dont-show-transcript-win"]):
                    self.move_transcript_window()
                    self.transcript_win.show()
                    self.actionPin.setChecked(True)

            # if command to end buffering, clear the label indicating that on the GUI
            if status["value"]=="<paste>":
                self.label_rec_status.setText("")
                self.buffering = False
                # setting flashing flag to False is actually redundant since there is another condition that 
                # has to be met in order for flashing to work, namely the system must be in "buffering" mode...
                #self.flashing_flag = False

            # show the command as last interim (if not in dictaphone mode). Use black color
            if not self.actionDictaphone.isChecked():
                self.label_interim.setStyleSheet("color: black")
                self.label_interim.setText(f'<b>ukaz</b>: {status["value"].replace(">","").replace("<","")}')
            
            if get_settings_value(self.settings, ['general', 'beep-on-finals']): 
                winsound.Beep(4000, 5)
        
        elif status["stype"]=="final":

            #self.transcript_win.ui.textEdit.insertPlainText(status["value"])

            # show fist n characters of the final as last interim (unless in dictaphone mode)
            if not self.actionDictaphone.isChecked():
                self.label_interim.setStyleSheet("color: black")
                if status["value"] and len(status["value"]) > _interim_display_len:
                    show_text = "..." + status["value"][-_interim_display_len:]
                else:
                    show_text = status["value"]
                self.label_interim.setText(f'<b>{show_text}</b>')
            if get_settings_value(self.settings, ['general', 'beep-on-finals']):
                winsound.Beep(4000, 10)

    def display_transcript(self, res):
        """
        This function is called from the Streamer every time a hypothesis is returned, final or an interim.
        It takes care for displaying the text in the destination window (either the floating window or any other
        user defined window)
        """
        def set_focus_to_destination_window():
            # set focus to destination window:
            # - if window is locked (self.locked_window['hndl'] != None) --> focus to the locked window
            # - if the session was started from an external command (self.wtof != None) --> focus to self.wtof
            # - otherwise focus to wtof
            if self.locked_window and self.locked_window.get('hwnd') and self.locked_window['hwnd'] != windll.user32.GetForegroundWindow():
                logger.debug(f"Setting focus to LOCKED window with handle {self.locked_window.get('hwnd')}")
                #self.win_mnpl.focus_window_without_click(self.locked_window)
                self.win_mnpl.set_focus_to_window_handle(self.locked_window['hwnd'])
            elif self.wtof and self.wtof != windll.user32.GetForegroundWindow():
                logger.debug(f"Setting focus to B21 window with handle {self.wtof}") 
                #set_focus_to_window_handle(self.wtof)
                self.win_mnpl.set_focus_to_window_handle(self.wtof)
            else:
                wtof = self.lineEdit_destination.text().strip() 
                if wtof:
                    logger.debug("Setting focus to destination window ...")
                    #set_focus_to_window(wtof)
                    self.win_mnpl.set_focus_to_window(wtof)

        def copy_content_to_destination_window(source=None):
            """
            Copy content of transcription window to destination window.
            Add new line before the content so that in the destination window text will start in next line. 
            """
            time.sleep(0.3)
            logger.debug("PASTING content ...")
            self.transcript_win.hide()
            self.actionPin.setChecked(False)
            # set focus to destination window
            set_focus_to_destination_window()
            # copypaste content
            text_to_copy = self.text_corrector.correct_typos(self.transcript_win.ui.textEdit.toPlainText().replace(self.template_placeholder_endsymbol, "").replace(self.template_placeholder_startsymbol, "").replace("_", ""))
            # if request to copy content is coming from the <paste> command - paste the content in a new line.
            if source=="command":
                text_to_copy = "\n" + text_to_copy
            pyperclip.copy(text_to_copy)
            keyboard.press_and_release('ctrl+v')
            # clear content from floating window
            self.last_transcript_win_content = self.transcript_win.ui.textEdit.toHtml()
            self.transcript_win.ui.textEdit.clear()

        def scroll_to_end():
            cursor.movePosition(QTextCursor.End)
            self.transcript_win.ui.textEdit.setTextCursor(cursor)
            self.transcript_win.ui.textEdit.ensureCursorVisible()
            
        def delete_last_word():
            # if whole text is selected - happens after command "izberi vse", detect that and remove it
            # otherwise remove last word
            if cursor.hasSelection() and cursor.selectionStart() == 0 and cursor.selectionEnd() == len(self.transcript_win.ui.textEdit.toPlainText()):
                cursor.removeSelectedText()
            else:
                cursor.movePosition(cursor.PreviousWord, cursor.KeepAnchor)
                if set(cursor.selectedText()).issubset(".,!?;:-*+"):    
                    cursor.movePosition(cursor.PreviousWord, cursor.KeepAnchor)
                # dont delete template tokens
                if cursor.selectedText().find("#")==-1:
                    cursor.removeSelectedText()

        def delete_last_n_characters(n):
            cursor.movePosition(cursor.PreviousCharacter, cursor.KeepAnchor, n)
            cursor.removeSelectedText()
        
        def delete_last_sentence():
            plain_text = self.transcript_win.ui.textEdit.toPlainText()[:cursor.position()+1]
            if len(plain_text)>0 and plain_text[-1]=='_':
                plain_text = plain_text[:-1]
            match = re.search(r'[^.!?]+[.!?\s]*$', plain_text)
            if match:
                last_sentence_end = match.end()
                last_sentence_start = match.start()
                cursor.setPosition(last_sentence_end)
                # if in template mode, do not delete tokens that are part of the template
                placeholder_position = plain_text[last_sentence_start:last_sentence_end].rfind(self.template_placeholder_endsymbol) 
                if placeholder_position != -1:
                    print("I GOT IT :)))))")
                    last_sentence_start = placeholder_position + 1
                cursor.setPosition(last_sentence_start, QTextCursor.KeepAnchor)
                cursor.removeSelectedText()

        def delete_spaces_to_left():
            while cursor.positionInBlock() > 0 and cursor.block().text()[cursor.positionInBlock() - 1].isspace():
                cursor.movePosition(QTextCursor.Left, QTextCursor.KeepAnchor)
            cursor.removeSelectedText()

        def move_to_prev_input(twin):
            cursor_position = cursor.position()
            plain_text = twin.textEdit.toPlainText()
            prev_field_pos = plain_text[:cursor_position-1].rfind(twin.input_field_symbol)
            if prev_field_pos != -1:
                # move cursor
                cursor.setPosition(prev_field_pos)
                twin.textEdit.setTextCursor(cursor)
                # highlight field
                twin.highlight_field()

        def move_to_next_input(twin):
            cursor_position = cursor.position()
            plain_text = twin.textEdit.toPlainText()
            next_field_pos = plain_text[cursor_position+1:].find(twin.input_field_symbol)
            if next_field_pos != -1:
                next_field_pos += cursor_position + 1
                # move cursor
                cursor.setPosition(next_field_pos)
                twin.textEdit.setTextCursor(cursor)
                # highlight field
                twin.highlight_field()

        def move_first_input(twin):
            plain_text =  twin.textEdit.toPlainText()
            first_field_pos = plain_text.find(twin.input_field_symbol)
            if first_field_pos != -1:
                # move cursor
                cursor.setPosition(first_field_pos)
                twin.textEdit.setTextCursor(cursor)
        
        def handle_command(cmd):
            cmd = cmd.lower()
            # opomba
            if cmd == "<comment>":
                if self.buffering:
                    if self.transcript_win.ui.textEdit.toPlainText().strip()=="":
                        self.transcript_win.ui.textEdit.insertPlainText("*** OPOMBE ***\n")
                    else:
                        self.transcript_win.ui.textEdit.insertPlainText("\r\n*** OPOMBE ***\n")
                else:
                    pyperclip.copy("\r\n*** OPOMBE ***")
                    keyboard.press_and_release('ctrl+v')
                    keyboard.press_and_release('enter')
                self.line_start = True
            
            # delete complete content
            if cmd == "<delall>":
                if self.buffering:
                    self.last_transcript_win_content = self.transcript_win.ui.textEdit.toHtml()
                    self.transcript_win.ui.textEdit.clear()
                else:
                    keyboard.press_and_release('ctrl+a')
                    keyboard.press_and_release('backspace')
                self.line_start = True

            # return previous text (text from previous copy-past session)
            if cmd == "<textback>":
                self.transcript_win.ui.textEdit.insertHtml(self.last_transcript_win_content)
            
            # print without space
            if cmd == "<nospace>":
                self.modifiers['noSpace']=True

            if cmd == "<withdigits>":
                self.modifiers['withDigits']=True
            
            # paste
            if cmd == "<paste>":
                if self.buffering:
                    self.buffering = False
                    copy_content_to_destination_window(source="command")
                else:
                    logger.debug(f"PASTE command detected, but buffering mode is OFF, ignoring ...")

            # space
            if cmd == "<spc>":
                self.transcript_win.ui.textEdit.insertPlainText(" ")

            # new line
            if cmd == "<nl>":
                if self.buffering:
                    self.transcript_win.ui.textEdit.insertPlainText("\n")
                else:
                    keyboard.press_and_release('\n')
                self.line_start = True

            # new paragraph
            if cmd == "<np>":
                if self.buffering:
                    self.transcript_win.ui.textEdit.insertPlainText("\n\n")
                else:
                    keyboard.press_and_release('\n')
                    keyboard.press_and_release('\n')
                self.line_start = True
            
            # upper case
            if cmd == "<uc>":
                self.modifiers['upper']=True
                self.modifiers['lower']=False
            if cmd == "</uc>":
                self.modifiers['upper']=False
            
            # lower case
            if cmd == "<lc>":
                self.modifiers['lower']=True
                self.modifiers['upper']=False
            if cmd == "</lc>":
                self.modifiers['lower']=False
            
            # next lower
            if cmd == "<lcc>":
                self.modifiers['withLower']=True
            
            # cap case or next upper
            if cmd == "<cc>":
                self.modifiers['cap']=True
            if cmd == "</cc>":
                self.modifiers['cap']=False
            
            # next upper
            if cmd == "<ucc>":
                self.modifiers['withUpper']=True
            
            # bold
            if cmd == "<b>":
                self.modifiers['bold']=True
                if not self.buffering:
                    keyboard.press_and_release('ctrl+b')
            if cmd == "</b>":
                self.modifiers['bold']=False
                if not self.buffering:
                    keyboard.press_and_release('ctrl+b')
           
            # italic
            if cmd == "<i>":
                self.modifiers['italic']=True
                if not self.buffering:
                    keyboard.press_and_release('ctrl+i')
            if cmd == "</i>":
                self.modifiers['italic']=False
                if not self.buffering:
                    keyboard.press_and_release('ctrl+i')
            
            # underline
            if cmd == "<u>":
                self.modifiers['underline']=True
                if not self.buffering:
                    keyboard.press_and_release('ctrl+u')
            if cmd == "</u>":
                self.modifiers['underline']=False
                if not self.buffering:
                    keyboard.press_and_release('ctrl+u')
           
            # insert template
            if cmd == "<ins>":
                if self.buffering:
                    #logger.warning("TEMPLATES are not supported in this mode!!")
                    self.modifiers["insert"]=True
                else:
                    self.modifiers["insert"]=True
                # Show template selector if templates index is not None 
                if self.templates_index:
                    if not self.template_viewer:
                        self.template_viewer = TemplateViewer(self.templates_index, self.templates_index_shared, self)
                        if self.template_viewer.exec_():
                            logger.debug(f"Manually selected template: {self.template_viewer.selected_template}")
                            # load template
                            cmd_arg = self.template_viewer.selected_template.split()[0].strip(".").lower()
                            logger.debug(f"Loading template with ID: {cmd_arg}")
                            if self.buffering:
                                self.transcript_win.ui.textEdit.insertPlainText(self.templates[cmd_arg])
                            else:
                                 # Focus to the selected destination window and copy template content
                                set_focus_to_destination_window()
                                pyperclip.copy(self.templates[cmd_arg])
                                keyboard.press_and_release('ctrl+v')
                        self.template_viewer = None
                    else:
                        logger.debug("Raising popup")
                        self.template_viewer.raise_()  # Bring the existing viewer to the front
            
            # delete word
            if cmd == "<delw>":
                if self.buffering:
                    delete_last_word()
                else:
                    keyboard.press_and_release('backspace')
            
            # delete sentence
            if cmd == "<dels>":
                delete_last_sentence()   
            
            # delete last n symbols
            if cmd[:6] == "<deln_":
                n = int(cmd.split('_')[1].strip('>'))
                if self.buffering:
                    delete_last_n_characters(n)
                else:
                    for i in range(0, n):
                        keyboard.press_and_release('backspace')
                        time.sleep(0.02)
            
            # handle navigation between input fields (symbol _)
            if cmd == "<prev>":
                move_to_prev_input(self.transcript_win.ui)
            if cmd == "<next>":
                move_to_next_input(self.transcript_win.ui)
            
            # after paste hide the window
            if cmd == "<paste>":
                self.transcript_win.hide()
                self.actionPin.setChecked(False)
            
            # select all text
            if cmd == "<selectall>":
                if self.buffering:
                    self.transcript_win.ui.textEdit.selectAll()
                else:
                    keyboard.press_and_release('ctrl+a')
            
            # display command on toolbar
            self.display_status(status=dict(stype="final-command", value=cmd))
            
            # change field holder position if in template mode 
            if self.transcript_win.ui.current_highlight_position:
                self.transcript_win.ui.current_highlight_position = cursor.position()

        def get_spp_code_description(text):
            return self.text_corrector.handle_spp_codes(text)

        def convert_tokens_to_commands(t):
            t_ref = t
            t = self.text_corrector.handle_translations(t, self.translations)    
            if t_ref != t: 
                logger.debug(f"IDENTIFIED COMMANDS: {t_ref} --> {t}")
            return t    
        
        def text_segments(input_string):
            input_string = convert_tokens_to_commands(input_string)
            segments = re.split(r'(<[\/\w]+>)', input_string)
            res = []
            for s in [segment.strip() for segment in segments if segment.strip()]:
                if s[0]=="<":
                    res.append(dict(htype="command", text=s))
                else:
                    res.append(dict(htype="text", text=s))
            return res
        
        def get_last_non_space_character(t, pos):
            for i in range(min(pos, len(t)-1), 0, -1):
                if t[i] != " ":
                    return t[i]
            return None
   
        def remove_disabled_commands(t):
            """
            Check which commands are disabled and remove them from the hypothesis
            """
            t_orig = t
            enabled_commands_setting = get_settings_value(self.settings, ['user-defined-commands', 'enabled-commands'])
            if enabled_commands_setting:
                disabled_commands = [key for item in enabled_commands_setting for key, value in item.items() if not value]
            else:
                disabled_commands = []
            for cmd in ('b', 'i', 'u', 'uc', 'lc'):
                if cmd in disabled_commands:
                    disabled_commands.append(f'/{cmd}')
            for cmd in disabled_commands:
                t = t.replace(f'<{cmd}>', '')
            return t!=t_orig, t

        def is_named_entity(t, named_entities, treshold=0.75):
            """
            Returns True if t is a named entity
            Args:
            - t: token
            - named_entities: dict of named entities. Each token has values for L (lowercased), U (uppercased), C (capital) and M (mixed). 
                Each value tells how many occurancies of the token t appeared in upper, lower, capital and mixed case.
            - treshold: if in more than 'treshold' cases token t appeared as lowercase token, then return False
            """

            def remove_trailing_symbols(t):
                return "".join([c for c in t if c.isalpha()])
            
            t = t.lower()
            t = remove_trailing_symbols(t)

            if t in named_entities:
                if (named_entities[t]['C'] + named_entities[t]['U'] + named_entities[t]['M']) == 0 or \
                    named_entities[t]['L'] / (named_entities[t]['C'] + named_entities[t]['U'] + named_entities[t]['M']) > treshold:
                    return False
                else:
                    return True
            
            return False

        def truecase_first_token(text):
            if not text:
                return text
            # if hypothesis starts with .!?, return as is - no need for truecasing first token - it should already be returned in the correct case from the model
            if text[0] in set('.!?'):
                return text
            # split text to tokens
            tokens = text.split()
            # get first non-punct token and check if NE
            new_text = []
            first_real_token = True
            for t in tokens:
                if t.strip() in set(',:;)()+-x="%$*'):
                    new_text.append(t)
                elif first_real_token:
                    # if the first real token is not NE and the token is not all upper, chenge the first letter to lowercase
                    # TODO: if the TRUECASER workse OK, this should be removed as the ASR would expected to return already in the correct casing!!!s
                    if not is_named_entity(t, self.named_entities) and not t.upper()==t:
                        t = t[0].lower() + t[1:]
                    else:
                        t = t[0].upper() + t[1:]
                    new_text.append(t)
                    first_real_token = False
                else:
                    new_text.append(t)
            return " ".join(new_text)    

        # if in Dictaphone mode, do nothing
        if self.actionDictaphone.isChecked():
            logger.debug("Dictaphone mode ... skipping transcript display")
            return

        # if in buffering state and floating window is currently hidden, open it
        if self.buffering and not self.actionPin.isChecked() and not get_settings_value(self.settings, ["general", "dont-show-transcript-win"]):
            self.move_transcript_window()
            self.transcript_win.show()
            self.actionPin.setChecked(True)
        
        cursor = self.transcript_win.ui.textEdit.textCursor()

        if res.get("text", None):

            # if res is a final text or final command
            if res.get("final", None):
                
                logger.debug(f"ASR RESPONSE: {res['text']}")

                # eliminate known ASR error - NOTE: this should be handled on a higher level, e.g. with ZAMENJAVE
                text_to_truecase = self.text_corrector.correct_commands_mismatch(res['text'])
                text_to_truecase = self.text_corrector.handle_symbols(text_to_truecase)
                text_to_truecase = self.text_corrector.handle_composite_commands(text_to_truecase)
                text_to_truecase, performed_corrections = self.text_corrector.handle_numbers(text_to_truecase)
                if text_to_truecase != res['text']:
                    logger.debug(f"CORRECTED TEXT: {text_to_truecase}")

                # remove disabled commands if received from the model 
                text_changed, text_to_truecase = remove_disabled_commands(text_to_truecase)
                if text_changed:
                    logger.debug(f"TEXT WITHOUT DISABLED COMMANDS: {text_to_truecase}")

                # truecase the first token
                tc_text = None
                text_to_truecase_orig = text_to_truecase
                text_to_truecase = truecase_first_token(text_to_truecase)
                if text_to_truecase != text_to_truecase_orig:
                    logger.debug(f"TRUECASED FIRST TOKEN: {text_to_truecase}")
                
                if not tc_text:
                    tc_text = text_to_truecase
                
                # if space, make space and continue
                if res["text"] == " ":
                    if self.buffering:
                        self.transcript_win.ui.textEdit.insertPlainText(" ")
                    else:
                        keyboard.press_and_release('space')
                
                else:
                    for text_segment in text_segments(tc_text): 

                        logger.debug(f"TEXT_SEGMENT: {text_segment}")

                        if text_segment.get("htype", None)=='text':
                            
                            text_to_print = text_segment["text"]

                            # Check if SPP code. SPP codes are expected to be dictated as commands - complete final is checked if it represents a SPP code
                            # The checking will only be performed if text_to_print without spaces is less than 6 characters long (no code is longer) and if
                            # postprocessing of SPP codes is set in the settings to ON.
                            if get_settings_value(self.settings, ['general', 'do-postprocessing', 'spp-codes']) and len(text_to_print.strip().replace(" ", "")) < 6:
                                formated_spp_code = get_spp_code_description(text_to_print)
                                if formated_spp_code:
                                    logger.debug(f"SPP code detected: {formated_spp_code}")
                                    text_to_print = formated_spp_code

                            # if insert is ON, load template if next token defines one, and there is no other token in the text segment
                            if self.modifiers['insert']:
                                cmd_arg = text_to_print.strip(".").lower()
                                # make sure to convert word numbers ena, dva, tri, ... to digits
                                cmd_arg = str(word_numbers[cmd_arg]) if cmd_arg in word_numbers else cmd_arg
                                # local templates
                                if get_settings_value(self.settings, ['general', 'use-local-templates']):
                                    # TODO: hardcoded to demonstrate use of tables in MS Word
                                    if cmd_arg == "99":
                                        template_file = os.path.join(user_appdata, 'templates', '99.docx')
                                        if os.path.isfile(template_file):
                                            copy_word_template(template_file)
                                            continue
                                    # ............. 
                                    if cmd_arg in self.templates.keys():
                                        # if template viewer is opened, close it
                                        if self.template_viewer and self.template_viewer.isVisible():
                                            self.template_viewer.close()
                                        logger.debug(f"Loading local template: {text_to_print}")
                                        if self.buffering:
                                            self.transcript_win.ui.textEdit.insertPlainText(self.templates[cmd_arg])
                                        else:
                                            # Focus to the selected destination window and copy template content
                                            set_focus_to_destination_window
                                            pyperclip.copy(self.templates[cmd_arg])
                                            keyboard.press_and_release('ctrl+v')
                                        continue
                                    else:
                                        logger.debug(f"Insert command is followed by unknown template name {text_to_print} - ignoring")
                                    self.modifiers['insert'] = False
                                # B21 templates
                                else:
                                    if self.buffering:
                                        pass
                                    else:
                                        b21_template_cmd = f'{self.b21_template_token}{cmd_arg}'
                                        logger.debug(f"Lunching B21 template command: {b21_template_cmd}")
                                        pyperclip.copy(b21_template_cmd)
                                        keyboard.press_and_release('ctrl+v')
                                        keyboard.press_and_release(self.settings["commands"]['<nl>'][self.dictation_type]["keyboard_press"])
                            
                            # handle casing
                            logger.debug(f"INPUT TEXT: {text_to_print}")
                            logger.debug(f"ACTIVE MODIFIERS: {[s for s in self.modifiers.keys() if self.modifiers[s]]}")
                            if self.modifiers['upper']:
                                text_to_print = text_to_print.upper()
                            elif self.modifiers['lower']:
                                text_to_print = text_to_print.lower()
                            elif self.modifiers['withLower']:
                                text_to_print = text_to_print[0].lower() + text_to_print[1:]
                            elif self.modifiers['cap'] or self.modifiers['withUpper']:
                                text_to_print = text_to_print[0].upper() + text_to_print[1:]
                            # handle font weight and style - bold, italic, underline
                            if self.modifiers['bold']:
                                text_to_print = f"<b>{text_to_print}</b>"
                            if self.modifiers['italic']:
                                text_to_print = f"<i>{text_to_print}</i>"
                            if self.modifiers['underline']:
                                text_to_print = f"<u>{text_to_print}</u>"
                            # handle print with digits
                            if self.modifiers['withDigits']:
                                text_to_print = self.text_corrector.handle_word2symbols(self.text_corrector.handle_word2digit(text_to_print))
                                self.modifiers['withDigits'] = False
                            # handle print without space
                            if self.modifiers['noSpace']:
                                # first replace all words to numbers since if written without spaces numbers must be digits
                                text_to_print = self.text_corrector.handle_word2digit(text_to_print)
                                text_to_print = text_to_print.replace(" ", "")
                                self.modifiers['noSpace'] = False
                            logger.debug(f"OUTPUT TEXT: {text_to_print}")

                            # handle insert - not covered yet in this version - in floating window mode, tamplates should be supported with fields
                            if self.modifiers["insert"] and False:
                                if text_to_print.isnumeric():
                                    self.modifiers["insert"]=False
                                    self.template_mode = True
                                    self.modifiers["template_init"]=True
                                    text_to_print = """
                    <p><b><large>{OBREMENITVENO TESTIRANJE}</large></b></p>

                    <p>{Indikacija:} _</p> 

                    <p>{Terapija:} _</p> 

                    <p>{EKG:} _</p>

                    <p>{Klinično:} _</p>
                    """

                            # TEMPLATE MODE
                            if self.template_mode:
                                print("TEMPLATE MODE")
                                if not cursor.atBlockStart() and not set(text_to_print).issubset(set(".,!?:;+-*/")):
                                    cursor.insertText(" ")
                                cursor.insertHtml(text_to_print)
                                if self.modifiers["template_init"]:
                                    move_first_input(self.transcript_win.ui)
                                    self.modifiers["template_init"]=False
                                self.transcript_win.ui.current_highlight_position = cursor.position()
                            
                            # ORDINARY MODE - buffering mode
                            elif self.buffering:
                                next_character = None
                                if cursor.atBlockStart():
                                    if get_settings_value(self.settings, ["general", "do-postprocessing", "capitalize-sentences"]):
                                        start_with_space=False
                                        set_first_cap=True
                                    else:
                                        start_with_space=False
                                        set_first_cap=False
                                else:
                                    if set(text_to_print).issubset(set(".,!?:;+-*/")):
                                        start_with_space=False
                                        set_first_cap=False
                                        # if left-binding punct AND space at current cursor pos, remove spaces until you get to a non-space character
                                        if set(text_to_print).issubset(set(".,!?")):
                                            delete_spaces_to_left()  
                                    else:
                                        last_character = self.transcript_win.ui.textEdit.toPlainText()[cursor.position()-1]
                                        last_non_space_character = get_last_non_space_character(self.transcript_win.ui.textEdit.toPlainText(), cursor.position())
                                        if not cursor.atEnd():
                                            next_character = self.transcript_win.ui.textEdit.toPlainText()[cursor.position()]
                                        if last_character in ('.', '?', '!'):
                                            start_with_space=True
                                            set_first_cap=True
                                        elif last_character != " ":
                                            if text_to_print.strip()[0] in ('.', ',', '?', '!', ':', ';', ')'):
                                                start_with_space=False
                                                set_first_cap=False   
                                            else: 
                                                # if last character is rightside binded character, set space to false
                                                if last_character == "(":
                                                    start_with_space = False
                                                else:
                                                    start_with_space=True
                                                set_first_cap=False
                                        else:
                                            if last_non_space_character in ('.', '?', '!'):
                                                start_with_space=False
                                                set_first_cap=True
                                            else:
                                                start_with_space=False
                                                set_first_cap=False
                                
                                text_to_print = text_to_print.strip()

                                # check for posible typos, such as space before punctuation, space before paranthesis ...
                                corrected_text = self.text_corrector.correct_typos(text_to_print)
                                #print(f"TEXT_TO_PRINT: {text_to_print}, CORRECTED_TEXT: {corrected_text}")
                                if corrected_text != text_to_print:
                                    logger.debug(f"Removed typos: {text_to_print} ==> {corrected_text}")
                                    text_to_print = corrected_text

                                if set_first_cap and not self.modifiers['lower'] and not self.modifiers['withLower']:
                                    text_to_print = text_to_print[0].upper() + text_to_print[1:]
                                if start_with_space:
                                    cursor.insertText(" ")
                                
                                # deactivate withUpper or withLower
                                for m in ('withLower', 'withUpper'):
                                    self.modifiers[m] = False
                                
                                logger.debug(f"First final flag: {self.new_session}")
                                logger.debug(f"Previous final: {self.last_processed_final}")
                                logger.debug(f"Start line flag: {self.line_start}")
                                logger.debug(f"Space before flag: {start_with_space}")
                                logger.debug(f"Start with capital letter flag: {set_first_cap}")
                                logger.debug(f"TEXT TO PRINT: {text_to_print}")

                                self.transcript_win.ui.textEdit.insertHtml(text_to_print)
                                if next_character and next_character != ' ':
                                    cursor.insertText(" ")

                                self.transcript_win.ui.update_cursor_pos_status()

                            # ORDINARY MODE - printing to destination window
                            else:
                                # context in the destination window is not known.
                                next_character = None
                                if self.new_session:
                                    start_with_space = False
                                    set_first_cap = True
                                elif self.line_start:
                                    if get_settings_value(self.settings, ["general", "do-postprocessing", "capitalize-sentences"]):
                                        start_with_space=False
                                        set_first_cap=True
                                    else:
                                        start_with_space=False
                                        set_first_cap=False
                                else:
                                    if set(text_to_print).issubset(set(".,!?:;+-*/")):
                                        start_with_space=False
                                        set_first_cap=False
                                        # if left-binding punct AND space at current cursor pos, remove spaces until you get to a non-space character
                                        # this can only be done if floating window  
                                    else:
                                        last_text = self.last_processed_final.get("text")
                                        last_character = None
                                        if last_text:
                                            last_character = last_text[-1] 
                                            last_non_space_character = last_text.strip()[-1]
                                        if last_character in ('.', '?', '!'):
                                            start_with_space=True
                                            set_first_cap=True
                                        elif last_character != " ":
                                            if text_to_print.strip()[0] in ('.', ',', '?', '!', ':', ';', ')'):
                                                start_with_space=False
                                                set_first_cap=False   
                                            else: 
                                                # if last character is rightside binded character, set space to false
                                                if last_character == "(":
                                                    start_with_space = False
                                                else:
                                                    # if starting after PAUSE, check whether to make SPACE or not
                                                    if self.starting_after_pause:
                                                        self.starting_after_pause = False
                                                        if get_settings_value(self.settings, ['general', 'continue-pause-with-space']):
                                                            start_with_space=True
                                                        else:
                                                            start_with_space=False
                                                    else:
                                                        start_with_space=True
                                                set_first_cap=False
                                        else:
                                            if last_non_space_character in ('.', '?', '!'):
                                                start_with_space=False
                                                set_first_cap=True
                                            else:
                                                start_with_space=False
                                                set_first_cap=False
                                
                                text_to_print = text_to_print.strip()

                                # check for posible typos, such as space before punctuation, space before paranthesis ...
                                corrected_text = self.text_corrector.correct_typos(text_to_print)
                                
                                if corrected_text != text_to_print:
                                    logger.debug(f"Removed typos: {text_to_print} ==> {corrected_text}")
                                    text_to_print = corrected_text

                                if set_first_cap and not self.modifiers['lower'] and not self.modifiers['withLower']:
                                    text_to_print = text_to_print[0].upper() + text_to_print[1:]
                                if start_with_space:
                                    cursor.insertText(" ")
                                
                                # deactivate withUpper or withLower
                                for m in ('withLower', 'withUpper'):
                                    self.modifiers[m] = False

                                logger.debug(f"First final flag: {self.new_session}")
                                logger.debug(f"Previous final: {self.last_processed_final}")
                                logger.debug(f"Start line flag: {self.line_start}")
                                logger.debug(f"Space before flag: {start_with_space}")
                                logger.debug(f"Start with capital letter flag: {set_first_cap}")
                                logger.debug(f"TEXT TO PRINT: {text_to_print}")
                                
                                self.transcript_win.ui.textEdit.insertHtml(text_to_print)
                                self.transcript_win.ui.update_cursor_pos_status()
                                
                                # copy transcript window content to destination window
                                copy_content_to_destination_window()
                                
                            # scroll to the end of the viewport if cursor at end and in buffering mode 
                            if not self.template_mode and self.buffering:
                                if cursor.atEnd():
                                    scroll_to_end()
                            
                        # if text_segment is a command, do appropriate action
                        elif text_segment.get("htype", None)=='command':
                            handle_command(text_segment.get("text", "").strip())

                        # remember last non-command text segment and reset new session flag
                        if text_segment.get("htype")=="text":
                            self.last_processed_final=text_segment
                            self.line_start = False
                            self.new_session = False
    
            # if res is an interim
            elif res["final"]==False:
                pass 
        
    def print_output(self, res):
        # If something went wrong in the TB library, the result will include key 'messageType' with value 'ERROR' and 
        # key 'message' with the description of the error 
        if 'error_type' in res and res['error_type'][-5:]=='ERROR':
            self.label_interim.setStyleSheet(f"color: {cl_message_failed}")
            self.label_interim.setText(f"Napaka v komunikaciji s strežnikom!")
            self.actionAlarm.setVisible(True)
            self.recording_state = 'idle'
            self.actionRecord.setIcon(self.icon_rec_idle)
            # if session start was triggered from an external command, send response
            if self.active_external_msg_id:
                 self.send_reponse(self.active_external_msg_id, f'cmd_status=False | response=Error in streaming audio. Error message: {res.get("message")}')
            # hide the toolbar (including floating window) if user settings requires so - BE CAREFUL: user will not be informed about the ERROR since the Toolbar will hide
            #if get_settings_value(self.settings, ['general', 'system-tray', 'minimize-after-login']):
            #    self.transcript_win.hide()
            #    self.hide()

        # Otherwise the results will hold session info
        else:  
            logger.debug(f"SESSION INFO: {res[-1]}")

        # If listening for external commands and a finish signal was received, check the dictaphone mode and respond accordingly
        #if get_settings_value(self.settings, ['integration', 'listen-for-external-commands']) and self.actionDictaphone.isChecked():
        #    if self.recording_state=='idle':
        #        logger.debug(f"Listening for external commands and got a signal to finish the session. The dictaphone mode will be swittched OFF - finishing note taking mode.")
        #        self.actionDictaphone.setDisabled(True)
        #        self.label_interim.setText(f"Pripombe so bile shranjene.")
        #        self.widget_status.setStyleSheet(f"background-color: {cl_light_green_string}")
        #        self.actionDictaphone.setChecked(False)
        #    elif self.recording_state=='pause':
        #        logger.debug(f"Listening for external commands and got a signal to pause the session. The dictaphone mode will remain in the note taking mode.")

    def thread_complete(self, res):
        logger.debug(f"THREAD COMPLETE FOR SESSION {res.get('sessionid')}!")
        
        # if received sessionid from the Streamer is different than the GUI current session, there must be an ERROR - this should never happen!
        if str(res.get('sessionid')).strip() != self.current_sessionid:
            logger.error(f"Session ID mismatch! GUI session ID: {self.current_sessionid}, Streamer session ID: {res.get('sessionid')}")
            return False
        
        # if session has been dropped, do nothing
        if self.stt.state == 'Error':
            logger.warning(f"Session in error state - session name and shares will not be patched!")
            return False

        # reset buttons
        for b in ('<b>', '<i>', '<u>', '<uc>', '<lc>', '<spell>'):
            self.toggle_button(b, on=False)

        # if the note taking requested for the session, create a new session and save current state: note_taking_mode=initiated
        if self.note_taking_mode == 'requested':
            self.start_recording()
            self.note_taking_mode = 'initiated'
            return
        
        # if the note taking is finished, notify the user, disable dictaphone mode (if listening for external commands), switch off the dictaphone icon
        if self.user_session_log[self.current_sessionid].type == 'note-taking':
            # if listening for external commands, disable the dictaphone mode
            if get_settings_value(self.settings, ['integration', 'listen-for-external-commands']):
                self.actionDictaphone.setDisabled(True)
            self.label_interim.setText(f"Pripombe za sejo {self.current_sessionid} so bile shranjene.")
            self.widget_status.setStyleSheet(f"background-color: {cl_light_green_string}")
            self.actionDictaphone.setChecked(False)
            self.note_taking_mode = None

        # If the session has name or notes, patch them - don/t needed here - I do that immediatelly when getting the session ID - check display_status() function
        #self.patch_session()

        # add user shares if session finished (in idle, not in pause) 
        self.patch_shares()

        # if we are in the DICTAPHONE mode (regular dictaphone mode, not the note taking), assign Dictaphone label to the session and leave the DICTAPHONE mode ON
        if self.actionDictaphone.isChecked():
            self.enable_dictaphone_label()
        
        # Set current session to None if recording state is IDLE (not PAUSE)
        if self.recording_state == 'idle':
            self.current_sessionid = None

    def handle_streaming_errors(self, error):
        # This will happen when an error will occur in the Streamer thread, other then the TB error
        err_obj = truebar.TBError(
            error_code=4000,
            error_message="Exception in Streamer object",
            exception=error[1],
            error_type="CLIENT-ERROR",
    	)
        self.stt.connection_errors.append(vars(err_obj))
        logger.error(vars(err_obj))
        self.label_interim.setStyleSheet(f"color: {cl_message_failed}")
        self.label_interim.setText(f"Napaka pri izvajanju procesa razpoznave!")
        self.recording_state = 'idle'
        self.actionRecord.setIcon(self.icon_rec_idle)

    def send_reponse(self, command_id, response):
        """
        Sends response on received command to outQueue
        """
        msg=win32com.client.Dispatch("MSMQ.MSMQMessage")
        msg.Label=f"{command_id}"
        msg.Body=f"{response}"
        msg.Send(self.outQueue)
        # set active msg_id to None to indicate that all processed messages got responses
        self.active_external_msg_id = None

    def external_command_received(self, res):
        """
        Only accept commands/instructions that are defined in self.inQueue.legal_external_commands. 
        
        RESPONSE STRUCTURE:
        all responses will include: message_id and message_body
        - massage_id is an identifier of the message. It serves for clients to connect responses with messages they send.
        - message_body contains the response content. The content is structured and has three keys: 'cmd_status', err_msg 
          and 'response'. The last two are optional. 
        The meaning of these keys is as follows:
        - 'cmd_status': tells the status of the message. It can be eirther 'True' if command succedded, or False otherwise.
        - 'err_msg': if an error occured (cmd_status=False), the error will be described in this field. Otherwise this field 
           will not be included in the massage_body
        - 'response': if the command sent to the server expects a reponse (e.g. sessionid when start_dict is triggered), this
           response will be included in this field. Otherwise the filed will not be included in the message body.

        The three fields are separated with the pipe symbol "|"  
        """

        self.active_external_msg_id = None
        msg_id = res['label']
        msg_components = res['body'].split("|")
        command = msg_components[0]
        arguments = [msg_components[i] for i in range(1, len(msg_components))]

        try:

            # if user not authenticated, ignore everything except login/logout, show/hide toolbar, and get_status commands
            if not self.user_authenticated and msg_components[0].lower() not in ("login", 'status', 'logout', 'show_toolbar', 'hide_toolbar'):
                logger.debug(f"External command received: {res}")
                logger.debug(f"User not authenticated, external command will be ignored...")
                self.send_reponse(msg_id, f"cmd_status=False | err_msg=FAILED: User not authenticated - command ignored.")
                return

            # if in the integration debug mode, show the command
            if _integration_debug_mode:
                self.label_interim.setStyleSheet("color: red")
                self.label_interim.setText(f"Ext: {res['body'][:_interim_display_len]}...")

            # ignore unknown commands
            if command.lower() not in self.inQueue.legal_external_commands:
                logger.debug(f"Unknown external command received: {command}")
                return
            # if legal extarnal command, react accordingly
            else:
                logger.debug(f"External request received: label: {msg_id}, body: {res['body']}")
                self.active_external_msg_id = msg_id
                #self.label_interim.setText(res['body'][:80]+"...")

                # login
                if command.lower() == 'login':
                    try:
                        if not self.user_authenticated:
                            if len(arguments)!=3: 
                                logger.debug(f'Syntax error in external command: {command}\nUsege: login |<username>|<password>|<hostname>')
                                self.send_reponse(msg_id, f"cmd_status=False | err_msg=FAILED: Syntax error. Usage: login |<username>|<password>|<hostname>")
                            else:
                                self.lineEdit_username.setText(arguments[0])
                                self.lineEdit_password.setText(arguments[1])
                                self.lineEdit_host.setText(arguments[2])
                                if self.authenticate():
                                    self.send_reponse(msg_id, 'cmd_status=True')
                                else:
                                    self.send_reponse(msg_id, 'cmd_status=False | err_msg=Unable to authenticate this user!')
                        else:
                            self.send_reponse(msg_id, 'cmd_status=True')
                    except Exception as e:
                        self.send_reponse(msg_id, f'cmd_status=False | err_msg={e}')

                # logout
                if command.lower() == 'logout':
                    try:
                        if self.user_authenticated:
                            self.logout()
                        self.send_reponse(msg_id, 'cmd_status=True')
                    except Exception as e:
                        self.send_reponse(msg_id, f'cmd_status=False | err_msg={e}')

                # status
                elif command.lower() == 'status':
                    # return recording status (idle, recording, pause), buffering status (True, False), Dictaphone status (True, False), and current session ID if in recording or pause mode
                    current_session_id = self.current_sessionid if self.recording_state in ('recording', 'pause') else ""
                    is_dictation_allowed = True if self.b21_win_hndl else False
                    self.send_reponse(msg_id, 'cmd_status=True | response={authenticated='+f'{self.user_authenticated}, status={self.recording_state}, buffering={self.buffering}, dictaphone_mode={self.actionDictaphone.isChecked()}, sessionid={current_session_id}, dictation_allowed={is_dictation_allowed}'+'}')
                
                # start_dict
                elif command.lower() == 'start_dict':
                    # only proceed if in idle or pause state and command syntax ok
                    # NOTE: session ID will be returned when the Streamer starts and session_id is created and passed to the main via display_status()
                    if self.recording_state not in ('idle', 'pause'):
                        logger.debug(f"ERROR: dictation can't be started in {self.recording_state} state. External command will be ignored.")
                        self.send_reponse(msg_id, f"cmd_status=False | err_msg=FAILED: can't start recording in {self.recording_state} state")
                    elif len(arguments) != 4: 
                        logger.debug(f'Syntax error in external command: {command}\nUsege: start_dict |<window handle>|<patient id>|<session_id>|<notes>\nThe third and fourth arguments can be null, i.e. an empty string, session_id, is optional. Use to continue sesission.')
                        self.send_reponse(msg_id, f"cmd_status=False | err_msg=FAILED: Syntax error. Usege: start_dict |<window handle>|<patient id>|<session_id>|<notes>\nThe third and fourth arguments can be null, i.e. an empty string.")
                    else:
                        # Extract session name and sessionid if provided
                        # NOTE: PAUSE mode can only be triggered by pressing toolbar or dictaphone button, or via voice 
                        # command 'pause'. If the listener is in pause mode and sessionid is provided via the external 
                        # command, the provided session will be continued and not the one from which the pause was triggered. 
                        # Note also that when a session is continued, the last provided PID will be used to name the session.
                        self.continue_sessionId = None
                        if arguments[2] != "":
                            if arguments[2].isnumeric():
                                self.continue_sessionId = arguments[2]
                            else:
                                logger.warning(f"Value {arguments[2]} not recognised as a valid session identifier. New session will be created!") 
                        # remember session name and notes if set by the caller
                        if arguments[1] != "":
                            self.session_name = arguments[1]
                        else:
                            self.session_name = None
                        if arguments[3] != "":
                            self.session_notes = arguments[3]
                        else:
                            self.session_notes = None 

                        # focus to window handle and start dictation. 
                        if arguments[0].isnumeric():
                            # first show toolbar if hidden in sys tray
                            self.show()
                            self.wtof = int(arguments[0])
                            if self.wtof != windll.user32.GetForegroundWindow():
                                #set_focus_to_window_handle(self.wtof)
                                self.win_mnpl.set_focus_to_window_handle(self.wtof)
                                
                            self.record()
                        else:
                            logger.debug(f"Syntax error in external command: {command}\nArgument <window handle> must be convertable to integer.")
                            self.send_reponse(msg_id, f"cmd_status=False | err_msg=FAILED: Syntax error. <window handle> can't be converted to integer!")
                            self.wtof = None

                # win_change
                elif command.lower() == 'win_change':
                    # check syntax
                    if len(arguments) != 5: 
                        logger.debug(f'Syntax error in external command: {command}\nUsege: win_change |<window handle>|<patient id>|<session_id>|<notes>|<text_before>\nThe third, fourth, and fifth arguments can be null, i.e. an empty string, session_id, is optional. Use to continue sesission. \nOr set all arguments to null to notify TB-listener it should not allow dictation in current window!')
                        self.send_reponse(msg_id, f"cmd_status=False | err_msg=FAILED: Syntax error. Usege: win_change |<window handle>|<patient id>|<session_id>|<notes>|<text_before>\nThe third, fourth, and fifth arguments can be null, i.e. an empty string.\nOr set all arguments to null to notify TB-listener it should not allow dictation in current window!")
                    else:
                        # If all arguments are null reset values to indicate dictation is not possible in this window
                        if set(arguments) == {""}:
                            self.continue_sessionId = None
                            self.session_name = None
                            self.session_notes = None
                            self.b21_win_hndl = None
                            self.send_reponse(msg_id, f"cmd_status=True | response='dictation-allowed set to False'")
                        else:
                            # Extract session name and session ID if provided
                            # NOTE: is sessionid is provided, it will be used to continue session next time REC is pressed on the dictaphone (unless a reset command is received - win_change without parameters. 
                            # At this point, session id might not be known - we need to save provided metadata to temporay variables and not to self.user_session_log
                            self.continue_sessionId = None
                            
                            # Check if session ID is provided
                            if arguments[2] != "":
                                if arguments[2].isnumeric():
                                    self.continue_sessionId = arguments[2]
                                    self.current_sessionid = self.continue_sessionId
                                    # the Truebar method relies on the attribute last_sessionId when existing session is requested to be continued
                                    self.stt.last_sessionId = self.continue_sessionId
                                else:
                                    self.stt.last_sessionId = None
                                    self.continue_sessionId = None
                                    logger.warning(f"Value {arguments[2]} not recognised as a valid session identifier. New session will be created!") 
                            
                            # extract session name 
                            self.session_name = arguments[1]
                            
                            # remember notes if set by the caller
                            if arguments[3] != "":
                                self.session_notes = arguments[3]
                            else:
                                self.session_notes = None
                            
                            # remember window handler
                            if arguments[0] != "":
                                self.b21_win_hndl = arguments[0]
                            else:
                                self.b21_win_hndl = None

                            self.send_reponse(msg_id, f"cmd_status=True | response='win_change set for: session-name={self.session_name}, session-id={self.continue_sessionId}, win-handl={self.b21_win_hndl}, notes={self.session_notes}")

                        #set window to focus on the received handle - if None, set wtof to None
                        self.wtof = self.b21_win_hndl
                        
                # stop_dict
                # NOTE: when stop_dict is received, stop_recording will be triggered which will in turn reset the buffering state and buffer.
                # IMPORTANT: if in 'pause mode', don't stop recording as it is already stopped. Instead, patch the session name and shares
                elif command.lower() == 'stop_dict':
                    # only proceed if in recording or pause state and command syntax ok
                    if self.recording_state not in ('recording', 'pause'):
                        logger.debug(f"Can't stop dictation - not in recording or pause state. State: {self.recording_state}")
                        self.send_reponse(msg_id, f"cmd_status=False | err_msg=FAILED: can't stop dictation - not in recording or pause state. State: {self.recording_state}")
                        return
                    elif len(arguments) != 1: 
                        logger.debug(f'Syntax error in external command: {command}\nUsege: stop_dict |<session id>')
                        self.send_reponse(msg_id, f"cmd_status=False | err_msg=FAILED: syntax error in external command. Usege: stop_dict |<session id>")
                    else:
                        sessionid = arguments[0].strip()
                        # if command syntax incorrect, ignore it
                        if not sessionid.isnumeric() or (sessionid != self.current_sessionid):
                            logger.warning(f"Received command does not refer to the current session: current: {self.current_sessionid} - refered session {sessionid}")
                            self.send_reponse(msg_id, f"cmd_status=False | err_msg=FAILED: received command does not refer to the current session!")

                        # if in pause mode, patch the session but don't stop as it is already stopped
                        elif self.recording_state=='pause':
                            logger.debug(f"Session already stopped - changing status from PAUSE to IDLE.")
                            self.recording_state = 'idle'
                            self.actionRecord.setIcon(self.icon_rec_idle)
                            # remove session id from the toolbar
                            self.label_logged_user.setText(
                                f'P: {self.last_stt_ping} | '
                                f'<a href="open_templates">T: {len(self.templates)}</a> | '
                                f'U: {self.lineEdit_username.text()}  '
                            )
                            # if in Dictaphone mode, set label
                            if self.actionDictaphone.isChecked():
                                logger.info("Setting label for DICTAPHONE mode!")
                                self.enable_dictaphone_label()
                            self.send_reponse(msg_id, "cmd_status=True")
                        
                        # if in recording state, stop recording
                        else:    
                            # stop recording
                            self.stop_recording()
                            self.send_reponse(msg_id, "cmd_status=True")

                # pause
                # NOTE: this command is deprecated as it can be simulated by simply stopping the current session and then
                # using start_dict with the sessionid to be continued 
                elif command.lower() == 'pause':
                    # only eligible if in recording state
                    if self.recording_state != 'recording':
                        logger.debug(f"Can't pause dictation - not in recording state. State: {self.recording_state}")
                        return
                    elif len(arguments) != 1: 
                        logger.debug(f'Syntax error in external command: {command}\nUsege: pause |<sesion id>')
                        self.send_reponse(msg_id, f"cmd_status=False | err_msg=FAILED: syntax error. Usege: pause |<sesion id>") 
                    else:
                        sessionid = arguments[0].strip()
                        if not sessionid.isnumeric() or (sessionid != self.current_sessionid):
                            logger.warning(f"Received command does not refer to the current session: current: {self.current_sessionid} - refered session {sessionid}")
                            self.send_reponse(msg_id, f"cmd_status=False | err_msg=FAILED: received command does not refer to the current session!")
                        else:    
                            # pause recording
                            self.pause_recording()
                            self.send_reponse(msg_id, "cmd_status=True")

                # show toolbar
                elif command.lower() == 'show_toolbar':
                    if len(arguments) not in (0, 2) or (len(arguments)==2 and (not arguments[0].isnumeric() or not arguments[1].isnumeric())):
                        logger.debug(f'Syntax error in external command: {command}\nUsege: show_toolbar [|<xpos>|<ypos>]\nThe <xpos> and <ypos> arguments are optional.')
                        self.send_reponse(msg_id, f"cmd_status=False | err_msg=FAILED: Syntax error. Usage: show_toolbar [|<xpos>|<ypos>]. The <xpos> and <ypos> arguments are optional.")
                    else:
                        if len(arguments)==2:
                            self.move(int(arguments[0]), int(arguments[1]))
                        self.show()
                        # if transcript window was in visible state when the toolbar was minimized to the tray, show it
                        if self.transcript_win and self.buffering and not get_settings_value(self.settings, ["general", "dont-show-transcript-win"]):
                            self.move_transcript_window()
                            self.transcript_win.show()
                        self.send_reponse(msg_id, "cmd_status=True")

                # hide toolbar
                elif command.lower() == 'hide_toolbar':
                    # first hide transcript window in in open state
                    if self.transcript_win:
                        self.transcript_win.hide()
                    self.hide()
                    self.send_reponse(msg_id, "cmd_status=True")

                # upload audio for offline transcription
                elif command.lower() == 'upload_audio':
                    if len(arguments) != 1: 
                        logger.debug(f'Syntax error in external command: {command}\nUsege: upload_audio |<local_audio_filename_with_path>\nAccepted audio formats: wav, mp3, dss, ds2.')
                        self.send_reponse(msg_id, f"cmd_status=False | err_msg=FAILED: Syntax error. Usege: upload_audio |<local_audio_filename_with_path>\nAccepted audio formats: wav, mp3, dss, ds2.")
                    else:
                        self.upload_file(external_command=True, external_params=rf"{arguments[0]}")

                # check offlineASR status
                elif command.lower() == 'check_status':
                    if len(arguments) != 1: 
                        logger.debug(f'Syntax error in external command: {command}\nUsege: check_status |<sessionid>')
                        self.send_reponse(msg_id, f"cmd_status=False | err_msg=FAILED: Syntax error. Usege: check_status |<sessionid>")
                    else:
                        res = self.stt.get_session_status(arguments[0])
                        if res:
                            self.send_reponse(msg_id, f"cmd_status=True | response={res}")
                        else:
                            self.send_reponse(msg_id, f"cmd_status=False | err_msg=FAILED: Cannot check status for session {arguments[0]}")

                # get transcript
                elif command.lower() == 'get_transcript':
                    if len(arguments) not in (1,2): 
                        logger.debug(f'Syntax error in external command: {command}\nUsage: get_transcript | <sessionid> | <with_metadata>\nParameter with_metadata is Boolean and Optional.')
                        self.send_reponse(msg_id, f"cmd_status=False | err_msg=FAILED: Syntax error. Usage: get_transcript | <sessionid> | <with_metadata>")
                    else:
                        # if <with_metadata> argument is not provided, it is considered false --> formated transcript will be returned
                        jsontrans = self.stt.get_session_transcript(arguments[0], 'transcript')
                        if jsontrans:
                            if len(arguments)==1 or not arguments[1]:
                                tr = truebar.TranscriptReader()
                                html_text = None
                                if jsontrans:
                                    html_text = tr.transcript_to_html(jsontrans)
                                self.send_reponse(msg_id, f"cmd_status=True | response={html_text}")
                            else:
                                self.send_reponse(msg_id, f"cmd_status=True | response={jsontrans}")
                        else:
                            self.send_reponse(msg_id, f"cmd_status=False | err_msg=FAILED: Unable to retrieve transcript for session {arguments[0]}")
        
        except Exception as e:
            logger.error(f"Exception rised on receiving external request: {e}")
            self.send_reponse(msg_id, f"cmd_status=False | err_msg=EXCEPTION: {e}")

    def queue_listener_stopped(self):
        logger.debug("MSMQ listener stopped!")

    def start_recording(self):
        """
        Before starting new session, check settings from gui/settings.yaml
        and reapply if neccessary.
        """
        # TODO: focusing to correct window is hadled in the display_transcript and is redundant here! Check carefully and remove
        # the code tha deals with the focus
        
        # minimize toolbar to its size and start
        self.show_interims()

        # if toolbar not visible, show it
        if self.isHidden():
            self.show()

        # open floating window if in buffering mode or (the setting start-in-buffering-mode is ON and not in Dictaphone mode) 
        if self.buffering or (get_settings_value(self.settings, ['general', 'start-in-buffering-mode']) and not self.actionDictaphone.isChecked()):
            self.label_rec_status.setText("\u25BA pomnjenje | ")
            self.buffering = True
            if not get_settings_value(self.settings, ["general", "dont-show-transcript-win"]):
                self.move_transcript_window()
                self.transcript_win.show()
        else:
            self.transcript_win.hide()

        # make the destination window active - use window title from the settings 
        # except when window handle is given via an external command and self.wtof holds handle id 
        if self.wtof is None:
            wtof = self.lineEdit_destination.text().strip()
            if wtof:
                #set_focus_to_window(wtof)
                self.win_mnpl.set_focus_to_window(wtof)
        else:
            # if external command is triggering the recording, check whether session id is provided
            # in this case make sure to continue the session as if it was in pause mode
            if self.continue_sessionId:
                self.current_sessionid = self.continue_sessionId
                # the Truebar method relies on the attribute last_sessionId when existing session is requested to be continued
                self.stt.last_sessionId = self.continue_sessionId 

        logger.debug(f"RECORDING STATE: {self.recording_state}")
        logger.debug(f"BUFFERING STATE: {self.buffering}")
        logger.debug(f"BUFFER CONTENT: {self.buffer}")

        # set variable to hold status of modifiers - required since the transcript window is handled internally
        self.modifiers=dict(
            upper=False,
            lower=False,
            withLower=False,
            withUpper=False,
            cap=False,
            bold=False,
            italic=False,
            underline=False,
            insert=False,
            template_init=False,
            noSpace=False,
            withDigits=False,
        )
        self.template_mode = False

        # check if new session is requested or a continuation of an existing session
        continue_session_flag = (self.recording_state=='pause' or (self.continue_sessionId is not None))
        self.starting_after_pause = continue_session_flag
        # reset line start flag and if new session, clean last final data
        self.line_start = None
        if not continue_session_flag:
            self.last_processed_final = dict()
            self.new_session = True
        else:
            self.new_session = False
            # if last_processed_final doesn't exist yet, create one
            if not hasattr(self, 'last_processed_final'):
                self.last_processed_final = dict()

        # if listening for external commands, dictaphone mode must be enabled when in recording mode
        if get_settings_value(self.settings, ['integration', 'listen-for-external-commands']):
            self.actionDictaphone.setDisabled(False)

        self.streamer = Streamer(
            stt=self.stt,
            settings=self.settings,
            dictation_type=self.dictation_type,
            continue_session=continue_session_flag,
            buffering = self.buffering,
            buffer = self.buffer,
            dictaphone_mode = self.actionDictaphone.isChecked(),
            templates=self.read_templates(),
            ignore_ssl=self.ignoreSSL,
            )
        self.streamer.signals.result.connect(self.print_output)
        self.streamer.signals.finished.connect(self.thread_complete)
        self.streamer.signals.status.connect(self.display_status)
        self.streamer.signals.error.connect(self.handle_streaming_errors)
        self.streamer.signals.hypothesis.connect(self.display_transcript)
        # execute
        self.threadpool.start(self.streamer)

    def toggle_button(self, btn, on:Boolean):
        button = None
        if btn in ('<b>', '</b>'):
            button = self.pushButton_bold
        elif btn in ('<i>', '</i>'):
            button = self.pushButton_italic
        elif btn in ('<u>', '</u>'):
            button = self.pushButton_underline
        elif btn in ('<uc>', '</uc>'):
            button = self.pushButton_upper
        elif btn in ('<lc>', '</lc>'):
            button = self.pushButton_lower
        elif btn in ('<spell>', '</spell>'):
            button = self.pushButton_spell
        if button:
            if not on:
                button.setStyleSheet("background-color : lightgrey; border-style: solid; border: 1px solid grey")
            else:
                button.setStyleSheet("background-color : lightblue; border-style: solid; border: 1px solid blue")

    def select_output(self):
        radioButton = self.sender()
        if radioButton.isChecked():
            if radioButton == self.radioButton_plain:
                self.pushButton_bold.setVisible(False)
                self.pushButton_italic.setVisible(False)
                self.pushButton_underline.setVisible(False)
                self.label_interim.setGeometry(scale(100), scale(5), scale(240), scale(21))
                self.dictation_type="txt"
            else:
                self.pushButton_bold.setVisible(True)
                self.pushButton_italic.setVisible(True)
                self.pushButton_underline.setVisible(True)
                self.label_interim.setGeometry(scale(185), scale(5), scale(240), scale(21))
                if self.radioButton_rtf.isChecked():
                    self.dictation_type="rtf"
                elif self.radioButton_docx.isChecked():
                    self.dictation_type="docx"
                else:
                    self.dictation_type="b21"

    def open_send_logs(self):
        sendlog_dialog = QtWidgets.QDialog()
        sendlog_dialog.ui = SendLog(
            gui_object=sendlog_dialog, 
            logger_folder=self.logger_folder,
            tb_backend=self.stt,
            username=self.lineEdit_username.text(),
            host=self.lineEdit_host.text(),
            )
        # make window stay on top
        sendlog_dialog.setWindowFlags(Qt.WindowStaysOnTopHint)
        sendlog_dialog.exec()

    def open_commands_helper(self):
        logger.debug(f"<<<< INFO BUTTON PRESSED >>>>")
        self.commands_helper = QtWidgets.QDialog()
        self.commands_helper.ui = Dictation_commands(self.commands_helper)

        self.COMMANDS_dialog_opened=True
        if not self.isActiveWindow():
            logger.debug(f"Active window when COMMANDS is opening and is without focus: {win32gui.GetWindowText(win32gui.GetForegroundWindow())}")
            wtof = ".*MainWindow.*"
            wtof = "TB-listener: MainWindow"
            if wtof:
                #set_focus_to_window(wtof)
                self.win_mnpl.set_focus_to_window(wtof)

        if self.commands_helper.exec()==QDialog.Rejected:
            # tell the streamer that window was closed
            if self.streamer:
                self.streamer.helper_window_closed()
            # set focus back to the destination window
            self.COMMANDS_dialog_opened=False
            wtof = self.lineEdit_destination.text().strip()
            if wtof:
                #set_focus_to_window(wtof)
                self.win_mnpl.set_focus_to_window(wtof)

    def move_transcript_window(self):
        if self.transcript_win:
            # set position below the toolbar - call this function on init and on every move of the toolbar
            toolbar_position = self.geometry()
            self.transcript_win.move(toolbar_position.left(), toolbar_position.bottom())

    def create_transcript_window(self):
        self.transcript_win = QtWidgets.QMainWindow()
        self.transcript_win.ui = TranWin(gui_object=self.transcript_win)
        self.transcript_win.setWindowFlags(Qt.WindowStaysOnTopHint|QtCore.Qt.FramelessWindowHint)
        
        # set position below the toolbar
        self.move_transcript_window()
        
        # use toolbar width and the default height if not height not specified in the settings 
        requestedWinWidth = get_settings_value(self.settings, ['appearance', 'floating-window-width'])
        requestedWinHeight = get_settings_value(self.settings, ['appearance', 'floating-window-height'])
        if requestedWinWidth is None:
            requestedWinWidth = self.geometry().width()
        if requestedWinHeight is None:
            requestedWinHeight = self.transcript_win.height()*2
        self.transcript_win.resize(requestedWinWidth, requestedWinHeight)
        
        # hide toolbar and status bar of the transcript window
        self.transcript_win.ui.menubar.setVisible(False)
        self.transcript_win.ui.statusbar.setVisible(False)

        # set font family and size (use default, 10 points, Arial, if not set)
        requestedFontFamily = get_settings_value(self.settings, ['appearance', 'floating-window-font-family'])
        if not requestedFontFamily: 
            requestedFontFamily = "Arial"
        font = QFont(requestedFontFamily)
        requestedFontSize = get_settings_value(self.settings, ['appearance', 'floating-window-font-size'])
        if not requestedFontSize: 
            requestedFontSize = 10
        logger.info(f"Floating window font family set to {requestedFontFamily}, size set to {requestedFontSize}")
        font.setPointSize(get_settings_value(self.settings, ['appearance', 'floating-window-font-size']))  # Change the size as needed
        self.transcript_win.ui.textEdit.setFont(font)
     
        # make transcript window initially read only
        #self.transcript_win.ui.textEdit.setReadOnly(True)
        self.cursor_position = None
        self.last_transcript_win_content = None

        # set transcript window style
        self.transcript_win.ui.textEdit.setStyleSheet("""
            QTextEdit {
                line-height: 150%;
            }
        """)
                
    def toggle_transcript_window(self):
        logger.debug(f"<<<< FLOATING WINDOW BUTTON PRESSED >>>>")
        if self.actionPin.isChecked():
            self.move_transcript_window()
            self.transcript_win.show()
        else:
            self.transcript_win.hide()

    def open_add_word_dialog(self):
        logger.debug(f"<<<< DICTIONARY BUTTON PRESSED >>>>")
        # Check if using Riva framework - in this case show personal dictionary rather than general one
        if self.comboBox_model.currentText().split(',')[0].upper()=='RIVA':
            self.personal_dict_dialog = DictionaryManager(self, tb_object=self.stt)
            toolbar_position = self.geometry()
            self.personal_dict_dialog.move(toolbar_position.left(), toolbar_position.bottom()+10)
            self.personal_dict_dialog.resize(self.geometry().width(), scale(450)) 
            self.personal_dict_dialog.exec_()          
        else:
            self.add_word_dialog = QtWidgets.QDialog()
            self.add_word_dialog.ui = Add_Word_Dialog(
                gui_object=self.add_word_dialog,
                truebar_object=self.stt,
                tb_config=self.tb_current_config,
                )
            self.add_word_dialog.setWindowFlags(Qt.WindowStaysOnTopHint)
            self.add_word_dialog.exec()

    def open_repl_dialog(self):
        logger.debug(f"<<<< REPLACEMENTS BUTTON PRESSED >>>>")
        self.replacements_dialog = MappingManager(self, tb_object=self.stt)
        toolbar_position = self.geometry()
        self.replacements_dialog.move(toolbar_position.left(), toolbar_position.bottom()+10)
        self.replacements_dialog.resize(self.geometry().width(), scale(450))
        self.replacements_dialog.exec_()          

    def open_dialog(self, whndl=None, pid=None):
        # This method is called if toggle button (record/pause/idle) is clicked on the toolbar
        # if in recording mode, put in pause or in idle, depending on the user settings
        logger.debug(f"<<<< REC/STOP/PAUSE BUTTON PRESSED >>>>")
        if self.recording_state == 'recording':
            action_after_recording = get_settings_value(self.settings, ['general', 'action-after-recording'])
            if action_after_recording == 'stop':
                self.stop_recording()
            else:
                self.pause_recording()
        # if in pause mode
        elif self.recording_state=='pause':
            # set self.wtof and self.continue_sessionId to None to indicate that the command is not comming from an external command
            self.wtof = None
            self.continue_sessionId = None
            self.record()
        # if idle
        else:
            # if the user switched off this feature in the settings, ignore it and just start dictation
            # self.continue_sessionId refers to session start initiated via an external command and is None in all cases here
            logger.debug(f"show-dialog-PID: {get_settings_value(self.settings, ['general', 'show-dialog-PID'])}")
            if not get_settings_value(self.settings, ['general', 'show-dialog-PID']):
                self.continue_sessionId = None
                self.record()
                return

            dialog = QtWidgets.QDialog()
            dialog.ui = Ui_Dialog_pid()
            dialog.ui.setupUi(dialog, self.settings, whndl=whndl, pid=pid)

            # make window stay on top
            dialog.setWindowFlags(Qt.WindowStaysOnTopHint)
            
            # Show/hide notification
            """
            if self.qt_settings.value('suppress-notifications')=='true':
                dialog.ui.textBrowser_notification.setVisible(False)
                dialog.ui.checkBox_dontshow.setVisible(False)
                dialog.resize(scale(300), scale(110))
            else:
                dialog.ui.textBrowser_notification.setVisible(True)
                dialog.ui.checkBox_dontshow.setVisible(True)
                dialog.resize(scale(300), scale(220))
            """

            # position dialog right/left from the toolbar
            if self.pos().x() + self.size().width() + scale(10) + dialog.frameGeometry().width() > QDesktopWidget().availableGeometry().width():
                dialog.move(
                    self.pos().x() - dialog.frameGeometry().width() - scale(10), 
                    self.pos().y()
                    )    
            else:
                dialog.move(
                    self.pos().x() + self.frameGeometry().width() + scale(10), 
                    self.pos().y()
                    )
            
            # open dialog
            self.PID_dialog_opened=True
            
            if not self.isActiveWindow():
                logger.debug(f"Active window when PID is opening and is without focus: {win32gui.GetWindowText(win32gui.GetForegroundWindow())}")
                # make the destination window active
                wtof = get_settings_value(self.settings, ['localization', 'main-window-title'])
                #wtof = "TB-listener"
                if wtof:
                    #set_focus_to_window(wtof)
                    self.win_mnpl.set_focus_to_window(wtof)

            if dialog.exec_()==QDialog.Accepted:
                # construct session name as required in settings
                session_template = get_settings_value(self.settings, ['localization', 'session-name-template'])
                if session_template:
                    # remember session name for latter when session ID is received
                    self.session_name = session_template.format(
                        label1=dialog.ui.lineEdit_pid.text(),
                        label2=dialog.ui.lineEdit_ido.text()
                        )
                else:
                    self.session_name = dialog.ui.lineEdit_pid.text()
                logger.info(f"Starting dictation for the patient with id {self.session_name}")
                # setting self.wtof to None to indicate that the command is not comming from an external command
                self.wtof = None
                self.continue_sessionId = None
                self.record()
            self.PID_dialog_opened=False

    def open_detailed_settings(self):
        detailed_settings_dialog = QtWidgets.QDialog()
        detailed_settings_dialog.ui = DetailedSettings(
            gui_object=detailed_settings_dialog,
            settings=self.settings,
            truebar_object=self.stt,
            )
        detailed_settings_dialog.setWindowFlags(Qt.WindowStaysOnTopHint)
        current_templates_folder = detailed_settings_dialog.ui.lineEdit_templates.text()
        current_templates_use_local = detailed_settings_dialog.ui.checkBox_use_local_templates.isChecked() 
        detailed_settings_dialog.exec()

        # check if the location of templates changed or source for the templates changed (local vs B21)
        if detailed_settings_dialog.ui.lineEdit_templates.text() != current_templates_folder or detailed_settings_dialog.ui.checkBox_use_local_templates.isChecked() != current_templates_use_local:
            self.templates = self.read_templates()
            logger.debug(f"Templates folder changed or setting 'use local templates' changed ==> templates were updated.")
            self.label_logged_user.setText(
                f'<a href="open_templates">T: {len(self.templates)}</a> | '
                f'U: {self.lineEdit_username.text()}  '
            )

        #reload settings
        self.settings = detailed_settings_dialog.ui.settings
        enabled_commands_setting = get_settings_value(self.settings, ['user-defined-commands', 'enabled-commands'])
        if enabled_commands_setting:
            self.enabled_commands = [key for item in enabled_commands_setting for key, value in item.items() if value]
        else:
            self.enabled_commands = []

    def show_last_err(self):
        logger.debug(f"<<<< SHOW ALARM BUTTON PRESSED >>>>")
        self.error_dlg = QtWidgets.QDialog()
        self.error_dlg.ui = Error_Stack(
            gui_object=self.error_dlg,
            truebar_object=self.stt,
            alarm_icon=self.actionAlarm,
            error_text=self.label_interim,
            host=self.lineEdit_host.text(), 
            user=self.lineEdit_username.text(),  
            )
        self.error_dlg.setWindowFlags(Qt.WindowStaysOnTopHint)
        self.error_dlg.exec()

    def check_dictaphone_label(self):
        """
        Read labels of the client and check if "diktafon" label exists.
        If not, create it! We need it to denote sessions created in 
        dictaphone mode.
        """
        self.dictaphone_label_id = None
        labels = self.stt.get_client_labels()
        if labels:
            dictaphone_label_id = [l['id'] for l in labels if l['code'].lower()=="diktafon"]
            # if dictaphone label does not exist yet, add one - use color from the settings
            if not dictaphone_label_id:
                label_color = get_settings_value(self.settings, ['general', 'dictaphone-label-color'])
                if not label_color:
                    label_color = '#199D55'
                res = self.stt.add_client_label(
                    label_code='diktafon',
                    label_color=label_color,
                    isDefault=False
                )
                if res:
                    dictaphone_label_id = res.get('id', None)
                logger.info(f"Dictaphone label created with ID: {dictaphone_label_id}")
            else:
                dictaphone_label_id = dictaphone_label_id[0] if dictaphone_label_id else None
                logger.info(f"Dictaphone label ID: {dictaphone_label_id}")
            self.dictaphone_label_id = dictaphone_label_id

    def enable_dictaphone_label(self):
        """
        When end button is pressed on the Toolbar or when stop command is received from external source or when Streamer sends end command,
        set label 'diktafon' if in dictaphone mode!
        """
        logger.debug(f"Current session: {self.current_sessionid}, note taking mode: {self.note_taking_mode}")
        if not self.dictaphone_label_id:
            logger.warning("Dictaphone label doesn't exist and can't be enabled!")
        else:
            self.stt.add_session_label(
                sessionid=self.current_sessionid, 
                labelid=self.dictaphone_label_id, 
                is_enabled=True,
            )

class Ui_Dialog_pid(object):
    def setupUi(self, Dialog_pid, settings, whndl=None, pid=None):
        # set Qsettings
        self.qt_settings = QSettings('Vitasis', 'TB-listener')
        self.settings = settings
        #
        Dialog_pid.setObjectName("Dialog_pid")
        # make window fixed size
        Dialog_pid.setFixedSize(int(303*scalingFactor), int(110*scalingFactor))
        #Dialog_pid.resize(scale(303), scale(110))

        font = QtGui.QFont()
        font.setBold(True)
        font.setWeight(75)
        
        self.label_pid = QtWidgets.QLabel(Dialog_pid)
        self.label_pid.setGeometry(QtCore.QRect(scale(20), scale(22), scale(91), scale(16)))
        self.label_pid.setObjectName("label_pid")
        self.label_pid.setAlignment(QtCore.Qt.AlignRight|QtCore.Qt.AlignTrailing|QtCore.Qt.AlignVCenter)

        self.lineEdit_pid = QtWidgets.QLineEdit(Dialog_pid)
        self.lineEdit_pid.setGeometry(QtCore.QRect(scale(120), scale(20), scale(150), scale(20)))
        self.lineEdit_pid.setFont(font)
        self.lineEdit_pid.setObjectName("lineEdit_pid")
        pid_default = get_settings_value(self.settings, ['localization', 'session-name-label1-default'])
        if pid_default:
            self.lineEdit_pid.setText(pid_default)

        self.label_ido = QtWidgets.QLabel(Dialog_pid)
        self.label_ido.setGeometry(QtCore.QRect(scale(20), scale(47), scale(91), scale(16)))
        self.label_ido.setObjectName("label_ido")
        self.label_ido.setAlignment(QtCore.Qt.AlignRight|QtCore.Qt.AlignTrailing|QtCore.Qt.AlignVCenter)
        
        self.lineEdit_ido = QtWidgets.QLineEdit(Dialog_pid)
        self.lineEdit_ido.setGeometry(QtCore.QRect(scale(120), scale(45), scale(150), scale(20)))
        self.lineEdit_ido.setFont(font)
        self.lineEdit_ido.setObjectName("lineEdit_ido")
        ido_default = get_settings_value(self.settings, ['localization', 'session-name-label2-default'])
        if ido_default:
            self.lineEdit_ido.setText(ido_default)

        self.pushButton_cancel = QtWidgets.QPushButton(Dialog_pid)
        self.pushButton_cancel.setGeometry(QtCore.QRect(scale(200), scale(70), scale(71), scale(23)))
        self.pushButton_cancel.setDefault(False)
        self.pushButton_cancel.setObjectName("pushButton_cancel")
        
        self.pushButton_record = QtWidgets.QPushButton(Dialog_pid)
        self.pushButton_record.setGeometry(QtCore.QRect(scale(120), scale(70), scale(71), scale(23)))
        self.pushButton_record.setDefault(True)
        self.pushButton_record.setObjectName("pushButton_record")
        
        self.textBrowser_notification = QtWidgets.QTextBrowser(Dialog_pid)
        self.textBrowser_notification.setGeometry(QtCore.QRect(scale(30), scale(110), scale(241), scale(91)))
        self.textBrowser_notification.setStyleSheet("border-style: solid;\n"
"background-color: rgb(scale(231), scale(231), scale(231));\n"
"border-width: 1px;\n"
"border-color: rgb(scale(206), scale(206), scale(206));")
        self.textBrowser_notification.setObjectName("textBrowser_notification")
        self.textBrowser_notification.setVisible(False)
        self.checkBox_dontshow = QtWidgets.QCheckBox(Dialog_pid)
        self.checkBox_dontshow.setGeometry(QtCore.QRect(scale(40), scale(160), scale(191), scale(17)))
        self.checkBox_dontshow.setObjectName("checkBox_dontshow")
        self.checkBox_dontshow.stateChanged.connect(self.change_notifications)
        self.checkBox_dontshow.setVisible(False)

        self.retranslateUi(Dialog_pid)

        # if pid is received over external request, preload it to lineEdit_pi
        if pid:
            self.lineEdit_pid.setText(pid)

        # if 'Prekini' is clicked, send reject signal and close dialog - do nothing further
        self.pushButton_cancel.clicked.connect(Dialog_pid.reject)
        # if 'Začni' is clicked, first validate if PID was entered ...
        self.pushButton_record.clicked.connect(lambda: self.validate_and_start(Dialog_pid))
        # the next ine is confusing: check https://stackoverflow.com/questions/2462401/problem-in-understanding-connectslotsbyname-in-pyqt
        QtCore.QMetaObject.connectSlotsByName(Dialog_pid)
        self.button_pressed = None

    def retranslateUi(self, Dialog_pid):
        _translate = QtCore.QCoreApplication.translate
        Dialog_pid.setWindowTitle(_translate("Dialog_pid", "Oznaka zapisa"))
        self.label_pid.setText(_translate("Dialog_pid", _nvl(get_settings_value(self.settings, ['localization', 'session-name-label1']), "Oznaka pacienta")))
        self.label_ido.setText(_translate("Dialog_pid", _nvl(get_settings_value(self.settings, ['localization', 'session-name-label2']), "Številka obravnave")))
        self.pushButton_cancel.setText(_translate("Dialog_pid", "Prekini"))
        self.pushButton_record.setText(_translate("Dialog_pid", "Začni"))
        self.textBrowser_notification.setHtml(_translate("Dialog_pid", "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0//EN\" \"http://www.w3.org/TR/REC-html40/strict.dtd\">\n"
"<html><head><meta name=\"qrichtext\" content=\"1\" /><style type=\"text/css\">\n"
"p, li { white-space: pre-wrap; }\n"
"</style></head><body style=\" font-family:\'MS Shell Dlg 2\'; font-size:8.25pt; font-weight:400; font-style:normal;\">\n"
"<p style=\" margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\">Po pritisku na gumb <span style=\" font-weight:600;\">Začni</span> najprej preverite, če je kurzor v oknu, v katerega želite narekovati besedilo. Šele nato začnite z narekovanjem! </p></body></html>"))
        self.checkBox_dontshow.setText(_translate("Dialog_pid", "Ne prikazuj več tega obvestila"))

    def validate_and_start(self, Dialog_pid):
        if self.lineEdit_pid.text().strip() != "":
            Dialog_pid.accept()
        else:
            self.lineEdit_pid.setStyleSheet("border: 1px solid red;")
            
    def change_notifications(self):
        # read and change settings
        if self.checkBox_dontshow.checkState()==0:
            self.qt_settings.setValue('suppress-notifications', False)
        else:
            self.qt_settings.setValue('suppress-notifications', True)

class Dictation_commands(QtWidgets.QDialog, Ui_Dialog_commands):
    def __init__(self, gui_object):
        super().__init__()
        # render gui
        self.setupUi(gui_object)
        # make window fixed size
        gui_object.setFixedSize(int(591*scalingFactor), int(761*scalingFactor))
        # make window stay on top
        self.setWindowFlags(
            self.windowFlags() |  
            QtCore.Qt.WindowStaysOnTopHint
        )
        # connect pushbutton click to action close
        self.pushButton_close.clicked.connect(gui_object.close)

class Add_Word_Dialog(QtWidgets.QDialog, Ui_Dialog_add_word):
    def __init__(self, gui_object, truebar_object, tb_config):
        super().__init__()
        # to work with the BE, Truebar object, created within the mainwindow is used
        self.stt = truebar_object
        self.tb_current_config = tb_config
        # render gui
        self.setupUi(gui_object)
        # make window fixed size 437|512
        gui_object.setFixedSize(int(242*scalingFactor), int(439*scalingFactor))
        # make window stay on top
        self.setWindowFlags(
            self.windowFlags() |  
            QtCore.Qt.WindowStaysOnTopHint
        )
        # load icons
        icon_download = QtGui.QIcon()
        icon_download.addPixmap(QtGui.QPixmap(os.path.join(basedir, "download.png")), QtGui.QIcon.Normal, QtGui.QIcon.Off)
        self.pushButton_readDict.setIcon(icon_download)
        self.icon_collapse = QtGui.QIcon()
        self.icon_collapse.addPixmap(QtGui.QPixmap(os.path.join(basedir, "collapse.png")), QtGui.QIcon.Normal, QtGui.QIcon.Off)
        self.icon_expand = QtGui.QIcon()
        self.icon_expand.addPixmap(QtGui.QPixmap(os.path.join(basedir, "more.png")), QtGui.QIcon.Normal, QtGui.QIcon.Off)
        # initially the detailed bar is collapsed
        self.pushButton_expand.setIcon(self.icon_expand)
        self.dialog_expanded = False
        
        # configure badge
        self.label_badge.setStyleSheet("color: white; background-color: blue; border-radius: 12px;")

        # connect pushbuttons
        self.pushButton_add_pron.clicked.connect(lambda: self.add_pron())
        self.pushButton_del_pron.clicked.connect(lambda: self.del_pron())
        self.pushButton_update_pron.clicked.connect(lambda: self.update_pron())
        self.pushButton_dict_close.clicked.connect(gui_object.close)
        self.pushButton_dict_save.clicked.connect(lambda: self.save_dict())
        self.pushButton_readDict.clicked.connect(lambda: self.read_dictionary())
        self.pushButton_expand.clicked.connect(lambda: self.show_details(gui_object))
        self.pushButton_update_model.clicked.connect(lambda: self.start_model_update())

        # connect listWidget_pron
        self.listWidget_pron.currentRowChanged.connect(lambda: self.change_current_pron())

        # get frequency classes
        [{"id":1,"label":"zelo redko"},{"id":2,"label":"redko"},{"id":3,"label":"občasno"},{"id":4,"label":"pogosto"},{"id":5,"label":"zelo pogosto"}]
        frequency_classes = self.stt.get_frequency_classes()
        if frequency_classes:
            self.comboBox_tf.addItems([None]+[fc['label'] for fc in frequency_classes])
        else:
            logger.warning(f"Couldn't retrieve frequency classes from the server!")
        
        # init fields
        self.init_fields()

        # Set validator for word entries - must not include spaces    
        validator = NoSpaceValidator()
        self.lineEdit_word.setValidator(validator)

        # set validation for pronunciations - only allowed phonemes are acceptable
        self.phoneme_validator=None
        res=self.get_phoneset()
        if res:
            allowed_phonemes = "|" + "".join(res['nonsilentPhones'].split(" "))
            reg_ex = QRegExp(rf"[{allowed_phonemes}]+")
            self.phoneme_validator = QRegExpValidator(reg_ex, self.lineEdit_curr_pron)
            self.lineEdit_curr_pron.setValidator(self.phoneme_validator)

        # read data for badge on new word 
        self.read_word_stat()

        # set variable for timer
        self.timer = None
        
        # read data about model update
        self.qt_settings = QSettings('Vitasis', 'TB-listener')
        self.model_updates = self.qt_settings.value('model-updates') or dict()

    def init_fields(self):
        self.comboBox_tf.setCurrentIndex(0)
        self.lineEdit_curr_pron.clear()
        self.lineEdit_word.clear()
        self.listWidget_pron.clear()
        self.label_word_status.clear()
        self.label_action_status.clear()
        self.label_update_status.clear()
        self.lineEdit_word.setFocus()

    def get_phoneset(self):
        return self.stt.get_model_phoneset(
            language = self.tb_current_config["stt"]["language"]["value"], 
            domain = self.tb_current_config["stt"]["domain"]["value"],
            model = self.tb_current_config["stt"]["model"]["value"], 
        )
        
    def read_dictionary(self):
        self.lineEdit_curr_pron.clear()
        self.listWidget_pron.clear()
        self.comboBox_tf.setCurrentIndex(0)
        self.label_action_status.clear()

        res = self.stt.read_dictionary(
            language = self.tb_current_config["stt"]["language"]["value"], 
            domain = self.tb_current_config["stt"]["domain"]["value"],
            model = self.tb_current_config["stt"]["model"]["value"],
            token=self.lineEdit_word.text()
        )
        
        if res:
            # if multiple records exist for the same token, log this
            if len(res)>1:
                logger.warning(f"Multiple records received for the word {self.lineEdit_word.text()}.")
            
            if 'status' in res[0]:
                if res[0]["status"] == 'NEW':
                    self.label_word_status.setText('nova beseda')
                    self.label_word_status.setStyleSheet("color: darkred")
                elif res[0]["status"] == 'IN_DICTIONARY': 
                    self.label_word_status.setText('beseda je že v slovarju izbranega modela')
                    self.label_word_status.setStyleSheet("color: green")
                else: 
                    self.label_word_status.setText('beseda je že na seznamu za prenovo modela.')
                    self.label_word_status.setStyleSheet("color: green")
                
                if "pronunciations" in res[0]:
                    # add pronunciations that are saved for the token. If new token, add all pronunciations (generated)
                    self.listWidget_pron.addItems([el["text"] for el in res[0]['pronunciations'] if el["saved"] or res[0]["status"] == 'NEW'])
                    # select first pron
                    self.listWidget_pron.setCurrentRow(0)
                    if self.listWidget_pron.currentItem():
                        self.lineEdit_curr_pron.setText(self.listWidget_pron.currentItem().text())

                if res[0]["status"] != 'NEW':
                    if "frequencyClassId" in res[0]:
                        self.comboBox_tf.setCurrentIndex(res[0]["frequencyClassId"])
                else:
                    self.comboBox_tf.setCurrentIndex(3)
                    
        self.lineEdit_word.setFocus()

    def add_pron(self):
        if self.lineEdit_curr_pron.text() not in [self.listWidget_pron.item(i).text() for i in range(self.listWidget_pron.count())]:
            self.listWidget_pron.addItem(self.lineEdit_curr_pron.text())
    
    def del_pron(self):
        if self.listWidget_pron.currentRow() != -1:
            self.listWidget_pron.takeItem(self.listWidget_pron.currentRow())
            self.lineEdit_curr_pron.clear()
        if self.listWidget_pron.count()>0:
            self.listWidget_pron.setCurrentRow(0)
            self.lineEdit_curr_pron.setText(self.listWidget_pron.currentItem().text())
            self.pron_current_row=0
        else:
            self.pron_current_row=None

    def update_pron(self):
        if self.pron_current_row:
            self.listWidget_pron.setCurrentRow(self.pron_current_row)
            self.listWidget_pron.currentItem().setText(self.lineEdit_curr_pron.text())

    def save_dict(self):
        """
        New or updated enties are saved to DB and locally to AppData/dict for sync purposes
        """
        if self.listWidget_pron.count() > 0:
            word_entry = dict(
                text=self.lineEdit_word.text(),
                frequencyClassId=self.comboBox_tf.currentIndex(),
                pronunciations=[dict(text=self.listWidget_pron.item(i).text()) for i in range(self.listWidget_pron.count())]
            )
            if self.stt.save_dictionary(
                language = self.tb_current_config["stt"]["language"]["value"], 
                domain = self.tb_current_config["stt"]["domain"]["value"],
                model = self.tb_current_config["stt"]["model"]["value"],
                word_entry=word_entry,
                ):
                self.init_fields()
                self.label_action_status.setText("Beseda uspešno shranjena.")
                self.label_action_status.setStyleSheet("color: green")
                # save to file
                with open(f"{os.path.join(user_appdata, 'dict', 'dictionary.jsonl')}", "a", encoding="utf-8") as fdict:
                    word_entry.update(ts=format_datetime(time.time()))
                    fdict.write(json.dumps(word_entry, ensure_ascii=False)+"\n")
    
            else:
                self.label_action_status.setText("Pri shranjevanju je prišlo do napake!")
                self.label_action_status.setStyleSheet("color: red")
                logger.error(f"Error when saving word entry {word_entry} to dictionary!")
                
        else:
            self.label_action_status.setText("Beseda nima nobene izgovorjave!")
            self.label_action_status.setStyleSheet("color: red")

    def change_current_pron(self):
        if self.listWidget_pron.currentItem():
            self.pron_current_row = self.listWidget_pron.currentRow()
            self.lineEdit_curr_pron.setText(self.listWidget_pron.currentItem().text())
            if self.phoneme_validator:
                if self.phoneme_validator.validate(self.lineEdit_curr_pron.text(), 0)[0] != QtGui.QValidator.Acceptable:
                    self.lineEdit_curr_pron.setStyleSheet("border-style: solid; border-width: 1px; border-color: red")
                else:
                    self.lineEdit_curr_pron.setStyleSheet("border-style: solid; border-width: 1px; border-color: grey")

    def read_word_stat(self):
        res = self.stt.get_model_word_count(
            language = self.tb_current_config["stt"]["language"]["value"], 
            domain = self.tb_current_config["stt"]["domain"]["value"],
            model = self.tb_current_config["stt"]["model"]["value"]
            )
        if res:
            self.label_badge.setText(str(res.get('wordsNew', None)))
            if res.get('wordsNew', 0) > 0:
                self.label_badge.setVisible(True)
            else:
                self.label_badge.setVisible(False) 
            return True
        else:
            self.label_badge.setVisible(False)
            return False

    def show_details(self, gui_object):
        if not self.dialog_expanded:
            self.refresh_model_update_status()
            # show badge if new words waiting for the update
            self.read_word_stat()
            gui_object.setFixedHeight(int(_dictionary_frame_height_L*scalingFactor))
            self.pushButton_expand.setIcon(self.icon_collapse)
            # start timer to check updater status every 3 sec - timer will stop if status is FAILED or NOT_RUNNING
            self.timer = QTimer()
            self.timer.setInterval(3000)
            self.timer.timeout.connect(self.refresh_model_update_status)
            self.timer.start()
        else:
            gui_object.setFixedHeight(int(_dictionary_frame_height_S*scalingFactor))
            self.pushButton_expand.setIcon(self.icon_expand)
            # stop timer
            if self.timer:
                self.timer.stop()
        self.dialog_expanded = not self.dialog_expanded

    def start_model_update(self):
        language = self.tb_current_config["stt"]["language"]["value"]
        domain = self.tb_current_config["stt"]["domain"]["value"]
        model = self.tb_current_config["stt"]["model"]["value"]
        
        # check if the user has appropriate credentials to start the update
        model_update_allowed = self.stt.check_model_update_status(language=language, domain=domain, model=model)
        if not model_update_allowed or not model_update_allowed.get("enableModelUpdating", False):
            show_message_box(
                message='Nimate pravice za prenovo modela. Obrnite se na skrbnika aplikacije.',
                box_title='Opozorilo',
                button_yes_text='Zapri',
                box_type='Warning',
                num_of_buttons=1
            ) 

        elif show_message_box(
            message='Posodobitev modela lahko traja več kot 20 minut. Po končeni posodobitvi bodo vse seje z obstoječim modelom samodejno prekinjene! Nov model bo na voljo kot nova izbira v okviru nastavitev. Želite nadaljevati?',
            box_title='Opozorilo',
            button_yes_text='Nadaljuj',
            button_no_text='Prekliči',
            box_type='Warning',
            num_of_buttons=2
            ) == 1:
            # start model updater
            if self.stt.start_model_update(language=language, domain=domain, model=model):
                logger.debug("Model update started!")
                self.label_update_status.setText("Model se prenavlja ...")
                self.label_update_status.setStyleSheet(f"color: {cl_message_success}")
                # save starting time
                self.model_updates[f"{language}{domain}{model}"].update(start_time=time.time())
                self.qt_settings.setValue('model-updates', self.model_updates)
                # start timer
                if not self.timer.isActive():
                    self.timer.start()
            else:
                logger.error("Model update didn't start!") 
        else:
            print(self.stt.check_model_update_status(
                language = language, 
                domain = domain,
                model = model,
            ))
        
    def refresh_model_update_status(self):
        language = self.tb_current_config["stt"]["language"]["value"]
        domain = self.tb_current_config["stt"]["domain"]["value"]
        model = self.tb_current_config["stt"]["model"]["value"]
        
        self.label_update_status.setText("")
        
        model_updater_status = self.stt.check_model_update_status(language=language, domain=domain, model=model)
        if not model_updater_status:
            self.label_update_status.setText("Servis za prenovo trenutno ni na voljo!")
            self.label_update_status.setStyleSheet(f"color: {cl_message_failed}")
            return

        # if servis is not running and no data in regisry yet, set empty dict and 
        # then update. There will be no start_time key until model updater is started  
        if f"{language}{domain}{model}" not in self.model_updates:
            self.model_updates[f"{language}{domain}{model}"]=dict()
        self.model_updates[f"{language}{domain}{model}"].update(
            status=model_updater_status.get('statusCode', 'UNKNOWN'),
            last_check=time.strftime('%H:%M:%S', time.gmtime(time.time()))
            )
        # refresh registry entry
        self.qt_settings.setValue('model-updates', self.model_updates)
        
        if model_updater_status and model_updater_status.get('enableModelUpdating', False):
            logger.debug(f"Model update status: {model_updater_status}")
            if model_updater_status['statusCode']=="FAILED":
                # if last attempt failed, show message and allow restart. Stop timer if running.
                self.label_update_status.setText("Zadnji poskus prenove neuspešen!")
                self.label_update_status.setStyleSheet(f"color: {cl_message_failed}")
                self.pushButton_update_model.setEnabled(True)
                if self.timer:
                    self.timer.stop()
            elif model_updater_status['statusCode']=="RUNNING":
                # if running, keep updating status and disable pushButton
                elapsed_time = time.time() - self.model_updates[f"{language}{domain}{model}"].get('start_time', time.time())
                self.label_update_status.setText(f"Model se prenavlja ({time.strftime('%H:%M:%S', time.gmtime(elapsed_time))})")
                self.label_update_status.setStyleSheet(f"color: {cl_message_success}")
                self.pushButton_update_model.setEnabled(False)
            elif model_updater_status['statusCode']=="NOT_RUNNING":
                # if not running, clear status message and enable pushButton if new words > 0
                # stop timer if running
                self.label_update_status.setText("")
                if self.label_badge.text()!="0":
                    self.pushButton_update_model.setEnabled(True)
                else:
                    self.pushButton_update_model.setEnabled(False)
                if self.timer:
                    self.timer.stop()
        else:
            self.pushButton_update_model.setEnabled(False)
        
class SendLog(QtWidgets.QDialog, Ui_Dialog_sendLog):
    def __init__(self, gui_object, logger_folder, tb_backend, username, host):
        super().__init__()
        # render gui
        self.setupUi(gui_object)
        # make window fixed size
        gui_object.setFixedSize(int(331*scalingFactor), int(137*scalingFactor))
        # make window stay on top
        self.setWindowFlags(
            self.windowFlags() |  
            QtCore.Qt.WindowStaysOnTopHint
        )
        self.logger_folder = logger_folder
        self.tb_backend = tb_backend
        self.username = username
        self.host = host
        # connect pushbuttons 
        self.pushButton_confirm.clicked.connect(self.sendlogs)
        self.pushButton_cancel.clicked.connect(gui_object.close)
    
    def sendlogs(self):
        """
        Logs are sent to minio over BE. User must be authenticated!
        """
        self.label_upload_result.setText("Nalagam ...")
        self.label_upload_result.setStyleSheet("color: black")
        # process events to make label text change immediately
        QApplication.processEvents()

        try:
            res = self.tb_backend.upload_logs(
                log_folder=self.logger_folder,
                host=self.host,
                username=self.username,
                )
        except Exception as e:
            res = None
            logger.error(f"Upload of log files failed. Exception: {e}")
            pass
       
        if res and 'all_log_files' in res and 'failed' in res:
            self.label_upload_result.setText(f"<b>{res['all_log_files']-res['failed']}</b> od <b>{res['all_log_files']}</b> datotek uspešno naloženih.")
            if res['all_log_files']-res['failed'] == 0:
                self.label_upload_result.setStyleSheet("color: black")
            else:    
                self.label_upload_result.setStyleSheet("color: green") 
        else:
            self.label_upload_result.setText("Pri nalaganju log datotek je prišlo do napake!")
            self.label_upload_result.setStyleSheet(f"color: {cl_message_failed}")

class DetailedSettings(QtWidgets.QDialog, Ui_Dialog_detailed_settings):
    def __init__(self, gui_object, settings, truebar_object=None):
        super().__init__()

        QtWidgets.QApplication.instance().focusChanged.connect(self.on_focusChanged)
        self.gui_object = gui_object

        self.settings = settings
        # the class variable settings will change. To keep track on changes, another variable is used, settings_orig
        self.settings_orig = copy.deepcopy(self.settings)
        # to work with teh BE, Truebar object, created within the mainwindow is used
        self.stt = truebar_object
        self.destination_formats = {0:'txt', 1:'rtf', 2:'docx', 3:'b21'}
        # initial state of changes
        self.settings_changed = False
        
        # render gui
        self.setupUi(gui_object)
        self.original_style = self.lineEdit_templates.styleSheet()

        # make first tab active
        self.tabWidget.setCurrentIndex(0)
        # clear status label
        self.label_result_status.clear()
        # make window fixed size
        gui_object.setFixedSize(int(819*scalingFactor), int(650*scalingFactor))
        # make window stay on top
        self.setWindowFlags(
            self.windowFlags() |  
            QtCore.Qt.WindowStaysOnTopHint
        )
        # connect pushbuttons
        #self.pushButton_close.clicked.connect(gui_object.close)
        self.pushButton_close.clicked.connect(lambda: self.close_window())
        self.pushButton_save.clicked.connect(lambda: self.save_settings())
        self.pushButton_add_basic_repl.clicked.connect(lambda: self.add_replacement_to_list())
        self.pushButton_del_basic_repl.clicked.connect(lambda: self.delete_replacement_from_list())
        self.pushButton_update_basic_repl.clicked.connect(lambda: self.update_replacement_on_list())
        self.toolButton_templates.clicked.connect(lambda: self.open_file_dialog())
        self.toolButton_templates_2.clicked.connect(lambda: self.open_file_dialog(shared=True))
        self.pushButton_checkAll.clicked.connect(lambda: self.enable_commands_switch(True))
        self.pushButton_uncheck_all.clicked.connect(lambda: self.enable_commands_switch(False))
        # connect checkBoxes
        self.checkBox_use_proxy.clicked.connect(lambda: self.init_fields(fields='proxy'))
        self.checkBox_focus_by_key.clicked.connect(lambda: self.init_fields(fields='key'))
        self.checkBox_focus_by_title.clicked.connect(lambda: self.init_fields(fields='title'))
        self.checkBox_listen_external.clicked.connect(lambda: self.init_fields(fields='listener'))
        self.checkBox_use_local_templates.clicked.connect(lambda: self.init_fields(fields='templates'))
        self.checkBox_numbers.stateChanged.connect(lambda: self.save_changes(fields='numbers'))
        self.checkBox_spp.stateChanged.connect(lambda: self.save_changes(fields='spp'))
        self.checkBox_capitalization.stateChanged.connect(lambda: self.save_changes(fields='capitalization'))
        self.checkBox_beep_on_final.stateChanged.connect(lambda: self.save_changes(fields='beep'))
        self.checkBox_space_after_pause.stateChanged.connect(lambda: self.save_changes(fields='spaceAfterPause'))
        self.checkBox_dot_floating_point.stateChanged.connect(lambda: self.save_changes(fields='dotFloatingPoint'))
        self.checkBox_format_notes.stateChanged.connect(lambda: self.save_changes(fields='notes'))
        self.checkBox_show_PID.stateChanged.connect(lambda: self.save_changes(fields='pid'))
        self.checkBox_use_proxy.stateChanged.connect(lambda: self.save_changes(fields='use-proxy'))
        self.checkBox_focus_by_key.stateChanged.connect(lambda: self.save_changes(fields='key'))
        self.checkBox_focus_by_title.stateChanged.connect(lambda: self.save_changes(fields='title'))
        self.checkBox_listen_external.stateChanged.connect(lambda: self.save_changes(fields='listener'))
        self.checkBox_purge_queue.stateChanged.connect(lambda: self.save_changes(fields='purge-queue'))
        self.checkBox_use_local_templates.stateChanged.connect(lambda: self.save_changes(fields='use-local-templates'))
        self.checkBox_dictaphone_toggle.stateChanged.connect(lambda: self.save_changes(fields='dictaphone'))
        self.checkBox_minimize.stateChanged.connect(lambda: self.save_changes(fields='systray'))
        self.checkBox_startInBufferingMode.stateChanged.connect(lambda: self.save_changes(fields='start-in-buffering-mode'))
        self.checkBox_dontShowTranscriptWin.stateChanged.connect(lambda: self.save_changes(fields='dont-show-transcript-win'))
        self.checkBox_nl.stateChanged.connect(lambda: self.save_changes(fields='nl'))
        self.checkBox_np.stateChanged.connect(lambda: self.save_changes(fields='np'))
        self.checkBox_bold.stateChanged.connect(lambda: self.save_changes(fields='b'))
        self.checkBox_italic.stateChanged.connect(lambda: self.save_changes(fields='i'))
        self.checkBox_underline.stateChanged.connect(lambda: self.save_changes(fields='u'))
        self.checkBox_align_center.stateChanged.connect(lambda: self.save_changes(fields='alignc'))
        self.checkBox_align_left.stateChanged.connect(lambda: self.save_changes(fields='alignl'))
        self.checkBox_align_right.stateChanged.connect(lambda: self.save_changes(fields='alignr'))
        self.checkBox_uppercase.stateChanged.connect(lambda: self.save_changes(fields='uc'))
        self.checkBox_lowercase.stateChanged.connect(lambda: self.save_changes(fields='lc'))
        self.checkBox_start_with_upper.stateChanged.connect(lambda: self.save_changes(fields='UC'))
        self.checkBox_start_with_lower.stateChanged.connect(lambda: self.save_changes(fields='LC'))
        self.checkBox_del_all.stateChanged.connect(lambda: self.save_changes(fields='delall'))
        self.checkBox_del_last.stateChanged.connect(lambda: self.save_changes(fields='delw'))
        self.checkBox_del_last_n.stateChanged.connect(lambda: self.save_changes(fields='deln'))
        self.checkBox_dels.stateChanged.connect(lambda: self.save_changes(fields='dels'))
        self.checkBox_select_all.stateChanged.connect(lambda: self.save_changes(fields='selectall'))
        self.checkBox_copy.stateChanged.connect(lambda: self.save_changes(fields='copy'))
        self.checkBox_paste.stateChanged.connect(lambda: self.save_changes(fields='paste'))
        self.checkBox_end_dictation.stateChanged.connect(lambda: self.save_changes(fields='end'))
        self.checkBox_pause.stateChanged.connect(lambda: self.save_changes(fields='pause'))
        self.checkBox_space.stateChanged.connect(lambda: self.save_changes(fields='spc'))
        self.checkBox_nospace.stateChanged.connect(lambda: self.save_changes(fields='nospace'))
        self.checkBox_comments.stateChanged.connect(lambda: self.save_changes(fields='comment'))
        self.checkBox_last_text.stateChanged.connect(lambda: self.save_changes(fields='textback'))
        self.checkBox_next.stateChanged.connect(lambda: self.save_changes(fields='next'))
        self.checkBox_prev.stateChanged.connect(lambda: self.save_changes(fields='prev'))
        self.checkBox_insert.stateChanged.connect(lambda: self.save_changes(fields='ins'))

        # connect comboBoxes
        self.comboBox_protocol.currentTextChanged.connect(lambda: self.save_changes(fields='proxy-protocol'))
        # connect other components of the replacements tab
        self.listWidget_basic_repl.currentRowChanged.connect(lambda: self.populate_list_of_replacements())
        self.lineEdit_filter.textChanged.connect(self.filter_replacements)
        # populate fields with settings
        self.checkBox_numbers.setChecked(get_settings_value(self.settings, ['general', 'do-postprocessing', 'numbers']))
        self.checkBox_spp.setChecked(get_settings_value(self.settings, ['general', 'do-postprocessing', 'spp-codes']))
        self.checkBox_capitalization.setChecked(get_settings_value(self.settings, ['general', 'do-postprocessing', 'capitalize-sentences']))
        self.checkBox_beep_on_final.setChecked(get_settings_value(self.settings, ['general', 'beep-on-finals']))
        self.checkBox_space_after_pause.setChecked(get_settings_value(self.settings, ['general', 'continue-pause-with-space']))
        self.checkBox_dot_floating_point.setChecked(get_settings_value(self.settings, ['general', 'use-dot-floating-point']))
        self.checkBox_format_notes.setChecked(get_settings_value(self.settings, ['general', 'do-postprocessing', 'format-notes']))
        self.checkBox_show_PID.setChecked(get_settings_value(self.settings, ['general', 'show-dialog-PID']))
        self.checkBox_minimize.setChecked(get_settings_value(self.settings, ['general', 'system-tray', 'minimize-after-login']))
        self.checkBox_dontShowTranscriptWin.setChecked(get_settings_value(self.settings, ['general', 'dont-show-transcript-win']))
        self.checkBox_startInBufferingMode.setChecked(get_settings_value(self.settings, ['general', 'start-in-buffering-mode']))
        self.init_fields(fields='start-in-buffering-mode')
        self.checkBox_listen_external.setChecked(get_settings_value(self.settings, ['integration', 'listen-for-external-commands']))
        self.checkBox_purge_queue.setChecked(get_settings_value(self.settings, ['integration', 'purge-queue-on-start']))
        self.init_fields(fields='listener')
        self.checkBox_use_local_templates.setChecked(get_settings_value(self.settings, ['general', 'use-local-templates']))
        local_private_templates_folder = get_settings_value(self.settings, ['general', 'templates-folder'])
        local_private_templates_folder = "" if not local_private_templates_folder else local_private_templates_folder
        self.lineEdit_templates.setText(local_private_templates_folder)
        self.init_fields(fields='templates')
        local_shared_templates_folder = get_settings_value(self.settings, ['general', 'templates-folder-shared'])
        local_shared_templates_folder = "" if not local_shared_templates_folder else local_shared_templates_folder
        self.lineEdit_templates_shared.setText(local_shared_templates_folder)
        self.init_fields(fields='templates-shared')
        self.checkBox_use_proxy.setChecked(get_settings_value(self.settings, ['proxy-server', 'use-proxy-server']))
        self.lineEdit_host.setText(get_settings_value(self.settings, ['proxy-server', 'proxy-host-ip']))
        self.lineEdit_port.setText(str(get_settings_value(self.settings, ['proxy-server', 'proxy-host-port'])))
        current_proxy_protocol=get_settings_value(self.settings, ['proxy-server', 'proxy-type'])
        if not current_proxy_protocol:
            self.comboBox_protocol.setCurrentText('None')
        else:
            self.comboBox_protocol.setCurrentText(current_proxy_protocol)
        self.lineEdit_username.setText(get_settings_value(self.settings, ['proxy-server', 'http-proxy-auth-username']))
        self.lineEdit_password.setText(get_settings_value(self.settings, ['proxy-server', 'http-proxy-auth-password']))
        self.init_fields(fields='proxy')
        self.checkBox_focus_by_key.setChecked(get_settings_value(self.settings, ['general', 'autofocus', 'autofocus-with-key']))
        self.lineEdit_focus_key.setText(get_settings_value(self.settings, ['general', 'autofocus', 'autofocus-key']))
        self.init_fields(fields='key')
        self.checkBox_focus_by_title.setChecked(get_settings_value(self.settings, ['general', 'autofocus', 'autofocus-by-window-title']))
        self.init_fields(fields='title')
        self.lineEdit_focus_win_title.setText(get_settings_value(self.settings, ['general', 'autofocus', 'autofocus-window-title']))
        self.checkBox_dictaphone_toggle.setChecked(get_settings_value(self.settings, ['dictaphone-key-bindings', 'enable-hotkey-listener']))
        self.label_toggle_key_combination.setEnabled(self.checkBox_dictaphone_toggle.isChecked())
        self.lineEdit_toggle_key_combination.setText(get_settings_value(self.settings, ['dictaphone-key-bindings', 'toggle-key']))
        self.lineEdit_toggle_key_combination.setEnabled(self.checkBox_dictaphone_toggle.isChecked())
        
        ### commands
        enabled_commands_setting = get_settings_value(self.settings, ['user-defined-commands', 'enabled-commands'])
        if enabled_commands_setting:
            self.enabled_commands = [key for item in enabled_commands_setting for key, value in item.items() if value]
        else:
            self.enabled_commands = []
        self.init_fields(fields='command')

        ### validation
        onlyInt = QIntValidator()
        self.lineEdit_port.setValidator(onlyInt)
        ### hide tabs that are not yet implemented
        self.tabWidget.removeTab(3)
        self.tabWidget.removeTab(3)
        ### replacements
        self.reload_replacements()

    @QtCore.pyqtSlot("QWidget*", "QWidget*")
    def on_focusChanged(self, old, now):
        """
        This is to detect events that happen when some widget lose focus. We need this to trigger 
        lineEdit content validation and to store it into self.settings. The variable self.settings
        is kept in memory so without an explicit press on the button "Shrani", the changes will be 
        lost on exit.
        """
        self.label_result_status.clear()
        # proxy
        if self.lineEdit_host == old and self.lineEdit_host.text() != get_settings_value(self.settings, ['proxy-server', 'proxy-host-ip']):
            self.settings['proxy-server']['proxy-host-ip']=self.lineEdit_host.text()
            logger.debug(f"Value of the setting 'proxy-host-ip' changed to {self.lineEdit_host.text()}")
        elif self.lineEdit_port == old and int(_nvl(self.lineEdit_port.text(),'0')) != get_settings_value(self.settings, ['proxy-server', 'proxy-host-port']):
            self.settings['proxy-server']['proxy-host-port']=self.lineEdit_port.text()
            logger.debug(f"Value of the setting 'proxy-host-port' changed to {self.lineEdit_port.text()}")
        elif self.lineEdit_username == old: 
            current_proxy_username=self.lineEdit_username.text()
            if current_proxy_username == "":
                current_proxy_username = None
            if current_proxy_username != get_settings_value(self.settings, ['proxy-server', 'http-proxy-auth-username']):
                self.settings['proxy-server']['http-proxy-auth-username']=current_proxy_username
                logger.debug(f"Value of the setting 'http-proxy-auth-username' changed to {current_proxy_username}")
        elif self.lineEdit_password == old: 
            current_proxy_password=self.lineEdit_password.text()
            if current_proxy_password == "":
                current_proxy_password = None
            if current_proxy_password != get_settings_value(self.settings, ['proxy-server', 'http-proxy-auth-password']):
                self.settings['proxy-server']['http-proxy-auth-password']=current_proxy_password
                logger.debug(f"Value of the setting 'http-proxy-auth-password' changed to {current_proxy_password}")
        # templates
        elif self.lineEdit_templates == old and self.lineEdit_templates.text() != get_settings_value(self.settings, ['general', 'templates-folder']):
            self.settings['general']['templates-folder']=self.lineEdit_templates.text()
            logger.debug(f"Value of the setting 'templates-folder' changed to {self.lineEdit_templates.text()}")        
            # check if folder exists and color it in red if not
            if self.lineEdit_templates.text() and not os.path.isdir(self.lineEdit_templates.text()):
                self.lineEdit_templates.setStyleSheet(f"border: 2px solid red; background: {cl_light_orange_string};")
            else:
                self.lineEdit_templates.setStyleSheet(self.original_style)
        elif self.lineEdit_templates_shared == old and self.lineEdit_templates_shared.text() != get_settings_value(self.settings, ['general', 'templates-folder-shared']):
            self.settings['general']['templates-folder-shared']=self.lineEdit_templates_shared.text()
            logger.debug(f"Value of the setting 'templates-folder-shared' changed to {self.lineEdit_templates_shared.text()}")        
            # check if folder exists and color it in red if not
            if self.lineEdit_templates_shared and not os.path.isdir(self.lineEdit_templates_shared.text()):
                self.lineEdit_templates_shared.setStyleSheet(f"border: 2px solid red; background: {cl_light_orange_string};")
            else:
                self.lineEdit_templates_shared.setStyleSheet(self.original_style)
        # autofocus
        elif self.lineEdit_focus_key == old and self.lineEdit_focus_key.text() != get_settings_value(self.settings, ['general', 'autofocus', 'autofocus-key']):
            self.settings['general']['autofocus']['autofocus-key']=self.lineEdit_focus_key.text()
            logger.debug(f"Value of the setting 'autofocus-key' changed to {self.lineEdit_focus_key.text()}")
        elif self.lineEdit_focus_win_title == old and self.lineEdit_focus_win_title.text() != get_settings_value(self.settings, ['general', 'autofocus', 'autofocus-window-title']):
            self.settings['general']['autofocus']['autofocus-window-title']=self.lineEdit_focus_win_title.text()
            logger.debug(f"Value of the setting 'autofocus-window-title' changed to {self.lineEdit_focus_win_title.text()}")
        # dictaphone
        elif self.lineEdit_toggle_key_combination == old and self.lineEdit_toggle_key_combination.text() != get_settings_value(self.settings, ['dictaphone-key-bindings', 'toggle-key']):
            self.settings['dictaphone-key-bindings']['toggle-key']=self.lineEdit_toggle_key_combination.text()
            logger.debug(f"Value of the setting 'toggle-key' for dictaphone changed to {self.lineEdit_toggle_key_combination.text()}")
        # check if settings have changed
        if self.settings != self.settings_orig:
            self.settings_changed = True
        else:
            self.settings_changed = False 

    def init_fields(self, fields='key'):
        if fields=='key':
            self.lineEdit_focus_key.setEnabled(self.checkBox_focus_by_key.isChecked())
        elif fields=='title':
            self.lineEdit_focus_win_title.setEnabled(self.checkBox_focus_by_title.isChecked())
        elif fields=='listener':
            self.checkBox_purge_queue.setEnabled(self.checkBox_listen_external.isChecked())
        elif fields=='templates':
            self.lineEdit_templates.setEnabled(self.checkBox_use_local_templates.isChecked())
            self.toolButton_templates.setEnabled(self.checkBox_use_local_templates.isChecked())
            self.label_templates.setEnabled(self.checkBox_use_local_templates.isChecked())
        elif fields=='templates-shared':
            self.lineEdit_templates_shared.setEnabled(self.checkBox_use_local_templates.isChecked())
            self.toolButton_templates_2.setEnabled(self.checkBox_use_local_templates.isChecked())
            self.label_templates_shared.setEnabled(self.checkBox_use_local_templates.isChecked())
        elif fields=='proxy':
            self.lineEdit_host.setEnabled(self.checkBox_use_proxy.isChecked())
            self.lineEdit_port.setEnabled(self.checkBox_use_proxy.isChecked())
            self.comboBox_protocol.setEnabled(self.checkBox_use_proxy.isChecked())
            if not self.checkBox_use_proxy.isChecked():
                self.comboBox_protocol.setStyleSheet("background-color: white; border-style: solid; border-width: 1px; border-color: lightgrey")
            else:
                self.comboBox_protocol.setStyleSheet("background-color: white; border-style: solid; border-width: 1px; border-color: grey")
            self.lineEdit_username.setEnabled(self.checkBox_use_proxy.isChecked())
            self.lineEdit_password.setEnabled(self.checkBox_use_proxy.isChecked())
            self.label_host.setEnabled(self.checkBox_use_proxy.isChecked())
            self.label_port.setEnabled(self.checkBox_use_proxy.isChecked())
            self.label_protocol.setEnabled(self.checkBox_use_proxy.isChecked())
            self.label_username.setEnabled(self.checkBox_use_proxy.isChecked())
            self.label_password.setEnabled(self.checkBox_use_proxy.isChecked())
        elif fields=='command':
            self.checkBox_nl.setChecked('nl' in self.enabled_commands)
            self.checkBox_np.setChecked('np' in self.enabled_commands)
            self.checkBox_bold.setChecked('b' in self.enabled_commands)
            self.checkBox_italic.setChecked('i' in self.enabled_commands)
            self.checkBox_underline.setChecked('u' in self.enabled_commands)
            self.checkBox_align_center.setChecked('alignc' in self.enabled_commands)
            self.checkBox_align_left.setChecked('alignl' in self.enabled_commands)
            self.checkBox_align_right.setChecked('alignr' in self.enabled_commands)
            self.checkBox_uppercase.setChecked('uc' in self.enabled_commands)
            self.checkBox_lowercase.setChecked('lc' in self.enabled_commands)
            self.checkBox_start_with_upper.setChecked('UC' in self.enabled_commands)
            self.checkBox_start_with_lower.setChecked('LC' in self.enabled_commands)
            self.checkBox_del_all.setChecked('delall' in self.enabled_commands)
            self.checkBox_del_last.setChecked('delw' in self.enabled_commands)
            self.checkBox_del_last_n.setChecked('delw' in self.enabled_commands)
            self.checkBox_dels.setChecked('dels' in self.enabled_commands)
            self.checkBox_select_all.setChecked('selectall' in self.enabled_commands)
            self.checkBox_copy.setChecked('copy' in self.enabled_commands)
            self.checkBox_paste.setChecked('paste' in self.enabled_commands)
            self.checkBox_end_dictation.setChecked('end' in self.enabled_commands)
            self.checkBox_pause.setChecked('pause' in self.enabled_commands)
            self.checkBox_space.setChecked('spc' in self.enabled_commands)
            self.checkBox_nospace.setChecked('nospace' in self.enabled_commands)
            self.checkBox_comments.setChecked('comment' in self.enabled_commands)
            self.checkBox_last_text.setChecked('textback' in self.enabled_commands)
            self.checkBox_next.setChecked('next' in self.enabled_commands)
            self.checkBox_prev.setChecked('prev' in self.enabled_commands)
            self.checkBox_insert.setChecked('ins' in self.enabled_commands)
        elif fields=='start-in-buffering-mode':
            self.checkBox_startInBufferingMode.setDisabled(self.checkBox_dontShowTranscriptWin.isChecked())
            
    def close_window(self):
        #if self.settings_changed:
        if self.settings != self.settings_orig:
            if show_message_box(
                message='Nastavitve so bile spremenjene. Če jih ne shranite, se bodo ob naslednjem zagonu aplikacije naložile stare nastavitve!',
                box_title='Neshranjene spremembe',
                button_yes_text='Shrani in zapri',
                button_no_text='Zapri',
                box_type='Question',
                num_of_buttons=2
                ) == 1:
                if save_config(self.settings):
                    self.settings_orig = copy.deepcopy(self.settings)
                else:
                    show_message_box(
                        message='Nastavitve niso bile shranjene! Obrnite se na skrbnika aplikacije!',
                        box_title='Napaka',
                        button_yes_text='Zapri',
                        box_type='Critical',
                        num_of_buttons=1
                        )

        if self.replacements_changed():
            if show_message_box(
                message='Zamenjave so bile spremenjene. Jih želite shraniti?',
                box_title='Neshranjene zamenjave',
                button_yes_text='Shrani in zapri',
                button_no_text='Zapri',
                box_type='Question',
                num_of_buttons=2,
                ) == 1:
                res = self.update_user_replacements_on_backend()
                if res['post_error'] + res['del_error'] > 0:
                    show_message_box(
                        message='Pri shranjevanju zamenjav so se zgodile napake! Nekatere zamenjave niso bilo shranjene oz. brisane! Obrnite se na skrbnika aplikacije.',
                        box_title='Napaka',
                        button_yes_text='Zapri',
                        box_type='Critical',
                        num_of_buttons=1
                        )
        
        self.gui_object.close()

    def open_file_dialog(self, shared=False):
        if shared:
            folder_path = QFileDialog.getExistingDirectory(self, "Izberi mapo s skupnimi predlogami")
            if folder_path and folder_path.strip() != self.lineEdit_templates_shared.text().strip():
                logger.debug(f"New folder selected for shared templates: {folder_path}")
                self.lineEdit_templates_shared.setText(folder_path)
                self.settings['general']['templates-folder-shared']=folder_path
                logger.debug(f"Value of the setting 'templates-folder-shared' changed to {self.lineEdit_templates_shared.text()}")        
                self.settings_changed = True
        else:
            folder_path = QFileDialog.getExistingDirectory(self, "Izberi mapo s predlogami")
            if folder_path and folder_path.strip() != self.lineEdit_templates.text().strip():
                logger.debug(f"New folder selected for templates: {folder_path}")
                self.lineEdit_templates.setText(folder_path)
                self.settings['general']['templates-folder']=folder_path
                logger.debug(f"Value of the setting 'templates-folder' changed to {self.lineEdit_templates.text()}")        
                self.settings_changed = True
    
    def save_changes(self, fields):
        """
        Whenever a checkBox or comboBox is changed, this will fire and changes will be saved to self.settings variable
        Notice that changes to content of lineEdit components are handled with the 'on_focusChanged' handler
        """
        def set_command_value(cmd, value):
            if 'user-defined-commands' not in self.settings or 'enabled-commands' not in self.settings['user-defined-commands']:
                logger.warning(f"The key 'user-defined-settings' or its subkey 'enabled-commands' missing in the user settings!")
                return
            for item in self.settings['user-defined-commands']['enabled-commands']:
                if cmd in item:
                    item[cmd] = value
                    break

        self.label_result_status.clear()
        # post-processing
        if fields=='numbers' and self.checkBox_numbers.isChecked() != get_settings_value(self.settings, ['general', 'do-postprocessing', 'numbers']):
            self.settings['general']['do-postprocessing']['numbers']=self.checkBox_numbers.isChecked()
            logger.debug(f"Value of the setting 'numbers' changed to {self.checkBox_numbers.isChecked()}")
        elif fields=='spp' and self.checkBox_spp.isChecked() != get_settings_value(self.settings, ['general', 'do-postprocessing', 'spp-codes']):
            self.settings['general']['do-postprocessing']['spp-codes']=self.checkBox_spp.isChecked()
            logger.debug(f"Value of the setting 'spp' changed to {self.checkBox_spp.isChecked()}")
        elif fields=='capitalization' and self.checkBox_capitalization.isChecked() != get_settings_value(self.settings, ['general', 'do-postprocessing', 'capitalize-sentences']):
            self.settings['general']['do-postprocessing']['capitalize-sentences']=self.checkBox_capitalization.isChecked()
            logger.debug(f"Value of the setting 'capitalization' changed to {self.checkBox_capitalization.isChecked()}")
        elif fields=='beep' and self.checkBox_beep_on_final.isChecked() != get_settings_value(self.settings, ['general', 'beep-on-finals']):
            self.settings['general']['beep-on-finals']=self.checkBox_beep_on_final.isChecked()
            logger.debug(f"Value of the setting 'beep-on-finals' changed to {self.checkBox_beep_on_final.isChecked()}")
        elif fields=='spaceAfterPause' and self.checkBox_space_after_pause.isChecked() != get_settings_value(self.settings, ['general', 'continue-pause-with-space']):
            self.settings['general']['continue-pause-with-space']=self.checkBox_space_after_pause.isChecked()
            logger.debug(f"Value of the setting 'continue-pause-with-space' changed to {self.checkBox_space_after_pause.isChecked()}")
        elif fields=='dotFloatingPoint' and self.checkBox_dot_floating_point.isChecked() != get_settings_value(self.settings, ['general', 'use-dot-floating-point']):
            self.settings['general']['use-dot-floating-point']=self.checkBox_dot_floating_point.isChecked()
            logger.debug(f"Value of the setting 'use-dot-floating-point' changed to {self.checkBox_dot_floating_point.isChecked()}")
        # notes
        elif fields=='notes' and self.checkBox_format_notes.isChecked() != get_settings_value(self.settings, ['general', 'do-postprocessing', 'format-notes']):
            self.settings['general']['do-postprocessing']['format-notes']=self.checkBox_format_notes.isChecked()
            logger.debug(f"Value of the setting 'format-notes' changed to {self.checkBox_format_notes.isChecked()}")
        # PID dialog box
        elif fields=='pid' and self.checkBox_show_PID.isChecked() != get_settings_value(self.settings, ['general', 'show-dialog-PID']):
            self.settings['general']['show-dialog-PID']=self.checkBox_show_PID.isChecked()
            logger.debug(f"Value of the setting 'show-dialog-PID' changed to {self.checkBox_show_PID.isChecked()}")
        # proxy
        elif fields=='use-proxy' and self.checkBox_use_proxy.isChecked() != get_settings_value(self.settings, ['proxy-server', 'use-proxy-server']):
            self.settings['proxy-server']['use-proxy-server']=self.checkBox_use_proxy.isChecked()
            logger.debug(f"Value of the setting 'use-proxy-server' changed to {self.checkBox_use_proxy.isChecked()}")
        elif fields=='proxy-protocol':
            if self.comboBox_protocol.currentText() not in ('http', 'socks4', 'socks4a', 'socks5', 'socks5h'):
                self.settings['proxy-server']['proxy-type']=None
            else:
                self.settings['proxy-server']['proxy-type']=self.comboBox_protocol.currentText()
            logger.debug(f"Value of the setting 'proxy-type' changed to {self.comboBox_protocol.currentText()}")
        # autofocus
        elif fields=="key" and self.checkBox_focus_by_key.isChecked() != get_settings_value(self.settings, ['general', 'autofocus', 'autofocus-with-key']):
            self.settings['general']['autofocus']['autofocus-with-key']=self.checkBox_focus_by_key.isChecked()
            logger.debug(f"Value of the setting 'autofocus-with-key' changed to {self.checkBox_focus_by_key.isChecked()}")
        elif fields=="title" and self.checkBox_focus_by_title.isChecked() != get_settings_value(self.settings, ['general', 'autofocus', 'autofocus-by-window-title']):
            self.settings['general']['autofocus']['autofocus-by-window-title']=self.checkBox_focus_by_title.isChecked()
            logger.debug(f"Value of the setting 'autofocus-by-window-title' changed to {self.checkBox_focus_by_title.isChecked()}")
        # listener
        elif fields=="listener" and self.checkBox_listen_external.isChecked() != get_settings_value(self.settings, ['integration', 'listen-for-external-commands']):
            self.settings['integration']['listen-for-external-commands']=self.checkBox_listen_external.isChecked()
            logger.debug(f"Value of the setting 'listen-for-external-commands' changed to {self.checkBox_listen_external.isChecked()}")
        elif fields=="purge-queue" and self.checkBox_purge_queue.isChecked() != get_settings_value(self.settings, ['integration', 'purge-queue-on-start']):
            self.settings['integration']['purge-queue-on-start']=self.checkBox_purge_queue.isChecked()
            logger.debug(f"Value of the setting 'purge-queue-on-start' changed to {self.checkBox_purge_queue.isChecked()}")
        # templates
        elif fields=="use-local-templates" and self.checkBox_use_local_templates.isChecked() != get_settings_value(self.settings, ['general', 'use-local-templates']):
            self.settings['general']['use-local-templates']=self.checkBox_use_local_templates.isChecked()
            logger.debug(f"Value of the setting 'use-local-templates' changed to {self.checkBox_use_local_templates.isChecked()}")
        # minimize to systray
        elif fields=='systray' and self.checkBox_minimize.isChecked() != get_settings_value(self.settings, ['general', 'system-tray', 'minimize-after-login']):
            self.settings['general']['system-tray']['minimize-after-login']=self.checkBox_minimize.isChecked()
            logger.debug(f"Value of the setting 'minimize-after-login' changed to {self.checkBox_minimize.isChecked()}")
        # start in buffering mode
        elif fields=='start-in-buffering-mode' and self.checkBox_startInBufferingMode.isChecked() != get_settings_value(self.settings, ['general', 'start-in-buffering-mode']):
            self.settings['general']['start-in-buffering-mode']=self.checkBox_startInBufferingMode.isChecked()
            logger.debug(f"Value of the setting 'start-in-buffering-mode' changed to {self.checkBox_startInBufferingMode.isChecked()}")    
        # don't show transcript window
        elif fields=='dont-show-transcript-win' and self.checkBox_dontShowTranscriptWin.isChecked() != get_settings_value(self.settings, ['general', 'dont-show-transcript-win']):
            self.settings['general']['dont-show-transcript-win']=self.checkBox_dontShowTranscriptWin.isChecked()
            logger.debug(f"Value of the setting 'dont-show-transcript-win' changed to {self.checkBox_dontShowTranscriptWin.isChecked()}")
            # if this option is set to True, the startInBufferingMode option should be disabled
            self.checkBox_startInBufferingMode.setDisabled(self.checkBox_dontShowTranscriptWin.isChecked())
        # dictaphone toggle key
        elif fields=='dictaphone' and self.checkBox_dictaphone_toggle.isChecked() != get_settings_value(self.settings, ['dictaphone-key-bindings', 'enable-hotkey-listener']):
            self.settings['dictaphone-key-bindings']['enable-hotkey-listener']=self.checkBox_dictaphone_toggle.isChecked()
            logger.debug(f"Value of the setting 'enable-hotkey-listener' for dictaphone changed to {self.checkBox_dictaphone_toggle.isChecked()}")
        # commands
        elif fields=='nl':
            set_command_value('nl', self.checkBox_nl.isChecked())
            logger.debug(f"Value of the setting 'enable command <nl>' changed to {self.checkBox_nl.isChecked()}")
        elif fields=='np':
            set_command_value('np', self.checkBox_np.isChecked())
            logger.debug(f"Value of the setting 'enable command <np>' changed to {self.checkBox_np.isChecked()}")
        elif fields=='b':
            set_command_value('b', self.checkBox_bold.isChecked())
            logger.debug(f"Value of the setting 'enable command <b>' changed to {self.checkBox_bold.isChecked()}")
        elif fields=='i':
            set_command_value('i', self.checkBox_italic.isChecked())
            logger.debug(f"Value of the setting 'enable command <i>' changed to {self.checkBox_italic.isChecked()}")
        elif fields=='u':
            set_command_value('u', self.checkBox_underline.isChecked())
            logger.debug(f"Value of the setting 'enable command <u>' changed to {self.checkBox_underline.isChecked()}")
        elif fields=='alignc':
            set_command_value('alignc', self.checkBox_align_center.isChecked())
            logger.debug(f"Value of the setting 'enable command <alignc>' changed to {self.checkBox_align_center.isChecked()}")
        elif fields=='alignl':
            set_command_value('alignl', self.checkBox_align_left.isChecked())
            logger.debug(f"Value of the setting 'enable command <alignl>' changed to {self.checkBox_align_left.isChecked()}")
        elif fields=='alignr':
            set_command_value('alignr', self.checkBox_align_right.isChecked())
            logger.debug(f"Value of the setting 'enable command <alignr>' changed to {self.checkBox_align_right.isChecked()}")
        elif fields=='uc':
            set_command_value('uc', self.checkBox_uppercase.isChecked())
            logger.debug(f"Value of the setting 'enable command <uc>' changed to {self.checkBox_uppercase.isChecked()}")
        elif fields=='lc':
            set_command_value('lc', self.checkBox_lowercase.isChecked())
            logger.debug(f"Value of the setting 'enable command <lc>' changed to {self.checkBox_lowercase.isChecked()}")
        elif fields=='UC':
            set_command_value('UC', self.checkBox_start_with_upper.isChecked())
            logger.debug(f"Value of the setting 'enable command <UC>' changed to {self.checkBox_start_with_upper.isChecked()}")
        elif fields=='LC':
            set_command_value('LC', self.checkBox_start_with_lower.isChecked())
            logger.debug(f"Value of the setting 'enable command <LC>' changed to {self.checkBox_start_with_lower.isChecked()}")
        elif fields=='delall':
            set_command_value('delall', self.checkBox_del_all.isChecked())
            logger.debug(f"Value of the setting 'enable command <delall>' changed to {self.checkBox_del_all.isChecked()}")
        elif fields=='delw':
            set_command_value('delw', self.checkBox_del_last.isChecked())
            logger.debug(f"Value of the setting 'enable command <delw>' changed to {self.checkBox_del_last.isChecked()}")
        elif fields=='deln':
            set_command_value('deln', self.checkBox_del_last_n.isChecked())
            logger.debug(f"Value of the setting 'enable command <deln>' changed to {self.checkBox_del_last_n.isChecked()}")
        elif fields=='dels':
            set_command_value('dels', self.checkBox_dels.isChecked())
            logger.debug(f"Value of the setting 'enable command <dels>' changed to {self.checkBox_dels.isChecked()}")
        elif fields=='selectall':
            set_command_value('selectall', self.checkBox_select_all.isChecked())
            logger.debug(f"Value of the setting 'enable command <selectall>' changed to {self.checkBox_select_all.isChecked()}")
        elif fields=='copy':
            set_command_value('copy', self.checkBox_copy.isChecked())
            logger.debug(f"Value of the setting 'enable command <copy>' changed to {self.checkBox_copy.isChecked()}")
        elif fields=='paste':
            set_command_value('paste', self.checkBox_paste.isChecked())
            logger.debug(f"Value of the setting 'enable command <paste>' changed to {self.checkBox_paste.isChecked()}")
        elif fields=='end':
            set_command_value('end', self.checkBox_end_dictation.isChecked())
            logger.debug(f"Value of the setting 'enable command <end>' changed to {self.checkBox_end_dictation.isChecked()}")
        elif fields=='pause':
            set_command_value('pause', self.checkBox_pause.isChecked())
            logger.debug(f"Value of the setting 'enable command <pause>' changed to {self.checkBox_pause.isChecked()}")
        elif fields=='spc':
            set_command_value('spc', self.checkBox_space.isChecked())
            logger.debug(f"Value of the setting 'enable command <spc>' changed to {self.checkBox_space.isChecked()}")
        elif fields=='nospace':
            set_command_value('nospace', self.checkBox_pause.isChecked())
            logger.debug(f"Value of the setting 'enable command <nospace>' changed to {self.checkBox_nospace.isChecked()}")
        elif fields=='comment':
            set_command_value('comment', self.checkBox_comments.isChecked())
            logger.debug(f"Value of the setting 'enable command <comment>' changed to {self.checkBox_comments.isChecked()}")
        elif fields=='textback':
            set_command_value('textback', self.checkBox_last_text.isChecked())
            logger.debug(f"Value of the setting 'enable command <textback>' changed to {self.checkBox_last_text.isChecked()}")
        elif fields=='next':
            set_command_value('next', self.checkBox_next.isChecked())
            logger.debug(f"Value of the setting 'enable command <next>' changed to {self.checkBox_next.isChecked()}")
        elif fields=='prev':
            set_command_value('prev', self.checkBox_prev.isChecked())
            logger.debug(f"Value of the setting 'enable command <prev>' changed to {self.checkBox_prev.isChecked()}")
        elif fields=='ins':
            set_command_value('ins', self.checkBox_insert.isChecked())
            logger.debug(f"Value of the setting 'enable command <ins>' changed to {self.checkBox_insert.isChecked()}")
       
        # check if settings have changed
        if self.settings != self.settings_orig:
            self.settings_changed = True
        else:
            self.settings_changed = False

    def save_settings(self):
        # if tab 'Zamenjave' is selected, post replacements to BE
        if self.tabWidget.currentIndex()==2:
            logger.debug(f"Pushing changes of replacements to backend...")
            res = self.update_user_replacements_on_backend()
            if res['post_error'] + res['del_error'] > 0:
                self.label_result_status.setStyleSheet(f"color: {cl_message_failed}")
                self.label_result_status.setText(f"Pri shranjevanju zamenjav so se zgodile napake! Nekatere zamenjave niso bilo shranjene oz. brisane! Obrnite se na skrbnika aplikacije.")
            else:
                self.label_result_status.setStyleSheet(f"color: {cl_message_success}")
                self.label_result_status.setText(f"Zamenjave uspešno shranjene.")
            # refresh variables and return
            self.reload_replacements()
            return
        # if tab 'Osnovno' or 'Ukazi' selected, save settings to config
        if self.tabWidget.currentIndex() in (0, 1):
            logger.debug(f"Exporting self.settings to settings.yaml...")
            res = save_config(self.settings)
            if res:
                self.label_result_status.setStyleSheet("color: green")
                self.label_result_status.setText("Nastavitve uspešno shranjene.")
                self.settings_orig = self.settings
                self.settings_changed = False
            else:
                self.label_result_status.setStyleSheet(f"color: {cl_message_failed}")
                self.label_result_status.setText("Nastavitve niso bile shranjene! Obrnite se na skrbnika aplikacije.")

    def reload_replacements(self):
        # replacements retrieved from the backend
        self.user_replacements_from_backend = self.extract_replacements(self.stt.get_user_replacements())
        # replacements currently holded in memory - all, not just filtered
        self.current_list_of_replacements = copy.deepcopy(self.user_replacements_from_backend)
        # indexes of replacements from the memory that are in current filter
        self.label_replacement_result.clear()
        self.current_indexes = [i for i in range(0, len(self.current_list_of_replacements))]
        self.listWidget_basic_repl.clear()
        self.listWidget_basic_repl.addItems(self.current_list_of_replacements)
        # clear filter
        self.lineEdit_filter.clear()
        # position cursor on the first replacement
        if len(self.current_list_of_replacements) > 0: 
            self.listWidget_basic_repl.setCurrentRow(0)
            self.lineEdit_basic_repl.setText(self.listWidget_basic_repl.currentItem().text())

    def __valid_replacement(self, action='add'):
        # ignore replacements that already are on the list
        if action=='add':
            current_list = self.current_list_of_replacements
        elif action=='update':
            current_list = [el for el in self.current_list_of_replacements if el != self.listWidget_basic_repl.currentItem().text()]
        else:
            logger.error(f"Unknown action '{action}' in __valid_replacement() function!")
            return False

        if self.lineEdit_basic_repl.text() in current_list:
            self.label_replacement_result.setText("Ta zamenjava že obstaja.")
            self.label_replacement_result.setStyleSheet(f"color: {cl_message_failed}")
            return False
        # or source already have target
        elif self.lineEdit_basic_repl.text().split(": ")[0] in [r.split(": ")[0] for r in current_list]:
            self.label_replacement_result.setText("Ista beseda/fraza ima lahko samo eno zamenjavo.")
            self.label_replacement_result.setStyleSheet(f"color: {cl_message_failed}")
            return False
        self.label_replacement_result.clear()
        return True

    def add_replacement_to_list(self):
        if self.lineEdit_basic_repl.text() != '' and self.__valid_replacement(action='add'):
            # add item to the widget
            self.listWidget_basic_repl.addItem(self.lineEdit_basic_repl.text())
            # append item to the list variable
            self.current_list_of_replacements.append(self.lineEdit_basic_repl.text())
            # reload indexes
            self.current_indexes = [i for i in range(0, len(self.current_list_of_replacements))]
            print("index after add op:", self.current_indexes)
            # reset message label
            self.label_replacement_result.clear()

    def extract_replacements(self, replacement_response):
        """
        Creates list of replacements in the format: 'source: target'
        At the same time, class property self.backend_replacements_dict if populated
        """
        self.backend_replacements_dict = dict()
        repl_list = []
        for el in replacement_response:
            target = el['target']['text']
            item = f"{' '.join(s['text'] for s in el['source'])}: {target}"
            repl_list.append(item)
            self.backend_replacements_dict[item]=el['id']
        return repl_list

    def update_replacement_on_list(self):
        if not self.listWidget_basic_repl.currentItem():
            self.label_replacement_result.setText("Nobena zamenjava ni izbrana - kliknite na zamenjavo, ki jo želite spremeniti!")
            self.label_replacement_result.setStyleSheet(f"color: {cl_message_failed}") 
        elif self.__valid_replacement(action='update'):
            self.listWidget_basic_repl.currentItem().setText(self.lineEdit_basic_repl.text())
            self.current_list_of_replacements[self.current_indexes[self.listWidget_basic_repl.currentRow()]]=self.lineEdit_basic_repl.text()
            self.label_replacement_result.clear()

    def delete_replacement_from_list(self):
        # delete item from the list variable
        if self.listWidget_basic_repl.currentRow() != -1:
            del self.current_list_of_replacements[self.listWidget_basic_repl.currentRow()]
            # remove item from the widget
            self.listWidget_basic_repl.takeItem(self.listWidget_basic_repl.currentRow())
            # reload indexes
            self.current_indexes = [i for i in range(0, len(self.current_list_of_replacements))]
            # reset message label
            self.label_replacement_result.clear()
        else:
            self.label_replacement_result.setText("Nobena zamenjava ni izbrana - kliknite na zamenjavo, ki jo želite brisati!")
            self.label_replacement_result.setStyleSheet(f"color: {cl_message_failed}")

    def populate_list_of_replacements(self):
        if self.listWidget_basic_repl.currentItem():
            self.lineEdit_basic_repl.setText(self.listWidget_basic_repl.currentItem().text())

    def filter_replacements(self, text):
        self.listWidget_basic_repl.clear()
        self.current_indexes = []
        for c, el in enumerate(self.current_list_of_replacements):
            if text in el: 
                QListWidgetItem(el, self.listWidget_basic_repl)
                self.current_indexes.append(c)

    def update_user_replacements_on_backend(self):
        """
        Compare user replacements on the backend with current replacements
        and make necessary changes at the backend. 
        """
        def reformat_replications(d):
            """
            This will put replications into format as required by the POST endpoint
            {"id":4,"source":[{"spaceBefore":true,"text":"sončen"}],"target":{"spaceBefore":true,"text":"sočen"}},
            """
            d = dict()
            for r in repl_to_add:
                source = r.split(": ")[0]
                target = r.split(": ")[1]
                d[target] = [dict(text=s, spaceBefore=True) for s in source.split(' ')]
            return d

        # use DELETE to remove replications that were deleted
        repl_to_del = [r for r in self.user_replacements_from_backend if r not in self.current_list_of_replacements]

        del_error = 0
        del_success = 0

        for r in repl_to_del:
            if r not in self.backend_replacements_dict:
                logger.error(f'Replacement {r} cannot be deleted since it was not found among items imported from the backend!')
                continue
            else: 
                if not self.stt.delete_user_replacement(self.backend_replacements_dict[r]):
                    del_error += 1
                else:
                    del_success += 1

        res = dict(del_success=del_success, del_error=del_error)

        # use POST to sync replacements that were changed or added
        repl_to_add = [r for r in self.current_list_of_replacements if r not in self.user_replacements_from_backend]
        repl_dict = reformat_replications(repl_to_add)

        post_error = 0
        post_success = 0

        for el in repl_dict.keys():
            json_data = dict(source=repl_dict[el], target=dict(text=el, spaceBefore=True))
            if not self.stt.post_user_replacement(json_data):
                post_error += 1
                #print(json_data)
            else:
                post_success += 1
        
        res.update(post_success=post_success, post_error=post_error)
        
        return res

    def replacements_changed(self):
        repl_to_del = [r for r in self.user_replacements_from_backend if r not in self.current_list_of_replacements]
        repl_to_add = [r for r in self.current_list_of_replacements if r not in self.user_replacements_from_backend]
        if len(repl_to_add) + len(repl_to_del) > 0:
            return True
        else:
            return False

    def textEditTest(self):
        self.textEdit.setText("To je <b>tekst</b>")

    def enable_commands_switch(self, action):
        """
        All checkboxes in the COMMANDS tab of the detailed settings are set to TRUE or FALSE
        """
        for cb in (self.checkBox_nl, self.checkBox_np, self.checkBox_bold, self.checkBox_italic, self.checkBox_underline,
                    self.checkBox_align_center, self.checkBox_align_left, self.checkBox_align_right, self.checkBox_uppercase,
                    self.checkBox_lowercase, self.checkBox_start_with_upper, self.checkBox_start_with_lower, self.checkBox_del_all,
                    self.checkBox_del_last, self.checkBox_del_last_n, self.checkBox_dels, self.checkBox_select_all, self.checkBox_space, self.checkBox_nospace,
                    self.checkBox_comments, self.checkBox_last_text, self.checkBox_next, self.checkBox_prev, self.checkBox_insert):
            cb.setChecked(action)

class Error_Stack(QtWidgets.QDialog, Ui_Dialog_Error):
    def __init__(self, gui_object, truebar_object, alarm_icon, error_text, host, user):
        super().__init__()
        # render gui
        self.setupUi(gui_object)
        self.gui_object = gui_object
        self.alarm_icon = alarm_icon
        self.error_text = error_text
        self.host = host
        self.user = user
        self.ip = truebar_object.get_ip()
        self.app_version = app_version
        # make window fixed size
        gui_object.setFixedSize(int(371*scalingFactor), int(202*scalingFactor))
        # make window stay on top
        self.setWindowFlags(
            self.windowFlags() |  
            QtCore.Qt.WindowStaysOnTopHint
        )
        # connect buttons
        self.pushButton_send.clicked.connect(lambda: self.send_mail())
        self.pushButton_close.clicked.connect(lambda: self.gui_object.close())
        self.pushButton_clear.clicked.connect(lambda: self.reset_window())

        self.stt = truebar_object
        if len(self.stt.connection_errors)>0:    
            self.lineEdit_ts.setText(format_datetime(self.stt.connection_errors[-1].get("error_ts", "")))
            self.lineEdit_code.setText(str(self.stt.connection_errors[-1].get("error_code", "")))
            self.lineEdit_error_type.setText(self.stt.connection_errors[-1].get("error_type", ""))
            self.lineEdit_message_id.setText(self.stt.connection_errors[-1].get("error_id", ""))
            self.lineEdit_message.setText(self.stt.connection_errors[-1].get("error_message", ""))
            self.errdata = dict(
                error_id=self.lineEdit_message_id.text(),
                error_ts=self.lineEdit_ts.text(),
                error_code=self.lineEdit_code.text(),
                error_type=self.lineEdit_error_type.text(),
                error_message=self.lineEdit_message.text(),
                exception=self.stt.connection_errors[-1].get("exception", "")
            )
            self.metadata = dict(
                host=self.host,
                app="TB-listener",
                app_version=self.app_version,
                user_ip=self.ip,
                username=self.user,
                ts=time.strftime('%H:%M:%S', time.gmtime(time.time())),
            )

    def reset_window(self):
        for f in [self.lineEdit_code, self.lineEdit_error_type, self.lineEdit_message, self.lineEdit_message_id, self.lineEdit_ts]:
            f.clear()
        self.gui_object.close()
        self.alarm_icon.setVisible(False)
        self.error_text.setText("")
    
    def send_mail(self):
        
        self.gui_object.setCursor(Qt.WaitCursor)

        html_content=f'<p>T E S T N O  sporočilo o napaki!</p><br>'
        
        for el in self.metadata.keys():
            html_content += f'<p>{el}: <b>{self.metadata[el]}</b></p>'

        html_content += '<hr>'    

        for el in self.errdata.keys():
            html_content += f'<p>{el}: <b>{self.errdata[el]}</b></p>'

        soup = BeautifulSoup(html_content, 'html.parser')
        plain_text_content = soup.get_text()

        message = Mail(
            from_email='podpora@vitasis.si',
            to_emails='marko.bajec@vitasis.si',
            subject='Truebar: sporočilo o napaki',
            plain_text_content=PlainTextContent(plain_text_content),
            html_content=HtmlContent(html_content)
        )

        # Attach files
        if self.checkBox_logs.isChecked():

            file_paths = [os.path.join(user_appdata, f) for f in ('info.log', 'debug.log', 'error.log', 'settings.yaml')]
            for file_path in file_paths:
                if os.path.isfile(file_path):
                    with open(file_path, 'rb') as file:
                        file_content = file.read()
                        file_data = base64.b64encode(file_content).decode()
                        attachment = Attachment(
                            FileContent(file_data),
                            FileName(os.path.basename(file_path)),
                            FileType('application/txt'),
                            Disposition('attachment')
                        )
                        message.add_attachment(attachment)
                else:
                    logger.warning(f"FIle {file_path} could not be found and will not be attached to the outgoing email.")

        try:
            sg = SendGridAPIClient('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')
            #sg = SendGridAPIClient(os.environ.get('SENDGRID_API_KEY'))
            response = sg.send(message)
            logger.debug(f"EMAIL SERVICE RESPONSE STATUS CODE: {response.status_code}")
            #logger.debug(response.body)
            #logger.debug(response.headers)
        except Exception as e:
            logger.error(e)
        finally:
            self.gui_object.close()

class TranWin(QMainWindow, Ui_TranscriptWindow):
    def __init__(self, gui_object):
        super().__init__()
        # render gui
        self.setupUi(gui_object)
        self.gui_object = gui_object
        self.input_field_symbol = "_"
        self.current_highlight_position = None
        # create syntax highlighter object
        self.highlighter = MedSyntaxHighlighter(self.textEdit.document())
        self.highlighter.is_highlighting_enabled = True
        # status bar
        font = QtGui.QFont()
        font.setPointSize(8)
        self.statusbar.setFont(font)
        self.textEdit.cursorPositionChanged.connect(self.update_cursor_pos_status)
        
    def update_cursor_pos_status(self):
        current_text = self.textEdit.toPlainText()
        cursor = self.textEdit.textCursor()
        currentPosition = cursor.position()
        #self.statusBar().showMessage(f"Cursor position: {currentPosition}")
        left_context = current_text[:currentPosition].split(" ")[-1] if currentPosition > 0 else ""
        right_context = current_text[currentPosition:].split(" ")[0] if len(current_text)>currentPosition else ""
        self.statusbar.showMessage(f"Cursor position: {currentPosition} | context left: {left_context} | context right: {right_context}")

    def highlight_field(self):
        # Get the current cursor position
        cursor_position = self.textEdit.textCursor().position()

        # Reset the background color of the previous letter
        self.clear_previous_highlight()

        # Highlight the letter at the current cursor position
        self.set_highlight(cursor_position)

        # Update the current_highlight_position
        self.current_highlight_position = cursor_position

    def clear_previous_highlight(self):
        # Clear the background color of the previous letter
        if self.current_highlight_position is not None:
            format_clear = QTextCharFormat()
            format_clear.setBackground(Qt.white)
            cursor = self.textEdit.textCursor()
            cursor.setPosition(self.current_highlight_position)
            cursor.movePosition(QTextCursor.Right, QTextCursor.KeepAnchor)
            cursor.mergeCharFormat(format_clear)

    def remove_background_color(self):
        # Create a QTextCursor and set the default background color
        cursor = QTextCursor(self.textEdit.document())
        format_clear = QTextCharFormat()
        format_clear.setBackground(Qt.white)
        cursor.select(QTextCursor.Document)
        cursor.mergeCharFormat(format_clear)
        self.textEdit.setTextCursor(cursor)

    def set_highlight(self, position):
        # Highlight the letter at the given position with a background color
        format_highlight = QTextCharFormat()
        format_highlight.setBackground(Qt.yellow)
        cursor = self.textEdit.textCursor()
        cursor.setPosition(position)
        cursor.movePosition(QTextCursor.Right, QTextCursor.KeepAnchor)
        cursor.mergeCharFormat(format_highlight)

    def move_cursor_left(self):
        # Move the cursor left programmatically
        self.textEdit.moveCursor(QTextCursor.Left)

    def move_cursor_right(self):
        # Move the cursor right programmatically
        self.textEdit.moveCursor(QTextCursor.Right)

    def move_to_next_input(self):
        cursor = self.textEdit.textCursor()
        cursor_position = cursor.position()
        plain_text = self.textEdit.toPlainText()
        next_field_pos = plain_text[cursor_position+1:].find(self.input_field_symbol)
        if next_field_pos != -1:
            next_field_pos += cursor_position + 1
            # move cursor
            cursor.setPosition(next_field_pos)
            self.textEdit.setTextCursor(cursor)
            # highlight field
            #self.highlight_field()

    def move_to_prev_input(self):
        cursor = self.textEdit.textCursor()
        cursor_position = cursor.position()
        plain_text = self.textEdit.toPlainText()
        prev_field_pos = plain_text[:cursor_position-1].rfind(self.input_field_symbol)
        if prev_field_pos != -1:
            # move cursor
            cursor.setPosition(prev_field_pos)
            self.textEdit.setTextCursor(cursor)
            # highlight field
            #self.highlight_field()

class PlayerWindow(TranscriptEditor):
    def __init__(
            self,
            app_object,
            leap_back=2,
            play_speed=1,
        ):
        """
        This class inherits from the wordprocessor module that has the class TranscriptEditor. It adds
        GUI elements for media player and all required methods to play audio and show transcript in sync.
        This is also the place to introduce additional changes to functionality of the TranscriptEditor class 
        should they ever be required.
        Args:
        - app_object: application object, created in the main module, needed for the Player Window to process messages and events
        - leap_back: amount of time to repeat when starting player after pause. Default is 2 seconds
        - play_speed: the speed of the player. Default is 1 - regular speed. 
        """
        super().__init__()

        self.app = app_object

        # set default values
        self.leap_back = leap_back
        self.play_speed = play_speed
        
        # This varible will hold an instance of the TranscriptAligner class from the truebar module (required for audio-transcript sync).
        self.transcript_aligner = None

        # set fixed size for the player window
        # TODO: size and pos should be read from the registry
        #self.setFixedSize(int(800*scalingFactor), int(600*scalingFactor))
        self.resize(int(800*scalingFactor), int(600*scalingFactor))
        self.setMinimumSize(int(400*scalingFactor), int(300*scalingFactor))  # Minimum size (width, height)
        self.setMaximumSize(int(1200*scalingFactor), int(800*scalingFactor))  # Maximum size (width, height)

        # create media player toolbar at the editor bottom
        self._create_mediaplayer_toolbar()

        # hide status bar
        self.status.setVisible(False)

        # an attribute that wil hold an instance of the transcription aligner
        self.transcript_aligner = None

        # init attribute to hold source text as extracted from the transcript
        self.source_text = None

        # connect additional signals ...
        self.editor.cursorPositionChanged.connect(self.update_on_cursor_pos_changed)
        self.document = self.editor.document()

        # make sure cursor remains visible
        self.editor.ensureCursorVisible()

        # highlighter
        self.highlighter_pos = None
        self.highlighter = MedSyntaxHighlighter(self.editor.document())
        self.highlighter_action.triggered.connect(self.highlight_text)

        # show changes
        self.change_tracker_action.triggered.connect(self.compose_text_with_changes)
        self.change_highlighter_format = QTextCharFormat()
        self.change_highlighter_format.setBackground(QBrush(Qt.yellow))
        self.editor_current_content = None

        # keep track on changes 
        self.editor.document().contentsChange[int,int,int].connect(self.save_content_changes)
        self.prev_txt = ''
        self.tracked_changes = []
    
    # Install event filter on the editor
        self.editor.installEventFilter(self)

    def eventFilter(self, obj, event):
        if event.type() == QEvent.KeyPress:
            key = event.key()
            if key == Qt.Key_Tab:
                self.play()
                return True  # Indicate that the event has been handled
            elif event.key() == Qt.Key_Plus and event.modifiers() == Qt.ControlModifier:
                self.play_speed += 0.1
                self.mediaPlayer.setPlaybackRate(self.play_speed)
                return True  # Indicate that the event has been handled
            elif event.key() == Qt.Key_Minus and event.modifiers() == Qt.ControlModifier:
                self.play_speed -= 0.1
                self.mediaPlayer.setPlaybackRate(self.play_speed)
                return True  # Indicate that the event has been handled
        return super(PlayerWindow, self).eventFilter(obj, event)

    def added_format(self):
        fmt = QTextCharFormat()
        fmt.setBackground(QBrush(QColor("lightgreen")))
        return fmt

    def deleted_format(self):
        fmt = QTextCharFormat()
        fmt.setBackground(QBrush(QColor("lightcoral")))
        fmt.setFontStrikeOut(True)
        return fmt

    def compose_text_with_changes(self):

        if self.change_tracker_action.isChecked():

            # remember current content
            self.editor_current_content = self.editor.toHtml()

            # create hash map for current visible tokens
            hash_map = {el["abs_pos"]: el for el in self.transcript_aligner.visible_tokens}

            # disable the change tracker
            self.enable_tracking_changes = False

            # create required styles for the html content with changes
            content = """
            <html>
                <head>
                    <style>
                        span.modified { background-color: lightgreen; }
                        span.deleted { background-color: lightcoral; text-decoration: line-through; }
                    </style>
                </head>
            """

            # remember if prev token was removed completely - to count space in between as deleted or not 
            prev_removed = False

            for el_pos, el in enumerate(self.transcript_aligner.visible_tokens_original):
                
                token_pos = el["pos"]
                token_orig = el["text"]
                token = hash_map.get(el["abs_pos"] , None)
                token = token["text"] if token else None

                if el['nl_before'] or el['np_before']:
                    content += '</p><p>'

                if el_pos == 0:
                    space = ""
                else:
                    space = " " * (token_pos - (self.transcript_aligner.visible_tokens_original[el_pos-1]["pos"] + len(self.transcript_aligner.visible_tokens_original[el_pos-1]["text"])))

                if token == token_orig:
                    content += f'<span>{space + token}</span>'
                else:
                    # token was completely deleted
                    if not token:
                        if not prev_removed:
                            content += f'{space}<span class="deleted">{token_orig}</span>'
                        else:
                            content += f'<span class="deleted">{space}{token_orig}</span>'
                        prev_removed = True
                    # new token is shorter
                    elif len(token) <= len(token_orig):
                        res = token_orig.find(token)
                        if res == -1:
                            # new token is not included in the original
                            content += f'{space}<span class="deleted">{token_orig}</span><span class="modified">{token}</span>'
                        else:
                            # new token is part of the original
                            content += f'{space}<span class="deleted">{token_orig[:res]}</span><span>{token}</span><span class="deleted">{token_orig[res+len(token):]}</span>'
                    # new token is longer
                    elif len(token) > len(token_orig):
                        res = token.find(token_orig)
                        if res == -1:
                            # new token does not include the original
                            content += f'{space}<span class="deleted">{token_orig}</span><span class="modified">{token}</span>'
                        else:
                            # original token is part of new token
                            content += f'{space}<span class="modified">{token[:res]}</span><span>{token_orig}</span><span class="modified">{token[res+len(token_orig):]}</span>'

            content += "</body></html>"

            self.editor.setHtml(content)
            self.editor.setReadOnly(True)

        else:
            self.editor.setHtml(self.editor_current_content)
            self.editor.setReadOnly(False)
            # enable the change tracker back
            self.enable_tracking_changes = True

    def highlight_token_at_pos(self, pos):
        cursor = QTextCursor(self.editor.document())
        cursor.setPosition(pos)
        
        cursor.select(QTextCursor.WordUnderCursor)
        
        # Apply the predefined highlight format
        cursor.setCharFormat(self.change_highlighter_format)

    def highlight_text(self):
        self.highlighter.is_highlighting_enabled = not self.highlighter.is_highlighting_enabled
        self.highlighter.rehighlight()
    
    def _create_mediaplayer_toolbar(self):

        # create mediaplayer object
        self.mediaPlayer = QMediaPlayer()
        self.mediaPlayer.setPlaybackRate(1)
        self.mediaPlayer.setVolume(100)

        # create GUI elements
        media_control_widget = QWidget()
        media_control_layout = QHBoxLayout()
        media_control_layout.addItem(QSpacerItem(40, 20, QSizePolicy.Expanding, QSizePolicy.Minimum))
        media_control_layout.setContentsMargins(scale(0), scale(0), scale(0), scale(0))  # Set margins to zero to reduce space
        media_control_layout.setSpacing(0)  # Set spacing to zero to reduce space

        # create changable icons
        self.icon_pause = QtGui.QIcon()
        self.icon_pause.addPixmap(QtGui.QPixmap(os.path.join(basedir, "pause96.png")), QtGui.QIcon.Normal, QtGui.QIcon.Off)
        self.icon_play = QtGui.QIcon()
        self.icon_play.addPixmap(QtGui.QPixmap(os.path.join(basedir, "play96.png")), QtGui.QIcon.Normal, QtGui.QIcon.Off)

        # Single action button with "play.png" icon
        self.pushButton_play = QPushButton()
        self.pushButton_play.setIcon(self.icon_play)
        self.pushButton_play.setIconSize(QSize(64, 64))  # Adjust the icon size as needed
        self.pushButton_play.setFixedSize(64, 64)
        self.pushButton_play.setFlat(True)
        self.pushButton_play.setEnabled(False)
        media_control_layout.addWidget(self.pushButton_play)
        media_control_layout.addItem(QSpacerItem(40, 20, QSizePolicy.Expanding, QSizePolicy.Minimum))
        media_control_widget.setLayout(media_control_layout)

        # slider
        self.positionSlider = QSlider(Qt.Horizontal)
        self.positionSlider.setMinimum(0)
        self.positionSlider.setMaximum(100)
        self.positionSlider.setValue(0)
        self.positionSlider.setRange(0, 0)

        # timer
        self.label_timer = QLabel()
        self.label_timer.setGeometry(QtCore.QRect(scale(100), scale(56), scale(181), scale(16)))
        self.label_timer.setLayoutDirection(QtCore.Qt.LeftToRight)
        self.label_timer.setAlignment(Qt.AlignCenter)
        self.label_timer.setObjectName("label_timer")

        # playback speed
        self.label_payback_speed = QLabel()
        self.label_payback_speed.setGeometry(QtCore.QRect(scale(100), scale(56), scale(181), scale(16)))
        self.label_payback_speed.setLayoutDirection(QtCore.Qt.LeftToRight)
        self.label_payback_speed.setAlignment(QtCore.Qt.AlignLeft)
        self.label_payback_speed.setObjectName("label_playback_speed")
        self.label_payback_speed.setText("1.0")

        # Vertical layout for media controls and slider
        media_layout = QVBoxLayout()
        media_layout.addWidget(media_control_widget)
        media_layout.addWidget(self.positionSlider)
        #media_layout.addWidget(self.label_payback_speed)
        media_layout.addWidget(self.label_timer)

        media_container = QWidget()
        media_container.setLayout(media_layout)

        self.toolbar2 = QToolBar("Media Controls")
        self.addToolBar(Qt.BottomToolBarArea, self.toolbar2)
        self.toolbar2.addWidget(media_container)

        # connect functions to play
        self.pushButton_play.clicked.connect(self.play)
        
        # connect functions to slider
        self.positionSlider.sliderMoved.connect(self.set_position)
        
        # connect functions to mediaplayer
        self.mediaPlayer.stateChanged.connect(self.media_state_changed)
        self.mediaPlayer.positionChanged.connect(self.position_changed)
        self.mediaPlayer.durationChanged.connect(self.duration_changed)
        
        # make mediaplayer notification about position changed more frequent than default (1000)
        self.mediaPlayer.setNotifyInterval (100)
        self.mediaPlayer.error.connect(self.handle_error)

    def _consolidate_changes(self):
        """
        Returns a list of consolidated changes.
        Iterates over tracked_changes and joins changes that happened in a row,
        for instance if 5 letter word was added, five change elements are joined
        into a single one.
        """
        def change_type(c):
            """
            Returns change type. The type can be:
            1 - addition
            2 - removal
            3 - mixed
            """
            if c.get('added', False):
                if c.get('removed', False):
                    return 3
                else:
                    return 1
            else:
                return 2

        new_change_list = []
        prev_change = None
        prev_pos = None
        
        for change in self.tracked_changes:
            if prev_change and change_type(prev_change)==change_type(change):
                if change_type(change)==1 and change['pos']==prev_pos+1:
                    prev_change.update(added=prev_change['added']+change['added'])
                elif change_type(change)==2 and change['pos']==prev_pos:
                    prev_change.update(removed=change['removed']+prev_change['removed'], pos=change['pos'])
                else:
                    new_change_list.append(prev_change)
                    prev_change = copy.deepcopy(change)
            else:
                if prev_change: # prev exists but is different than current
                    new_change_list.append(prev_change)
                    prev_change = copy.deepcopy(change)
                    
                else: # prev not exists
                    if change_type(change)==3: # if mixed, just put it on the list
                        new_change_list.append(change)
                    else: # if not mixed, put it to prev_change
                        prev_change = copy.deepcopy(change)
            prev_pos = change['pos']
                            
        # take care for the last element
        if prev_change:
            new_change_list.append(prev_change)

        return new_change_list    

    # NOT USED - delete
    def toggle_show_hide_changes(self):
        """
        This function is called when track changes button is triggered
        If track changes is ON, changes are shown and editor locked from editing
        Otherwise changes are hidden.
        """

        consolidated_changes = self._consolidate_changes()

        if self.highlighter_action.isChecked():
            for el in consolidated_changes:
                added = el.get('added', None)
                if added:
                    # annotating text will emit signal and trigger document().contentsChange
                    # use blockSignals to prevent that from happening 
                    self.editor.document().blockSignals(True)
                    self.annotate_text(added, el['pos'], 'INS')
                    self.editor.document().blockSignals(False)
            self.editor.setReadOnly(True)    
        else:
            # hide changes
            for el in consolidated_changes:
                added = el.get('added', None)
                if added:
                    self.editor.document().blockSignals(True)
                    self.remove_styling(added, el['pos'], 'INS')
                    self.editor.document().blockSignals(False)
            self.editor.setReadOnly(False)

    def save_content_changes(self, pos, rem, add):
        """
        This function is triggered on every content change. When a change happens, 
        information about it is added to an internal list so that content changes can 
        be tracked. All arguments come through the event signal. 
        Args:
        - pos: position in the text where change happened. Since pos refers to a text
               at specific time, when new change is handled, all changes with with
               pos in the area that is effected must change as well.
        - rem: text that was removed
        - add: text that was added
        """

        if self.enable_tracking_changes:

            current_txt = self.editor.toPlainText()
            change = dict()

            if add > 0: 
                change.update(added = current_txt[pos:pos+add])
            if rem > 0:
                change.update(removed = self.prev_txt[pos:pos+rem])

            # it seems the highlighter removes and adds back text that is highlighted. This should not be tracked as a change
            if add + rem > 0 and (add-rem!=0 or current_txt[pos:pos+add]!=self.prev_txt[pos:pos+rem]):
                # move pos of old changes that will be effected by the new change
                move = len(change.get('added', '')) - len(change.get('removed', ''))
                for change_el in self.tracked_changes:
                    if change_el['pos'] >= pos:
                        change_el.update(pos = change_el['pos'] + move)
                # append the new change
                change.update(pos=pos)
                self.tracked_changes.append(change)
                # set new offset
                self.offset += add - rem
                # update position of visible tokens - do that separatelly for removed abd added tokens if both were applied at the 
                # same time, e.g. by selecting some text and copyng over another text
                if rem:
                    self.transcript_aligner.update_tokens_pos(pos, -rem)
                if add:
                    self.transcript_aligner.update_tokens_pos(pos, add, current_txt[pos:pos+add])
        
            self.prev_txt = current_txt

    def closeEvent(self,event):
        """
        Handles the state (checked/unchecked) of the pushbutton for 
        showing/hiding transcript editor 
        """
        #self.toggle_button.setChecked(False)
        # save window pos and size
        #qt_settings.setValue('editor-size', self.size())
        #qt_settings.setValue('editor-position', self.pos())
        event.accept()    

    def update_on_cursor_pos_changed(self):
        """
        Handles audio position after cursor position changed - i.e. user clicked somewhere in text (in PLAY mode only) 
        """
        if self.mediaPlayer.state() == QMediaPlayer.PlayingState:
            pos = self.editor.textCursor().position()
            if self.transcript_aligner:
                #print("offset in update_on_curpose_pos_changed: ", self.offset)
                res = self.transcript_aligner.find_token_by_pos(pos, 0, len(self.transcript_aligner.visible_tokens))
                if res:
                    start_pos = res[1]
                    self.highlight_token(("", pos))
                    self.mediaPlayer.setPosition(int(start_pos * 1000))
    
    # multimedia methods
    def open_file(self, fileName):
        if os.path.isfile(fileName):
            self.mediaPlayer.setMedia(QMediaContent(QUrl.fromLocalFile(fileName)))
            self.pushButton_play.setEnabled(True)

    def exit_call(self):
        sys.exit(self.app.exec_())
 
    def play(self):
        # if in 'show changes mode', revert back to play mode first
        if self.change_tracker_action.isChecked():
            self.editor.setHtml(self.editor_current_content)
            self.editor.setReadOnly(False)
            self.change_tracker_action.setChecked(False)
            # enable the change tracker back
            self.enable_tracking_changes = True

        if self.mediaPlayer.state() == QMediaPlayer.PlayingState:
            self.mediaPlayer.pause()
        else:
            # go back for x miliseconds
            self.mediaPlayer.setPosition(max(0, self.mediaPlayer.position()-self.leap_back*1000))
            # play
            self.mediaPlayer.play()
 
    def media_state_changed(self, state):   
        if self.mediaPlayer.state() == QMediaPlayer.PlayingState:
            self.pushButton_play.setIcon(self.icon_pause)
        else:
            self.pushButton_play.setIcon(self.icon_play)
 
    def position_changed(self, position):
        """
        Will be triggered everytime mediaplayer changes position in the recording. The mediaplayer will trigger this with some frequency
        that can be customized. The position argument tells the current pos in milliseconds
        NOTE: if transcript content was altered, the position returned by the find_spoken_word() method will have to be altered accordingly
        """
        # if position went out of scale, put it back
        if position < 0:
            print("WARNING: position less than 0:", position)
            position = 0
        elif position > self.mediaPlayer.duration():
            print("WARNING: position past the end:", position)
            position = self.mediaPlayer.duration()
        self.positionSlider.setValue(position)
        self.label_timer.setText(f"{str(timedelta(seconds=round(position/1000)))} |{str(timedelta(seconds=round(self.mediaPlayer.duration()/1000)))}")
        
        # if aligner is set and spoken word located in the editor content, call highligner
        if self.transcript_aligner:
            if position==0:
                self.reset_text_color()
            res = self.transcript_aligner.find_spoken_token(position/1000, 0, len(self.transcript_aligner.visible_tokens)-1)
            if res:
                self.highlight_token(res)
                self.app.processEvents()
            else:
                pass
                #print(f"Can't find spoken word for position: {position/1000} and length: {len(self.transcript_aligner.visible_tokens)}")
             
    def duration_changed(self, duration):
        self.positionSlider.setRange(0, duration)
        # set correct duration once media loaded - the "0" is to compensate for the missing leading zero returned by timedelta
        duration_format = "0" + str(timedelta(seconds=round(self.mediaPlayer.duration()/1000)))
        self.label_timer.setText(self.label_timer.text()[:11] + f"{duration_format[-8:]}")
            
    def set_position(self, position):
        self.mediaPlayer.setPosition(position)
 
    def handle_error(self):
        self.pushButton_play.setEnabled(False)
        # TODO: decide what to do if audio cannot be played
        #self.status.showMessage("Error: " + self.mediaPlayer.errorString())
        #self.status.setVisible(True)
        #self.label_error_message.setText("Error: " + self.mediaPlayer.errorString())
        print('Media error event triggered!')

    # methods to handle text coloring when playing
    def reset_text_color(self):
        """Reset text to black"""
        document = self.editor.document()
        cursor = QTextCursor(document)
        cursor.select(QTextCursor.Document)
        
        default_format = QTextCharFormat()
        default_format.setForeground(Qt.black)
        default_format.setBackground(Qt.white)
        #cursor.setCharFormat(default_format)
        cursor.mergeCharFormat(default_format)

    def highlight_token(self, token_data):
        text = token_data[0]
        pos = token_data[1]

        # Do nothing if still on the same position 
        if pos == self.highlighter_pos:
            return
        else:
            self.highlighter_pos = pos

        if pos != -1:
            document = self.editor.document()
            cursor = QTextCursor(document)
            
            # First, reset all text color to default
            self.reset_text_color()

            # Move the cursor to the position of the word and select the word
            cursor.setPosition(pos)
            cursor.movePosition(QTextCursor.Right, QTextCursor.KeepAnchor, len(text))
            
            # Set the format for the highlighted word
            format = QTextCharFormat()
            format.setForeground(Qt.black)
            format.setBackground(QColor(173,216,230))  # light blue
            #cursor.setCharFormat(format)

            # Merge the new format with the existing format
            cursor.mergeCharFormat(format)
