import yaml
import os
import logging

def setup_logging(logger_name, logger_folder):
    """
    Logger is setup with config parameters that are expected in the app/conf folder in 
    config-logger.yaml file. See example in other services like TTS service etc.
    """
    with open('./conf/config-logger.yaml', 'r', encoding="utf-8") as stream:
        cfg = yaml.load(stream, Loader=yaml.FullLoader)
    cfg['handlers']['info_file_handler']['filename'] = os.path.join(logger_folder, 'info.log')
    cfg['handlers']['debug_file_handler']['filename'] = os.path.join(logger_folder, 'debug.log')
    cfg['handlers']['error_file_handler']['filename'] = os.path.join(logger_folder, 'error.log')
    logging.config.dictConfig(cfg)
    return logging.getLogger(logger_name)