<?xml version="1.0" encoding="Windows-1250"?>
<!DOCTYPE xsl:stylesheet [
	<!ENTITY nbsp "&#160;">
]>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:decimal-format name="european" decimal-separator="," grouping-separator="."/>
	<!-- COMMON -->
	<xsl:template name="FormatDate">
		<xsl:param name="Date"/>
		<xsl:variable name="year" select="substring($Date,1,4)"/>
		<xsl:choose>
			<xsl:when test="$year&lt;'1900'"/>
			<xsl:otherwise>
				<xsl:value-of select="substring($Date,9,2)"/>.<xsl:value-of select="substring($Date,6,2)"/>.<xsl:value-of select="substring($Date,1,4)"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="FormatNumber">
		<xsl:param name="Number"/>
		<xsl:choose>
			<xsl:when test="$Number='0.00000'"/>
			<xsl:when test="contains($Number,'/')">
				<xsl:value-of select="$Number"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="format-number($Number, '###.##0,00', 'european')"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="FormatNumberWithNull">
		<xsl:param name="Number"/>
		<xsl:choose>
			<xsl:when test="$Number='0.00000'">0,00</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="format-number($Number, '###.##0,00', 'european')"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="UnderGroundField">
		<xsl:param name="TxtFile"/>
		<xsl:if test="not (UnitProperty/SmallPoint = '')">
			<xsl:value-of select="document($TxtFile)/InvoiceTXT/BodyTXT/BUGF_1_1"/>&nbsp;		
			<xsl:call-template name="FormatNumber">
				<xsl:with-param name="Number" select="UnitProperty/SmallPoint"/>
			</xsl:call-template>&nbsp;&nbsp;			
		</xsl:if>
		<xsl:if test="not (UnitProperty/BigPoint = '')">
			<xsl:value-of select="document($TxtFile)/InvoiceTXT/BodyTXT/BUGF_1_2"/>&nbsp;		
			<xsl:call-template name="FormatNumber">
				<xsl:with-param name="Number" select="UnitProperty/BigPoint"/>
			</xsl:call-template>&nbsp;&nbsp;			
		</xsl:if>
		<xsl:if test="not (UnitProperty/Point = '')">
			<xsl:value-of select="document($TxtFile)/InvoiceTXT/BodyTXT/BUGF_1_3"/>&nbsp;
			<xsl:call-template name="FormatNumber">
				<xsl:with-param name="Number" select="UnitProperty/Point"/>
			</xsl:call-template>&nbsp;&nbsp;
		</xsl:if>
		<xsl:if test="not (UnitProperty/CasePrice = '')">
			<xsl:choose>
				<xsl:when test="not (../../../../../../../InvProperty/KontoSPP = '')">
					<xsl:value-of select="document($TxtFile)/InvoiceTXT/BodyTXT/BUGF_1_8"/>&nbsp;		
			</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="document($TxtFile)/InvoiceTXT/BodyTXT/BUGF_1_5"/>&nbsp;		
			</xsl:otherwise>
			</xsl:choose>
			<xsl:call-template name="FormatNumber">
				<xsl:with-param name="Number" select="UnitProperty/CasePrice "/>
			</xsl:call-template>&nbsp;&nbsp;			
		</xsl:if>
		<xsl:if test="not (UnitProperty/NursingDay= '')">
			<xsl:value-of select="document($TxtFile)/InvoiceTXT/BodyTXT/BUGF_1_6"/>&nbsp;		
			<xsl:call-template name="FormatNumber">
				<xsl:with-param name="Number" select="UnitProperty/NursingDay"/>
			</xsl:call-template>&nbsp;&nbsp;			
		</xsl:if>
		<xsl:if test="not (UnitProperty/KM= '')">
			<xsl:value-of select="document($TxtFile)/InvoiceTXT/BodyTXT/BUGF_1_4"/>&nbsp;		
			<xsl:call-template name="FormatNumber">
				<xsl:with-param name="Number" select="UnitProperty/KM"/>
			</xsl:call-template>&nbsp;&nbsp;			
		</xsl:if>
	</xsl:template>
	<xsl:template name="UnderGroundField1">
		<xsl:param name="TxtFile"/>
		<xsl:if test="not (UnitProperty/SmallPoint = '')">
			<xsl:value-of select="document($TxtFile)/InvoiceTXT/BodyTXT/BUGF_1_1"/>&nbsp;
			<xsl:call-template name="FormatNumber">
				<xsl:with-param name="Number" select="UnitProperty/SmallPoint"/>
			</xsl:call-template>&nbsp;&nbsp;
		</xsl:if>
		<xsl:if test="not (UnitProperty/BigPoint = '')">
			<xsl:value-of select="document($TxtFile)/InvoiceTXT/BodyTXT/BUGF_1_2"/>&nbsp;
			<xsl:call-template name="FormatNumber">
				<xsl:with-param name="Number" select="UnitProperty/BigPoint"/>
			</xsl:call-template>&nbsp;&nbsp;
		</xsl:if>
		<xsl:if test="not (UnitProperty/Point = '')">
			<xsl:value-of select="document($TxtFile)/InvoiceTXT/BodyTXT/BUGF_1_3"/>&nbsp;
			<xsl:call-template name="FormatNumber">
				<xsl:with-param name="Number" select="UnitProperty/Point"/>
			</xsl:call-template>&nbsp;&nbsp;
		</xsl:if>
		<xsl:if test="not (UnitProperty/CasePrice = '')">
			<xsl:value-of select="document($TxtFile)/InvoiceTXT/BodyTXT/BUGF_1_5"/>&nbsp;
			<xsl:call-template name="FormatNumber">
				<xsl:with-param name="Number" select="UnitProperty/CasePrice"/>
			</xsl:call-template>&nbsp;&nbsp;
		</xsl:if>
		<xsl:if test="not (UnitProperty/NursingDay= '')">
			<xsl:value-of select="document($TxtFile)/InvoiceTXT/BodyTXT/BUGF_1_6"/>&nbsp;
			<xsl:call-template name="FormatNumber">
				<xsl:with-param name="Number" select="UnitProperty/NursingDay"/>
			</xsl:call-template>&nbsp;&nbsp;
		</xsl:if>
		<xsl:if test="not (UnitProperty/KM= '')">
			<xsl:value-of select="document($TxtFile)/InvoiceTXT/BodyTXT/BUGF_1_4"/>&nbsp;		
			<xsl:call-template name="FormatNumber">
				<xsl:with-param name="Number" select="UnitProperty/KM"/>
			</xsl:call-template>&nbsp;&nbsp;			
		</xsl:if>
	</xsl:template>
	<!-- HEAD -->
	<xsl:template name="HeadRules">
		<xsl:param name="T"/>
		<xsl:param name="H4_1"/>
		<xsl:param name="H5_1"/>
		<xsl:param name="H6_1"/>
		<xsl:param name="H7_2"/>
		<xsl:param name="H8_2"/>
		<xsl:param name="H9_2"/>
		<xsl:param name="H10_2"/>
		<xsl:param name="H11_1"/>
		<xsl:param name="H11_2"/>
		<xsl:param name="H12_2"/>
		<xsl:param name="H13_2"/>
		<xsl:param name="H14_2"/>
		<xsl:param name="H15_2"/>
		<xsl:param name="H16_2"/>
		<xsl:param name="H17_2"/>
		<xsl:if test="$H4_1">
			<xsl:choose>
				<xsl:when test="(../InvProperty/HeaderAccountDesc) and (not (../InvProperty/HeaderAccountDesc=''))">
					<xsl:value-of select="../InvProperty/HeaderAccountDesc"/>:
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="document($H4_1)/InvoiceTXT/HeadTXT/H4_1_1"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="$H5_1">
			<xsl:choose>
				<xsl:when test="(../InvProperty/HeaderTAXDesc) and (not (../InvProperty/HeaderTAXDesc=''))">
					<xsl:value-of select="../InvProperty/HeaderTAXDesc"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="document($H5_1)/InvoiceTXT/HeadTXT/H5_1_1"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="$H6_1">
			<xsl:value-of select="document($H6_1)/InvoiceTXT/HeadTXT/H6_1_1"/>
		</xsl:if>
		<xsl:if test="$H7_2">
			<xsl:choose>
				<xsl:when test="($T='01') or ($T='02') or ($T='03') or ($T='05') or ($T='06') or ($T='3B')">
					<xsl:choose>
						<xsl:when test="(../InvProperty/StornoDocument = 'D') and (../InvProperty/VezniDocument != '')">STORNO POR. T.:</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="document($H7_2)/InvoiceTXT/HeadTXT/H7_2_1"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:when test="(Document/Name = 'FZ')  or ($T='11')">
					<xsl:choose>
						<xsl:when test="(../InvProperty/StornoDocument = 'D') and (../InvProperty/VezniDocument != '')">STORNO ZAHT. T.:</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="document($H7_2)/InvoiceTXT/HeadTXT/H7_2_2"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<!-- 20.07.2005 -->
				<xsl:when test="($T='P01')  or ($T='P02')  or ($T='P03') or ($T='S01') or ($T='40') or ($T='44') or ($T='ER')">
					<!--Akt_100886-->
					<xsl:choose>
						<xsl:when test="(../InvProperty/StornoDocument = 'D') and (../InvProperty/VezniDocument != '') and contains(../InvProperty/HeaderInformation, 'DOBROPIS')">DOBROPIS T.:</xsl:when>
						<!--Nap_9576-->
						<xsl:when test="(../InvProperty/StornoDocument = 'D') and (../InvProperty/VezniDocument != '')">STORNO RA. T.:</xsl:when>
						<xsl:when test="contains(../InvFooter/ServicePriceProperty/BasicPrice,'-') and (../InvFooter/TextProvsion != '')">DOBROPIS T.:</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="document($H7_2)/InvoiceTXT/HeadTXT/H7_2_3"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<!-- 20.07.2005 -->
				<xsl:when test="($T='09') or ($T='10') or ($T='12') or ($T='19') or ($T='23') or ($T='25') or ($T='08') or ($T='26') or ($T='VOZ')  or ($T='33') or ($T='34') or ($T='38') or ($T='EEEEE') or ($T='39') or ($T='41') or ($T='42') or ($T='43') or ($T='45') or ($T='46') or ($T='47') or ($T='48') or ($T='49') ">
					<!-- Akt_100808, Akt_101021 -->
					<xsl:choose>
						<xsl:when test="(../InvProperty/StornoDocument = 'D') and (../InvProperty/VezniDocument != '')">DOBROPIS T.:</xsl:when>
						<xsl:when test=" ($T='39')">INTERNI RAUN:</xsl:when>
						<!-- Akt_100808 -->
						<xsl:otherwise>
							<xsl:value-of select="document($H7_2)/InvoiceTXT/HeadTXT/H7_2_3"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:when test="($T='BBBBB') or ($T='DDDDD') or ($T='35')">
					<xsl:choose>
						<xsl:when test="(../InvProperty/StornoDocument = 'D') and (../InvProperty/VezniDocument != '')">STORNO FIKT. RA.:</xsl:when>
						<xsl:otherwise>FIKTIVNI RA.:</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="$H8_2">
			<xsl:value-of select="document($H8_2)/InvoiceTXT/HeadTXT/H8_2_1"/>
		</xsl:if>
		<xsl:if test="$H9_2">
			<xsl:choose>
				<xsl:when test="($T='01') or ($T='02') or ($T='03') or ($T='05') or ($T='06') or ($T='3B')">
					<xsl:choose>
						<xsl:when test="(../InvProperty/StornoDocument='D') or contains(../InvFooter/ServicePriceProperty/ServicePrice,'-') or contains(../InvFooter/ServicePriceProperty/BasicPrice,'-') or contains(../InvFooter/ServicePriceProperty/AdditionalPrice,'-')">
							<xsl:value-of select="document($H9_2)/InvoiceTXT/HeadTXT/H9_2_4"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="document($H9_2)/InvoiceTXT/HeadTXT/H9_2_1"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:when test="(Document/Name = 'FZ') or ($T='11')">
					<xsl:value-of select="document($H9_2)/InvoiceTXT/HeadTXT/H9_2_2"/>
				</xsl:when>
				<xsl:when test="($T='09') or ($T='10') or ($T='12') or ($T='19') or ($T='23') or ($T='25') or ($T='08') or ($T='26') or ($T='VOZ') or ($T='BBBBB') or ($T='DDDDD') or ($T='P01')  or ($T='P02')  or ($T='P03') or ($T='S01') or ($T='33') or ($T='34') or ($T='38') or ($T='EEEEE') or ($T='39') or ($T='41') or ($T='40')  or ($T='42') or ($T='43') or ($T='35') or ($T='44') or ($T='45') or ($T='46') or ($T='47') or ($T='48') or ($T='49') or ($T='ER')">
					<!--Akt_100886-->
					<!-- Akt_100808, Akt_101021 -->
					<xsl:choose>
						<xsl:when test="(../InvProperty/StornoDocument='D') or contains(../InvFooter/ServicePriceProperty/ServicePrice,'-') or contains(../InvFooter/ServicePriceProperty/BasicPrice,'-') or contains(../InvFooter/ServicePriceProperty/AdditionalPrice,'-')">
							<xsl:value-of select="document($H9_2)/InvoiceTXT/HeadTXT/H9_2_5"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:choose>
								<xsl:when test="contains(../InvProperty/HeaderInformation,'DATE_L')">
									<xsl:value-of select="document($H9_2)/InvoiceTXT/HeadTXT/H9_2_6"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="document($H9_2)/InvoiceTXT/HeadTXT/H9_2_3"/>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="$H10_2">
			<xsl:choose>
				<xsl:when test="($T='38') or ($T='VOZ')">
					<xsl:choose>
						<xsl:when test="contains(../InvProperty/HeaderInformation,'DATE_L')  and not(contains(../InvProperty/HeaderInformation,'DATE_DUR'))">
							<!--Akt_100847-->
							<td>
								<xsl:value-of select="document($H10_2)/InvoiceTXT/HeadTXT/H10_2_7"/>
							</td>
							<td>
								<xsl:call-template name="FormatDate">
									<xsl:with-param name="Date" select="Document/InvDateDUR"/>
								</xsl:call-template>
							</td>
							<tr>
								<td/>
								<td/>
								<td>
									<xsl:value-of select="document($H10_2)/InvoiceTXT/HeadTXT/H10_2_6"/>
								</td>
								<td>
									<xsl:value-of select="Document/InsuranceGroup"/>
								</td>
							</tr>
						</xsl:when>
						<xsl:otherwise>
							<td>
								<xsl:value-of select="document($H10_2)/InvoiceTXT/HeadTXT/H10_2_6"/>
							</td>
							<td>
								<xsl:value-of select="Document/InsuranceGroup"/>
							</td>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:when test="($T='P01') or ($T='P02') or ($T='P03') or ($T='S01') or ($T='40') or ($T='44') or ($T='ER')">
					<!--Akt_100886-->
					<xsl:choose>
						<xsl:when test="contains(../InvProperty/HeaderInformation,'DATE_L')  and not(contains(../InvProperty/HeaderInformation,'DATE_DUR'))">
							<!--Akt_100847-->
							<td>
								<xsl:value-of select="document($H10_2)/InvoiceTXT/HeadTXT/H10_2_7"/>
							</td>
							<td>
								<xsl:call-template name="FormatDate">
									<xsl:with-param name="Date" select="Document/InvDateDUR"/>
								</xsl:call-template>
							</td>
							<xsl:if test="(contains(../InvProperty/HeaderInformation,'ZZZS')) and (../InvProperty/Language='SLO') and not((Document/Name = 'HP') or (Document/Name = 'FP'))">
								<tr>
									<td/>
									<td/>
									<td>
										<xsl:call-template name="HeadRules">
											<xsl:with-param name="T" select="$T"/>
											<xsl:with-param name="H11_2" select="$H10_2"/>
										</xsl:call-template>
									</td>
									<td>
										<xsl:call-template name="FormatDate">
											<xsl:with-param name="Date" select="Document/DateExpiration"/>
										</xsl:call-template>
									</td>
								</tr>
							</xsl:if>
						</xsl:when>
						<xsl:when test="(contains(../InvProperty/HeaderInformation,'ZZZS')) and (../InvProperty/Language='SLO') and not((Document/Name = 'HP') or (Document/Name = 'FP'))">
							<td>
								<xsl:call-template name="HeadRules">
									<xsl:with-param name="T" select="$T"/>
									<xsl:with-param name="H11_2" select="$H10_2"/>
								</xsl:call-template>
							</td>
							<td>
								<xsl:call-template name="FormatDate">
									<xsl:with-param name="Date" select="Document/DateExpiration"/>
								</xsl:call-template>
							</td>
						</xsl:when>
						<xsl:otherwise>
							<xsl:choose>
								<xsl:when test="contains(../InvProperty/HeaderInformation,'DATE_DUR')">
									<td>
										<!-- Dat.opr.stor.-DUR: -->
										<xsl:value-of select="document($H10_2)/InvoiceTXT/HeadTXT/H10_2_4"/>
									</td>
									<td>
										<xsl:call-template name="FormatDate">
											<xsl:with-param name="Date" select="Document/InvDateDUR"/>
										</xsl:call-template>
									</td>
								</xsl:when>
								<xsl:otherwise/>
							</xsl:choose>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:otherwise>
					<xsl:choose>
						<xsl:when test="contains(../InvProperty/HeaderInformation,'DATE_L')  and not(contains(../InvProperty/HeaderInformation,'DATE_DUR'))">
							<!--Akt_100847-->
							<td>
								<xsl:value-of select="document($H10_2)/InvoiceTXT/HeadTXT/H10_2_7"/>
							</td>
							<td>
								<xsl:call-template name="FormatDate">
									<xsl:with-param name="Date" select="Document/InvDateDUR"/>
								</xsl:call-template>
							</td>
							<tr>
								<td/>
								<td/>
								<td>
									<xsl:value-of select="document($H10_2)/InvoiceTXT/HeadTXT/H10_2_1"/>
								</td>
								<td>
									<xsl:choose>
										<xsl:when test="($T='42') or ($T='43')">
											<!--Akt_101147-->
											<xsl:value-of select="Document/InsuranceType"/>
										</xsl:when>
										<xsl:when test="Document/InsuranceType = '2'">
											<xsl:value-of select="document($H10_2)/InvoiceTXT/HeadTXT/H10_2_3"/>
										</xsl:when>
										<xsl:when test="Document/InsuranceType = '5'">
											<xsl:value-of select="document($H10_2)/InvoiceTXT/HeadTXT/H10_2_5"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="document($H10_2)/InvoiceTXT/HeadTXT/H10_2_2"/>
										</xsl:otherwise>
									</xsl:choose>
								</td>
							</tr>
						</xsl:when>
						<xsl:otherwise>
							<td>
								<xsl:value-of select="document($H10_2)/InvoiceTXT/HeadTXT/H10_2_1"/>
							</td>
							<td>
								<xsl:choose>
									<xsl:when test="($T='42') or ($T='43')">
										<!--Akt_101147-->
										<xsl:value-of select="Document/InsuranceType"/>
									</xsl:when>
									<xsl:when test="Document/InsuranceType = '2'">
										<xsl:value-of select="document($H10_2)/InvoiceTXT/HeadTXT/H10_2_3"/>
									</xsl:when>
									<xsl:when test="Document/InsuranceType = '5'">
										<xsl:value-of select="document($H10_2)/InvoiceTXT/HeadTXT/H10_2_5"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="document($H10_2)/InvoiceTXT/HeadTXT/H10_2_2"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="$H11_1">
			<xsl:value-of select="document($H11_1)/InvoiceTXT/HeadTXT/H11_1_1"/>
		</xsl:if>
		<xsl:if test="$H11_2">
			<xsl:value-of select="document($H11_2)/InvoiceTXT/HeadTXT/H11_2_1"/>
		</xsl:if>
		<xsl:if test="$H12_2">
			<xsl:value-of select="document($H12_2)/InvoiceTXT/HeadTXT/H12_2_1"/>
		</xsl:if>
		<xsl:if test="$H13_2">
			<xsl:value-of select="document($H13_2)/InvoiceTXT/HeadTXT/H13_2_1"/>
		</xsl:if>
		<xsl:if test="$H14_2">
			<xsl:value-of select="document($H14_2)/InvoiceTXT/HeadTXT/H14_2_1"/>
		</xsl:if>
		<xsl:if test="$H15_2">
			<xsl:value-of select="document($H15_2)/InvoiceTXT/HeadTXT/H15_2_1"/>
		</xsl:if>
		<xsl:if test="$H16_2">
			<xsl:value-of select="document($H16_2)/InvoiceTXT/HeadTXT/H16_2_1"/>
		</xsl:if>
		<xsl:if test="$H17_2">
			<xsl:choose>
				<xsl:when test="(../InvHeader/Payer/Destination/TaxDesc) and (not (../InvHeader/Payer/Destination/TaxDesc=''))">
					<xsl:value-of select="../InvHeader/Payer/Destination/TaxDesc"/>
				</xsl:when>
				<xsl:when test="(../InvProperty/HeaderTAXDesc) and (not (../InvProperty/HeaderTAXDesc=''))">
					<xsl:value-of select="../InvProperty/HeaderTAXDesc"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="document($H17_2)/InvoiceTXT/HeadTXT/H17_2_1"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>
	<!-- 	FOOT -->
	<!--
	<xsl:template name="FootRules">
		<xsl:param name="T"/>
		<xsl:param name="F2_1"/>
		<xsl:if test="$F2_1">
			<xsl:if test="($T='01') or ($T='02') or ($T='03') or ($T='05') or ($T='06') or ($T='09') or ($T='10') or ($T='19') or ($T='23') or ($T='25') or ($T='26') or ($T='VOZ') or ($T='P01') or ($T='P02') or ($T='S01')">
				<xsl:value-of select="document($F2_1)/InvoiceTXT/FootTXT/F2_1_1"/>
			</xsl:if>
			<xsl:if test="($T='11')">
				<xsl:value-of select="document($F2_1)/InvoiceTXT/FootTXT/F2_1_2"/>
			</xsl:if>
			<xsl:if test="($T='12')">
				<xsl:value-of select="document($F2_1)/InvoiceTXT/FootTXT/F2_1_3"/>
			</xsl:if>
			<xsl:if test="($T='15')">
				<xsl:value-of select="document($F2_1)/InvoiceTXT/FootTXT/F2_1_4"/>
			</xsl:if>
			<xsl:if test="($T='16') or ($T='17')">
				<xsl:value-of select="document($F2_1)/InvoiceTXT/FootTXT/F2_1_5"/>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	-->
	<!-- BODY -->
	<xsl:template name="BodyRules">
		<xsl:param name="T"/>
		<xsl:param name="BH1_1"/>
		<xsl:param name="BH1_2"/>
		<xsl:param name="BH2_1"/>
		<xsl:param name="BH2_2"/>
		<xsl:param name="BH3_1"/>
		<xsl:param name="BH3_2"/>
		<xsl:param name="BH3_3"/>
		<xsl:param name="BH3_4"/>
		<xsl:param name="BH3_5"/>
		<xsl:param name="BH3_6"/>
		<xsl:param name="BH3_7"/>
		<xsl:param name="BH4_1"/>
		<xsl:param name="BH4_2"/>
		<xsl:param name="BH4_3"/>
		<xsl:param name="BH4_4"/>
		<xsl:param name="BH4_5"/>
		<xsl:param name="BH4_6"/>
		<xsl:param name="BH4_7"/>
		<xsl:param name="BUG_1"/>
		<xsl:param name="BUG_2"/>
		<xsl:param name="BUG_3"/>
		<xsl:param name="BUG_4"/>
		<xsl:param name="BG_2"/>
		<xsl:param name="BG_3"/>
		<xsl:param name="BG_4"/>
		<xsl:param name="BG_5"/>
		<xsl:param name="BG_6"/>
		<xsl:param name="BG_7"/>
		<xsl:param name="BG_8"/>
		<xsl:param name="BF_1"/>
		<xsl:param name="BF_2"/>
		<xsl:param name="BF_3"/>
		<xsl:param name="BF_4"/>
		<!--
		<xsl:param name="BF_4"/>
		<xsl:param name="BF_5"/>
		<xsl:param name="BF_6"/>
		<xsl:param name="BF_7"/>
		<xsl:param name="BF_8"/>
		<xsl:param name="BF_9"/>
		-->
		<xsl:param name="BA_1"/>
		<xsl:param name="BA_2"/>
		<xsl:variable name="HomeCurrency" select="((../InvFooter/ServicePriceProperty/Currency = 'SIT') and (2007 > number(../InvHeader/Document/ServiceYear))) or ((../InvFooter/ServicePriceProperty/Currency = 'EUR') and (number(../InvHeader/Document/ServiceYear) > 2006))"/>
		<xsl:if test="$BH1_1">
			<xsl:if test="($T='19')">
				<b>
					<xsl:value-of select="document($BH1_1)/InvoiceTXT/BodyTXT/BH1_1_1"/>
				</b>
				<xsl:value-of select="BodyProperty/Country/ID"/>&nbsp;
				<xsl:value-of select="BodyProperty/Country/Name"/>
			</xsl:if>
		</xsl:if>
		<xsl:if test="$BH1_2">
			<xsl:if test="not(BodyProperty/RegistrationID = '')">
				<b>Reg. tevilka:</b>&nbsp;
				<!-- <BH1_2_1>Reg. tevilka:</BH1_2_1> -->
				<xsl:value-of select="BodyProperty/RegistrationID"/>
			</xsl:if>
		</xsl:if>
		<xsl:if test="$BH2_1">
			<xsl:value-of select="document($BH2_1)/InvoiceTXT/BodyTXT/BH2_1_1"/>&nbsp;
		</xsl:if>
		<xsl:if test="$BH2_2">
			<xsl:if test="not(($T='15') or ($T='02') or ($T='04') or ($T='49'))">
				<b>
					<xsl:value-of select="document($BH2_2)/InvoiceTXT/BodyTXT/BH2_2_1"/>&nbsp;
				</b>
				<xsl:value-of select="BodyProperty/IDCriterionKZZ"/>
			</xsl:if>
		</xsl:if>
		<xsl:if test="$BH3_1">
			<xsl:value-of select="document($BH3_1)/InvoiceTXT/BodyTXT/BH3_1_1"/>
		</xsl:if>
		<xsl:if test="$BH3_2">
			<xsl:choose>
				<xsl:when test="($T='01')">
					<xsl:value-of select="document($BH3_2)/InvoiceTXT/BodyTXT/BH3_2_1"/>
				</xsl:when>
				<xsl:when test="($T='41')">
					<!--Akt_101021-->
					<xsl:value-of select="document($BH3_2)/InvoiceTXT/BodyTXT/BH3_3_1"/>
				</xsl:when>
				<xsl:when test="($T='05')">
					<xsl:if test="contains(../InvProperty/BodyInformation,'C')">
						<xsl:value-of select="document($BH3_2)/InvoiceTXT/BodyTXT/BH3_2_1"/>
					</xsl:if>
				</xsl:when>
				<xsl:when test="($T='08') or ($T='45') ">
					<xsl:value-of select="document($BH3_2)/InvoiceTXT/BodyTXT/BH3_2_2"/>
					<!--Akt_102118-->
				</xsl:when>
				<xsl:when test="($T='46')">
					<xsl:value-of select="document($BH3_2)/InvoiceTXT/BodyTXT/BH3_2_4"/>
				</xsl:when>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="$BH3_3">
			<xsl:choose>
				<xsl:when test="($T='02') or ($T='17') or ($T='04') or ($T='40') or ($T='43') or ($T='48') or ($T='49')"/>
				<xsl:when test="($T='01')">
					<xsl:value-of select="document($BH3_3)/InvoiceTXT/BodyTXT/BH3_3_2"/>
				</xsl:when>
				<!--Akt_101021-->
				<xsl:when test="($T='41')">
					<xsl:value-of select="document($BH3_3)/InvoiceTXT/BodyTXT/BH3_3_3"/>
				</xsl:when>
				<xsl:when test="($T='46')">
					<xsl:value-of select="document($BH3_3)/InvoiceTXT/BodyTXT/BH4_3_9"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="document($BH3_3)/InvoiceTXT/BodyTXT/BH3_3_1"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="$BH3_4">
			<xsl:choose>
				<xsl:when test="($T='48') or ($T='49')"/>
				<xsl:when test="($T='42')">
					<xsl:value-of select="document($BH3_4)/InvoiceTXT/BodyTXT/BH3_3_2"/>
				</xsl:when>
				<xsl:when test="not (../InvProperty/KontoSPP = '')">
					<xsl:value-of select="document($BH3_4)/InvoiceTXT/BodyTXT/BH3_4_2"/>
				</xsl:when>
				<xsl:when test="($T='06') or ($T='05') or ($T='25') or ($T='10')">
					<xsl:value-of select="document($BH3_4)/InvoiceTXT/BodyTXT/BH3_4_1"/>
				</xsl:when>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="$BH3_5">
			<!--<xsl:choose>
				<xsl:when test="($T='02')"/>
				<xsl:otherwise>-->
			<xsl:value-of select="document($BH3_5)/InvoiceTXT/BodyTXT/BH3_5_1"/>
			<!--</xsl:otherwise>
			</xsl:choose>-->
		</xsl:if>
		<xsl:if test="$BH3_6">
			<xsl:choose>
				<xsl:when test="($T='17')"/>
				<xsl:otherwise>
					<xsl:value-of select="document($BH3_6)/InvoiceTXT/BodyTXT/BH3_6_1"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="$BH3_7">
			<xsl:choose>
				<xsl:when test="($T='02') or ($T='17') or ($T='04') or ($T='46') or ($T='49')"/>
				<xsl:otherwise>
					<xsl:value-of select="document($BH3_7)/InvoiceTXT/BodyTXT/BH3_7_1"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="$BH4_1">
			<xsl:value-of select="document($BH4_1)/InvoiceTXT/BodyTXT/BH4_1_1"/>
		</xsl:if>
		<xsl:if test="$BH4_2">
			<xsl:choose>
				<xsl:when test="($T='46')">
					<xsl:value-of select="document($BH4_2)/InvoiceTXT/BodyTXT/BH3_2_3"/>
				</xsl:when>
				<xsl:when test="($T='01')">
					<xsl:value-of select="document($BH4_2)/InvoiceTXT/BodyTXT/BH4_2_1"/>
				</xsl:when>
				<xsl:when test="($T='41')">
					<!--Akt_101021-->
					<xsl:value-of select="document($BH4_2)/InvoiceTXT/BodyTXT/BH4_3_5"/>
				</xsl:when>
				<xsl:when test="($T='05')">
					<xsl:if test="contains(../InvProperty/BodyInformation,'C')">
						<xsl:value-of select="document($BH4_2)/InvoiceTXT/BodyTXT/BH4_2_1"/>
					</xsl:if>
				</xsl:when>
				<xsl:when test="($T='3B')">
					<xsl:value-of select="document($BH4_2)/InvoiceTXT/BodyTXT/BH4_2_2"/>
				</xsl:when>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="$BH4_3">
			<xsl:choose>
				<xsl:when test="not (../InvProperty/KontoSPP = '')"/>
				<xsl:when test="($T='05') or ($T='09') or ($T='10') or ($T='06') or ($T='39')">
					<!-- Akt_100808 -->
					<xsl:value-of select="document($BH4_3)/InvoiceTXT/BodyTXT/BH4_3_1"/>
				</xsl:when>
				<xsl:when test="($T='03')">
					<xsl:value-of select="document($BH4_3)/InvoiceTXT/BodyTXT/BH4_3_2"/>
				</xsl:when>
				<xsl:when test="($T='11')">
					<xsl:value-of select="document($BH4_3)/InvoiceTXT/BodyTXT/BH4_3_3"/>
				</xsl:when>
				<xsl:when test="($T='15') or ($T='16')">
					<xsl:value-of select="document($BH4_3)/InvoiceTXT/BodyTXT/BH4_3_4"/>
				</xsl:when>
				<xsl:when test="($T='23')">
					<xsl:value-of select="document($BH4_3)/InvoiceTXT/BodyTXT/BH4_3_5"/>
				</xsl:when>
				<xsl:when test="($T='25')">
					<xsl:value-of select="document($BH4_3)/InvoiceTXT/BodyTXT/BH4_3_6"/>
				</xsl:when>
				<xsl:when test="($T='01')">
					<xsl:value-of select="document($BH4_3)/InvoiceTXT/BodyTXT/BH4_3_7"/>
				</xsl:when>
				<xsl:when test="($T='06') or ($T='05')">
					<xsl:value-of select="document($BH4_3)/InvoiceTXT/BodyTXT/BH4_3_8"/>
				</xsl:when>
				<xsl:when test="($T='41')">
					<xsl:value-of select="document($BH4_3)/InvoiceTXT/BodyTXT/BH4_3_9"/>
				</xsl:when>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="$BH4_4">
			<xsl:choose>
				<xsl:when test="($T='48') or ($T='49')"/>
				<xsl:when test="($T='42')">
					<xsl:value-of select="document($BH4_4)/InvoiceTXT/BodyTXT/BH4_3_7"/>
				</xsl:when>
				<xsl:when test=" not (../InvProperty/KontoSPP = '')">
					<xsl:value-of select="document($BH4_4)/InvoiceTXT/BodyTXT/BH4_4_2"/>
				</xsl:when>
				<xsl:when test="($T='06') or ($T='05') or ($T='25') or ($T='10')">
					<xsl:value-of select="document($BH4_4)/InvoiceTXT/BodyTXT/BH4_4_1"/>
				</xsl:when>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="$BH4_5">
			<xsl:choose>
				<!--<xsl:when test="($T='02')"/>-->
				<xsl:when test="($T='11') or ($T='15') or ($T='16') or ($T='17')">
					<xsl:value-of select="document($BH4_5)/InvoiceTXT/BodyTXT/BH4_5_2"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="document($BH4_5)/InvoiceTXT/BodyTXT/BH4_5_1"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="$BH4_6">
			<xsl:choose>
				<xsl:when test="($T='17')"/>
				<xsl:otherwise>
					<xsl:value-of select="document($BH4_6)/InvoiceTXT/BodyTXT/BH4_6_1"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="$BH4_7">
			<xsl:choose>
				<xsl:when test="($T='02') or ($T='17') or ($T='04') or ($T='46') or ($T='49')"/>
				<xsl:when test="(not(../InvHeader/Payer/Organization) and (($T='26') or ($T='47')))"/>
				<xsl:otherwise>
					<xsl:value-of select="document($BH4_7)/InvoiceTXT/BodyTXT/BH4_7_1"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="$BUG_1">
			<xsl:choose>
				<xsl:when test="not (../../../../../../../InvProperty/KontoSPP = '') and (contains(../../../../../../../InvProperty/KontoSPP,ID))">
					<xsl:call-template name="UnderGroundField">
						<xsl:with-param name="TxtFile" select="$BUG_1"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="(../../ID='501')">
					<xsl:value-of select="document($BUG_1)/InvoiceTXT/BodyTXT/BUG_1_1"/>
					<xsl:value-of select="UnitProperty/Point"/>
				</xsl:when>
				<xsl:when test="(../../ID='106') or ($T='02') or (../../ID='402') or (../../ID='202') or (../../ID='201') or ($T='06') or ($T='05') or ($T='19') or ($T='10') or ($T='26')or ($T='39') or ($T='47') or (../../../../ID='501') or ($T='49')"/>
				<!-- Akt_100808 -->
				<xsl:otherwise>
					<xsl:call-template name="UnderGroundField">
						<xsl:with-param name="TxtFile" select="$BUG_1"/>
					</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="$BUG_2">
			<xsl:if test="($T='01') or ($T='03') or ($T='05') or ($T='06') or ($T='10') or ($T='11') or ($T='16') or ($T='25')  or ($T='42') or ($T='40') ">
				<!--Akt_101147-->
				<td/>
				<td colspan="4">
					<xsl:choose>
						<xsl:when test="($T='40')">
							<xsl:value-of select="document($BUG_2)/InvoiceTXT/BodyTXT/BUG_2_2"/>&nbsp;&nbsp;						
							<xsl:value-of select="Name"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="document($BUG_2)/InvoiceTXT/BodyTXT/BUG_2_1"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td align="right">
					<!--
					<xsl:if test="not(($T='06') or ($T='10'))">
						<xsl:call-template name="FormatNumber">
							<xsl:with-param name="Number" select="UnitValue/Value"/>
						</xsl:call-template>
					</xsl:if>
					-->
				</td>
				<td/>
				<td align="right">
					<xsl:call-template name="FormatNumberWithNull">
						<xsl:with-param name="Number" select="ServicePriceProperty/ServicePrice"/>
					</xsl:call-template>
				</td>
				<td align="right">
					<xsl:call-template name="FormatNumberWithNull">
						<xsl:with-param name="Number" select="ServicePriceProperty/BasicPrice"/>
					</xsl:call-template>
				</td>
				<td align="right">
					<xsl:call-template name="FormatNumberWithNull">
						<xsl:with-param name="Number" select="ServicePriceProperty/AdditionalPrice"/>
					</xsl:call-template>
				</td>
			</xsl:if>
		</xsl:if>
		<xsl:if test="$BUG_3">
			<xsl:choose>
				<xsl:when test="($T='46') ">
					<xsl:call-template name="FormatNumberWithNull">
						<xsl:with-param name="Number" select="NumberOfCase/Number"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="($T='01') or ($T='10') ">
					<xsl:call-template name="FormatNumberWithNull">
						<xsl:with-param name="Number" select="NumberOfCase/Number"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="($T='05')">
					<xsl:if test="contains(../../../../../../../InvProperty/BodyInformation,'C')">
						<xsl:call-template name="FormatNumberWithNull">
							<xsl:with-param name="Number" select="NumberOfCase/Number"/>
						</xsl:call-template>
					</xsl:if>
				</xsl:when>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="$BUG_4">
			<xsl:choose>
				<xsl:when test="($T='04') or ($T='46') or ($T='48')"/>
				<xsl:when test="not(($T='01') or ($T='10') or ($T='02') or ($T='05') or ($T='41') or ($T='43') or ($T='49'))">
					<xsl:call-template name="FormatNumberWithNull">
						<xsl:with-param name="Number" select="NumberOfCase/Number"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="($T='05')">
					<xsl:if test="not(../../../../../../../InvProperty/BodyInformation = 'C')">
						<xsl:call-template name="FormatNumberWithNull">
							<xsl:with-param name="Number" select="NumberOfCase/Number"/>
						</xsl:call-template>
					</xsl:if>
				</xsl:when>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="$BA_1">
			<xsl:if test="not($T='40')">
				<xsl:value-of select="ID"/>
			</xsl:if>
		</xsl:if>
		<xsl:if test="$BA_2">
			<xsl:if test="not($T='40')">
				<xsl:value-of select="Name"/>
			</xsl:if>
		</xsl:if>
		<xsl:if test="$BG_2">
			<!-- <xsl:if test="($T='01') or ($T='10')"> </xsl:if> -->
			<xsl:choose>
				<xsl:when test="(contains((../../../../../../../../../InvProperty/KontoSPP),(../../ID)) and contains((../../../../../../../../../InvProperty/KontoSPP),(../../../../../../ID)) or ($T='42') or ($T='48'))"/>
				<xsl:when test="($T='46')">
					<xsl:call-template name="FormatNumber">
						<xsl:with-param name="Number" select="UnitValue/Value"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="FormatNumber">
						<xsl:with-param name="Number" select="NumberOfCase/Number"/>
					</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="$BG_3">
			<xsl:if test="not($T='11')">
				<td>
					<xsl:value-of select="ID"/>
				</td>
				<td>
					<xsl:value-of select="Name"/>
				</td>
			</xsl:if>
			<xsl:if test="($T='11')">
				<xsl:choose>
					<xsl:when test="(ID='1111')">
						<td>
							<xsl:value-of select="Name"/>
						</td>
						<td/>
					</xsl:when>
					<xsl:otherwise>
						<td>
							<xsl:value-of select="ID"/>
						</td>
						<td>
							<xsl:value-of select="Name"/>
						</td>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
		</xsl:if>
		<xsl:if test="$BG_4">
			<xsl:choose>
				<xsl:when test="($T='48') or  ($T='49')"/>
				<xsl:when test="($T='11')">
					<xsl:choose>
						<xsl:when test="(ID='1111') or (ID='0091')"/>
						<xsl:otherwise>
							<xsl:call-template name="FormatNumber">
								<xsl:with-param name="Number" select="UnitValue/Value"/>
							</xsl:call-template>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:when test="($T='19') or  ($T='26') or  ($T='VOZ') or ($T='11') or ($T='43') or ($T='47') "/>
				<xsl:when test="contains((../../../../../../../../../InvProperty/KontoSPP),(../../ID)) and contains((../../../../../../../../../InvProperty/KontoSPP),(../../../../../../ID))">
					<xsl:call-template name="FormatNumber">
						<xsl:with-param name="Number" select="NumberOfCase/Number"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="($T='42')">
					<xsl:call-template name="FormatNumber">
						<xsl:with-param name="Number" select="NumberOfCase/Number"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="($T='46')">
					<xsl:call-template name="FormatNumber">
						<xsl:with-param name="Number" select="OperationPrice"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="FormatNumber">
						<xsl:with-param name="Number" select="UnitValue/Value"/>
					</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="$BG_5">
			<xsl:choose>
				<xsl:when test="($T='48') or ($T='49')"/>
				<xsl:when test="contains((../../../../../../../../../InvProperty/KontoSPP),(../../ID)) and contains((../../../../../../../../../InvProperty/KontoSPP),(../../../../../../ID))">
					<xsl:call-template name="FormatNumber">
						<xsl:with-param name="Number" select="UnitValue/Value"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="($T='42')">
					<xsl:call-template name="FormatNumber">
						<xsl:with-param name="Number" select="UnitValue/Value"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="($T='25') or ($T='06') or ($T='05') or ($T='10')">
					<xsl:call-template name="FormatNumberWithNull">
						<xsl:with-param name="Number" select="OperationPrice"/>
					</xsl:call-template>
				</xsl:when>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="$BG_6">
			<!--<xsl:if test="not ($T='02')">-->
			<xsl:call-template name="FormatNumberWithNull">
				<xsl:with-param name="Number" select="ServicePriceProperty/ServicePrice"/>
			</xsl:call-template>
			<!--</xsl:if>-->
		</xsl:if>
		<xsl:if test="$BG_7">
			<xsl:call-template name="FormatNumberWithNull">
				<xsl:with-param name="Number" select="ServicePriceProperty/BasicPrice"/>
			</xsl:call-template>
		</xsl:if>
		<xsl:if test="$BG_8">
			<xsl:if test="not (($T='02') or ($T='04') or ($T='46') or ($T='49'))">
				<xsl:call-template name="FormatNumberWithNull">
					<xsl:with-param name="Number" select="ServicePriceProperty/AdditionalPrice"/>
				</xsl:call-template>
			</xsl:if>
		</xsl:if>
		<xsl:if test="$BF_1">
			<xsl:choose>
				<!-- 20.07.2005
				<xsl:when test="(../InvProperty/StornoDocument='D') or contains(../InvFooter/ServicePriceProperty/ServicePrice,'-') or contains(../InvFooter/ServicePriceProperty/BasicPrice,'-') or contains(../InvFooter/ServicePriceProperty/AdditionalPrice,'-')">
					test<xsl:value-of select="document($BF_1)/InvoiceTXT/SpecTXT/SpecAccountBody/BF6_1_2"/>
				</xsl:when>
			-->
				<xsl:when test="($T='03') or ($T='05') or ($T='01') or ($T='06')">
					<xsl:value-of select="document($BF_1)/InvoiceTXT/BodyTXT/BF_1_1"/>
				</xsl:when>
				<xsl:when test="($T='42')">
					<xsl:value-of select="document($BF_1)/InvoiceTXT/BodyTXT/BF_1_6"/>
				</xsl:when>
				<xsl:when test="($T='08') or ($T='09') or ($T='10') or ($T='12') or ($T='19') or ($T='23') or ($T='25') or ($T='26') or ($T='VOZ') or ($T='04') or ($T='41') or ($T='43') or ($T='45') or ($T='47') or ($T='48') or ($T='49') ">
					<!--Akt_101021-->
					<xsl:choose>
						<xsl:when test="(../InvProperty/StornoDocument='D') or contains(../InvFooter/ServicePriceProperty/ServicePrice,'-') or contains(../InvFooter/ServicePriceProperty/BasicPrice,'-') or contains(../InvFooter/ServicePriceProperty/AdditionalPrice,'-')">
							<xsl:value-of select="document($BF_1)/InvoiceTXT/BodyTXT/BF_1_4"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:choose>
								<xsl:when test="$HomeCurrency">
									<xsl:value-of select="document($BF_1)/InvoiceTXT/BodyTXT/BF_1_5"/>
									<xsl:value-of select="../InvFooter/ServicePriceProperty/Currency"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="document($BF_1)/InvoiceTXT/BodyTXT/BF_1_2"/>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:when test="($T='11') or ($T='15') or ($T='16') or ($T='17')">
					<xsl:value-of select="document($BF_1)/InvoiceTXT/BodyTXT/BF_1_3"/>
				</xsl:when>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="$BF_2">
			<xsl:choose>
				<xsl:when test="($T='17')">
					<xsl:value-of select="../InvFooter/ServicePriceProperty/ServicePrice"/>
				</xsl:when>
				<xsl:when test="($T='02') or ($T='04') or ($T='49')">
					<xsl:call-template name="FormatNumberWithNull">
						<xsl:with-param name="Number" select="../InvFooter/ServicePriceProperty/ServicePrice"/>
					</xsl:call-template>
				</xsl:when>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="$BF_3">
			<xsl:choose>
				<xsl:when test="not(($T='17') or ($T='26') or ($T='42') or ($T='43') or ($T='47'))">
					<xsl:call-template name="FormatNumberWithNull">
						<xsl:with-param name="Number" select="../InvFooter/ServicePriceProperty/BasicPrice"/>
					</xsl:call-template>
				</xsl:when>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="$BF_4">
			<xsl:choose>
				<xsl:when test="($T='26') or ($T='42') or ($T='43') or ($T='47')">
					<xsl:call-template name="FormatNumberWithNull">
						<xsl:with-param name="Number" select="../InvFooter/ServicePriceProperty/AdditionalPrice"/>
					</xsl:call-template>
				</xsl:when>
			</xsl:choose>
		</xsl:if>
		<!--
		<xsl:if test="$BF_4">
			<xsl:if test="($T='11') or ($T='15') or ($T='16') or ($T='17')">
				<xsl:value-of select="document($BF_4)/InvoiceTXT/BodyTXT/BF_2_1"/>
			</xsl:if>
		</xsl:if>
		<xsl:if test="$BF_5">
			<xsl:if test="($T='17')">
				<xsl:value-of select="ServicePriceProperty/DDV_High"/>
			</xsl:if>
		</xsl:if>
		<xsl:if test="$BF_6">
			<xsl:if test="not($T='17')">
				<xsl:value-of select="ServicePriceProperty/DDV_High"/>
			</xsl:if>
		</xsl:if>
		<xsl:if test="$BF_7">
			<xsl:if test="($T='11') or ($T='15') or ($T='16') or ($T='17')">
				<xsl:value-of select="document($BF_7)/InvoiceTXT/BodyTXT/BF_3_1"/>
			</xsl:if>
		</xsl:if>
		<xsl:if test="$BF_8">
			<xsl:if test="($T='17')">
				<xsl:value-of select="ServicePriceProperty/DDV_Low"/>
			</xsl:if>
		</xsl:if>
		<xsl:if test="$BF_9">
			<xsl:if test="not($T='17')">
				<xsl:value-of select="ServicePriceProperty/DDV_Low"/>
			</xsl:if>
		</xsl:if>
		-->
	</xsl:template>
	<xsl:template name="TaxText">
		<xsl:param name="TxtFile"/>
		<xsl:param name="Level"/>
		<xsl:param name="Percent"/>
		<xsl:param name="Currency"/>
		<xsl:value-of select="format-number($Percent, '#0,#', 'european')"/>%&nbsp;-&nbsp;
		<xsl:choose>
			<xsl:when test="($Level = 1)">
				<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BF3_1_2"/>
			</xsl:when>
			<xsl:when test="($Level = 2)">
				<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BF4_1_2"/>
			</xsl:when>
			<xsl:when test="($Level = 99)">
				<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BF4_3_3"/>
			</xsl:when>
			<xsl:when test="($Level = 98)">
				<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BF4_3_4"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BF3_1_2"/>
				<!-- zniana stopnja po defaultu-->
			</xsl:otherwise>
		</xsl:choose>
		<xsl:value-of select="$Currency"/>
	</xsl:template>
</xsl:stylesheet>
