<?xml version="1.0" encoding="Windows-1250"?>
<!-- edited with XMLSPY v5 rel. 2 U (http://www.xmlspy.com) by Goran (Infonet Kranj d.o.o.) -->
<!-- edited with XMLSpy v2006 U (http://www.altova.com) by goran (EMBRACE) -->
<!DOCTYPE xsl:stylesheet [
	<!ENTITY nbsp "&#160;">
]>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:template match="InvHeader" mode="DocHeader">
		<xsl:param name="Type"/>
		<xsl:param name="TxtFile"/>
		<table width="650" border="0" cellspacing="0" cellpadding="0" style="font-size: 11px;">
			<xsl:if test="contains(../InvProperty/HeaderInformation,'LOGO=')">
				<tr>
					<td colspan="4">
						<img src="{substring-before(substring-after(../InvProperty/HeaderInformation , 'LOGO=') , ';')}"/>
					</td>
				</tr>
			</xsl:if>
			<xsl:choose>
				<xsl:when test="../InvProperty/HeaderPerformer='true'">
					<tr>
						<td colspan="4">
							<xsl:if test="not (contains(../InvProperty/HeaderInformation,'DNP:ORG'))">
								<xsl:value-of select="Performer/Organization/Name"/>
							</xsl:if>&nbsp;
						</td>
					</tr>
					<xsl:choose>
						<xsl:when test="(../InvProperty/PerformerDestination='true')">
							<tr>
								<td colspan="4">
									<xsl:if test="not( contains(../InvProperty/HeaderInformation,'DNP:NAS'))">
										<xsl:value-of select="Performer/Organization/Address/Street"/>,&nbsp;&nbsp;
								</xsl:if>&nbsp;
									<xsl:if test="not (contains(../InvProperty/HeaderInformation,'DNP:PS'))">
										<xsl:value-of select="Performer/Organization/Address/PostalOffice/Code"/>&nbsp;&nbsp;
									</xsl:if>&nbsp;
									<xsl:if test="not( contains(../InvProperty/HeaderInformation,'DNP:KR'))">
										<xsl:value-of select="Performer/Organization/Address/PostalOffice/Name"/>
									</xsl:if>&nbsp;
								</td>
							</tr>
						</xsl:when>
						<xsl:when test="Performer/Organization/AdditionName != ''">
							<tr>
								<td colspan="4">
									<xsl:if test="not(contains(../InvProperty/HeaderInformation,'DNP:DN'))">
										<xsl:value-of select="Performer/Organization/AdditionName"/>
									</xsl:if>&nbsp;
								</td>
							</tr>
						</xsl:when>
					</xsl:choose>
					<tr>
						<td colspan="4">
							<xsl:choose>
								<xsl:when test="(../InvProperty/PerformerDestination='true')">
									<xsl:if test="not(contains(../InvProperty/HeaderInformation,'DNP:DDV'))">
										<xsl:call-template name="HeadRules">
											<xsl:with-param name="T" select="$Type"/>
											<xsl:with-param name="H5_1" select="$TxtFile"/>
										</xsl:call-template>&nbsp;
										<xsl:value-of select="Performer/Organization/TaxID"/>
									</xsl:if>&nbsp;
								</xsl:when>
								<xsl:otherwise>
									<xsl:if test="not(contains(../InvProperty/HeaderInformation,'DNP:NAS'))">
										<xsl:value-of select="Performer/Organization/Address/Street"/>
									</xsl:if>&nbsp;
								</xsl:otherwise>
							</xsl:choose>
						</td>
					</tr>
					<tr>
						<td colspan="4">
							<xsl:choose>
								<xsl:when test="(../InvProperty/PerformerDestination='true')">&nbsp;</xsl:when>
								<xsl:otherwise>
									<xsl:if test="not(contains(../InvProperty/HeaderInformation,'DNP:PS'))">
										<xsl:value-of select="Performer/Organization/Address/PostalOffice/Code"/>&nbsp;&nbsp;
									</xsl:if>&nbsp;
									<xsl:if test="not(contains(../InvProperty/HeaderInformation,'DNP:KR'))">
										<xsl:value-of select="Performer/Organization/Address/PostalOffice/Name"/>
									</xsl:if>&nbsp;
								</xsl:otherwise>
							</xsl:choose>
						</td>
					</tr>
					<tr>
						<td colspan="4">
							<xsl:choose>
								<xsl:when test="(../InvProperty/PerformerDestination='true')">
									<xsl:value-of select="Performer/Destination/Name"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:if test="not(contains(../InvProperty/HeaderInformation,'DNP:DDV'))">
										<xsl:call-template name="HeadRules">
											<xsl:with-param name="T" select="$Type"/>
											<xsl:with-param name="H5_1" select="$TxtFile"/>
										</xsl:call-template>&nbsp;
										<xsl:value-of select="Performer/Organization/TaxID"/>
									</xsl:if>&nbsp;
								</xsl:otherwise>
							</xsl:choose>
						</td>
					</tr>
					<tr>
						<td colspan="4">
							<xsl:choose>
								<xsl:when test="(../InvProperty/PerformerDestination='true')">
									<xsl:value-of select="Performer/Destination/Address/Street"/>,&nbsp;&nbsp;					
									<xsl:value-of select="Performer/Destination/Address/PostalOffice/Code"/>&nbsp;&nbsp;
									<xsl:value-of select="Performer/Destination/Address/PostalOffice/Name"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:if test="not(contains(../InvProperty/HeaderInformation,'DNP:TR'))">
										<xsl:call-template name="HeadRules">
											<xsl:with-param name="T" select="$Type"/>
											<xsl:with-param name="H4_1" select="$TxtFile"/>
										</xsl:call-template>&nbsp;
										<xsl:value-of select="Performer/Organization/AccountID"/>
									</xsl:if>&nbsp;
								</xsl:otherwise>
							</xsl:choose>
						</td>
					</tr>
					<tr>
						<td colspan="2">
							<xsl:choose>
								<xsl:when test="(../InvProperty/PerformerDestination='true')">
									<xsl:call-template name="HeadRules">
										<xsl:with-param name="T" select="$Type"/>
										<xsl:with-param name="H4_1" select="$TxtFile"/>
									</xsl:call-template>&nbsp;
									<xsl:value-of select="Performer/Destination/AccountID"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:if test="not(contains(../InvProperty/HeaderInformation,'DNP:TR'))">
										<xsl:call-template name="HeadRules">
											<xsl:with-param name="T" select="$Type"/>
											<xsl:with-param name="H6_1" select="$TxtFile"/>
										</xsl:call-template>&nbsp;
										<xsl:value-of select="Performer/Organization/BICID"/>
									</xsl:if>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td>
							<b>
								<xsl:call-template name="HeadRules">
									<xsl:with-param name="T" select="$Type"/>
									<xsl:with-param name="H7_2" select="$TxtFile"/>
								</xsl:call-template>
							</b>
						</td>
						<td>
							<xsl:value-of select="Document/ID"/>
						</td>
					</tr>
					<xsl:if test="(../InvProperty/StornoDocument = 'D') and (../InvProperty/VezniDocument != '') and not ($Type='42')">
						<tr>
							<td colspan="2"/>
							<td>Vezni dokument:</td>
							<td>
								<xsl:value-of select="../InvProperty/VezniDocument"/>
							</td>
						</tr>
					</xsl:if>
				</xsl:when>
				<xsl:otherwise>
					<tr>
						<td colspan="4">&nbsp;</td>
					</tr>
					<tr>
						<td colspan="4">&nbsp;</td>
					</tr>
					<tr>
						<td colspan="2"/>
						<td>
							<b>
								<xsl:call-template name="HeadRules">
									<xsl:with-param name="T" select="$Type"/>
									<xsl:with-param name="H7_2" select="$TxtFile"/>
								</xsl:call-template>
							</b>
						</td>
						<td>
							<xsl:value-of select="Document/ID"/>
						</td>
					</tr>
					<xsl:if test="(../InvProperty/StornoDocument = 'D') and (../InvProperty/VezniDocument != '')">
						<tr>
							<td colspan="2"/>
							<td>Vezni dokument:</td>
							<td>
								<xsl:value-of select="../InvProperty/VezniDocument"/>
							</td>
						</tr>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
			<tr>
				<td colspan="2">
					<xsl:choose>
						<xsl:when test="(../InvProperty/PerformerDestination='true')">
							<xsl:call-template name="HeadRules">
								<xsl:with-param name="T" select="$Type"/>
								<xsl:with-param name="H6_1" select="$TxtFile"/>
							</xsl:call-template>&nbsp;
										<xsl:value-of select="Performer/Organization/BICID"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:choose>
								<xsl:when test="(Performer/Organization/PhoneNumber != '')">
									<xsl:if test="not(contains(../InvProperty/HeaderInformation,'DNP:TEL'))">
										<xsl:value-of select="Performer/Organization/PhoneNumber"/>
									</xsl:if>&nbsp;
										</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="Performer/Destination/Name"/>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td>
					<xsl:call-template name="HeadRules">
						<xsl:with-param name="T" select="$Type"/>
						<xsl:with-param name="H8_2" select="$TxtFile"/>
					</xsl:call-template>
				</td>
				<td>
					<xsl:value-of select="Document/PlaceEdition"/>
				</td>
			</tr>
			<tr>
				<td colspan="2"/>
				<!-- Payer/Organization/Name-->
				<td>
					<xsl:call-template name="HeadRules">
						<xsl:with-param name="T" select="$Type"/>
						<xsl:with-param name="H9_2" select="$TxtFile"/>
					</xsl:call-template>
				</td>
				<td>
					<xsl:call-template name="FormatDate">
						<xsl:with-param name="Date" select="Document/InvDate"/>
					</xsl:call-template>
				</td>
			</tr>
			<xsl:if test="contains(../InvProperty/HeaderInformation,'ZZZS')">
				<xsl:choose>
					<xsl:when test="contains(../InvProperty/HeaderInformation,'DATE_DUR')">
						<tr>
							<td colspan="2">
								<!-- KK 17.11.03 -->
								<!--xsl:value-of select="Payer/Organization/Name"/-->
							</td>
							<td>
								<xsl:choose>
									<xsl:when test="contains(../InvProperty/HeaderInformation,'DATE_L')">
										<xsl:value-of select="document($TxtFile)/InvoiceTXT/HeadTXT/H10_2_7"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="document($TxtFile)/InvoiceTXT/HeadTXT/H10_2_4"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
							<td>
								<xsl:call-template name="FormatDate">
									<xsl:with-param name="Date" select="Document/InvDateDUR"/>
								</xsl:call-template>
							</td>
						</tr>
					</xsl:when>
					<xsl:otherwise/>
				</xsl:choose>
			</xsl:if>
			<tr>
				<td colspan="2">
					<xsl:if test="(not($Type='39')) and (not($Type='40')) ">
						<!-- ML, 10.05.2012, Akt_103846: Dopolnitev izpisa raunov - BIC, IBAN-->
						<xsl:value-of select="Payer/Organization/Name"/>
					</xsl:if>
				</td>
				<xsl:call-template name="HeadRules">
					<xsl:with-param name="T" select="$Type"/>
					<xsl:with-param name="H10_2" select="$TxtFile"/>
				</xsl:call-template>
			</tr>
			<tr>
				<td colspan="2">
					<xsl:if test="(not($Type='39')) and (not($Type='40')) ">
						<!-- ML, 10.05.2012, Akt_103846: Dopolnitev izpisa raunov - BIC, IBAN-->
						<xsl:value-of select="Payer/Organization/Address/Street"/>
					</xsl:if>
				</td>
				<xsl:choose>
					<xsl:when test="(contains(../InvProperty/HeaderInformation,'ZZZS')) and (($Type='P01') or ($Type='P02') or ($Type='P03') or ($Type='S01') or ($Type='DDDDD') or ($Type='BBBBB') or ($Type='40') or ($Type='44') or ($Type='ER'))">
						<!--Akt_100886-->
						<td>
							<xsl:call-template name="HeadRules">
								<xsl:with-param name="T" select="$Type"/>
								<xsl:with-param name="H12_2" select="$TxtFile"/>
							</xsl:call-template>
						</td>
						<td>
							<xsl:call-template name="FormatDate">
								<xsl:with-param name="Date" select="Document/InvDateFrom"/>
							</xsl:call-template> -
								<xsl:call-template name="FormatDate">
								<xsl:with-param name="Date" select="Document/InvDateTo"/>
							</xsl:call-template>
						</td>
					</xsl:when>
					<xsl:otherwise>
						<td>
							<xsl:call-template name="HeadRules">
								<xsl:with-param name="T" select="$Type"/>
								<xsl:with-param name="H11_2" select="$TxtFile"/>
							</xsl:call-template>
						</td>
						<td>
							<xsl:call-template name="FormatDate">
								<xsl:with-param name="Date" select="Document/DateExpiration"/>
							</xsl:call-template>
						</td>
					</xsl:otherwise>
				</xsl:choose>
			</tr>
			<xsl:choose>
				<xsl:when test="($Type='P01') or ($Type='P02') or ($Type='P03') or ($Type='S01') or ($Type='DDDDD') or ($Type='BBBBB') or ($Type='40') or ($Type='44') or ($Type='ER')">
					<!--Akt_100886-->
					<xsl:if test="contains(../InvProperty/HeaderInformation,'ZZZS')"/>
				</xsl:when>
				<xsl:otherwise>
					<tr>
						<td colspan="2">
							<!-- ML, 10.05.2012, Akt_103846: Dopolnitev izpisa raunov - BIC, IBAN-->
							<xsl:if test="(not($Type='39')) and (not($Type='40')) ">
								<xsl:value-of select="Payer/Organization/Address/PostalOffice/Code"/>&nbsp;&nbsp;
						<xsl:value-of select="Payer/Organization/Address/PostalOffice/Name"/>
							</xsl:if>
						</td>
						<td>
							<xsl:call-template name="HeadRules">
								<xsl:with-param name="T" select="$Type"/>
								<xsl:with-param name="H12_2" select="$TxtFile"/>
							</xsl:call-template>
						</td>
						<td>
							<xsl:call-template name="FormatDate">
								<xsl:with-param name="Date" select="Document/InvDateFrom"/>
							</xsl:call-template> -
							<xsl:call-template name="FormatDate">
								<xsl:with-param name="Date" select="Document/InvDateTo"/>
							</xsl:call-template>
						</td>
					</tr>
				</xsl:otherwise>
			</xsl:choose>
			<tr>
				<td colspan="2"/>
				<xsl:choose>
					<xsl:when test="($Type='P01') or ($Type='P02') or ($Type='P03') or ($Type='S01') or ($Type='DDDDD') or ($Type='BBBBB') or ($Type='S01') or ($Type='44') or ($Type='ER')">
						<!--Akt_100886-->
						<xsl:if test="contains(../InvProperty/HeaderInformation,'ZZZS')"/>
					</xsl:when>
					<xsl:otherwise>
						<td>
							<xsl:call-template name="HeadRules">
								<xsl:with-param name="T" select="$Type"/>
								<xsl:with-param name="H13_2" select="$TxtFile"/>
							</xsl:call-template>
						</td>
						<td>
							<xsl:value-of select="Document/ServiceYear"/>
						</td>
					</xsl:otherwise>
				</xsl:choose>
			</tr>
			<tr>
				<xsl:choose>
					<xsl:when test="($Type='P01') or ($Type='P02') or ($Type='P03') or ($Type='S01') or (Payer/Destination/Address/Street = '') or ($Type='34') or ($Type='38') or ($Type='33')  or ($Type='DDDDD') or ($Type='BBBBB') or ($Type='39') or ($Type='40') or ($Type='44') or ($Type='ER')">
						<!-- Akt_100808 -->
						<!--Akt_100886-->
						<td colspan="2"/>
					</xsl:when>
					<xsl:otherwise>
						<td colspan="2">
							<xsl:call-template name="HeadRules">
								<xsl:with-param name="T" select="$Type"/>
								<xsl:with-param name="H11_1" select="$TxtFile"/>
							</xsl:call-template>
						</td>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:choose>
					<xsl:when test="($Type='P01') or ($Type='P02') or ($Type='P03') or ($Type='S01') or ($Type='DDDDD') or ($Type='BBBBB')  or ($Type='40') or ($Type='44') or ($Type='ER')">
						<!--Akt_100886-->
						<xsl:choose>
							<xsl:when test="contains(../InvProperty/HeaderInformation,'ZZZS')">
								<!-- KK 17.11.03 -->
								<td>
									<xsl:call-template name="HeadRules">
										<xsl:with-param name="T" select="$Type"/>
										<xsl:with-param name="H16_2" select="$TxtFile"/>
									</xsl:call-template>
								</td>
								<td>
									<xsl:value-of select="Payer/Destination/ConvocationID"/>
								</td>
							</xsl:when>
							<xsl:otherwise>
								<td>
									<xsl:call-template name="HeadRules">
										<xsl:with-param name="T" select="$Type"/>
										<xsl:with-param name="H16_2" select="$TxtFile"/>
									</xsl:call-template>
								</td>
								<td>
									<xsl:value-of select="Payer/Destination/ConvocationID"/>
								</td>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<td>
							<xsl:call-template name="HeadRules">
								<xsl:with-param name="T" select="$Type"/>
								<xsl:with-param name="H14_2" select="$TxtFile"/>
							</xsl:call-template>
						</td>
						<td>
							<xsl:value-of select="Performer/Organization/ID"/>
						</td>
					</xsl:otherwise>
				</xsl:choose>
			</tr>
			<tr>
				<td width="5%"/>
				<td width="50%" style="font-size: 13px;">
					<xsl:choose>
						<xsl:when test="../InvProperty/BoldAddress='true'">
							<b>
								<xsl:value-of select="Payer/Destination/Name"/>
							</b>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="Payer/Destination/Name"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<xsl:choose>
					<xsl:when test="($Type='P01') or ($Type='P02') or ($Type='P03') or ($Type='S01') or ($Type='DDDDD') or ($Type='BBBBB')  or ($Type='40') or ($Type='44') or ($Type='ER')">
						<!--Akt_100886-->
						<xsl:choose>
							<xsl:when test="contains(../InvProperty/HeaderInformation,'ZZZS')">
								<!-- KK 17.11.03
								<td>
									<xsl:call-template name="HeadRules">
										<xsl:with-param name="T" select="$Type"/>
										<xsl:with-param name="H16_2" select="$TxtFile"/>
									</xsl:call-template>
								</td>
								<td>
									<xsl:value-of select="Payer/Destination/ConvocationID"/>
								</td>
								 -->
								<td>
									<xsl:call-template name="HeadRules">
										<xsl:with-param name="T" select="$Type"/>
										<xsl:with-param name="H17_2" select="$TxtFile"/>
									</xsl:call-template>
								</td>
								<td>
									<xsl:value-of select="Payer/Destination/TaxID"/>
								</td>
							</xsl:when>
							<xsl:otherwise>
								<td>
									<xsl:call-template name="HeadRules">
										<xsl:with-param name="T" select="$Type"/>
										<xsl:with-param name="H17_2" select="$TxtFile"/>
									</xsl:call-template>
								</td>
								<td>
									<xsl:value-of select="Payer/Destination/TaxID"/>
								</td>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<td width="20%">
							<xsl:call-template name="HeadRules">
								<xsl:with-param name="T" select="$Type"/>
								<xsl:with-param name="H15_2" select="$TxtFile"/>
							</xsl:call-template>
						</td>
						<td width="25%">
							<xsl:value-of select="Payer/Destination/ID"/>
						</td>
					</xsl:otherwise>
				</xsl:choose>
			</tr>
			<xsl:choose>
				<xsl:when test="(Payer/Destination/AdditionalName != '')">
					<tr>
						<td/>
						<td style="font-size: 13px;">
							<xsl:choose>
								<xsl:when test="../InvProperty/BoldAddress='true'">
									<b>
										<xsl:value-of select="Payer/Destination/AdditionalName"/>
									</b>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="Payer/Destination/AdditionalName"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<xsl:choose>
							<xsl:when test="($Type='P01') or ($Type='P02') or ($Type='P03') or ($Type='S01') or ($Type='DDDDD') or ($Type='BBBBB') or ($Type='40') or ($Type='44') or ($Type='ER')">
								<!--Akt_100886-->
								<!-- KK 17.11.03
								<xsl:if test="contains(../InvProperty/HeaderInformation,'ZZZS')">
									
									<td>
										<xsl:call-template name="HeadRules">
											<xsl:with-param name="T" select="$Type"/>
											<xsl:with-param name="H17_2" select="$TxtFile"/>
										</xsl:call-template>
									</td>
									<td>
										<xsl:value-of select="Payer/Destination/TaxID"/>
									</td>
								
								</xsl:if>
									-->
								<xsl:if test="(Payer/Destination/AdditionalName1 != '')">
									<tr>
										<td/>
										<td style="font-size: 13px;">
											<xsl:choose>
												<xsl:when test="../InvProperty/BoldAddress='true'">
													<b>
														<xsl:value-of select="Payer/Destination/AdditionalName1"/>
													</b>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="Payer/Destination/AdditionalName1"/>
												</xsl:otherwise>
											</xsl:choose>
										</td>
									</tr>
								</xsl:if>
								<xsl:if test="(Payer/Destination/AdditionalName2 != '')">
									<tr>
										<td/>
										<td style="font-size: 13px;">
											<xsl:choose>
												<xsl:when test="../InvProperty/BoldAddress='true'">
													<b>
														<xsl:value-of select="Payer/Destination/AdditionalName2"/>
													</b>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="Payer/Destination/AdditionalName2"/>
												</xsl:otherwise>
											</xsl:choose>
										</td>
									</tr>
								</xsl:if>
							</xsl:when>
							<xsl:otherwise>
								<td>
									<xsl:call-template name="HeadRules">
										<xsl:with-param name="T" select="$Type"/>
										<xsl:with-param name="H16_2" select="$TxtFile"/>
									</xsl:call-template>
								</td>
								<td>
									<xsl:value-of select="Payer/Destination/ConvocationID"/>
								</td>
							</xsl:otherwise>
						</xsl:choose>
					</tr>
					<tr>
						<td/>
						<td style="font-size: 13px;">
							<xsl:choose>
								<xsl:when test="../InvProperty/BoldAddress='true'">
									<b>
										<xsl:value-of select="Payer/Destination/Address/Street"/>
									</b>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="Payer/Destination/Address/Street"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<xsl:choose>
							<xsl:when test="($Type='P01') or ($Type='P02') or ($Type='P03') or ($Type='S01') or ($Type='DDDDD') or ($Type='BBBBB')  or ($Type='40') or ($Type='44') or ($Type='ER')"/>
							<!--Akt_100886-->
							<xsl:otherwise>
								<td>
									<xsl:call-template name="HeadRules">
										<xsl:with-param name="T" select="$Type"/>
										<xsl:with-param name="H17_2" select="$TxtFile"/>
									</xsl:call-template>
								</td>
								<td>
									<xsl:value-of select="Payer/Destination/TaxID"/>
								</td>
							</xsl:otherwise>
						</xsl:choose>
					</tr>
					<tr>
						<td colspan="4">&nbsp;</td>
					</tr>
				</xsl:when>
				<xsl:otherwise>
					<tr>
						<td/>
						<td style="font-size: 13px;">
							<xsl:choose>
								<xsl:when test="../InvProperty/BoldAddress='true'">
									<b>
										<xsl:value-of select="Payer/Destination/Address/Street"/>
									</b>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="Payer/Destination/Address/Street"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<xsl:choose>
							<xsl:when test="($Type='P01') or ($Type='P02') or ($Type='P03') or ($Type='S01') or ($Type='DDDDD') or ($Type='BBBBB') or ($Type='40') or ($Type='44') or ($Type='ER')">
								<!--Akt_100886-->
								<xsl:if test="contains(../InvProperty/HeaderInformation,'ZZZS')">
									<!-- KK 17.11.03
									<td>
										<xsl:call-template name="HeadRules">
											<xsl:with-param name="T" select="$Type"/>
											<xsl:with-param name="H17_2" select="$TxtFile"/>
										</xsl:call-template>
									</td>
									<td>
										<xsl:value-of select="Payer/Destination/TaxID"/>
									</td>
									-->
								</xsl:if>
							</xsl:when>
							<xsl:otherwise>
								<td>
									<xsl:call-template name="HeadRules">
										<xsl:with-param name="T" select="$Type"/>
										<xsl:with-param name="H16_2" select="$TxtFile"/>
									</xsl:call-template>
								</td>
								<td>
									<xsl:value-of select="Payer/Destination/ConvocationID"/>
								</td>
							</xsl:otherwise>
						</xsl:choose>
					</tr>
					<xsl:choose>
						<xsl:when test="($Type='P01') or ($Type='P02')  or ($Type='P03') or ($Type='S01') or ($Type='DDDDD') or ($Type='BBBBB') or ($Type='40') or ($Type='44') or ($Type='ER')">
							<!--Akt_100886-->
							<tr>
								<td colspan="4">&nbsp;</td>
							</tr>
						</xsl:when>
					</xsl:choose>
					<tr>
						<td colspan="2"/>
						<xsl:choose>
							<xsl:when test="($Type='P01') or ($Type='P02') or ($Type='P03') or ($Type='S01') or ($Type='DDDDD') or ($Type='BBBBB') or ($Type='40') or ($Type='44') or ($Type='ER')"/>
							<!--Akt_100886-->
							<xsl:otherwise>
								<td>
									<xsl:call-template name="HeadRules">
										<xsl:with-param name="T" select="$Type"/>
										<xsl:with-param name="H17_2" select="$TxtFile"/>
									</xsl:call-template>
								</td>
								<td>
									<xsl:value-of select="Payer/Destination/TaxID"/>
								</td>
							</xsl:otherwise>
						</xsl:choose>
					</tr>
				</xsl:otherwise>
			</xsl:choose>
			<tr>
				<td/>
				<td style="font-size: 13px;">
					<xsl:choose>
						<xsl:when test="../InvProperty/BoldAddress='true'">
							<b>
								<xsl:value-of select="Payer/Destination/Address/PostalOffice/Code"/>&nbsp;&nbsp;&nbsp;
								<xsl:value-of select="Payer/Destination/Address/PostalOffice/Name"/>
							</b>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="Payer/Destination/Address/PostalOffice/Code"/>&nbsp;&nbsp;&nbsp;
							<xsl:value-of select="Payer/Destination/Address/PostalOffice/Name"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<xsl:choose>
					<xsl:when test="($Type='42') or ($Type='43')">
						<td colspan="2">
							<xsl:choose>
								<xsl:when test="(../InvProperty/StornoDocument = 'D') and (../InvProperty/VezniDocument != '')">
									<xsl:value-of select="document($TxtFile)/InvoiceTXT/HeadTXT/H19_2_1"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="document($TxtFile)/InvoiceTXT/HeadTXT/H18_2_1"/>
								</xsl:otherwise>
							</xsl:choose>
							<xsl:value-of select="../InvProperty/VezniDocument"/>
						</td>
					</xsl:when>
					<xsl:otherwise>
						<td colspan="2"/>
					</xsl:otherwise>
				</xsl:choose>
			</tr>
			<!-- //ML, 18.10.2016, Nap_21576: Drava na dokumentih v RAFu-->
			<xsl:if test="not(../InvBody/BodyProperty/Country/ID = '705') and (../InvBody/BodyProperty/Country/Name != '')">
				<tr>
					<td/>
					<td style="font-size: 13px;">
						<xsl:choose>
							<xsl:when test="../InvProperty/BoldAddress='true'">
								<b>
									<xsl:value-of select="../InvBody/BodyProperty/Country/Name"/>&nbsp;&nbsp;&nbsp;&nbsp;
								
							</b>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="../InvBody/BodyProperty/Country/Name"/>&nbsp;&nbsp;&nbsp;&nbsp;
						</xsl:otherwise>
						</xsl:choose>
					</td>
				</tr>
			</xsl:if>
			<tr>
				<td colspan="4">&nbsp;</td>
			</tr>
			<tr>
				<!-- Akt_100808 -->
				<xsl:choose>
					<xsl:when test="($Type='39')">
						<td colspan="4">
							<xsl:value-of select="Payer/Destination/AdditionalName2"/>
						</td>
					</xsl:when>
					<xsl:otherwise>
						<td colspan="4">&nbsp;</td>
					</xsl:otherwise>
				</xsl:choose>
			</tr>
			<tr>
				<td colspan="4">&nbsp;</td>
			</tr>
			<tr>
				<td colspan="4">&nbsp;</td>
			</tr>
			<tr>
				<td colspan="4">&nbsp;</td>
			</tr>
			<xsl:choose>
				<xsl:when test="($Type='P01') or ($Type='P02') or ($Type='P03') or ($Type='S01') or ($Type='DDDDD') or ($Type='BBBBB') or ($Type='40') or ($Type='44') or ($Type='ER')">
					<!--Akt_100886-->
					<tr>
						<td colspan="4">&nbsp;</td>
					</tr>
					<tr>
						<td colspan="4">&nbsp;</td>
					</tr>
					<tr>
						<td colspan="4">&nbsp;</td>
					</tr>
				</xsl:when>
			</xsl:choose>
			<!-- //ML, 21.02.2023, Akt_109479: Dodatni opis na dokumentu-->
			<xsl:if test="(Document/DocumentTitle != '')">
				<tr>
					<td colspan="4">
						<b>
							<xsl:value-of select="Document/DocumentTitle"/>
						</b>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="(Document/DocumentText != '')">
				<tr>
					<td colspan="4">
						<xsl:value-of select="Document/DocumentText"/>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>
	<xsl:template match="InvHeader" mode="DocAccountHeader">
		<xsl:param name="Type"/>
		<xsl:param name="TxtFile"/>
		<table width="650" border="0" cellspacing="0" cellpadding="0" style="font-size: 11px;">
			<xsl:if test="contains(../InvProperty/HeaderInformation,'LOGO=')">
				<tr>
					<td colspan="4">
						<img src="{substring-before(substring-after(../InvProperty/HeaderInformation , 'LOGO=') , ';')}"/>
					</td>
				</tr>
			</xsl:if>
			<tr>
				<td colspan="2">
					<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/H1_1_1"/>
				</td>
				<td colspan="3">
					<xsl:value-of select="Payer/Destination/ConvocationID"/>
				</td>
			</tr>
			<tr>
				<td colspan="2"/>
				<td colspan="3">
					<xsl:value-of select="Performer/Organization/BankCName"/>
				</td>
			</tr>
			<tr>
				<td colspan="2"/>
				<td colspan="3">
					<xsl:value-of select="Performer/Organization/BankCID"/>
				</td>
			</tr>
			<tr>
				<td colspan="2"/>
				<td colspan="3">
					<xsl:value-of select="Performer/Organization/BankCIBAN"/>
				</td>
			</tr>
			<tr>
				<td colspan="2">
					<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/H2_1_1"/>
				</td>
				<td colspan="3">
					<xsl:value-of select="Performer/Organization/AccountCID"/>
				</td>
			</tr>
			<tr>
				<td colspan="2"/>
				<td colspan="3">
					<xsl:if test="not( contains(../InvProperty/HeaderInformation,'DNP:ORG'))">
						<xsl:value-of select="Performer/Organization/Name"/>
					</xsl:if>&nbsp;
				</td>
			</tr>
			<xsl:if test="Performer/Organization/AdditionName != ''">
				<tr>
					<td colspan="2"/>
					<td colspan="3">
						<xsl:if test="not( contains(../InvProperty/HeaderInformation,'DNP:DN'))">
							<xsl:value-of select="Performer/Organization/AdditionName"/>
						</xsl:if>&nbsp;
					</td>
				</tr>
			</xsl:if>
			<tr>
				<td colspan="2"/>
				<td colspan="3">
					<xsl:if test="not( contains(../InvProperty/HeaderInformation,'DNP:KR'))">
						<xsl:value-of select="Performer/Organization/Address/PostalOffice/Name"/>
					</xsl:if>&nbsp;
				</td>
			</tr>
			<tr>
				<td width="10">&nbsp;</td>
				<td width="150">&nbsp;</td>
				<td width="150">&nbsp;</td>
				<td width="200">&nbsp;</td>
				<td width="140">&nbsp;</td>
			</tr>
			<tr>
				<td colspan="3"/>
				<td>
					<b>
						<xsl:call-template name="HeadRules">
							<xsl:with-param name="T" select="$Type"/>
							<xsl:with-param name="H7_2" select="$TxtFile"/>
						</xsl:call-template>
					</b>
				</td>
				<td>
					<xsl:value-of select="Document/ID"/>
				</td>
			</tr>
			<xsl:if test="(../InvProperty/StornoDocument = 'D') and (../InvProperty/VezniDocument != '')">
				<tr>
					<td colspan="2"/>
					<td>Vezni dokument:</td>
					<td>
						<xsl:value-of select="../InvProperty/VezniDocument"/>
					</td>
				</tr>
			</xsl:if>
			<tr>
				<td/>
				<td colspan="2" style="font-size: 13px;">
					<xsl:choose>
						<xsl:when test="../InvProperty/BoldAddress='true'">
							<b>
								<xsl:value-of select="Payer/Destination/Name"/>
							</b>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="Payer/Destination/Name"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td colspan="2"/>
			</tr>
			<tr>
				<td/>
				<td colspan="2" style="font-size: 13px;">
					<xsl:choose>
						<xsl:when test="../InvProperty/BoldAddress='true'">
							<b>
								<xsl:value-of select="Payer/Destination/Address/Street"/>
							</b>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="Payer/Destination/Address/Street"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td>
					<xsl:call-template name="HeadRules">
						<xsl:with-param name="T" select="$Type"/>
						<xsl:with-param name="H8_2" select="$TxtFile"/>
					</xsl:call-template>
				</td>
				<td>
					<xsl:value-of select="Document/PlaceEdition"/>
				</td>
			</tr>
			<tr>
				<td colspan="3"/>
				<td>
					<xsl:call-template name="HeadRules">
						<xsl:with-param name="T" select="$Type"/>
						<xsl:with-param name="H9_2" select="$TxtFile"/>
					</xsl:call-template>
				</td>
				<td>
					<xsl:call-template name="FormatDate">
						<xsl:with-param name="Date" select="Document/InvDate"/>
					</xsl:call-template>
				</td>
			</tr>
			<tr>
				<td/>
				<td colspan="2" style="font-size: 13px;">
					<xsl:choose>
						<xsl:when test="../InvProperty/BoldAddress='true'">
							<b>
								<xsl:value-of select="Payer/Destination/Address/PostalOffice/Code"/>&nbsp;&nbsp;&nbsp;
								<xsl:value-of select="Payer/Destination/Address/PostalOffice/Name"/>
							</b>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="Payer/Destination/Address/PostalOffice/Code"/>&nbsp;&nbsp;&nbsp;
							<xsl:value-of select="Payer/Destination/Address/PostalOffice/Name"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<xsl:call-template name="HeadRules">
					<xsl:with-param name="T" select="$Type"/>
					<xsl:with-param name="H10_2" select="$TxtFile"/>
				</xsl:call-template>
			</tr>
			<!-- //ML, 18.10.2016, Nap_21576: Drava na dokumentih v RAFu-->
			<xsl:if test="not(../InvBody/BodyProperty/Country/ID = '705') and (../InvBody/BodyProperty/Country/Name != '')">
				<tr>
					<td/>
					<td colspan="2" style="font-size: 13px;">
						<xsl:choose>
							<xsl:when test="../InvProperty/BoldAddress='true'">
								<b>
									<xsl:value-of select="../InvBody/BodyProperty/Country/Name"/>&nbsp;&nbsp;&nbsp;&nbsp;
								
							</b>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="../InvBody/BodyProperty/Country/Name"/>&nbsp;&nbsp;&nbsp;&nbsp;
						</xsl:otherwise>
						</xsl:choose>
					</td>
				</tr>
			</xsl:if>
			<tr>
				<td colspan="3"/>
				<td>
					<xsl:call-template name="HeadRules">
						<xsl:with-param name="T" select="$Type"/>
						<xsl:with-param name="H11_2" select="$TxtFile"/>
					</xsl:call-template>
				</td>
				<td>
					<xsl:call-template name="FormatDate">
						<xsl:with-param name="Date" select="Document/DateExpiration"/>
					</xsl:call-template>
				</td>
			</tr>
			<tr>
				<td colspan="3"/>
				<td>
					<xsl:call-template name="HeadRules">
						<xsl:with-param name="T" select="$Type"/>
						<xsl:with-param name="H17_2" select="$TxtFile"/>
					</xsl:call-template>
				</td>
				<td>
					<xsl:value-of select="Payer/Destination/TaxID"/>
				</td>
			</tr>
			<tr>
				<td colspan="5">&nbsp;</td>
			</tr>
			<tr>
				<td colspan="5">&nbsp;</td>
			</tr>
			<!-- //ML, 21.02.2023, Akt_109479: Dodatni opis na dokumentu-->
			<xsl:if test="(Document/DocumentTitle != '')">
				<tr>
					<td colspan="4">
						<b>
							<xsl:value-of select="Document/DocumentTitle"/>
						</b>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="(Document/DocumentText != '')">
				<tr>
					<td colspan="4">
						<xsl:value-of select="Document/DocumentText"/>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>
	<xsl:template match="InvHeader" mode="SpecHeader">
		<xsl:param name="Type"/>
		<xsl:param name="TxtFile"/>
		<table width="650" border="0" cellspacing="0" cellpadding="0" style="font-size: 11px;">
			<xsl:if test="contains(../InvProperty/HeaderInformation,'LOGO=')">
				<tr>
					<td colspan="4">
						<img src="{substring-before(substring-after(../InvProperty/HeaderInformation , 'LOGO=') , ';')}"/>
					</td>
				</tr>
			</xsl:if>
			<xsl:choose>
				<xsl:when test="../InvProperty/HeaderPerformer='true'">
					<tr>
						<td width="350">
							<xsl:value-of select="Performer/Organization/ID"/>&nbsp;
							<xsl:if test="not (contains(../InvProperty/HeaderInformation,'DNP:ORG'))">
								<xsl:value-of select="Performer/Organization/Name"/>
							</xsl:if>&nbsp;
						</td>
					</tr>
					<xsl:if test="Performer/Organization/AdditionName != ''">
						<tr>
							<td>
								<xsl:if test="not (contains(../InvProperty/HeaderInformation,'DNP:DN'))">
									<xsl:value-of select="Performer/Organization/AdditionName"/>
								</xsl:if>&nbsp;
							</td>
						</tr>
					</xsl:if>
				</xsl:when>
				<xsl:otherwise>
					<!--
					<tr>
						<td colspan="4">&nbsp;</td>
					</tr>
					<tr>
						<td colspan="4">&nbsp;</td>
					</tr>
					<tr>
						<td colspan="4">&nbsp;</td>
					</tr>
					<tr>
						<td colspan="4">&nbsp;</td>
					</tr>
				-->
				</xsl:otherwise>
			</xsl:choose>
			<tr>
				<td>&nbsp;</td>
			</tr>
			<tr>
				<td>
					<xsl:choose>
						<xsl:when test="../InvProperty/InvoiceSpecLabel">
							<xsl:value-of select="../InvProperty/InvoiceSpecLabel"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BH1_2_1"/>&nbsp;
								<xsl:choose>
								<xsl:when test="(Document/Name = 'FZ')">
									<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BH1_3_2"/>
								</xsl:when>
								<xsl:when test="($Type='01') or ($Type='02') or ($Type='03') or ($Type='05') or ($Type='06')">
									<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BH1_3_1"/>
								</xsl:when>
								<xsl:when test="($Type='09') or ($Type='10') or ($Type='12') or ($Type='19') or ($Type='23') or ($Type='25') or ($Type='P01') or ($Type='P02') or ($Type='P03') or ($Type='08') or ($Type='26') or ($Type='S01') or ($Type='33') or ($Type='34') or ($Type='38') or ($Type='VOZ') or ($Type='DDDDD') or ($Type='BBBBB') or ($Type='41') or ($Type='40') or ($Type='42') or ($Type='44') or ($Type='45')  or ($Type='47') or ($Type='48') or ($Type='49') or ($Type='ER')">
									<!--Akt_101021-->
									<!--Akt_100886-->
									<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BH1_3_3"/>
								</xsl:when>
								<xsl:otherwise/>
							</xsl:choose>
						</xsl:otherwise>
					</xsl:choose>
					&nbsp;<xsl:value-of select="Document/ID"/>
				</td>
			</tr>
			<xsl:if test="(../InvProperty/StornoDocument = 'D') and (../InvProperty/VezniDocument != '')">
				<tr>
					<td colspan="2"/>
					<td>Vezni dokument:</td>
					<td>
						<xsl:value-of select="../InvProperty/VezniDocument"/>
					</td>
				</tr>
			</xsl:if>
			<xsl:choose>
				<xsl:when test="($Type='P01') or ($Type='P02') or ($Type='P03') or ($Type='S01') or ($Type='DDDDD') or ($Type='BBBBB') or ($Type='40') or ($Type='44') or ($Type='ER')"/>
				<!--Akt_100886-->
				<xsl:otherwise>
					<xsl:if test="not($Type='39') ">
						<!-- Akt_100808 -->
						<tr>
							<td>Vrsta zavarovanja:
							<xsl:if test="($Type='42') or ($Type='43')">
									<xsl:value-of select="Document/InsuranceType"/>
								</xsl:if>
								<xsl:if test="Document/InsuranceType = '1'">Obvezno zavarovanje</xsl:if>
								<xsl:if test="Document/InsuranceType = '2'">Prostovoljno zavarovanje</xsl:if>
							</td>
						</tr>
					</xsl:if>
					<tr>
						<td>&nbsp;</td>
					</tr>
					<xsl:if test="not($Type='39') ">
						<!-- Akt_100808 -->
						<tr>
							<td>
								<xsl:value-of select="Payer/Organization/Name"/>
							</td>
						</tr>
						<tr>
							<xsl:choose>
								<xsl:when test="../InvProperty/BoldAddress='true'">
									<b>
										<td>Izpostava <xsl:value-of select="Payer/Destination/Name"/>
										</td>
									</b>
								</xsl:when>
								<xsl:otherwise>
									<td>Izpostava <xsl:value-of select="Payer/Destination/Name"/>
									</td>
								</xsl:otherwise>
							</xsl:choose>
						</tr>
					</xsl:if>
					<tr>
						<td>&nbsp;</td>
					</tr>
					<tr>
						<td>Obdobje: <xsl:call-template name="FormatDate">
								<xsl:with-param name="Date" select="Document/InvDateFrom"/>
							</xsl:call-template> - 
					<xsl:call-template name="FormatDate">
								<xsl:with-param name="Date" select="Document/InvDateTo"/>
							</xsl:call-template>
						</td>
					</tr>
					<tr>
						<td>&nbsp;</td>
					</tr>
					<xsl:if test="not($Type='39') ">
						<!-- Akt_100808 -->
						<xsl:if test="../InvBody/BodyProperty/ReasonTrial/ID != ''">
							<tr>
								<td>Razlog obravnave:&nbsp;
								<xsl:value-of select="../InvBody/BodyProperty/ReasonTrial/ID"/>&nbsp;
								<xsl:value-of select="../InvBody/BodyProperty/ReasonTrial/Name"/>
								</td>
							</tr>
						</xsl:if>
						<tr>
							<td>ifra kriterija za priloge: <xsl:value-of select="../InvBody/BodyProperty/IDCriterionKZZ"/>
							</td>
						</tr>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
		</table>
	</xsl:template>
	<xsl:template name="SpecHeadKonvencija">
		<xsl:param name="Type"/>
		<xsl:param name="TxtFile"/>
		<xsl:if test="contains(../InvProperty/HeaderInformation,'LOGO=')">
			<tr>
				<td colspan="4">
					<img src="{substring-before(substring-after(../InvProperty/HeaderInformation , 'LOGO=') , ';')}"/>
				</td>
			</tr>
		</xsl:if>
		<tr>
			<td colspan="16">
				<table style="font-size: 11px;">
					<xsl:for-each select="../../../../../../../../../InvHeader">
						<xsl:choose>
							<xsl:when test="../InvProperty/HeaderPerformer='true'">
								<tr>
									<td width="350">
										<xsl:value-of select="Performer/Organization/ID"/>&nbsp;
										<xsl:if test="not (contains(../InvProperty/HeaderInformation,'DNP:ORG'))">
											<xsl:value-of select="Performer/Organization/Name"/>
										</xsl:if>&nbsp;
									</td>
								</tr>
							</xsl:when>
							<xsl:otherwise>
								<!--
								<tr>
									<td colspan="4">&nbsp;</td>
								</tr>
								<tr>
									<td colspan="4">&nbsp;</td>
								</tr>
								<tr>
									<td colspan="4">&nbsp;</td>
								</tr>
								<tr>
									<td colspan="4">&nbsp;</td>
								</tr>
								-->
							</xsl:otherwise>
						</xsl:choose>
						<tr>
							<td>&nbsp;</td>
						</tr>
						<tr>
							<td>
								<xsl:choose>
									<xsl:when test="../InvProperty/InvoiceSpecLabel">
										<xsl:value-of select="../InvProperty/InvoiceSpecLabel"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BH1_2_1"/>&nbsp;
									<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BH1_3_3"/>&nbsp;
									</xsl:otherwise>
								</xsl:choose>
								<xsl:value-of select="Document/ID"/>
							</td>
						</tr>
						<xsl:if test="(../InvProperty/StornoDocument = 'D') and (../InvProperty/VezniDocument != '')">
							<tr>
								<td colspan="2"/>
								<td>Vezni dokument:</td>
								<td>
									<xsl:value-of select="../InvProperty/VezniDocument"/>
								</td>
							</tr>
						</xsl:if>
						<tr>
							<td>Vrsta zavarovanja:
							<xsl:if test="($Type='42') or ($Type='43')">
									<xsl:value-of select="Document/InsuranceType"/>
								</xsl:if>
								<xsl:if test="Document/InsuranceType = '1'">Obvezno zavarovanje</xsl:if>
								<xsl:if test="Document/InsuranceType = '2'">Prostovoljno zavarovanje</xsl:if>
							</td>
						</tr>
						<tr>
							<td>&nbsp;</td>
						</tr>
						<tr>
							<td>
								<xsl:value-of select="Payer/Organization/Name"/>
							</td>
						</tr>
						<tr>
							<xsl:choose>
								<xsl:when test="../InvProperty/BoldAddress='true'">
									<b>
										<td>Izpostava&nbsp;
								<xsl:value-of select="Payer/Destination/Name"/>
										</td>
									</b>
								</xsl:when>
								<xsl:otherwise>
									<td>Izpostava&nbsp;
								<xsl:value-of select="Payer/Destination/Name"/>
									</td>
								</xsl:otherwise>
							</xsl:choose>
						</tr>
						<tr>
							<td>&nbsp;</td>
						</tr>
						<tr>
							<td>Obdobje: 
								<xsl:call-template name="FormatDate">
									<xsl:with-param name="Date" select="Document/InvDateFrom"/>
								</xsl:call-template> - 
								<xsl:call-template name="FormatDate">
									<xsl:with-param name="Date" select="Document/InvDateTo"/>
								</xsl:call-template>
							</td>
						</tr>
						<tr>
							<td>&nbsp;</td>
						</tr>
						<xsl:if test="../InvBody/BodyProperty/ReasonTrial/ID != ''">
							<tr>
								<td>Razlog obravnave:&nbsp; 
									<xsl:value-of select="../InvBody/BodyProperty/ReasonTrial/ID"/>&nbsp;
									<xsl:value-of select="../InvBody/BodyProperty/ReasonTrial/Name"/>
								</td>
							</tr>
						</xsl:if>
						<tr>
							<td>ifra kriterija za priloge:&nbsp; 
								<xsl:value-of select="../InvBody/BodyProperty/IDCriterionKZZ"/>
							</td>
						</tr>
					</xsl:for-each>
				</table>
			</td>
		</tr>
	</xsl:template>
	<!-- SG, 20.01.2008, Akt_101197 -->
	<xsl:template match="InvHeader" mode="Receipt">
		<xsl:param name="Type"/>
		<xsl:param name="TxtFile"/>
		<br/>
		<br/>
		<xsl:if test="../InvProperty/Receipt = '1'">
			<table width="650" border="0" cellspacing="0" cellpadding="0" style="font-size: 11px;">
				<tr>
					<td colspan="2" align="center">
						<xsl:value-of select="document($TxtFile)/InvoiceTXT/HeadTXT/H20_2_1"/>&nbsp;
				<xsl:value-of select="substring(Document/ID,3,string-length(Document/ID))"/>
					</td>
				</tr>
				<tr>
					<td align="center">
						<xsl:value-of select="../InvProperty/MainBillingFormService"/>
						<xsl:value-of select="../InvProperty/MainBillingPaymentDeadLine"/>
					</td>
					<td align="center">
						<xsl:value-of select="../InvProperty/MainBillingFormTransactionType"/>
				&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
				***<xsl:call-template name="FormatNumberWithNull">
							<xsl:with-param name="Number" select="../InvFooter/ServicePriceProperty/AdditionalPrice"/>
						</xsl:call-template>
					</td>
				</tr>
				<tr>
					<td colspan="2" align="center">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
	                 ***<xsl:call-template name="FormatNumberWithNull">
							<xsl:with-param name="Number" select="../InvFooter/ServicePriceProperty/AdditionalPrice"/>
						</xsl:call-template>
				&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
				<xsl:value-of select="substring(../InvProperty/MainBillingBankAccountNumber,1,4)"/>&nbsp;&nbsp;
				<xsl:value-of select="substring(../InvProperty/MainBillingBankAccountNumber,5,1) + substring(../InvProperty/MainBillingBankAccountNumber,7,3)"/>				&nbsp;&nbsp;
				<xsl:value-of select="substring(../InvProperty/MainBillingBankAccountNumber,10,4)"/>&nbsp;&nbsp;
				<xsl:value-of select="substring(../InvProperty/MainBillingBankAccountNumber,14,3)"/>&nbsp;&nbsp;
			</td>
				</tr>
				<tr>
					<td width="50%">
						<xsl:value-of select="../InvProperty/RefNumber"/>
					</td>
					<td width="50%">
						<xsl:value-of select="../InvProperty/RefNumber"/>
					</td>
				</tr>
				<tr>
					<td colspan="2" align="center">
						<xsl:value-of select="../InvProperty/MainBillingFormTitle"/>
					</td>
				</tr>
				<tr>
					<td colspan="2" align="center">
						<xsl:value-of select="../InvProperty/MainBillingFormStreet"/>
					</td>
				</tr>
				<tr>
					<td colspan="2" align="center">
						<xsl:value-of select="../InvProperty/MainBillingFormPost"/>
					</td>
				</tr>
				<tr>
					<td width="50%">
						<xsl:value-of select="Payer/Organization/Name"/>
					</td>
					<td width="50%">
						<xsl:value-of select="Payer/Organization/Name"/>
					</td>
				</tr>
				<tr>
					<td width="50%">
						<xsl:value-of select="Payer/Organization/Address/Street"/>
					</td>
					<td width="50%">
						<xsl:value-of select="Payer/Organization/Address/Street"/>
					</td>
				</tr>
				<tr>
					<td width="50%">
						<xsl:value-of select="Payer/Organization/Address/PostalOffice/Code"/>&nbsp;&nbsp;
				<xsl:value-of select="Payer/Organization/Address/PostalOffice/Name"/>
					</td>
					<td width="50%">
						<xsl:value-of select="Payer/Organization/Address/PostalOffice/Code"/>&nbsp;&nbsp;
			<xsl:value-of select="Payer/Organization/Address/PostalOffice/Name"/>
					</td>
				</tr>
				<!-- //ML, 21.02.2023, Akt_109479: Dodatni opis na dokumentu-->
			<xsl:if test="(Document/DocumentTitle != '')">
				<tr>
					<td colspan="4">
						<b>
							<xsl:value-of select="Document/DocumentTitle"/>
						</b>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="(Document/DocumentText != '')">
				<tr>
					<td colspan="4">
						<xsl:value-of select="Document/DocumentText"/>
					</td>
				</tr>
			</xsl:if>
			</table>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>
