# -*- coding: utf-8 -*-

# Form implementation generated from reading ui file 'commands_dialog.ui'
#
# Created by: PyQt5 UI code generator 5.15.7
#
# WARNING: Any manual changes made to this file will be lost when pyuic5 is
# run again.  Do not edit this file unless you know what you are doing.

"""
TODO:
The classes here are generated from GUI design, created in QT Designer. For example:
    pyuic5 commands_dialog.ui -o commands_dialog.py

To make GUI DPI aware, scaling must be used. Currently scaling is implemented by find and replace using these regex expressions:
# (move|resize|QRect|setContentsMargins)(?!scale)([(\s])(\d+) --> $1$2scale($3)
# (scale\(\d+\),)(\s)(\d+) --> $1$2scale($3)

This should better be covered by some additional converter which is called after the ui --> py conversion. For example:
    python add_scaling commands_dialog.py -o commands_dialog_with_scaling.py

Additional conversion needed is to make icons and figures have relative addresses. Use the following
# (QtGui\.QPixmap\()(".*") --> $1os.path.join(basedir, $2)
For this to work you will need to import "os" module and set up basedir variable: 
# basedir = os.path.dirname(__file__)

If scaling not available, add all this
import ctypes

scaleFactor = ctypes.windll.shcore.GetScaleFactorForDevice(0) / 100

def scale(value):
    return int(scaleFactor * value)
 
"""

from PyQt5 import QtGui, QtWidgets, QtCore, Qt
from PyQt5.QtWidgets import QMessageBox
from gui.gui_scaling import scale

import os
basedir = os.path.dirname(__file__)

def show_message_box( 
        message,
        box_title=None,
        button_yes_text=None,
        button_no_text=None,
        button_cancel_text=None,
        box_type='Question', 
        num_of_buttons=2,
    ):
    box = QMessageBox()
    if box_type=='Question':
        box.setIcon(QMessageBox.Question)
    elif box_type=='Warning':
        box.setIcon(QMessageBox.Warning)
    elif box_type=='Information':
        box.setIcon(QMessageBox.Information)
    elif box_type=='Critical':
        box.setIcon(QMessageBox.Critical)
    else:
        box.setIcon(QMessageBox.Information)

    if box_title:
        box.setWindowTitle(box_title)
    
    box.setText(message)
    
    if num_of_buttons == 1:
        box.setStandardButtons(QMessageBox.Yes)
        buttonY = box.button(QMessageBox.Yes)
        if button_yes_text:
            buttonY.setText(button_yes_text)
    
    elif num_of_buttons == 2:
        box.setStandardButtons(QMessageBox.Yes|QMessageBox.No)
        buttonY = box.button(QMessageBox.Yes)
        buttonN = box.button(QMessageBox.No)
        if button_yes_text:
            buttonY.setText(button_yes_text)
        if button_no_text:
            buttonN.setText(button_no_text) 

    elif num_of_buttons == 3:
        box.setStandardButtons(QMessageBox.Yes|QMessageBox.No|QMessageBox.Cancel)
        buttonY = box.button(QMessageBox.Yes)
        buttonN = box.button(QMessageBox.No)
        buttonC = box.button(QMessageBox.Cancel)
        if button_yes_text:
            buttonY.setText(button_yes_text)
        if button_no_text:
            buttonN.setText(button_no_text)
        if button_cancel_text:
            buttonC.setText(button_cancel_text)

    box.setWindowFlags(QtCore.Qt.WindowStaysOnTopHint)
    box.exec()

    if box.clickedButton() == buttonY:
        return 1
    elif box.clickedButton() == buttonN:
        return 2
    elif box.clickedButton() == buttonC:
        return 3

class Ui_Dialog_commands(object):
    def setupUi(self, Dialog_commands):
        Dialog_commands.setObjectName("Dialog_commands")
        Dialog_commands.resize(scale(591), scale(693))
        self.tabWidget = QtWidgets.QTabWidget(Dialog_commands)
        self.tabWidget.setGeometry(QtCore.QRect(scale(10), scale(10), scale(571), scale(681)))
        self.tabWidget.setObjectName("tabWidget")
        self.tab_3 = QtWidgets.QWidget()
        self.tab_3.setObjectName("tab_3")
        self.pushButton_close = QtWidgets.QPushButton(self.tab_3)
        self.pushButton_close.setGeometry(QtCore.QRect(scale(478), scale(622), scale(75), scale(23)))
        self.pushButton_close.setDefault(True)
        self.pushButton_close.setObjectName("pushButton_close")
        self.widget = QtWidgets.QWidget(self.tab_3)
        self.widget.setGeometry(QtCore.QRect(scale(10), scale(10), scale(201), scale(611)))
        self.widget.setObjectName("widget")
        self.verticalLayout = QtWidgets.QVBoxLayout(self.widget)
        self.verticalLayout.setContentsMargins(scale(0), scale(0), scale(0), scale(0))
        self.verticalLayout.setObjectName("verticalLayout")
        self.label_H1_2 = QtWidgets.QLabel(self.widget)
        font = QtGui.QFont()
        font.setBold(True)
        font.setWeight(75)
        self.label_H1_2.setFont(font)
        self.label_H1_2.setObjectName("label_H1_2")
        self.verticalLayout.addWidget(self.label_H1_2)
        self.label_H1_4 = QtWidgets.QLabel(self.widget)
        font = QtGui.QFont()
        font.setBold(True)
        font.setWeight(75)
        self.label_H1_4.setFont(font)
        self.label_H1_4.setStyleSheet("background: lightblue")
        self.label_H1_4.setObjectName("label_H1_4")
        self.verticalLayout.addWidget(self.label_H1_4)
        self.label_action_46 = QtWidgets.QLabel(self.widget)
        font = QtGui.QFont()
        font.setFamily("MS Shell Dlg 2")
        self.label_action_46.setFont(font)
        self.label_action_46.setObjectName("label_action_46")
        self.verticalLayout.addWidget(self.label_action_46)
        self.label_action_42 = QtWidgets.QLabel(self.widget)
        font = QtGui.QFont()
        font.setFamily("MS Shell Dlg 2")
        self.label_action_42.setFont(font)
        self.label_action_42.setObjectName("label_action_42")
        self.verticalLayout.addWidget(self.label_action_42)
        self.label_H2_2 = QtWidgets.QLabel(self.widget)
        font = QtGui.QFont()
        font.setBold(True)
        font.setWeight(75)
        self.label_H2_2.setFont(font)
        self.label_H2_2.setStyleSheet("background: lightblue")
        self.label_H2_2.setObjectName("label_H2_2")
        self.verticalLayout.addWidget(self.label_H2_2)
        self.label_action_50 = QtWidgets.QLabel(self.widget)
        font = QtGui.QFont()
        font.setFamily("MS Shell Dlg 2")
        self.label_action_50.setFont(font)
        self.label_action_50.setObjectName("label_action_50")
        self.verticalLayout.addWidget(self.label_action_50)
        self.label_action_49 = QtWidgets.QLabel(self.widget)
        font = QtGui.QFont()
        font.setFamily("MS Shell Dlg 2")
        self.label_action_49.setFont(font)
        self.label_action_49.setObjectName("label_action_49")
        self.verticalLayout.addWidget(self.label_action_49)
        self.label_action_51 = QtWidgets.QLabel(self.widget)
        font = QtGui.QFont()
        font.setFamily("MS Shell Dlg 2")
        self.label_action_51.setFont(font)
        self.label_action_51.setObjectName("label_action_51")
        self.verticalLayout.addWidget(self.label_action_51)
        self.label_action_40 = QtWidgets.QLabel(self.widget)
        font = QtGui.QFont()
        font.setFamily("MS Shell Dlg 2")
        self.label_action_40.setFont(font)
        self.label_action_40.setObjectName("label_action_40")
        self.verticalLayout.addWidget(self.label_action_40)
        self.label_action_32 = QtWidgets.QLabel(self.widget)
        font = QtGui.QFont()
        font.setFamily("MS Shell Dlg 2")
        self.label_action_32.setFont(font)
        self.label_action_32.setObjectName("label_action_32")
        self.verticalLayout.addWidget(self.label_action_32)
        self.label_action_37 = QtWidgets.QLabel(self.widget)
        font = QtGui.QFont()
        font.setFamily("MS Shell Dlg 2")
        self.label_action_37.setFont(font)
        self.label_action_37.setObjectName("label_action_37")
        self.verticalLayout.addWidget(self.label_action_37)
        self.label_action_52 = QtWidgets.QLabel(self.widget)
        font = QtGui.QFont()
        font.setFamily("MS Shell Dlg 2")
        self.label_action_52.setFont(font)
        self.label_action_52.setObjectName("label_action_52")
        self.verticalLayout.addWidget(self.label_action_52)
        self.label_action_53 = QtWidgets.QLabel(self.widget)
        font = QtGui.QFont()
        font.setFamily("MS Shell Dlg 2")
        self.label_action_53.setFont(font)
        self.label_action_53.setObjectName("label_action_53")
        self.verticalLayout.addWidget(self.label_action_53)
        self.label_action_54 = QtWidgets.QLabel(self.widget)
        font = QtGui.QFont()
        font.setFamily("MS Shell Dlg 2")
        self.label_action_54.setFont(font)
        self.label_action_54.setObjectName("label_action_54")
        self.verticalLayout.addWidget(self.label_action_54)
        self.label_H3_2 = QtWidgets.QLabel(self.widget)
        font = QtGui.QFont()
        font.setBold(True)
        font.setWeight(75)
        self.label_H3_2.setFont(font)
        self.label_H3_2.setStyleSheet("background: lightblue")
        self.label_H3_2.setObjectName("label_H3_2")
        self.verticalLayout.addWidget(self.label_H3_2)
        self.label_action_41 = QtWidgets.QLabel(self.widget)
        font = QtGui.QFont()
        font.setFamily("MS Shell Dlg 2")
        self.label_action_41.setFont(font)
        self.label_action_41.setObjectName("label_action_41")
        self.verticalLayout.addWidget(self.label_action_41)
        self.label_action_44 = QtWidgets.QLabel(self.widget)
        font = QtGui.QFont()
        font.setFamily("MS Shell Dlg 2")
        self.label_action_44.setFont(font)
        self.label_action_44.setObjectName("label_action_44")
        self.verticalLayout.addWidget(self.label_action_44)
        self.label_action_73 = QtWidgets.QLabel(self.widget)
        font = QtGui.QFont()
        font.setFamily("MS Shell Dlg 2")
        self.label_action_73.setFont(font)
        self.label_action_73.setObjectName("label_action_73")
        self.verticalLayout.addWidget(self.label_action_73)
        self.label_action_39 = QtWidgets.QLabel(self.widget)
        font = QtGui.QFont()
        font.setFamily("MS Shell Dlg 2")
        self.label_action_39.setFont(font)
        self.label_action_39.setObjectName("label_action_39")
        self.verticalLayout.addWidget(self.label_action_39)
        self.label_H4_2 = QtWidgets.QLabel(self.widget)
        font = QtGui.QFont()
        font.setBold(True)
        font.setWeight(75)
        self.label_H4_2.setFont(font)
        self.label_H4_2.setStyleSheet("background: lightblue")
        self.label_H4_2.setObjectName("label_H4_2")
        self.verticalLayout.addWidget(self.label_H4_2)
        self.label_action_71 = QtWidgets.QLabel(self.widget)
        font = QtGui.QFont()
        font.setFamily("MS Shell Dlg 2")
        self.label_action_71.setFont(font)
        self.label_action_71.setObjectName("label_action_71")
        self.verticalLayout.addWidget(self.label_action_71)
        self.label_action_72 = QtWidgets.QLabel(self.widget)
        font = QtGui.QFont()
        font.setFamily("MS Shell Dlg 2")
        self.label_action_72.setFont(font)
        self.label_action_72.setObjectName("label_action_72")
        self.verticalLayout.addWidget(self.label_action_72)
        self.label_action_45 = QtWidgets.QLabel(self.widget)
        font = QtGui.QFont()
        font.setFamily("MS Shell Dlg 2")
        self.label_action_45.setFont(font)
        self.label_action_45.setObjectName("label_action_45")
        self.verticalLayout.addWidget(self.label_action_45)
        self.label_action_38 = QtWidgets.QLabel(self.widget)
        font = QtGui.QFont()
        font.setFamily("MS Shell Dlg 2")
        self.label_action_38.setFont(font)
        self.label_action_38.setObjectName("label_action_38")
        self.verticalLayout.addWidget(self.label_action_38)
        self.widget1 = QtWidgets.QWidget(self.tab_3)
        self.widget1.setGeometry(QtCore.QRect(scale(210), scale(10), scale(351), scale(611)))
        self.widget1.setObjectName("widget1")
        self.verticalLayout_2 = QtWidgets.QVBoxLayout(self.widget1)
        self.verticalLayout_2.setContentsMargins(scale(0), scale(0), scale(0), scale(0))
        self.verticalLayout_2.setObjectName("verticalLayout_2")
        self.label_H1_3 = QtWidgets.QLabel(self.widget1)
        font = QtGui.QFont()
        font.setBold(True)
        font.setWeight(75)
        self.label_H1_3.setFont(font)
        self.label_H1_3.setObjectName("label_H1_3")
        self.verticalLayout_2.addWidget(self.label_H1_3)
        self.label_H1_5 = QtWidgets.QLabel(self.widget1)
        font = QtGui.QFont()
        font.setBold(True)
        font.setWeight(75)
        self.label_H1_5.setFont(font)
        self.label_H1_5.setStyleSheet("background: lightblue")
        self.label_H1_5.setText("")
        self.label_H1_5.setObjectName("label_H1_5")
        self.verticalLayout_2.addWidget(self.label_H1_5)
        self.label_pron_56 = QtWidgets.QLabel(self.widget1)
        font = QtGui.QFont()
        font.setFamily("MS Shell Dlg 2")
        self.label_pron_56.setFont(font)
        self.label_pron_56.setObjectName("label_pron_56")
        self.verticalLayout_2.addWidget(self.label_pron_56)
        self.label_pron_58 = QtWidgets.QLabel(self.widget1)
        font = QtGui.QFont()
        font.setFamily("MS Shell Dlg 2")
        self.label_pron_58.setFont(font)
        self.label_pron_58.setObjectName("label_pron_58")
        self.verticalLayout_2.addWidget(self.label_pron_58)
        self.label_H2_3 = QtWidgets.QLabel(self.widget1)
        font = QtGui.QFont()
        font.setBold(True)
        font.setWeight(75)
        self.label_H2_3.setFont(font)
        self.label_H2_3.setStyleSheet("background: lightblue")
        self.label_H2_3.setText("")
        self.label_H2_3.setObjectName("label_H2_3")
        self.verticalLayout_2.addWidget(self.label_H2_3)
        self.label_pron_65 = QtWidgets.QLabel(self.widget1)
        font = QtGui.QFont()
        font.setFamily("MS Shell Dlg 2")
        self.label_pron_65.setFont(font)
        self.label_pron_65.setObjectName("label_pron_65")
        self.verticalLayout_2.addWidget(self.label_pron_65)
        self.label_pron_66 = QtWidgets.QLabel(self.widget1)
        font = QtGui.QFont()
        font.setFamily("MS Shell Dlg 2")
        self.label_pron_66.setFont(font)
        self.label_pron_66.setObjectName("label_pron_66")
        self.verticalLayout_2.addWidget(self.label_pron_66)
        self.label_pron_67 = QtWidgets.QLabel(self.widget1)
        font = QtGui.QFont()
        font.setFamily("MS Shell Dlg 2")
        self.label_pron_67.setFont(font)
        self.label_pron_67.setObjectName("label_pron_67")
        self.verticalLayout_2.addWidget(self.label_pron_67)
        self.label_pron_53 = QtWidgets.QLabel(self.widget1)
        font = QtGui.QFont()
        font.setFamily("MS Shell Dlg 2")
        self.label_pron_53.setFont(font)
        self.label_pron_53.setObjectName("label_pron_53")
        self.verticalLayout_2.addWidget(self.label_pron_53)
        self.label_pron_62 = QtWidgets.QLabel(self.widget1)
        font = QtGui.QFont()
        font.setFamily("MS Shell Dlg 2")
        self.label_pron_62.setFont(font)
        self.label_pron_62.setObjectName("label_pron_62")
        self.verticalLayout_2.addWidget(self.label_pron_62)
        self.label_pron_57 = QtWidgets.QLabel(self.widget1)
        font = QtGui.QFont()
        font.setFamily("MS Shell Dlg 2")
        self.label_pron_57.setFont(font)
        self.label_pron_57.setObjectName("label_pron_57")
        self.verticalLayout_2.addWidget(self.label_pron_57)
        self.label_pron_68 = QtWidgets.QLabel(self.widget1)
        font = QtGui.QFont()
        font.setFamily("MS Shell Dlg 2")
        self.label_pron_68.setFont(font)
        self.label_pron_68.setObjectName("label_pron_68")
        self.verticalLayout_2.addWidget(self.label_pron_68)
        self.label_pron_69 = QtWidgets.QLabel(self.widget1)
        font = QtGui.QFont()
        font.setFamily("MS Shell Dlg 2")
        self.label_pron_69.setFont(font)
        self.label_pron_69.setObjectName("label_pron_69")
        self.verticalLayout_2.addWidget(self.label_pron_69)
        self.label_pron_70 = QtWidgets.QLabel(self.widget1)
        font = QtGui.QFont()
        font.setFamily("MS Shell Dlg 2")
        self.label_pron_70.setFont(font)
        self.label_pron_70.setObjectName("label_pron_70")
        self.verticalLayout_2.addWidget(self.label_pron_70)
        self.label_H2_4 = QtWidgets.QLabel(self.widget1)
        font = QtGui.QFont()
        font.setBold(True)
        font.setWeight(75)
        self.label_H2_4.setFont(font)
        self.label_H2_4.setStyleSheet("background: lightblue")
        self.label_H2_4.setText("")
        self.label_H2_4.setObjectName("label_H2_4")
        self.verticalLayout_2.addWidget(self.label_H2_4)
        self.label_pron_61 = QtWidgets.QLabel(self.widget1)
        font = QtGui.QFont()
        font.setFamily("MS Shell Dlg 2")
        self.label_pron_61.setFont(font)
        self.label_pron_61.setObjectName("label_pron_61")
        self.verticalLayout_2.addWidget(self.label_pron_61)
        self.label_pron_105 = QtWidgets.QLabel(self.widget1)
        font = QtGui.QFont()
        font.setFamily("MS Shell Dlg 2")
        self.label_pron_105.setFont(font)
        self.label_pron_105.setObjectName("label_pron_105")
        self.verticalLayout_2.addWidget(self.label_pron_105)
        self.label_pron_63 = QtWidgets.QLabel(self.widget1)
        font = QtGui.QFont()
        font.setFamily("MS Shell Dlg 2")
        self.label_pron_63.setFont(font)
        self.label_pron_63.setObjectName("label_pron_63")
        self.verticalLayout_2.addWidget(self.label_pron_63)
        self.label_pron_55 = QtWidgets.QLabel(self.widget1)
        font = QtGui.QFont()
        font.setFamily("MS Shell Dlg 2")
        self.label_pron_55.setFont(font)
        self.label_pron_55.setObjectName("label_pron_55")
        self.verticalLayout_2.addWidget(self.label_pron_55)
        self.label_H2_5 = QtWidgets.QLabel(self.widget1)
        font = QtGui.QFont()
        font.setBold(True)
        font.setWeight(75)
        self.label_H2_5.setFont(font)
        self.label_H2_5.setStyleSheet("background: lightblue")
        self.label_H2_5.setText("")
        self.label_H2_5.setObjectName("label_H2_5")
        self.verticalLayout_2.addWidget(self.label_H2_5)
        self.label_pron_104 = QtWidgets.QLabel(self.widget1)
        font = QtGui.QFont()
        font.setFamily("MS Shell Dlg 2")
        self.label_pron_104.setFont(font)
        self.label_pron_104.setObjectName("label_pron_104")
        self.verticalLayout_2.addWidget(self.label_pron_104)
        self.label_pron_103 = QtWidgets.QLabel(self.widget1)
        font = QtGui.QFont()
        font.setFamily("MS Shell Dlg 2")
        self.label_pron_103.setFont(font)
        self.label_pron_103.setObjectName("label_pron_103")
        self.verticalLayout_2.addWidget(self.label_pron_103)
        self.label_pron_52 = QtWidgets.QLabel(self.widget1)
        font = QtGui.QFont()
        font.setFamily("MS Shell Dlg 2")
        self.label_pron_52.setFont(font)
        self.label_pron_52.setObjectName("label_pron_52")
        self.verticalLayout_2.addWidget(self.label_pron_52)
        self.label_pron_54 = QtWidgets.QLabel(self.widget1)
        font = QtGui.QFont()
        font.setFamily("MS Shell Dlg 2")
        self.label_pron_54.setFont(font)
        self.label_pron_54.setObjectName("label_pron_54")
        self.verticalLayout_2.addWidget(self.label_pron_54)
        self.tabWidget.addTab(self.tab_3, "")
        self.tab_4 = QtWidgets.QWidget()
        self.tab_4.setObjectName("tab_4")
        self.label_action_55 = QtWidgets.QLabel(self.tab_4)
        self.label_action_55.setGeometry(QtCore.QRect(scale(30), scale(46), scale(71), scale(20)))
        font = QtGui.QFont()
        font.setFamily("MS Shell Dlg 2")
        self.label_action_55.setFont(font)
        self.label_action_55.setObjectName("label_action_55")
        self.label_H5_3 = QtWidgets.QLabel(self.tab_4)
        self.label_H5_3.setGeometry(QtCore.QRect(scale(25), scale(20), scale(521), scale(16)))
        font = QtGui.QFont()
        font.setBold(True)
        font.setWeight(75)
        self.label_H5_3.setFont(font)
        self.label_H5_3.setStyleSheet("background: lightblue")
        self.label_H5_3.setObjectName("label_H5_3")
        self.label_pron_71 = QtWidgets.QLabel(self.tab_4)
        self.label_pron_71.setGeometry(QtCore.QRect(scale(180), scale(46), scale(221), scale(20)))
        font = QtGui.QFont()
        font.setFamily("Courier New")
        self.label_pron_71.setFont(font)
        self.label_pron_71.setObjectName("label_pron_71")
        self.label_pron_72 = QtWidgets.QLabel(self.tab_4)
        self.label_pron_72.setGeometry(QtCore.QRect(scale(120), scale(46), scale(21), scale(20)))
        font = QtGui.QFont()
        font.setFamily("Courier New")
        font.setPointSize(10)
        font.setBold(True)
        font.setWeight(75)
        self.label_pron_72.setFont(font)
        self.label_pron_72.setAlignment(QtCore.Qt.AlignCenter)
        self.label_pron_72.setObjectName("label_pron_72")
        self.label_pron_73 = QtWidgets.QLabel(self.tab_4)
        self.label_pron_73.setGeometry(QtCore.QRect(scale(180), scale(76), scale(221), scale(20)))
        font = QtGui.QFont()
        font.setFamily("Courier New")
        self.label_pron_73.setFont(font)
        self.label_pron_73.setObjectName("label_pron_73")
        self.label_pron_74 = QtWidgets.QLabel(self.tab_4)
        self.label_pron_74.setGeometry(QtCore.QRect(scale(120), scale(76), scale(21), scale(20)))
        font = QtGui.QFont()
        font.setFamily("Courier New")
        font.setPointSize(10)
        font.setBold(True)
        font.setWeight(75)
        self.label_pron_74.setFont(font)
        self.label_pron_74.setAlignment(QtCore.Qt.AlignCenter)
        self.label_pron_74.setObjectName("label_pron_74")
        self.label_action_56 = QtWidgets.QLabel(self.tab_4)
        self.label_action_56.setGeometry(QtCore.QRect(scale(30), scale(76), scale(71), scale(20)))
        font = QtGui.QFont()
        font.setFamily("MS Shell Dlg 2")
        self.label_action_56.setFont(font)
        self.label_action_56.setObjectName("label_action_56")
        self.label_pron_75 = QtWidgets.QLabel(self.tab_4)
        self.label_pron_75.setGeometry(QtCore.QRect(scale(180), scale(106), scale(221), scale(20)))
        font = QtGui.QFont()
        font.setFamily("Courier New")
        self.label_pron_75.setFont(font)
        self.label_pron_75.setObjectName("label_pron_75")
        self.label_pron_76 = QtWidgets.QLabel(self.tab_4)
        self.label_pron_76.setGeometry(QtCore.QRect(scale(120), scale(106), scale(21), scale(20)))
        font = QtGui.QFont()
        font.setFamily("Courier New")
        font.setPointSize(10)
        font.setBold(True)
        font.setWeight(75)
        self.label_pron_76.setFont(font)
        self.label_pron_76.setAlignment(QtCore.Qt.AlignCenter)
        self.label_pron_76.setObjectName("label_pron_76")
        self.label_action_57 = QtWidgets.QLabel(self.tab_4)
        self.label_action_57.setGeometry(QtCore.QRect(scale(30), scale(106), scale(71), scale(20)))
        font = QtGui.QFont()
        font.setFamily("MS Shell Dlg 2")
        self.label_action_57.setFont(font)
        self.label_action_57.setObjectName("label_action_57")
        self.label_action_58 = QtWidgets.QLabel(self.tab_4)
        self.label_action_58.setGeometry(QtCore.QRect(scale(30), scale(136), scale(71), scale(20)))
        font = QtGui.QFont()
        font.setFamily("MS Shell Dlg 2")
        self.label_action_58.setFont(font)
        self.label_action_58.setObjectName("label_action_58")
        self.label_pron_77 = QtWidgets.QLabel(self.tab_4)
        self.label_pron_77.setGeometry(QtCore.QRect(scale(180), scale(136), scale(221), scale(20)))
        font = QtGui.QFont()
        font.setFamily("Courier New")
        self.label_pron_77.setFont(font)
        self.label_pron_77.setObjectName("label_pron_77")
        self.label_pron_78 = QtWidgets.QLabel(self.tab_4)
        self.label_pron_78.setGeometry(QtCore.QRect(scale(120), scale(136), scale(21), scale(20)))
        font = QtGui.QFont()
        font.setFamily("Courier New")
        font.setPointSize(10)
        font.setBold(True)
        font.setWeight(75)
        self.label_pron_78.setFont(font)
        self.label_pron_78.setAlignment(QtCore.Qt.AlignCenter)
        self.label_pron_78.setObjectName("label_pron_78")
        self.label_pron_79 = QtWidgets.QLabel(self.tab_4)
        self.label_pron_79.setGeometry(QtCore.QRect(scale(180), scale(166), scale(221), scale(20)))
        font = QtGui.QFont()
        font.setFamily("Courier New")
        self.label_pron_79.setFont(font)
        self.label_pron_79.setObjectName("label_pron_79")
        self.label_action_59 = QtWidgets.QLabel(self.tab_4)
        self.label_action_59.setGeometry(QtCore.QRect(scale(30), scale(258), scale(71), scale(20)))
        font = QtGui.QFont()
        font.setFamily("MS Shell Dlg 2")
        self.label_action_59.setFont(font)
        self.label_action_59.setObjectName("label_action_59")
        self.label_pron_80 = QtWidgets.QLabel(self.tab_4)
        self.label_pron_80.setGeometry(QtCore.QRect(scale(120), scale(258), scale(21), scale(20)))
        font = QtGui.QFont()
        font.setFamily("Courier New")
        font.setPointSize(10)
        font.setBold(True)
        font.setWeight(75)
        self.label_pron_80.setFont(font)
        self.label_pron_80.setAlignment(QtCore.Qt.AlignCenter)
        self.label_pron_80.setObjectName("label_pron_80")
        self.label_pron_81 = QtWidgets.QLabel(self.tab_4)
        self.label_pron_81.setGeometry(QtCore.QRect(scale(120), scale(166), scale(21), scale(20)))
        font = QtGui.QFont()
        font.setFamily("Courier New")
        font.setPointSize(10)
        font.setBold(True)
        font.setWeight(75)
        self.label_pron_81.setFont(font)
        self.label_pron_81.setAlignment(QtCore.Qt.AlignCenter)
        self.label_pron_81.setObjectName("label_pron_81")
        self.label_action_60 = QtWidgets.QLabel(self.tab_4)
        self.label_action_60.setGeometry(QtCore.QRect(scale(30), scale(288), scale(71), scale(20)))
        font = QtGui.QFont()
        font.setFamily("MS Shell Dlg 2")
        self.label_action_60.setFont(font)
        self.label_action_60.setObjectName("label_action_60")
        self.label_action_61 = QtWidgets.QLabel(self.tab_4)
        self.label_action_61.setGeometry(QtCore.QRect(scale(30), scale(166), scale(71), scale(20)))
        font = QtGui.QFont()
        font.setFamily("MS Shell Dlg 2")
        self.label_action_61.setFont(font)
        self.label_action_61.setObjectName("label_action_61")
        self.label_action_62 = QtWidgets.QLabel(self.tab_4)
        self.label_action_62.setGeometry(QtCore.QRect(scale(30), scale(196), scale(71), scale(20)))
        font = QtGui.QFont()
        font.setFamily("MS Shell Dlg 2")
        self.label_action_62.setFont(font)
        self.label_action_62.setObjectName("label_action_62")
        self.label_pron_82 = QtWidgets.QLabel(self.tab_4)
        self.label_pron_82.setGeometry(QtCore.QRect(scale(120), scale(288), scale(21), scale(20)))
        font = QtGui.QFont()
        font.setFamily("Courier New")
        font.setPointSize(10)
        font.setBold(True)
        font.setWeight(75)
        self.label_pron_82.setFont(font)
        self.label_pron_82.setAlignment(QtCore.Qt.AlignCenter)
        self.label_pron_82.setObjectName("label_pron_82")
        self.label_pron_83 = QtWidgets.QLabel(self.tab_4)
        self.label_pron_83.setGeometry(QtCore.QRect(scale(180), scale(196), scale(221), scale(20)))
        font = QtGui.QFont()
        font.setFamily("Courier New")
        self.label_pron_83.setFont(font)
        self.label_pron_83.setObjectName("label_pron_83")
        self.label_pron_84 = QtWidgets.QLabel(self.tab_4)
        self.label_pron_84.setGeometry(QtCore.QRect(scale(180), scale(288), scale(329), scale(20)))
        font = QtGui.QFont()
        font.setFamily("Courier New")
        self.label_pron_84.setFont(font)
        self.label_pron_84.setObjectName("label_pron_84")
        self.label_pron_85 = QtWidgets.QLabel(self.tab_4)
        self.label_pron_85.setGeometry(QtCore.QRect(scale(180), scale(258), scale(221), scale(20)))
        font = QtGui.QFont()
        font.setFamily("Courier New")
        self.label_pron_85.setFont(font)
        self.label_pron_85.setObjectName("label_pron_85")
        self.label_pron_86 = QtWidgets.QLabel(self.tab_4)
        self.label_pron_86.setGeometry(QtCore.QRect(scale(120), scale(196), scale(21), scale(20)))
        font = QtGui.QFont()
        font.setFamily("Courier New")
        font.setPointSize(10)
        font.setBold(True)
        font.setWeight(75)
        self.label_pron_86.setFont(font)
        self.label_pron_86.setAlignment(QtCore.Qt.AlignCenter)
        self.label_pron_86.setObjectName("label_pron_86")
        self.label_pron_87 = QtWidgets.QLabel(self.tab_4)
        self.label_pron_87.setGeometry(QtCore.QRect(scale(180), scale(406), scale(221), scale(20)))
        font = QtGui.QFont()
        font.setFamily("Courier New")
        self.label_pron_87.setFont(font)
        self.label_pron_87.setObjectName("label_pron_87")
        self.label_action_63 = QtWidgets.QLabel(self.tab_4)
        self.label_action_63.setGeometry(QtCore.QRect(scale(30), scale(436), scale(71), scale(20)))
        font = QtGui.QFont()
        font.setFamily("MS Shell Dlg 2")
        self.label_action_63.setFont(font)
        self.label_action_63.setObjectName("label_action_63")
        self.label_pron_88 = QtWidgets.QLabel(self.tab_4)
        self.label_pron_88.setGeometry(QtCore.QRect(scale(120), scale(346), scale(21), scale(20)))
        font = QtGui.QFont()
        font.setFamily("Courier New")
        font.setPointSize(10)
        font.setBold(True)
        font.setWeight(75)
        self.label_pron_88.setFont(font)
        self.label_pron_88.setAlignment(QtCore.Qt.AlignCenter)
        self.label_pron_88.setObjectName("label_pron_88")
        self.label_action_64 = QtWidgets.QLabel(self.tab_4)
        self.label_action_64.setGeometry(QtCore.QRect(scale(30), scale(376), scale(71), scale(20)))
        font = QtGui.QFont()
        font.setFamily("MS Shell Dlg 2")
        self.label_action_64.setFont(font)
        self.label_action_64.setObjectName("label_action_64")
        self.label_action_65 = QtWidgets.QLabel(self.tab_4)
        self.label_action_65.setGeometry(QtCore.QRect(scale(30), scale(346), scale(71), scale(20)))
        font = QtGui.QFont()
        font.setFamily("MS Shell Dlg 2")
        self.label_action_65.setFont(font)
        self.label_action_65.setObjectName("label_action_65")
        self.label_action_66 = QtWidgets.QLabel(self.tab_4)
        self.label_action_66.setGeometry(QtCore.QRect(scale(30), scale(316), scale(71), scale(20)))
        font = QtGui.QFont()
        font.setFamily("MS Shell Dlg 2")
        self.label_action_66.setFont(font)
        self.label_action_66.setObjectName("label_action_66")
        self.label_action_67 = QtWidgets.QLabel(self.tab_4)
        self.label_action_67.setGeometry(QtCore.QRect(scale(30), scale(406), scale(71), scale(20)))
        font = QtGui.QFont()
        font.setFamily("MS Shell Dlg 2")
        self.label_action_67.setFont(font)
        self.label_action_67.setObjectName("label_action_67")
        self.label_pron_89 = QtWidgets.QLabel(self.tab_4)
        self.label_pron_89.setGeometry(QtCore.QRect(scale(120), scale(436), scale(21), scale(20)))
        font = QtGui.QFont()
        font.setFamily("Courier New")
        font.setPointSize(10)
        font.setBold(True)
        font.setWeight(75)
        self.label_pron_89.setFont(font)
        self.label_pron_89.setAlignment(QtCore.Qt.AlignCenter)
        self.label_pron_89.setObjectName("label_pron_89")
        self.label_pron_90 = QtWidgets.QLabel(self.tab_4)
        self.label_pron_90.setGeometry(QtCore.QRect(scale(180), scale(466), scale(221), scale(20)))
        font = QtGui.QFont()
        font.setFamily("Courier New")
        self.label_pron_90.setFont(font)
        self.label_pron_90.setObjectName("label_pron_90")
        self.label_pron_91 = QtWidgets.QLabel(self.tab_4)
        self.label_pron_91.setGeometry(QtCore.QRect(scale(180), scale(376), scale(221), scale(20)))
        font = QtGui.QFont()
        font.setFamily("Courier New")
        self.label_pron_91.setFont(font)
        self.label_pron_91.setObjectName("label_pron_91")
        self.label_pron_92 = QtWidgets.QLabel(self.tab_4)
        self.label_pron_92.setGeometry(QtCore.QRect(scale(120), scale(406), scale(21), scale(20)))
        font = QtGui.QFont()
        font.setFamily("Courier New")
        font.setPointSize(10)
        font.setBold(True)
        font.setWeight(75)
        self.label_pron_92.setFont(font)
        self.label_pron_92.setAlignment(QtCore.Qt.AlignCenter)
        self.label_pron_92.setObjectName("label_pron_92")
        self.label_pron_93 = QtWidgets.QLabel(self.tab_4)
        self.label_pron_93.setGeometry(QtCore.QRect(scale(180), scale(436), scale(221), scale(20)))
        font = QtGui.QFont()
        font.setFamily("Courier New")
        self.label_pron_93.setFont(font)
        self.label_pron_93.setObjectName("label_pron_93")
        self.label_pron_94 = QtWidgets.QLabel(self.tab_4)
        self.label_pron_94.setGeometry(QtCore.QRect(scale(120), scale(316), scale(21), scale(20)))
        font = QtGui.QFont()
        font.setFamily("Courier New")
        font.setPointSize(10)
        font.setBold(True)
        font.setWeight(75)
        self.label_pron_94.setFont(font)
        self.label_pron_94.setAlignment(QtCore.Qt.AlignCenter)
        self.label_pron_94.setObjectName("label_pron_94")
        self.label_pron_95 = QtWidgets.QLabel(self.tab_4)
        self.label_pron_95.setGeometry(QtCore.QRect(scale(120), scale(466), scale(21), scale(20)))
        font = QtGui.QFont()
        font.setFamily("Courier New")
        font.setPointSize(10)
        font.setBold(True)
        font.setWeight(75)
        self.label_pron_95.setFont(font)
        self.label_pron_95.setAlignment(QtCore.Qt.AlignCenter)
        self.label_pron_95.setObjectName("label_pron_95")
        self.label_pron_96 = QtWidgets.QLabel(self.tab_4)
        self.label_pron_96.setGeometry(QtCore.QRect(scale(180), scale(316), scale(221), scale(20)))
        font = QtGui.QFont()
        font.setFamily("Courier New")
        self.label_pron_96.setFont(font)
        self.label_pron_96.setObjectName("label_pron_96")
        self.label_action_68 = QtWidgets.QLabel(self.tab_4)
        self.label_action_68.setGeometry(QtCore.QRect(scale(30), scale(466), scale(71), scale(20)))
        font = QtGui.QFont()
        font.setFamily("MS Shell Dlg 2")
        self.label_action_68.setFont(font)
        self.label_action_68.setObjectName("label_action_68")
        self.label_pron_97 = QtWidgets.QLabel(self.tab_4)
        self.label_pron_97.setGeometry(QtCore.QRect(scale(120), scale(376), scale(21), scale(20)))
        font = QtGui.QFont()
        font.setFamily("Courier New")
        font.setPointSize(10)
        font.setBold(True)
        font.setWeight(75)
        self.label_pron_97.setFont(font)
        self.label_pron_97.setAlignment(QtCore.Qt.AlignCenter)
        self.label_pron_97.setObjectName("label_pron_97")
        self.label_pron_98 = QtWidgets.QLabel(self.tab_4)
        self.label_pron_98.setGeometry(QtCore.QRect(scale(180), scale(346), scale(221), scale(20)))
        font = QtGui.QFont()
        font.setFamily("Courier New")
        self.label_pron_98.setFont(font)
        self.label_pron_98.setObjectName("label_pron_98")
        self.label_H5_4 = QtWidgets.QLabel(self.tab_4)
        self.label_H5_4.setGeometry(QtCore.QRect(scale(26), scale(230), scale(521), scale(16)))
        font = QtGui.QFont()
        font.setBold(True)
        font.setWeight(75)
        self.label_H5_4.setFont(font)
        self.label_H5_4.setStyleSheet("background: lightblue")
        self.label_H5_4.setObjectName("label_H5_4")
        self.label_pron_99 = QtWidgets.QLabel(self.tab_4)
        self.label_pron_99.setGeometry(QtCore.QRect(scale(120), scale(496), scale(21), scale(20)))
        font = QtGui.QFont()
        font.setFamily("Courier New")
        font.setPointSize(10)
        font.setBold(True)
        font.setWeight(75)
        self.label_pron_99.setFont(font)
        self.label_pron_99.setAlignment(QtCore.Qt.AlignCenter)
        self.label_pron_99.setObjectName("label_pron_99")
        self.label_pron_100 = QtWidgets.QLabel(self.tab_4)
        self.label_pron_100.setGeometry(QtCore.QRect(scale(180), scale(496), scale(221), scale(20)))
        font = QtGui.QFont()
        font.setFamily("Courier New")
        self.label_pron_100.setFont(font)
        self.label_pron_100.setObjectName("label_pron_100")
        self.label_action_69 = QtWidgets.QLabel(self.tab_4)
        self.label_action_69.setGeometry(QtCore.QRect(scale(30), scale(496), scale(71), scale(20)))
        font = QtGui.QFont()
        font.setFamily("MS Shell Dlg 2")
        self.label_action_69.setFont(font)
        self.label_action_69.setObjectName("label_action_69")
        self.label_pron_101 = QtWidgets.QLabel(self.tab_4)
        self.label_pron_101.setGeometry(QtCore.QRect(scale(180), scale(526), scale(221), scale(20)))
        font = QtGui.QFont()
        font.setFamily("Courier New")
        self.label_pron_101.setFont(font)
        self.label_pron_101.setObjectName("label_pron_101")
        self.label_pron_102 = QtWidgets.QLabel(self.tab_4)
        self.label_pron_102.setGeometry(QtCore.QRect(scale(120), scale(526), scale(21), scale(20)))
        font = QtGui.QFont()
        font.setFamily("Courier New")
        font.setPointSize(10)
        font.setBold(True)
        font.setWeight(75)
        self.label_pron_102.setFont(font)
        self.label_pron_102.setAlignment(QtCore.Qt.AlignCenter)
        self.label_pron_102.setObjectName("label_pron_102")
        self.label_action_70 = QtWidgets.QLabel(self.tab_4)
        self.label_action_70.setGeometry(QtCore.QRect(scale(30), scale(526), scale(71), scale(20)))
        font = QtGui.QFont()
        font.setFamily("MS Shell Dlg 2")
        self.label_action_70.setFont(font)
        self.label_action_70.setObjectName("label_action_70")
        self.tabWidget.addTab(self.tab_4, "")

        self.retranslateUi(Dialog_commands)
        self.tabWidget.setCurrentIndex(0)
        QtCore.QMetaObject.connectSlotsByName(Dialog_commands)

    def retranslateUi(self, Dialog_commands):
        _translate = QtCore.QCoreApplication.translate
        Dialog_commands.setWindowTitle(_translate("Dialog_commands", "Ukazi, ločila in posebni znaki"))
        self.pushButton_close.setText(_translate("Dialog_commands", "Zapri"))
        self.label_H1_2.setText(_translate("Dialog_commands", "A K C I J A"))
        self.label_H1_4.setText(_translate("Dialog_commands", " vrstice in odstavki"))
        self.label_action_46.setText(_translate("Dialog_commands", "Pojdi v novo vrsto"))
        self.label_action_42.setText(_translate("Dialog_commands", "Naredi odstavek"))
        self.label_H2_2.setText(_translate("Dialog_commands", "oblikovanje besedila"))
        self.label_action_50.setText(_translate("Dialog_commands", "Vključi / izključi odebeljeno pisavo"))
        self.label_action_49.setText(_translate("Dialog_commands", "Vključi / izključi poševno pisavo"))
        self.label_action_51.setText(_translate("Dialog_commands", "Vključi / izključi podčrtano pisavo"))
        self.label_action_40.setText(_translate("Dialog_commands", "Poravnaj na sredino"))
        self.label_action_32.setText(_translate("Dialog_commands", "Poravnaj na levo"))
        self.label_action_37.setText(_translate("Dialog_commands", "Poravnaj na desno"))
        self.label_action_52.setText(_translate("Dialog_commands", "Vključi / izključi velike črke"))
        self.label_action_53.setText(_translate("Dialog_commands", "Vključi / izključi male črke"))
        self.label_action_54.setText(_translate("Dialog_commands", "Začni z veliko začetnico"))
        self.label_H3_2.setText(_translate("Dialog_commands", "brisanje besedila"))
        self.label_action_41.setText(_translate("Dialog_commands", "Razveljavi (undo)"))
        self.label_action_44.setText(_translate("Dialog_commands", "Briši zadnji znak / označeno besedilo"))
        self.label_action_73.setText(_translate("Dialog_commands", "Briši zadnjih n znakov"))
        self.label_action_39.setText(_translate("Dialog_commands", "Označi vse besedilo"))
        self.label_H4_2.setText(_translate("Dialog_commands", "pomnjenje in zaključek snemanja"))
        self.label_action_71.setText(_translate("Dialog_commands", "Zapomni narekovano besedilo"))
        self.label_action_72.setText(_translate("Dialog_commands", "Prilepi zapomnjeno besedilo"))
        self.label_action_45.setText(_translate("Dialog_commands", "Zaključi snemanje"))
        self.label_action_38.setText(_translate("Dialog_commands", "Pavza"))
        self.label_H1_3.setText(_translate("Dialog_commands", "I Z G O V O R J A V A   U K A Z A"))
        self.label_pron_56.setText(_translate("Dialog_commands", "nova vrsta, nova vrstica"))
        self.label_pron_58.setText(_translate("Dialog_commands", "nov odstavek"))
        self.label_pron_65.setText(_translate("Dialog_commands", "vključi/izključi bold, vključi/izključi odebeljeno"))
        self.label_pron_66.setText(_translate("Dialog_commands", "vključi/izključi italik, vključi/izključi kurzivno, vključi/izključi poševno"))
        self.label_pron_67.setText(_translate("Dialog_commands", "vključi/izključi podčrtano"))
        self.label_pron_53.setText(_translate("Dialog_commands", "poravnaj na sredo, poravnaj na sredino"))
        self.label_pron_62.setText(_translate("Dialog_commands", "poravnaj levo"))
        self.label_pron_57.setText(_translate("Dialog_commands", "poravnaj desno"))
        self.label_pron_68.setText(_translate("Dialog_commands", "vključi/izključi velike črke, vključi/izključi velike"))
        self.label_pron_69.setText(_translate("Dialog_commands", "vključi/izključi male črke, vključi/izključi male"))
        self.label_pron_70.setText(_translate("Dialog_commands", "velika začetnica"))
        self.label_pron_61.setText(_translate("Dialog_commands", "razveljavi"))
        self.label_pron_105.setText(_translate("Dialog_commands", "briši"))
        self.label_pron_63.setText(_translate("Dialog_commands", "briši n"))
        self.label_pron_55.setText(_translate("Dialog_commands", "označi vse"))
        self.label_pron_104.setText(_translate("Dialog_commands", "zapomni"))
        self.label_pron_103.setText(_translate("Dialog_commands", "prilepi"))
        self.label_pron_52.setText(_translate("Dialog_commands", "konec diktata, zaključi snemanje, konec snemanja"))
        self.label_pron_54.setText(_translate("Dialog_commands", "pavza"))
        self.tabWidget.setTabText(self.tabWidget.indexOf(self.tab_3), _translate("Dialog_commands", "Osnovni ukazi"))
        self.label_action_55.setText(_translate("Dialog_commands", "pika"))
        self.label_H5_3.setText(_translate("Dialog_commands", " L O Č I L A"))
        self.label_pron_71.setText(_translate("Dialog_commands", "pika"))
        self.label_pron_72.setText(_translate("Dialog_commands", "."))
        self.label_pron_73.setText(_translate("Dialog_commands", "vejica"))
        self.label_pron_74.setText(_translate("Dialog_commands", ","))
        self.label_action_56.setText(_translate("Dialog_commands", "vejica"))
        self.label_pron_75.setText(_translate("Dialog_commands", "klicaj"))
        self.label_pron_76.setText(_translate("Dialog_commands", "!"))
        self.label_action_57.setText(_translate("Dialog_commands", "klicaj"))
        self.label_action_58.setText(_translate("Dialog_commands", "vprašaj"))
        self.label_pron_77.setText(_translate("Dialog_commands", "vprašaj"))
        self.label_pron_78.setText(_translate("Dialog_commands", "?"))
        self.label_pron_79.setText(_translate("Dialog_commands", "dvopičje"))
        self.label_action_59.setText(_translate("Dialog_commands", "vezaj"))
        self.label_pron_80.setText(_translate("Dialog_commands", "-"))
        self.label_pron_81.setText(_translate("Dialog_commands", ":"))
        self.label_action_60.setText(_translate("Dialog_commands", "oklepaj"))
        self.label_action_61.setText(_translate("Dialog_commands", "dvopičje"))
        self.label_action_62.setText(_translate("Dialog_commands", "podpičje"))
        self.label_pron_82.setText(_translate("Dialog_commands", "("))
        self.label_pron_83.setText(_translate("Dialog_commands", "podpičje"))
        self.label_pron_84.setText(_translate("Dialog_commands", "oklepaj, odprti oklepaj, v oklepaju"))
        self.label_pron_85.setText(_translate("Dialog_commands", "vezaj, črtica, pomišjaj"))
        self.label_pron_86.setText(_translate("Dialog_commands", ";"))
        self.label_pron_87.setText(_translate("Dialog_commands", "krat"))
        self.label_action_63.setText(_translate("Dialog_commands", "deljeno"))
        self.label_pron_88.setText(_translate("Dialog_commands", "+"))
        self.label_action_64.setText(_translate("Dialog_commands", "minus"))
        self.label_action_65.setText(_translate("Dialog_commands", "plus"))
        self.label_action_66.setText(_translate("Dialog_commands", "zaklepaj"))
        self.label_action_67.setText(_translate("Dialog_commands", "krat"))
        self.label_pron_89.setText(_translate("Dialog_commands", "/"))
        self.label_pron_90.setText(_translate("Dialog_commands", "poševnica, na, čez"))
        self.label_pron_91.setText(_translate("Dialog_commands", "minus"))
        self.label_pron_92.setText(_translate("Dialog_commands", "x"))
        self.label_pron_93.setText(_translate("Dialog_commands", "deljeno"))
        self.label_pron_94.setText(_translate("Dialog_commands", ")"))
        self.label_pron_95.setText(_translate("Dialog_commands", "/"))
        self.label_pron_96.setText(_translate("Dialog_commands", "zaklepaj, zaprti oklepaj"))
        self.label_action_68.setText(_translate("Dialog_commands", "poševnica"))
        self.label_pron_97.setText(_translate("Dialog_commands", "-"))
        self.label_pron_98.setText(_translate("Dialog_commands", "plus"))
        self.label_H5_4.setText(_translate("Dialog_commands", " P O S E B N I   Z N A K I"))
        self.label_pron_99.setText(_translate("Dialog_commands", "°"))
        self.label_pron_100.setText(_translate("Dialog_commands", "stopinja"))
        self.label_action_69.setText(_translate("Dialog_commands", "stopinja"))
        self.label_pron_101.setText(_translate("Dialog_commands", "procent"))
        self.label_pron_102.setText(_translate("Dialog_commands", "%"))
        self.label_action_70.setText(_translate("Dialog_commands", "procent"))
        self.tabWidget.setTabText(self.tabWidget.indexOf(self.tab_4), _translate("Dialog_commands", "Ločila in posebni znaki"))

class Ui_Dialog_sendLog(object):
    def setupUi(self, Dialog_sendLog):
        Dialog_sendLog.setObjectName("Dialog_sendLog")
        Dialog_sendLog.resize(scale(331), scale(137))
        self.label_message = QtWidgets.QLabel(Dialog_sendLog)
        self.label_message.setGeometry(QtCore.QRect(scale(40), scale(10), scale(251), scale(41)))
        font = QtGui.QFont()
        font.setPointSize(8)
        font.setBold(False)
        font.setWeight(50)
        self.label_message.setFont(font)
        self.label_message.setAlignment(QtCore.Qt.AlignCenter)
        self.label_message.setWordWrap(True)
        self.label_message.setObjectName("label_message")
        self.pushButton_confirm = QtWidgets.QPushButton(Dialog_sendLog)
        self.pushButton_confirm.setGeometry(QtCore.QRect(scale(136), scale(100), scale(75), scale(23)))
        self.pushButton_confirm.setObjectName("pushButton_confirm")
        self.pushButton_cancel = QtWidgets.QPushButton(Dialog_sendLog)
        self.pushButton_cancel.setGeometry(QtCore.QRect(scale(216), scale(100), scale(75), scale(23)))
        self.pushButton_cancel.setObjectName("pushButton_cancel")
        self.label_upload_result = QtWidgets.QLabel(Dialog_sendLog)
        self.label_upload_result.setGeometry(QtCore.QRect(scale(40), scale(60), scale(251), scale(20)))
        font = QtGui.QFont()
        font.setPointSize(7)
        self.label_upload_result.setFont(font)
        self.label_upload_result.setText("")
        self.label_upload_result.setAlignment(QtCore.Qt.AlignCenter)
        self.label_upload_result.setObjectName("label_upload_result")

        self.retranslateUi(Dialog_sendLog)
        QtCore.QMetaObject.connectSlotsByName(Dialog_sendLog)

    def retranslateUi(self, Dialog_sendLog):
        _translate = QtCore.QCoreApplication.translate
        Dialog_sendLog.setWindowTitle(_translate("Dialog_sendLog", "Log datoteke"))
        self.label_message.setText(_translate("Dialog_sendLog", "Log datoteke bodo poslane v pregled vzdrževalcem sistema TB-listener!"))
        self.pushButton_confirm.setText(_translate("Dialog_sendLog", "Pošlji"))
        self.pushButton_cancel.setText(_translate("Dialog_sendLog", "Zapri"))

class Ui_Dialog_detailed_settings_old(object):
    def setupUi(self, Dialog_detailed_settings):
        Dialog_detailed_settings.setObjectName("Dialog_detailed_settings")
        Dialog_detailed_settings.resize(scale(819), scale(629))
        Dialog_detailed_settings.setStyleSheet("QPushButton {\n"
"    background-color: lightgrey;\n"
"}\n"
"QDialog {\n"
"    background-color: rgb(234, 241, 221);\n"
"}")
        self.tabWidget = QtWidgets.QTabWidget(Dialog_detailed_settings)
        self.tabWidget.setEnabled(True)
        self.tabWidget.setGeometry(QtCore.QRect(scale(10), scale(10), scale(801), scale(571)))
        self.tabWidget.setStyleSheet("background-color:rgb(244, 244, 244);\n"
"")
        self.tabWidget.setTabShape(QtWidgets.QTabWidget.Rounded)
        self.tabWidget.setObjectName("tabWidget")
        self.tab_basic = QtWidgets.QWidget()
        self.tab_basic.setObjectName("tab_basic")
        self.groupBox_postprocessing = QtWidgets.QGroupBox(self.tab_basic)
        self.groupBox_postprocessing.setGeometry(QtCore.QRect(scale(20), scale(20), scale(371), scale(161)))
        font = QtGui.QFont()
        font.setBold(True)
        font.setWeight(75)
        self.groupBox_postprocessing.setFont(font)
        self.groupBox_postprocessing.setFlat(False)
        self.groupBox_postprocessing.setObjectName("groupBox_postprocessing")
        self.checkBox_numbers = QtWidgets.QCheckBox(self.groupBox_postprocessing)
        self.checkBox_numbers.setGeometry(QtCore.QRect(scale(20), scale(30), scale(251), scale(17)))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.checkBox_numbers.setFont(font)
        self.checkBox_numbers.setObjectName("checkBox_numbers")
        self.checkBox_spp = QtWidgets.QCheckBox(self.groupBox_postprocessing)
        self.checkBox_spp.setGeometry(QtCore.QRect(scale(20), scale(60), scale(251), scale(17)))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.checkBox_spp.setFont(font)
        self.checkBox_spp.setObjectName("checkBox_spp")
        self.checkBox_capitalization = QtWidgets.QCheckBox(self.groupBox_postprocessing)
        self.checkBox_capitalization.setGeometry(QtCore.QRect(scale(20), scale(90), scale(271), scale(17)))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.checkBox_capitalization.setFont(font)
        self.checkBox_capitalization.setObjectName("checkBox_capitalization")
        self.checkBox_beep_on_final = QtWidgets.QCheckBox(self.groupBox_postprocessing)
        self.checkBox_beep_on_final.setGeometry(QtCore.QRect(scale(20), scale(120), scale(321), scale(17)))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.checkBox_beep_on_final.setFont(font)
        self.checkBox_beep_on_final.setObjectName("checkBox_beep_on_final")
        self.groupBox_dictaphone = QtWidgets.QGroupBox(self.tab_basic)
        self.groupBox_dictaphone.setGeometry(QtCore.QRect(scale(410), scale(330), scale(371), scale(111)))
        font = QtGui.QFont()
        font.setBold(True)
        font.setWeight(75)
        self.groupBox_dictaphone.setFont(font)
        self.groupBox_dictaphone.setObjectName("groupBox_dictaphone")
        self.checkBox_dictaphone_toggle = QtWidgets.QCheckBox(self.groupBox_dictaphone)
        self.checkBox_dictaphone_toggle.setGeometry(QtCore.QRect(scale(20), scale(30), scale(311), scale(17)))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.checkBox_dictaphone_toggle.setFont(font)
        self.checkBox_dictaphone_toggle.setObjectName("checkBox_dictaphone_toggle")
        self.lineEdit_toggle_key_combination = QtWidgets.QLineEdit(self.groupBox_dictaphone)
        self.lineEdit_toggle_key_combination.setGeometry(QtCore.QRect(scale(170), scale(60), scale(181), scale(20)))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.lineEdit_toggle_key_combination.setFont(font)
        self.lineEdit_toggle_key_combination.setStyleSheet("background-color: white;")
        self.lineEdit_toggle_key_combination.setObjectName("lineEdit_toggle_key_combination")
        self.label_toggle_key_combination = QtWidgets.QLabel(self.groupBox_dictaphone)
        self.label_toggle_key_combination.setGeometry(QtCore.QRect(scale(38), scale(60), scale(131), scale(16)))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.label_toggle_key_combination.setFont(font)
        self.label_toggle_key_combination.setObjectName("label_toggle_key_combination")
        self.groupBox_general = QtWidgets.QGroupBox(self.tab_basic)
        self.groupBox_general.setGeometry(QtCore.QRect(scale(410), scale(160), scale(371), scale(141)))
        font = QtGui.QFont()
        font.setBold(True)
        font.setWeight(75)
        self.groupBox_general.setFont(font)
        self.groupBox_general.setObjectName("groupBox_general")
        self.checkBox_minimize = QtWidgets.QCheckBox(self.groupBox_general)
        self.checkBox_minimize.setGeometry(QtCore.QRect(scale(20), scale(30), scale(311), scale(17)))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.checkBox_minimize.setFont(font)
        self.checkBox_minimize.setObjectName("checkBox_minimize")
        self.checkBox_purge_queue = QtWidgets.QCheckBox(self.groupBox_general)
        self.checkBox_purge_queue.setGeometry(QtCore.QRect(scale(20), scale(90), scale(311), scale(17)))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.checkBox_purge_queue.setFont(font)
        self.checkBox_purge_queue.setObjectName("checkBox_purge_queue")
        self.checkBox_listen_external = QtWidgets.QCheckBox(self.groupBox_general)
        self.checkBox_listen_external.setGeometry(QtCore.QRect(scale(20), scale(60), scale(311), scale(17)))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.checkBox_listen_external.setFont(font)
        self.checkBox_listen_external.setObjectName("checkBox_listen_external")
        self.groupBox_proxy = QtWidgets.QGroupBox(self.tab_basic)
        self.groupBox_proxy.setGeometry(QtCore.QRect(scale(20), scale(300), scale(371), scale(231)))
        font = QtGui.QFont()
        font.setBold(True)
        font.setWeight(75)
        self.groupBox_proxy.setFont(font)
        self.groupBox_proxy.setObjectName("groupBox_proxy")
        self.checkBox_use_proxy = QtWidgets.QCheckBox(self.groupBox_proxy)
        self.checkBox_use_proxy.setGeometry(QtCore.QRect(scale(20), scale(30), scale(311), scale(17)))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.checkBox_use_proxy.setFont(font)
        self.checkBox_use_proxy.setObjectName("checkBox_use_proxy")
        self.lineEdit_host = QtWidgets.QLineEdit(self.groupBox_proxy)
        self.lineEdit_host.setGeometry(QtCore.QRect(scale(150), scale(60), scale(181), scale(20)))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.lineEdit_host.setFont(font)
        self.lineEdit_host.setStyleSheet("background-color: white;")
        self.lineEdit_host.setObjectName("lineEdit_host")
        self.label_host = QtWidgets.QLabel(self.groupBox_proxy)
        self.label_host.setGeometry(QtCore.QRect(scale(37), scale(60), scale(100), scale(20)))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.label_host.setFont(font)
        self.label_host.setAlignment(QtCore.Qt.AlignRight|QtCore.Qt.AlignTrailing|QtCore.Qt.AlignVCenter)
        self.label_host.setObjectName("label_host")
        self.label_port = QtWidgets.QLabel(self.groupBox_proxy)
        self.label_port.setGeometry(QtCore.QRect(scale(37), scale(90), scale(100), scale(20)))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.label_port.setFont(font)
        self.label_port.setAlignment(QtCore.Qt.AlignRight|QtCore.Qt.AlignTrailing|QtCore.Qt.AlignVCenter)
        self.label_port.setObjectName("label_port")
        self.lineEdit_port = QtWidgets.QLineEdit(self.groupBox_proxy)
        self.lineEdit_port.setGeometry(QtCore.QRect(scale(150), scale(90), scale(51), scale(20)))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.lineEdit_port.setFont(font)
        self.lineEdit_port.setStyleSheet("background-color: white;")
        self.lineEdit_port.setObjectName("lineEdit_port")
        self.label_protocol = QtWidgets.QLabel(self.groupBox_proxy)
        self.label_protocol.setGeometry(QtCore.QRect(scale(37), scale(120), scale(100), scale(20)))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.label_protocol.setFont(font)
        self.label_protocol.setAlignment(QtCore.Qt.AlignRight|QtCore.Qt.AlignTrailing|QtCore.Qt.AlignVCenter)
        self.label_protocol.setObjectName("label_protocol")
        self.label_username = QtWidgets.QLabel(self.groupBox_proxy)
        self.label_username.setGeometry(QtCore.QRect(scale(37), scale(150), scale(100), scale(20)))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.label_username.setFont(font)
        self.label_username.setAlignment(QtCore.Qt.AlignRight|QtCore.Qt.AlignTrailing|QtCore.Qt.AlignVCenter)
        self.label_username.setObjectName("label_username")
        self.label_password = QtWidgets.QLabel(self.groupBox_proxy)
        self.label_password.setGeometry(QtCore.QRect(scale(37), scale(180), scale(100), scale(20)))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.label_password.setFont(font)
        self.label_password.setAlignment(QtCore.Qt.AlignRight|QtCore.Qt.AlignTrailing|QtCore.Qt.AlignVCenter)
        self.label_password.setObjectName("label_password")
        self.lineEdit_username = QtWidgets.QLineEdit(self.groupBox_proxy)
        self.lineEdit_username.setGeometry(QtCore.QRect(scale(150), scale(150), scale(181), scale(20)))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.lineEdit_username.setFont(font)
        self.lineEdit_username.setStyleSheet("background-color: white;")
        self.lineEdit_username.setObjectName("lineEdit_username")
        self.lineEdit_password = QtWidgets.QLineEdit(self.groupBox_proxy)
        self.lineEdit_password.setGeometry(QtCore.QRect(scale(150), scale(180), scale(181), scale(20)))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.lineEdit_password.setFont(font)
        self.lineEdit_password.setStyleSheet("background-color: white;")
        self.lineEdit_password.setObjectName("lineEdit_password")
        self.comboBox_protocol = QtWidgets.QComboBox(self.groupBox_proxy)
        self.comboBox_protocol.setGeometry(QtCore.QRect(scale(150), scale(120), scale(121), scale(20)))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.comboBox_protocol.setFont(font)
        self.comboBox_protocol.setStyleSheet("background-color: white;\n"
"border-style: solid;\n"
"border-width: 1px;")
        self.comboBox_protocol.setObjectName("comboBox_protocol")
        self.comboBox_protocol.addItem("")
        self.comboBox_protocol.addItem("")
        self.comboBox_protocol.addItem("")
        self.comboBox_protocol.addItem("")
        self.comboBox_protocol.addItem("")
        self.comboBox_protocol.addItem("")
        self.groupBox_focus = QtWidgets.QGroupBox(self.tab_basic)
        self.groupBox_focus.setGeometry(QtCore.QRect(scale(410), scale(20), scale(371), scale(111)))
        font = QtGui.QFont()
        font.setBold(True)
        font.setWeight(75)
        self.groupBox_focus.setFont(font)
        self.groupBox_focus.setStyleSheet("")
        self.groupBox_focus.setObjectName("groupBox_focus")
        self.checkBox_focus_by_key = QtWidgets.QCheckBox(self.groupBox_focus)
        self.checkBox_focus_by_key.setGeometry(QtCore.QRect(scale(20), scale(30), scale(180), scale(17)))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.checkBox_focus_by_key.setFont(font)
        self.checkBox_focus_by_key.setObjectName("checkBox_focus_by_key")
        self.checkBox_focus_by_title = QtWidgets.QCheckBox(self.groupBox_focus)
        self.checkBox_focus_by_title.setGeometry(QtCore.QRect(scale(20), scale(60), scale(180), scale(17)))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.checkBox_focus_by_title.setFont(font)
        self.checkBox_focus_by_title.setObjectName("checkBox_focus_by_title")
        self.lineEdit_focus_key = QtWidgets.QLineEdit(self.groupBox_focus)
        self.lineEdit_focus_key.setGeometry(QtCore.QRect(scale(150), scale(30), scale(201), scale(20)))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.lineEdit_focus_key.setFont(font)
        self.lineEdit_focus_key.setStyleSheet("background-color: white;")
        self.lineEdit_focus_key.setObjectName("lineEdit_focus_key")
        self.lineEdit_focus_win_title = QtWidgets.QLineEdit(self.groupBox_focus)
        self.lineEdit_focus_win_title.setGeometry(QtCore.QRect(scale(150), scale(60), scale(201), scale(20)))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.lineEdit_focus_win_title.setFont(font)
        self.lineEdit_focus_win_title.setStyleSheet("background-color: white;")
        self.lineEdit_focus_win_title.setObjectName("lineEdit_focus_win_title")
        self.groupBox_PID = QtWidgets.QGroupBox(self.tab_basic)
        self.groupBox_PID.setGeometry(QtCore.QRect(scale(20), scale(210), scale(371), scale(61)))
        font = QtGui.QFont()
        font.setBold(True)
        font.setWeight(75)
        self.groupBox_PID.setFont(font)
        self.groupBox_PID.setObjectName("groupBox_PID")
        self.checkBox_show_PID = QtWidgets.QCheckBox(self.groupBox_PID)
        self.checkBox_show_PID.setGeometry(QtCore.QRect(scale(20), scale(20), scale(251), scale(17)))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.checkBox_show_PID.setFont(font)
        self.checkBox_show_PID.setObjectName("checkBox_show_PID")
        self.tabWidget.addTab(self.tab_basic, "")
        self.tab_commands = QtWidgets.QWidget()
        self.tab_commands.setObjectName("tab_commands")
        self.groupBox_command_settings = QtWidgets.QGroupBox(self.tab_commands)
        self.groupBox_command_settings.setGeometry(QtCore.QRect(scale(20), scale(20), scale(721), scale(451)))
        self.groupBox_command_settings.setStyleSheet("QListWidget, QTextEdit {\n"
"    background-color: white;\n"
"}")
        self.groupBox_command_settings.setObjectName("groupBox_command_settings")
        self.listWidget_command = QtWidgets.QListWidget(self.groupBox_command_settings)
        self.listWidget_command.setGeometry(QtCore.QRect(scale(20), scale(50), scale(211), scale(381)))
        self.listWidget_command.setStyleSheet("")
        self.listWidget_command.setObjectName("listWidget_command")
        item = QtWidgets.QListWidgetItem()
        self.listWidget_command.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_command.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_command.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_command.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_command.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_command.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_command.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_command.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_command.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_command.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_command.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_command.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_command.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_command.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_command.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_command.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_command.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_command.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_command.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_command.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_command.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_command.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_command.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_command.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_command.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_command.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_command.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_command.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_command.addItem(item)
        self.label_command = QtWidgets.QLabel(self.groupBox_command_settings)
        self.label_command.setGeometry(QtCore.QRect(scale(20), scale(30), scale(211), scale(20)))
        font = QtGui.QFont()
        font.setBold(True)
        font.setWeight(75)
        self.label_command.setFont(font)
        self.label_command.setObjectName("label_command")
        self.label_command_meaning = QtWidgets.QLabel(self.groupBox_command_settings)
        self.label_command_meaning.setGeometry(QtCore.QRect(scale(280), scale(30), scale(211), scale(20)))
        font = QtGui.QFont()
        font.setBold(True)
        font.setWeight(75)
        self.label_command_meaning.setFont(font)
        self.label_command_meaning.setObjectName("label_command_meaning")
        self.textEdit_command_meaning = QtWidgets.QPlainTextEdit(self.groupBox_command_settings)
        self.textEdit_command_meaning.setGeometry(QtCore.QRect(scale(280), scale(50), scale(421), scale(121)))
        self.textEdit_command_meaning.setStyleSheet("background-color: white")
        self.textEdit_command_meaning.setObjectName("textEdit_command_meaning")
        self.groupBox = QtWidgets.QGroupBox(self.groupBox_command_settings)
        self.groupBox.setGeometry(QtCore.QRect(scale(280), scale(189), scale(421), scale(241)))
        font = QtGui.QFont()
        font.setBold(True)
        font.setWeight(75)
        self.groupBox.setFont(font)
        self.groupBox.setStyleSheet("")
        self.groupBox.setObjectName("groupBox")
        self.label_dest = QtWidgets.QLabel(self.groupBox)
        self.label_dest.setGeometry(QtCore.QRect(scale(110), scale(40), scale(47), scale(21)))
        self.label_dest.setObjectName("label_dest")
        self.spinBox_repeat = QtWidgets.QSpinBox(self.groupBox)
        self.spinBox_repeat.setGeometry(QtCore.QRect(scale(150), scale(100), scale(42), scale(22)))
        self.spinBox_repeat.setStyleSheet("background-color: white;")
        self.spinBox_repeat.setObjectName("spinBox_repeat")
        self.lineEdit_copy2buf = QtWidgets.QLineEdit(self.groupBox)
        self.lineEdit_copy2buf.setGeometry(QtCore.QRect(scale(150), scale(160), scale(151), scale(22)))
        self.lineEdit_copy2buf.setStyleSheet("background-color: white;")
        self.lineEdit_copy2buf.setObjectName("lineEdit_copy2buf")
        self.label_copy2clip = QtWidgets.QLabel(self.groupBox)
        self.label_copy2clip.setGeometry(QtCore.QRect(scale(40), scale(130), scale(100), scale(22)))
        self.label_copy2clip.setAlignment(QtCore.Qt.AlignRight|QtCore.Qt.AlignTrailing|QtCore.Qt.AlignVCenter)
        self.label_copy2clip.setObjectName("label_copy2clip")
        self.label_copy2buf = QtWidgets.QLabel(self.groupBox)
        self.label_copy2buf.setGeometry(QtCore.QRect(scale(40), scale(160), scale(100), scale(22)))
        self.label_copy2buf.setAlignment(QtCore.Qt.AlignRight|QtCore.Qt.AlignTrailing|QtCore.Qt.AlignVCenter)
        self.label_copy2buf.setObjectName("label_copy2buf")
        self.label_keypress = QtWidgets.QLabel(self.groupBox)
        self.label_keypress.setGeometry(QtCore.QRect(scale(40), scale(70), scale(100), scale(22)))
        self.label_keypress.setAlignment(QtCore.Qt.AlignRight|QtCore.Qt.AlignTrailing|QtCore.Qt.AlignVCenter)
        self.label_keypress.setObjectName("label_keypress")
        self.lineEdit_keypress = QtWidgets.QLineEdit(self.groupBox)
        self.lineEdit_keypress.setGeometry(QtCore.QRect(scale(150), scale(70), scale(151), scale(22)))
        self.lineEdit_keypress.setStyleSheet("background-color: white;")
        self.lineEdit_keypress.setObjectName("lineEdit_keypress")
        self.comboBox_destination_format = QtWidgets.QComboBox(self.groupBox)
        self.comboBox_destination_format.setGeometry(QtCore.QRect(scale(150), scale(40), scale(151), scale(22)))
        self.comboBox_destination_format.setStyleSheet("background-color: white;\n"
"border-style: solid;\n"
"border-width: 1px;\n"
"border-color: grey;")
        self.comboBox_destination_format.setObjectName("comboBox_destination_format")
        self.comboBox_destination_format.addItem("")
        self.comboBox_destination_format.addItem("")
        self.comboBox_destination_format.addItem("")
        self.comboBox_destination_format.addItem("")
        self.lineEdit_copy2clip = QtWidgets.QLineEdit(self.groupBox)
        self.lineEdit_copy2clip.setGeometry(QtCore.QRect(scale(150), scale(130), scale(151), scale(22)))
        self.lineEdit_copy2clip.setStyleSheet("background-color: white;")
        self.lineEdit_copy2clip.setObjectName("lineEdit_copy2clip")
        self.label_repeat = QtWidgets.QLabel(self.groupBox)
        self.label_repeat.setGeometry(QtCore.QRect(scale(40), scale(100), scale(100), scale(22)))
        self.label_repeat.setAlignment(QtCore.Qt.AlignRight|QtCore.Qt.AlignTrailing|QtCore.Qt.AlignVCenter)
        self.label_repeat.setObjectName("label_repeat")
        self.tabWidget.addTab(self.tab_commands, "")
        self.tab_replacements = QtWidgets.QWidget()
        self.tab_replacements.setEnabled(True)
        self.tab_replacements.setObjectName("tab_replacements")
        self.groupBox_general_replacements = QtWidgets.QGroupBox(self.tab_replacements)
        self.groupBox_general_replacements.setGeometry(QtCore.QRect(scale(20), scale(10), scale(751), scale(471)))
        font = QtGui.QFont()
        font.setBold(True)
        font.setWeight(75)
        self.groupBox_general_replacements.setFont(font)
        self.groupBox_general_replacements.setStyleSheet("QPushButton {background-color: lightgray}")
        self.groupBox_general_replacements.setObjectName("groupBox_general_replacements")
        self.pushButton_add_basic_repl = QtWidgets.QPushButton(self.groupBox_general_replacements)
        self.pushButton_add_basic_repl.setGeometry(QtCore.QRect(scale(30), scale(430), scale(61), scale(23)))
        self.pushButton_add_basic_repl.setStyleSheet("")
        self.pushButton_add_basic_repl.setObjectName("pushButton_add_basic_repl")
        self.pushButton_del_basic_repl = QtWidgets.QPushButton(self.groupBox_general_replacements)
        self.pushButton_del_basic_repl.setGeometry(QtCore.QRect(scale(170), scale(430), scale(61), scale(23)))
        self.pushButton_del_basic_repl.setStyleSheet("")
        self.pushButton_del_basic_repl.setObjectName("pushButton_del_basic_repl")
        self.lineEdit_basic_repl = QtWidgets.QLineEdit(self.groupBox_general_replacements)
        self.lineEdit_basic_repl.setGeometry(QtCore.QRect(scale(30), scale(400), scale(691), scale(22)))
        self.lineEdit_basic_repl.setStyleSheet("background-color: white\n"
"")
        self.lineEdit_basic_repl.setObjectName("lineEdit_basic_repl")
        self.listWidget_basic_repl = QtWidgets.QListWidget(self.groupBox_general_replacements)
        self.listWidget_basic_repl.setGeometry(QtCore.QRect(scale(30), scale(80), scale(691), scale(311)))
        self.listWidget_basic_repl.setStyleSheet("background-color: white")
        self.listWidget_basic_repl.setAlternatingRowColors(True)
        self.listWidget_basic_repl.setModelColumn(0)
        self.listWidget_basic_repl.setObjectName("listWidget_basic_repl")
        item = QtWidgets.QListWidgetItem()
        self.listWidget_basic_repl.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_basic_repl.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_basic_repl.addItem(item)
        self.pushButton_update_basic_repl = QtWidgets.QPushButton(self.groupBox_general_replacements)
        self.pushButton_update_basic_repl.setGeometry(QtCore.QRect(scale(100), scale(430), scale(61), scale(23)))
        self.pushButton_update_basic_repl.setStyleSheet("")
        self.pushButton_update_basic_repl.setObjectName("pushButton_update_basic_repl")
        self.label = QtWidgets.QLabel(self.groupBox_general_replacements)
        self.label.setGeometry(QtCore.QRect(scale(30), scale(30), scale(41), scale(20)))
        font = QtGui.QFont()
        font.setPointSize(7)
        self.label.setFont(font)
        self.label.setObjectName("label")
        self.lineEdit_filter = QtWidgets.QLineEdit(self.groupBox_general_replacements)
        self.lineEdit_filter.setGeometry(QtCore.QRect(scale(30), scale(50), scale(691), scale(22)))
        self.lineEdit_filter.setStyleSheet("background-color: white")
        self.lineEdit_filter.setObjectName("lineEdit_filter")
        self.label_replacement_result = QtWidgets.QLabel(self.groupBox_general_replacements)
        self.label_replacement_result.setGeometry(QtCore.QRect(scale(240), scale(430), scale(471), scale(23)))
        font = QtGui.QFont()
        font.setPointSize(7)
        font.setBold(False)
        font.setWeight(50)
        self.label_replacement_result.setFont(font)
        self.label_replacement_result.setObjectName("label_replacement_result")
        self.tabWidget.addTab(self.tab_replacements, "")
        self.tab_templates = QtWidgets.QWidget()
        self.tab_templates.setEnabled(True)
        self.tab_templates.setObjectName("tab_templates")
        self.groupBox_templates = QtWidgets.QGroupBox(self.tab_templates)
        self.groupBox_templates.setGeometry(QtCore.QRect(scale(20), scale(20), scale(761), scale(451)))
        self.groupBox_templates.setStyleSheet("QListWidget, QTextEdit {\n"
"    background-color: white;\n"
"}")
        self.groupBox_templates.setObjectName("groupBox_templates")
        self.listWidget_templates = QtWidgets.QListWidget(self.groupBox_templates)
        self.listWidget_templates.setGeometry(QtCore.QRect(scale(20), scale(50), scale(181), scale(381)))
        self.listWidget_templates.setStyleSheet("")
        self.listWidget_templates.setObjectName("listWidget_templates")
        item = QtWidgets.QListWidgetItem()
        self.listWidget_templates.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_templates.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_templates.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_templates.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_templates.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_templates.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_templates.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_templates.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_templates.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_templates.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_templates.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_templates.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_templates.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_templates.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_templates.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_templates.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_templates.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_templates.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_templates.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_templates.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_templates.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_templates.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_templates.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_templates.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_templates.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_templates.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_templates.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_templates.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_templates.addItem(item)
        self.label_template_titles = QtWidgets.QLabel(self.groupBox_templates)
        self.label_template_titles.setGeometry(QtCore.QRect(scale(20), scale(30), scale(211), scale(20)))
        font = QtGui.QFont()
        font.setBold(True)
        font.setWeight(75)
        self.label_template_titles.setFont(font)
        self.label_template_titles.setObjectName("label_template_titles")
        self.label_command_meaning_2 = QtWidgets.QLabel(self.groupBox_templates)
        self.label_command_meaning_2.setGeometry(QtCore.QRect(scale(210), scale(30), scale(211), scale(20)))
        font = QtGui.QFont()
        font.setBold(True)
        font.setWeight(75)
        self.label_command_meaning_2.setFont(font)
        self.label_command_meaning_2.setObjectName("label_command_meaning_2")
        self.textEdit_2 = QtWidgets.QTextEdit(self.groupBox_templates)
        self.textEdit_2.setGeometry(QtCore.QRect(scale(210), scale(50), scale(531), scale(381)))
        self.textEdit_2.setObjectName("textEdit_2")
        self.tabWidget.addTab(self.tab_templates, "")
        self.tab_dict = QtWidgets.QWidget()
        self.tab_dict.setObjectName("tab_dict")
        self.label_2 = QtWidgets.QLabel(self.tab_dict)
        self.label_2.setGeometry(QtCore.QRect(scale(30), scale(30), scale(47), scale(16)))
        self.label_2.setObjectName("label_2")
        self.label_4 = QtWidgets.QLabel(self.tab_dict)
        self.label_4.setGeometry(QtCore.QRect(scale(290), scale(30), scale(71), scale(16)))
        self.label_4.setAlignment(QtCore.Qt.AlignRight|QtCore.Qt.AlignTrailing|QtCore.Qt.AlignVCenter)
        self.label_4.setObjectName("label_4")
        self.lineEdit = QtWidgets.QLineEdit(self.tab_dict)
        self.lineEdit.setGeometry(QtCore.QRect(scale(30), scale(50), scale(231), scale(22)))
        self.lineEdit.setStyleSheet("background-color:white")
        self.lineEdit.setReadOnly(True)
        self.lineEdit.setObjectName("lineEdit")
        self.lineEdit_2 = QtWidgets.QLineEdit(self.tab_dict)
        self.lineEdit_2.setGeometry(QtCore.QRect(scale(290), scale(50), scale(71), scale(22)))
        self.lineEdit_2.setStyleSheet("background-color:white")
        self.lineEdit_2.setAlignment(QtCore.Qt.AlignRight|QtCore.Qt.AlignTrailing|QtCore.Qt.AlignVCenter)
        self.lineEdit_2.setReadOnly(True)
        self.lineEdit_2.setObjectName("lineEdit_2")
        self.label_6 = QtWidgets.QLabel(self.tab_dict)
        self.label_6.setGeometry(QtCore.QRect(scale(390), scale(30), scale(71), scale(16)))
        self.label_6.setAlignment(QtCore.Qt.AlignRight|QtCore.Qt.AlignTrailing|QtCore.Qt.AlignVCenter)
        self.label_6.setObjectName("label_6")
        self.lineEdit_3 = QtWidgets.QLineEdit(self.tab_dict)
        self.lineEdit_3.setGeometry(QtCore.QRect(scale(390), scale(50), scale(71), scale(22)))
        self.lineEdit_3.setStyleSheet("background-color:white")
        self.lineEdit_3.setAlignment(QtCore.Qt.AlignRight|QtCore.Qt.AlignTrailing|QtCore.Qt.AlignVCenter)
        self.lineEdit_3.setReadOnly(True)
        self.lineEdit_3.setObjectName("lineEdit_3")
        self.pushButton = QtWidgets.QPushButton(self.tab_dict)
        self.pushButton.setGeometry(QtCore.QRect(scale(470), scale(50), scale(31), scale(23)))
        self.pushButton.setText("")
        icon = QtGui.QIcon()
        icon.addPixmap(QtGui.QPixmap(os.path.join(basedir, "refresh.png")), QtGui.QIcon.Normal, QtGui.QIcon.Off)
        self.pushButton.setIcon(icon)
        self.pushButton.setIconSize(QtCore.QSize(18, 18))
        self.pushButton.setFlat(True)
        self.pushButton.setObjectName("pushButton")
        self.pushButton_2 = QtWidgets.QPushButton(self.tab_dict)
        self.pushButton_2.setGeometry(QtCore.QRect(scale(30), scale(100), scale(461), scale(23)))
        self.pushButton_2.setObjectName("pushButton_2")
        self.textEdit = QtWidgets.QTextEdit(self.tab_dict)
        self.textEdit.setGeometry(QtCore.QRect(scale(30), scale(130), scale(461), scale(71)))
        self.textEdit.setObjectName("textEdit")
        self.tabWidget.addTab(self.tab_dict, "")
        self.pushButton_save = QtWidgets.QPushButton(Dialog_detailed_settings)
        self.pushButton_save.setGeometry(QtCore.QRect(scale(10), scale(589), scale(75), scale(23)))
        self.pushButton_save.setObjectName("pushButton_save")
        self.pushButton_close = QtWidgets.QPushButton(Dialog_detailed_settings)
        self.pushButton_close.setGeometry(QtCore.QRect(scale(90), scale(589), scale(75), scale(23)))
        self.pushButton_close.setObjectName("pushButton_close")
        self.label_result_status = QtWidgets.QLabel(Dialog_detailed_settings)
        self.label_result_status.setGeometry(QtCore.QRect(scale(180), scale(590), scale(491), scale(20)))
        font = QtGui.QFont()
        font.setPointSize(7)
        font.setBold(False)
        font.setWeight(50)
        self.label_result_status.setFont(font)
        self.label_result_status.setObjectName("label_result_status")

        self.retranslateUi(Dialog_detailed_settings)
        self.tabWidget.setCurrentIndex(0)
        QtCore.QMetaObject.connectSlotsByName(Dialog_detailed_settings)

    def retranslateUi(self, Dialog_detailed_settings):
        _translate = QtCore.QCoreApplication.translate
        Dialog_detailed_settings.setWindowTitle(_translate("Dialog_detailed_settings", "Podrobne nastavitve"))
        self.groupBox_postprocessing.setTitle(_translate("Dialog_detailed_settings", "Dodatna obdelava"))
        self.checkBox_numbers.setText(_translate("Dialog_detailed_settings", "Normaliziraj števila"))
        self.checkBox_spp.setText(_translate("Dialog_detailed_settings", "Dopolni šifre diagnoz (SPP)"))
        self.checkBox_capitalization.setText(_translate("Dialog_detailed_settings", "Tekst po ukazu nova vrstica/odstavek začni z veliko"))
        self.checkBox_beep_on_final.setText(_translate("Dialog_detailed_settings", "Zapiskaj ob končni razpoznavi"))
        self.groupBox_dictaphone.setTitle(_translate("Dialog_detailed_settings", "Upravljanje z diktafonom"))
        self.checkBox_dictaphone_toggle.setText(_translate("Dialog_detailed_settings", "Detektiraj gumb za preklapljanje med snemaj/pavza"))
        self.label_toggle_key_combination.setText(_translate("Dialog_detailed_settings", "Simuliraj kombinacijo tipk"))
        self.groupBox_general.setTitle(_translate("Dialog_detailed_settings", "Ob zagonu"))
        self.checkBox_minimize.setText(_translate("Dialog_detailed_settings", "Pomanjšaj v sistemsko vrstico"))
        self.checkBox_purge_queue.setText(_translate("Dialog_detailed_settings", "Sprazni vrsto zunanjih ukazov"))
        self.checkBox_listen_external.setText(_translate("Dialog_detailed_settings", "Odpri vrsto za poslušanje zunanjih ukazov"))
        self.groupBox_proxy.setTitle(_translate("Dialog_detailed_settings", "Proxy strežnik"))
        self.checkBox_use_proxy.setText(_translate("Dialog_detailed_settings", "Uporabi proxy strežnik"))
        self.label_host.setText(_translate("Dialog_detailed_settings", "Naslov strežnika (IP)"))
        self.label_port.setText(_translate("Dialog_detailed_settings", "Vrata (port)"))
        self.label_protocol.setText(_translate("Dialog_detailed_settings", "Protokol"))
        self.label_username.setText(_translate("Dialog_detailed_settings", "Uporabniško ime"))
        self.label_password.setText(_translate("Dialog_detailed_settings", "Geslo"))
        self.comboBox_protocol.setItemText(0, _translate("Dialog_detailed_settings", "none"))
        self.comboBox_protocol.setItemText(1, _translate("Dialog_detailed_settings", "http"))
        self.comboBox_protocol.setItemText(2, _translate("Dialog_detailed_settings", "socks4"))
        self.comboBox_protocol.setItemText(3, _translate("Dialog_detailed_settings", "socks4a"))
        self.comboBox_protocol.setItemText(4, _translate("Dialog_detailed_settings", "socks5"))
        self.comboBox_protocol.setItemText(5, _translate("Dialog_detailed_settings", "socks5h"))
        self.groupBox_focus.setTitle(_translate("Dialog_detailed_settings", "Samodejno fokusiranje na okno"))
        self.checkBox_focus_by_key.setText(_translate("Dialog_detailed_settings", "S tipkami za preklop"))
        self.checkBox_focus_by_title.setText(_translate("Dialog_detailed_settings", "Po nazivu okna"))
        self.groupBox_PID.setTitle(_translate("Dialog_detailed_settings", "Identifikacija seje"))
        self.checkBox_show_PID.setText(_translate("Dialog_detailed_settings", "Prikaži okno za vnos oznake seje"))
        self.tabWidget.setTabText(self.tabWidget.indexOf(self.tab_basic), _translate("Dialog_detailed_settings", "Osnovno"))
        self.groupBox_command_settings.setTitle(_translate("Dialog_detailed_settings", "Nastavitve ukazov"))
        __sortingEnabled = self.listWidget_command.isSortingEnabled()
        self.listWidget_command.setSortingEnabled(False)
        item = self.listWidget_command.item(0)
        item.setText(_translate("Dialog_detailed_settings", "nova vrsta"))
        item = self.listWidget_command.item(1)
        item.setText(_translate("Dialog_detailed_settings", "nov odstavek"))
        item = self.listWidget_command.item(2)
        item.setText(_translate("Dialog_detailed_settings", "vključi velike črke"))
        item = self.listWidget_command.item(3)
        item.setText(_translate("Dialog_detailed_settings", "izključi velike črke"))
        item = self.listWidget_command.item(4)
        item.setText(_translate("Dialog_detailed_settings", "vključi odebeljeno"))
        item = self.listWidget_command.item(5)
        item.setText(_translate("Dialog_detailed_settings", "izključi odebeljeno"))
        item = self.listWidget_command.item(6)
        item.setText(_translate("Dialog_detailed_settings", "vključi poševno"))
        item = self.listWidget_command.item(7)
        item.setText(_translate("Dialog_detailed_settings", "izključi poševno"))
        item = self.listWidget_command.item(8)
        item.setText(_translate("Dialog_detailed_settings", "vključi podčrtano"))
        item = self.listWidget_command.item(9)
        item.setText(_translate("Dialog_detailed_settings", "izključi podčrtano"))
        item = self.listWidget_command.item(10)
        item.setText(_translate("Dialog_detailed_settings", "velike črke"))
        item = self.listWidget_command.item(11)
        item.setText(_translate("Dialog_detailed_settings", "odebeljeno"))
        item = self.listWidget_command.item(12)
        item.setText(_translate("Dialog_detailed_settings", "poševno"))
        item = self.listWidget_command.item(13)
        item.setText(_translate("Dialog_detailed_settings", "podčrtano"))
        item = self.listWidget_command.item(14)
        item.setText(_translate("Dialog_detailed_settings", "z veliko začetnico"))
        item = self.listWidget_command.item(15)
        item.setText(_translate("Dialog_detailed_settings", "poravnaj levo"))
        item = self.listWidget_command.item(16)
        item.setText(_translate("Dialog_detailed_settings", "poravnaj desno"))
        item = self.listWidget_command.item(17)
        item.setText(_translate("Dialog_detailed_settings", "poravnaj na sredino"))
        item = self.listWidget_command.item(18)
        item.setText(_translate("Dialog_detailed_settings", "briši"))
        item = self.listWidget_command.item(19)
        item.setText(_translate("Dialog_detailed_settings", "izberi vse"))
        item = self.listWidget_command.item(20)
        item.setText(_translate("Dialog_detailed_settings", "potrdi"))
        item = self.listWidget_command.item(21)
        item.setText(_translate("Dialog_detailed_settings", "prekliči"))
        item = self.listWidget_command.item(22)
        item.setText(_translate("Dialog_detailed_settings", "vstavi"))
        item = self.listWidget_command.item(23)
        item.setText(_translate("Dialog_detailed_settings", "naslednji"))
        item = self.listWidget_command.item(24)
        item.setText(_translate("Dialog_detailed_settings", "prejšnji"))
        item = self.listWidget_command.item(25)
        item.setText(_translate("Dialog_detailed_settings", "pavza"))
        item = self.listWidget_command.item(26)
        item.setText(_translate("Dialog_detailed_settings", "konec diktata"))
        item = self.listWidget_command.item(27)
        item.setText(_translate("Dialog_detailed_settings", "zapomni"))
        item = self.listWidget_command.item(28)
        item.setText(_translate("Dialog_detailed_settings", "prilepi"))
        self.listWidget_command.setSortingEnabled(__sortingEnabled)
        self.label_command.setText(_translate("Dialog_detailed_settings", "Ukaz"))
        self.label_command_meaning.setText(_translate("Dialog_detailed_settings", "Pomen ukaza"))
        self.groupBox.setTitle(_translate("Dialog_detailed_settings", "Nastavitve ukaza"))
        self.label_dest.setText(_translate("Dialog_detailed_settings", "Izhod"))
        self.label_copy2clip.setText(_translate("Dialog_detailed_settings", "Kopiraj v odložišče"))
        self.label_copy2buf.setText(_translate("Dialog_detailed_settings", "Kopiraj v pomnilnik"))
        self.label_keypress.setText(_translate("Dialog_detailed_settings", "Simuliraj pritisk tipk"))
        self.comboBox_destination_format.setItemText(0, _translate("Dialog_detailed_settings", "navadno besedilo (txt)"))
        self.comboBox_destination_format.setItemText(1, _translate("Dialog_detailed_settings", "oblikovano besedilo (rtf)"))
        self.comboBox_destination_format.setItemText(2, _translate("Dialog_detailed_settings", "oblikovano besedilo (docx)"))
        self.comboBox_destination_format.setItemText(3, _translate("Dialog_detailed_settings", "B21"))
        self.label_repeat.setText(_translate("Dialog_detailed_settings", "Ponovi"))
        self.tabWidget.setTabText(self.tabWidget.indexOf(self.tab_commands), _translate("Dialog_detailed_settings", "Ukazi"))
        self.groupBox_general_replacements.setTitle(_translate("Dialog_detailed_settings", "Splošne zamenjave"))
        self.pushButton_add_basic_repl.setText(_translate("Dialog_detailed_settings", "Dodaj"))
        self.pushButton_del_basic_repl.setText(_translate("Dialog_detailed_settings", "Briši"))
        __sortingEnabled = self.listWidget_basic_repl.isSortingEnabled()
        self.listWidget_basic_repl.setSortingEnabled(False)
        item = self.listWidget_basic_repl.item(0)
        item.setText(_translate("Dialog_detailed_settings", "df: diloman"))
        item = self.listWidget_basic_repl.item(1)
        item.setText(_translate("Dialog_detailed_settings", "e recept: eRecept"))
        item = self.listWidget_basic_repl.item(2)
        item.setText(_translate("Dialog_detailed_settings", "mm Hg: mmHg"))
        self.listWidget_basic_repl.setSortingEnabled(__sortingEnabled)
        self.pushButton_update_basic_repl.setText(_translate("Dialog_detailed_settings", "Spremeni"))
        self.label.setText(_translate("Dialog_detailed_settings", "Filter"))
        self.label_replacement_result.setText(_translate("Dialog_detailed_settings", "TextLabel"))
        self.tabWidget.setTabText(self.tabWidget.indexOf(self.tab_replacements), _translate("Dialog_detailed_settings", "Zamenjave"))
        self.groupBox_templates.setTitle(_translate("Dialog_detailed_settings", "Upravljanje predlog"))
        __sortingEnabled = self.listWidget_templates.isSortingEnabled()
        self.listWidget_templates.setSortingEnabled(False)
        item = self.listWidget_templates.item(0)
        item.setText(_translate("Dialog_detailed_settings", "nova vrsta"))
        item = self.listWidget_templates.item(1)
        item.setText(_translate("Dialog_detailed_settings", "nov odstavek"))
        item = self.listWidget_templates.item(2)
        item.setText(_translate("Dialog_detailed_settings", "vključi velike črke"))
        item = self.listWidget_templates.item(3)
        item.setText(_translate("Dialog_detailed_settings", "izključi velike črke"))
        item = self.listWidget_templates.item(4)
        item.setText(_translate("Dialog_detailed_settings", "vključi odebeljeno"))
        item = self.listWidget_templates.item(5)
        item.setText(_translate("Dialog_detailed_settings", "izključi odebeljeno"))
        item = self.listWidget_templates.item(6)
        item.setText(_translate("Dialog_detailed_settings", "vključi poševno"))
        item = self.listWidget_templates.item(7)
        item.setText(_translate("Dialog_detailed_settings", "izključi poševno"))
        item = self.listWidget_templates.item(8)
        item.setText(_translate("Dialog_detailed_settings", "vključi podčrtano"))
        item = self.listWidget_templates.item(9)
        item.setText(_translate("Dialog_detailed_settings", "izključi podčrtano"))
        item = self.listWidget_templates.item(10)
        item.setText(_translate("Dialog_detailed_settings", "velike črke"))
        item = self.listWidget_templates.item(11)
        item.setText(_translate("Dialog_detailed_settings", "odebeljeno"))
        item = self.listWidget_templates.item(12)
        item.setText(_translate("Dialog_detailed_settings", "poševno"))
        item = self.listWidget_templates.item(13)
        item.setText(_translate("Dialog_detailed_settings", "podčrtano"))
        item = self.listWidget_templates.item(14)
        item.setText(_translate("Dialog_detailed_settings", "z veliko začetnico"))
        item = self.listWidget_templates.item(15)
        item.setText(_translate("Dialog_detailed_settings", "poravnaj levo"))
        item = self.listWidget_templates.item(16)
        item.setText(_translate("Dialog_detailed_settings", "poravnaj desno"))
        item = self.listWidget_templates.item(17)
        item.setText(_translate("Dialog_detailed_settings", "poravnaj na sredino"))
        item = self.listWidget_templates.item(18)
        item.setText(_translate("Dialog_detailed_settings", "briši"))
        item = self.listWidget_templates.item(19)
        item.setText(_translate("Dialog_detailed_settings", "izberi vse"))
        item = self.listWidget_templates.item(20)
        item.setText(_translate("Dialog_detailed_settings", "potrdi"))
        item = self.listWidget_templates.item(21)
        item.setText(_translate("Dialog_detailed_settings", "prekliči"))
        item = self.listWidget_templates.item(22)
        item.setText(_translate("Dialog_detailed_settings", "vstavi"))
        item = self.listWidget_templates.item(23)
        item.setText(_translate("Dialog_detailed_settings", "naslednji"))
        item = self.listWidget_templates.item(24)
        item.setText(_translate("Dialog_detailed_settings", "prejšnji"))
        item = self.listWidget_templates.item(25)
        item.setText(_translate("Dialog_detailed_settings", "pavza"))
        item = self.listWidget_templates.item(26)
        item.setText(_translate("Dialog_detailed_settings", "konec diktata"))
        item = self.listWidget_templates.item(27)
        item.setText(_translate("Dialog_detailed_settings", "zapomni"))
        item = self.listWidget_templates.item(28)
        item.setText(_translate("Dialog_detailed_settings", "prilepi"))
        self.listWidget_templates.setSortingEnabled(__sortingEnabled)
        self.label_template_titles.setText(_translate("Dialog_detailed_settings", "Naziv predloge"))
        self.label_command_meaning_2.setText(_translate("Dialog_detailed_settings", "Predloga"))
        self.textEdit_2.setHtml(_translate("Dialog_detailed_settings", "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0//EN\" \"http://www.w3.org/TR/REC-html40/strict.dtd\">\n"
"<html><head><meta name=\"qrichtext\" content=\"1\" /><style type=\"text/css\">\n"
"p, li { white-space: pre-wrap; }\n"
"</style></head><body style=\" font-family:\'MS Shell Dlg 2\'; font-size:8.25pt; font-weight:400; font-style:normal;\">\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt; font-weight:600; color:#000000;\">DOPPLER  VRATNIH  ARTERIJ</span><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt; color:#000000;\"> </span></p>\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt; color:#000000;\"> </span><span style=\" font-size:8pt;\"> </span></p>\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt; font-weight:600; color:#000000;\">Indikacija</span><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt; color:#000000;\">:</span><span style=\" font-size:8pt;\"> </span></p>\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt; color:#000000;\"> </span><span style=\" font-size:8pt;\"> </span></p>\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt; font-weight:600; color:#000000;\">Dejavniki tveganja za aterosklerotični proces</span><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt; color:#000000;\">: </span></p>\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt; color:#000000;\"> </span><span style=\" font-size:8pt;\"> </span></p>\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt; font-weight:600; color:#000000;\">Terapija</span><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt; color:#000000;\">:</span><span style=\" font-size:8pt;\"> </span></p>\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt; color:#000000;\"> </span><span style=\" font-size:8pt;\"> </span></p>\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt; font-weight:600; color:#000000;\">RR</span><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt; color:#000000;\"> </span><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt; font-weight:600; color:#000000;\">nadlahti</span><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt; color:#000000;\">:</span><span style=\" font-size:8pt;\"> </span></p>\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt; color:#000000;\"> </span><span style=\" font-size:8pt;\"> </span></p>\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt; color:#000000;\"> </span><span style=\" font-size:8pt;\"> </span></p>\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt; font-weight:600; color:#000000;\">2 D IN BARVNI PRIKAZ</span><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt; color:#000000;\">:</span><span style=\" font-size:8pt;\"> </span></p>\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt; color:#000000;\"> </span><span style=\" font-size:8pt;\"> </span></p>\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt; color:#000000;\"> </span><span style=\" font-size:8pt;\"> </span></p>\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt; font-style:italic; text-decoration: underline; color:#000000;\">PW doppler (sistolne/diastolne hitrosti toka v cm/sek)</span><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt; color:#000000;\">:</span><span style=\" font-size:8pt;\"> </span></p>\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt; color:#000000;\"> </span><span style=\" font-size:8pt;\"> </span></p>\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt; color:#000000;\">                                  desno                    levo</span><span style=\" font-size:8pt;\"> </span></p>\n"
"<table border=\"1\" style=\" margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px;\" width=\"340\" cellspacing=\"0\" cellpadding=\"0\">\n"
"<tr>\n"
"<td width=\"114\" style=\" vertical-align:top; padding-left:0; padding-right:0; padding-top:0; padding-bottom:0;\">\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt;\">ACC</span><span style=\" font-size:8pt;\"> </span></p></td>\n"
"<td width=\"111\" style=\" vertical-align:top; padding-left:0; padding-right:0; padding-top:0; padding-bottom:0;\">\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:8pt;\"> </span><span style=\" font-size:8pt;\"> </span></p></td>\n"
"<td width=\"115\" style=\" vertical-align:top; padding-left:0; padding-right:0; padding-top:0; padding-bottom:0;\">\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:8pt;\"> </span><span style=\" font-size:8pt;\"> </span></p></td></tr>\n"
"<tr>\n"
"<td style=\" vertical-align:top; padding-left:0; padding-right:0; padding-top:0; padding-bottom:0;\">\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt;\">ACI</span><span style=\" font-size:8pt;\"> </span></p></td>\n"
"<td style=\" vertical-align:top; padding-left:0; padding-right:0; padding-top:0; padding-bottom:0;\">\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:8pt;\"> </span><span style=\" font-size:8pt;\"> </span></p></td>\n"
"<td style=\" vertical-align:top; padding-left:0; padding-right:0; padding-top:0; padding-bottom:0;\">\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:8pt;\"> </span><span style=\" font-size:8pt;\"> </span></p></td></tr>\n"
"<tr>\n"
"<td style=\" vertical-align:top; padding-left:0; padding-right:0; padding-top:0; padding-bottom:0;\">\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt;\">ACE</span><span style=\" font-size:8pt;\"> </span></p></td>\n"
"<td style=\" vertical-align:top; padding-left:0; padding-right:0; padding-top:0; padding-bottom:0;\">\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:8pt;\"> </span><span style=\" font-size:8pt;\"> </span></p></td>\n"
"<td style=\" vertical-align:top; padding-left:0; padding-right:0; padding-top:0; padding-bottom:0;\">\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:8pt;\"> </span><span style=\" font-size:8pt;\"> </span></p></td></tr>\n"
"<tr>\n"
"<td style=\" vertical-align:top; padding-left:0; padding-right:0; padding-top:0; padding-bottom:0;\">\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt;\">VA</span><span style=\" font-size:8pt;\"> </span></p></td>\n"
"<td style=\" vertical-align:top; padding-left:0; padding-right:0; padding-top:0; padding-bottom:0;\">\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:8pt;\"> </span><span style=\" font-size:8pt;\"> </span></p></td>\n"
"<td style=\" vertical-align:top; padding-left:0; padding-right:0; padding-top:0; padding-bottom:0;\">\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:8pt;\"> </span><span style=\" font-size:8pt;\"> </span></p></td></tr></table>\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt; color:#000000;\"> </span><span style=\" font-size:8pt;\"> </span></p>\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt; color:#000000;\"> </span><span style=\" font-size:8pt;\"> </span></p>\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt; color:#000000;\"> </span><span style=\" font-size:8pt;\"> </span></p>\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt; font-weight:600; color:#000000;\">M N E N J E</span><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt; color:#000000;\"> :</span><span style=\" font-size:8pt;\"> </span></p></body></html>"))
        self.tabWidget.setTabText(self.tabWidget.indexOf(self.tab_templates), _translate("Dialog_detailed_settings", "Predloge"))
        self.label_2.setText(_translate("Dialog_detailed_settings", "Model"))
        self.label_4.setText(_translate("Dialog_detailed_settings", "Vseh besed"))
        self.lineEdit.setText(_translate("Dialog_detailed_settings", "KALDI, sl-SI, MED, 20221201-1735"))
        self.lineEdit_2.setText(_translate("Dialog_detailed_settings", "120.988"))
        self.label_6.setText(_translate("Dialog_detailed_settings", "Novih besed"))
        self.lineEdit_3.setText(_translate("Dialog_detailed_settings", "8"))
        self.pushButton_2.setText(_translate("Dialog_detailed_settings", "Sproži prenovo modela"))
        self.textEdit.setHtml(_translate("Dialog_detailed_settings", "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0//EN\" \"http://www.w3.org/TR/REC-html40/strict.dtd\">\n"
"<html><head><meta name=\"qrichtext\" content=\"1\" /><style type=\"text/css\">\n"
"p, li { white-space: pre-wrap; }\n"
"</style></head><body style=\" font-family:\'MS Shell Dlg 2\'; font-size:8.25pt; font-weight:400; font-style:normal;\">\n"
"<p style=\" margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-weight:600; color:#ff0000;\">Opozorilo</span><span style=\" color:#ff0000;\">: postopek prenove lahko traja več kot 20 minut. Ko bo model prenovljen, se bodo vse seje z obstoječim modelom samodejno zaključile! Prenovljeni model bo na voljo v nastavitvah kot nova izbira.</span></p></body></html>"))
        self.tabWidget.setTabText(self.tabWidget.indexOf(self.tab_dict), _translate("Dialog_detailed_settings", "Slovar"))
        self.pushButton_save.setText(_translate("Dialog_detailed_settings", "Shrani"))
        self.pushButton_close.setText(_translate("Dialog_detailed_settings", "Zapri"))
        self.label_result_status.setText(_translate("Dialog_detailed_settings", "TextLabel"))

class Ui_Dialog_detailed_settings(object):
    def setupUi(self, Dialog_detailed_settings):
        Dialog_detailed_settings.setObjectName("Dialog_detailed_settings")
        Dialog_detailed_settings.resize(scale(819), scale(629))
        Dialog_detailed_settings.setStyleSheet("QPushButton {\n"
"    background-color: lightgrey;\n"
"}\n"
"QDialog {\n"
"    background-color: rgb(234, 241, 221);\n"
"}")
        self.tabWidget = QtWidgets.QTabWidget(Dialog_detailed_settings)
        self.tabWidget.setEnabled(True)
        self.tabWidget.setGeometry(QtCore.QRect(scale(10), scale(10), scale(801), scale(571)))
        self.tabWidget.setStyleSheet("background-color:rgb(244, 244, 244);\n"
"")
        self.tabWidget.setTabShape(QtWidgets.QTabWidget.Rounded)
        self.tabWidget.setObjectName("tabWidget")
        self.tab_basic = QtWidgets.QWidget()
        self.tab_basic.setObjectName("tab_basic")
        self.groupBox_postprocessing = QtWidgets.QGroupBox(self.tab_basic)
        self.groupBox_postprocessing.setGeometry(QtCore.QRect(scale(20), scale(20), scale(371), scale(201)))
        font = QtGui.QFont()
        font.setBold(True)
        font.setWeight(75)
        self.groupBox_postprocessing.setFont(font)
        self.groupBox_postprocessing.setFlat(False)
        self.groupBox_postprocessing.setObjectName("groupBox_postprocessing")
        self.checkBox_numbers = QtWidgets.QCheckBox(self.groupBox_postprocessing)
        self.checkBox_numbers.setGeometry(QtCore.QRect(scale(20), scale(30), scale(251), scale(17)))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.checkBox_numbers.setFont(font)
        self.checkBox_numbers.setToolTip("")
        self.checkBox_numbers.setObjectName("checkBox_numbers")
        self.checkBox_spp = QtWidgets.QCheckBox(self.groupBox_postprocessing)
        self.checkBox_spp.setGeometry(QtCore.QRect(scale(20), scale(60), scale(251), scale(17)))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.checkBox_spp.setFont(font)
        self.checkBox_spp.setObjectName("checkBox_spp")
        self.checkBox_capitalization = QtWidgets.QCheckBox(self.groupBox_postprocessing)
        self.checkBox_capitalization.setGeometry(QtCore.QRect(scale(20), scale(90), scale(271), scale(17)))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.checkBox_capitalization.setFont(font)
        self.checkBox_capitalization.setObjectName("checkBox_capitalization")
        self.checkBox_beep_on_final = QtWidgets.QCheckBox(self.groupBox_postprocessing)
        self.checkBox_beep_on_final.setGeometry(QtCore.QRect(scale(20), scale(120), scale(321), scale(17)))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.checkBox_beep_on_final.setFont(font)
        self.checkBox_beep_on_final.setObjectName("checkBox_beep_on_final")
        self.checkBox_format_notes = QtWidgets.QCheckBox(self.groupBox_postprocessing)
        self.checkBox_format_notes.setGeometry(QtCore.QRect(scale(20), scale(150), scale(321), scale(17)))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.checkBox_format_notes.setFont(font)
        self.checkBox_format_notes.setObjectName("checkBox_format_notes")
        self.groupBox_dictaphone = QtWidgets.QGroupBox(self.tab_basic)
        self.groupBox_dictaphone.setGeometry(QtCore.QRect(scale(410), scale(330), scale(371), scale(111)))
        font = QtGui.QFont()
        font.setBold(True)
        font.setWeight(75)
        self.groupBox_dictaphone.setFont(font)
        self.groupBox_dictaphone.setObjectName("groupBox_dictaphone")
        self.checkBox_dictaphone_toggle = QtWidgets.QCheckBox(self.groupBox_dictaphone)
        self.checkBox_dictaphone_toggle.setGeometry(QtCore.QRect(scale(20), scale(30), scale(311), scale(17)))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.checkBox_dictaphone_toggle.setFont(font)
        self.checkBox_dictaphone_toggle.setObjectName("checkBox_dictaphone_toggle")
        self.lineEdit_toggle_key_combination = QtWidgets.QLineEdit(self.groupBox_dictaphone)
        self.lineEdit_toggle_key_combination.setGeometry(QtCore.QRect(scale(170), scale(60), scale(181), scale(20)))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.lineEdit_toggle_key_combination.setFont(font)
        self.lineEdit_toggle_key_combination.setStyleSheet("background-color: white;")
        self.lineEdit_toggle_key_combination.setObjectName("lineEdit_toggle_key_combination")
        self.label_toggle_key_combination = QtWidgets.QLabel(self.groupBox_dictaphone)
        self.label_toggle_key_combination.setGeometry(QtCore.QRect(scale(38), scale(60), scale(131), scale(16)))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.label_toggle_key_combination.setFont(font)
        self.label_toggle_key_combination.setObjectName("label_toggle_key_combination")
        self.groupBox_general = QtWidgets.QGroupBox(self.tab_basic)
        self.groupBox_general.setGeometry(QtCore.QRect(scale(410), scale(160), scale(371), scale(141)))
        font = QtGui.QFont()
        font.setBold(True)
        font.setWeight(75)
        self.groupBox_general.setFont(font)
        self.groupBox_general.setObjectName("groupBox_general")
        self.checkBox_minimize = QtWidgets.QCheckBox(self.groupBox_general)
        self.checkBox_minimize.setGeometry(QtCore.QRect(scale(20), scale(30), scale(311), scale(17)))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.checkBox_minimize.setFont(font)
        self.checkBox_minimize.setObjectName("checkBox_minimize")
        self.checkBox_purge_queue = QtWidgets.QCheckBox(self.groupBox_general)
        self.checkBox_purge_queue.setGeometry(QtCore.QRect(scale(20), scale(90), scale(311), scale(17)))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.checkBox_purge_queue.setFont(font)
        self.checkBox_purge_queue.setObjectName("checkBox_purge_queue")
        self.checkBox_listen_external = QtWidgets.QCheckBox(self.groupBox_general)
        self.checkBox_listen_external.setGeometry(QtCore.QRect(scale(20), scale(60), scale(311), scale(17)))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.checkBox_listen_external.setFont(font)
        self.checkBox_listen_external.setObjectName("checkBox_listen_external")
        self.groupBox_proxy = QtWidgets.QGroupBox(self.tab_basic)
        self.groupBox_proxy.setGeometry(QtCore.QRect(scale(20), scale(250), scale(371), scale(231)))
        font = QtGui.QFont()
        font.setBold(True)
        font.setWeight(75)
        self.groupBox_proxy.setFont(font)
        self.groupBox_proxy.setObjectName("groupBox_proxy")
        self.checkBox_use_proxy = QtWidgets.QCheckBox(self.groupBox_proxy)
        self.checkBox_use_proxy.setGeometry(QtCore.QRect(scale(20), scale(30), scale(311), scale(17)))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.checkBox_use_proxy.setFont(font)
        self.checkBox_use_proxy.setObjectName("checkBox_use_proxy")
        self.lineEdit_host = QtWidgets.QLineEdit(self.groupBox_proxy)
        self.lineEdit_host.setGeometry(QtCore.QRect(scale(150), scale(60), scale(181), scale(20)))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.lineEdit_host.setFont(font)
        self.lineEdit_host.setStyleSheet("background-color: white;")
        self.lineEdit_host.setObjectName("lineEdit_host")
        self.label_host = QtWidgets.QLabel(self.groupBox_proxy)
        self.label_host.setGeometry(QtCore.QRect(scale(37), scale(60), scale(100), scale(20)))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.label_host.setFont(font)
        self.label_host.setAlignment(QtCore.Qt.AlignRight|QtCore.Qt.AlignTrailing|QtCore.Qt.AlignVCenter)
        self.label_host.setObjectName("label_host")
        self.label_port = QtWidgets.QLabel(self.groupBox_proxy)
        self.label_port.setGeometry(QtCore.QRect(scale(37), scale(90), scale(100), scale(20)))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.label_port.setFont(font)
        self.label_port.setAlignment(QtCore.Qt.AlignRight|QtCore.Qt.AlignTrailing|QtCore.Qt.AlignVCenter)
        self.label_port.setObjectName("label_port")
        self.lineEdit_port = QtWidgets.QLineEdit(self.groupBox_proxy)
        self.lineEdit_port.setGeometry(QtCore.QRect(scale(150), scale(90), scale(51), scale(20)))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.lineEdit_port.setFont(font)
        self.lineEdit_port.setStyleSheet("background-color: white;")
        self.lineEdit_port.setObjectName("lineEdit_port")
        self.label_protocol = QtWidgets.QLabel(self.groupBox_proxy)
        self.label_protocol.setGeometry(QtCore.QRect(scale(37), scale(120), scale(100), scale(20)))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.label_protocol.setFont(font)
        self.label_protocol.setAlignment(QtCore.Qt.AlignRight|QtCore.Qt.AlignTrailing|QtCore.Qt.AlignVCenter)
        self.label_protocol.setObjectName("label_protocol")
        self.label_username = QtWidgets.QLabel(self.groupBox_proxy)
        self.label_username.setGeometry(QtCore.QRect(scale(37), scale(150), scale(100), scale(20)))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.label_username.setFont(font)
        self.label_username.setAlignment(QtCore.Qt.AlignRight|QtCore.Qt.AlignTrailing|QtCore.Qt.AlignVCenter)
        self.label_username.setObjectName("label_username")
        self.label_password = QtWidgets.QLabel(self.groupBox_proxy)
        self.label_password.setGeometry(QtCore.QRect(scale(37), scale(180), scale(100), scale(20)))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.label_password.setFont(font)
        self.label_password.setAlignment(QtCore.Qt.AlignRight|QtCore.Qt.AlignTrailing|QtCore.Qt.AlignVCenter)
        self.label_password.setObjectName("label_password")
        self.lineEdit_username = QtWidgets.QLineEdit(self.groupBox_proxy)
        self.lineEdit_username.setGeometry(QtCore.QRect(scale(150), scale(150), scale(181), scale(20)))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.lineEdit_username.setFont(font)
        self.lineEdit_username.setStyleSheet("background-color: white;")
        self.lineEdit_username.setObjectName("lineEdit_username")
        self.lineEdit_password = QtWidgets.QLineEdit(self.groupBox_proxy)
        self.lineEdit_password.setGeometry(QtCore.QRect(scale(150), scale(180), scale(181), scale(20)))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.lineEdit_password.setFont(font)
        self.lineEdit_password.setStyleSheet("background-color: white;")
        self.lineEdit_password.setObjectName("lineEdit_password")
        self.comboBox_protocol = QtWidgets.QComboBox(self.groupBox_proxy)
        self.comboBox_protocol.setGeometry(QtCore.QRect(scale(150), scale(120), scale(121), scale(20)))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.comboBox_protocol.setFont(font)
        self.comboBox_protocol.setStyleSheet("background-color: white;\n"
"border-style: solid;\n"
"border-width: 1px;")
        self.comboBox_protocol.setObjectName("comboBox_protocol")
        self.comboBox_protocol.addItem("")
        self.comboBox_protocol.addItem("")
        self.comboBox_protocol.addItem("")
        self.comboBox_protocol.addItem("")
        self.comboBox_protocol.addItem("")
        self.comboBox_protocol.addItem("")
        self.groupBox_focus = QtWidgets.QGroupBox(self.tab_basic)
        self.groupBox_focus.setGeometry(QtCore.QRect(scale(410), scale(20), scale(371), scale(111)))
        font = QtGui.QFont()
        font.setBold(True)
        font.setWeight(75)
        self.groupBox_focus.setFont(font)
        self.groupBox_focus.setStyleSheet("")
        self.groupBox_focus.setObjectName("groupBox_focus")
        self.checkBox_focus_by_key = QtWidgets.QCheckBox(self.groupBox_focus)
        self.checkBox_focus_by_key.setGeometry(QtCore.QRect(scale(20), scale(30), scale(180), scale(17)))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.checkBox_focus_by_key.setFont(font)
        self.checkBox_focus_by_key.setObjectName("checkBox_focus_by_key")
        self.checkBox_focus_by_title = QtWidgets.QCheckBox(self.groupBox_focus)
        self.checkBox_focus_by_title.setGeometry(QtCore.QRect(scale(20), scale(60), scale(180), scale(17)))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.checkBox_focus_by_title.setFont(font)
        self.checkBox_focus_by_title.setObjectName("checkBox_focus_by_title")
        self.lineEdit_focus_key = QtWidgets.QLineEdit(self.groupBox_focus)
        self.lineEdit_focus_key.setGeometry(QtCore.QRect(scale(150), scale(30), scale(201), scale(20)))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.lineEdit_focus_key.setFont(font)
        self.lineEdit_focus_key.setStyleSheet("background-color: white;")
        self.lineEdit_focus_key.setObjectName("lineEdit_focus_key")
        self.lineEdit_focus_win_title = QtWidgets.QLineEdit(self.groupBox_focus)
        self.lineEdit_focus_win_title.setGeometry(QtCore.QRect(scale(150), scale(60), scale(201), scale(20)))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.lineEdit_focus_win_title.setFont(font)
        self.lineEdit_focus_win_title.setStyleSheet("background-color: white;")
        self.lineEdit_focus_win_title.setObjectName("lineEdit_focus_win_title")
        self.groupBox_PID = QtWidgets.QGroupBox(self.tab_basic)
        self.groupBox_PID.setGeometry(QtCore.QRect(scale(410), scale(470), scale(371), scale(61)))
        font = QtGui.QFont()
        font.setBold(True)
        font.setWeight(75)
        self.groupBox_PID.setFont(font)
        self.groupBox_PID.setObjectName("groupBox_PID")
        self.checkBox_show_PID = QtWidgets.QCheckBox(self.groupBox_PID)
        self.checkBox_show_PID.setGeometry(QtCore.QRect(scale(20), scale(20), scale(251), scale(17)))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.checkBox_show_PID.setFont(font)
        self.checkBox_show_PID.setObjectName("checkBox_show_PID")
        self.tabWidget.addTab(self.tab_basic, "")
        self.tab_commands = QtWidgets.QWidget()
        self.tab_commands.setObjectName("tab_commands")
        self.groupBox_command_settings = QtWidgets.QGroupBox(self.tab_commands)
        self.groupBox_command_settings.setGeometry(QtCore.QRect(scale(20), scale(20), scale(721), scale(451)))
        self.groupBox_command_settings.setStyleSheet("QListWidget, QTextEdit {\n"
"    background-color: white;\n"
"}")
        self.groupBox_command_settings.setObjectName("groupBox_command_settings")
        self.listWidget_command = QtWidgets.QListWidget(self.groupBox_command_settings)
        self.listWidget_command.setGeometry(QtCore.QRect(scale(20), scale(50), scale(211), scale(381)))
        self.listWidget_command.setStyleSheet("")
        self.listWidget_command.setObjectName("listWidget_command")
        item = QtWidgets.QListWidgetItem()
        self.listWidget_command.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_command.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_command.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_command.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_command.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_command.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_command.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_command.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_command.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_command.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_command.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_command.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_command.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_command.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_command.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_command.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_command.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_command.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_command.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_command.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_command.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_command.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_command.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_command.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_command.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_command.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_command.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_command.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_command.addItem(item)
        self.label_command = QtWidgets.QLabel(self.groupBox_command_settings)
        self.label_command.setGeometry(QtCore.QRect(scale(20), scale(30), scale(211), scale(20)))
        font = QtGui.QFont()
        font.setBold(True)
        font.setWeight(75)
        self.label_command.setFont(font)
        self.label_command.setObjectName("label_command")
        self.label_command_meaning = QtWidgets.QLabel(self.groupBox_command_settings)
        self.label_command_meaning.setGeometry(QtCore.QRect(scale(280), scale(30), scale(211), scale(20)))
        font = QtGui.QFont()
        font.setBold(True)
        font.setWeight(75)
        self.label_command_meaning.setFont(font)
        self.label_command_meaning.setObjectName("label_command_meaning")
        self.textEdit_command_meaning = QtWidgets.QPlainTextEdit(self.groupBox_command_settings)
        self.textEdit_command_meaning.setGeometry(QtCore.QRect(scale(280), scale(50), scale(421), scale(121)))
        self.textEdit_command_meaning.setStyleSheet("background-color: white")
        self.textEdit_command_meaning.setObjectName("textEdit_command_meaning")
        self.groupBox = QtWidgets.QGroupBox(self.groupBox_command_settings)
        self.groupBox.setGeometry(QtCore.QRect(scale(280), scale(189), scale(421), scale(241)))
        font = QtGui.QFont()
        font.setBold(True)
        font.setWeight(75)
        self.groupBox.setFont(font)
        self.groupBox.setStyleSheet("")
        self.groupBox.setObjectName("groupBox")
        self.label_dest = QtWidgets.QLabel(self.groupBox)
        self.label_dest.setGeometry(QtCore.QRect(scale(110), scale(40), scale(47), scale(21)))
        self.label_dest.setObjectName("label_dest")
        self.spinBox_repeat = QtWidgets.QSpinBox(self.groupBox)
        self.spinBox_repeat.setGeometry(QtCore.QRect(scale(150), scale(100), scale(42), scale(22)))
        self.spinBox_repeat.setStyleSheet("background-color: white;")
        self.spinBox_repeat.setObjectName("spinBox_repeat")
        self.lineEdit_copy2buf = QtWidgets.QLineEdit(self.groupBox)
        self.lineEdit_copy2buf.setGeometry(QtCore.QRect(scale(150), scale(160), scale(151), scale(22)))
        self.lineEdit_copy2buf.setStyleSheet("background-color: white;")
        self.lineEdit_copy2buf.setObjectName("lineEdit_copy2buf")
        self.label_copy2clip = QtWidgets.QLabel(self.groupBox)
        self.label_copy2clip.setGeometry(QtCore.QRect(scale(40), scale(130), scale(100), scale(22)))
        self.label_copy2clip.setAlignment(QtCore.Qt.AlignRight|QtCore.Qt.AlignTrailing|QtCore.Qt.AlignVCenter)
        self.label_copy2clip.setObjectName("label_copy2clip")
        self.label_copy2buf = QtWidgets.QLabel(self.groupBox)
        self.label_copy2buf.setGeometry(QtCore.QRect(scale(40), scale(160), scale(100), scale(22)))
        self.label_copy2buf.setAlignment(QtCore.Qt.AlignRight|QtCore.Qt.AlignTrailing|QtCore.Qt.AlignVCenter)
        self.label_copy2buf.setObjectName("label_copy2buf")
        self.label_keypress = QtWidgets.QLabel(self.groupBox)
        self.label_keypress.setGeometry(QtCore.QRect(scale(40), scale(70), scale(100), scale(22)))
        self.label_keypress.setAlignment(QtCore.Qt.AlignRight|QtCore.Qt.AlignTrailing|QtCore.Qt.AlignVCenter)
        self.label_keypress.setObjectName("label_keypress")
        self.lineEdit_keypress = QtWidgets.QLineEdit(self.groupBox)
        self.lineEdit_keypress.setGeometry(QtCore.QRect(scale(150), scale(70), scale(151), scale(22)))
        self.lineEdit_keypress.setStyleSheet("background-color: white;")
        self.lineEdit_keypress.setObjectName("lineEdit_keypress")
        self.comboBox_destination_format = QtWidgets.QComboBox(self.groupBox)
        self.comboBox_destination_format.setGeometry(QtCore.QRect(scale(150), scale(40), scale(151), scale(22)))
        self.comboBox_destination_format.setStyleSheet("background-color: white;\n"
"border-style: solid;\n"
"border-width: 1px;\n"
"border-color: grey;")
        self.comboBox_destination_format.setObjectName("comboBox_destination_format")
        self.comboBox_destination_format.addItem("")
        self.comboBox_destination_format.addItem("")
        self.comboBox_destination_format.addItem("")
        self.comboBox_destination_format.addItem("")
        self.lineEdit_copy2clip = QtWidgets.QLineEdit(self.groupBox)
        self.lineEdit_copy2clip.setGeometry(QtCore.QRect(scale(150), scale(130), scale(151), scale(22)))
        self.lineEdit_copy2clip.setStyleSheet("background-color: white;")
        self.lineEdit_copy2clip.setObjectName("lineEdit_copy2clip")
        self.label_repeat = QtWidgets.QLabel(self.groupBox)
        self.label_repeat.setGeometry(QtCore.QRect(scale(40), scale(100), scale(100), scale(22)))
        self.label_repeat.setAlignment(QtCore.Qt.AlignRight|QtCore.Qt.AlignTrailing|QtCore.Qt.AlignVCenter)
        self.label_repeat.setObjectName("label_repeat")
        self.tabWidget.addTab(self.tab_commands, "")
        self.tab_replacements = QtWidgets.QWidget()
        self.tab_replacements.setEnabled(True)
        self.tab_replacements.setObjectName("tab_replacements")
        self.groupBox_general_replacements = QtWidgets.QGroupBox(self.tab_replacements)
        self.groupBox_general_replacements.setGeometry(QtCore.QRect(scale(20), scale(10), scale(751), scale(471)))
        font = QtGui.QFont()
        font.setBold(True)
        font.setWeight(75)
        self.groupBox_general_replacements.setFont(font)
        self.groupBox_general_replacements.setStyleSheet("QPushButton {background-color: lightgray}")
        self.groupBox_general_replacements.setObjectName("groupBox_general_replacements")
        self.pushButton_add_basic_repl = QtWidgets.QPushButton(self.groupBox_general_replacements)
        self.pushButton_add_basic_repl.setGeometry(QtCore.QRect(scale(30), scale(430), scale(61), scale(23)))
        self.pushButton_add_basic_repl.setStyleSheet("")
        self.pushButton_add_basic_repl.setObjectName("pushButton_add_basic_repl")
        self.pushButton_del_basic_repl = QtWidgets.QPushButton(self.groupBox_general_replacements)
        self.pushButton_del_basic_repl.setGeometry(QtCore.QRect(scale(170), scale(430), scale(61), scale(23)))
        self.pushButton_del_basic_repl.setStyleSheet("")
        self.pushButton_del_basic_repl.setObjectName("pushButton_del_basic_repl")
        self.lineEdit_basic_repl = QtWidgets.QLineEdit(self.groupBox_general_replacements)
        self.lineEdit_basic_repl.setGeometry(QtCore.QRect(scale(30), scale(400), scale(691), scale(22)))
        self.lineEdit_basic_repl.setStyleSheet("background-color: white\n"
"")
        self.lineEdit_basic_repl.setObjectName("lineEdit_basic_repl")
        self.listWidget_basic_repl = QtWidgets.QListWidget(self.groupBox_general_replacements)
        self.listWidget_basic_repl.setGeometry(QtCore.QRect(scale(30), scale(80), scale(691), scale(311)))
        self.listWidget_basic_repl.setStyleSheet("background-color: white")
        self.listWidget_basic_repl.setAlternatingRowColors(True)
        self.listWidget_basic_repl.setModelColumn(0)
        self.listWidget_basic_repl.setObjectName("listWidget_basic_repl")
        item = QtWidgets.QListWidgetItem()
        self.listWidget_basic_repl.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_basic_repl.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_basic_repl.addItem(item)
        self.pushButton_update_basic_repl = QtWidgets.QPushButton(self.groupBox_general_replacements)
        self.pushButton_update_basic_repl.setGeometry(QtCore.QRect(scale(100), scale(430), scale(61), scale(23)))
        self.pushButton_update_basic_repl.setStyleSheet("")
        self.pushButton_update_basic_repl.setObjectName("pushButton_update_basic_repl")
        self.label = QtWidgets.QLabel(self.groupBox_general_replacements)
        self.label.setGeometry(QtCore.QRect(scale(30), scale(30), scale(41), scale(20)))
        font = QtGui.QFont()
        font.setPointSize(7)
        self.label.setFont(font)
        self.label.setObjectName("label")
        self.lineEdit_filter = QtWidgets.QLineEdit(self.groupBox_general_replacements)
        self.lineEdit_filter.setGeometry(QtCore.QRect(scale(30), scale(50), scale(691), scale(22)))
        self.lineEdit_filter.setStyleSheet("background-color: white")
        self.lineEdit_filter.setObjectName("lineEdit_filter")
        self.label_replacement_result = QtWidgets.QLabel(self.groupBox_general_replacements)
        self.label_replacement_result.setGeometry(QtCore.QRect(scale(240), scale(430), scale(471), scale(23)))
        font = QtGui.QFont()
        font.setPointSize(7)
        font.setBold(False)
        font.setWeight(50)
        self.label_replacement_result.setFont(font)
        self.label_replacement_result.setObjectName("label_replacement_result")
        self.tabWidget.addTab(self.tab_replacements, "")
        self.tab_templates = QtWidgets.QWidget()
        self.tab_templates.setEnabled(True)
        self.tab_templates.setObjectName("tab_templates")
        self.groupBox_templates = QtWidgets.QGroupBox(self.tab_templates)
        self.groupBox_templates.setGeometry(QtCore.QRect(scale(20), scale(20), scale(761), scale(451)))
        self.groupBox_templates.setStyleSheet("QListWidget, QTextEdit {\n"
"    background-color: white;\n"
"}")
        self.groupBox_templates.setObjectName("groupBox_templates")
        self.listWidget_templates = QtWidgets.QListWidget(self.groupBox_templates)
        self.listWidget_templates.setGeometry(QtCore.QRect(scale(20), scale(50), scale(181), scale(381)))
        self.listWidget_templates.setStyleSheet("")
        self.listWidget_templates.setObjectName("listWidget_templates")
        item = QtWidgets.QListWidgetItem()
        self.listWidget_templates.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_templates.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_templates.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_templates.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_templates.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_templates.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_templates.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_templates.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_templates.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_templates.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_templates.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_templates.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_templates.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_templates.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_templates.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_templates.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_templates.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_templates.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_templates.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_templates.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_templates.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_templates.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_templates.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_templates.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_templates.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_templates.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_templates.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_templates.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_templates.addItem(item)
        self.label_template_titles = QtWidgets.QLabel(self.groupBox_templates)
        self.label_template_titles.setGeometry(QtCore.QRect(scale(20), scale(30), scale(211), scale(20)))
        font = QtGui.QFont()
        font.setBold(True)
        font.setWeight(75)
        self.label_template_titles.setFont(font)
        self.label_template_titles.setObjectName("label_template_titles")
        self.label_command_meaning_2 = QtWidgets.QLabel(self.groupBox_templates)
        self.label_command_meaning_2.setGeometry(QtCore.QRect(scale(210), scale(30), scale(211), scale(20)))
        font = QtGui.QFont()
        font.setBold(True)
        font.setWeight(75)
        self.label_command_meaning_2.setFont(font)
        self.label_command_meaning_2.setObjectName("label_command_meaning_2")
        self.textEdit_2 = QtWidgets.QTextEdit(self.groupBox_templates)
        self.textEdit_2.setGeometry(QtCore.QRect(scale(210), scale(50), scale(531), scale(381)))
        self.textEdit_2.setObjectName("textEdit_2")
        self.tabWidget.addTab(self.tab_templates, "")
        self.tab_dict = QtWidgets.QWidget()
        self.tab_dict.setObjectName("tab_dict")
        self.label_2 = QtWidgets.QLabel(self.tab_dict)
        self.label_2.setGeometry(QtCore.QRect(scale(30), scale(30), scale(47), scale(16)))
        self.label_2.setObjectName("label_2")
        self.label_4 = QtWidgets.QLabel(self.tab_dict)
        self.label_4.setGeometry(QtCore.QRect(scale(290), scale(30), scale(71), scale(16)))
        self.label_4.setAlignment(QtCore.Qt.AlignRight|QtCore.Qt.AlignTrailing|QtCore.Qt.AlignVCenter)
        self.label_4.setObjectName("label_4")
        self.lineEdit = QtWidgets.QLineEdit(self.tab_dict)
        self.lineEdit.setGeometry(QtCore.QRect(scale(30), scale(50), scale(231), scale(22)))
        self.lineEdit.setStyleSheet("background-color:white")
        self.lineEdit.setReadOnly(True)
        self.lineEdit.setObjectName("lineEdit")
        self.lineEdit_2 = QtWidgets.QLineEdit(self.tab_dict)
        self.lineEdit_2.setGeometry(QtCore.QRect(scale(290), scale(50), scale(71), scale(22)))
        self.lineEdit_2.setStyleSheet("background-color:white")
        self.lineEdit_2.setAlignment(QtCore.Qt.AlignRight|QtCore.Qt.AlignTrailing|QtCore.Qt.AlignVCenter)
        self.lineEdit_2.setReadOnly(True)
        self.lineEdit_2.setObjectName("lineEdit_2")
        self.label_6 = QtWidgets.QLabel(self.tab_dict)
        self.label_6.setGeometry(QtCore.QRect(scale(390), scale(30), scale(71), scale(16)))
        self.label_6.setAlignment(QtCore.Qt.AlignRight|QtCore.Qt.AlignTrailing|QtCore.Qt.AlignVCenter)
        self.label_6.setObjectName("label_6")
        self.lineEdit_3 = QtWidgets.QLineEdit(self.tab_dict)
        self.lineEdit_3.setGeometry(QtCore.QRect(scale(390), scale(50), scale(71), scale(22)))
        self.lineEdit_3.setStyleSheet("background-color:white")
        self.lineEdit_3.setAlignment(QtCore.Qt.AlignRight|QtCore.Qt.AlignTrailing|QtCore.Qt.AlignVCenter)
        self.lineEdit_3.setReadOnly(True)
        self.lineEdit_3.setObjectName("lineEdit_3")
        self.pushButton = QtWidgets.QPushButton(self.tab_dict)
        self.pushButton.setGeometry(QtCore.QRect(scale(470), scale(50), scale(31), scale(23)))
        self.pushButton.setText("")
        icon = QtGui.QIcon()
        icon.addPixmap(QtGui.QPixmap(os.path.join(basedir, "refresh.png")), QtGui.QIcon.Normal, QtGui.QIcon.Off)
        self.pushButton.setIcon(icon)
        self.pushButton.setIconSize(QtCore.QSize(18, 18))
        self.pushButton.setFlat(True)
        self.pushButton.setObjectName("pushButton")
        self.pushButton_2 = QtWidgets.QPushButton(self.tab_dict)
        self.pushButton_2.setGeometry(QtCore.QRect(scale(30), scale(100), scale(461), scale(23)))
        self.pushButton_2.setObjectName("pushButton_2")
        self.textEdit = QtWidgets.QTextEdit(self.tab_dict)
        self.textEdit.setGeometry(QtCore.QRect(scale(30), scale(130), scale(461), scale(71)))
        self.textEdit.setObjectName("textEdit")
        self.tabWidget.addTab(self.tab_dict, "")
        self.pushButton_save = QtWidgets.QPushButton(Dialog_detailed_settings)
        self.pushButton_save.setGeometry(QtCore.QRect(scale(10), scale(589), scale(75), scale(23)))
        self.pushButton_save.setObjectName("pushButton_save")
        self.pushButton_close = QtWidgets.QPushButton(Dialog_detailed_settings)
        self.pushButton_close.setGeometry(QtCore.QRect(scale(90), scale(589), scale(75), scale(23)))
        self.pushButton_close.setObjectName("pushButton_close")
        self.label_result_status = QtWidgets.QLabel(Dialog_detailed_settings)
        self.label_result_status.setGeometry(QtCore.QRect(scale(180), scale(590), scale(491), scale(20)))
        font = QtGui.QFont()
        font.setPointSize(7)
        font.setBold(False)
        font.setWeight(50)
        self.label_result_status.setFont(font)
        self.label_result_status.setObjectName("label_result_status")

        self.retranslateUi(Dialog_detailed_settings)
        self.tabWidget.setCurrentIndex(0)
        QtCore.QMetaObject.connectSlotsByName(Dialog_detailed_settings)

    def retranslateUi(self, Dialog_detailed_settings):
        _translate = QtCore.QCoreApplication.translate
        Dialog_detailed_settings.setWindowTitle(_translate("Dialog_detailed_settings", "Podrobne nastavitve"))
        self.groupBox_postprocessing.setTitle(_translate("Dialog_detailed_settings", "Dodatna obdelava"))
        self.checkBox_numbers.setText(_translate("Dialog_detailed_settings", "Normaliziraj števila"))
        self.checkBox_spp.setText(_translate("Dialog_detailed_settings", "Dopolni šifre diagnoz (SPP)"))
        self.checkBox_capitalization.setText(_translate("Dialog_detailed_settings", "Tekst po ukazu nova vrstica/odstavek začni z veliko"))
        self.checkBox_beep_on_final.setText(_translate("Dialog_detailed_settings", "Zapiskaj ob končni razpoznavi"))
        self.checkBox_format_notes.setText(_translate("Dialog_detailed_settings", "Označi opombe"))
        self.groupBox_dictaphone.setTitle(_translate("Dialog_detailed_settings", "Upravljanje z diktafonom"))
        self.checkBox_dictaphone_toggle.setText(_translate("Dialog_detailed_settings", "Detektiraj gumb za preklapljanje med snemaj/pavza"))
        self.label_toggle_key_combination.setText(_translate("Dialog_detailed_settings", "Simuliraj kombinacijo tipk"))
        self.groupBox_general.setTitle(_translate("Dialog_detailed_settings", "Ob zagonu"))
        self.checkBox_minimize.setText(_translate("Dialog_detailed_settings", "Pomanjšaj v sistemsko vrstico"))
        self.checkBox_purge_queue.setText(_translate("Dialog_detailed_settings", "Sprazni vrsto zunanjih ukazov"))
        self.checkBox_listen_external.setText(_translate("Dialog_detailed_settings", "Odpri vrsto za poslušanje zunanjih ukazov"))
        self.groupBox_proxy.setTitle(_translate("Dialog_detailed_settings", "Proxy strežnik"))
        self.checkBox_use_proxy.setText(_translate("Dialog_detailed_settings", "Uporabi proxy strežnik"))
        self.label_host.setText(_translate("Dialog_detailed_settings", "Naslov strežnika (IP)"))
        self.label_port.setText(_translate("Dialog_detailed_settings", "Vrata (port)"))
        self.label_protocol.setText(_translate("Dialog_detailed_settings", "Protokol"))
        self.label_username.setText(_translate("Dialog_detailed_settings", "Uporabniško ime"))
        self.label_password.setText(_translate("Dialog_detailed_settings", "Geslo"))
        self.comboBox_protocol.setItemText(0, _translate("Dialog_detailed_settings", "none"))
        self.comboBox_protocol.setItemText(1, _translate("Dialog_detailed_settings", "http"))
        self.comboBox_protocol.setItemText(2, _translate("Dialog_detailed_settings", "socks4"))
        self.comboBox_protocol.setItemText(3, _translate("Dialog_detailed_settings", "socks4a"))
        self.comboBox_protocol.setItemText(4, _translate("Dialog_detailed_settings", "socks5"))
        self.comboBox_protocol.setItemText(5, _translate("Dialog_detailed_settings", "socks5h"))
        self.groupBox_focus.setTitle(_translate("Dialog_detailed_settings", "Samodejno fokusiranje na okno"))
        self.checkBox_focus_by_key.setText(_translate("Dialog_detailed_settings", "S tipkami za preklop"))
        self.checkBox_focus_by_title.setText(_translate("Dialog_detailed_settings", "Po nazivu okna"))
        self.groupBox_PID.setTitle(_translate("Dialog_detailed_settings", "Identifikacija seje"))
        self.checkBox_show_PID.setText(_translate("Dialog_detailed_settings", "Prikaži okno za vnos oznake seje"))
        self.tabWidget.setTabText(self.tabWidget.indexOf(self.tab_basic), _translate("Dialog_detailed_settings", "Osnovno"))
        self.groupBox_command_settings.setTitle(_translate("Dialog_detailed_settings", "Nastavitve ukazov"))
        __sortingEnabled = self.listWidget_command.isSortingEnabled()
        self.listWidget_command.setSortingEnabled(False)
        item = self.listWidget_command.item(0)
        item.setText(_translate("Dialog_detailed_settings", "nova vrsta"))
        item = self.listWidget_command.item(1)
        item.setText(_translate("Dialog_detailed_settings", "nov odstavek"))
        item = self.listWidget_command.item(2)
        item.setText(_translate("Dialog_detailed_settings", "vključi velike črke"))
        item = self.listWidget_command.item(3)
        item.setText(_translate("Dialog_detailed_settings", "izključi velike črke"))
        item = self.listWidget_command.item(4)
        item.setText(_translate("Dialog_detailed_settings", "vključi odebeljeno"))
        item = self.listWidget_command.item(5)
        item.setText(_translate("Dialog_detailed_settings", "izključi odebeljeno"))
        item = self.listWidget_command.item(6)
        item.setText(_translate("Dialog_detailed_settings", "vključi poševno"))
        item = self.listWidget_command.item(7)
        item.setText(_translate("Dialog_detailed_settings", "izključi poševno"))
        item = self.listWidget_command.item(8)
        item.setText(_translate("Dialog_detailed_settings", "vključi podčrtano"))
        item = self.listWidget_command.item(9)
        item.setText(_translate("Dialog_detailed_settings", "izključi podčrtano"))
        item = self.listWidget_command.item(10)
        item.setText(_translate("Dialog_detailed_settings", "velike črke"))
        item = self.listWidget_command.item(11)
        item.setText(_translate("Dialog_detailed_settings", "odebeljeno"))
        item = self.listWidget_command.item(12)
        item.setText(_translate("Dialog_detailed_settings", "poševno"))
        item = self.listWidget_command.item(13)
        item.setText(_translate("Dialog_detailed_settings", "podčrtano"))
        item = self.listWidget_command.item(14)
        item.setText(_translate("Dialog_detailed_settings", "z veliko začetnico"))
        item = self.listWidget_command.item(15)
        item.setText(_translate("Dialog_detailed_settings", "poravnaj levo"))
        item = self.listWidget_command.item(16)
        item.setText(_translate("Dialog_detailed_settings", "poravnaj desno"))
        item = self.listWidget_command.item(17)
        item.setText(_translate("Dialog_detailed_settings", "poravnaj na sredino"))
        item = self.listWidget_command.item(18)
        item.setText(_translate("Dialog_detailed_settings", "briši"))
        item = self.listWidget_command.item(19)
        item.setText(_translate("Dialog_detailed_settings", "izberi vse"))
        item = self.listWidget_command.item(20)
        item.setText(_translate("Dialog_detailed_settings", "potrdi"))
        item = self.listWidget_command.item(21)
        item.setText(_translate("Dialog_detailed_settings", "prekliči"))
        item = self.listWidget_command.item(22)
        item.setText(_translate("Dialog_detailed_settings", "vstavi"))
        item = self.listWidget_command.item(23)
        item.setText(_translate("Dialog_detailed_settings", "naslednji"))
        item = self.listWidget_command.item(24)
        item.setText(_translate("Dialog_detailed_settings", "prejšnji"))
        item = self.listWidget_command.item(25)
        item.setText(_translate("Dialog_detailed_settings", "pavza"))
        item = self.listWidget_command.item(26)
        item.setText(_translate("Dialog_detailed_settings", "konec diktata"))
        item = self.listWidget_command.item(27)
        item.setText(_translate("Dialog_detailed_settings", "zapomni"))
        item = self.listWidget_command.item(28)
        item.setText(_translate("Dialog_detailed_settings", "prilepi"))
        self.listWidget_command.setSortingEnabled(__sortingEnabled)
        self.label_command.setText(_translate("Dialog_detailed_settings", "Ukaz"))
        self.label_command_meaning.setText(_translate("Dialog_detailed_settings", "Pomen ukaza"))
        self.groupBox.setTitle(_translate("Dialog_detailed_settings", "Nastavitve ukaza"))
        self.label_dest.setText(_translate("Dialog_detailed_settings", "Izhod"))
        self.label_copy2clip.setText(_translate("Dialog_detailed_settings", "Kopiraj v odložišče"))
        self.label_copy2buf.setText(_translate("Dialog_detailed_settings", "Kopiraj v pomnilnik"))
        self.label_keypress.setText(_translate("Dialog_detailed_settings", "Simuliraj pritisk tipk"))
        self.comboBox_destination_format.setItemText(0, _translate("Dialog_detailed_settings", "navadno besedilo (txt)"))
        self.comboBox_destination_format.setItemText(1, _translate("Dialog_detailed_settings", "oblikovano besedilo (rtf)"))
        self.comboBox_destination_format.setItemText(2, _translate("Dialog_detailed_settings", "oblikovano besedilo (docx)"))
        self.comboBox_destination_format.setItemText(3, _translate("Dialog_detailed_settings", "B21"))
        self.label_repeat.setText(_translate("Dialog_detailed_settings", "Ponovi"))
        self.tabWidget.setTabText(self.tabWidget.indexOf(self.tab_commands), _translate("Dialog_detailed_settings", "Ukazi"))
        self.groupBox_general_replacements.setTitle(_translate("Dialog_detailed_settings", "Splošne zamenjave"))
        self.pushButton_add_basic_repl.setText(_translate("Dialog_detailed_settings", "Dodaj"))
        self.pushButton_del_basic_repl.setText(_translate("Dialog_detailed_settings", "Briši"))
        __sortingEnabled = self.listWidget_basic_repl.isSortingEnabled()
        self.listWidget_basic_repl.setSortingEnabled(False)
        item = self.listWidget_basic_repl.item(0)
        item.setText(_translate("Dialog_detailed_settings", "df: diloman"))
        item = self.listWidget_basic_repl.item(1)
        item.setText(_translate("Dialog_detailed_settings", "e recept: eRecept"))
        item = self.listWidget_basic_repl.item(2)
        item.setText(_translate("Dialog_detailed_settings", "mm Hg: mmHg"))
        self.listWidget_basic_repl.setSortingEnabled(__sortingEnabled)
        self.pushButton_update_basic_repl.setText(_translate("Dialog_detailed_settings", "Spremeni"))
        self.label.setText(_translate("Dialog_detailed_settings", "Filter"))
        self.label_replacement_result.setText(_translate("Dialog_detailed_settings", "TextLabel"))
        self.tabWidget.setTabText(self.tabWidget.indexOf(self.tab_replacements), _translate("Dialog_detailed_settings", "Zamenjave"))
        self.groupBox_templates.setTitle(_translate("Dialog_detailed_settings", "Upravljanje predlog"))
        __sortingEnabled = self.listWidget_templates.isSortingEnabled()
        self.listWidget_templates.setSortingEnabled(False)
        item = self.listWidget_templates.item(0)
        item.setText(_translate("Dialog_detailed_settings", "nova vrsta"))
        item = self.listWidget_templates.item(1)
        item.setText(_translate("Dialog_detailed_settings", "nov odstavek"))
        item = self.listWidget_templates.item(2)
        item.setText(_translate("Dialog_detailed_settings", "vključi velike črke"))
        item = self.listWidget_templates.item(3)
        item.setText(_translate("Dialog_detailed_settings", "izključi velike črke"))
        item = self.listWidget_templates.item(4)
        item.setText(_translate("Dialog_detailed_settings", "vključi odebeljeno"))
        item = self.listWidget_templates.item(5)
        item.setText(_translate("Dialog_detailed_settings", "izključi odebeljeno"))
        item = self.listWidget_templates.item(6)
        item.setText(_translate("Dialog_detailed_settings", "vključi poševno"))
        item = self.listWidget_templates.item(7)
        item.setText(_translate("Dialog_detailed_settings", "izključi poševno"))
        item = self.listWidget_templates.item(8)
        item.setText(_translate("Dialog_detailed_settings", "vključi podčrtano"))
        item = self.listWidget_templates.item(9)
        item.setText(_translate("Dialog_detailed_settings", "izključi podčrtano"))
        item = self.listWidget_templates.item(10)
        item.setText(_translate("Dialog_detailed_settings", "velike črke"))
        item = self.listWidget_templates.item(11)
        item.setText(_translate("Dialog_detailed_settings", "odebeljeno"))
        item = self.listWidget_templates.item(12)
        item.setText(_translate("Dialog_detailed_settings", "poševno"))
        item = self.listWidget_templates.item(13)
        item.setText(_translate("Dialog_detailed_settings", "podčrtano"))
        item = self.listWidget_templates.item(14)
        item.setText(_translate("Dialog_detailed_settings", "z veliko začetnico"))
        item = self.listWidget_templates.item(15)
        item.setText(_translate("Dialog_detailed_settings", "poravnaj levo"))
        item = self.listWidget_templates.item(16)
        item.setText(_translate("Dialog_detailed_settings", "poravnaj desno"))
        item = self.listWidget_templates.item(17)
        item.setText(_translate("Dialog_detailed_settings", "poravnaj na sredino"))
        item = self.listWidget_templates.item(18)
        item.setText(_translate("Dialog_detailed_settings", "briši"))
        item = self.listWidget_templates.item(19)
        item.setText(_translate("Dialog_detailed_settings", "izberi vse"))
        item = self.listWidget_templates.item(20)
        item.setText(_translate("Dialog_detailed_settings", "potrdi"))
        item = self.listWidget_templates.item(21)
        item.setText(_translate("Dialog_detailed_settings", "prekliči"))
        item = self.listWidget_templates.item(22)
        item.setText(_translate("Dialog_detailed_settings", "vstavi"))
        item = self.listWidget_templates.item(23)
        item.setText(_translate("Dialog_detailed_settings", "naslednji"))
        item = self.listWidget_templates.item(24)
        item.setText(_translate("Dialog_detailed_settings", "prejšnji"))
        item = self.listWidget_templates.item(25)
        item.setText(_translate("Dialog_detailed_settings", "pavza"))
        item = self.listWidget_templates.item(26)
        item.setText(_translate("Dialog_detailed_settings", "konec diktata"))
        item = self.listWidget_templates.item(27)
        item.setText(_translate("Dialog_detailed_settings", "zapomni"))
        item = self.listWidget_templates.item(28)
        item.setText(_translate("Dialog_detailed_settings", "prilepi"))
        self.listWidget_templates.setSortingEnabled(__sortingEnabled)
        self.label_template_titles.setText(_translate("Dialog_detailed_settings", "Naziv predloge"))
        self.label_command_meaning_2.setText(_translate("Dialog_detailed_settings", "Predloga"))
        self.textEdit_2.setHtml(_translate("Dialog_detailed_settings", "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0//EN\" \"http://www.w3.org/TR/REC-html40/strict.dtd\">\n"
"<html><head><meta name=\"qrichtext\" content=\"1\" /><style type=\"text/css\">\n"
"p, li { white-space: pre-wrap; }\n"
"</style></head><body style=\" font-family:\'MS Shell Dlg 2\'; font-size:8.25pt; font-weight:400; font-style:normal;\">\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt; font-weight:600; color:#000000;\">DOPPLER  VRATNIH  ARTERIJ</span><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt; color:#000000;\"> </span></p>\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt; color:#000000;\"> </span><span style=\" font-size:8pt;\"> </span></p>\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt; font-weight:600; color:#000000;\">Indikacija</span><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt; color:#000000;\">:</span><span style=\" font-size:8pt;\"> </span></p>\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt; color:#000000;\"> </span><span style=\" font-size:8pt;\"> </span></p>\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt; font-weight:600; color:#000000;\">Dejavniki tveganja za aterosklerotični proces</span><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt; color:#000000;\">: </span></p>\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt; color:#000000;\"> </span><span style=\" font-size:8pt;\"> </span></p>\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt; font-weight:600; color:#000000;\">Terapija</span><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt; color:#000000;\">:</span><span style=\" font-size:8pt;\"> </span></p>\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt; color:#000000;\"> </span><span style=\" font-size:8pt;\"> </span></p>\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt; font-weight:600; color:#000000;\">RR</span><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt; color:#000000;\"> </span><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt; font-weight:600; color:#000000;\">nadlahti</span><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt; color:#000000;\">:</span><span style=\" font-size:8pt;\"> </span></p>\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt; color:#000000;\"> </span><span style=\" font-size:8pt;\"> </span></p>\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt; color:#000000;\"> </span><span style=\" font-size:8pt;\"> </span></p>\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt; font-weight:600; color:#000000;\">2 D IN BARVNI PRIKAZ</span><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt; color:#000000;\">:</span><span style=\" font-size:8pt;\"> </span></p>\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt; color:#000000;\"> </span><span style=\" font-size:8pt;\"> </span></p>\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt; color:#000000;\"> </span><span style=\" font-size:8pt;\"> </span></p>\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt; font-style:italic; text-decoration: underline; color:#000000;\">PW doppler (sistolne/diastolne hitrosti toka v cm/sek)</span><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt; color:#000000;\">:</span><span style=\" font-size:8pt;\"> </span></p>\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt; color:#000000;\"> </span><span style=\" font-size:8pt;\"> </span></p>\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt; color:#000000;\">                                  desno                    levo</span><span style=\" font-size:8pt;\"> </span></p>\n"
"<table border=\"1\" style=\" margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px;\" width=\"340\" cellspacing=\"0\" cellpadding=\"0\">\n"
"<tr>\n"
"<td width=\"114\" style=\" vertical-align:top; padding-left:0; padding-right:0; padding-top:0; padding-bottom:0;\">\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt;\">ACC</span><span style=\" font-size:8pt;\"> </span></p></td>\n"
"<td width=\"111\" style=\" vertical-align:top; padding-left:0; padding-right:0; padding-top:0; padding-bottom:0;\">\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:8pt;\"> </span><span style=\" font-size:8pt;\"> </span></p></td>\n"
"<td width=\"115\" style=\" vertical-align:top; padding-left:0; padding-right:0; padding-top:0; padding-bottom:0;\">\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:8pt;\"> </span><span style=\" font-size:8pt;\"> </span></p></td></tr>\n"
"<tr>\n"
"<td style=\" vertical-align:top; padding-left:0; padding-right:0; padding-top:0; padding-bottom:0;\">\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt;\">ACI</span><span style=\" font-size:8pt;\"> </span></p></td>\n"
"<td style=\" vertical-align:top; padding-left:0; padding-right:0; padding-top:0; padding-bottom:0;\">\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:8pt;\"> </span><span style=\" font-size:8pt;\"> </span></p></td>\n"
"<td style=\" vertical-align:top; padding-left:0; padding-right:0; padding-top:0; padding-bottom:0;\">\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:8pt;\"> </span><span style=\" font-size:8pt;\"> </span></p></td></tr>\n"
"<tr>\n"
"<td style=\" vertical-align:top; padding-left:0; padding-right:0; padding-top:0; padding-bottom:0;\">\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt;\">ACE</span><span style=\" font-size:8pt;\"> </span></p></td>\n"
"<td style=\" vertical-align:top; padding-left:0; padding-right:0; padding-top:0; padding-bottom:0;\">\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:8pt;\"> </span><span style=\" font-size:8pt;\"> </span></p></td>\n"
"<td style=\" vertical-align:top; padding-left:0; padding-right:0; padding-top:0; padding-bottom:0;\">\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:8pt;\"> </span><span style=\" font-size:8pt;\"> </span></p></td></tr>\n"
"<tr>\n"
"<td style=\" vertical-align:top; padding-left:0; padding-right:0; padding-top:0; padding-bottom:0;\">\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt;\">VA</span><span style=\" font-size:8pt;\"> </span></p></td>\n"
"<td style=\" vertical-align:top; padding-left:0; padding-right:0; padding-top:0; padding-bottom:0;\">\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:8pt;\"> </span><span style=\" font-size:8pt;\"> </span></p></td>\n"
"<td style=\" vertical-align:top; padding-left:0; padding-right:0; padding-top:0; padding-bottom:0;\">\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:8pt;\"> </span><span style=\" font-size:8pt;\"> </span></p></td></tr></table>\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt; color:#000000;\"> </span><span style=\" font-size:8pt;\"> </span></p>\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt; color:#000000;\"> </span><span style=\" font-size:8pt;\"> </span></p>\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt; color:#000000;\"> </span><span style=\" font-size:8pt;\"> </span></p>\n"
"<p style=\" margin-top:12px; margin-bottom:12px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt; font-weight:600; color:#000000;\">M N E N J E</span><span style=\" font-family:\'Arial,sans-serif\'; font-size:11pt; color:#000000;\"> :</span><span style=\" font-size:8pt;\"> </span></p></body></html>"))
        self.tabWidget.setTabText(self.tabWidget.indexOf(self.tab_templates), _translate("Dialog_detailed_settings", "Predloge"))
        self.label_2.setText(_translate("Dialog_detailed_settings", "Model"))
        self.label_4.setText(_translate("Dialog_detailed_settings", "Vseh besed"))
        self.lineEdit.setText(_translate("Dialog_detailed_settings", "KALDI, sl-SI, MED, 20221201-1735"))
        self.lineEdit_2.setText(_translate("Dialog_detailed_settings", "120.988"))
        self.label_6.setText(_translate("Dialog_detailed_settings", "Novih besed"))
        self.lineEdit_3.setText(_translate("Dialog_detailed_settings", "8"))
        self.pushButton_2.setText(_translate("Dialog_detailed_settings", "Sproži prenovo modela"))
        self.textEdit.setHtml(_translate("Dialog_detailed_settings", "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0//EN\" \"http://www.w3.org/TR/REC-html40/strict.dtd\">\n"
"<html><head><meta name=\"qrichtext\" content=\"1\" /><style type=\"text/css\">\n"
"p, li { white-space: pre-wrap; }\n"
"</style></head><body style=\" font-family:\'MS Shell Dlg 2\'; font-size:8.25pt; font-weight:400; font-style:normal;\">\n"
"<p style=\" margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-weight:600; color:#ff0000;\">Opozorilo</span><span style=\" color:#ff0000;\">: postopek prenove lahko traja več kot 20 minut. Ko bo model prenovljen, se bodo vse seje z obstoječim modelom samodejno zaključile! Prenovljeni model bo na voljo v nastavitvah kot nova izbira.</span></p></body></html>"))
        self.tabWidget.setTabText(self.tabWidget.indexOf(self.tab_dict), _translate("Dialog_detailed_settings", "Slovar"))
        self.pushButton_save.setText(_translate("Dialog_detailed_settings", "Shrani"))
        self.pushButton_close.setText(_translate("Dialog_detailed_settings", "Zapri"))
        self.label_result_status.setText(_translate("Dialog_detailed_settings", "TextLabel"))

class Ui_Dialog_add_word(object):
    def setupUi(self, Dialog_add_word):
        Dialog_add_word.setObjectName("Dialog_add_word")
        Dialog_add_word.resize(242, 441)
        Dialog_add_word.setStyleSheet("QPushButton {\n"
"    background-color: lightgrey;\n"
"}\n"
"QDialog {\n"
"    background-color: rgb(234, 241, 221);\n"
"}\n"
"QComboBox {\n"
"    background-color: white\n"
"}")
        self.label_word = QtWidgets.QLabel(Dialog_add_word)
        self.label_word.setGeometry(QtCore.QRect(10, 10, 41, 16))
        self.label_word.setObjectName("label_word")
        self.lineEdit_word = QtWidgets.QLineEdit(Dialog_add_word)
        self.lineEdit_word.setGeometry(QtCore.QRect(10, 30, 191, 22))
        font = QtGui.QFont()
        font.setPointSize(8)
        font.setBold(True)
        font.setWeight(75)
        self.lineEdit_word.setFont(font)
        self.lineEdit_word.setObjectName("lineEdit_word")
        self.label_tf = QtWidgets.QLabel(Dialog_add_word)
        self.label_tf.setGeometry(QtCore.QRect(10, 80, 221, 16))
        self.label_tf.setObjectName("label_tf")
        self.comboBox_tf = QtWidgets.QComboBox(Dialog_add_word)
        self.comboBox_tf.setGeometry(QtCore.QRect(10, 100, 221, 22))
        self.comboBox_tf.setObjectName("comboBox_tf")
        self.groupBox_pron = QtWidgets.QGroupBox(Dialog_add_word)
        self.groupBox_pron.setGeometry(QtCore.QRect(10, 140, 221, 241))
        self.groupBox_pron.setStyleSheet("QGroupBox {\n"
"    background-color:rgb(244, 244, 244);\n"
"}")
        self.groupBox_pron.setObjectName("groupBox_pron")
        self.pushButton_add_pron = QtWidgets.QPushButton(self.groupBox_pron)
        self.pushButton_add_pron.setGeometry(QtCore.QRect(10, 210, 61, 23))
        self.pushButton_add_pron.setStyleSheet("")
        self.pushButton_add_pron.setObjectName("pushButton_add_pron")
        self.listWidget_pron = QtWidgets.QListWidget(self.groupBox_pron)
        self.listWidget_pron.setGeometry(QtCore.QRect(10, 21, 201, 151))
        self.listWidget_pron.setObjectName("listWidget_pron")
        item = QtWidgets.QListWidgetItem()
        self.listWidget_pron.addItem(item)
        item = QtWidgets.QListWidgetItem()
        self.listWidget_pron.addItem(item)
        self.pushButton_del_pron = QtWidgets.QPushButton(self.groupBox_pron)
        self.pushButton_del_pron.setGeometry(QtCore.QRect(150, 210, 61, 23))
        self.pushButton_del_pron.setStyleSheet("")
        self.pushButton_del_pron.setObjectName("pushButton_del_pron")
        self.lineEdit_curr_pron = QtWidgets.QLineEdit(self.groupBox_pron)
        self.lineEdit_curr_pron.setGeometry(QtCore.QRect(10, 180, 201, 22))
        self.lineEdit_curr_pron.setObjectName("lineEdit_curr_pron")
        self.pushButton_update_pron = QtWidgets.QPushButton(self.groupBox_pron)
        self.pushButton_update_pron.setGeometry(QtCore.QRect(80, 210, 61, 23))
        self.pushButton_update_pron.setStyleSheet("")
        self.pushButton_update_pron.setObjectName("pushButton_update_pron")
        self.pushButton_dict_save = QtWidgets.QPushButton(Dialog_add_word)
        self.pushButton_dict_save.setGeometry(QtCore.QRect(10, 400, 108, 23))
        self.pushButton_dict_save.setObjectName("pushButton_dict_save")
        self.pushButton_dict_close = QtWidgets.QPushButton(Dialog_add_word)
        self.pushButton_dict_close.setGeometry(QtCore.QRect(122, 400, 108, 23))
        self.pushButton_dict_close.setObjectName("pushButton_dict_close")
        self.pushButton_readDict = QtWidgets.QPushButton(Dialog_add_word)
        self.pushButton_readDict.setGeometry(QtCore.QRect(204, 29, 28, 23))
        self.pushButton_readDict.setStyleSheet("")
        self.pushButton_readDict.setText("")
        icon = QtGui.QIcon()
        icon.addPixmap(QtGui.QPixmap("download.png"), QtGui.QIcon.Normal, QtGui.QIcon.Off)
        self.pushButton_readDict.setIcon(icon)
        self.pushButton_readDict.setIconSize(QtCore.QSize(16, 16))
        self.pushButton_readDict.setAutoDefault(False)
        self.pushButton_readDict.setDefault(True)
        self.pushButton_readDict.setFlat(False)
        self.pushButton_readDict.setObjectName("pushButton_readDict")
        self.label_word_status = QtWidgets.QLabel(Dialog_add_word)
        self.label_word_status.setGeometry(QtCore.QRect(10, 52, 221, 20))
        font = QtGui.QFont()
        font.setPointSize(7)
        font.setBold(False)
        font.setWeight(50)
        self.label_word_status.setFont(font)
        self.label_word_status.setStyleSheet("")
        self.label_word_status.setAlignment(QtCore.Qt.AlignLeading|QtCore.Qt.AlignLeft|QtCore.Qt.AlignVCenter)
        self.label_word_status.setObjectName("label_word_status")
        self.label_action_status = QtWidgets.QLabel(Dialog_add_word)
        self.label_action_status.setGeometry(QtCore.QRect(20, 380, 201, 20))
        font = QtGui.QFont()
        font.setPointSize(7)
        font.setBold(False)
        font.setWeight(50)
        self.label_action_status.setFont(font)
        self.label_action_status.setStyleSheet("")
        self.label_action_status.setAlignment(QtCore.Qt.AlignLeading|QtCore.Qt.AlignLeft|QtCore.Qt.AlignVCenter)
        self.label_action_status.setObjectName("label_action_status")
        self.pushButton_update_model = QtWidgets.QPushButton(Dialog_add_word)
        self.pushButton_update_model.setGeometry(QtCore.QRect(10, 460, 221, 41))
        self.pushButton_update_model.setObjectName("pushButton_update_model")
        self.pushButton_expand = QtWidgets.QPushButton(Dialog_add_word)
        self.pushButton_expand.setGeometry(QtCore.QRect(83, 420, 75, 23))
        self.pushButton_expand.setStyleSheet("border-style: none;\n"
"background-color: none;")
        self.pushButton_expand.setText("")
        icon1 = QtGui.QIcon()
        icon1.addPixmap(QtGui.QPixmap("more.png"), QtGui.QIcon.Normal, QtGui.QIcon.Off)
        self.pushButton_expand.setIcon(icon1)
        self.pushButton_expand.setFlat(True)
        self.pushButton_expand.setObjectName("pushButton_expand")
        self.label_badge = QtWidgets.QLabel(Dialog_add_word)
        self.label_badge.setGeometry(QtCore.QRect(20, 468, 25, 25))
        self.label_badge.setAlignment(QtCore.Qt.AlignCenter)
        self.label_badge.setObjectName("label_badge")
        self.label_update_status = QtWidgets.QLabel(Dialog_add_word)
        self.label_update_status.setGeometry(QtCore.QRect(16, 440, 211, 20))
        font = QtGui.QFont()
        font.setPointSize(7)
        self.label_update_status.setFont(font)
        self.label_update_status.setAlignment(QtCore.Qt.AlignCenter)
        self.label_update_status.setObjectName("label_update_status")

        self.retranslateUi(Dialog_add_word)
        QtCore.QMetaObject.connectSlotsByName(Dialog_add_word)

    def retranslateUi(self, Dialog_add_word):
        _translate = QtCore.QCoreApplication.translate
        Dialog_add_word.setWindowTitle(_translate("Dialog_add_word", "Dodaj besedo"))
        self.label_word.setText(_translate("Dialog_add_word", "Beseda"))
        self.lineEdit_word.setText(_translate("Dialog_add_word", "beseda"))
        self.label_tf.setText(_translate("Dialog_add_word", "Pogostost"))
        self.groupBox_pron.setTitle(_translate("Dialog_add_word", "Izgovorjave"))
        self.pushButton_add_pron.setText(_translate("Dialog_add_word", "Dodaj"))
        __sortingEnabled = self.listWidget_pron.isSortingEnabled()
        self.listWidget_pron.setSortingEnabled(False)
        item = self.listWidget_pron.item(0)
        item.setText(_translate("Dialog_add_word", "beseda"))
        item = self.listWidget_pron.item(1)
        item.setText(_translate("Dialog_add_word", "biseda"))
        self.listWidget_pron.setSortingEnabled(__sortingEnabled)
        self.pushButton_del_pron.setText(_translate("Dialog_add_word", "Briši"))
        self.pushButton_update_pron.setText(_translate("Dialog_add_word", "Spremeni"))
        self.pushButton_dict_save.setText(_translate("Dialog_add_word", "Shrani"))
        self.pushButton_dict_close.setText(_translate("Dialog_add_word", "Zapri"))
        self.pushButton_readDict.setToolTip(_translate("Dialog_add_word", "poišči besedo v slovarju"))
        self.label_word_status.setText(_translate("Dialog_add_word", "nova beseda"))
        self.label_action_status.setText(_translate("Dialog_add_word", "nova beseda"))
        self.pushButton_update_model.setText(_translate("Dialog_add_word", "Prenovi model"))
        self.label_badge.setText(_translate("Dialog_add_word", "O"))
        self.label_update_status.setText(_translate("Dialog_add_word", "Model se prenavlja ..."))


