<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://zzzs.si/b2b/Ceniki" 
  xmlns:nsoct="http://zzzs.si/b2b/nso/ComplexTypes">
  <xsl:output method="text" encoding="windows-1250" indent="yes"/>
  <xsl:strip-space elements="*" />
  
    <xsl:variable name="v_StevilkaPosiljke"  select="/xs:Ceniki/xs:PodatkiOPosiljki/xs:ZapStPosNaDan"></xsl:variable>
    <xsl:variable name="v_DatumPosiljke"  select="/xs:Ceniki/xs:PodatkiOPosiljki/xs:DtPriPos"></xsl:variable>
    <xsl:variable name="v_LetoObjave"  select="/xs:Ceniki/xs:PodatkiObjave/xs:LetoObjave"></xsl:variable>
    <xsl:variable name="v_StevilkaObjave"  select="/xs:Ceniki/xs:PodatkiObjave/xs:StevilkaObjave"></xsl:variable>
    <xsl:variable name="v_DatumObjave"  select="/xs:Ceniki/xs:PodatkiObjave/xs:DatumObjave"></xsl:variable>
    <xsl:variable name="v_KomVsebSprememb"  select="/xs:Ceniki/xs:PodatkiObjave/xs:KomVsebSprememb"></xsl:variable>
    <xsl:variable name="v_VrstaCenika"  select="/xs:Ceniki/xs:PodatkiObjave/xs:VrstaCenika"></xsl:variable>
    <xsl:variable name="v_VeljaOd"  select="/xs:Ceniki/xs:PodatkiObjave/xs:VeljaOd"></xsl:variable>
    <xsl:variable name="v_VeljaDo">
		<xsl:choose>
			<xsl:when test="/xs:Ceniki/xs:PodatkiObjave/xs:VeljaDo"> to_date('<xsl:value-of select="/xs:Ceniki/xs:PodatkiObjave/xs:VeljaDo" />', 'yyyy-mm-dd') </xsl:when>
			<xsl:otherwise>NULL</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
  
  <xsl:template match="xs:PodatkiObjave">
    begin
    insert into inet.imp_pr115hed (IDHED115, IDIMP002, TYPEZ115, STATP115, YEAR_115, POSTN115, DATPO115, OBJAV115, DATOB115, MODE_115, TEXT_115, SSIF_F16)
    values ( xREPL002, xREPL001, '22', '1', to_date('<xsl:value-of select="$v_LetoObjave" />-01-01', 'yyyy-mm-dd') , <xsl:value-of select="$v_StevilkaPosiljke" />, to_date('<xsl:value-of select="$v_DatumPosiljke" />', 'yyyy-mm-dd'), <xsl:value-of select="$v_StevilkaObjave" />, to_date('<xsl:value-of select="$v_DatumObjave" />', 'yyyy-mm-dd'), 'xREPL003', '<xsl:value-of select="$v_KomVsebSprememb" />', 'F16ForChange') ;
  </xsl:template>
  
  <xsl:template match="xs:Cene">
    <xsl:apply-templates select="xs:CeneStoritevTipaEME"/>
    <xsl:apply-templates select="xs:CeneStoritevTipaKOL"/>
    <xsl:apply-templates select="xs:CeneStoritevTipaTOC"/>
    <xsl:apply-templates select="xs:CeneStoritevTipaUTE"/>
    <xsl:apply-templates select="xs:CeneStoritevTipaDAN"/>
    <xsl:apply-templates select="xs:CeneStoritevTipaPRI"/>
    <xsl:apply-templates select="xs:CeneStoritevTipaLZM"/>
    <xsl:apply-templates select="xs:CeneStoritevTipaCMP"/>
    <xsl:apply-templates select="xs:CeneStoritevTipaPAV"/>
  	commit;
	end;
</xsl:template>
  
  <xsl:template match="xs:CeneStoritevTipaEME">
    <xsl:for-each select="xs:Zapis">
      insert into inet.IMP_PR115CT0 ( IMP__115, 
        YEAR_115, 
        POSTN115, 
        DATPO115,  
        TEXT_115, 
        TYPE_115,
        DATO_115,
        DATD_115,
        ID___027,
        CODEV074,
        CODEP074,
        DATOD115,
		<xsl:if test='xs:VeljaDo'>DATDO115,</xsl:if>
        CODE_011,
        PRICE115,
        VREL_115,
        KOLIC115,
		IDIMP002, IDHED115,
		SSIF_F16,
		PLANG011
        ) 
        values ( inet.getsequence('IMP_PR115CT0'), 
            to_date('<xsl:value-of select="$v_LetoObjave" />-01-01', 'yyyy-mm-dd') , 
            <xsl:value-of select="$v_StevilkaPosiljke" />, 
            to_date('<xsl:value-of select="$v_DatumPosiljke" />', 'yyyy-mm-dd'), 
            '<xsl:value-of select="$v_KomVsebSprememb" />', 
            <xsl:value-of select="$v_VrstaCenika" />, 
            to_date('<xsl:value-of select="$v_VeljaOd" />', 'yyyy-mm-dd'), 
            <xsl:value-of select="$v_VeljaDo" />, 
			'EME',
			'<xsl:value-of select="xs:SifraVrsZdrDej" />',
			'<xsl:value-of select="xs:SifraPodZdrDej" />',
            to_date('<xsl:value-of select="xs:VeljaOd" />', 'yyyy-mm-dd'), 
			<xsl:if test='xs:VeljaDo'>to_date('<xsl:value-of select="xs:VeljaDo" />', 'yyyy-mm-dd'),</xsl:if>
			'<xsl:value-of select="xs:SiSto" />', 
			<xsl:value-of select="xs:CenaZaEnotoMere" />, 0, 0,
            xREPL001, xREPL002,			
			'F16ForChange',
			'<xsl:value-of select="xs:SifraSkuStoPla" />'
        ) ;
    </xsl:for-each>
  </xsl:template>

  <xsl:template match="xs:CeneStoritevTipaKOL">
    <xsl:for-each select="xs:Zapis">
      insert into inet.IMP_PR115CT0 ( IMP__115, 
        YEAR_115, 
        POSTN115, 
        DATPO115,  
        TEXT_115, 
        TYPE_115,
        DATO_115,
        DATD_115,
        ID___027,
        CODEV074,
        CODEP074,
        DATOD115,
		<xsl:if test='xs:VeljaDo'>DATDO115,</xsl:if>
        CODE_011,
        PRICE115
        <xsl:if test='xs:NizkaCenaKolicnika'>,VREL_115</xsl:if>
        <xsl:if test='xs:VisokaCenaKolicnika'>,KOLIC115</xsl:if>
		, IDIMP002, IDHED115, SSIF_F16,
		PLANG011
        ) 
        values ( inet.getsequence('IMP_PR115CT0'), 
            to_date('<xsl:value-of select="$v_LetoObjave" />-01-01', 'yyyy-mm-dd'), 
            <xsl:value-of select="$v_StevilkaPosiljke" />, 
            to_date('<xsl:value-of select="$v_DatumPosiljke" />', 'yyyy-mm-dd'), 
            '<xsl:value-of select="$v_KomVsebSprememb" />', 
            <xsl:value-of select="$v_VrstaCenika" />, 
            to_date('<xsl:value-of select="$v_VeljaOd" />', 'yyyy-mm-dd'), 
            <xsl:value-of select="$v_VeljaDo" />, 
			'KOL',
			'<xsl:value-of select="xs:SifraVrsZdrDej" />',
			'<xsl:value-of select="xs:SifraPodZdrDej" />',
            to_date('<xsl:value-of select="xs:VeljaOd" />', 'yyyy-mm-dd'), 
			<xsl:if test='xs:VeljaDo'>to_date('<xsl:value-of select="xs:VeljaDo" />', 'yyyy-mm-dd'),</xsl:if>
			'<xsl:value-of select="xs:SiSto" />', 
			0
			<xsl:if test='xs:NizkaCenaKolicnika'>,<xsl:value-of select="xs:NizkaCenaKolicnika" /></xsl:if>
			<xsl:if test='xs:VisokaCenaKolicnika'>,<xsl:value-of select="xs:VisokaCenaKolicnika" /></xsl:if>
			, xREPL001, xREPL002, 'F16ForChange',
			'<xsl:value-of select="xs:SifraSkuStoPla" />'
        ) ;
    </xsl:for-each>
  </xsl:template>

  <xsl:template match="xs:CeneStoritevTipaTOC">
    <xsl:for-each select="xs:Zapis">
      insert into inet.IMP_PR115CT0 ( IMP__115, 
        YEAR_115, 
        POSTN115, 
        DATPO115,  
        TEXT_115, 
        TYPE_115,
        DATO_115,
        DATD_115,
        ID___027,
        CODEV074,
        CODEP074,
        DATOD115,
		<xsl:if test='xs:VeljaDo'>DATDO115,</xsl:if>
        CODE_011,
        PRICE115,
        VREL_115,
        KOLIC115,
		IDIMP002, IDHED115, SSIF_F16,
		PLANG011
        ) 
        values ( inet.getsequence('IMP_PR115CT0'), 
            to_date('<xsl:value-of select="$v_LetoObjave" />-01-01', 'yyyy-mm-dd') , 
            <xsl:value-of select="$v_StevilkaPosiljke" />, 
            to_date('<xsl:value-of select="$v_DatumPosiljke" />', 'yyyy-mm-dd'), 
            '<xsl:value-of select="$v_KomVsebSprememb" />', 
            <xsl:value-of select="$v_VrstaCenika" />, 
            to_date('<xsl:value-of select="$v_VeljaOd" />', 'yyyy-mm-dd'), 
            <xsl:value-of select="$v_VeljaDo" />, 
			'TOC',
			'<xsl:value-of select="xs:SifraVrsZdrDej" />',
			'<xsl:value-of select="xs:SifraPodZdrDej" />',
            to_date('<xsl:value-of select="xs:VeljaOd" />', 'yyyy-mm-dd'), 
			<xsl:if test='xs:VeljaDo'>to_date('<xsl:value-of select="xs:VeljaDo" />', 'yyyy-mm-dd'),</xsl:if>
			'<xsl:value-of select="xs:SiSto" />', 
			<xsl:value-of select="xs:VrednostTocke" />, 0, 0,
			xREPL001, xREPL002, 'F16ForChange',
			'<xsl:value-of select="xs:SifraSkuStoPla" />'
        ) ;
    </xsl:for-each>
  </xsl:template>

  <xsl:template match="xs:CeneStoritevTipaUTE">
    <xsl:for-each select="xs:Zapis">
      insert into inet.IMP_PR115CT0 ( IMP__115, 
        YEAR_115, 
        POSTN115, 
        DATPO115,  
        TEXT_115, 
        TYPE_115,
        DATO_115,
        DATD_115,
        ID___027,
        CODEV074,
        CODEP074,
        DATOD115,
		<xsl:if test='xs:VeljaDo'>DATDO115,</xsl:if>
        CODE_011,
        PRICE115,
        VREL_115,
        KOLIC115,
		IDIMP002, IDHED115, SSIF_F16,
		PLANG011
        ) 
        values ( inet.getsequence('IMP_PR115CT0'), 
            to_date('<xsl:value-of select="$v_LetoObjave" />-01-01', 'yyyy-mm-dd') , 
            <xsl:value-of select="$v_StevilkaPosiljke" />, 
            to_date('<xsl:value-of select="$v_DatumPosiljke" />', 'yyyy-mm-dd'), 
            '<xsl:value-of select="$v_KomVsebSprememb" />', 
            <xsl:value-of select="$v_VrstaCenika" />, 
            to_date('<xsl:value-of select="$v_VeljaOd" />', 'yyyy-mm-dd'), 
            <xsl:value-of select="$v_VeljaDo" />, 
			'UTE',
			'<xsl:value-of select="xs:SifraVrsZdrDej" />',
			'<xsl:value-of select="xs:SifraPodZdrDej" />',
            to_date('<xsl:value-of select="xs:VeljaOd" />', 'yyyy-mm-dd'), 
			<xsl:if test='xs:VeljaDo'>to_date('<xsl:value-of select="xs:VeljaDo" />', 'yyyy-mm-dd'),</xsl:if>
			'<xsl:value-of select="xs:SiSto" />', 
			<xsl:value-of select="xs:VrednostUtezi" />, 0, 0, xREPL001, xREPL002, 'F16ForChange',
			'<xsl:value-of select="xs:SifraSkuStoPla" />' 
        ) ;
    </xsl:for-each>
  </xsl:template>

  <xsl:template match="xs:CeneStoritevTipaDAN">
    <xsl:for-each select="xs:Zapis">
      insert into inet.IMP_PR115CT0 ( IMP__115, 
        YEAR_115, 
        POSTN115, 
        DATPO115,  
        TEXT_115, 
        TYPE_115,
        DATO_115,
        DATD_115,
        ID___027,
        CODEV074,
        CODEP074,
        DATOD115,
		<xsl:if test='xs:VeljaDo'>DATDO115,</xsl:if>
        CODE_011,
        PRICE115,
        VREL_115,
        KOLIC115,
		IDIMP002, IDHED115, SSIF_F16
        ) 
        values ( inet.getsequence('IMP_PR115CT0'), 
            to_date('<xsl:value-of select="$v_LetoObjave" />-01-01', 'yyyy-mm-dd') , 
            <xsl:value-of select="$v_StevilkaPosiljke" />, 
            to_date('<xsl:value-of select="$v_DatumPosiljke" />', 'yyyy-mm-dd'), 
            '<xsl:value-of select="$v_KomVsebSprememb" />', 
            <xsl:value-of select="$v_VrstaCenika" />, 
            to_date('<xsl:value-of select="$v_VeljaOd" />', 'yyyy-mm-dd'), 
            <xsl:value-of select="$v_VeljaDo" />, 
			'DAN',
			'<xsl:value-of select="xs:SifraVrsZdrDej" />',
			'<xsl:value-of select="xs:SifraPodZdrDej" />',
            to_date('<xsl:value-of select="xs:VeljaOd" />', 'yyyy-mm-dd'), 
			<xsl:if test='xs:VeljaDo'>to_date('<xsl:value-of select="xs:VeljaDo" />', 'yyyy-mm-dd'),</xsl:if>
			'<xsl:value-of select="xs:SiSto" />', 
			<xsl:value-of select="xs:CenaZaDan" />, 0, 0,
			xREPL001, xREPL002, 'F16ForChange'
        ) ;
    </xsl:for-each>
  </xsl:template>

  <xsl:template match="xs:CeneStoritevTipaPRI">
    <xsl:for-each select="xs:Zapis">
      insert into inet.IMP_PR115CT0 ( IMP__115, 
        YEAR_115, 
        POSTN115, 
        DATPO115,  
        TEXT_115, 
        TYPE_115,
        DATO_115,
        DATD_115,
        ID___027,
        CODEV074,
        CODEP074,
        DATOD115,
		<xsl:if test='xs:VeljaDo'>DATDO115,</xsl:if>
        CODE_011,
        PRICE115,
        VREL_115,
        KOLIC115,
		IDIMP002, IDHED115, SSIF_F16
        ) 
        values ( inet.getsequence('IMP_PR115CT0'), 
            to_date('<xsl:value-of select="$v_LetoObjave" />-01-01', 'yyyy-mm-dd') , 
            <xsl:value-of select="$v_StevilkaPosiljke" />, 
            to_date('<xsl:value-of select="$v_DatumPosiljke" />', 'yyyy-mm-dd'), 
            '<xsl:value-of select="$v_KomVsebSprememb" />', 
            <xsl:value-of select="$v_VrstaCenika" />, 
            to_date('<xsl:value-of select="$v_VeljaOd" />', 'yyyy-mm-dd'), 
            <xsl:value-of select="$v_VeljaDo" />, 
			'PRI',
			'<xsl:value-of select="xs:SifraVrsZdrDej" />',
			'<xsl:value-of select="xs:SifraPodZdrDej" />',
            to_date('<xsl:value-of select="xs:VeljaOd" />', 'yyyy-mm-dd'), 
			<xsl:if test='xs:VeljaDo'>to_date('<xsl:value-of select="xs:VeljaDo" />', 'yyyy-mm-dd'),</xsl:if>
			'<xsl:value-of select="xs:SiSto" />', 
			<xsl:value-of select="xs:CenaZaPrimer" />, 0, 0,
            xREPL001, xREPL002, 'F16ForChange'			
        ) ;
    </xsl:for-each>
  </xsl:template>

  <xsl:template match="xs:CeneStoritevTipaLZM">
    <xsl:for-each select="xs:Zapis">
      insert into inet.IMP_PR115CT0 ( IMP__115, 
        YEAR_115, 
        POSTN115, 
        DATPO115,  
        TEXT_115, 
        TYPE_115,
        DATO_115,
        DATD_115,
        ID___027,
        CODEV074,
        CODEP074,
        DATOD115,
		<xsl:if test='xs:VeljaDo'>DATDO115,</xsl:if>
        CODE_011,
        PRICE115,
        VREL_115,
        KOLIC115,
		IDIMP002, IDHED115, SSIF_F16
        ) 
        values ( inet.getsequence('IMP_PR115CT0'), 
            to_date('<xsl:value-of select="$v_LetoObjave" />-01-01', 'yyyy-mm-dd') , 
            <xsl:value-of select="$v_StevilkaPosiljke" />, 
            to_date('<xsl:value-of select="$v_DatumPosiljke" />', 'yyyy-mm-dd'), 
            '<xsl:value-of select="$v_KomVsebSprememb" />', 
            <xsl:value-of select="$v_VrstaCenika" />, 
            to_date('<xsl:value-of select="$v_VeljaOd" />', 'yyyy-mm-dd'), 
            <xsl:value-of select="$v_VeljaDo" />, 
			'LZM',
			'<xsl:value-of select="xs:SifraVrsZdrDej" />',
			'<xsl:value-of select="xs:SifraPodZdrDej" />',
            to_date('<xsl:value-of select="xs:VeljaOd" />', 'yyyy-mm-dd'), 
			<xsl:if test='xs:VeljaDo'>to_date('<xsl:value-of select="xs:VeljaDo" />', 'yyyy-mm-dd'),</xsl:if>
			'<xsl:value-of select="xs:SiSto" />', 
			<xsl:value-of select="xs:CenaEnotoMere" />, 0, 0,
            xREPL001, xREPL002, 'F16ForChange'			
        ) ;
    </xsl:for-each>
  </xsl:template>
  
  <xsl:template match="xs:CeneStoritevTipaCMP">
    <xsl:for-each select="xs:Zapis">
      insert into inet.IMP_PR115CT0 ( IMP__115, 
        YEAR_115, 
        POSTN115, 
        DATPO115,  
        TEXT_115, 
        TYPE_115,
        DATO_115,
        DATD_115,
        ID___027,
        CODEV074,
        CODEP074,
        DATOD115,
		<xsl:if test='xs:VeljaDo'>DATDO115,</xsl:if>
        CODE_011,
        PRICE115,
        VREL_115,
        KOLIC115,
		IDIMP002, IDHED115, SSIF_F16
        ) 
        values ( inet.getsequence('IMP_PR115CT0'), 
            to_date('<xsl:value-of select="$v_LetoObjave" />-01-01', 'yyyy-mm-dd') , 
            <xsl:value-of select="$v_StevilkaPosiljke" />, 
            to_date('<xsl:value-of select="$v_DatumPosiljke" />', 'yyyy-mm-dd'), 
            '<xsl:value-of select="$v_KomVsebSprememb" />', 
            <xsl:value-of select="$v_VrstaCenika" />, 
            to_date('<xsl:value-of select="$v_VeljaOd" />', 'yyyy-mm-dd'), 
            <xsl:value-of select="$v_VeljaDo" />, 
			'CMP',
			'<xsl:value-of select="xs:SifraVrsZdrDej" />',
			'<xsl:value-of select="xs:SifraPodZdrDej" />',
            to_date('<xsl:value-of select="xs:VeljaOd" />', 'yyyy-mm-dd'), 
			<xsl:if test='xs:VeljaDo'>to_date('<xsl:value-of select="xs:VeljaDo" />', 'yyyy-mm-dd'),</xsl:if>
			'<xsl:value-of select="xs:SiSto" />', 
			<xsl:value-of select="xs:CenaStoritve" />, 0, 0,
            xREPL001, xREPL002, 'F16ForChange'			
        ) ;
    </xsl:for-each>
  </xsl:template>
  
  <xsl:template match="xs:CeneStoritevTipaPAV">
    <xsl:for-each select="xs:Zapis">
      insert into inet.IMP_PR115CT0 ( IMP__115, 
        YEAR_115, 
        POSTN115, 
        DATPO115,  
        TEXT_115, 
        TYPE_115,
        DATO_115,
        DATD_115,
        ID___027,
        CODEV074,
        CODEP074,
        DATOD115,
		<xsl:if test='xs:VeljaDo'>DATDO115,</xsl:if>
        CODE_011,
        PRICE115,
        VREL_115,
        KOLIC115,
		IDIMP002, IDHED115, SSIF_F16
        ) 
        values ( inet.getsequence('IMP_PR115CT0'), 
            to_date('<xsl:value-of select="$v_LetoObjave" />-01-01', 'yyyy-mm-dd') , 
            <xsl:value-of select="$v_StevilkaPosiljke" />, 
            to_date('<xsl:value-of select="$v_DatumPosiljke" />', 'yyyy-mm-dd'), 
            '<xsl:value-of select="$v_KomVsebSprememb" />', 
            <xsl:value-of select="$v_VrstaCenika" />, 
            to_date('<xsl:value-of select="$v_VeljaOd" />', 'yyyy-mm-dd'), 
            <xsl:value-of select="$v_VeljaDo" />, 
			'PAV',
			'<xsl:value-of select="xs:SifraVrsZdrDej" />',
			'<xsl:value-of select="xs:SifraPodZdrDej" />',
            to_date('<xsl:value-of select="xs:VeljaOd" />', 'yyyy-mm-dd'), 
			<xsl:if test='xs:VeljaDo'>to_date('<xsl:value-of select="xs:VeljaDo" />', 'yyyy-mm-dd'),</xsl:if>
			'<xsl:value-of select="xs:SiSto" />', 
			<xsl:value-of select="xs:CenaStoritve" />, 0, 0,
            xREPL001, xREPL002, 'F16ForChange'			
        ) ;
    </xsl:for-each>
  </xsl:template>
  
  <xsl:template match="xs:Izvajalec"/>
  <xsl:template match="xs:Prejemnik"/>
  <xsl:template match="xs:PodatkiOPosiljki"/>

 </xsl:stylesheet>