<?xml version="1.0" encoding="Windows-1250"?>
<!-- edited with XMLSpy v2011 sp1 (http://www.altova.com) by End User (free.org) -->
<!DOCTYPE xsl:stylesheet [
	<!ENTITY nbsp "&#160;">
]>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html" omit-xml-declaration="yes"/>
	<xsl:include href="InvDocBody.xsl"/>
	<xsl:include href="InvSpec.xsl"/>
	<xsl:include href="InvDocRules.xsl"/>
	<xsl:include href="InvDocHead.xsl"/>
	<xsl:include href="InvDocFoot.xsl"/>
	<xsl:include href="InvSpecComm.xsl"/>
	<xsl:include href="InvSpecBody.xsl"/>
	<xsl:include href="InvCountry.xsl"/>
	<!--	<xsl:variable name="HomeCurrency" select="((/Invoice/InvFooter/ServicePriceProperty/Currency = 'SIT') and (2007 > number(/Invoice/InvHeader/Document/ServiceYear))) or ((/Invoice/InvFooter/ServicePriceProperty/Currency = 'EUR') and (number(/Invoice/InvHeader/Document/ServiceYear) > 2006))"/>
	<xsl:variable name="HomeCurrency" select="(((/Invoice/InvFooter/ServicePriceProperty/Currency = 'SIT') and (2007 > number(/Invoice/InvHeader/Document/ServiceYear))) or ((/Invoice/InvFooter/ServicePriceProperty/Currency = 'EUR') and (number(/Invoice/InvHeader/Document/ServiceYear) > 2006)) or ((/Invoice/InvSpecs/Invoice/InvFooter/ServicePriceProperty/Currency = 'SIT') and (2007 > number(/Invoice/InvSpecs/Invoice/InvHeader/Document/ServiceYear))) or ((/Invoice/InvSpecs/Invoice/InvFooter/ServicePriceProperty/Currency = 'EUR') and (number(/Invoice/InvSpecs/Invoice/InvHeader/Document/ServiceYear) > 2006)))"/> -->
	<xsl:template match="Invoice">
		<html>
			<head>
				<!-- ML, 23.3.2007,Akt_99966: SB Celje - RAF oblika fakture -->
				<!--				
				<xsl:choose>
					<xsl:when test="contains(InvProperty/HeaderInformation,'LOGO=')">
						<img src="{substring-before(substring-after(InvProperty/HeaderInformation , 'LOGO=') , ';')}"/>
					</xsl:when>
				</xsl:choose> -->
				<style type="text/css">
					TABLE {
							font-family : "Verdana";
						     }
				       .pBreak {page-break-before : always} 
				</style>
			</head>
			<body>
				<xsl:choose>
					<xsl:when test="InvProperty/Language='SLO'">
						<xsl:call-template name="GetDocument">
							<xsl:with-param name="TxtFile">InvTxtSL.xml</xsl:with-param>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="InvProperty/Language='ANG'">
						<xsl:call-template name="GetDocument">
							<xsl:with-param name="TxtFile">InvTxtANG.xml</xsl:with-param>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="InvProperty/Language='NEM'">
						<!-- DEM -->
						<xsl:call-template name="GetDocument">
							<xsl:with-param name="TxtFile">InvTxtDEM.xml</xsl:with-param>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="InvProperty/Language='ITA'">
						<xsl:call-template name="GetDocument">
							<xsl:with-param name="TxtFile">InvTxtITL.xml</xsl:with-param>
						</xsl:call-template>
					</xsl:when>
					<!-- MKI -->
					<xsl:when test="InvProperty/Language='MKI'">
						<xsl:call-template name="GetMKIDocument">
							<xsl:with-param name="TxtFile">InvTxtMKI.xml</xsl:with-param>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="InvProperty/Language='SRL'">
						<xsl:call-template name="GetCountryDocument">
							<xsl:with-param name="TxtFile">InvTxtSRL.xml</xsl:with-param>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="InvSpecs">
						<xsl:call-template name="GetSeparateDocument"/>
					</xsl:when>
				</xsl:choose>
			</body>
		</html>
	</xsl:template>
	<!-- TUJINA - SRL -->
	<xsl:template name="GetCountryDocument">
		<xsl:param name="TxtFile"/>
		<xsl:variable name="Type" select="InvProperty/TypeName"/>
		<xsl:apply-templates select="InvHeader" mode="DocCountryHeader">
			<xsl:with-param name="Type" select="$Type"/>
			<xsl:with-param name="TxtFile" select="$TxtFile"/>
		</xsl:apply-templates>
		<xsl:apply-templates select="InvBody" mode="DocCountryHeaderBody">
			<xsl:with-param name="Type" select="$Type"/>
			<xsl:with-param name="TxtFile" select="$TxtFile"/>
		</xsl:apply-templates>
		<xsl:choose>
			<xsl:when test="InvBody/Activitys/Activity/Categorys/Category/UnderGroups/UnderGroup/Groups/Group/Services/Service">
				<xsl:apply-templates select="InvBody" mode="DocCountrySpecBody">
					<xsl:with-param name="Type" select="$Type"/>
					<xsl:with-param name="TxtFile" select="$TxtFile"/>
				</xsl:apply-templates>
				<xsl:apply-templates select="InvFooter" mode="DocCountrySpecFooter">
					<xsl:with-param name="Type" select="$Type"/>
					<xsl:with-param name="TxtFile" select="$TxtFile"/>
				</xsl:apply-templates>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates select="InvBody" mode="DocCountryBody">
					<xsl:with-param name="Type" select="$Type"/>
					<xsl:with-param name="TxtFile" select="$TxtFile"/>
				</xsl:apply-templates>
				<xsl:apply-templates select="InvFooter" mode="DocCountryFooter">
					<xsl:with-param name="Type" select="$Type"/>
					<xsl:with-param name="TxtFile" select="$TxtFile"/>
				</xsl:apply-templates>
				<!-- SG, 27.01.2008, Akt_101197  -->
				<xsl:if test="InvProperty/Receipt=1">
					<xsl:apply-templates select="InvHeader" mode="Receipt">
						<xsl:with-param name="Type" select="$Type"/>
						<xsl:with-param name="TxtFile" select="$TxtFile"/>
					</xsl:apply-templates>
				</xsl:if>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- TUJINA - MKI -->
	<xsl:template name="GetMKIDocument">
		<xsl:param name="TxtFile"/>
		<xsl:variable name="Type" select="InvProperty/TypeName"/>
		<xsl:choose>
			<!-- SPECIFIKACIJA I -->
			<xsl:when test="InvBody/Activitys/Activity/Categorys/Category/UnderGroups/UnderGroup/SpecPatients">
				<xsl:apply-templates select="InvHeader" mode="SpecHeader">
					<xsl:with-param name="Type" select="$Type"/>
					<xsl:with-param name="TxtFile" select="$TxtFile"/>
				</xsl:apply-templates>
				<xsl:apply-templates select="InvBody" mode="SpecBody">
					<xsl:with-param name="Type" select="$Type"/>
					<xsl:with-param name="TxtFile" select="$TxtFile"/>
				</xsl:apply-templates>
			</xsl:when>
			<!-- FAKTURA -->
			<xsl:otherwise>
				<!-- GLAVA -->
				<xsl:apply-templates select="InvHeader" mode="DocMKIHeader">
					<xsl:with-param name="Type" select="$Type"/>
					<xsl:with-param name="TxtFile" select="$TxtFile"/>
				</xsl:apply-templates>
				<!-- TRUP -->
				<xsl:apply-templates select="InvBody" mode="DocMKIBody">
					<xsl:with-param name="Type" select="$Type"/>
					<xsl:with-param name="TxtFile" select="$TxtFile"/>
				</xsl:apply-templates>
				<!-- NOGA -->
				<xsl:apply-templates select="InvFooter">
					<xsl:with-param name="Type" select="$Type"/>
					<xsl:with-param name="TxtFile" select="$TxtFile"/>
				</xsl:apply-templates>
				<!-- SG, 27.01.2008, Akt_101197  -->
				<xsl:if test="InvProperty/Receipt=1">
					<xsl:apply-templates select="InvHeader" mode="Receipt">
						<xsl:with-param name="Type" select="$Type"/>
						<xsl:with-param name="TxtFile" select="$TxtFile"/>
					</xsl:apply-templates>
				</xsl:if>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="GetDocument">
		<xsl:param name="TxtFile"/>
		<xsl:variable name="Type" select="InvProperty/TypeName"/>
		<xsl:choose>
			<!-- FAKTURA -->
			<xsl:when test="InvBody/Activitys/Activity/Categorys/Category/UnderGroups/UnderGroup/Groups">
				<!-- GLAVA -->
				<xsl:apply-templates select="InvHeader" mode="DocHeader">
					<xsl:with-param name="Type" select="$Type"/>
					<xsl:with-param name="TxtFile" select="$TxtFile"/>
				</xsl:apply-templates>
				<!-- TRUP -->
				<xsl:apply-templates select="InvBody" mode="Doc">
					<xsl:with-param name="Type" select="$Type"/>
					<xsl:with-param name="TxtFile" select="$TxtFile"/>
				</xsl:apply-templates>
				<!-- NOGA -->
				<xsl:apply-templates select="InvFooter">
					<xsl:with-param name="Type" select="$Type"/>
					<xsl:with-param name="TxtFile" select="$TxtFile"/>
				</xsl:apply-templates>
				<!-- SG, 27.01.2008, Akt_101197  -->
				<xsl:if test="InvProperty/Receipt=1">
					<xsl:apply-templates select="InvHeader" mode="Receipt">
						<xsl:with-param name="Type" select="$Type"/>
						<xsl:with-param name="TxtFile" select="$TxtFile"/>
					</xsl:apply-templates>
				</xsl:if>
			</xsl:when>
			<!-- SPECIFIKACIJA I -->
			<xsl:when test="InvBody/Activitys/Activity/Categorys/Category/UnderGroups/UnderGroup/SpecPatients">
				<!-- <xsl:choose>
				
					<xsl:when test="($Type='19')">
						 SPECIFIKACIJA ZA KONVENCIJO
						<xsl:apply-templates select="InvBody" mode="SpecKonvencija">
							<xsl:with-param name="Type" select="$Type"/>
							<xsl:with-param name="TxtFile" select="$TxtFile"/>
						</xsl:apply-templates>
					</xsl:when>
					<xsl:otherwise> -->
				<xsl:apply-templates select="InvHeader" mode="SpecHeader">
					<xsl:with-param name="Type" select="$Type"/>
					<xsl:with-param name="TxtFile" select="$TxtFile"/>
				</xsl:apply-templates>
				<xsl:apply-templates select="InvBody" mode="SpecBody">
					<xsl:with-param name="Type" select="$Type"/>
					<xsl:with-param name="TxtFile" select="$TxtFile"/>
				</xsl:apply-templates>
				<!-- 	</xsl:otherwise>
				</xsl:choose> -->
			</xsl:when>
			<!-- SPECIFIKACIJA II -->
			<xsl:when test="InvBody/Activitys/Activity/Categorys/Category/UnderGroups/UnderGroup/SpecOrderers">
				<xsl:apply-templates select="InvHeader" mode="SpecHeader">
					<xsl:with-param name="Type" select="$Type"/>
					<xsl:with-param name="TxtFile" select="$TxtFile"/>
				</xsl:apply-templates>
				<xsl:choose>
					<!-- 13.06.05 -->
					<xsl:when test="contains(InvProperty/BodyInformation,'ORDERERS')">
						<xsl:apply-templates select="InvBody" mode="SpecBody">
							<xsl:with-param name="Type" select="$Type"/>
							<xsl:with-param name="TxtFile" select="$TxtFile"/>
						</xsl:apply-templates>
					</xsl:when>
					<xsl:otherwise>
						<xsl:apply-templates select="InvBody" mode="SpecOrdererBody">
							<xsl:with-param name="Type" select="$Type"/>
							<xsl:with-param name="TxtFile" select="$TxtFile"/>
						</xsl:apply-templates>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<!-- RAUN ZA PODJETJE IN SAMOPLANIKE -->
			<xsl:when test="InvBody/Activitys/Activity/Categorys/Category/UnderGroups/UnderGroup/Services">
				<xsl:choose>
					<xsl:when test="(InvProperty/Language = 'SLO') or (InvProperty/Language = 'MKI')">
						<xsl:apply-templates select="InvHeader" mode="DocHeader">
							<xsl:with-param name="Type" select="$Type"/>
							<xsl:with-param name="TxtFile" select="$TxtFile"/>
						</xsl:apply-templates>
					</xsl:when>
					<xsl:otherwise>
						<xsl:apply-templates select="InvHeader" mode="DocAccountHeader">
							<xsl:with-param name="Type" select="$Type"/>
							<xsl:with-param name="TxtFile" select="$TxtFile"/>
						</xsl:apply-templates>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:choose>
					<xsl:when test="InvHeader/Document/Name = 'FZ'">
						<xsl:apply-templates select="InvBody" mode="BodyAccountFZ">
							<xsl:with-param name="Type" select="$Type"/>
							<xsl:with-param name="TxtFile" select="$TxtFile"/>
						</xsl:apply-templates>
					</xsl:when>
					<xsl:when test="($Type='33') or ($Type='34') or ($Type='38') or ($Type='04') or ($Type='11')">
						<xsl:apply-templates select="InvBody" mode="BodyAccount">
							<xsl:with-param name="Type" select="$Type"/>
							<xsl:with-param name="TxtFile" select="$TxtFile"/>
						</xsl:apply-templates>
					</xsl:when>
					<xsl:otherwise>
						<xsl:apply-templates select="InvBody" mode="SpecAccount">
							<xsl:with-param name="Type" select="$Type"/>
							<xsl:with-param name="TxtFile" select="$TxtFile"/>
						</xsl:apply-templates>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:apply-templates select="InvFooter">
					<xsl:with-param name="Type" select="$Type"/>
					<xsl:with-param name="TxtFile" select="$TxtFile"/>
				</xsl:apply-templates>
			</xsl:when>
			<!-- SKUPINSKA SPECIFIKACIJA -->
			<xsl:when test="InvSpecs">
				<xsl:call-template name="SpecCommon">
					<xsl:with-param name="Type" select="$Type"/>
					<xsl:with-param name="TxtFile" select="$TxtFile"/>
				</xsl:call-template>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="GetSeparateDocument">
		<xsl:for-each select="InvSpecs/Invoice">
			<xsl:choose>
				<xsl:when test="InvProperty/Language='SLO'">
					<xsl:call-template name="GetDocument">
						<xsl:with-param name="TxtFile">InvTxtSL.xml</xsl:with-param>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="InvProperty/Language='ANG'">
					<xsl:call-template name="GetDocument">
						<xsl:with-param name="TxtFile">InvTxtANG.xml</xsl:with-param>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="InvProperty/Language='NEM'">
					<!-- DEM -->
					<xsl:call-template name="GetDocument">
						<xsl:with-param name="TxtFile">InvTxtDEM.xml</xsl:with-param>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="InvProperty/Language='ITA'">
					<xsl:call-template name="GetDocument">
						<xsl:with-param name="TxtFile">InvTxtITL.xml</xsl:with-param>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="InvProperty/Language='MKI'">
					<xsl:call-template name="GetDocument">
						<xsl:with-param name="TxtFile">InvTxtMKI.xml</xsl:with-param>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="InvProperty/Language='SRL'">
					<xsl:call-template name="GetCountryDocument">
						<xsl:with-param name="TxtFile">InvTxtSRL.xml</xsl:with-param>
					</xsl:call-template>
				</xsl:when>
			</xsl:choose>
			<xsl:if test="position()!=last()">
				<br class="pBreak"/>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
</xsl:stylesheet>
