<?xml version="1.0" encoding="Windows-1250"?>
<!DOCTYPE xsl:stylesheet [
	<!ENTITY nbsp "&#160;">
]>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<!--TEST - -  RAUN ZA TRIGLAV -->
	<xsl:template match="InvBody" mode="BodyAccountX">
		<xsl:param name="Type"/>
		<xsl:param name="TxtFile"/>
		<table width="650" border="0" cellspacing="0" cellpadding="0" style="font-size: 10px;">
			<tr>
				<xsl:for-each select="../InvProperty/HeaderColumns/Column">
					<td>
						<b>
							<xsl:value-of select="Name"/>
						</b>
					</td>
				</xsl:for-each>
			</tr>
		</table>
	</xsl:template>
	<!-- ZAHTEVEK -->
	<xsl:template match="InvBody" mode="BodyAccountFZ">
		<xsl:param name="Type"/>
		<xsl:param name="TxtFile"/>
		<table width="650" border="0" cellspacing="0" cellpadding="0" style="font-size: 10px;">
			<tr>
				<td colspan="3">&nbsp;</td>
			</tr>
			<tr>
				<td colspan="3">&nbsp;</td>
			</tr>
			<tr>
				<td colspan="3">
					<hr size="0"/>
				</td>
			</tr>
			<tr>
				<td colspan="3">&nbsp;</td>
			</tr>
			<tr>
				<td colspan="2">
					<b>
						<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BF6_2_2"/>
					</b>
				</td>
				<td align="right">
					<xsl:call-template name="FormatNumberWithNull">
						<xsl:with-param name="Number" select="(../InvFooter/ServicePriceProperty/ServicePrice)"/>
					</xsl:call-template>
				</td>
			</tr>
			<tr>
				<td colspan="3">&nbsp;</td>
			</tr>
			<tr>
				<td colspan="3">
					<hr size="0"/>
				</td>
			</tr>
			<tr>
				<td colspan="3">&nbsp;</td>
			</tr>
			<tr>
				<td colspan="3">&nbsp;</td>
			</tr>
			<!-- davek-->
			<xsl:choose>
				<xsl:when test="../InvFooter/ServicePriceProperty/TaxList">
					<xsl:for-each select="../InvFooter/ServicePriceProperty/TaxList/Tax">
						<tr>
							<td>
								<xsl:call-template name="TaxText">
									<xsl:with-param name="TxtFile" select="$TxtFile"/>
									<xsl:with-param name="Level" select="DDVLevel"/>
									<xsl:with-param name="Percent" select="DDVPercent"/>
									<xsl:with-param name="Currency" select="../../Currency"/>
								</xsl:call-template>
							</td>
							<td align="right">
								<xsl:call-template name="FormatNumberWithNull">
									<xsl:with-param name="Number" select="DDVBase"/>
								</xsl:call-template>
							</td>
							<td align="right">
								<xsl:call-template name="FormatNumberWithNull">
									<xsl:with-param name="Number" select="DDVAmount"/>
								</xsl:call-template>
							</td>
						</tr>
					</xsl:for-each>
				</xsl:when>
				<xsl:otherwise>
					<tr>
						<!-- - ZNIANA STOPNJA 8.50% V SIT -->
						<td>
							<xsl:choose>
								<xsl:when test="../InvFooter/ServicePriceProperty/Level01/DDVPercent">
									<xsl:value-of select="format-number(../InvFooter/ServicePriceProperty/Level01/DDVPercent, '#0,#', 'european')"/>%
						</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="format-number(../InvFooter/ServicePriceProperty/Level01/DDVLevel, '#0,#', 'european')"/>
								</xsl:otherwise>
							</xsl:choose>				
						&nbsp;-&nbsp;
						<xsl:choose>
								<xsl:when test="(../InvFooter/ServicePriceProperty/Currency = 'EUR')">
									<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BF3_2_1"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BF3_1_1"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td align="right">
							<xsl:call-template name="FormatNumberWithNull">
								<xsl:with-param name="Number" select="../InvFooter/ServicePriceProperty/Level01/DDVBase"/>
							</xsl:call-template>
						</td>
						<td align="right">
							<xsl:call-template name="FormatNumberWithNull">
								<xsl:with-param name="Number" select="../InvFooter/ServicePriceProperty/Level01/DDVAmount"/>
							</xsl:call-template>
						</td>
					</tr>
					<tr>
						<!-- - SPLONA STOPNJA 20.00% V SIT -->
						<td>
							<xsl:choose>
								<xsl:when test="../InvFooter/ServicePriceProperty/Level02/DDVPercent">
									<xsl:value-of select="format-number(../InvFooter/ServicePriceProperty/Level02/DDVPercent, '#0,#', 'european')"/>%
						</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="format-number(../InvFooter/ServicePriceProperty/Level02/DDVLevel, '#0,#', 'european')"/>
								</xsl:otherwise>
							</xsl:choose>				
						&nbsp;-&nbsp;	
						<xsl:choose>
								<xsl:when test="(../InvFooter/ServicePriceProperty/Currency = 'EUR')">
									<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BF4_2_1"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BF4_1_1"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td align="right">
							<xsl:call-template name="FormatNumberWithNull">
								<xsl:with-param name="Number" select="../InvFooter/ServicePriceProperty/Level02/DDVBase"/>
							</xsl:call-template>
						</td>
						<td align="right">
							<xsl:call-template name="FormatNumberWithNull">
								<xsl:with-param name="Number" select="../InvFooter/ServicePriceProperty/Level02/DDVAmount"/>
							</xsl:call-template>
						</td>
					</tr>
					<tr>
						<!-- - OPROENO 0% V SIT -->
						<td>
							<xsl:choose>
								<xsl:when test="../InvFooter/ServicePriceProperty/Level99/DDVPercent">
									<xsl:value-of select="format-number(../InvFooter/ServicePriceProperty/Level99/DDVPercent, '#0,#', 'european')"/>%
						</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="format-number(../InvFooter/ServicePriceProperty/Level99/DDVLevel, '#0,#', 'european')"/>
								</xsl:otherwise>
							</xsl:choose>				
						&nbsp;-&nbsp;	
						<xsl:choose>
								<xsl:when test="(../InvFooter/ServicePriceProperty/Currency = 'EUR')">
									<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BF4_3_2"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BF4_3_1"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td align="right">
							<xsl:call-template name="FormatNumberWithNull">
								<xsl:with-param name="Number" select="../InvFooter/ServicePriceProperty/Level99/DDVBase"/>
							</xsl:call-template>
						</td>
						<td align="right">
							<xsl:call-template name="FormatNumberWithNull">
								<xsl:with-param name="Number" select="../InvFooter/ServicePriceProperty/Level99/DDVAmount"/>
							</xsl:call-template>
						</td>
					</tr>
				</xsl:otherwise>
			</xsl:choose>
			<tr>
				<td>&nbsp;</td>
				<td colspan="2">
					<hr size="0"/>
				</td>
			</tr>
			<tr>
				<td colspan="3">&nbsp;</td>
			</tr>
			<tr>
				<td colspan="3">&nbsp;</td>
			</tr>
			<tr>
				<td colspan="2">
					<b>
						<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BF6_2_1"/>
					</b>
				</td>
				<td align="right">
					<xsl:call-template name="FormatNumberWithNull">
						<xsl:with-param name="Number" select="(../InvFooter/PayPrice)"/>
					</xsl:call-template>
				</td>
			</tr>
			<tr>
				<td colspan="3">&nbsp;</td>
			</tr>
			<tr>
				<td colspan="3">&nbsp;</td>
			</tr>
		</table>
	</xsl:template>
	<!-- RAUN ZA TRIGLAV -->
	<xsl:template match="InvBody" mode="BodyAccount">
		<xsl:param name="Type"/>
		<xsl:param name="TxtFile"/>
		<xsl:variable name="HomeCurrency" select="((../InvFooter/ServicePriceProperty/Currency = 'SIT') and (2007 > number(../InvHeader/Document/ServiceYear))) or ((../InvFooter/ServicePriceProperty/Currency = 'EUR') and (number(../InvHeader/Document/ServiceYear) > 2006))"/>
		<table width="650" border="0" cellspacing="0" cellpadding="0" style="font-size: 10px;">
			<tr>
				<td colspan="9">&nbsp;</td>
			</tr>
			<tr>
				<xsl:if test="not(../InvFooter/SubjectOfContract = '')">
					<td colspan="9">
						<!-- <b>Predmet pogodbe: </b> -->
						<b>
							<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BH1_1_1"/>&nbsp;
						</b>
						<xsl:value-of select="../InvFooter/SubjectOfContract"/>
					</td>
				</xsl:if>
			</tr>
			<tr>
				<td colspan="9">
					<hr size="0"/>
				</td>
			</tr>
			<tr>
				<td colspan="9">&nbsp;</td>
			</tr>
			<tr>
				<td>
					<!-- ifra in naziv storitve  -->
					<b>
						<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BH2_1_1"/>
					</b>
				</td>
				<td align="right">
					<!-- koli -->
					<xsl:choose>
						<xsl:when test="($Type='38')">
							<b>
								<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BH2_2_2"/>
							</b>
						</xsl:when>
						<xsl:otherwise>
							<b>
								<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BH2_2_1"/>
							</b>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td align="right">
					<!-- tok / EM-->
					<xsl:choose>
						<xsl:when test="($Type='38')"/>
						<xsl:otherwise>
							<b>
								<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BH2_3_2"/>
							</b>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td align="right">
					<!-- cena / cena SIT -->
					<xsl:choose>
						<xsl:when test="($Type='38')">
							<b>
								<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BH2_5_3"/>
							</b>
						</xsl:when>
						<xsl:otherwise>
							<b>
								<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BH2_5_4"/>
								<xsl:value-of select="../InvFooter/ServicePriceProperty/Currency"/>
							</b>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td align="right">
					<xsl:if test="not($HomeCurrency)">
						<!-- val -->
						<b>
							<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BH2_6_1"/>
						</b>
					</xsl:if>
				</td>
				<td align="right">
					<!-- vrednost storitve / % PZZ -->
					<xsl:choose>
						<xsl:when test="($Type='38')">
							<b>
								<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BH2_7_4"/>
							</b>
						</xsl:when>
						<xsl:otherwise>
							<b>
								<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BH2_7_2"/>
							</b>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td align="right">
					<!-- znesek za plailo / vrednost SIT -->
					<xsl:choose>
						<xsl:when test="($Type='38')">
							<b>
								<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BH2_8_4"/>
							</b>
						</xsl:when>
						<xsl:otherwise>
							<b>
								<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BH2_8_5"/>
								<xsl:value-of select="../InvFooter/ServicePriceProperty/Currency"/>
							</b>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td align="right">
					<xsl:if test="not(../InvFooter/Discount = '0.00000') and not(contains(../InvProperty/BodyInformation,'NIPOP'))">
						<!-- pop -->
						<b>
							<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BH2_4_1"/>
						</b>
					</xsl:if>
				</td>
				<td align="right">
					<!-- DDV  -->
					<b>
						<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BH2_9_1"/>
					</b>
				</td>
			</tr>
			<xsl:choose>
				<xsl:when test="($Type='38')">
					<tr>
						<td>
							<!-- ifra in naziv storitve  -->
						</td>
						<td align="right">
							<!-- koli -->
						</td>
						<td align="right">
							<!-- tok / EM-->
						</td>
						<td align="right">
							<!-- cena / cena SIT -->
							<xsl:choose>
								<xsl:when test="($Type='38')">
									<b>
										<xsl:value-of select="../InvFooter/ServicePriceProperty/Currency"/>
									</b>
								</xsl:when>
								<xsl:otherwise/>
							</xsl:choose>
						</td>
						<td align="right">
							<xsl:if test="not(../InvFooter/ServicePriceProperty/Currency = 'SIT')">
								<!-- val -->
							</xsl:if>
						</td>
						<td align="right">
							<!-- vrednost storitve / % PZZ -->
							<xsl:choose>
								<xsl:when test="($Type='38')">
									<b>
										<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BH2_7_5"/>
									</b>
								</xsl:when>
								<xsl:otherwise/>
							</xsl:choose>
						</td>
						<td align="right">
							<!-- znesek za plailo / vrednost SIT -->
							<xsl:choose>
								<xsl:when test="($Type='38')">
									<b>
										<xsl:value-of select="../InvFooter/ServicePriceProperty/Currency"/>
									</b>
								</xsl:when>
								<xsl:otherwise/>
							</xsl:choose>
						</td>
						<td align="right">
							<xsl:if test="not(../InvFooter/Discount = '0.00000') and not(contains(../InvProperty/BodyInformation,'NIPOP'))">
								<!-- pop -->
							</xsl:if>
						</td>
						<td align="right">
							<!-- DDV  -->
						</td>
					</tr>
				</xsl:when>
				<xsl:otherwise/>
			</xsl:choose>
			<tr>
				<td colspan="9">&nbsp;</td>
			</tr>
			<tr>
				<td colspan="9">
					<hr size="0"/>
				</td>
			</tr>
			<tr>
				<td colspan="9">&nbsp;</td>
			</tr>
			<xsl:for-each select="Activitys/Activity/Categorys/Category/UnderGroups/UnderGroup/Services/Service">
				<xsl:sort/>
				<tr>
					<td>
						<xsl:value-of select="Service/ID"/>&nbsp;&nbsp;
										<xsl:value-of select="Service/Name"/>
					</td>
					<td align="right">
						<xsl:choose>
							<xsl:when test="(UnitValue/Value) = 0.00000">
								<xsl:call-template name="FormatNumberWithNull">
									<xsl:with-param name="Number" select="(NumberOfCase/Number)"/>
								</xsl:call-template>
							</xsl:when>
							<xsl:otherwise>
								<xsl:call-template name="FormatNumberWithNull">
									<xsl:with-param name="Number" select="(UnitValue/Value)"/>
								</xsl:call-template>
							</xsl:otherwise>
						</xsl:choose>
					</td>
					<td align="right">
						<xsl:choose>
							<xsl:when test="($Type='38')"/>
							<xsl:otherwise>
								<xsl:value-of select="ServicePriceProperty/EM"/>
							</xsl:otherwise>
						</xsl:choose>
					</td>
					<td align="right">
						<xsl:call-template name="FormatNumberWithNull">
							<xsl:with-param name="Number" select="CoeficientValue"/>
						</xsl:call-template>
					</td>
					<td align="right">
						<xsl:if test="not($HomeCurrency)">
							<xsl:value-of select="ServicePriceProperty/Currency"/>
						</xsl:if>
					</td>
					<td align="right">
						<xsl:value-of select="format-number(PercentPZZ, '###.##0', 'european')"/>
					</td>
					<td align="right">
						<xsl:call-template name="FormatNumberWithNull">
							<xsl:with-param name="Number" select="ServicePriceProperty/AdditionalPrice"/>
						</xsl:call-template>
					</td>
					<td align="right">
						<xsl:if test="not(../../../../../../../../../InvFooter/Discount = '0.00000') and not(contains(../../../../../../../../../InvProperty/BodyInformation,'NIPOP'))">
							<xsl:value-of select="format-number(Discount, '##,##', 'european')"/>
							<xsl:if test="not(Discount='0.00000')">%</xsl:if>
						</xsl:if>
					</td>
					<td align="right">
						<xsl:choose>
							<xsl:when test="ServicePriceProperty/DDVPercent">
								<xsl:value-of select="format-number(ServicePriceProperty/DDVPercent, '#0,#', 'european')"/>%
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="format-number(ServicePriceProperty/DDVLevel, '#0,#', 'european')"/>
							</xsl:otherwise>
						</xsl:choose>
					</td>
				</tr>
			</xsl:for-each>
			<tr>
				<td colspan="9">&nbsp;</td>
			</tr>
			<tr>
				<td colspan="9">
					<hr size="0"/>
				</td>
			</tr>
			<tr>
				<td colspan="2">
					<b>
						<!-- SKUPAJ: -->
						<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BF1_1_1"/>
					</b>
				</td>
				<td colspan="4"/>
				<td align="right">
					<xsl:choose>
						<xsl:when test="$HomeCurrency">
							<xsl:call-template name="FormatNumberWithNull">
								<xsl:with-param name="Number" select="../InvFooter/ServicePriceProperty/ServicePrice"/>
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="FormatNumberWithNull">
								<xsl:with-param name="Number" select="../InvFooter/ServicePriceProperty/ServicePriceInCurrency"/>
							</xsl:call-template>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td align="left">
					&nbsp;<xsl:value-of select="../InvFooter/ServicePriceProperty/Currency"/>
				</td>
				<td/>
			</tr>
			<tr>
				<td colspan="9">&nbsp;</td>
			</tr>
			<xsl:if test="not(../InvFooter/Discount = '0.00000')">
				<tr>
					<td colspan="6">
						<b>
							<!-- Popust v znesku: -->
							<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BF2_1_1"/>
						</b>
					</td>
					<td align="right">
						<xsl:call-template name="FormatNumberWithNull">
							<xsl:with-param name="Number" select="../InvFooter/Discount"/>
						</xsl:call-template>
					</td>
					<td align="left">&nbsp;</td>
					<td/>
				</tr>
			</xsl:if>
			<xsl:if test="not(../InvFooter/DiscountWithContract = '0.00000')">
				<tr>
					<td colspan="4">
						<b>
							<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BF2_2_1"/>
						</b>
					</td>
					<td colspan="2">
						<xsl:call-template name="FormatNumber">
							<xsl:with-param name="Number" select="../InvFooter/DiscountWithContractInPercent"/>
						</xsl:call-template>&nbsp;%			
					</td>
					<td align="right">
						<xsl:call-template name="FormatNumberWithNull">
							<xsl:with-param name="Number" select="../InvFooter/DiscountWithContract"/>
						</xsl:call-template>
					</td>
					<td align="left">&nbsp;-</td>
					<td/>
				</tr>
			</xsl:if>
			<tr>
				<td colspan="9">&nbsp;</td>
			</tr>
			<xsl:choose>
				<xsl:when test="../InvFooter/ServicePriceProperty/TaxList">
					<xsl:for-each select="../InvFooter/ServicePriceProperty/TaxList/Tax">
						<tr>
							<td colspan="3">
								<xsl:call-template name="TaxText">
									<xsl:with-param name="TxtFile" select="$TxtFile"/>
									<xsl:with-param name="Level" select="DDVLevel"/>
									<xsl:with-param name="Percent" select="DDVPercent"/>
									<xsl:with-param name="Currency" select="../../Currency"/>
								</xsl:call-template>
							</td>
							<td align="right">
								<xsl:call-template name="FormatNumberWithNull">
									<xsl:with-param name="Number" select="DDVBase"/>
								</xsl:call-template>
							</td>
							<td colspan="2"/>
							<td align="right">
								<xsl:call-template name="FormatNumberWithNull">
									<xsl:with-param name="Number" select="DDVAmount"/>
								</xsl:call-template>
							</td>
							<td colspan="2"/>
						</tr>
					</xsl:for-each>
				</xsl:when>
				<xsl:otherwise>
					<tr>
						<!-- - ZNIANA STOPNJA 8.50% V SIT -->
						<td colspan="3">
							<xsl:choose>
								<xsl:when test="../InvFooter/ServicePriceProperty/Level01/DDVPercent">
									<xsl:value-of select="format-number(../InvFooter/ServicePriceProperty/Level01/DDVPercent, '#0,#', 'european')"/>%
						</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="format-number(../InvFooter/ServicePriceProperty/Level01/DDVLevel, '#0,#', 'european')"/>
								</xsl:otherwise>
							</xsl:choose>							
					&nbsp;-&nbsp;
					<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BF3_1_2"/>
							<xsl:value-of select="../InvFooter/ServicePriceProperty/Currency"/>
						</td>
						<td align="right">
							<xsl:call-template name="FormatNumberWithNull">
								<xsl:with-param name="Number" select="../InvFooter/ServicePriceProperty/Level01/DDVBase"/>
							</xsl:call-template>
						</td>
						<td colspan="2"/>
						<td align="right">
							<xsl:call-template name="FormatNumberWithNull">
								<xsl:with-param name="Number" select="../InvFooter/ServicePriceProperty/Level01/DDVAmount"/>
							</xsl:call-template>
						</td>
						<td colspan="2"/>
					</tr>
					<xsl:if test="not($HomeCurrency)">
						<tr>
							<!--  - ZNIANA STOPNJA 8.50% V VALUTI -->
							<td colspan="3">
								<xsl:choose>
									<xsl:when test="../InvFooter/ServicePriceProperty/LevelC01/DDVPercent">
										<xsl:value-of select="format-number(../InvFooter/ServicePriceProperty/LevelC01/DDVPercent, '#0,#', 'european')"/>%
							</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="format-number(../InvFooter/ServicePriceProperty/LevelC01/DDVLevel, '#0,#', 'european')"/>
									</xsl:otherwise>
								</xsl:choose>					
							&nbsp;-&nbsp;
							<xsl:choose>
									<xsl:when test="(../InvFooter/ServicePriceProperty/Currency = 'EUR')">
										<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BF3_1_1"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BF3_2_1"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
							<td align="right">
								<xsl:call-template name="FormatNumberWithNull">
									<xsl:with-param name="Number" select="../InvFooter/ServicePriceProperty/LevelC01/DDVBase"/>
								</xsl:call-template>
							</td>
							<td colspan="2"/>
							<td align="right">
								<xsl:call-template name="FormatNumberWithNull">
									<xsl:with-param name="Number" select="../InvFooter/ServicePriceProperty/LevelC01/DDVAmount"/>
								</xsl:call-template>
							</td>
							<td colspan="2"/>
						</tr>
					</xsl:if>
					<tr>
						<!-- - SPLONA STOPNJA 20.00% V SIT -->
						<td colspan="3">
							<xsl:choose>
								<xsl:when test="../InvFooter/ServicePriceProperty/Level02/DDVPercent">
									<xsl:value-of select="format-number(../InvFooter/ServicePriceProperty/Level02/DDVPercent, '#0,#', 'european')"/>%
						</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="format-number(../InvFooter/ServicePriceProperty/Level02/DDVLevel, '#0,#', 'european')"/>
								</xsl:otherwise>
							</xsl:choose>				
					&nbsp;-&nbsp;
					<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BF4_1_2"/>
							<xsl:value-of select="../InvFooter/ServicePriceProperty/Currency"/>
						</td>
						<td align="right">
							<xsl:call-template name="FormatNumberWithNull">
								<xsl:with-param name="Number" select="../InvFooter/ServicePriceProperty/Level02/DDVBase"/>
							</xsl:call-template>
						</td>
						<td colspan="2"/>
						<td align="right">
							<xsl:call-template name="FormatNumberWithNull">
								<xsl:with-param name="Number" select="../InvFooter/ServicePriceProperty/Level02/DDVAmount"/>
							</xsl:call-template>
						</td>
						<td colspan="2"/>
					</tr>
					<xsl:if test="not($HomeCurrency)">
						<tr>
							<!-- - SPLONA STOPNJA 20.00% V VALUTI -->
							<td colspan="3">
								<xsl:choose>
									<xsl:when test="../InvFooter/ServicePriceProperty/LevelC02/DDVPercent">
										<xsl:value-of select="format-number(../InvFooter/ServicePriceProperty/LevelC02/DDVPercent, '#0,#', 'european')"/>%
							</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="format-number(../InvFooter/ServicePriceProperty/LevelC02/DDVLevel, '#0,#', 'european')"/>
									</xsl:otherwise>
								</xsl:choose>
							&nbsp;-&nbsp;
							<xsl:choose>
									<xsl:when test="(../InvFooter/ServicePriceProperty/Currency = 'EUR')">
										<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BF4_1_1"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BF4_2_1"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
							<td align="right">
								<xsl:call-template name="FormatNumberWithNull">
									<xsl:with-param name="Number" select="../InvFooter/ServicePriceProperty/LevelC02/DDVBase"/>
								</xsl:call-template>
							</td>
							<td colspan="2"/>
							<td align="right">
								<xsl:call-template name="FormatNumberWithNull">
									<xsl:with-param name="Number" select="../InvFooter/ServicePriceProperty/LevelC02/DDVAmount"/>
								</xsl:call-template>
							</td>
							<td colspan="2"/>
						</tr>
					</xsl:if>
					<tr>
						<!-- - OPROENO 0% V SIT -->
						<td colspan="3">
							<xsl:choose>
								<xsl:when test="../InvFooter/ServicePriceProperty/Level99/DDVPercent">
									<xsl:value-of select="format-number(../InvFooter/ServicePriceProperty/Level99/DDVPercent, '#0,#', 'european')"/>%
						</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="format-number(../InvFooter/ServicePriceProperty/Level99/DDVLevel, '#0,#', 'european')"/>
								</xsl:otherwise>
							</xsl:choose>
					&nbsp;-&nbsp;
					<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BF4_3_3"/>
							<xsl:value-of select="../InvFooter/ServicePriceProperty/Currency"/>
						</td>
						<td align="right">
							<xsl:call-template name="FormatNumberWithNull">
								<xsl:with-param name="Number" select="../InvFooter/ServicePriceProperty/Level99/DDVBase"/>
							</xsl:call-template>
						</td>
						<td colspan="2"/>
						<td align="right">
							<xsl:call-template name="FormatNumberWithNull">
								<xsl:with-param name="Number" select="../InvFooter/ServicePriceProperty/Level99/DDVAmount"/>
							</xsl:call-template>
						</td>
						<td colspan="2"/>
					</tr>
					<xsl:if test="not($HomeCurrency)">
						<tr>
							<!-- - OPROENO 0% V VALUTI -->
							<td colspan="3">
								<xsl:choose>
									<xsl:when test="../InvFooter/ServicePriceProperty/LevelC99/DDVPercent">
										<xsl:value-of select="format-number(../InvFooter/ServicePriceProperty/LevelC99/DDVPercent, '#0,#', 'european')"/>%
							</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="format-number(../InvFooter/ServicePriceProperty/LevelC99/DDVLevel, '#0,#', 'european')"/>
									</xsl:otherwise>
								</xsl:choose>
						&nbsp;-&nbsp;
						<xsl:choose>
									<xsl:when test="(../InvFooter/ServicePriceProperty/Currency = 'EUR')">
										<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BF4_3_1"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BF4_3_2"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
							<td align="right">
								<xsl:call-template name="FormatNumberWithNull">
									<xsl:with-param name="Number" select="../InvFooter/ServicePriceProperty/LevelC99/DDVBase"/>
								</xsl:call-template>
							</td>
							<td colspan="2"/>
							<td align="right">
								<xsl:call-template name="FormatNumberWithNull">
									<xsl:with-param name="Number" select="../InvFooter/ServicePriceProperty/LevelC99/DDVAmount"/>
								</xsl:call-template>
							</td>
							<td colspan="2"/>
						</tr>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
			<tr>
				<td colspan="6">&nbsp;</td>
				<td>
					<hr size="0"/>
				</td>
				<td colspan="2"/>
			</tr>
			<xsl:if test="(../InvProperty/Language = 'SLO')">
				<tr>
					<td colspan="6">
						<b>
							<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BF6_2_1"/>
						</b>
					</td>
					<td align="right">
						<xsl:call-template name="FormatNumberWithNull">
							<xsl:with-param name="Number" select="(../InvFooter/PayPrice)"/>
						</xsl:call-template>
					</td>
					<td colspan="2"/>
				</tr>
				<tr>
					<td colspan="9">&nbsp;</td>
				</tr>
			</xsl:if>
			<!-- Raun s provizijo za zahtevek-->
			<xsl:if test="../InvFooter/Commission/InvoiceName">
				<tr>
					<td colspan="6">
						<b>
							<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BF7_1_1"/>&nbsp;
						</b>
						<xsl:value-of select="../InvFooter/Commission/InvoiceName"/>
					</td>
					<td align="right">
						<xsl:call-template name="FormatNumberWithNull">
							<xsl:with-param name="Number" select="(../InvFooter/Commission/Amount)"/>
						</xsl:call-template>
					</td>
					<td colspan="2"/>
				</tr>
				<tr>
					<td colspan="9">&nbsp;</td>
				</tr>
			</xsl:if>
			<xsl:if test="not($HomeCurrency)">
				<tr>
					<td colspan="6">
						<b>
							<!-- ZA PLAILO V VALUTI -->
							<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BF5_1_1"/>
						</b>
					</td>
					<td align="right">
						<xsl:call-template name="FormatNumberWithNull">
							<xsl:with-param name="Number" select="(../InvFooter/PayPriceC)"/>
						</xsl:call-template>
					</td>
					<td colspan="2"/>
				</tr>
				<tr>
					<td colspan="9">&nbsp;</td>
				</tr>
			</xsl:if>
			<xsl:if test="(../InvProperty/Language = 'SLO')">
				<tr>
					<td colspan="6">
						<b>
							<xsl:choose>
								<xsl:when test="contains(../InvFooter/PayPrice,'-')">
									<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BF5_2_2"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BF5_2_1"/>
								</xsl:otherwise>
							</xsl:choose>
							<xsl:value-of select="../InvFooter/ServicePriceProperty/Currency"/>
						</b>
					</td>
					<td align="right">
						<xsl:call-template name="FormatNumberWithNull">
							<xsl:with-param name="Number" select="(../InvFooter/PayPrice)"/>
						</xsl:call-template>
					</td>
					<td colspan="2"/>
				</tr>
			</xsl:if>
			<!-- specifikacija zneskov splone stopnje -->
			<xsl:variable name="ddvLevel" select="../InvFooter/ServicePriceProperty/Commission/Commission/DDVLevel"/>
			<xsl:variable name="ddvPercent" select="../InvFooter/ServicePriceProperty/Commission/Commission/DDVPercent"/>
			<xsl:if test="((../InvFooter/ServicePriceProperty/Commission) and (($ddvLevel = 2) or ($ddvLevel = 1)))">
				<tr>
					<td colspan="9">&nbsp;</td>
				</tr>
				<tr>
					<td colspan="9">&nbsp;</td>
				</tr>
				<tr>
					<td colspan="9">&nbsp;</td>
				</tr>
				<tr>
					<td colspan="9">
						<b>
							<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BF8_1_1"/>
						</b>
					</td>
				</tr>
				<tr>
					<td colspan="9">&nbsp;</td>
				</tr>
				<tr>
					<!-- STORITVE -->
					<td colspan="3">
						<xsl:choose>
							<xsl:when test="../InvFooter/ServicePriceProperty/Commission/Service/DDVPercent">
								<xsl:value-of select="format-number(../InvFooter/ServicePriceProperty/Commission/Service/DDVPercent, '#0,#', 'european')"/>%
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="format-number(../InvFooter/ServicePriceProperty/Commission/Service/DDVLevel, '#0,#', 'european')"/>
							</xsl:otherwise>
						</xsl:choose>					
						&nbsp;-&nbsp;
						<xsl:choose>
							<xsl:when test="(../InvFooter/ServicePriceProperty/Commission/Service/DDVLevel = 2)">
								<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BF8_2_1"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BF8_2_2"/>
							</xsl:otherwise>
						</xsl:choose>
					</td>
					<td align="right">
						<xsl:call-template name="FormatNumberWithNull">
							<xsl:with-param name="Number" select="../InvFooter/ServicePriceProperty/Commission/Service/DDVBase"/>
						</xsl:call-template>
					</td>
					<td colspan="2"/>
					<td align="right">
						<xsl:call-template name="FormatNumberWithNull">
							<xsl:with-param name="Number" select="../InvFooter/ServicePriceProperty/Commission/Service/DDVAmount"/>
						</xsl:call-template>
					</td>
					<td colspan="2"/>
				</tr>
				<tr>
					<!-- PROVIZIJA -->
					<td colspan="3">
						<xsl:choose>
							<xsl:when test="$ddvPercent">
								<xsl:value-of select="format-number($ddvPercent, '#0,#', 'european')"/>%
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="format-number($ddvLevel, '#0,#', 'european')"/>
							</xsl:otherwise>
						</xsl:choose>					
						&nbsp;-&nbsp;
						<xsl:choose>
							<xsl:when test="($ddvLevel = 2)">
								<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BF8_1_2"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BF8_1_3"/>
							</xsl:otherwise>
						</xsl:choose>
					</td>
					<td align="right">
						<xsl:call-template name="FormatNumberWithNull">
							<xsl:with-param name="Number" select="../InvFooter/ServicePriceProperty/Commission/Commission/DDVBase"/>
						</xsl:call-template>
					</td>
					<td colspan="2"/>
					<td align="right">
						<xsl:call-template name="FormatNumberWithNull">
							<xsl:with-param name="Number" select="../InvFooter/ServicePriceProperty/Commission/Commission/DDVAmount"/>
						</xsl:call-template>
					</td>
					<td colspan="2"/>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>
</xsl:stylesheet>
