<?xml version="1.0" encoding="Windows-1250"?>
<!-- edited with XMLSPY v5 rel. 2 U (http://www.xmlspy.com) by sys (Infonet Kranj d.o.o.) -->
<!DOCTYPE xsl:stylesheet [
	<!ENTITY nbsp "&#160;">
]>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<!-- BODY-GLAVA ZA KONVENCIJO -->
	<xsl:template name="SpecBodyHeadKonvencija">
		<xsl:param name="Type"/>
		<xsl:param name="TxtFile"/>
		<tr>
			<td colspan="16">&nbsp;</td>
		</tr>
		<tr>
			<td colspan="16">
				<hr size="0"/>
			</td>
		</tr>
		<tr>
			<td colspan="4">ZZZS t.</td>
			<td colspan="4">priimek in ime</td>
			<td>dat.roj.</td>
			<td>spol</td>
			<td colspan="2">reg.t.</td>
			<td colspan="2">podlaga</td>
			<td>polica</td>
			<!-- 16.02.2006 Akt_96119 -->
			<td>nosilec PZZ</td>
		</tr>
		<tr>
			<td colspan="4"/>
			<td colspan="6">naslov</td>
			<td colspan="2">OZZ do</td>
			<td colspan="2">tip zav.</td>
			<td colspan="2">PZZ do</td>
		</tr>
		<tr>
			<td colspan="16">
				<hr size="0"/>
			</td>
		</tr>
		<tr>
			<td/>
			<td colspan="4">ifra BPI</td>
			<td colspan="3">zdr.del.</td>
			<td colspan="2">enota</td>
			<td colspan="5">datum</td>
			<td align="center">prost.</td>
		</tr>
		<tr>
			<td colspan="2"/>
			<td>pri.</td>
			<td align="center">obra.</td>
			<td colspan="2">datum</td>
			<td>obr.</td>
			<td colspan="3">storitev</td>
			<td align="center">t.</td>
			<td align="center">tok</td>
			<td align="center">% </td>
			<td align="center">obr.vred.</td>
			<td align="center">obv.del</td>
			<td align="center">
				<xsl:choose>
					<xsl:when test="not(../InvHeader/Payer/Organization) and (($Type='26') or ($Type='47'))">zavarovanje</xsl:when>
					<xsl:otherwise>zav.</xsl:otherwise>
					<!-- 17.02.2006 zav.Vzajemna -->
				</xsl:choose>
			</td>
		</tr>
		<tr>
			<td colspan="16">
				<hr size="0"/>
			</td>
		</tr>
		<tr>
			<td colspan="16">&nbsp;</td>
		</tr>
	</xsl:template>
	<!-- SPECIFIKACIJA ZA KONVENCIJO -->
	<xsl:template match="InvBody" mode="SpecKonvencija">
		<xsl:param name="Type"/>
		<xsl:param name="TxtFile"/>
		<table width="650" border="0" cellspacing="0" cellpadding="0" style="font-size: 9px;">
			<tr>
				<td width="10"/>
				<td width="10"/>
				<td width="10"/>
				<td width="40"/>
				<td width="60"/>
				<td width="20"/>
				<td width="30"/>
				<td width="65"/>
				<td width="65"/>
				<td width="65"/>
				<td width="35"/>
				<td width="35"/>
				<td width="20"/>
				<td width="65"/>
				<td width="65"/>
				<td width="65"/>
			</tr>
			<xsl:for-each select="Activitys/Activity/Categorys/Category/UnderGroups/UnderGroup/SpecPatients/Patient">
				<xsl:sort/>
				<xsl:call-template name="SpecHeadKonvencija">
					<xsl:with-param name="Type" select="$Type"/>
					<xsl:with-param name="TxtFile" select="$TxtFile"/>
				</xsl:call-template>
				<xsl:call-template name="SpecBodyHeadKonvencija">
					<xsl:with-param name="Type" select="$Type"/>
					<xsl:with-param name="TxtFile" select="$TxtFile"/>
				</xsl:call-template>
				<tr>
					<td colspan="16">&nbsp;</td>
				</tr>
				<tr>
					<td colspan="4">
						<xsl:value-of select="ZZZS_ID"/>
					</td>
					<td colspan="4">
						<xsl:value-of select="Name"/>
					</td>
					<td>
						<xsl:call-template name="FormatDate">
							<xsl:with-param name="Date" select="BirthDate"/>
						</xsl:call-template>&nbsp;
					</td>
					<td>
						<xsl:value-of select="Sex"/>
					</td>
					<td colspan="2">
						<xsl:value-of select="OZZ/ID"/>
					</td>
					<td colspan="2">
						<xsl:value-of select="Template/ID"/>
					</td>
					<td>
						<xsl:value-of select="PZZ/ID"/>
					</td>
					<!-- 16.02.2006 Akt_96119 -->
					<td>
						<xsl:value-of select="SifraZavarovalnice"/>
					</td>
				</tr>
				<tr>
					<td colspan="4"/>
					<td colspan="6">
						<xsl:value-of select="Address/Street"/>, <xsl:value-of select="Address/PostalOffice"/>
					</td>
					<td colspan="2">
						<xsl:if test="not(OZZ/ID='')">
							<xsl:call-template name="FormatDate">
								<xsl:with-param name="Date" select="OZZ/DateOfExpiry"/>
							</xsl:call-template>
						</xsl:if>
					</td>
					<td colspan="2">
						<xsl:value-of select="Template/TypeInsurance"/>
					</td>
					<td colspan="2">
						<xsl:if test="not(PZZ/ID='')">
							<xsl:call-template name="FormatDate">
								<xsl:with-param name="Date" select="PZZ/DateOfExpiry"/>
							</xsl:call-template>
						</xsl:if>
					</td>
				</tr>
				<tr>
					<td/>
					<td colspan="4">
						<xsl:value-of select="ServiceProperty/BPI_ID"/>
					</td>
					<td colspan="3">
						<xsl:value-of select="ServiceProperty/Doctor/ID"/>
					</td>
					<td colspan="2">
						<xsl:value-of select="ServiceProperty/ZDRUnit"/>
					</td>
					<td colspan="6">
						<xsl:if test="ServiceProperty/DateRealization">
							<xsl:call-template name="FormatDate">
								<xsl:with-param name="Date" select="ServiceProperty/DateRealization"/>
							</xsl:call-template> -
						<xsl:call-template name="FormatDate">
								<xsl:with-param name="Date" select="ServiceProperty/DateRealizationTO"/>
							</xsl:call-template>
						</xsl:if>
						<xsl:value-of select="ServiceProperty/Proposal"/>
					</td>
				</tr>
				<xsl:for-each select="ServiceProperty/Services/Service">
					<tr>
						<td width="10"/>
						<td width="10"/>
						<td width="10">
							<xsl:value-of select="KZZScenario"/>
						</td>
						<td width="40">
							<xsl:value-of select="Account"/>
						</td>
						<td colspan="2" width="80">
							<xsl:call-template name="FormatDate">
								<xsl:with-param name="Date" select="DateCompletion"/>
							</xsl:call-template>
						</td>
						<td width="30">
							<xsl:value-of select="TreatmentReason"/>
						</td>
						<td colspan="3" width="195">
							<xsl:variable name="FormatString" select="Service/Name"/>
							<xsl:value-of select="Service/ID"/>&nbsp;			
													<xsl:value-of select="substring($FormatString,1,25)"/>
						</td>
						<td width="35" align="right">
							<xsl:call-template name="FormatNumber">
								<xsl:with-param name="Number" select="NumberOfCase/Number"/>
							</xsl:call-template>
						</td>
						<td width="35" align="right">
							<xsl:call-template name="FormatNumber">
								<xsl:with-param name="Number" select="UnitValue/Value"/>
							</xsl:call-template>
						</td>
						<td width="20" align="right">
							<xsl:value-of select="format-number(Percent, '0', 'european')"/>
						</td>
						<td width="65" align="right">
							<xsl:call-template name="FormatNumberWithNull">
								<xsl:with-param name="Number" select="ServicePriceProperty/ServicePrice"/>
							</xsl:call-template>
						</td>
						<td width="65" align="right">
							<xsl:call-template name="FormatNumberWithNull">
								<xsl:with-param name="Number" select="ServicePriceProperty/BasicPrice"/>
							</xsl:call-template>
						</td>
						<td width="65" align="right">
							<xsl:call-template name="FormatNumberWithNull">
								<xsl:with-param name="Number" select="ServicePriceProperty/AdditionalPrice"/>
							</xsl:call-template>
						</td>
					</tr>
				</xsl:for-each>
				<tr>
					<td/>
					<td colspan="3">[  Skupaj</td>
					<td colspan="9">
						<xsl:value-of select="Name"/>
					</td>
					<td align="right">
						<xsl:call-template name="FormatNumberWithNull">
							<xsl:with-param name="Number" select="ServicePriceProperty/ServicePrice"/>
						</xsl:call-template>
					</td>
					<td align="right">
						<xsl:call-template name="FormatNumberWithNull">
							<xsl:with-param name="Number" select="ServicePriceProperty/BasicPrice"/>
						</xsl:call-template>
					</td>
					<td align="right">
						<xsl:call-template name="FormatNumberWithNull">
							<xsl:with-param name="Number" select="ServicePriceProperty/AdditionalPrice"/>
						</xsl:call-template>  ]
					</td>
				</tr>
				<tr>
					<td colspan="16">&nbsp;</td>
				</tr>
				<tr>
					<td colspan="16">
						<hr size="0"/>
					</td>
				</tr>
				<xsl:if test="position()!=last()">
					<tr class="pBreak"/>
				</xsl:if>
			</xsl:for-each>
		</table>
	</xsl:template>
	<!-- SPECIFIKACIJA I -->
	<xsl:template match="InvBody" mode="SpecBody">
		<xsl:param name="Type"/>
		<xsl:param name="TxtFile"/>
		<table width="650" border="0" cellspacing="0" cellpadding="0" style="font-size: 9px;">
			<tr>
				<td colspan="16">&nbsp;</td>
			</tr>
			<tr>
				<td width="10"/>
				<td width="10"/>
				<td width="10"/>
				<td width="40"/>
				<td width="60"/>
				<td width="20"/>
				<td width="30"/>
				<td width="65"/>
				<td width="65"/>
				<td width="65"/>
				<td width="35"/>
				<td width="35"/>
				<td width="20"/>
				<td width="65"/>
				<td width="65"/>
				<td width="65"/>
			</tr>
			<tr>
				<td colspan="16">&nbsp;</td>
			</tr>
			<tr>
				<td colspan="16">
					<hr size="0"/>
				</td>
			</tr>
			<xsl:choose>
				<xsl:when test="($Type='P01') or ($Type='P02') or ($Type='S01') or ($Type='33') or ($Type='34') or ($Type='DDDDD') or ($Type='BBBBB') or ($Type='40') or ($Type='ER')">
					<!--Akt_100886-->
					<tr>
						<td colspan="4"/>
						<td colspan="4">
							<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BH3_1_1"/>
						</td>
						<td>
							<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BH3_2_1"/>
						</td>
						<td>
							<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BH3_3_1"/>
						</td>
						<td colspan="6">
							<xsl:if test="Activitys/Activity/Categorys/Category/UnderGroups/UnderGroup/SpecPatients/Patient/ServiceProperty/DateRealization">
								<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BH3_4_1"/>
							</xsl:if>
						</td>
					</tr>
					<xsl:if test="contains(../InvProperty/BodyInformation,'ZZZS')">
						<tr>
							<td/>
							<td colspan="4">ifra BPI</td>
							<td colspan="3">zdr.del.</td>
							<td colspan="2">enota</td>
							<td colspan="6"/>
						</tr>
					</xsl:if>
					<tr>
						<xsl:choose>
							<xsl:when test="($Type='40') ">
								<td colspan="2"/>
								<td>
									<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BH4_1_1_1"/>
								</td>
							</xsl:when>
							<xsl:otherwise>
								<td colspan="3"/>
							</xsl:otherwise>
						</xsl:choose>
						<td>
							<xsl:if test="($Type='40') ">
								<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BH4_1_1"/>
							</xsl:if>
						</td>
						<td colspan="3">
							<xsl:if test="not($Type='40') ">
								<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BH4_2_1"/>
							</xsl:if>
						</td>
						<td colspan="5">
							<xsl:if test="not($Type='40') ">
								<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BH4_3_1"/>
							</xsl:if>
						</td>
						<td align="right">
							<xsl:if test="not($Type='40') ">
								<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BH4_4_1"/>
							</xsl:if>
						</td>
						<td align="right">
							<xsl:if test="not($Type='40') ">
								<xsl:if test="not(Activitys/Activity/Categorys/Category/UnderGroups/UnderGroup/UnitValue/Value = '0.00000')">
									<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BH4_5_1"/>
								</xsl:if>
							</xsl:if>
						</td>
						<td align="right">
							<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BH4_6_1"/>
						</td>
						<td align="right">
							<xsl:if test="not($Type='40') ">
								<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BH4_7_1"/>
							</xsl:if>
						</td>
					</tr>
				</xsl:when>
				<xsl:otherwise>
					<tr>
						<xsl:if test="($Type='39') ">
							<!-- Akt_100808 -->
							<td colspan="10">Ident. t. </td>
						</xsl:if>
						<xsl:if test="not($Type='39') ">
							<!-- Akt_100808 -->
							<td colspan="4">ZZZS t.</td>
							<td colspan="4">priimek in ime</td>
							<td>dat.roj.</td>
							<td>spol</td>
						</xsl:if>
						<td colspan="2">
							<xsl:if test="not($Type='39') ">reg.t.</xsl:if>
						</td>
						<!-- Akt_100808 -->
						<td colspan="2">
							<xsl:if test="not($Type='39') ">podlaga</xsl:if>
						</td>
						<td>
							<xsl:if test="not($Type='39') ">polica</xsl:if>
						</td>
						<!-- 16.02.2006 Akt_96119 -->
						<td>
							<xsl:if test="not($Type='39') ">nosilec PZZ</xsl:if>
						</td>
						<!-- Akt_100808 -->
					</tr>
					<tr>
						<xsl:if test="($Type='39') ">
							<!-- Akt_100808 -->
							<td colspan="10"/>
						</xsl:if>
						<xsl:if test="not($Type='39') ">
							<!-- Akt_100808 -->
							<td colspan="4"/>
							<td colspan="6">naslov</td>
						</xsl:if>
						<td colspan="2">
							<xsl:if test="not($Type='39') ">OZZ do</xsl:if>
						</td>
						<!-- Akt_100808 -->
						<td colspan="2">
							<xsl:if test="not($Type='39') ">tip zav.</xsl:if>
						</td>
						<!-- Akt_100808 -->
						<td colspan="2">
							<xsl:if test="not($Type='39') ">PZZ do</xsl:if>
						</td>
						<!-- Akt_100808 -->
					</tr>
					<tr>
						<td colspan="16">
							<hr size="0"/>
						</td>
					</tr>
					<xsl:if test="not($Type='39') ">
						<!-- Akt_100808 -->
						<tr>
							<td/>
							<td colspan="4">ifra BPI</td>
							<td colspan="3">zdr.del.</td>
							<td>enota</td>
							<xsl:choose>
								<xsl:when test="($Type='46') ">
									<td colspan="2">t.ak.knj.</td>
									<td colspan="2">nujnost</td>
									<td>nap.diag</td>
									<td>klin.vpr.</td>
								</xsl:when>
								<xsl:otherwise>
									<td colspan="4">datum</td>
									<td>t. napotnice</td>
								</xsl:otherwise>
							</xsl:choose>
							<td align="center">prost.</td>
						</tr>
					</xsl:if>
					<tr>
						<td colspan="2"/>
						<td>
							<xsl:if test="not($Type='39') ">pri.</xsl:if>
						</td>
						<!-- Akt_100808 -->
						<td align="center">
							<xsl:if test="not($Type='39') ">obra.</xsl:if>
						</td>
						<!-- Akt_100808 -->
						<td colspan="2">datum</td>
						<td>obr.</td>
						<xsl:choose>
							<xsl:when test="($Type='46')">
								<td colspan="2">storitev</td>
								<td>DRG</td>
							</xsl:when>
							<xsl:otherwise>
								<td colspan="3">storitev</td>
							</xsl:otherwise>
						</xsl:choose>
						<td align="center">t.</td>
						<td align="center">tok</td>
						<td align="center">
							<xsl:if test="not($Type='39') ">%</xsl:if>
						</td>
						<!-- Akt_100808 -->
						<td align="center">obr.vred.</td>
						<td align="center">obv.del</td>
						<td align="center">
							<xsl:choose>
								<xsl:when test="not(../InvHeader/Payer/Organization) and (($Type='26') or ($Type='47'))">zavarovanje</xsl:when>
								<xsl:otherwise>
									<xsl:if test="not($Type='39') ">zav.</xsl:if>
								</xsl:otherwise>
								<!-- Akt_100808 -->
								<!-- 17.02.2006 zav.Vzajemna -->
							</xsl:choose>
						</td>
					</tr>
					<xsl:choose>
						<xsl:when test="($Type='46')">
							<tr>
								<td/>
								<td/>
								<td colspan="2">naziv KS</td>
								<td colspan="5">koncent. KS</td>
								<td colspan="2">kol. KS</td>
							</tr>
						</xsl:when>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
			<tr>
				<td colspan="16">
					<hr size="0"/>
				</td>
			</tr>
			<tr>
				<td colspan="16">&nbsp;</td>
			</tr>
			<xsl:for-each select="Activitys/Activity">
				<xsl:choose>
					<xsl:when test="($Type='P01') or ($Type='P02') or ($Type='S01') or ($Type='33') or ($Type='34') or ($Type='DDDDD') or ($Type='BBBBB') or ($Type='40') or ($Type='ER') "/>
					<xsl:otherwise>
						<tr>
							<td colspan="3" style="font-size: 11px;">
								<b>
									<xsl:value-of select="ID"/>
								</b>
							</td>
							<td colspan="13" style="font-size: 11px;">
								<b>
									<xsl:value-of select="Name"/>
								</b>
							</td>
						</tr>
						<tr>
							<td colspan="16">&nbsp;</td>
						</tr>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:for-each select="Categorys/Category">
					<xsl:sort/>
					<xsl:choose>
						<xsl:when test="($Type='P01') or ($Type='P02') or ($Type='S01') or ($Type='33') or ($Type='34') or ($Type='DDDDD') or ($Type='BBBBB') or ($Type='ER')"/>
						<xsl:otherwise>
							<xsl:if test="not(ID='0')">
								<tr>
									<td colspan="2" style="font-size: 11px;">
										<b>
											<xsl:value-of select="ID"/>
										</b>
									</td>
									<td colspan="14" style="font-size: 11px;">
										<b>
											<xsl:value-of select="Name"/>
										</b>
									</td>
								</tr>
							</xsl:if>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:for-each select="UnderGroups/UnderGroup">
						<xsl:sort/>
						<xsl:choose>
							<xsl:when test="($Type='P01') or ($Type='P02') or ($Type='S01') or ($Type='33') or ($Type='34') or ($Type='DDDDD') or ($Type='BBBBB') or ($Type='40') or ($Type='ER')"/>
							<xsl:otherwise>
								<td colspan="16">&nbsp;</td>
								<tr>
									<td colspan="3">
										<xsl:value-of select="ID"/>
									</td>
									<td colspan="5">
										<xsl:value-of select="Name"/>
									</td>
									<td colspan="1">
										<xsl:choose>
											<xsl:when test="($Type='02')"/>
											<xsl:otherwise>
												<xsl:call-template name="FormatNumber">
													<xsl:with-param name="Number" select="NumberOfCase/Number"/>
												</xsl:call-template>
											</xsl:otherwise>
										</xsl:choose>
									</td>
									<td colspan="7">
										<xsl:call-template name="UnderGroundField1">
											<xsl:with-param name="TxtFile" select="'InvTxtSL.xml'"/>
										</xsl:call-template>
									</td>
								</tr>
							</xsl:otherwise>
						</xsl:choose>
						<xsl:choose>
							<!-- 13.06.05 TO JE NOVO  -->
							<xsl:when test="contains(../../../../../../../InvProperty/BodyInformation,'ORDERERS')">
								<xsl:for-each select="SpecOrderers/Orderer">
									<xsl:sort/>
									<tr>
										<td colspan="16">&nbsp;</td>
									</tr>
									<tr>
										<td colspan="16">
									Naronik: <xsl:value-of select="Name"/>
										</td>
									</tr>
									<xsl:for-each select="SpecPatients">
										<xsl:apply-templates select="Patient" mode="SpecBodyPatient">
											<xsl:with-param name="Type" select="$Type"/>
											<xsl:with-param name="TxtFile" select="$TxtFile"/>
										</xsl:apply-templates>
									</xsl:for-each>
									<tr>
										<td colspan="5">[  Skupaj naronik:</td>
										<td colspan="8">
											<xsl:value-of select="Name"/>
										</td>
										<td align="right">
											<xsl:call-template name="FormatNumberWithNull">
												<xsl:with-param name="Number" select="ServicePriceProperty/ServicePrice"/>
											</xsl:call-template>
										</td>
										<td align="right">
											<xsl:call-template name="FormatNumberWithNull">
												<xsl:with-param name="Number" select="ServicePriceProperty/BasicPrice"/>
											</xsl:call-template>
										</td>
										<td align="right">
											<xsl:call-template name="FormatNumberWithNull">
												<xsl:with-param name="Number" select="ServicePriceProperty/AdditionalPrice"/>
											</xsl:call-template>  ]
									</td>
									</tr>
									<tr>
										<td colspan="16">&nbsp;</td>
									</tr>
								</xsl:for-each>
							</xsl:when>
							<xsl:otherwise>
								<xsl:for-each select="SpecPatients">
									<xsl:apply-templates select="Patient" mode="SpecBodyPatient">
										<xsl:with-param name="Type" select="$Type"/>
										<xsl:with-param name="TxtFile" select="$TxtFile"/>
									</xsl:apply-templates>
								</xsl:for-each>
							</xsl:otherwise>
						</xsl:choose>
						<!-- 22.09.2005, 27.06.2006 -->
						<xsl:if test="not($Type='40')">
							<tr>
								<td colspan="3">
									<xsl:if test="not($Type='42')">
										<!--Akt_101147-->[  </xsl:if>
									<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecBody/BUG_2_1"/>
								</td>
								<td colspan="7">
									<xsl:if test="($Type='39') ">
										<xsl:value-of select="SIFRA101"/>
										<!-- Akt_100808 -->
									</xsl:if>
									<xsl:if test="not($Type='39') ">
										<xsl:value-of select="Name"/>
									</xsl:if>
								</td>
								<td align="right">
									<xsl:call-template name="FormatNumber">
										<xsl:with-param name="Number" select="NumberOfCase/Number"/>
									</xsl:call-template>
								</td>
								<td align="right">
									<xsl:call-template name="FormatNumber">
										<xsl:with-param name="Number" select="UnitValue/Value"/>
									</xsl:call-template>
								</td>
								<td/>
								<td align="right">
									<xsl:call-template name="FormatNumberWithNull">
										<xsl:with-param name="Number" select="ServicePriceProperty/ServicePrice"/>
									</xsl:call-template>
								</td>
								<td align="right">
									<xsl:call-template name="FormatNumberWithNull">
										<xsl:with-param name="Number" select="ServicePriceProperty/BasicPrice"/>
									</xsl:call-template>
								</td>
								<td align="right">
									<xsl:if test="not($Type='39') ">
										<xsl:call-template name="FormatNumberWithNull">
											<xsl:with-param name="Number" select="ServicePriceProperty/AdditionalPrice"/>
										</xsl:call-template>
									</xsl:if>
									<!-- Akt_100808 -->
									<xsl:if test="not($Type='42') ">
										<!--Akt_101147-->
								]</xsl:if>
								</td>
							</tr>
						</xsl:if>
					</xsl:for-each>
				</xsl:for-each>
			</xsl:for-each>
			<tr>
				<td colspan="16">
					<hr size="0"/>
				</td>
			</tr>
			<tr>
				<td colspan="16">&nbsp;</td>
			</tr>
			<xsl:choose>
				<xsl:when test="($Type='P01') or ($Type='P02') or ($Type='S01') or ($Type='33') or ($Type='34') or ($Type='DDDDD') or ($Type='BBBBB') or ($Type='ER')">
					<tr>
						<td colspan="13">
							<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BF1_1_1"/>
						</td>
						<td align="right"/>
						<td align="right"/>
						<td align="right">
							<!--Nap_10766-->
							<xsl:choose>
								<xsl:when test="($Type='34') or ($Type='S01') ">
									<xsl:call-template name="FormatNumberWithNull">
										<xsl:with-param name="Number" select="../InvFooter/ServicePriceProperty/AdditionalPrice"/>
									</xsl:call-template>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="FormatNumberWithNull">
										<xsl:with-param name="Number" select="../InvFooter/ServicePriceProperty/ServicePrice"/>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</td>
					</tr>
				</xsl:when>
				<xsl:otherwise>
					<tr>
						<td colspan="13">Skupaj:</td>
						<td align="right">
							<xsl:if test="($Type='17')">
								<xsl:call-template name="FormatNumberWithNull">
									<xsl:with-param name="Number" select="../InvFooter/ServicePriceProperty/ServicePrice"/>
								</xsl:call-template>
							</xsl:if>
						</td>
						<td align="right">
							<xsl:if test="not(($Type='17') or ($Type='26') or ($Type='VOZ') or ($Type='42') or ($Type='47') or ($Type='38'))">
								<!--Akt_101147-->
								<xsl:call-template name="FormatNumberWithNull">
									<xsl:with-param name="Number" select="../InvFooter/ServicePriceProperty/BasicPrice"/>
								</xsl:call-template>
							</xsl:if>
						</td>
						<td align="right">
							<xsl:if test="($Type='26') or ($Type='VOZ') or ($Type='42') or ($Type='47') or ($Type='38')">
								<!--Akt_101147-->
								<xsl:call-template name="FormatNumberWithNull">
									<xsl:with-param name="Number" select="../InvFooter/ServicePriceProperty/AdditionalPrice"/>
								</xsl:call-template>
							</xsl:if>
						</td>
					</tr>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:choose>
				<xsl:when test="($Type='P01') or ($Type='P02') or ($Type='S01') or ($Type='33') or ($Type='34') or ($Type='DDDDD') or ($Type='BBBBB') or ($Type='ER')">
					<tr>
						<td colspan="16">&nbsp;</td>
					</tr>
					<tr>
						<td colspan="16">&nbsp;</td>
					</tr>
					<!--<xsl:if test="(../InvProperty/Language = 'SLO')">-->
					<tr>
						<td colspan="16">
							<xsl:value-of select="../InvFooter/Description"/>
						</td>
					</tr>
					<!--</xsl:if>-->
					<!--
					<tr>
						<td colspan="16">&nbsp;</td>
					</tr>
					<tr>
						<td align="left" colspan="11">
							<xsl:value-of select="../InvFooter/SignHeader"/>
						</td>
						<td align="left" colspan="5">
							<xsl:value-of select="../InvFooter/SignManHeader"/>
						</td>
					</tr>
					<tr>
						<td align="left" colspan="11">
							<xsl:value-of select="../InvFooter/Sign"/>
						</td>
						<td align="left" colspan="5">
							<xsl:value-of select="../InvFooter/SignMan"/>
						</td>
					</tr>
					-->
				</xsl:when>
			</xsl:choose>
		</table>
	</xsl:template>
	<xsl:template match="Patient" mode="SpecBodyPatient">
		<xsl:param name="Type"/>
		<xsl:param name="TxtFile"/>
		<!-- <xsl:sort/> -->
		<tr>
			<td colspan="16">&nbsp;</td>
		</tr>
		<tr>
			<xsl:if test="($Type='39') ">
				<td colspan="10">
					<xsl:value-of select="SIFRA101"/>
					<!-- Akt_100808 -->
				</td>
			</xsl:if>
			<xsl:choose>
				<xsl:when test="($Type='40')">
					<td colspan="3">
						<xsl:value-of select="ZZZS_ID"/>
					</td>
					<td colspan="5">
						<xsl:value-of select="Name"/>
					</td>
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test="not($Type='39') ">
						<td colspan="4">
							<xsl:value-of select="ZZZS_ID"/>
						</td>
						<td colspan="4">
							<xsl:value-of select="Name"/>
						</td>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:if test="not($Type='39') ">
				<td>
					<xsl:call-template name="FormatDate">
						<xsl:with-param name="Date" select="BirthDate"/>
					</xsl:call-template>&nbsp;
									</td>
				<td>
					<xsl:value-of select="Sex"/>
				</td>
			</xsl:if>
			<xsl:choose>
				<xsl:when test="($Type='P01') or ($Type='P02') or ($Type='S01') or ($Type='33') or ($Type='34') or ($Type='DDDDD') or ($Type='BBBBB') or ($Type='ER')">
					<td colspan="6">
						<xsl:value-of select="ServiceProperty/Services/Service/RequestDocument"/>
						<!-- ML, 08.06.2018, Akt_107573: Dopolnitev izpisa t.avtorizacije na dokument -->
					</td>
				</xsl:when>
				<xsl:otherwise>
					<td colspan="2">
						<xsl:value-of select="OZZ/ID"/>
					</td>
					<td colspan="2">
						<xsl:value-of select="Template/ID"/>
					</td>
					<td>
						<xsl:value-of select="PZZ/ID"/>
					</td>
					<!-- 16.02.2006 Akt_96119 -->
					<td>
						<xsl:value-of select="SifraZavarovalnice"/>
					</td>
				</xsl:otherwise>
			</xsl:choose>
		</tr>
		<tr>
			<xsl:if test="($Type='39') ">
				<!-- Akt_100808 -->
				<td colspan="9">
		     </td>
			</xsl:if>
			<xsl:if test="not($Type='39') ">
				<!-- Akt_100808 -->
				<xsl:choose>
					<xsl:when test="($Type='40')">
						<td colspan="3"/>
						<td colspan="6">
							<xsl:value-of select="Address/Street"/>, <xsl:value-of select="Address/PostalOffice"/>
						</td>
					</xsl:when>
					<xsl:otherwise>
						<td colspan="4"/>
						<td colspan="5">
							<xsl:value-of select="Address/Street"/>, <xsl:value-of select="Address/PostalOffice"/>
						</td>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:choose>
				<xsl:when test="($Type='P01') or ($Type='P02') or ($Type='S01') or ($Type='33') or ($Type='34') or ($Type='DDDDD') or ($Type='BBBBB') or ($Type='ER')">
					<td colspan="4">
						<xsl:if test="ServiceProperty/DateRealization">
							<xsl:call-template name="FormatDate">
								<xsl:with-param name="Date" select="ServiceProperty/DateRealization"/>
							</xsl:call-template> -
											<xsl:call-template name="FormatDate">
								<xsl:with-param name="Date" select="ServiceProperty/DateRealizationTO"/>
							</xsl:call-template>
						</xsl:if>
						<xsl:value-of select="ServiceProperty/Proposal"/>
					</td>
					<td colspan="3">
						<xsl:value-of select="ServiceProperty/ReqNumber"/>
					</td>
				</xsl:when>
				<xsl:otherwise>
					<td colspan="1"/>
					<td colspan="2">
						<xsl:if test="not(OZZ/ID='')">
							<xsl:call-template name="FormatDate">
								<xsl:with-param name="Date" select="OZZ/DateOfExpiry"/>
							</xsl:call-template>
						</xsl:if>
					</td>
					<td colspan="2">
						<xsl:value-of select="Template/TypeInsurance"/>
					</td>
					<td colspan="2">
						<xsl:if test="not(PZZ/ID='')">
							<xsl:call-template name="FormatDate">
								<xsl:with-param name="Date" select="PZZ/DateOfExpiry"/>
							</xsl:call-template>
						</xsl:if>
					</td>
				</xsl:otherwise>
			</xsl:choose>
		</tr>
		<xsl:choose>
			<!-- <xsl:when test="($Type='P01') or ($Type='P02') or ($Type='S01') or ($Type='33') or ($Type='34') or ($Type='DDDDD') or ($Type='BBBBB')"/> -->
			<xsl:when test="not(contains(../../../../../../../../../InvProperty/BodyInformation,'ZZZS')) and (($Type='P01') or ($Type='P02') or ($Type='S01') or ($Type='33') or ($Type='34') or ($Type='DDDDD') or ($Type='BBBBB') or ($Type='40') or ($Type='ER') )"/>
			<xsl:otherwise>
				<xsl:if test="not($Type='39') ">
					<!-- Akt_100808 -->
					<tr>
						<td/>
						<td colspan="4">
							<xsl:value-of select="ServiceProperty/BPI_ID"/>
						</td>
						<td colspan="3">
							<xsl:value-of select="ServiceProperty/Doctor/ID"/>
						</td>
						<xsl:choose>
							<xsl:when test="($Type='46')">
								<td>
									<xsl:value-of select="ServiceProperty/ZDRUnit"/>
								</td>
								<td colspan="2">
									<xsl:value-of select="ServiceProperty/WLNumber"/>
								</td>
								<td colspan="2">
									<xsl:value-of select="ServiceProperty/Priority"/>
								</td>
								<td>
									<xsl:value-of select="ServiceProperty/ReqDiagnose"/>
								</td>
								<td>
									<xsl:value-of select="ServiceProperty/ClinicalQuestion"/>
								</td>
							</xsl:when>
							<xsl:otherwise>
								<td colspan="2">
									<xsl:value-of select="ServiceProperty/ZDRUnit"/>
								</td>
								<td colspan="4">
									<xsl:if test="ServiceProperty/DateRealization">
										<xsl:call-template name="FormatDate">
											<xsl:with-param name="Date" select="ServiceProperty/DateRealization"/>
										</xsl:call-template> -
											<xsl:call-template name="FormatDate">
											<xsl:with-param name="Date" select="ServiceProperty/DateRealizationTO"/>
										</xsl:call-template>
									</xsl:if>
									<xsl:value-of select="ServiceProperty/Proposal"/>
								</td>
								<td colspan="2">
									<xsl:value-of select="ServiceProperty/ReqNumber"/>
								</td>
							</xsl:otherwise>
						</xsl:choose>
					</tr>
				</xsl:if>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:for-each select="ServiceProperty/Services/Service">
			<xsl:choose>
				<xsl:when test="($Type='P01') or ($Type='P02') or ($Type='S01') or ($Type='33') or ($Type='34')  or ($Type='DDDDD') or ($Type='BBBBB') or ($Type='ER')">
					<tr>
						<td width="10"/>
						<td width="10"/>
						<td width="10"/>
						<td width="50">
							<xsl:value-of select="Account"/>
						</td>
						<td colspan="2" width="80">
							<xsl:call-template name="FormatDate">
								<xsl:with-param name="Date" select="DateCompletion"/>
							</xsl:call-template>
						</td>
						<td width="20"/>
						<td colspan="5" width="230">
							<xsl:variable name="FormatString" select="Service/Name"/>
							<xsl:value-of select="Service/ID"/>&nbsp;			
												<xsl:value-of select="substring($FormatString,1,35)"/>
						</td>
						<td width="65" align="right">
							<xsl:call-template name="FormatNumber">
								<xsl:with-param name="Number" select="NumberOfCase/Number"/>
							</xsl:call-template>
						</td>
						<td width="65" align="right">
							<xsl:call-template name="FormatNumber">
								<xsl:with-param name="Number" select="UnitValue/Value"/>
							</xsl:call-template>
						</td>
						<td width="65" align="right">
							<xsl:call-template name="FormatNumberWithNull">
								<xsl:with-param name="Number" select="ServicePriceProperty/ServicePrice"/>
							</xsl:call-template>
						</td>
						<td width="65" align="right">
							<xsl:call-template name="FormatNumberWithNull">
								<xsl:with-param name="Number" select="ServicePriceProperty/AdditionalPrice"/>
							</xsl:call-template>
						</td>
					</tr>
				</xsl:when>
				<xsl:otherwise>
					<tr>
						<td width="10"/>
						<td width="10"/>
						<xsl:choose>
							<!-- Akt_100886 -->
							<xsl:when test="($Type='40')">
								<td width="50">
									<xsl:value-of select="KontoID"/>
								</td>
								<td width="50">
									<xsl:value-of select="Service/ID"/>
								</td>
								<td colspan="6" width="300">
									<xsl:variable name="FormatString" select="Service/Name"/>
									<xsl:value-of select="substring($FormatString,1,25)"/>
								</td>
							</xsl:when>
							<xsl:otherwise>
								<td width="10">
									<xsl:if test="not($Type='39') ">
										<xsl:value-of select="KZZScenario"/>
									</xsl:if>
									<!-- Akt_100808 -->
								</td>
								<td width="50">
									<xsl:if test="not($Type='39') ">
										<xsl:value-of select="Account"/>
									</xsl:if>
									<!-- Akt_100808 -->
								</td>
								<td colspan="2" width="80">
									<xsl:call-template name="FormatDate">
										<xsl:with-param name="Date" select="DateCompletion"/>
									</xsl:call-template>
								</td>
								<td width="30">
									<xsl:value-of select="TreatmentReason"/>
								</td>
								<xsl:choose>
									<xsl:when test="($Type='46')">
										<td colspan="2" width="195">
											<xsl:variable name="FormatString" select="Service/Name"/>
											<xsl:value-of select="Service/ID"/>&nbsp;			
													<xsl:value-of select="substring($FormatString,1,24)"/>
										</td>
									</xsl:when>
									<xsl:otherwise>
										<td colspan="3" width="195">
											<xsl:variable name="FormatString" select="Service/Name"/>
											<xsl:value-of select="Service/ID"/>&nbsp;			
													<xsl:value-of select="substring($FormatString,1,25)"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
						<xsl:choose>
							<xsl:when test="($Type='46')">
								<td width="35" align="left">
									<xsl:value-of select="DRG"/>
								</td>
								<td width="10" align="right">
									<xsl:if test="not($Type='40') ">
										<xsl:call-template name="FormatNumber">
											<xsl:with-param name="Number" select="NumberOfCase/Number"/>
										</xsl:call-template>
									</xsl:if>
								</td>
							</xsl:when>
							<xsl:otherwise>
								<td width="35" align="right">
									<xsl:if test="not($Type='40') ">
										<xsl:call-template name="FormatNumber">
											<xsl:with-param name="Number" select="NumberOfCase/Number"/>
										</xsl:call-template>
									</xsl:if>
								</td>
							</xsl:otherwise>
						</xsl:choose>
						<td width="35" align="right">
							<xsl:if test="not($Type='40') ">
								<xsl:call-template name="FormatNumber">
									<xsl:with-param name="Number" select="UnitValue/Value"/>
								</xsl:call-template>
							</xsl:if>
						</td>
						<td width="20" align="right">
							<xsl:if test="not(($Type='39') or ($Type='40')) ">
								<xsl:value-of select="format-number(Percent, '0', 'european')"/>
							</xsl:if>
							<!-- Akt_100808 -->
						</td>
						<td width="65" align="right">
							<xsl:if test="not($Type='40') ">
								<xsl:call-template name="FormatNumberWithNull">
									<xsl:with-param name="Number" select="ServicePriceProperty/ServicePrice"/>
								</xsl:call-template>
							</xsl:if>
						</td>
						<td width="65" align="right">
							<xsl:call-template name="FormatNumberWithNull">
								<xsl:with-param name="Number" select="ServicePriceProperty/BasicPrice"/>
							</xsl:call-template>
						</td>
						<td width="65" align="right">
							<xsl:if test="not(($Type='39') or ($Type='40'))">
								<xsl:call-template name="FormatNumberWithNull">
									<xsl:with-param name="Number" select="ServicePriceProperty/AdditionalPrice"/>
								</xsl:call-template>
							</xsl:if>
							<!-- Akt_100808 -->
						</td>
					</tr>
					<xsl:if test="($Type='46')">
						<xsl:for-each select="Medicine">
							<tr>
								<td/>
								<td/>
								<td colspan="2">
									<xsl:value-of select="ID"/>
								</td>
								<td colspan="5">
									<xsl:value-of select="Name"/>
								</td>
								<td colspan="2">
									<xsl:value-of select="Quantity"/>
								</td>
							</tr>
						</xsl:for-each>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>
		<xsl:choose>
			<xsl:when test="($Type='P01') or ($Type='P02') or ($Type='S01') or ($Type='33') or ($Type='34') or ($Type='DDDDD') or ($Type='BBBBB') or ($Type='ER')">
				<tr>
					<td/>
					<td colspan="3">[  
											<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BG1_1_1"/>
					</td>
					<td colspan="8">
						<!-- 27.06.2006 -->
						<xsl:value-of select="Name"/>
					</td>
					<td align="right">
						<!-- 27.06.2006 -->
						<xsl:call-template name="FormatNumber">
							<xsl:with-param name="Number" select="NumberOfCase/Number"/>
						</xsl:call-template>
					</td>
					<td align="right">
						<!-- 27.06.2006 -->
						<xsl:call-template name="FormatNumber">
							<xsl:with-param name="Number" select="UnitValue/Value"/>
						</xsl:call-template>
					</td>
					<td align="right">
						<!-- 27.06.2006 -->
						<xsl:call-template name="FormatNumberWithNull">
							<xsl:with-param name="Number" select="ServicePriceProperty/ServicePrice"/>
						</xsl:call-template>
					</td>
					<td align="right">
						<xsl:call-template name="FormatNumberWithNull">
							<xsl:with-param name="Number" select="ServicePriceProperty/AdditionalPrice"/>
						</xsl:call-template>
						]	
					</td>
				</tr>
			</xsl:when>
			<xsl:otherwise>
				<tr>
					<td/>
					<xsl:choose>
						<xsl:when test="($Type='40')">
							<td colspan="2">[ Skupaj</td>
							<td colspan="10">
								<xsl:value-of select="Name"/>
							</td>
						</xsl:when>
						<xsl:otherwise>
							<td colspan="3">
								<xsl:if test="not($Type='42') ">
									<!--Akt_101147-->
					[  </xsl:if>Skupaj</td>
							<td colspan="9">
								<xsl:if test="($Type='39') ">
									<xsl:value-of select="SIFRA101"/>
									<!-- Akt_100808 -->
								</xsl:if>
								<xsl:if test="not($Type='39') ">
									<xsl:value-of select="Name"/>
								</xsl:if>
							</td>
						</xsl:otherwise>
					</xsl:choose>
					<td align="right">
						<xsl:if test="not($Type='40') ">
							<xsl:call-template name="FormatNumberWithNull">
								<xsl:with-param name="Number" select="ServicePriceProperty/ServicePrice"/>
							</xsl:call-template>
						</xsl:if>
					</td>
					<td align="right">
						<xsl:call-template name="FormatNumberWithNull">
							<xsl:with-param name="Number" select="ServicePriceProperty/BasicPrice"/>
						</xsl:call-template>
					</td>
					<td align="right">
						<xsl:if test="not(($Type='39') or ($Type='40') )">
							<xsl:call-template name="FormatNumberWithNull">
								<xsl:with-param name="Number" select="ServicePriceProperty/AdditionalPrice"/>
							</xsl:call-template>
						</xsl:if>
						<!-- Akt_100808 -->
						<xsl:if test="not($Type='42') ">
							<!--Akt_101147-->
						 ]
						 </xsl:if>
					</td>
				</tr>
			</xsl:otherwise>
		</xsl:choose>
		<tr>
			<td colspan="16">&nbsp;</td>
		</tr>
	</xsl:template>
	<!-- SPECIFIKACIJA II -->
	<xsl:template match="InvBody" mode="SpecOrdererBody">
		<xsl:param name="Type"/>
		<xsl:param name="TxtFile"/>
		<table width="650" border="0" cellspacing="0" cellpadding="0" style="font-size: 9px;">
			<tr>
				<td width="15"/>
				<td width="15"/>
				<td width="260"/>
				<td width="90"/>
				<td width="90"/>
				<!-- ML, 27.3.2007,Akt_99966: SB Celje - RAF oblika fakture -->
				<td width="90"/>
				<td width="90"/>
			</tr>
			<tr>
				<td colspan="7">&nbsp;</td>
			</tr>
			<tr>
				<td colspan="7">&nbsp;</td>
			</tr>
			<!-- ML, 27.3.2007,Akt_99966: SB Celje - RAF oblika fakture -->
			<!-- rekapitulacija storitev po zdravnikih naronikih -->
			<xsl:if test="contains(../InvProperty/BodyInformation,'ORDERER:SERVICES')">
				<tr>
					<td colspan="7">
						<hr size="1" style="color: #000000;"/>
					</td>
				</tr>
				<tr>
					<td colspan="3">Storitev/material</td>
					<td align="right">koliina</td>
					<td align="right">t. tok</td>
					<!-- ML, 27.3.2007,Akt_99966: SB Celje - RAF oblika fakture -->
					<td align="right">cena</td>
					<td align="right">znesek</td>
				</tr>
				<tr>
					<td colspan="7">
						<hr size="1" style="color: #000000;"/>
					</td>
				</tr>
				<tr>
					<td colspan="7">&nbsp;</td>
				</tr>
				<xsl:for-each select="Activitys/Activity">
					<xsl:sort/>
					<!-- K 10.10.2006 - Akt_99019 - e je 0 pol ne prikae -->
					<xsl:choose>
						<xsl:when test="ID != '0'">
							<tr>
								<td colspan="2" style="font-size: 11px;">
									<b>
										<xsl:value-of select="ID"/>
									</b>
								</td>
								<td colspan="5" style="font-size: 11px;">
									<b>
										<xsl:value-of select="Name"/>
									</b>
								</td>
							</tr>
							<tr>
								<td colspan="7">&nbsp;</td>
							</tr>
						</xsl:when>
					</xsl:choose>
					<xsl:for-each select="Categorys/Category/UnderGroups/UnderGroup">
						<xsl:sort/>
						<!-- K 10.10.2006 - Akt_99019 - e je 0 pol ne prikae -->
						<xsl:choose>
							<xsl:when test="ID != '0'">
								<tr>
									<td colspan="2">
										<xsl:value-of select="ID"/>
									</td>
									<td colspan="5">
										<xsl:value-of select="Name"/>
									</td>
								</tr>
								<tr>
									<td colspan="7">&nbsp;</td>
								</tr>
							</xsl:when>
						</xsl:choose>
						<xsl:for-each select="SpecOrderers/Orderer">
							<xsl:sort/>
							<tr>
								<td colspan="7" style="font-weight: bold;">
									Naronik: <xsl:value-of select="ID"/>&nbsp;
									<xsl:value-of select="Name"/>
								</td>
							</tr>
							<tr>
								<td colspan="7">
									<hr size="0"/>
								</td>
							</tr>
							<xsl:for-each select="SpecOrdererServices/Service">
								<xsl:sort/>
								<tr>
									<td colspan="2"/>
									<td>
										<xsl:value-of select="Service/ID"/>&nbsp;
										<xsl:value-of select="Service/Name"/>
									</td>
									<!-- ML, 27.3.2007,Akt_99966: SB Celje - RAF oblika fakture -->
									<td align="right">
										<xsl:call-template name="FormatNumber">
											<xsl:with-param name="Number" select="NumberOfCase/Number"/>
										</xsl:call-template>
									</td>
									<!-- ML, 27.3.2007,Akt_99966: SB Celje - RAF oblika fakture -->
									<td align="right">
										<xsl:call-template name="FormatNumber">
											<xsl:with-param name="Number" select="UnitValue/Value"/>
										</xsl:call-template>
									</td>
									<td align="right">
										<xsl:call-template name="FormatNumber">
											<xsl:with-param name="Number" select="CoeficientValue"/>
										</xsl:call-template>
									</td>
									<td align="right">
										<xsl:call-template name="FormatNumberWithNull">
											<xsl:with-param name="Number" select="ServicePriceProperty/ServicePrice"/>
										</xsl:call-template>
									</td>
								</tr>
							</xsl:for-each>
							<tr>
								<td colspan="7">
									<hr size="0"/>
								</td>
							</tr>
							<tr>
								<td colspan="6">Skupaj: <xsl:value-of select="ID"/>&nbsp;
									<xsl:value-of select="Name"/>
								</td>
								<td align="right">
									<xsl:call-template name="FormatNumberWithNull">
										<xsl:with-param name="Number" select="ServicePriceProperty/ServicePrice"/>
									</xsl:call-template>
								</td>
							</tr>
							<tr>
								<td colspan="7">&nbsp;</td>
							</tr>
						</xsl:for-each>
					</xsl:for-each>
				</xsl:for-each>
				<tr>
					<td colspan="7">&nbsp;</td>
				</tr>
				<tr>
					<td colspan="6" style="font-weight: bold;">Skupaj raun:</td>
					<td align="right" style="font-weight: bold;">
						<xsl:call-template name="FormatNumberWithNull">
							<xsl:with-param name="Number" select="../InvFooter/ServicePriceProperty/ServicePrice"/>
						</xsl:call-template>
					</td>
				</tr>
				<tr>
					<td colspan="7">&nbsp;</td>
				</tr>
				<tr>
					<td colspan="7">&nbsp;</td>
				</tr>
				<tr>
					<td colspan="7">&nbsp;</td>
				</tr>
				<tr>
					<td colspan="7" style="font-size: 14px">
						<b>Seznam storitev po pacientih</b>
					</td>
				</tr>
			</xsl:if>
			<!--end  rekapitulacija -->
			<!--ML,29.06.2007, Spremenjena oblika fakture za Celje -->
			<tr>
				<td colspan="7">
					<hr size="1" style="color: #000000;"/>
				</td>
			</tr>
			<tr>
				<td colspan="3">Priimek in ime  &nbsp;&nbsp;&nbsp;        Naronik  &nbsp;&nbsp;&nbsp; Storitve</td>
				<td align="right">koliina</td>
				<td align="right">t. tok</td>
				<!-- ML, 27.3.2007,Akt_99966: SB Celje - RAF oblika fakture -->
				<td align="right">cena</td>
				<td align="right">znesek</td>
			</tr>
			<tr>
				<td colspan="7">
					<hr size="1" style="color: #000000;"/>
				</td>
			</tr>
			<tr>
				<td colspan="7">&nbsp;</td>
			</tr>
			<xsl:for-each select="Activitys/Activity">
				<xsl:sort/>
				<!-- K 10.10.2006 - Akt_99019 - e je 0 pol ne prikae -->
				<xsl:choose>
					<xsl:when test="ID != '0'">
						<tr>
							<td colspan="2" style="font-size: 11px;">
								<b>
									<xsl:value-of select="ID"/>
								</b>
							</td>
							<td colspan="5" style="font-size: 11px;">
								<b>
									<xsl:value-of select="Name"/>
								</b>
							</td>
						</tr>
						<tr>
							<td colspan="7">&nbsp;</td>
						</tr>
					</xsl:when>
				</xsl:choose>
				<xsl:for-each select="Categorys/Category/UnderGroups/UnderGroup">
					<xsl:sort/>
					<!-- K 10.10.2006 - Akt_99019 - e je 0 pol ne prikae -->
					<xsl:choose>
						<xsl:when test="ID != '0'">
							<tr>
								<td colspan="2">
									<xsl:value-of select="ID"/>
								</td>
								<td colspan="5">
									<xsl:value-of select="Name"/>
								</td>
							</tr>
							<tr>
								<td colspan="7">&nbsp;</td>
							</tr>
						</xsl:when>
					</xsl:choose>
					<xsl:for-each select="SpecOrderers/Orderer">
						<xsl:sort/>
						<tr>
							<td colspan="7" style="font-weight: bold">
									Naronik: <xsl:value-of select="ID"/> &nbsp;<xsl:value-of select="Name"/>
							</td>
						</tr>
						<tr>
							<td colspan="7">
								<hr size="0"/>
							</td>
						</tr>
						<xsl:for-each select="SpecPatients/Patient">
							<xsl:sort select="Name"/>
							<tr>
								<td/>
								<td colspan="7">
									<b>
										<xsl:value-of select="ZZZS_ID"/> &nbsp;<xsl:value-of select="Name"/>
									</b>,
								<!-- ML, 27.3.2007,Akt_99966: SB Celje - RAF oblika fakture -->
									<xsl:call-template name="FormatDate">
										<xsl:with-param name="Date" select="BirthDate"/>
									</xsl:call-template>
									, <xsl:value-of select="Address/Street"/>,  <xsl:value-of select="Address/PostalOffice"/>
								</td>
							</tr>
							<xsl:for-each select="ServiceProperty/Services/Service">
								<xsl:sort/>
								<tr>
									<td colspan="2"/>
									<td>
										<xsl:value-of select="Service/ID"/>&nbsp;<xsl:value-of select="Service/Name"/>&nbsp;,
										<xsl:call-template name="FormatDate">
											<xsl:with-param name="Date" select="DateCompletion"/>
										</xsl:call-template>
									</td>
									<!-- ML, 27.3.2007,Akt_99966: SB Celje - RAF oblika fakture -->
									<td align="right">
										<xsl:call-template name="FormatNumber">
											<xsl:with-param name="Number" select="NumberOfCase/Number"/>
										</xsl:call-template>
									</td>
									<!-- ML, 27.3.2007,Akt_99966: SB Celje - RAF oblika fakture -->
									<td align="right">
										<xsl:call-template name="FormatNumber">
											<xsl:with-param name="Number" select="UnitValue/Value"/>
										</xsl:call-template>
									</td>
									<td align="right">
										<xsl:call-template name="FormatNumber">
											<xsl:with-param name="Number" select="CoeficientValue"/>
										</xsl:call-template>
									</td>
									<td align="right">
										<xsl:call-template name="FormatNumberWithNull">
											<xsl:with-param name="Number" select="ServicePriceProperty/ServicePrice"/>
										</xsl:call-template>
									</td>
								</tr>
							</xsl:for-each>
							<tr>
								<td colspan="7">
									<hr size="0"/>
								</td>
							</tr>
							<tr>
								<td/>
								<td colspan="3">[Skupaj: <xsl:value-of select="ZZZS_ID"/>&nbsp; <xsl:value-of select="Name"/>
								</td>
								<td align="right">
									<xsl:call-template name="FormatNumber">
										<xsl:with-param name="Number" select="UnitValue/Value"/>
									</xsl:call-template>
								</td>
								<td align="right"/>
								<td align="right">
									<xsl:call-template name="FormatNumberWithNull">
										<xsl:with-param name="Number" select="ServicePriceProperty/ServicePrice"/>
									</xsl:call-template>]						
									</td>
							</tr>
							<tr>
								<td colspan="7">&nbsp;</td>
							</tr>
						</xsl:for-each>
						<xsl:if test="not(contains(../../../../../../../../../InvProperty/BodyInformation,'ORDERER:SERVICES'))">
							<tr>
								<td colspan="7">
									<hr size="0"/>
								</td>
							</tr>
							<tr>
								<td colspan="4">[Skupaj naronik:<xsl:value-of select="ID"/>&nbsp; <xsl:value-of select="Name"/>
								</td>
								<td align="right">
									<xsl:call-template name="FormatNumber">
										<xsl:with-param name="Number" select="UnitValue/Value"/>
									</xsl:call-template>
								</td>
								<td align="right"/>
								<td align="right">
									<xsl:call-template name="FormatNumberWithNull">
										<xsl:with-param name="Number" select="ServicePriceProperty/ServicePrice"/>
									</xsl:call-template>]
								</td>
							</tr>
							<tr>
								<td colspan="7">&nbsp;</td>
							</tr>
						</xsl:if>
					</xsl:for-each>
				</xsl:for-each>
			</xsl:for-each>
			<tr>
				<td colspan="7">
					<hr size="0"/>
				</td>
			</tr>
			<tr>
				<td colspan="7">&nbsp;</td>
			</tr>
			<tr>
				<td colspan="6" style="font-weight: bold;">Skupaj raun:</td>
				<td align="right" style="font-weight: bold;">
					<xsl:call-template name="FormatNumberWithNull">
						<xsl:with-param name="Number" select="../InvFooter/ServicePriceProperty/ServicePrice"/>
					</xsl:call-template>
				</td>
			</tr>
		</table>
	</xsl:template>
	<!-- RAUN ZA PODJETJE IN SAMOPLANIKE -->
	<xsl:template match="InvBody" mode="SpecAccount">
		<xsl:param name="Type"/>
		<xsl:param name="TxtFile"/>
		<xsl:variable name="HomeCurrency" select="((../InvFooter/ServicePriceProperty/Currency = 'SIT') and (2007 > number(../InvHeader/Document/ServiceYear))) or ((../InvFooter/ServicePriceProperty/Currency = 'EUR') and (number(../InvHeader/Document/ServiceYear) > 2006))"/>
		<table width="650" border="0" cellspacing="0" cellpadding="0" style="font-size: 10px;">
			<tr>
				<td colspan="11">&nbsp;</td>
			</tr>
			<tr>
				<xsl:if test="not(../InvFooter/SubjectOfContract = '')">
					<td colspan="11">
						<!-- <b>Predmet pogodbe: </b> -->
						<b>
							<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BH1_1_1"/>&nbsp;
						</b>
						<xsl:value-of select="../InvFooter/SubjectOfContract"/>
					</td>
				</xsl:if>
			</tr>
			<tr>
				<td colspan="11">
					<hr size="0"/>
				</td>
			</tr>
			<tr>
				<td colspan="11">&nbsp;</td>
			</tr>
			<tr>
				<td colspan="2"/>
				<td>
					<!-- <b>ifra in naziv storitve</b>  -->
					<b>
						<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BH2_1_1"/>
					</b>
				</td>
				<td align="right">
					<!-- <b>koli</b> -->
					<b>
						<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BH2_2_1"/>
					</b>
				</td>
				<td align="right">
					<xsl:if test="not(../InvFooter/UnitValue = '0.00000') and not($Type='44')">
						<!-- <b>tok</b> -->
						<b>
							<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BH2_3_1"/>
						</b>
					</xsl:if>
				</td>
				<td align="right">
					<!-- <b>cena</b> -->
					<b>
						<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BH2_5_1"/>
					</b>
				</td>
				<td align="right">
					<xsl:if test="not($HomeCurrency)">
						<!-- <b>val</b> -->
						<b>
							<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BH2_6_1"/>
						</b>
					</xsl:if>
				</td>
				<td align="right">
					<!-- <b>vrednost storitve</b> -->
					<b>
						<xsl:choose>
							<xsl:when test="../InvProperty/Part_220='2'">
								<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BH2_7_3"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BH2_7_1"/>
							</xsl:otherwise>
						</xsl:choose>
					</b>
				</td>
				<td align="right">
					<!-- <b>znesek za plailo</b> -->
					<b>
						<xsl:choose>
							<xsl:when test="../InvProperty/Part_220='2'">
								<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BH2_8_3"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BH2_8_1"/>
							</xsl:otherwise>
						</xsl:choose>
					</b>
				</td>
				<td align="right">
					<xsl:if test="not(../InvFooter/Discount = '0.00000') and not(contains(../InvProperty/BodyInformation,'NIPOP'))">
						<!-- <b>pop</b> -->
						<b>
							<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BH2_4_1"/>
						</b>
					</xsl:if>
				</td>
				<td/>
			</tr>
			<tr>
				<td colspan="11">&nbsp;</td>
			</tr>
			<tr>
				<td colspan="11">
					<hr size="0"/>
				</td>
			</tr>
			<tr>
				<td colspan="11">&nbsp;</td>
			</tr>
			<xsl:for-each select="Activitys/Activity">
				<xsl:variable name="ActivityID" select="ID"/>
				<xsl:for-each select="Categorys/Category">
					<xsl:for-each select="UnderGroups/UnderGroup">
						<xsl:sort/>
						<xsl:choose>
							<xsl:when test="(($Type='P03') or (contains(../../../../../../../InvProperty/BodyInformation,'KONTO')))">
								<tr>
									<td colspan="2"/>
									<td colspan="9">
										<b>
											<xsl:value-of select="$ActivityID"/>
											<xsl:value-of select="ID"/>&nbsp;&nbsp;
											<xsl:value-of select="Name"/>
										</b>
									</td>
								</tr>
							</xsl:when>
						</xsl:choose>
						<xsl:for-each select="Services/Service">
							<xsl:sort/>
							<xsl:variable name="HomeServiceCurrency" select="((ServicePriceProperty/Currency = 'SIT') and (2007 > number(../../../../../../../../../InvHeader/Document/ServiceYear))) or ((ServicePriceProperty/Currency = 'EUR') and (number(../../../../../../../../../InvHeader/Document/ServiceYear) > 2006))"/>
							<tr>
								<td colspan="2"/>
								<td>
									<xsl:value-of select="Service/ID"/>&nbsp;&nbsp;
										<xsl:value-of select="Service/Name"/>
								</td>
								<td align="right">
									<xsl:call-template name="FormatNumber">
										<xsl:with-param name="Number" select="NumberOfCase/Number"/>
									</xsl:call-template>
								</td>
								<td align="right">
									<xsl:if test="not($Type='44')">
										<xsl:call-template name="FormatNumber">
											<xsl:with-param name="Number" select="UnitValue/Value"/>
										</xsl:call-template>
									</xsl:if>
								</td>
								<td align="right">
									<xsl:call-template name="FormatNumberWithNull">
										<xsl:with-param name="Number" select="CoeficientValue"/>
									</xsl:call-template>
								</td>
								<td align="right">
									<xsl:if test="not($HomeCurrency)">
										<xsl:value-of select="ServicePriceProperty/Currency"/>
									</xsl:if>
								</td>
								<td align="right">
									<xsl:choose>
										<xsl:when test="$HomeServiceCurrency">
											<xsl:choose>
												<xsl:when test="($Type='44')">
													<xsl:call-template name="FormatNumberWithNull">
														<xsl:with-param name="Number" select="ServicePriceProperty/AdditionalPrice"/>
													</xsl:call-template>
												</xsl:when>
												<xsl:otherwise>
													<xsl:call-template name="FormatNumberWithNull">
														<xsl:with-param name="Number" select="ServicePriceProperty/ServicePrice"/>
													</xsl:call-template>
												</xsl:otherwise>
											</xsl:choose>
										</xsl:when>
										<xsl:otherwise>
											<xsl:call-template name="FormatNumberWithNull">
												<xsl:with-param name="Number" select="ServicePriceProperty/ServicePriceInCurrency"/>
											</xsl:call-template>
										</xsl:otherwise>
									</xsl:choose>
								</td>
								<td align="right">
									<xsl:call-template name="FormatNumberWithNull">
										<xsl:with-param name="Number" select="ServicePriceProperty/AdditionalPrice"/>
									</xsl:call-template>
								</td>
								<td align="right">
									<xsl:if test="not(../../../../../../../../../InvFooter/Discount = '0.00000') and not(contains(../../../../../../../../../InvProperty/BodyInformation,'NIPOP'))">
										<xsl:value-of select="format-number(Discount, '##,##', 'european')"/>
										<xsl:if test="not(Discount='0.00000')">%</xsl:if>
									</xsl:if>
								</td>
								<td align="right">
									<xsl:if test="not(ServicePriceProperty/DDVLevel= '99.00000')">
										&nbsp;&nbsp;
										<xsl:choose>
											<xsl:when test="ServicePriceProperty/DDVPercent">
												<xsl:value-of select="format-number(ServicePriceProperty/DDVPercent, '#0,#', 'european')"/>%
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="format-number(ServicePriceProperty/DDVLevel, '#0,#', 'european')"/>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:if>
								</td>
							</tr>
						</xsl:for-each>
						<xsl:choose>
							<xsl:when test="$Type='P03'">
								<tr>
									<td colspan="11">&nbsp;</td>
								</tr>
							</xsl:when>
						</xsl:choose>
					</xsl:for-each>
				</xsl:for-each>
			</xsl:for-each>
			<tr>
				<td colspan="11">&nbsp;</td>
			</tr>
			<tr>
				<td colspan="11">
					<hr size="0"/>
				</td>
			</tr>
			<tr>
				<td colspan="4">
					<b>
						<!-- SKUPAJ: -->
						<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BF1_1_1"/>
					</b>
				</td>
				<td align="right">
					<xsl:if test="($Type!='P03') and ($Type!='44')">
						<xsl:call-template name="FormatNumber">
							<xsl:with-param name="Number" select="../InvFooter/UnitValue"/>
						</xsl:call-template>
					</xsl:if>
				</td>
				<td colspan="3"/>
				<td align="right">
					<xsl:choose>
						<xsl:when test="not(../InvFooter/ServicePriceProperty/Currency = 'SIT')">
							<xsl:call-template name="FormatNumberWithNull">
								<xsl:with-param name="Number" select="(../InvFooter/ServicePriceProperty/ServicePriceInCurrency)"/>
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="FormatNumberWithNull">
								<xsl:with-param name="Number" select="(../InvFooter/ServicePriceProperty/ServicePrice)"/>
							</xsl:call-template>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td align="left">
					&nbsp;<xsl:value-of select="../InvFooter/ServicePriceProperty/Currency"/>
				</td>
				<td/>
			</tr>
			<tr>
				<td colspan="11">&nbsp;</td>
			</tr>
			<xsl:if test="not(../InvFooter/Discount = '0.00000')">
				<tr>
					<td colspan="8">
						<b>
							<!-- Popust v znesku: -->
							<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BF2_1_1"/>
						</b>
					</td>
					<td align="right">
						<xsl:call-template name="FormatNumberWithNull">
							<xsl:with-param name="Number" select="../InvFooter/Discount"/>
						</xsl:call-template>
					</td>
					<td align="left">&nbsp;-</td>
					<td/>
				</tr>
			</xsl:if>
			<xsl:if test="not(../InvFooter/DiscountWithContract = '0.00000')">
				<tr>
					<td colspan="6">
						<b>
							<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BF2_2_1"/>
						</b>
					</td>
					<td colspan="2">
						<xsl:call-template name="FormatNumber">
							<xsl:with-param name="Number" select="../InvFooter/DiscountWithContractInPercent"/>
						</xsl:call-template>&nbsp;%			
					</td>
					<td align="right">
						<xsl:call-template name="FormatNumberWithNull">
							<xsl:with-param name="Number" select="../InvFooter/DiscountWithContract"/>
						</xsl:call-template>
					</td>
					<td align="left">&nbsp;-</td>
					<td/>
				</tr>
			</xsl:if>
			<tr>
				<td colspan="11">&nbsp;</td>
			</tr>
			<!-- davek-->
			<xsl:choose>
				<xsl:when test="../InvFooter/ServicePriceProperty/TaxList">
					<xsl:for-each select="../InvFooter/ServicePriceProperty/TaxList/Tax">
						<tr>
							<td colspan="5">
								<xsl:call-template name="TaxText">
									<xsl:with-param name="TxtFile" select="$TxtFile"/>
									<xsl:with-param name="Level" select="DDVLevel"/>
									<xsl:with-param name="Percent" select="DDVPercent"/>
									<xsl:with-param name="Currency" select="../../Currency"/>
								</xsl:call-template>
							</td>
							<td align="right">
								<xsl:call-template name="FormatNumberWithNull">
									<xsl:with-param name="Number" select="DDVBase"/>
								</xsl:call-template>
							</td>
							<td colspan="2"/>
							<td align="right">
								<xsl:call-template name="FormatNumberWithNull">
									<xsl:with-param name="Number" select="DDVAmount"/>
								</xsl:call-template>
							</td>
							<td colspan="2"/>
						</tr>
					</xsl:for-each>
					<td colspan="8">&nbsp;</td>
					<td>
						<hr size="0"/>
					</td>
					<td colspan="2"/>
				</xsl:when>
				<xsl:otherwise>
					<tr>
						<xsl:if test="not(../InvFooter/ServicePriceProperty/Level01/DDVBase = '0.00000')">
							<td colspan="5">
								<!-- - ZNIANA STOPNJA 8.50% V SIT -->
								<xsl:choose>
									<xsl:when test="../InvFooter/ServicePriceProperty/Level01/DDVPercent">
										<xsl:value-of select="format-number(../InvFooter/ServicePriceProperty/Level01/DDVPercent, '#0,#', 'european')"/>%
							</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="format-number(../InvFooter/ServicePriceProperty/Level01/DDVLevel, '#0,#', 'european')"/>
									</xsl:otherwise>
								</xsl:choose>						
						&nbsp;-&nbsp;
						<xsl:choose>
									<xsl:when test="(../InvFooter/ServicePriceProperty/Currency = 'EUR')">
										<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BF3_2_1"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BF3_1_1"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
							<td align="right">
								<xsl:call-template name="FormatNumberWithNull">
									<xsl:with-param name="Number" select="../InvFooter/ServicePriceProperty/Level01/DDVBase"/>
								</xsl:call-template>
							</td>
							<td colspan="2"/>
							<td align="right">
								<xsl:call-template name="FormatNumberWithNull">
									<xsl:with-param name="Number" select="../InvFooter/ServicePriceProperty/Level01/DDVAmount"/>
								</xsl:call-template>
							</td>
							<td colspan="2"/>
						</xsl:if>
					</tr>
					<xsl:if test="not($HomeCurrency)">
						<tr>
							<xsl:if test="not(../InvFooter/ServicePriceProperty/LevelC01/DDVBase = '0.00000')">
								<td colspan="5">
									<!--  - ZNIANA STOPNJA 8.50% V VALUTI -->
									<xsl:choose>
										<xsl:when test="../InvFooter/ServicePriceProperty/LevelC01/DDVPercent">
											<xsl:value-of select="format-number(../InvFooter/ServicePriceProperty/LevelC01/DDVPercent, '#0,#', 'european')"/>%
								</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="format-number(../InvFooter/ServicePriceProperty/LevelC01/DDVLevel, '#0,#', 'european')"/>
										</xsl:otherwise>
									</xsl:choose>							
							&nbsp;-&nbsp;
							<xsl:choose>
										<xsl:when test="(../InvFooter/ServicePriceProperty/Currency = 'EUR')">
											<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BF3_1_1"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BF3_2_1"/>
										</xsl:otherwise>
									</xsl:choose>
								</td>
								<td align="right">
									<xsl:call-template name="FormatNumberWithNull">
										<xsl:with-param name="Number" select="../InvFooter/ServicePriceProperty/LevelC01/DDVBase"/>
									</xsl:call-template>
								</td>
								<td colspan="2"/>
								<td align="right">
									<xsl:call-template name="FormatNumberWithNull">
										<xsl:with-param name="Number" select="../InvFooter/ServicePriceProperty/LevelC01/DDVAmount"/>
									</xsl:call-template>
								</td>
								<td colspan="2"/>
							</xsl:if>
						</tr>
					</xsl:if>
					<tr>
						<xsl:if test="not(../InvFooter/ServicePriceProperty/Level02/DDVBase = '0.00000')">
							<td colspan="5">
								<!-- - SPLONA STOPNJA 20.00% V SIT -->
								<xsl:choose>
									<xsl:when test="../InvFooter/ServicePriceProperty/Level02/DDVPercent">
										<xsl:value-of select="format-number(../InvFooter/ServicePriceProperty/Level02/DDVPercent, '#0,#', 'european')"/>%
							</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="format-number(../InvFooter/ServicePriceProperty/Level02/DDVLevel, '#0,#', 'european')"/>
									</xsl:otherwise>
								</xsl:choose>						
						&nbsp;-&nbsp;	
						<xsl:choose>
									<xsl:when test="(../InvFooter/ServicePriceProperty/Currency = 'EUR')">
										<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BF4_2_1"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BF4_1_1"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
							<td align="right">
								<xsl:call-template name="FormatNumberWithNull">
									<xsl:with-param name="Number" select="../InvFooter/ServicePriceProperty/Level02/DDVBase"/>
								</xsl:call-template>
							</td>
							<td colspan="2"/>
							<td align="right">
								<xsl:call-template name="FormatNumberWithNull">
									<xsl:with-param name="Number" select="../InvFooter/ServicePriceProperty/Level02/DDVAmount"/>
								</xsl:call-template>
							</td>
							<td colspan="2"/>
						</xsl:if>
					</tr>
					<xsl:if test="not($HomeCurrency)">
						<tr>
							<xsl:if test="not(../InvFooter/ServicePriceProperty/LevelC02/DDVBase = '0.00000')">
								<td colspan="5">
									<!-- - SPLONA STOPNJA 20.00% V VALUTI -->
									<xsl:choose>
										<xsl:when test="../InvFooter/ServicePriceProperty/LevelC02/DDVPercent">
											<xsl:value-of select="format-number(../InvFooter/ServicePriceProperty/LevelC02/DDVPercent, '#0,#', 'european')"/>%
								</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="format-number(../InvFooter/ServicePriceProperty/LevelC02/DDVLevel, '#0,#', 'european')"/>
										</xsl:otherwise>
									</xsl:choose>							
							&nbsp;-&nbsp;
							<xsl:choose>
										<xsl:when test="(../InvFooter/ServicePriceProperty/Currency = 'EUR')">
											<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BF4_1_1"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BF4_2_1"/>
										</xsl:otherwise>
									</xsl:choose>
								</td>
								<td align="right">
									<xsl:call-template name="FormatNumberWithNull">
										<xsl:with-param name="Number" select="../InvFooter/ServicePriceProperty/LevelC02/DDVBase"/>
									</xsl:call-template>
								</td>
								<td colspan="2"/>
								<td align="right">
									<xsl:call-template name="FormatNumberWithNull">
										<xsl:with-param name="Number" select="../InvFooter/ServicePriceProperty/LevelC02/DDVAmount"/>
									</xsl:call-template>
								</td>
								<td colspan="2"/>
							</xsl:if>
						</tr>
					</xsl:if>
					<tr>
						<xsl:if test="(not(../InvFooter/ServicePriceProperty/Level01/DDVBase = '0.00000') or not(../InvFooter/ServicePriceProperty/Level02/DDVBase = '0.00000'))">
							<td colspan="8">&nbsp;</td>
							<td>
								<hr size="0"/>
							</td>
							<td colspan="2"/>
						</xsl:if>
					</tr>
				</xsl:otherwise>
			</xsl:choose>
			<!-- davek-->
			<xsl:if test="not($HomeCurrency)">
				<tr>
					<td colspan="8">
						<b>
							<!-- ZA PLAILO V VALUTI -->
							<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BF5_1_1"/>
						</b>
					</td>
					<td align="right">
						<xsl:call-template name="FormatNumberWithNull">
							<xsl:with-param name="Number" select="(../InvFooter/PayPriceC)"/>
						</xsl:call-template>
					</td>
					<td colspan="2"/>
				</tr>
				<tr>
					<td colspan="11">&nbsp;</td>
				</tr>
			</xsl:if>
			<!--ML,24.09.2007, Nap_8560: znesek s popustom-->
			<!--<xsl:if test="(../InvProperty/Language = 'SLO')">-->
			<tr>
				<td colspan="8">
					<b>
						<xsl:choose>
							<xsl:when test="(2007 > number(../InvHeader/Document/ServiceYear))">
								<xsl:choose>
									<xsl:when test="contains(../InvFooter/PayPrice,'-')">
										<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BF6_1_2"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BF6_1_1"/>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
									<xsl:when test="contains(../InvFooter/PayPrice,'-')">
										<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BF5_2_2"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BF5_2_1"/>
									</xsl:otherwise>
								</xsl:choose>
								<xsl:value-of select="../InvFooter/ServicePriceProperty/Currency"/>
							</xsl:otherwise>
						</xsl:choose>
					</b>
				</td>
				<td align="right">
					<xsl:call-template name="FormatNumberWithNull">
						<xsl:with-param name="Number" select="(../InvFooter/PayPrice)"/>
					</xsl:call-template>
				</td>
				<td colspan="2"/>
			</tr>
			<!--</xsl:if>-->
			<!-- 15.02.2006 Akt_95028 -->
			<xsl:if test="(not(../InvFooter/PayPriceInEUR= '0.00000')) ">
				<tr>
					<td colspan="11">&nbsp;</td>
				</tr>
				<tr>
					<td colspan="8">
						<b>
							<xsl:choose>
								<xsl:when test="(2007 > number(../InvHeader/Document/ServiceYear))">
									<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BF6_1_3"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="document($TxtFile)/InvoiceTXT/SpecTXT/SpecAccountBody/BF6_1_4"/>
								</xsl:otherwise>
							</xsl:choose>
						</b>
					</td>
					<td align="right">
						<xsl:call-template name="FormatNumberWithNull">
							<xsl:with-param name="Number" select="(../InvFooter/PayPriceInEUR)"/>
						</xsl:call-template>
					</td>
					<td colspan="2"/>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>
</xsl:stylesheet>
